/**@file
 *
 *@brief	QRL Maker
 *@date		Sat,19 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Fri,28 Apr,2023
 *
 *@author	Copyright(C)2019-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <cstdint>
#include <math.h>
#include "form_mainform.h"
#include "mytypes.h"
#include <QTimer>

void Form_MainForm::timerEvent(QTimerEvent* const tEvent) noexcept
{
	if (this->dragscroll.flag) {
		if (tEvent->timerId() == this->dragscroll.id) {

			const QRL::ChipAddrXY chip_ptr = {
				.x = -1,
				.y = -1,
			};

			if (0 != this->dragscroll.x) {
				mainwindow->set_horizontalScrollBar(mainwindow->get_horizontalScrollBar() + this->dragscroll.x);
			}
			if (0 != this->dragscroll.y) {
				mainwindow->set_verticalScrollBar(mainwindow->get_verticalScrollBar() + this->dragscroll.y);
			}

			if (this->dragscroll.with_ctrl) {
				buildImage(MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL, chip_ptr, this->dragscroll.mouse_ptr, NULL);
			} else {
				buildImage(MapEditor_Type::MOUSE_LEFT_DRAG, chip_ptr, this->dragscroll.mouse_ptr, NULL);
			}

		}
	}
	return;
}
// [ End of File ]
