#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,06 Sep,2020
--@date   Mon,21 Sep,2020
--@date   Sun,01 Nov,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : IF eq StatusEffect of the Friend in the Array
-- size : 5 , 2
-- footprint :
-- #####
-- #####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0020023
-- argument : 1
-- argument_comment[1] : Status Effect
-- argument[1] : Haywire
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] :  Poison , Burn , Regen , Stone , Haywire , Inhuman Visage , Twitchy Hands , Depression , Rejection , Body Aches , Anemia , Irrational Anger , Neural Lag , Major Neural Failure , Cerebrospinal Shock , Toxic Leakage , Shutdown , Rust , Stun , Sickness , Half-Blinded , Spinal Injury , Torn Ligaments , Crushed Bones , Heart Injury
-- argument_geometry[1] : x:104 , y:66 , w:265 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:IF_eq_StatusEffect_of_the_Friend_in_the_Array');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  switch = {
    default                  = function() return  0; end;
    ['Poison']               = function() return  1; end;
    ['Burn']                 = function() return  2; end;
    ['Regen']                = function() return  3; end;
    ['Stone']                = function() return  4; end;
    ['Haywire']              = function() return  5; end;
    ['Inhuman Visage']       = function() return  6; end;
    ['Twitchy Hands']        = function() return  7; end;
    ['Depression']           = function() return  8; end;
    ['Rejection']            = function() return  9; end;
    ['Body Aches']           = function() return 10; end;
    ['Anemia']               = function() return 11; end;
    ['Irrational Anger']     = function() return 12; end;
    ['Neural Lag']           = function() return 13; end;
    ['Major Neural Failure'] = function() return 14; end;
    ['Cerebrospinal Shock']  = function() return 15; end;
    ['Toxic Leakage']        = function() return 16; end;
    ['Shutdown']             = function() return 17; end;
    ['Rust']                 = function() return 18; end;
    ['Stun']                 = function() return 19; end;
    ['Sickness']             = function() return 20; end;
    ['Half-Blinded']         = function() return 21; end;
    ['Spinal Injury']        = function() return 22; end;
    ['Torn Ligaments']       = function() return 23; end;
    ['Crushed Bones']        = function() return 24; end;
    ['Heart Injury']         = function() return 25; end;
  };
  local ret = (switch["##111##"] or switch.default)();
  if (0 ~= Mek_NAttValue(g_QRL_SystemVariable["FriendMekList"][g_QRL_SystemVariable["FriendMekListPtr"]], NAG_StatusEffect, ret)) then
    return '##021##';
  end;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
