#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,18 Mar,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Get Next Enemy
-- size : 2 , 1
-- footprint :
-- ##
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010013
-- argument : 0
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Get_Next_Enemy');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  g_QRL_SystemVariable["EnemyMekListPtr"] = g_QRL_SystemVariable["EnemyMekListPtr"] + 1;

  while (g_QRL_SystemVariable["EnemyMekListPtr"] <= g_QRL_SystemVariable["EnemyMekListMax"]) do
    local TL = g_QRL_SystemVariable["EnemyMekList"][g_QRL_SystemVariable["EnemyMekListMax"]];
    if (NotDestroyed(TL) and GearActive(TL) and MekCanSeeTarget(GB, Mek, TL) and OnTheMap_Mek(TL)) then
      return '##021##';
    end;
    g_QRL_SystemVariable["EnemyMekListPtr"] = g_QRL_SystemVariable["EnemyMekListPtr"] + 1;
  end;

  g_QRL_SystemVariable["EnemyMekListPtr"] = 1;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
