#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Wed,03 Jan,2018
--@date   Sat,23 Jun,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Sat,18 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sat,19 Sep,2020
--@date   Wed,21 Oct,2020
--@date   Sun,25 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Reload Ammo for a Weapon
-- size : 4 , 2
-- footprint :
-- ####
-- ####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- argument : 2
-- argument_comment[1] : Weapon
-- argument[1] : wep
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:131 , y:16 , w:123 , h:31
-- argument_comment[2] : Ammo
-- argument[2] : ammo
-- argument_tag[2] : ##121##
-- argument_type[2] : var
-- argument_geometry[2] : x:10 , y:102 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Reload_Ammo_for_a_Weapon');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  local ret = true;
  if (c_Variable_Type_Weapon ~= g_QRL_UserVariable_Type["##111##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Reload_Ammo_for_a_Weapon:No weapon is selected.');
    ret = false;
  end;
  if (c_Variable_Type_Ammo ~= g_QRL_UserVariable_Type["##121##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Reload_Ammo_for_a_Weapon:No Ammo is selected.');
    ret = false;
  end;
  if not(ret) then
    return '##021##';
  end;

  g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] = g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] + 1;
  g_QRL_SystemVariable["ExecQueue_Reload_Queue_Weapon"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = g_QRL_UserVariable_Contents["##111##"];
  g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ammo"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = g_QRL_UserVariable_Contents["##121##"];
  return '##021##';
end;

-- ##end##
-- [ End of File ]
