-- ArenaScript Value Macros

-- GameData/asvmacro.txt
define_const("NAV_XRMResolved", 0);
define_const("NAV_XRMUnknown", 1);
define_const("NAV_XRMFamilySecret", 2);
define_const("NAV_XRMAmnesia", 3);
define_const("NAV_XRMNotHuman", 4);
define_const("NAV_XRMItem", 5);
define_const("NAV_XREUnknown", 0);
define_const("NAV_XRECharacter", 1);
define_const("NAV_XREFaction", 2);
define_const("NAV_XRBResolved", 0);
define_const("NAV_XRBUnknown", 1);
define_const("NAV_XRBFamilyDied", 2);
define_const("NAV_XRBIncriminated", 3);
define_const("NAV_XRBSeekingRevenge", 4);
define_const("NAV_XRBExMember", 5);
define_const("NAV_XRBLostLove", 6);

define_const("NAS_Poison", 1);
define_const("NAS_Stoned", 4);
define_const("NAS_Sickness", 20);


-- aibrain.pp
define_const("ORD_SeekEnemy", 0);
define_const("ORD_SeekSingleModel", 1);
define_const("ORD_SeekSpot", 2);
define_const("ORD_SeekEdge", 3);
define_const("ORD_SeekTeam", 4);
define_const("ORD_SeekNearestEdge", 5);

define_const("CORD_Flirt", 1);
define_const("CORD_Chat", 2);


-- arenascript.pp
define_const("NAG_ScriptVar", 0);


-- gears.pp
define_const("GG_DisposeGear", -32767);
define_const("NAG_DisposeNA", -32767);
define_const("NAS_DisposeNA", -32767);

define_const("GG_Story", -10);
define_const("GG_Plot", -9);
define_const("GG_MapFeature", -8);
define_const("GG_Adventure", -7);
define_const("GG_Faction", -6);
define_const("GG_Persona", -5);
define_const("GG_Team", -4);
define_const("GG_Scene", -3);
define_const("GG_Unit", -2);
define_const("GG_AbsolutelyNothing", -1);

define_const("GG_Mecha", 0);
define_const("GG_Module", 1);
define_const("GG_Character", 2);
define_const("GG_Cockpit", 3);
define_const("GG_Weapon", 4);
define_const("GG_Ammo", 5);
define_const("GG_MoveSys", 6);
define_const("GG_Holder", 7);
define_const("GG_Sensor", 8);
define_const("GG_Support", 9);
define_const("GG_Shield", 10);
define_const("GG_ExArmor", 11);
define_const("GG_Swag", 12);
define_const("GG_Prop", 13);
define_const("GG_Electronics", 14);
define_const("GG_MetaTerrain", 15);
define_const("GG_Usable", 16);
define_const("GG_RepairFuel", 17);
define_const("GG_Consumable", 18);
define_const("GG_Modifier", 19);
define_const("GG_WeaponAddOn", 20);

define_const("NAG_GearOps", 2);

define_const("NumMaterial", 2);
define_const("NAS_Material", 0);
define_const("NAV_Metal", 0);
define_const("NAV_Meat", 1);
define_const("NAV_BioTech", 2);

define_const("NAS_MassAdjust", 1);

define_const("NAS_DominationTarget", 2);
define_const("NAS_EvolveAt", 3);
define_const("NAS_Fudge", 4);

define_const("NAG_Narrative", 7);
define_const("NAS_NID", 0);

define_const("NAS_LockedDoorChance", 101);
define_const("NAS_SecretDoorChance", 102);

define_const("NAS_MaxCID", 3);
define_const("NAS_MaxNID", 4);

define_const("NAS_XRMystery", 10);
define_const("NAS_XREnemy", 11);
define_const("NAS_XRBadThing", 12);

define_const("NAS_VictimsRecovered", 201);

define_const("MassPerMV", 15);

define_const("NAG_Display", 13);
define_const("NAS_PrimaryFrame", 0);

define_const("NAG_Prefrences", 15);
define_const("NAS_DefAtOp", 0);


-- ghchars.pp
define_const("STAT_Reflexes", 1);
define_const("STAT_Body", 2);
define_const("STAT_Speed", 3);
define_const("STAT_Perception", 4);
define_const("STAT_Craft", 5);
define_const("STAT_Ego", 6);
define_const("STAT_Knowledge", 7);
define_const("STAT_Charm", 8);

define_const("NAG_StatImprovementLevel", 11);

define_const("MS_Maneuver", 1);
define_const("MS_Targeting", 2);
define_const("MS_Sensor", 3);

define_const("NAG_Skill", 1);

define_const("NAS_FreeSkillPoints", -1);
define_const("NAS_FreeStatPoints", -2);

define_const("NAG_CharDescription", 3);

define_const("NAS_Gender", 0);
define_const("NAV_Male", 0);
define_const("NAV_Female", 1);

define_const("NAS_DAge", 1);

define_const("NAS_CharType", 2);
define_const("NAV_CTPrimary", 0);
define_const("NAV_CTLancemate", 1);

define_const("Num_Personality_Traits", 7);
define_const("NAS_Heroic", -1);
define_const("NAS_Lawful", -2);
define_const("NAS_Sociable", -3);
define_const("NAS_Easygoing", -4);
define_const("NAS_Cheerful", -5);
define_const("NAS_Renowned", -6);
define_const("NAS_Pragmatic", -7);

define_const("NAG_Experience", 4);

define_const("NAS_TotalXP", 0);
define_const("NAS_SpentXP", 1);
define_const("NAS_Credits", 2);
define_const("NAS_FacXP", 3);
define_const("NAS_FacLevel", 4);
define_const("NAS_Skill_XP_Base", 100);

define_const("NAG_Condition", 9);
define_const("NAS_StaminaDown", 0);
define_const("NAS_MentalDown", 1);
define_const("NAS_Hunger", 2);
define_const("NAS_MoraleDamage", 3);
define_const("NAS_Overload", 4);
define_const("NAS_CyberTrauma", 5);

define_const("MORALE_HPRegen", 5);
define_const("MORALE_RepSmall", 10);
define_const("MORALE_RepBig", 30);

define_const("FOOD_MORALE_FACTOR", 15);

define_const("Hunger_Penalty_Starts", 70);

define_const("NumSkill", 41);

define_const("USAGE_Repair", 1);
define_const("USAGE_Clue", 2);
define_const("USAGE_Performance", 3);
define_const("USAGE_Robotics", 4);
define_const("USAGE_DominateAnimal", 5);
define_const("USAGE_PickPockets", 6);

define_const("NAS_WeightLifting", 33);
define_const("NAS_Performance", 35);
define_const("NAS_Resistance", 36);
define_const("NAS_Investigation", 37);
define_const("NAS_Leadership", 39);
define_const("NAS_PickPockets", 41);

define_const("NAG_Talent", 16);
define_const("NumTalent", 28);

define_const("NAS_StrengthOfFaith", 1);
define_const("NAS_BodyBuilder", 2);
define_const("NAS_ScientificMethod", 3);
define_const("NAS_Presence", 4);
define_const("NAS_KungFu", 5);
define_const("NAS_HapKiDo", 6);
define_const("NAS_Anatomist", 7);
define_const("NAS_HardAsNails", 8);
define_const("NAS_StuntDriving", 9);
define_const("NAS_Savant", 10);
define_const("NAS_Bishounen", 11);
define_const("NAS_Diplomatic", 12);
define_const("NAS_BornToFly", 13);
define_const("NAS_SureFooted", 14);
define_const("NAS_RoadHog", 15);
define_const("NAS_Scavenger", 16);
define_const("NAS_Idealist", 17);
define_const("NAS_BusinessSense", 18);
define_const("NAS_AnimalTrainer", 19);
define_const("NAS_JackOfAll", 20);
define_const("NAS_CombatMedic", 21);
define_const("NAS_Rage", 22);
define_const("NAS_Ninjitsu", 23);
define_const("NAS_HullDown", 24);
define_const("NAS_GateCrasher", 25);
define_const("NAS_Extropian", 26);
define_const("NAS_CyberPsycho", 27);
define_const("NAS_Sniper", 28);


-- ghmodule.pp
define_const("NumForm", 9);
define_const("GS_Battroid", 0);
define_const("GS_Zoanoid", 1);
define_const("GS_GroundHugger", 2);
define_const("GS_Arachnoid", 3);
define_const("GS_AeroFighter", 4);
define_const("GS_Ornithoid", 5);
define_const("GS_Gerwalk", 6);
define_const("GS_HoverFighter", 7);
define_const("GS_GroundCar", 8);


-- ghmodule.pp
define_const("NumModule", 9);
define_const("GS_Body", 1);
define_const("GS_Head", 2);
define_const("GS_Arm", 3);
define_const("GS_Leg", 4);
define_const("GS_Wing", 5);
define_const("GS_Tail", 6);
define_const("GS_Turret", 7);
define_const("GS_Storage", 8);
define_const("GS_Conversion", 9);

define_const("STAT_Armor", 1);

define_const("SATT_TRANSFORMABLE", "TRANSFORMABLE");
define_const("SATT_TRANSFORM_CURRENT", "TRANSFORM_CURRENT");
define_const("SATT_TRANSFORM_GS", "TRANSFORM_GS_");
define_const("SATT_TRANSFORM_WAIT", "TRANSFORM_WAIT_");

define_const("SATT_SEPARABLE", "SEPARABLE");
define_const("SATT_SEPARATE_WAIT", "SEPARATE_WAIT_");
define_const("SATT_SEPARATE", "SEPARATE_");


-- ghprop.pp
define_const("GS_MetaDoor", 1);
define_const("GS_MetaCloud", 2);
define_const("GS_MetaCity", 3);
define_const("GS_MetaTown", 4);
define_const("GS_MetaVillage", 5);
define_const("GS_MetaStairsUp", 6);
define_const("GS_MetaStairsDown", 7);
define_const("GS_MetaCave", 8);
define_const("GS_MetaTemple", 9);
define_const("GS_MetaElevator", 10);
define_const("GS_MetaTrapDoor", 11);
define_const("GS_MetaRubble", 12);
define_const("GS_MetaSign", 13);
define_const("GS_MetaFire", 14);
define_const("STAT_Altitude", 1);
define_const("STAT_Obscurement", 2);
define_const("STAT_Pass", 3);
define_const("STAT_Destination", 4);
define_const("STAT_MetaVisibility", 5);
define_const("STAT_Lock", 6);
define_const("STAT_CloudDuration", 7);


-- ghweapon.pp
define_const("GS_Melee", 0);
define_const("GS_EMelee", 1);
define_const("GS_Ballistic", 2);
define_const("GS_BeamGun", 3);
define_const("GS_Missile", 4);
define_const("GS_Grenade", 5);

define_const("STAT_Range", 1);
define_const("STAT_Accuracy", 2);
define_const("STAT_Recharge", 3);
define_const("STAT_BurstValue", 4);

define_const("STAT_GrenadeSkill", 5);

define_const("STAT_Magazine", 8);

define_const("STAT_AmmoPresent", 7);

define_const("NAG_WeaponModifier", -3);
define_const("NAS_AmmoSpent", 0);
define_const("NAS_Recharge", 1);
define_const("NAS_SafetySwitch", 2);

define_const("ARC_F90", 0);
define_const("ARC_F180", 1);
define_const("ARC_360", 2);

define_const("AA_SwarmAttack", 1);
define_const("AA_BlastAttack", 2);
define_const("AA_LineAttack", 3);
define_const("AA_Scatter", 4);
define_const("AA_Extended", 5);
define_const("AA_Hyper", 6);
define_const("AA_ArmorPiercing", 7);
define_const("AA_Mystery", 8);
define_const("AA_Thrown", 9);
define_const("AA_RETURNING", 10);
define_const("AA_ArmorIgnore", 11);
define_const("AA_Intercept", 12);
define_const("AA_Overload", 13);
define_const("AA_Brutal", 14);
define_const("AA_Flail", 15);
define_const("AA_AntiAir", 16);
define_const("AA_Smoke", 17);
define_const("AA_Gas", 18);
define_const("AA_Drone", 19);
define_const("AA_NoMetal", 20);
define_const("AA_Strain", 21);
define_const("AA_Complex", 22);

define_const("NAG_StatusEffect", 14);
define_const("Num_Status_FX", 25);

define_const("NAS_Haywireg", 5);
define_const("NAS_Stonedg", 4);
define_const("NAS_Rejectiong", 9);
define_const("NAS_Depressiong", 8);
define_const("NAS_Angerg", 12);
define_const("NAS_Anemiag", 11);
define_const("NAS_Rustg", 18);

define_const("GS_General_AO", 0);
define_const("GS_Gun_AO", 1);
define_const("GS_Heavy_AO", 2);
define_const("GS_Melee_AO", 3);


-- interact.pp
define_const("NAG_Personal", 5);

define_const("NAS_CID", 0);
define_const("NAS_FactionID", 2);

define_const("NAS_OptMax", 6);
define_const("NAS_OptMin", 7);

define_const("NAG_ReactionScore", 6);

define_const("NAG_Relationship", 10);
define_const("NAV_ArchEnemy", -1);
define_const("NAV_ArchAlly", 1);
define_const("NAV_Family", 2);
define_const("NAV_Lover", 3);


-- locale.pp
define_const("NAG_ParaLocation", -6);

define_const("NAG_Location", -1);
define_const("NAS_X", 0);
define_const("NAS_Y", 1);
define_const("NAS_D", 2);
define_const("NAS_Team", 4);
define_const("NAS_LastMenuItem", 5);
define_const("NAS_GX", 6);
define_const("NAS_GY", 7);
define_const("NAS_SmartAction", 8);
define_const("NAS_SmartWeapon", 9);
define_const("NAS_SmartCount", 10);
define_const("NAS_SmartX", 11);
define_const("NAS_SmartY", 12);
define_const("NAS_SmartTarget", 13);

define_const("NAV_DefPlayerTeam", 1);
define_const("NAV_LancemateTeam", -3);
define_const("NAV_DefEnemyTeam", 2);

define_const("NAG_SideReaction", -1);

define_const("NAG_EpisodeData", -4);

define_const("NAS_UID", 0);
define_const("NAS_Target", 1);
define_const("NAS_ATarget", 3);

define_const("NAS_PrevDamage", 4);
define_const("NAS_InitRecharge", 6);

define_const("NAS_Orders", 2);

define_const("NumAITypes", 5);
define_const("NAV_SeekAndDestroy", 0);
define_const("NAV_GotoSpot", 1);
define_const("NAV_SeekEdge", 2);
define_const("NAV_Passive", 3);
define_const("NAV_RunAway", 4);
define_const("NAV_Follow", 5);

define_const("NAS_ContinuousOrders", 7);
define_const("NAS_ChatterRecharge", 8);

define_const("NAS_Ransacked", 11);
define_const("NAS_Gutted", 9);
define_const("NAS_Flayed", 10);

define_const("NAG_SceneData", 17);
define_const("NAS_TacticsTurnStart", 1);

define_const("SA_MapEdgeObstacle", "NOEXIT");

define_const("XMax", 50);
define_const("YMax", 50);

define_const("AngDir_X", { 1,  1,  0, -1, -1, -1,  0,  1 });
define_const("AngDir_Y", { 0,  1,  1,  1,  0, -1, -1, -1 });


-- movement.pp
define_const("NumMoveMode", 4);
define_const("MM_Walk", 1);
define_const("MM_Roll", 2);
define_const("MM_Skim", 3);
define_const("MM_Fly", 4);

define_const("FormSpeedLimit", {
[GS_Battroid]     = { [MM_Walk] = 200, [MM_Roll] = 100, [MM_Skim] = 150, [MM_Fly] = 150 },
[GS_Zoanoid]      = { [MM_Walk] = 200, [MM_Roll] =   0, [MM_Skim] =   0, [MM_Fly] = 200 },
[GS_GroundHugger] = { [MM_Walk] = 200, [MM_Roll] = 150, [MM_Skim] = 200, [MM_Fly] =   0 },
[GS_Arachnoid]    = { [MM_Walk] = 200, [MM_Roll] =   0, [MM_Skim] =   0, [MM_Fly] = 100 },
[GS_AeroFighter]  = { [MM_Walk] = 200, [MM_Roll] =   0, [MM_Skim] =   0, [MM_Fly] = 300 },
[GS_Ornithoid]    = { [MM_Walk] = 200, [MM_Roll] =   0, [MM_Skim] =   0, [MM_Fly] = 300 },
[GS_Gerwalk]      = { [MM_Walk] =  60, [MM_Roll] =   0, [MM_Skim] = 300, [MM_Fly] = 250 },
[GS_HoverFighter] = { [MM_Walk] = 200, [MM_Roll] =   0, [MM_Skim] = 300, [MM_Fly] = 250 },
[GS_GroundCar]    = { [MM_Walk] = 200, [MM_Roll] = 200, [MM_Skim] =   0, [MM_Fly] =   0 },
});

define_const("NAG_Action", -2);
define_const("NAS_MoveMode", 0);

define_const("NAS_MoveAction", 1);
define_const("NAV_Stop", 0);
define_const("NAV_NormSpeed", 1);
define_const("NAV_FullSpeed", 2);
define_const("NAV_TurnLeft", 3);
define_const("NAV_TurnRight", 4);
define_const("NAV_Reverse", 5);
define_const("NAV_Hover", 6);

define_const("NAS_MoveETA", 2);
define_const("NAS_MoveStart", 3);
define_const("NAS_CallTime", 4);
define_const("NAS_TimeLimit", 5);
define_const("NAS_JumpRecharge", 6);


-- qrl_glue.pp
define_const("QRL_CHIPMODE_BEGIN", 1);
define_const("QRL_CHIPMODE_END", 2);
define_const("QRL_CHIPMODE_NORMAL", 3);
define_const("QRL_CHIPMODE_EXEC", 4);


-- [ End of File ]
