#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,08 Nov,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : Get Transform List
-- size : 3 , 1
-- footprint :
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010013
-- argument : 0
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Get_Transform_List');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  g_QRL_SystemVariable["TransformationListPtr"] = 0;
  local max_transform = MaxTransformableMode(Mek);
  if (0 == max_transform) then
    return '##031##';
  end;
  local cur_transform = Transform_CurrentForm(Mek);
  if (0 == cur_transform) then
    return '##031##';
  end;

  local i;
  for i = 1, max_transform, 1 do
    g_QRL_SystemVariable["TransformationListPtr"] = g_QRL_SystemVariable["TransformationListPtr"] + 1;
    if ( 0 ~= TransformWait(Mek, cur_transform, g_QRL_SystemVariable["TransformationListPtr"])) then
      return '##021##';
    end;
  end;

  g_QRL_SystemVariable["TransformationListPtr"] = 0;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
