#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Wed,03 Jan,2018
--@date   Sat,23 Jun,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Sat,18 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Wed,21 Oct,2020
--@date   Sun,25 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Reload Ammo for a Weapon in the Array
-- size : 2 , 2
-- footprint :
-- ##
-- ##
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- argument : 1
-- argument_comment[1] : Ammo
-- argument[1] : ammo
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:10 , y:102 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Reload_Ammo_for_a_Weapon_in_the_Array');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  if (c_Variable_Type_Ammo ~= g_QRL_UserVariable_Type["##111##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Reload_Ammo_for_a_Weapon_in_the_Array:No Ammo is selected.');
    ret = false;
  end;
  if not(ret) then
    return '##021##';
  end;

  if (g_QRL_SystemVariable["WeaponListPtr"] <= g_QRL_SystemVariable["WeaponListMax"]) then
    g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] = g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] + 1;
    g_QRL_SystemVariable["ExecQueue_Reload_Queue_Weapon"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = g_QRL_SystemVariable["WeaponList"][g_QRL_SystemVariable["WeaponListPtr"]];
    g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ammo"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = g_QRL_UserVariable_Contents["##111##"];
  end;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
