static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F                                                 *
*                                                                             *
*      ֐@@@F@int cl_gx_rep_set( pparmList , ppmList )               *
*                      (O)parmList  *pparmList                                *
*                      (I)prmList  *pprmList                                  *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern int giOptions[];
extern GlobalCt  *pGlobTable;
extern tdtIterate_ctl gtIter_ctl[];

static int _array_hash_clr();
static int _list_array_set();

/****************************************/
/*										*/
/****************************************/
int cl_gx_rep_set(pparmList ,pInfoParm)
parmList  *pparmList;
tdtInfoParm *pInfoParm;
{
	int		rc;
	ScrPrCT *pSPCT;
	tdtInfoParm *pInfoParmW;

	pSPCT = cl_search_src_ct();

	if (rc= cl_gx_get_info_parm(pSPCT,'s',pparmList,&pInfoParmW)) {
		return rc;
	}
	/* 2021.10.27 */
	return cl_gx_rep_info_als(pInfoParmW ,pInfoParm ,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_rep_set_global( pparmList ,pInfoParm )
parmList  *pparmList;
tdtInfoParm *pInfoParm;
{
	/* %s: %sɂ͑ł܂B */
	ERROROUT2(FORMAT(126),"cl_gx_rep_set_global",pparmList->prp);
	return ECL_SCRIPT_ERROR;
}

/****************************************/
/*										*/
/****************************************/
int _get_num_msg_no(pInfoParm,msg_no,opt,pix0)
tdtInfoParm *pInfoParm;
int msg_no,opt,*pix0;
{
	int iRc,ix0;

	iRc = -1;
	ix0 = 0;
	if (msg_no <= 0) msg_no = 577;	/* (%d)słB */
	if (pInfoParm && pix0) {
		iRc = 0;
		if (pInfoParm->pi_dlen > 0) {
			if (iRc = cl_get_parm_bin(pInfoParm,&ix0,"_get_start_pos.ix0:")) return iRc;
			if (ix0 < 0) {
				ERROROUT1(FORMAT(msg_no),ix0);	/* EEE(%d)słB */
				iRc = -1;
			}
		}
		else if (opt & 0x01) iRc = C_NULL_PARM;
		*pix0 = ix0;
	}
/*
printf("_get_num_msg_no: ix0=%d iRc=%d\n",ix0,iRc);
*/
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info(nparm,ppParm,pIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtArrayIndex *pIndexW;
	int iRc;

	pIndexW = pIndex;
	iRc = _get_array_info_ref(nparm,ppParm,&pIndexW,ppTBL,iParm,opt);
	if (!iRc || iRc==2000) {
		if (pIndexW != pIndex) memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return iRc;
}

/********1*********2*********3*********4*********5*******/
/*	F	ppIndex : *ppIndex ɂ́A&tIndex A		*/
/*					    ݒ肳Ă邱				*/
/*					  *ppIndex ɂ́AA or R ̂ƂA	*/
/*						zpIndexԂB		*/
/********************************************************/
int _get_array_info_ref(nparm,ppParm,ppIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex **ppIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtInfoParm *pInfoParm;
	int iRc,ix0,*index;
	XHASHB *xhp;
	tdtArrayIndex *pIndex;

	pInfoParm = ppParm[0];
	pIndex = *ppIndex;
/*
printf("_get_array_info_ref:1 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	if (iRc = cl_get_array_info_ref(pInfoParm,ppIndex,ppTBL,iParm)) return iRc;
	pIndex = *ppIndex;
/*
printf("_get_array_info_ref:2 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	if ((opt & 0x01) && pIndex->xhp) {
		iParm[0] = 0;		/* Jnʒu */
		return 2000;
	}

	ix0 = 0;
	if (nparm >= 2) {
		if (iRc = _get_num_msg_no(ppParm[1],222,0,&ix0)) return iRc;
	}
/*
printf("_get_array_info_ref: ix0=%d iParm[1]..[3]=%d %d %d\n",ix0,iParm[1],iParm[2],iParm[3]);
*/
	iParm[0] = ix0;		/* Jnʒu */
	iParm[1] -= ix0;	/* ővf - Jnʒu */
	iParm[3] = iParm[3] - iParm[2] + 1 - ix0;	/* Jnʒuݒςݗvf̐擪̍őʒu܂ł̗vf */
	iParm[2] += ix0;	/* off_set + Jnʒu */
/*
printf("_get_array_info_ref: ix0=%d iParm[1]..[3]=%d %d %d\n",ix0,iParm[1],iParm[2],iParm[3]);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info_used_ref(nparm,ppParm,ppIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex **ppIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtInfoParm ***pTBL,*pInfoParm;
	int iRc,*pSize;
	char c;

	if (iRc = _get_array_info_ref(nparm,ppParm,ppIndex,ppTBL,iParm,opt)) return iRc;
	pInfoParm = ppParm[0];
	c = pInfoParm->pi_id;
/*
printf("_get_array_info_used: c=[%c] iParm[0]..[3] =%d %d %d %d\n",c,iParm[0],iParm[1],iParm[2],iParm[3]);
*/
	if (c!='R' && c!='A') {
		if (ppTBL) {
			pTBL = *ppTBL;
			pSize = (int *)pTBL[0];
			iParm[3] = pSize[7] - (iParm[2] - 1);	/* 6-->7 2020.4.30 *//* 1-->3 2021.5.9 */
		}
	}
DEBUGOUTL4(194,"_get_array_info_used: iParm[0]..[3] =%d %d %d %d",iParm[0],iParm[1],iParm[2],iParm[3]);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info_used(nparm,ppParm,pIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtArrayIndex *pIndexW;
	int iRc;

	pIndexW = pIndex;
	iRc = _get_array_info_used_ref(nparm,ppParm,&pIndexW,ppTBL,iParm,opt);
	if (!iRc || iRc==2000) {
		if (pIndexW != pIndex) memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
static int _get_array_num(nparm,ppParm,nm1,pNum)
int  nparm;
tdtInfoParm *ppParm[];
int nm1,*pNum;
{
	tdtInfoParm *pInfoParm;
	int nm,iRc;

	nm = nm1;
/*
printf("_get_array_num: nparm=%d nm1=%d nm=%d\n",nparm,nm1,nm);
*/
	if (nparm >= 1) {
		if ((iRc=_get_num_msg_no(ppParm[0],223,0x01,&nm)) == C_NULL_PARM) nm = nm1;
		else if (iRc) return iRc;
		else if (nm1>0 && nm>nm1) {
			if (cl_get_option(22,0) & 0x01) {
					/* f[^(%d)ž(%d)𒴂Ă܂B܂B */
				ERROROUT2(FORMAT(224),nm,nm1);
			}
			nm = nm1;
		}
	}
	*pNum = nm;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_array(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,tInfoParm,**ppParmW,*pInfoP;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix0,ix,nm,count,len,attr,nset,ii,type,iCOMPLEX;
	char c,*name,*p1;
	tdtArrayIndex *pIndex,tIndex;
	int *index,iParm[4];
	tdtDefType *pDeftype;

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	nm = nparm - 2;
	pIndex = &tIndex;
/*
printf("cl_set_array:Enter pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	iRc = _get_array_info_ref(nparm,ppParm,&pIndex,&pTBL,iParm,3);
	if (iRc) return iRc;

DEBUGOUTL5(194,"cl_set_array: nm=%d iParm=%d %d %d %d",nm,iParm[0],iParm[1],iParm[2],iParm[3]);

	iCOMPLEX = ppParm[0]->pi_alen & (D_AULN_COMPLEX_DATA | D_AULN_RANGE_DATA);
/*
printf("cl_set_array: iCOMPLEX=%08x\n",iCOMPLEX);
*/
	ix0 = iParm[0];
	ix  = iParm[2];
	n = 1;
	attr = pIndex->uAttr[0];
	pInfoP = pIndex->pInfoType;
/*
printf("cl_set_array: attr=%d pInfoP=%08x\n",attr,pInfoP);
*/
	if (pInfoP) n = 0;
	else if ((!attr || attr==DEF_ZOK_VARI) && !pInfoP) {
		nset = iParm[3] - iParm[2] + 1;
		for (i=0;i<nset;i++,ix++) {
			pInfoParmW = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'r');
			if (pInfoParmW) {
				if ((c=pInfoParmW->pi_id)=='T' || c=='R' || c=='A') {
					n = 0;
					break;
				}
			}
		}
		ix  = iParm[2];
	}
	if (n && nm>iParm[1]) {
		if (cl_get_option(22,0) & 0x01) {
				/* f[^(%d)ž(%d)𒴂Ă܂B܂B */
			ERROROUT2(FORMAT(224),nm,iParm[1]);
		}
		nm = iParm[1];
	}
/*
printf("cl_set_array:2 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
DEBUGOUTL3(194,"cl_set_array: n=%d nm=%d ix=%d",n,nm,ix);
	count = ii = 0;
	for (i=count=0;i<iParm[1];i++,ix++) {
		if (ii >= nm) break;
		pInfoParmW = cl_get_array_and_var_ent(pIndex,pTBL,ix);
		if (pInfoParmW) {
			pInfoParmW->pi_alen |= iCOMPLEX;
#if 1	/* 2022.12.07 */
			if (pInfoP) {
#else
			if (pInfoP && !pInfoParmW->pi_id) {
#endif
				if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoP,1)) return iRc;
				type = pInfoP->pi_aux[0];
/*
printf("cl_set_array: i=%d type=%d\n",i,type);
*/
				pInfoParmW->pi_hlen = ppParm[0]->pi_hlen;	/* add 2021.3.30 */
			}
/*
printf("cl_set_array: nm=%d i=%d ii=%d id=[%c]\n",nm,i,ii,pInfoParmW->pi_id);
*/
				pInfoParm = ppParm[ii+2];
				if (!cl_is_null_parm(pInfoParm)) {
					if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
					count++;
				}
				ii++;
		}
		else {
			return -1;
		}
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _list_copy_info(pCt,pCtI)
tdtRbCtl *pCt,*pCtI;
{
	tdtInfoParm *p,*pInfoParm;
	int iCHK,rc=0;

DEBUGOUTL2(120,"_list_copy_info:Enter pCt=%08x pCtI=%08x",pCt,pCtI);

	if (!pCt || !pCtI) return -1;
	if (pCt == pCtI) return 0;
	iCHK = 1;
	akxs_rb_read(pCtI,0);
	while (p=(tdtInfoParm *)akxs_rb_read(pCtI,1)) {
DEBUGOUT_InfoParm(198,"_list_copy_info: ",p,0,0);
		if (iCHK && p->pi_id==D_DATA_ID_UNDEFVAR) {
			rc = ECL_NDEFVAR_ERROR;
			break;
		}
		if (!(pInfoParm=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return ECL_MALLOC_ERROR;
		rc = _tmp_list_info_set(pInfoParm,p);
		if (!cl_tmp_rbset_n(pCt,pInfoParm)) return ECL_MALLOC_ERROR;
	}
DEBUGOUTL1(120,"_list_copy_info:Exit rc=%d",rc);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int _tmp_list_copy(pInfoParmO,pInfoParmI)
tdtInfoParm *pInfoParmO,*pInfoParmI;
{
	int rc;
	tdtRbCtl *pCt,*pCtI;

DEBUGOUTL2(120,"_tmp_list_copy:Enter pInfoParmO=%08x pInfoParmI=%08x",pInfoParmO,pInfoParmI);

	if (!pInfoParmO || !pInfoParmI) return -1;
	if (pInfoParmO == pInfoParmI) return 0;
	if (!(pCt = cl_tmp_rb_new(0,0,NULL))) return ECL_MALLOC_ERROR;
	pInfoParmO->pi_data = (char *)pCt;
	pInfoParmO->pi_scale &= ~D_DATA_MALLOC;
	pCtI = (tdtRbCtl *)pInfoParmI->pi_data;
	rc = _list_copy_info(pCt,pCtI);
DEBUGOUTL1(120,"_tmp_list_info_set:Exit rc=%d",rc);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int _tmp_list_info_set(pInfoParmO ,pInfoParmI)
tdtInfoParm  *pInfoParmO, *pInfoParmI;
{
	int rc;
	char c;

DEBUGOUTL(120,"_tmp_list_info_set:Enter");

	if (!pInfoParmO || !pInfoParmI) return -1;
	if (pInfoParmO == pInfoParmI) return 0;
	*pInfoParmO = *pInfoParmI;
DEBUGOUT_InfoParm(198,"_tmp_list_info_set: pInfoParmI=",pInfoParmI,0,0);
	if ((c=pInfoParmO->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) {
		if ((rc=_tmp_list_copy(pInfoParmO,pInfoParmI)) < 0) return rc;
	}
	else {
		if (rc=cl_gx_rep_info_copy_data(pInfoParmO,pInfoParmI,1 | D_GX_OPT_ALC_TMP,NULL)) return rc;
		if (pInfoParmO->pi_id == ' ') pInfoParmO->pi_aux[1] |= D_AUX1_PROTECTED;
DEBUGOUT_InfoParm(198,"_tmp_list_info_set: pInfoParmO=",pInfoParmO,0,0);
	}
DEBUGOUTL(120,"_tmp_list_info_set:Exit ret=0");
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2, *p;
	int i,rc,opt1,iHOLD_ERROR,f;
	tdtRbCtl *pCt;
	char id;

	opt1 = pGlobTable->options[4] & 0x01;
	/* 2022.6.14 */
	cl_none_parm(pInfoParmW);
	pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
	if (nparm > 0 || opt1) {
		pInfoParmW->pi_id   = D_DATA_ID_LIST;
		pInfoParmW->pi_attr = DEF_ZOK_BULK;
		pInfoParmW->pi_dlen  = sizeof(tdtRbCtl);
		if (!(pCt = cl_tmp_rb_new(0,0,NULL))) return ECL_MALLOC_ERROR;
		pInfoParmW->pi_data = (char *)pCt;
		pInfoParmW->pi_alen &= ~(D_AULN_NULL_PARM | D_AULN_NONE_PARM);
		pInfoParmW->pi_aux[1] &= ~D_AUX1_PROTECTED;
	}
	iHOLD_ERROR = 0;
	for (i=0;i<nparm;i++) {
		p = ppParm[i];
DEBUGOUT_InfoParm(197,"cl_set_list:s: i=%d",p,i,0);
		if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return ECL_MALLOC_ERROR;
		if ((rc=_tmp_list_info_set(pInfoParm1,p)) < 0) return rc;
DEBUGOUT_InfoParm(198,"cl_set_list:d: i=%d",pInfoParm1,i,0);
		if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		if (pInfoParm1->pi_alen & D_AULN_HOLD_ERROR) iHOLD_ERROR = D_AULN_HOLD_ERROR;
	}
	pInfoParmW->pi_alen |= iHOLD_ERROR;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
tdtRbCtl *cl_tmp_rb_new(lBS,lRM,pConstCt)
long lBS,lRM;
ConstantCt *pConstCt;
{
	char *(*m_alloc)();

	if (pConstCt) m_alloc = cl_const_ct_malloc;
	else  m_alloc = cl_tmp_const_malloc;
/*
printf("cl_tmp_rb_new: m_alloc=%08x pConstCt=%08x\n",m_alloc,pConstCt);
*/
	return akxs_rb_new2(lBS,lRM,m_alloc,pConstCt);
}

/****************************************/
/*										*/
/****************************************/
char *cl_tmp_rbset_n(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	return akxs_rb_set_n(pCt, addr);
}

/****************************************/
/*										*/
/****************************************/
int cl_cons_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2, *p;
	int i,rc,opt1;
	tdtRbCtl *pCt;
	char c,c0;

DEBUGOUTL2(120,"cl_cons_list:Enter nparm=%d ppParm=%08x",nparm,ppParm);

	opt1 = cl_get_option(5,0) & 0x01;
	cl_null_data(pInfoParmW);
	if (nparm > 0 || opt1) {
		pInfoParmW->pi_id   = D_DATA_ID_LIST;
		pInfoParmW->pi_attr = DEF_ZOK_BULK;
		pInfoParmW->pi_dlen  = sizeof(tdtRbCtl);
		if (!(pCt = cl_tmp_rb_new(0,0,NULL))) return ECL_MALLOC_ERROR;
		pInfoParmW->pi_data = (char *)pCt;
		if (nparm > 0) {
			/* 2021.4.7 */
			if ((c0=ppParm[0]->pi_id)==D_DATA_ID_NARABI || c0==D_DATA_ID_LIST)
				pInfoParmW->pi_id = c0;
		}
	}
	c0 = pInfoParmW->pi_id;
	for (i=0;i<nparm;i++) {
		p = ppParm[i];
		/* 2021.4.7 */
		if (((c=p->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) &&
		    (c==c0 || (c0!=D_DATA_ID_NARABI && c0!=D_DATA_ID_LIST))) {
			pInfoParmW->pi_id = c0 = c;
			if ((rc=_list_copy_info(pCt,p->pi_data)) < 0) return rc;
		}
		else if (!cl_is_null_parm(p)) {
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((rc=_tmp_list_info_set(pInfoParm1,p)) < 0) return rc;
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,len;
	char w1[32],*p1;
	tdtInfoParm **pp;

	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	ret = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) {
		ERROROUT(FORMAT(225));	/* w肪słB */
		return len;
	}
	nparm--;
	pp = &ppParm[1];
	if (!stricmp(p1,"LIST")||!stricmp(p1,"APPEND"))
		ret = cl_set_list(pInfoParmW,nparm,pp);
	else if (!stricmp(p1,"FIRST")) ret = cl_ope_list(pInfoParmW,NULL,nparm,pp,D_FUC_FIRST,0);
	else if (!stricmp(p1,"REST")) ret = cl_ope_list(pInfoParmW,NULL,nparm,pp,D_FUC_REST,0);
	else if (!stricmp(p1,"CONS")) ret = cl_cons_list(pInfoParmW,nparm,pp);
	else if (!stricmp(p1,"LIST_REF")) ret = cl_ope_list(pInfoParmW,NULL,nparm,pp,D_FUC_LIST_REF,0);
	else {
		ERROROUT1(FORMAT(226),p1);	/* w(%s)słB */
		ret = ECL_SCRIPT_ERROR;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ope_list(pInfoParmW,pdummy,nparm,ppParm,ope,dummy)
tdtInfoParm *pInfoParmW;
int  nparm,ope,dummy;
tdtInfoParm *ppParm[];
char *pdummy;
{
	tdtInfoParm *pInfoParm,*p,tInfoParm;
	int rc,n,opt1,i,m,iCONST;
	tdtRbCtl *pCt;
	char id;

	rc = 0;
	cl_null_data(pInfoParmW);
	pInfoParm = ppParm[0];
	if (cl_is_null_parm(pInfoParm) || cl_is_null_data(pInfoParm)) return 0;
	if ((id=pInfoParm->pi_id)!=D_DATA_ID_LIST && id!=D_DATA_ID_NARABI) {
		ERROROUT(FORMAT(227));	/* Xgł͂܂B */
		return ECL_SCRIPT_ERROR;
	}
	if (ope == D_FUC_FIRST) {
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if (p = (tdtInfoParm *)akxs_rb_get(pCt)) {
			if ((id=p->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI)
				rc = _tmp_list_info_set(pInfoParmW,p);
			else {
				cl_gx_copy_info(pInfoParmW,p);
				pInfoParmW->pi_scale &= ~D_DATA_MALLOC;
			}
		}
	}
	else if (ope == D_FUC_REST) {
		rc = _tmp_list_info_set(pInfoParmW,pInfoParm);
		opt1 = pGlobTable->options[4] & 0x01;
		n = akxs_rb_used(pCt=(tdtRbCtl *)pInfoParmW->pi_data);
		if (n>1 || opt1) {
			if (nparm > 1) {
				if ((rc=cl_get_parm_bin(ppParm[1],&m,"cl_ope_list REST:"))<0) return rc;
				rc = 0;
				m = X_MIN(n,m);
				for (i=0;i<m;i++) if (!akxs_rb_get_n(pCt)) break;
			}
			else akxs_rb_get_n(pCt);
		}
		else cl_null_data(pInfoParmW);
	}
	else if (ope == D_FUC_LIST_REF) {
		iCONST = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if ((n=akxs_rb_used(pCt)) <= 0) return 0;
		if (nparm > 1) {
			if ((rc=cl_get_parm_bin(ppParm[1],&m,"cl_ope_list REF:"))<0) return rc;
		}
		else m = 0;
		rc = 0;
		if (m < 0) {
			ERROROUT1(FORMAT(228),m);	/* Qƈʒu(%d)słB */
			return ECL_SCRIPT_ERROR;
		}
		if (m < n) {
			akxs_rb_read(pCt,0);
			for (i=0;i<=m;i++) if (!(p=(tdtInfoParm *)akxs_rb_read(pCt,1))) break;
			if (p) {
				if (dummy & D_GX_OPT_GET_ADDR) {
					cl_set_parm_long(pInfoParmW,(long)p);
					pInfoParmW->pi_id = 'S';
				}
				else {
					if ((id=p->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI)
						rc = _tmp_list_info_set(pInfoParmW,p);
					else
						cl_gx_copy_info(pInfoParmW,p);
				}
				pInfoParmW->pi_aux[1] |= iCONST;
DEBUGOUT_InfoParm(194,"cl_ope_list: p=",p,0,0);
DEBUGOUT_InfoParm(194,"cl_ope_list: ope=%d pInfoParmW=",pInfoParmW,ope,0);
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _array_cpy(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,rInfoParm;
	tdtInfoParm ***pTBL1,***pTBL2;
	int iRc,n,i,ix1,ix2,nm,nm1,nm2,count;
	tdtArrayIndex tIndex1,tIndex2,*pIndex;
	int *index1,*index2,iParm[4];
	char c,*name,*cpKey,*cpDat,*pVal;
	XHASHB *xhpI,*xhpO;

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));
	if (iRc = _get_array_info(nparm,ppParm,&tIndex1,&pTBL1,iParm,3)) {
		if (iRc == 2000) xhpO = tIndex1.xhp;
		else return iRc;
	}
	else xhpO = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];
/*
printf("_array_cpy: nm1=%d ix1=%d\n",nm1,ix1);
*/
	/* zQƏ`FbN */
	if (!gtIter_ctl[0].itc_circ_ref) {
		if (!(gtIter_ctl[0].itc_circ_ref=akxs_layer_new(10,cl_tmp_const_malloc,NULL))) return -215212104;
	}
	/* zQƂ`FbN */
	if (pTBL1) name = "$()";
	else name = (char *)ppParm[0]->pi_pos;
	pVal = cl_get_circ_addr(&tIndex1,pTBL1);
	if ((iRc=_iterate_circ_ref(&gtIter_ctl[0],pVal,name)) == 1) return 0;
	else if (iRc < 0) return iRc;
	if (iRc = _get_array_info_used(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhpI = tIndex2.xhp;
		else return iRc;
	}
	else xhpI = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];
/*
printf("_array_cpy: nm2=%d ix2=%d\n",nm2,ix2);
*/
	if (nm2 < nm1) nm1 = nm2;
	nm = nm1;
	if (iRc = _get_array_num(nparm-4,&ppParm[4],nm1,&nm)) return iRc;
/*
printf("_array_cpy: nm=%d nm1=%d\n",nm,nm1);
*/
	for (count=0,i=1;;i++) {
			if (i > nm) break;
			pInfoParmW = cl_get_array_and_var_ent(&tIndex1,pTBL1,ix1);
			pInfoParm  = cl_get_array_and_var_ent_opt(&tIndex2,pTBL2,ix2,'r');
			ix1++;
			ix2++;
		if (pInfoParmW && pInfoParm) {
			if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
		count++;
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_clr(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,rInfoParm;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix,nm,nm1,count,iNULL,atr,*pSize;
	char c,*name;
	tdtArrayIndex tIndex,*pIndex;
	int *index,iParm[4];

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	pIndex = &tIndex;
	if (iRc = _get_array_info_used_ref(nparm,ppParm,&pIndex,&pTBL,iParm,3)) {
	/*	if (iRc == 2000) iRc = _array_hash_clr(ppParm[0]->pi_data);	*/
		return iRc;
	}
	nm1 = iParm[1];		/* ővf */
	ix  = iParm[2];		/* off_set + Jnʒu */
	if (pTBL) atr = DEF_ZOK_VARI;
	else atr = pIndex->uAttr[0];
	index = pIndex->index;
	nm = nm1;
	/* NAw肳Ănmɂ̒lBAnm<=ővf */
	if (iRc = _get_array_num(nparm-3,&ppParm[3],nm1,&nm)) return iRc;
/*
printf("_array_clr: ix=%d nm1=%d nm=%d\n",ix,nm1,nm);
*/
	iNULL = 0;
	/* NAlȗNULLl̂Ƃ́Aݒɂ */
	if (nparm >= 3) {
		pInfoParm = ppParm[2];
		if (cl_is_null_parm(pInfoParm) && atr==DEF_ZOK_VARI) {
			cl_parm_set0(pInfoParm);
			iNULL = 1;
		}
	}
	else {
		pInfoParm = &rInfoParm;
		cl_null_parm(pInfoParm);
		if (atr == DEF_ZOK_VARI) {
			cl_parm_set0(pInfoParm);
		/*	iNULL = 1;	2021.7.2 */
		}
		iNULL = 1;
	}
	/* 2021.7.2 */
	if (iNULL) {	/* NAlȗNULLl̂Ƃ́AĂL܂Ŗݒɂ */
		nm1 = iParm[3];		/* ݒςݗvfōővfԍ̗vf܂ł̗vf */
		if (nm > nm1) nm = nm1;	/* w̃NA(nm)<=̐(nm1)ɂȂ */
	}
	for (i=count=0;i<nm;i++,ix++) {
		pInfoParmW = cl_get_array_and_var_ent(pIndex,pTBL,ix);
		if (pInfoParmW) {
			/* 2021.10.27 */
			if (iRc=cl_gx_rep_info_data(pInfoParmW,pInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
		count++;
	}
/*
printf("_array_clr: ix=%d nm1=%d nm=%d iNULL=%d\n",ix,nm1,nm,iNULL);
*/
	/* ݒςݗvfōővfԍ̗vf܂ŖݒɂA̐[ɂ */
	if (iNULL && nm1==nm) {
		ix = iParm[2] - 1;
		if (pTBL) {
			pSize = (int *)pTBL[0];
#if 1	/* 2023.2.10 */
			nm1 = pSize[7];
/*
printf("_array_clr: ix=%d pSize[7]=%d\n",ix,pSize[7]);
*/
			cl_set_max_var_ent(pSize,-1);
			nm = 0;
			for (i=nm1;i>=1;i--) {
				if (pInfoParm = cl_get_var_ent(pTBL,i)) {
					if (!(cl_is_null_parm(pInfoParm) || cl_is_undef_parm(pInfoParm))) {
						nm = i;
						break;
					}
				}
			}
			if (nm) cl_set_max_var_ent(pSize,nm);
#else
			cl_set_max_var_ent(pSize,-1);
			cl_set_max_var_ent(pSize,ix);
#endif
		}
		/* 2023.2.9 */
		index[2] = 0;
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/********1*********2*********3*********4*********5*********6*********7***/
/*			cmp_opt		: rIvV								*/
/*							= 0x01 : rΏۂ̐܂߂đSĂA		*/
/*									 vƂA1Ԃ				*/
/*	ԋp :  cmp_opt0x01												*/
/*			=0̂ƂAv											*/
/*			=1̂ƂA1/0=v/sv									*/
/********1*********2*********3*********4*********5*********6*********7***/
static int _array_cmp(pWork,nparm,ppParm,cmp_opt)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
int cmp_opt;
{
	tdtInfoParm *pInfoParm1,*pInfoParm2,*pInfoParm3;
	tdtInfoParm ***pTBL1,***pTBL2;
	int iRc,n,i,ix1,ix2,nm,nm1,nm2,len,iAns,iParm[4],count,match,nu1,nu2,nm3,nmc,nu;
	tdtArrayIndex tIndex1,tIndex2;
	char *p1,*pAns;
	char *cpKey,*cpDat,*pVal;
	char id1,id2;
	XHASHB *xhp1,*xhp2,*xhp;
/*
printf("_array_cmp: nparm=%d cmp_opt=%08x\n",nparm,cmp_opt);
*/
	/* zQƏ`FbN */
	if (!gtIter_ctl[0].itc_circ_ref) {
		if (!(gtIter_ctl[0].itc_circ_ref=akxs_layer_new(10,cl_tmp_const_malloc,NULL))) return -215212104;
		if (!(gtIter_ctl[1].itc_circ_ref=akxs_layer_new(10,cl_tmp_const_malloc,NULL))) return -215212104;
	}

	iAns = 0;
	memcpy(pWork,&iAns,sizeof(int));
	pInfoParm1 = ppParm[0];
	pInfoParm2 = ppParm[2];
	if ((id1=pInfoParm1->pi_id) != (id2=pInfoParm2->pi_id)) {
		/* %s: p[^̃f[^hc(id1=%c id2=%c)Ă܂B */
		ERROROUT3(FORMAT(241),"_array_cmp",id1,id2);
		return -1;
	}
	p1 = "==";
	if (nparm >= 6) {
		pInfoParm3 = ppParm[5];
		if (iRc=cl_check_attr(pInfoParm3,DEF_ZOK_CHAR,"_array_cmp.cmp")) return iRc;
		if (pInfoParm3->pi_dlen > 0) {
			p1 = pInfoParm3->pi_data;
			if (!strcmp(p1,"=")) p1 = "==";
			if (_get_comp_no(p1,0x11) < 0) return ECL_SCRIPT_ERROR;
		}
	}
	if (id1=='L' || id1=='N') {
		ix1 = ix2 = nm = 0;
		if (iRc=_get_num_msg_no(ppParm[1],222,0,&ix1)) return iRc;
		if (nparm >= 4) {
			if (iRc=_get_num_msg_no(ppParm[3],222,0,&ix2)) return iRc;
		}
		if (iRc = _get_array_num(nparm-4,&ppParm[4],-1,&nm)) return iRc;
		iParm[0] = ix1;
		iParm[1] = ix2;
		iParm[2] = nm;
		if ((iAns=cl_comp_list(p1,pInfoParm1,pInfoParm2,iParm,0)) >= 0) {
			memcpy(pWork,&iAns,sizeof(int));
			iRc = 0;
		}
		else iRc = iAns;
		return iRc;
	}
	if (iRc = _get_array_info_used(nparm,ppParm,&tIndex1,&pTBL1,iParm,1)) {
		if (iRc == 2000) xhp1 = tIndex1.xhp;
		else return iRc;
	}
	else xhp1 = NULL;

	/* zQƂ`FbN */
	pVal = cl_get_circ_addr(&tIndex1,pTBL1);
	if ((iRc=_iterate_circ_ref(&gtIter_ctl[0],pVal,(char *)ppParm[0]->pi_pos)) == 1) return 0;
	else if (iRc < 0) return iRc;

	nm1  = iParm[1];
	ix1  = iParm[2];
	nu1  = iParm[3];
/*
printf("_array_cmp: nm1=%d ix1=%d nu1=%d\n",nm1,ix1,nu1);
*/
	if (iRc = _get_array_info_used(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhp2 = tIndex2.xhp;
		else return iRc;
	}
	else xhp2 = NULL;

	/* zQƂ`FbN */
	pVal = cl_get_circ_addr(&tIndex2,pTBL2);
	if ((iRc=_iterate_circ_ref(&gtIter_ctl[1],pVal,(char *)ppParm[2]->pi_pos)) == 1) return 0;
	else if (iRc < 0) return iRc;

	nm2  = iParm[1];
	ix2  = iParm[2];
	nu2  = iParm[3];
/*
printf("_array_cmp: nm2=%d ix2=%d nu2=%d\n",nm2,ix2,nu2);
*/
	nm3 = X_MIN(nm1,nm2);
	nmc = nm3;
	if (iRc = _get_array_num(nparm-4,&ppParm[4],nm3,&nmc)) return iRc;
	nm = nmc;
	if (nu1 < nm) nm = nu1;
	if (nu2 < nm) nm = nu2;
/*
printf("_array_cmp: nm3=%d nm=%d cmp_opt=%02x nu1=%d nu2=%d\n",nm3,nm,cmp_opt,nu1,nu2);
*/
	if (cmp_opt & 0x01) {
		nu = X_MIN(nu1,nu2);
		if (nmc>=nu && nu1!=nu2) return 0;
	}
	nm1 = nm3;
/*
printf("_array_cmp: nm=%d\n",nm);
*/
	count=match=0;
	for (i=1;;i++) {
			if (i > nm) break;
			pInfoParm1 = cl_get_array_and_var_ent_opt(&tIndex1,pTBL1,ix1,'r');
			pInfoParm2 = cl_get_array_and_var_ent_opt(&tIndex2,pTBL2,ix2,'r');
			ix1++;
			ix2++;
		if (pInfoParm1 && pInfoParm2) {
			count++;
/*
printf("_array_cmp: count=%d\n",count);
*/
			pAns = (char *)&iAns;
			if ((iRc=cl_cmpt_comp_opt(&pAns,p1,pInfoParm1,pInfoParm2,0,NULL,cmp_opt)) < 0) iAns = 0;
		/*	if (!iAns) break; */
			if (iAns) match++;
		}
		else {
			return -1;
		}
	}
	if (cmp_opt & 0x01) {
		if (match == nm) match = 1;
		else match = 0;
	}
	memcpy(pWork,&match,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_bxp(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParmW,*pInfoParm2,tInfoParm;
	tdtInfoParm ***pTBL1,***pTBL2,***pTBL3;
	int iRc,n,i,ix1,ix2,ix3,nm,nm1,nm2,nm3,len,count,iParm[4],nu2,nu3;
	tdtArrayIndex *pIndex1,tIndex1,tIndex2,tIndex3,*pIndex;
	XHASHB *xhp1,*xhp2,*xhp3,*xhp;
	char *p1,*cpKey,*cpDat;

	count = 0;
	memcpy(pWork,&count,sizeof(int));

	pIndex1 = &tIndex1;
	if (iRc = _get_array_info_used_ref(nparm,ppParm,&pIndex1,&pTBL1,iParm,3)) {
		if (iRc == 2000) xhp1 = pIndex1->xhp;
		else return iRc;
	}
	else xhp1 = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];

	if (iRc = _get_array_info_used(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhp2 = tIndex2.xhp;
		else return iRc;
	}
	else xhp2 = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];
	nu2  = iParm[3];

	if (iRc = _get_array_info_used(nparm-4,&ppParm[4],&tIndex3,&pTBL3,iParm,1)) {
		if (iRc == 2000) xhp3 = tIndex3.xhp;
		else return iRc;
	}
	else xhp3 = NULL;
	nm3  = iParm[1];
	ix3  = iParm[2];
	nu3  = iParm[3];
	if (nm2 < nm1) nm1 = nm2;
	if (nm3 < nm1) nm1 = nm3;
	if (iRc = _get_array_num(nparm-6,&ppParm[6],nm1,&nm)) return iRc;
	if (nu2 < nm) nm = nu2;
	if (nu3 < nm) nm = nu3;

printf("_array_bxp: nm1=%d nm=%d\n",nm1,nm);

	p1 = "+";
	if (nparm >= 8) {
		pInfoParmW = ppParm[7];
		if (iRc=cl_check_attr(pInfoParmW,DEF_ZOK_CHAR,"_array_bxp.bxp")) return iRc;
		if (pInfoParmW->pi_dlen > 0) p1 = pInfoParmW->pi_data;
	}
	for (count=0,i=1;;i++) {
			if (i > nm) break;
			pInfoParmW = cl_get_array_and_var_ent(pIndex1,pTBL1,ix1);
			pInfoParm1 = cl_get_array_and_var_ent_opt(&tIndex2,pTBL2,ix2,'r');
			pInfoParm2 = cl_get_array_and_var_ent_opt(&tIndex3,pTBL3,ix3,'r');
			ix1++;
			ix2++;
			ix3++;
		if (pInfoParm1 && pInfoParm2) {
			if (iRc=cl_gx_bexp(&tInfoParm,pInfoParm1,p1,pInfoParm2,0,0)) return iRc;
				if (!pInfoParmW) return -1;
				if (iRc=cl_gx_rep_info_set(pInfoParmW,&tInfoParm,1)) return iRc;
			count++;
		}
		else {
			return -1;
		}
	}
	memcpy(pWork,&count,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_ope_opt(pAns,nparm,ppParm,ope,cmp_opt)
long *pAns;
int  nparm;
tdtInfoParm *ppParm[];
int  ope;
int  cmp_opt;
{
	int ret,ok_opt,*pWork,iAns;

DEBUGOUT_InfoParm(110,"cl_array_ope_opt:Enter ope=%d cmp_opt=%d ppParm[0]=",ppParm[0],ope,cmp_opt);
if (nparm > 2) {
DEBUGOUT_InfoParm(110,"                 ppParm[2]=",ppParm[2],0,0);
}
	ok_opt = 0x02 | 0x08 | 0x1000;
	if (cl_check_data_id(ppParm[0],~ok_opt)) return ECL_SCRIPT_ERROR;
	if (ope != D_FUC_ARRAY_CLR) {
		if (cl_check_data_id(ppParm[2],~ok_opt)) return ECL_SCRIPT_ERROR;
	}
	if (ope == D_FUC_ARRAY_BXP) {
		if (cl_check_data_id(ppParm[4],~ok_opt)) return ECL_SCRIPT_ERROR;
	}

	pWork = &iAns;
	if      (ope == D_FUC_ARRAY_CPY) ret = _array_cpy(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_CLR) ret = _array_clr(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_CMP) ret = _array_cmp(pWork,nparm,ppParm,cmp_opt);
	else if (ope == D_FUC_ARRAY_BXP) ret = _array_bxp(pWork,nparm,ppParm);
	*pAns = iAns;
/*
printf("cl_array_ope_opt: ret=%d\n",ret);
*/
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_ope(pWork,pOperator,nparm,ppParm,ope,opt)
char *pWork,*pOperator;
int  nparm,ope,opt;
tdtInfoParm *ppParm[];
{
	return cl_array_ope_opt(pWork,nparm,ppParm,ope,0);
}

/****************************************/
/*										*/
/****************************************/
static int _list_array_set(pCt,pInfoParmI)
tdtRbCtl *pCt;
tdtInfoParm *pInfoParmI;
{
	tdtInfoParm *pInfoParm1,*pInfoParm;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix,nm,len,iAns,iParm[4],count,match;
	tdtArrayIndex tIndex;
	char *p1;
	char *cpKey,*cpDat;
	XHASHB *xhp;

	if (iRc = _get_array_info(1,&pInfoParmI,&tIndex,&pTBL,iParm,3)) {
		if (iRc == 2000) xhp = tIndex.xhp;
		return iRc;
	}
	else xhp = NULL;
	nm = iParm[1];
	ix = iParm[2];

	for (i=1;i<=nm;i++,ix++) {
			pInfoParm = cl_get_array_and_var_ent_opt(&tIndex,pTBL,ix,'r');
		if (pInfoParm) {
			if (cl_is_undef_parm(pInfoParm) || cl_is_null_parm(pInfoParm)) continue;
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((iRc=_tmp_list_info_set(pInfoParm1,pInfoParm)) < 0) return iRc;
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
		else {
			return -1;
		}
	}

	return iRc;
}
