static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************************/
/* <cldPath.c>                                         */
/*      exec command  process                          */
/*******************************************************/
#include "colmn.h"

#undef DEBUG

extern condList *pCLcList;		/* 񃊃Xg */
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;

/**************************************************************/
/* cl_process_msg_pre_send                                    */
/**************************************************************/
int cl_process_msg_pre_send(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc = 0, cmd;

	if (leaf) {
		cmd = leaf->cmd.cid;
		proc->Curleaf = leaf;
		cl_ret_leaf_push(proc,leaf);
		if (cmd == C_SQL)
			rc = cl_process_sqlsnd(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		else if (cmd == C_SLEEP)
			rc = cl_process_sleep_snd(leaf->cmd.prmnum,leaf->cmd.prmp,proc);
		else if (cmd == C_MSG)
			rc = cl_process_messag_send(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		if (rc) {
			pGlobTable->error = rc;
			if (!pGlobTable->exception)
				pGlobTable->exception = cl_mk_exception_code(COMM_EXCEPTION,rc);
			pGlobTable->tuppl = 0;
		}
		else {
			cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_ON);
			cmn_set_stat(RTN_PR,&proc->ptype,L_ON);
		}
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_msg_pre_return                                  */
/**************************************************************/
int cl_process_msg_pre_return(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	ScrPrCT *scrprct;
	ProcCT  *procct;
	int rc, cmd;

	if (leaf) {
		procct = cl_search_proc_ct();
		if ((cmd=leaf->cmd.cid) == C_SQL)
			rc = cl_process_sqlrcv(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		else if (cmd == C_SLEEP)
			rc = cl_process_sleep_rcv(leaf->cmd.prmnum,leaf->cmd.prmp);
		else if (cmd == C_MSG)
			rc = cl_process_message_recv(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		if (pCLprocTable->WaitPacketp) Free(pCLprocTable->WaitPacketp);
		pCLprocTable->WaitPacketp = NULL;
		cmn_set_stat(RTN_PR,&procct->ptype,L_OFF);
		cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_OFF);
	}
	else {
		ERROROUT("cl_process_msg_pre_return:leaf==NULL");
		rc = ECL_SYSTEM_ERROR;
	}

	return rc;
}

/**************************************************************/
/* cl_proc_bexp                                               */
/**************************************************************/
int cl_process_bexp(cid, leaf, proc)
int     cid;
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;

	if (leaf && proc) {
		if (cid == C_BEXP) rc = cl_proc_bexp(leaf,proc);
		else rc = cl_process_let(leaf,proc);
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_read                                            */
/**************************************************************/
int cl_process_read(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;

	if (leaf && proc) {
		rc = cl_proc_read(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_output                                          */
/**************************************************************/
int cl_process_output(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int   rc;

	if (leaf && proc)  rc = cl_proc_output(leaf,proc);
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_leave                                           */
/**************************************************************/
int cl_process_leave(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;

	if (leaf && proc) {
		/* kd`uds */
		rc = cl_proc_leave(leaf, proc);
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_messag_send                                     */
/**************************************************************/
int cl_process_messag_send(nprm,prmp,pbxobj)
int nprm;
parmList *prmp[];
GXObject *pbxobj[];
{
	char *p;
	int rc;

	p = prmp[0]->prp;
 	if (!stricmp(p,"SEND") ||
 	    !stricmp(p,"POST") ||
 	    !stricmp(p,"REPLY"))
			rc = cl_process_msg_snd(nprm,prmp,pbxobj);
	else if (!stricmp(p,"SQL"))
			rc = cl_process_sqlsnd(nprm-1,prmp+1,pbxobj);
	else if (!stricmp(p,"SLEEP"))
			rc = cl_process_sleep_snd(nprm-1,prmp+1,pbxobj);
	else {
		ERROROUT1("[%s] not SQL,SLEEP,SEND,POST,REPLY",p);
		rc = ECL_EX_MSG;
	}
	return rc;
}

/**************************************************************/
/* cl_process_message_recv                                    */
/**************************************************************/
int cl_process_message_recv(nprm,prmp,pbxobj)
int nprm;
parmList *prmp[];
GXObject *pbxobj[];
{
	char *p;
	int rc;

	p = prmp[0]->prp;
 	if (!stricmp(p,"SEND") ||
 	    !stricmp(p,"POST") ||
 	    !stricmp(p,"REPLY"))
			rc = cl_process_msg_rcv(nprm,prmp,pbxobj);
	else if (!stricmp(p,"SQL"))
			rc = cl_process_sqlrcv(nprm-1,prmp+1,pbxobj);
	else if (!stricmp(p,"SLEEP"))
			rc = cl_process_sleep_rcv(nprm-1,prmp+1);
	else {
		ERROROUT1("[%s] not SQL,SLEEP,SEND,POST,REPLY",p);
		rc = ECL_SYSTEM_ERROR;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _get_src(pQue,n,s,s_len)
tdtQueCtl *pQue;
int n;
char *s;
int s_len;
{
	int rc,nn;
	char *cp,*p;
/*
printf("_get_src: n=%d s_len=%d\n",n,s_len);
*/
	if (s_len <= 0) return -1;
	if (n > 0) {
		akxs_que_move(pQue,QUE_TOP);
		while ((rc=akxs_que_peek(pQue,QUE_PEEK_NEXT,&cp)) > 0) {
			memcpy(&nn,cp,sizeof(int));
/*
printf("_get_src: n=%d p=[%s]\n",nn,cp+sizeof(int));
*/
			if (n == nn) break;
		}
	}
	else {
		rc = akxs_que_peek(pQue,QUE_BOT,&cp);
/*
if (rc > 0) {
memcpy(&nn,cp,sizeof(int));
printf("_get_src: n=%d p=[%s]\n",nn,cp+sizeof(int));
}
*/
	}
	if (rc > 0) {
		strncpy(s,cp+sizeof(int),s_len-1);
		s[s_len-1] = '\0';
		rc = strlen(s);
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _add_src(pQue,n1,n2,s,s_len)
tdtQueCtl *pQue;
int n1,n2;
char *s;
int s_len;
{
	int rc,n;
	char *cp;
/*
printf("_add_src: n1=%d n2=%d s_len=%d s=[%s]\n",n1,n2,s_len,s);
*/
	if (s_len <= 0) return 0;
	if ((rc=akxs_que_peek(pQue,QUE_BOT,&cp)) > 0) {
		memcpy(&n,cp,sizeof(int));
		n += n2;
	}
	else n = n1;
	cp = Malloc(sizeof(int)+s_len+1);
	memcpy(cp,&n,sizeof(int));
	memzcpy(cp+sizeof(int),s,s_len);
	akxs_que_put(pQue,QUE_BOT,cp);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _ins_src(pQue,num,s,s_len)
tdtQueCtl *pQue;
int num;
char *s;
int s_len;
{
	int rc,n;
	char *cp;
/*
printf("_ins_src: num=%d s_len=%d s=[%s]\n",num,s_len,s);
*/
	akxs_que_move(pQue,QUE_TOP);
	n = 0;
	for (;;) {
		if ((rc=akxs_que_peek(pQue,QUE_PEEK_CUR,&cp)) < 0) return rc;
		else if (!rc) break;
		memcpy(&n,cp,sizeof(int));
/*
printf("_ins_src: peek: rc=%d n=%d\n",rc,n);
*/
		if (n >= num) break;
		akxs_que_move(pQue,QUE_NEXT);
	}
	if (n == num) {
		akxs_que_get(pQue,QUE_CUR,&cp);
		Free(cp);
	}
	if (s_len > 0) {
		akxs_que_move(pQue,QUE_PREV);
		cp = Malloc(sizeof(int)+s_len+1);
		memcpy(cp,&num,sizeof(int));
		memzcpy(cp+sizeof(int),s,s_len);
		akxs_que_put(pQue,QUE_CUR,cp);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _list_src(pQue,argc,argv)
tdtQueCtl *pQue;
int argc;
char *argv[];
{
	int rc,n;
	char *cp,*p,*pp;
	Leaf *leafTop;
	condList *y;

	cp = argv[0];
	if (toupper(*cp)=='T'/* || !stricmp(cp,"tree")*/) {
		y = pCLcList;
	/*	if (leafTop = search_top_leaf(y))	*/
		leafTop = y->clstcb->TopTreeSave;
/*
printf("_list_src: leafTop=%08x\n",leafTop);
*/
		if (leafTop) {
/*
printf("_list_src: leftleaf=%08x rightleaf=%08x\n",leafTop->leftleaf,leafTop->rightleaf);
*/
			col_leaf_print(leafTop);
		}
	}
	else {
		akxs_que_move(pQue,QUE_TOP);
		while (akxs_que_peek(pQue,QUE_PEEK_NEXT,&cp) > 0) {
			memcpy(&n,cp,sizeof(int));
			p = cp + sizeof(int);
			cl_str_conv_put(&pp,p,strlen(p));
		/*	printf("%5d %s\n",n,pp);	*/
			if (p != pp) Free(pp);
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _renum_src(pQue,n1,n2)
tdtQueCtl *pQue;
int n1,n2;
{
	int rc,n;
	char *cp;

	n = n1;
	akxs_que_move(pQue,QUE_TOP);
	for (;;) {
		if ((rc=akxs_que_peek(pQue,QUE_PEEK_CUR,&cp)) <= 0) break;
		memcpy(cp,&n,sizeof(int));
		n += n2;
		akxs_que_move(pQue,QUE_NEXT);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _auto_mode(pQue,line,count)
tdtQueCtl *pQue;
char *line;
int count;
{
	int rc,pos;
	char *cp;

	if (pQue) {
		if ((rc=akxs_que_peek(pQue,QUE_PEEK_NEXT,&cp)) > 0) {
			strcpy(line,cp+sizeof(int));
			pos = strlen(line);
		}
		else pos = 0;
	}
	else {
		if (count == 1) {
			strcpy(line,"quit;");
			rc = 1;
			pos = strlen(line);
		}
		else {
			pos = rc = 0;
		}
	}
	strcpy(line+pos,"\n");
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _del_src(pQue,argc,argv)
tdtQueCtl *pQue;
int argc;
char *argv[];
{
	Leaf *leafTop;
	int i,rc,num,nn,flg,not_found,found;
	char *cp,w[16];
	condList *y;
	CLNCB *ys;

	y = pCLcList;
	ys = y->clstcb;
	flg = 1;
	found = 0;
	for (i=0;i<argc;i++) {
		flg = 0;
		cp = argv[i];
		if ((num=atoi(cp)) > 0) {
			akxs_que_move(pQue,QUE_TOP);
			not_found = 1;
			while ((rc=akxs_que_peek(pQue,QUE_CUR,&cp)) > 0) {
				memcpy(&nn,cp,sizeof(int));
/*
printf("_del_src: n=%d p=[%s]\n",nn,cp+sizeof(int));
*/
				if (num == nn) {
					rc = akxs_que_get(pQue,QUE_CUR,&cp);
					not_found = 0;
					found = 1;
					break;
				}
				akxs_que_move(pQue,QUE_NEXT);
			}
			if (not_found) {
				cmn_i_to_a(num,w);
				ERROROUT2(FORMAT(76),"_del_src",w);	/* %s: %s܂B*/
			}
		}
		else if (toupper(*cp)=='T'/* || !stricmp(cp,"tree")*/) ;
	}
	if (!flg && !found) return 0;

	if (flg) akxs_que_all_free(pQue);

/*	if (leafTop = search_top_leaf(y)) {	*/
	if (leafTop = ys->TopTreeSave) {
		cl_leaf_clear(leafTop);
	}
	ys->TopTreeSave = NULL;
	ys->TopStack = NULL;
	return flg;
}

/****************************************/
/*										*/
/****************************************/
static int _edit_cmd(cmdio,eds)
char *cmdio,*eds;
{
	char c,tmp[BUFLEN],*cms,*cmd,*p,*pp;
	int  len_cms,len_eds,m_cms,m_eds;
/*
printf("_edit_cmd: eds=[%s]\n",eds);
*/
	len_cms = strlen(cmdio);
	len_eds = strlen(eds);
	cmd = tmp;
	cms = cmdio;
	while (c=*eds) {
/*
printf("_edit_cmd: cms=[%s]\n",cms);
*/
		m_eds = akxqkanjilen2(eds,len_eds);
		m_cms = akxqkanjilen2(cms,len_cms);
		len_eds -= m_eds;
		len_cms -= m_cms;
		if (m_eds == 1) {
/*
printf("_edit_cmd: c=[%c] m_eds=%d m_cms=%d len_eds=%d len_cms=%d\n",c,m_eds,m_cms,len_eds,len_cms);
*/
			if (c==' ') {
			/*	if (c=*cms++) {
					*cmd++ = *cms++;	*/
				if (*cms) {
					memzcpy(cmd,cms,m_cms);
					cmd += m_cms;
					cms += m_cms;
				}
				else {
					*cmd++ = c;
					*cmd   = '\0';
				}
			}
			else if (c=='#') {
			/*	if (*cms) cms++;	*/
				if (*cms) cms += m_cms;
			}
			else if (c=='^') {
			/*
				if (c=*eds++) {
					*cmd++ = c;
				}
			*/
				eds++;
				if (*eds) {
					m_eds = akxqkanjilen2(eds,len_eds);
					memzcpy(cmd,eds,m_eds);
					cmd += m_eds;
				/*	eds += m_eds;	*/
					len_eds -= m_eds;
				/*	cms += m_cms;	*/
					len_cms += m_cms;
				}
				else break;
			}
			else if (c=='%') {
				break;
			/*
				strcpy(cmd,eds);
				strcpy(cmdio,tmp);
				return 0;
			*/
			}
			else if (c=='\\') {
			/*	if (c=*eds++) {
					*cmd++ = c;
					if (*cms) cms++;	*/
				eds++;
				if (*eds) {
					m_eds = akxqkanjilen2(eds,len_eds);
					memzcpy(cmd,eds,m_eds);
					cmd += m_eds;
				/*	eds += m_eds;	*/
					len_eds -= m_eds;
					cms += m_cms;
				}
				else break;
			}
			else if (c==';') {
				*cmd++ = c;
				*cmd   = '\0';
			/*
				strcpy(cmdio,tmp);
				return 0;
			*/
				*cms   = '\0';
				break;
			}
			else {
				*cmd++ = c;
			/*	if (*cms) cms++;	*/
				if (*cms) cms += m_cms;
				*cmd   = '\0';
			}
		}
		else {
			memzcpy(cmd,eds,m_eds);
			cmd += m_eds;
			cms += m_cms;
		}
		eds += m_eds;
/*
printf("_edit_cmd: tmp=[%s]\n",tmp);
*/
	}
	strcpy(cmd,cms);
	strcpy(cmdio,tmp);
/*
printf("_edit_cmd: cmdio=[%s]\n",cmdio);
*/
	return strlen(cmdio);
}

/****************************************/
/*										*/
/****************************************/
static int _editor(line,line_max)
char *line;
int line_max;
{
	static char *help[]=
{"/            ͗ɕۑꂽsB"
,"/list [tree] treeȂ̂Ƃ́A͗ɕۑꂽ\B"
,"             treêƂ́Aς݃R}htreê݂\B"
,"/renum [l][,|][l]"
,"             ̔Ԃ̃ftHglύXAsԍU蒼B"
,"             lȗ邩A[ȉ̂Ƃ́AftHgl͕ύXȂB"
,"/del [tree|no ...]"
,"             tree|noȂ̂Ƃ́A͗ɕۑꂽ"
,"             ς݃R}htreeSč폜B"
,"             treêƂ́Aς݃R}htreê݂폜B"
,"             nôƂ́A͗nosԍ̍s폜B"
,"/tree        ͗ɕۑꂽR}htree𐶐B"
,"/edit [no]   noȂ̂Ƃ́AO͍̓sҏWB"
,"             nôƂ́A͗nosԍ̍sҏWB"
,"//           ͑𒆎~B"
,"/quit        IB"
,NULL
};
	static tdtQueCtl *pQue=NULL,*pQueAuto=NULL;
	static int n1=10,n2=10,auto_mode=0,tree_mode=0;
	char buff[128],work[128],*p,*argv[10],c,**he,cmds[BUFLEN],*pp,*buf;
	int rc,len,line_len,num,s_len,pos,argc;
	SSP_S ssp;
	condList *y;
	CLNCB *ys;
	Leaf *leafTop;

	y = pCLcList;
	ys = y->clstcb;
	if (!pQue) pQue = akxs_que_new(0,0);
	if (auto_mode) {
		rc = _auto_mode(pQueAuto,line,auto_mode);
/*
printf("_editor:auto_mode: tree_mode=%d rc=%d line=[%s]\n",tree_mode,rc,line);
*/
		if (rc > 0) {
			auto_mode++;
			return 0;
		}
		else {
			auto_mode = 0;
			if (!tree_mode) return 0;
#if 1
		/* ɗƂ́ACLSTCB.TopTreeSave̓NAĂB
			if (leafTop = CLSTCB.TopTreeSave) {
				cl_leaf_clear(leafTop);
				CLSTCB.TopTreeSave = NULL;
			}
printf("_editor: TopTreeSave=%08x\n",leafTop);
		*/
			/* ł́A܂Alex()甲ĂȂ߁ACLSTCB.TopTreeɓo^ꂽ܂܂ŁA
			   leaf->leftleafɓĂȂACLSTCB.TopTreeSaveɈڂĂȂB
			   ̂܂܁A"/"sCLSTCB.TopTree2dɓo^AʓIɁA
			   2dɓo^ꂽԂCLSTCB.TopTreeSaveɈڂ̂ŁAŁA
			   CLSTCB.TopTreeCLSTCB.TopTreeSaveɈڂACLSTCB.TopTree𖢓o^ԂɂB */
			if (leafTop = search_top_leaf(y)) {
/*
printf("_editor: TopTree=%08x\n",leafTop);
*/
				ys->TopTreeSave = leafTop;
				ys->TopStack = NULL;
			}
#endif
		}
	}
	tree_mode = 0;
	for (;;) {
		printf("%s",y->fname);
#if 1
		if ((line_len=cl_getline(buff,sizeof(buff))) >= 0) {
		buf = buff;
#else
		if ((line_len=akxa_read_line_opt(buff,sizeof(buff),stdin,2)) >= 0) {
/*
akxaxdump("buf b",buf,line_len);
*/
			line_len = cl_str_conv_get(&buf,buff,line_len);
#endif
/*
akxaxdump("buf a",buf,line_len);
*/
			ssp.sp = 0;
			ssp.wd = work;
			if ((len=akxtgwse(buf,&ssp," \n",1)) > 0) {
				y->fname = ">";	/* prompt */
				if ((c=*work) == '/') {
					if (work[1] == '/') continue;
					pos = len + 1;
					argc = akxtgetargv2(buf+ssp.sp+1,argv,10,work+pos,sizeof(work)-pos,0x04);
					p = work + 1;
					if (!(c=toupper(*p)) || c=='T') {
						if (c == 'T') tree_mode = 1;
						else tree_mode = 0;
						argv[0] = "tree";
						_del_src(NULL,1,argv);
						auto_mode = 1;
						pQueAuto = pQue;
						akxs_que_move(pQue,QUE_TOP,NULL);
						rc = _auto_mode(pQue,line,auto_mode);
/*
printf("_editor: work=[%s] auto_mode=%d tree_mode=%d rc=%d line=[%s]\n",work,auto_mode,tree_mode,rc,line);
*/
						if (rc > 0) {
							auto_mode++;
							break;
						}
						else {
							auto_mode = 0;
							if (!tree_mode) break;
						}
					}
					else if (c=='L'/* || !stricmp(p,"list")*/) {
						_list_src(pQue,argc,argv);
					}
					else if (c=='R'/* || !stricmp(work,"/renum")*/) {
						if ((num=atoi(argv[0])) > 0) n1 = num;
						if ((num=atoi(argv[1])) > 0) n2 = num;
						_renum_src(pQue,n1,n2);
					}
					else if (c=='D'/* || !stricmp(work,"/del")*/) {
						if (_del_src(pQue,argc,argv)) pQue = akxs_que_new(0,0);
					}
					else if (c=='Q'/* || !stricmp(work,"/quit")*/) {
						argv[0] = "tree";
						_del_src(NULL,1,argv);
						auto_mode = 1;
						pQueAuto = NULL;
						rc = _auto_mode(NULL,line,auto_mode);
						return 0;
					}
					else if (c=='H'/* || !stricmp(work,"/help")*/) {
						he = help;
						while (p = *he++) {
#if 1
							cl_puts(p);
#else
							strcpy(work,p);
							cl_str_conv_put(NULL,work,strlen(work));
							printf("%s\n",work);
#endif
						}
						putchar('\n');
					}
					else if (c=='E'/* || !stricmp(work,"/edit")*/) {
						num = atoi(argv[0]);
						if ((len=_get_src(pQue,num,line,line_max)) > 0) {
							cl_str_conv_put(&p,line,len);
							printf("edit>%s\n",p);
							if (p != line) Free(p);
						/*	p = y->fname;
							y->fname = "edit>";	*//* prompt */
							printf("edit>");
							if ((line_len=akxa_read_line_opt(cmds,sizeof(cmds),stdin,2)) >= 0) {
								line_len = cl_str_conv_get(NULL,cmds,line_len);
								len = _edit_cmd(line,cmds);
								_add_src(pQue,n1,n2,line,len);
								strcpy(line+len,"\n");
								len++;
								cl_str_conv_put(&p,line,len);
								printf("%s",p);
								if (p != line) Free(p);
							/*	y->fname = p;	*/
								break;
							}
						/*	y->fname = p;	*/
						}
					}
					else {
						printf("*** [%s] is no subcommand.\n",work);
					}
				}
				else {
					rc = akxcgcvn(work,len,&num);
					if (!rc || rc>1) {
						if (num <= 0) continue;
						rc--;
						if (rc > 0) {
							pos = ssp.sp - len + rc;
						}
						else {
							pos = ssp.sp + 1;
							if (akxtgwse(buf,&ssp," \n",1) <= 0) pos = line_len;
						}
						p = buf + pos;
						s_len = line_len - pos;
						rc = _ins_src(pQue,num,p,s_len);
					}
					else {
						p = buf;
						s_len = line_len;
						_add_src(pQue,n1,n2,buf,line_len);
						memzcpy(line,p,s_len);
					/*	s_len = cl_str_conv_put(NULL,line,s_len);	*/
						strcpy(line+s_len,"\n");
						break;
					}
				}
			}
			else {
				strcpy(line,"\n");
				break;
			}
		}
	}
/*
printf("_editor: len=%d line=[%s]\n",len,line);
*/
#if 1
	if (leafTop = ys->TopTreeSave) {
		cl_leaf_clear(leafTop);
	}
	ys->TopTreeSave = NULL;
#endif
	return len;
}

/**************************************************************/
/* cl_process_interactive                                    */
/**************************************************************/
int cl_process_interactive(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int len,rc,opt_in,dtype;
	char buf[256];
	ScrPrCT *scrptct;
	Leaf    tleaf,*leafTop;
	condList *y;
	CLNCB *ys;

	if (!leaf || !proc) return ECL_SYSTEM_ERROR;
	if (!(scrptct=cl_search_src_ct())) return ECL_SYSTEM_ERROR;

	y = pCLcList;
	ys = y->clstcb;
	if (!(y->ConstCt=cl_const_ct_new())) {
		ERROROUT("Malloc ConstCt");
		return -1;
	}
#if 1
	y->fp = (FILE *)_editor;
	y->option |= D_SCRPT_FUNC;
#if 1	/* 2021.5.18 */
	dtype = akxt_get_code_type();
	if (opt_in = (cl_get_option(21,0)>>16) & 0x0f) dtype = opt_in;
	y->option |= D_CLST_OPT_USE_DTYPE | (dtype<<16);
#endif
#else
	y->fp = stdin;
#endif
	y->line = 0;
	y->fname = "coal>";	/* prompt */
	y->fullname = "stdin";
	memset(&tleaf,0,sizeof(Leaf));

	scrptct->pFlag |= D_SCRPT_INTERACTIVE;
	rc = 0;
	for (;;) {
		ys->TopStack = NULL;
#if 1
		ys->TopTreeSave = leaf->leftleaf;
		leaf->leftleaf = NULL;
#else
		if (leaf->leftleaf) {
		/*	if (proc->Nextleaf == leaf->leftleaf) proc->Nextleaf = NULL;	*/
			cl_leaf_clear(leaf->leftleaf);
			leaf->leftleaf = NULL;
		}
#endif
	/*	printf("coal>");	*/
	/*	printf("Enter Command.\n");	*/
#if 1
		y->fname = "coal>";	/* prompt */
		if ((rc=cl_lex(y)) == -1) {
			printf("\n");
			break;
		}
		else if (!rc) {
			if (leafTop = search_top_leaf(y)) {
				cl_ret_leaf_push(proc,leaf);
				leaf->leftleaf = leafTop;
				proc->Nextleaf = leaf->leftleaf;
			}
			else rc = -1;
			ys->TopStack = NULL;
			break;
		}
	}
#else
		if ((rc=cl_lex(y)) == -1) break;
		else {
			if (leafTop = search_top_leaf(y)) {
				rc = cl_node_process(leafTop,proc);
				if (!rc && cmn_chk_stat(SCR_ED,&pCLprocTable->ScrSt) != L_OFF) break;
				if (!pGlobTable->error && cmn_chk_stat(RTN_PR | RET_PR,&proc->ptype)!=L_OFF) break;
			}
		}
	}
	printf("\n");
#endif
	scrptct->pFlag &= ~D_SCRPT_INTERACTIVE;
	y->option &= ~D_CLST_OPT_USE_DTYPE;
	ys->TopStack = NULL;
	return rc;
}
