static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************/
/*	<clprdef.c>										*/
/*		Define process								*/
/****************************************************/
#include "colmn.h"

extern condList CLcList;
extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern int giOptions[];
extern CLCOMMON  CLcommon;
extern char *ScopeNames[];
extern char *ScopeMarks[];
extern int  ScopeGXOpts[];
extern int  ScopeAUX1s[];
extern char *SysPubVars[];

static XHASHB *pha_vnames[D_MAX_SCOPE];
static tdtINFO_PARM ***pTBL_vnames[D_MAX_SCOPE];

/************************************/
/* _undef							*/
/************************************/
static int _undef(leaf,proc,prmp,scrct,ex_opt,iCONST)
Leaf    *leaf;
ProcCT  *proc;
parmList *prmp;
ScrPrCT *scrct;
int ex_opt,iCONST;
{
	static char *_name_="_undefine";
	XHASHB *pha_vname;
	int  i,k,rc,vnlen,n,*pSize,ixlen,iHASHED_NAME,opt,scope,ParmNo,aux1_opt;
	int i_like,i_not,iLIKE,iNOT;
	char c,*varnam,*p,*ixnam, buf[64],*hakey;
	tdtINFO_PARM *pInfoParm,tInfoParm;
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	tdtINFO_PARM ***pTBL_vname,***pTBL_pas,*pInfo;
	uchar ucLOCAL=0;
	Leaf *topleaf,*curleaf;

	varnam = prmp->prp;
	vnlen = prmp->prmlen;
/*
printf("%s:Enter ex_opt=%08x varnam=[%s]\n",_name_,ex_opt,varnam);
*/
		if (rc=cl_gx_exp_obj_opt(1,&prmp,proc->Obj,&tInfoParm,ex_opt)) {
			ERROROUT2(FORMAT(125),_name_,varnam);	/* %s: [%s]Ă܂B */
			return ECL_SCRIPT_ERROR;
		}
DEBUGOUT_InfoParm(120,"%s: get rc=%d",&tInfoParm,_name_,rc);
		if ((c=tInfoParm.pi_id) != D_DATA_ID_STOREVAR) {
			if (c == 'U') {
				ERROROUT2(FORMAT(438),_name_,varnam);	/* %s: [%s]͖`łB */
				rc = ECL_NDEFVAR_ERROR;
			}
			else {
				ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
				rc = ECL_SCRIPT_ERROR;
			}
			return rc;
		}
		ParmNo = tInfoParm.pi_hlen;
		pSize = (int *)tInfoParm.pi_paux;
/*
printf("%s: ParmNo=%d pSize=%08x\n",_name_,ParmNo,pSize);
*/
		pInfoParm = (tdtINFO_PARM *)tInfoParm.pi_pos;
#if 1	/* 2021.8.23 */
		opt = pInfoParm->pi_aux[1];
		if (opt & D_AUX1_HASHED_NAME) {
			if (!iCONST &&
				((tInfoParm.pi_aux[1] & D_AUX1_PROTECTED) ||
			     (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED))) {
				ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
				return ECL_SCRIPT_ERROR;
			}
#else
		if ((tInfoParm.pi_aux[1] & D_AUX1_PROTECTED) ||
		    (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED)) {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		opt = pInfoParm->pi_aux[1];
/*
printf("%s: opt=%08x varnam=[%s]\n",_name_,opt,varnam);
*/
		if (opt & D_AUX1_HASHED_NAME) {
#endif
#if 1
			pha_vname = NULL;
			scope = 0;
			for (i=D_MAX_SCOPE-1;i>=0;i--) {
				aux1_opt = ScopeAUX1s[i];
				scope |= aux1_opt;
				if (opt & aux1_opt) {
					pha_vname  = pha_vnames[i];
					pTBL_vname = pTBL_vnames[i];
					break;
				}
			}
#else
			if (opt & D_AUX1_GLOBAL_VAR) {
				pha_vname = pGLprocTable->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR;
				pTBL_vname = pGLprocTable->pTBL_vnam;
			}
			else if (opt & D_AUX1_PUBLIC_VAR) {
				pha_vname = pCLprocTable->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
				pTBL_vname = pCLprocTable->pTBL_vnam;
			}
			else if (opt & D_AUX1_LOCAL_VAR) {
				pha_vname = proc->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR | D_AUX1_LOCAL_VAR;
				pTBL_vname = proc->pTBL_vnam;
			}
			else {
				pha_vname = scrct->Vary->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
				pTBL_vname = scrct->Vary->pTBL_vnam;
			}
#endif
			if (pha_vname) {
#if 1
				rc = 0;
				if (ParmNo>0 && !pSize) {
					if ((rc=cl_gx_get_vnam(pha_vname,ParmNo,&p)) < 0) return rc;
					else if (rc > 0) {
						varnam = p;
						vnlen = strlen(varnam);
/*
printf("%s: rc=%d varnam=[%s]\n",_name_,rc,varnam);
*/
					}
				}
				if (!rc) {
					c = pInfoParm->pi_id;
					if (c=='R' || c=='A' || c=='T' || c=='P'/* || c=='L'*/) {
						varnam = (char *)pInfoParm->pi_pos;
						vnlen = strlen(varnam);
						if ((k=cl_get_struct_name_len(varnam)) < vnlen) {
							k++;
							varnam += k;
							vnlen -= k;
						}
/*
printf("%s: k=%d vnlen=%d varnam=[%s]\n",_name_,k,vnlen,varnam);
*/
					}
					else {
						if (*varnam == '$') {
							varnam++;
							vnlen--;
						}
/*
printf("%s: varnam=[%s]\n",_name_,varnam);
*/
					}
				}
#else
				c = pInfoParm->pi_id;
				if (c=='R' || c=='A' || c=='T' || c=='P'/* || c=='L'*/) {
					varnam = (char *)pInfoParm->pi_pos;
					vnlen = strlen(varnam);
					if ((k=cl_get_struct_name_len(varnam)) < vnlen) {
						k++;
						varnam += k;
						vnlen -= k;
					}
/*
printf("%s: k=%d vnlen=%d varnam=[%s]\n",_name_,k,vnlen,varnam);
*/
				}
				else {
					rc = 0;
					if (ParmNo>0 && !pSize) {
						if ((rc=cl_gx_get_vnam(pha_vname,ParmNo,&p)) < 0) return rc;
						else if (rc > 0) {
							varnam = p;
							vnlen = strlen(varnam);
/*
printf("%s: rc=%d varnam=[%s]\n",_name_,rc,varnam);
*/
						}
					}
					if (!rc) {
						if (*varnam == '$') {
							varnam++;
							vnlen--;
						}
					}
				}
#endif
				rc = cl_gx_chk_vnam_info('r',pha_vname,varnam,vnlen,&pInfo);
				if (rc <= 0) {
#if 0
					pSize = (int *)pTBL_vname[0];
					ParmNo = pSize[6];
					pha_vname->xha_xhix = ParmNo;
					k = akxs_xhash(pha_vname,'p',(char *)&hakey);
					if (k > 0) varnam = hakey;
					else {
#endif
						ERROROUT2(FORMAT(438),_name_,varnam);	/* %s: [%s]͖`łB */
					/*	ERROROUT2(FORMAT(446),_name_,varnam);*/	/* %s: %sUNDEFINEł܂B */
						return ECL_NDEFVAR_ERROR;
#if 0
					}
#endif
				}
				rc = cl_gx_chk_vnam('d',pha_vname,varnam,vnlen);

DEBUGOUTL4(120,"%s: opt=%08x delete name=[%s] ix=%d",_name_,opt,varnam,rc);

				if (rc > 0) {
					if ((c=*varnam)!='$' && c!='%' && c!='#') {
						p = buf;
						*buf = '$';
						memnzcpy(buf+1,varnam,vnlen,sizeof(buf));
					}
					else p = varnam;
					if ((scope & D_AUX1_LOCAL_VAR) && pInfoParm->pi_id==' ') {
						topleaf = proc->ProcTop->leftleaf;
						curleaf = NULL;
						if ((rc=cl_gx_clear_var_obj(topleaf,curleaf,p,proc->Obj,scope)) < 0) return rc;
					}
					else {
						topleaf = scrct->TreeTop;
						curleaf = leaf;
						if ((rc=cl_gx_clear_var_obj_all(scrct,curleaf,p,scope)) < 0) return rc;
					}
				}
			}
			else return -1;
		}
		else {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		cl_free_info_parm(pInfoParm);
DEBUGOUT_InfoParm(120,"%s: FreeInfo",pInfoParm,_name_,0);
	return 0;
}

/************************************/
/* _get_scope_varnam				*/
/************************************/
static int _get_scope_varnam(iScope,var)
int iScope;
tdtGENERAL_DATA *var;
{
	static char *_name_="_get_scope_varnam";
	int vnlen,len,scope;
	char *varnam,word[16],*p;
	SSPL_S ssp;

	varnam = var->gd_data;
	vnlen  = var->gd_dlen;
	scope = 0;
	memset(&ssp,0,sizeof(SSPL_S));
	if ((len=akxtgwnsl(varnam,vnlen,&ssp," \t",1)) > 0) {
		memnzcpy(word,ssp.wd,len,sizeof(word));
		if (scope = cl_get_def_scope(word)) {
/*
printf("%s: scope=%08x\n",_name_,scope);
*/
			len = akxtgwnsl(varnam,vnlen,&ssp," \t",1);
		}
	}
	if (len >= 0) {
		if (varnam!=ssp.wd || vnlen!=len) {
			if (!(p = cl_tmp_const_malloc(len+1))) len = ECL_MALLOC_ERROR;
			else {
				memzcpy(p,ssp.wd,len);
				var->gd_data = p;
				var->gd_dlen = len;
			}
		}
		if (!scope) scope = iScope;
		var->gd_resv = scope;
	}
	return len;
}

/************************************/
/* _like_undef						*/
/************************************/
static int _like_undef(leaf,proc,prmp,scrct,ex_opt,iLIKE,iScope,iCONST)
Leaf    *leaf;
ProcCT  *proc;
parmList *prmp;
ScrPrCT *scrct;
int ex_opt,iLIKE,iScope,iCONST;
{
	static char *_name_="_like_undef";
	int rc,vnlen,len,scope,m,i,k,ix,opt,*scopea[1],*ps;
	char c,*varnam,*p,*key;
	parmList tPrmp;
	XHASHB *pha_vname,*pha_undef;
	tdtGENERAL_DATA var;

	varnam = prmp->prp;
	vnlen = prmp->prmlen;

	var.gd_data = varnam;
	var.gd_dlen = vnlen;
	var.gd_resv = 0;
	len = _get_scope_varnam(iScope,&var);
	if (len <= 0) {
		ERROROUT1(FORMAT(435),_name_);	/* %s: ϐ܂B*/
		return ECL_SCRIPT_ERROR;
	}
	varnam = var.gd_data;
	vnlen = len;
	scope  = var.gd_resv;
/*
printf("%s: vnlen=%d varnam=[%s]\n",_name_,vnlen,varnam);
*/
	if ((c=*varnam) == '$') {
		varnam++;
		vnlen--;
	}
	else if (c == '#') {
		ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
		return ECL_SCRIPT_ERROR;
	}
	opt = 0;
	if (iLIKE & 0x02) opt = 1;
	if (iLIKE & 0x04) opt |= 2;
/*
printf("%s: opt=%02x\n",_name_,opt);
*/
	if (scope) {
		if ((i=akxs_iseq(ScopeGXOpts,D_MAX_SCOPE,scope)) <= 0) return -1;
		pha_vname = pha_vnames[i-1];
		m = akxs_xhash2(pha_vname,'M',NULL,NULL);
/*
printf("%s: scope=%08x %s m=%d \n",_name_,scope,cl_get_scope_name_from_opt(scope),m);
*/
		for (i=1;i<=m;i++) {
			pha_vname->xha_xhix = i;
			if ((ix=akxs_xhash2(pha_vname,'P',&key,NULL)) < 0) return k;
			else if (ix > 0) {
/*
printf("%s: i=%d k=%d key=[%s]\n",_name_,i,ix,key);
*/
				len = strlen(key);
/*
printf("%s: i=%d len=%d key=[%s] vnlen=%d varnam=[%s]\n",_name_,i,len,key,vnlen,varnam);
*/
				if ((rc=akxs_xlike(key,len,varnam,vnlen,opt)) < 0) return rc;
				else if (!rc) {
					if (scope & D_GX_OPT_SET_PUBLIC) {
						if ((rc=akxs_seqr_str(SysPubVars,-1,key,0)) < 0) return rc;
					}
					else rc = 0;
					if (!rc) {
						if (len<=3 || memcmp(key,"<I>",3)) {
							tPrmp.prp = key;
							tPrmp.prmlen = len;
							tPrmp.opt = D_GX_OPT_NO_USE_OBJ;
							rc = _undef(leaf,proc,&tPrmp,scrct,ex_opt|scope,iCONST);
						}
					}
				}
/*
printf("%s: i=%d rc=%d\n",_name_,i,rc);
*/
			}
		}
	}
	else {
		pha_undef = akxs_xhash_new2(0,16,13,sizeof(int));
		for (k=D_MAX_SCOPE-1;k>=0;k--) {
			pha_vname = pha_vnames[k];
			m = akxs_xhash2(pha_vname,'M',NULL,NULL);
			scope = ScopeGXOpts[k];
/*
printf("%s: k=%d scope=%08x %s m=%d \n",_name_,k,scope,cl_get_scope_name_from_opt(scope),m);
*/
			for (i=1;i<=m;i++) {
				pha_vname->xha_xhix = i;
				ps = &scope;
				if ((ix=akxs_xhash2(pha_vname,'P',&key,NULL)) < 0) return ix;
				else if (ix > 0) {
/*
printf("%s: i=%d k=%d key=[%s]\n",_name_,i,ix,key);
*/
					len = strlen(key);
/*
printf("%s: i=%d len=%d key=[%s] vnlen=%d varnam=[%s]\n",_name_,i,len,key,vnlen,varnam);
*/
					if ((rc=akxs_xlike(key,len,varnam,vnlen,opt)) < 0) return rc;
					else if (!rc) {
						if (scope & D_GX_OPT_SET_PUBLIC) {
							if ((rc=akxs_seqr_str(SysPubVars,-1,key,0)) < 0) return rc;
						}
						else rc = 0;
						if (!rc) akxs_xhash2(pha_undef,'S',key,ps);
					}
				}
			}
		}
		m = akxs_xhash2(pha_undef,'M',NULL,NULL);
/*
printf("%s:undef var m=%d\n",_name_,m);
*/
		for (i=1;i<=m;i++) {
			pha_undef->xha_xhix = i;
			if ((k=akxs_xhash2(pha_undef,'P',&key,&ps)) < 0) return k;
			else if (k > 0) {
				scope = *ps;
/*
printf("%s:undef var i=%d k=%d scope=%08x key=[%s]\n",_name_,i,k,scope,key);
*/
				len = strlen(key);
				if (len<=3 || memcmp(key,"<I>",3)) {
					tPrmp.prp = key;
					tPrmp.prmlen = len;
					tPrmp.opt = D_GX_OPT_NO_USE_OBJ;
					rc = _undef(leaf,proc,&tPrmp,scrct,ex_opt|scope,iCONST);
/*
printf("%s:undef var i=%d rc=%d\n",_name_,i,rc);
*/
				}
			}
		}
		akxs_xhash_free(pha_undef);
	}
	return 0;
}

int _match_var(scope,key,var_list,used_var_list)
int scope,used_var_list;
char *key;
tdtGENERAL_DATA *var_list[];
{
	static char *_name_="_match_var";
	int rc,vnlen,len,i,opt,match,iLIKE,var_scope;
	char *varnam;
	tdtGENERAL_DATA *var;
/*
printf("%s: scope=%08x used_var_list=%d key=[%s] \n",_name_,scope,used_var_list,key);
*/
	match = 0;
	len = strlen(key);
	for (i=0;i<used_var_list;i++) {
		var = var_list[i];
		varnam = var->gd_data;
		vnlen  = var->gd_dlen;
		var_scope = var->gd_resv;
		opt = 0;
		iLIKE = var->gd_id;
		if (iLIKE & 0x02) opt = 1;
		if (iLIKE & 0x04) opt |= 2;
/*
printf("%s: i=%d opt=%02x var_scope=%08x vnlen=%d varnam=[%s]\n",_name_,i,opt,var_scope,vnlen,varnam);
*/
		if (iLIKE) rc = akxs_xlike(key,len,varnam,vnlen,opt);
		else if (rc = strcmp(key,varnam)) rc = 1;
		if (!rc) {
			if (var_scope && scope!=var_scope) rc = 1;
		}
		if (rc < 0) match = rc;
		else if (!rc) match = 1;
/*
printf("%s: i=%d match=%d\n",_name_,i,match);
*/
		if (match) break;
	}
	return match;
}

/************************************/
/* _not_undef						*/
/************************************/
static int _not_undef(leaf,proc,var_list,used_var_list,scrct,ex_opt,iScope,iCONST)
Leaf    *leaf;
ProcCT  *proc;
tdtGENERAL_DATA *var_list[];
ScrPrCT *scrct;
int used_var_list,ex_opt,iScope,iCONST;
{
	static char *_name_="_not_undef";
	int rc,vnlen,len,scope,m,i,k,ix,opt;
	char c,*varnam,*key;
	XHASHB *pha_vname;
	parmList tPrmp;
	tdtGENERAL_DATA *var;
/*
printf("%s:Enter used_var_list=%d\n",_name_,used_var_list);
*/
	for (i=0;i<used_var_list;i++) {
		var = var_list[i];
		len = _get_scope_varnam(iScope,var);
		if (len <= 0) {
			ERROROUT1(FORMAT(435),_name_);	/* %s: ϐ܂B*/
			return ECL_SCRIPT_ERROR;
		}
	}
	for (k=0;k<D_MAX_SCOPE;k++) {
		scope = ScopeGXOpts[k];
/*
printf("%s: k=%d scope=%08x\n",_name_,k,scope);
*/
		if (iScope && !(scope & iScope)) continue;

		pha_vname = pha_vnames[k];
		m = akxs_xhash2(pha_vname,'M',NULL,NULL);
/*
printf("%s: k=%d m=%d \n",_name_,k,m);
*/
		for (i=1;i<=m;i++) {
			pha_vname->xha_xhix = i;
			if ((ix=akxs_xhash2(pha_vname,'P',&key,NULL)) < 0) return ix;
			else if (ix > 0) {
/*
printf("%s: i=%d k=%d key=[%s]\n",_name_,i,ix,key);
*/
				if (scope & D_GX_OPT_SET_PUBLIC) {
					if ((rc=akxs_seqr_str(SysPubVars,-1,key,0)) < 0) return rc;
				}
				else rc = 0;
				if (!rc) {
					if ((rc=_match_var(scope,key,var_list,used_var_list)) < 0) return rc;
					else if (!rc) {
						len = strlen(key);
						if (len<=3 || memcmp(key,"<I>",3)) {
							tPrmp.prp = key;
							tPrmp.prmlen = len;
							tPrmp.opt = D_GX_OPT_NO_USE_OBJ;
							rc = _undef(leaf,proc,&tPrmp,scrct,ex_opt|scope,iCONST);
/*
printf("%s:undef var i=%d rc=%d\n",_name_,i,rc);
*/
						}
					}
				}
			}
		}
	}
	return 0;
}

/************************************/
/* cl_pr_ex_un_define				*/
/************************************/
int cl_pr_ex_un_define(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	static char *_name_="cl_pr_ex_un_define";
	int i,rc,vnlen,n,ex_opt,pos;
	int i_like,i_not,iLIKE,iNOT,max_var_list,used_var_list,iCONST,iScope,scope;
	char c,*varnam;
	ScrPrCT *scrct;
	parmList **pprmp;
	tdtGENERAL_DATA *var,**var_list,**var_list2;

	if (!leaf || !proc) return ECL_SYSTEM_ERROR;
	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;

	pha_vnames[0] = proc->pha_vnam;
	pha_vnames[1] = scrct->Vary->pha_vnam;
	pha_vnames[2] = pCLprocTable->pha_vnam;
	pha_vnames[3] = pGLprocTable->pha_vnam;

	pTBL_vnames[0] = proc->pTBL_vnam;
	pTBL_vnames[1] = scrct->Vary->pTBL_vnam;
	pTBL_vnames[2] = pCLprocTable->pTBL_vnam;
	pTBL_vnames[3] = pGLprocTable->pTBL_vnam;

	ex_opt = D_GX_OPT_GET_ADDR | D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;	/* 2021.1.15 */
	n = leaf->cmd.prmnum;
	pprmp = leaf->cmd.prmp;
	i_not = i_like = -1;
	iScope = iCONST = iLIKE = iNOT = 0;
	var_list = NULL;
	rc = max_var_list = used_var_list = 0;
	for (i=0;i<n;i++) {
		varnam = pprmp[i]->prp;
		vnlen  = pprmp[i]->prmlen;
#if 1	/* 2021.8.20 */
/*
printf("%s: varnam=[%s] vnlen=%d\n",_name_,varnam,vnlen);
*/
		rc = 0;
		if (!stricmp(varnam,"LIKE")) {
			if (i_like == i) rc = ECL_SCRIPT_ERROR;
			else {
				i_like = i + 1;
				iLIKE = 1;
/*
printf("%s: %s iNOT=%02x iLIKE=%02x\n",_name_,varnam,iNOT,iLIKE);
*/
				continue;
			}
		}
		else if (!stricmp(varnam,"iLIKE") || !stricmp(varnam,"zLIKE") || !stricmp(varnam,"izLIKE")) {
			if (i_like == i) rc = ECL_SCRIPT_ERROR;
			else {
				iLIKE = 1;
				if ((c=akxcupper(*varnam)) == 'I') iLIKE |= 2;
				if (c=='Z' || akxcupper(*(varnam+1))=='Z') iLIKE |= 4;
				i_like = i + 1;
/*
printf("%s: %s iNOT=%02x iLIKE=%02x\n",_name_,varnam,iNOT,iLIKE);
*/
				continue;
			}
		}
		else if (!stricmp(varnam,"NOT")) {
			iLIKE = 0;
			if (iNOT) {
				iNOT = 0;
				if (used_var_list > 0) {
					if ((rc=_not_undef(leaf,proc,var_list,used_var_list,scrct,ex_opt,iScope,iCONST)) < 0) {
						if (rc != ECL_NDEFVAR_ERROR) break;
						rc = 0;
					}
				}
/*
printf("%s: %s iNOT=%02x iLIKE=%02x\n",_name_,varnam,iNOT,iLIKE);
*/
			}
			else {
				if (!var_list) {
					max_var_list = 32;
					if (!(var_list=(tdtGENERAL_DATA **)cl_tmp_const_malloc(max_var_list*sizeof(tdtGENERAL_DATA *)))) return ECL_MALLOC_ERROR;
					used_var_list = 0;
				}
				iNOT = 1;
/*
printf("%s: %s iNOT=%02x iLIKE=%02x\n",_name_,varnam,iNOT,iLIKE);
*/
			}
			continue;
		}
		else if (!stricmp(varnam,"CONST")) {
			iCONST = 1;
			continue;
		}
		else if (scope = cl_get_def_scope(varnam)) {
			iScope = scope;
			continue;
		}
		if (rc < 0) {
			ERROROUT2(FORMAT(469),_name_,varnam);	/* %s: \"%s\"̈ʒusłB*/
			rc = ECL_SCRIPT_ERROR;
			break;
		}
		else {
			if (!iLIKE && akxnskipto(varnam,vnlen,"%[-]")<vnlen) {
				/* %s: [i][z]LIKEwȂLIKEp^[(%s)͎wł܂B*/
				ERROROUT2(FORMAT(623),_name_,varnam);
				rc = ECL_SCRIPT_ERROR;
				break;
			}
			else if (iNOT) {
				if (!(var = (tdtGENERAL_DATA *)cl_tmp_const_malloc(sizeof(tdtGENERAL_DATA)))) {
					rc = ECL_MALLOC_ERROR;
					break;
				}
				var->gd_data = varnam;
				var->gd_dlen = vnlen;
				var->gd_id = iLIKE;
				if (used_var_list >= max_var_list) {
					max_var_list += 32;
					if (!(var_list2=(tdtGENERAL_DATA **)cl_tmp_const_malloc(max_var_list*sizeof(tdtGENERAL_DATA *)))) {
						rc = ECL_MALLOC_ERROR;
						break;
					}
					mem_cpy_addr(var_list2,var_list,used_var_list); 
					var_list = var_list2;
				}
				var_list[used_var_list++] = var;
/*
printf("%s: %s used_var_list=%d\n",_name_,varnam,used_var_list);
*/
			}
			else if (iLIKE) rc = _like_undef(leaf,proc,pprmp[i],scrct,ex_opt,iLIKE,iScope,iCONST);
			else rc = _undef(leaf,proc,pprmp[i],scrct,ex_opt|iScope,iCONST);
			if (rc == ECL_NDEFVAR_ERROR) rc = 0;
			else if (rc < 0) break;
		}
#else
		if (rc=cl_gx_exp_obj_opt(1,&pprmp[i],proc->Obj,&tInfoParm,ex_opt)) {
			ERROROUT2(FORMAT(125),_name_,varnam);	/* %s: [%s]Ă܂B */
			return ECL_SCRIPT_ERROR;
		}
DEBUGOUT_InfoParm(120,"%s: get rc=%d",&tInfoParm,_name_,rc);
		if ((c=tInfoParm.pi_id) != D_DATA_ID_STOREVAR) {
			if (c == 'U') ERROROUT2(FORMAT(438),_name_,varnam);	/* %s: [%s]͖`łB */
			else ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		pInfoParm = (tdtINFO_PARM *)tInfoParm.pi_pos;
		if ((tInfoParm.pi_aux[1] & D_AUX1_PROTECTED) ||
		    (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED)) {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		vnlen = pprmp[i]->prmlen;
		opt = pInfoParm->pi_aux[1];
/*
printf("%s: opt=%08x varnam=[%s]\n",_name_,opt,varnam);
*/
		if (opt & D_AUX1_HASHED_NAME) {
			if (opt & D_AUX1_GLOBAL_VAR) {
				pha_vname = pGLprocTable->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR;
				pTBL_vname = pGLprocTable->pTBL_vnam;
			}
			else if (opt & D_AUX1_PUBLIC_VAR) {
				pha_vname = pCLprocTable->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
				pTBL_vname = pCLprocTable->pTBL_vnam;
			}
			else if (opt & D_AUX1_LOCAL_VAR) {
				pha_vname = proc->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR | D_AUX1_LOCAL_VAR;
				pTBL_vname = proc->pTBL_vnam;
			}
			else {
				pha_vname = scrct->Vary->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
				pTBL_vname = scrct->Vary->pTBL_vnam;
			}
			if (pha_vname) {
				c = pInfoParm->pi_id;
				if (c=='R' || c=='A' || c=='T' || c=='P'/* || c=='L'*/) {
					varnam = (char *)pInfoParm->pi_pos;
					vnlen = strlen(varnam);
					if ((k=cl_get_struct_name_len(varnam)) < strlen(varnam)) varnam += k+1;
				}
				else if (*varnam == '$') {
					varnam++;
					vnlen--;
				}
				rc = cl_gx_chk_vnam('r',pha_vname,varnam,vnlen);
				if (rc <= 0) {
					pSize = (int *)pTBL_vname[0];
					ParmNo = pSize[6];
					pha_vname->xha_xhix = ParmNo;
					k = akxs_xhash(pha_vname,'p',(char *)&hakey);
					if (k > 0) varnam = hakey;
					else {
						ERROROUT2(FORMAT(438),_name_,varnam);	/* %s: [%s]͖`łB */
					/*	ERROROUT2(FORMAT(446),_name_,varnam);*/	/* %s: %sUNDEFINEł܂B */
						return ECL_SCRIPT_ERROR;
					}
				}
				rc = cl_gx_chk_vnam('d',pha_vname,varnam,vnlen);
/*
printf("%s: delete name=[%s] ix=%d\n",_name_,varnam,rc);
*/
				if (rc > 0) {
					if ((c=*varnam)!='$' && c!='%' && c!='#') {
						p = buf;
						*buf = '$';
						memnzcpy(buf+1,varnam,vnlen,sizeof(buf));
					}
					else p = varnam;
					if ((scope & D_AUX1_LOCAL_VAR) && pInfoParm->pi_id==' ') {
						topleaf = proc->ProcTop->leftleaf;
						curleaf = NULL;
						if ((rc=cl_gx_clear_var_obj(topleaf,curleaf,p,proc->Obj,scope)) < 0) return rc;
					}
					else {
						topleaf = scrct->TreeTop;
						curleaf = leaf;
						if ((rc=cl_gx_clear_var_obj_all(scrct,curleaf,p,scope)) < 0) return rc;
					}
				}
			}
		}
		else {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		cl_free_info_parm(pInfoParm);
DEBUGOUT_InfoParm(120,"%s: FreeInfo",pInfoParm,_name_,0);
#endif
	}
/*
printf("%s: rc=%d\n",_name_,rc);
*/
	if (!rc && used_var_list>0) {
		rc = _not_undef(leaf,proc,var_list,used_var_list,scrct,ex_opt,iScope,iCONST);
		if (rc == ECL_NDEFVAR_ERROR) rc = 0;
	}
	return rc;
}
