static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************
*																		*
*	ړI	F t												*
*																		*
*	Tv	F 														*
*																		*
*************************************************************************/
#include <colmn.h>

extern CLCOMMON  CLcommon;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
char *cl_get_date_format()
{
	tdtINFO_PARM *pInfoParm;
	char *p,*pp,w[16];
	int  len;

	if (pGlobTable->options[18] & 0x01) {
		p = D_NAM_UNX_DATE_FORMAT;
		pp = D_UNX_DATE_FORMAT;
	}
	else {
		p = D_NAM_SQL_DATE_FORMAT;
		pp = D_SQL_DATE_FORMAT;
	}

	if (pInfoParm = cl_get_public_var(p)) {
		pp = w;
		if ((len=parm_to_char(pInfoParm,&pp,NULL)) < 0) return NULL;
	}
	return pp;
}

/****************************************/
/*										*/
/****************************************/
static int _func_set_date_part(pInfoParmW,p1,len1,nparm,ppParm,ma)
tdtINFO_PARM *pInfoParmW;
char *p1;
int  len1,nparm;
tdtINFO_PARM *ppParm[];
MPA *ma;
{
	int  rc,len,uxflg;
	char w2[16],*p2,date[20];
	struct tm stm,*ptm;
	time_t tt;

	uxflg = 1;
	rc = -1;
	if (nparm >= 1) {
		p2 = w2;
		if ((len = parm_to_char(ppParm[0],&p2,NULL))<0) {
			return len;
		}
		else if (!*p2) p2 = cl_get_date_format();
	}
	else {
		p2 = cl_get_date_format();
	}
	if (!p2) return -1;
	len = strlen(p2);
 	rc = akxs_in_mem_opt(p2,len,"%",1,0);
/*
printf("_func_set_date_part: len=%d rc=%d\n",len,rc);
*/
	if (!rc) uxflg = 0;	/* p2 = _uxformat(p2,len);	*/

	if (uxflg) {
		tt = time(NULL);
		if (!(ptm = localtime(&tt))) return ECL_SCRIPT_ERROR;
		if (strptime(p1,p2,ptm))
/*
akxaxdump("_func_set_date_part: stm",&stm,sizeof(DATE));
*/
			rc = akxc_tm2mpa(ma,ptm);
		else rc = -1;
	}
	else rc = akxc_str2date(p1,len1,p2,len,ma);
	if (rc < 0) {
		return rc;
	}
/*
akxaxdump("_func_set_date_part: ma",ma,sizeof(MPA));
*/
	cl_set_parm_date(pInfoParmW,ma);
DEBUGOUT_InfoParm(151,"_func_set_date_part:",pInfoParmW,0,0);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_to_date(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	MPA maz,*ma;
	int  len1,rc,code_type;
	char w1[16],*p1,date[20];

	code_type = cl_get_char_code_type(ppParm[0],1);
	p1 = w1;
	if ((len1=parm_to_char(ppParm[0],&p1,NULL)) < 0) {
		return len1;
	}
	if (nparm < 2) {
		rc = akxc_chk_date_type(date,p1,code_type);	/* YYYY/MM/DD HH:MI:SS */
/*
printf("cl_func_to_date: rc=%d\n",rc);
*/
		if (rc < 0) return rc;
/*
printf("cl_func_to_date: rc=%x date=[%s]\n",rc,date);
*/
		if (rc & 0x01) date[ 4] = '/';
		if (rc & 0x02) date[ 7] = '/';
		if (rc & 0x04) date[13] = ':';
		if (rc & 0x08) date[16] = ':';
/*
printf("cl_func_to_date: date=[%s]\n",date);
*/
		p1 = date;
		len1 = strlen(p1);
	}
	ma = (MPA *)cl_get_tmpMPA(&maz);
	clgetsysdate(ma);
	ma->num[D_LEN_DATE] = 1;
	return _func_set_date_part(pInfoParmW,p1,len1,nparm-1,ppParm+1,ma);
}

/****************************************/
/*										*/
/****************************************/
int cl_func_set_date_part(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	MPA maz,*ma;
	int ret,len1;
	char w1[16],*p1;
	long t1;

	ma = (MPA *)cl_get_tmpMPA(&maz);
	ret = cl_get_parm_date(ppParm[0],ma,"cl_func_set_part_date");
/*
printf("cl_func_set_date_part: ret=%d\n",ret);
*/
	if (!ret) {
		p1 = w1;
		if ((len1=parm_to_char(ppParm[1],&p1,NULL)) < 0) return len1;
		ma->num[D_LEN_DATE] = 0;
		ret = _func_set_date_part(pInfoParmW,p1,len1,nparm-2,ppParm+2,ma);
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_to_char(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	int  rc,len,uxflg,len2;
	char *p1,*p2;
	tdtINFO_PARM *pParm;
	char *pWork;
	int pre;

	pre = 0;
	uxflg = 1;
	rc = -1;
	p1 = NULL;
	pParm = ppParm[0];
/*
printf("cl_func_to_char: nparm=%d attr=%d\n",nparm,pParm->pi_attr);
*/
	if (pParm->pi_attr == DEF_ZOK_DATE) {
		if (nparm >= 2) {
			if ((len = parm_to_char(ppParm[1],&p1,NULL))<0) {
				return len;
			}
			else if (!*p1) p1 = cl_get_date_format();
		}
		else p1 = cl_get_date_format();
		len = strlen(p1);
		if (!p1) return -1;
 		rc = akxs_in_mem_opt(p1,len,"%",1,0);
/*
printf("cl_func_to_char: len=%d rc=%d\n",len,rc);
*/
		if (!rc) uxflg = 0;
		len2 = strlen(p1);
		len2 = len2*2 + 4;
		if (!(p2 = cl_tmp_const_malloc(len2+1))) return -1;
		if (uxflg) akxc_date2uxstr(p2,len2,p1,pParm->pi_data);
		else akxc_date2str(p2,len2,p1,len,pParm->pi_data);
		len2 = strlen(p2);
	}
	else {
		if ((len2 = parm_to_char(pParm,&p1,NULL))<0) {
			return len2;
		}
		p2 = p1;
/*
printf("cl_func_to_char: len2=%d p2=[%s]\n",len2,p2);
*/
		if (nparm >= 2) {
			if (rc = cl_get_parm_bin(ppParm[1],&pre,"to_char.p2")) return rc;
			if (pre < 0) {
				/* %s: x(%d)Ă܂B */
				ERROROUT2(FORMAT(464),"cl_func_to_char",pre);
				return ECL_SCRIPT_ERROR;
			}
			else if (pre > 0) {
				if (pre <= len2) {
					*(p2+pre) = '\0';
				}
				else {
					if (!(p2 = cl_tmp_const_malloc(pre+1))) return -1;
					memcpy(p2,p1,len2);
					memset(p2+len2,' ',pre-len2);
					*(p2+pre)='\0';
				}
				len2 = pre;
			}
		}
	}
/*
printf("cl_func_to_char: len2=%d p2=[%s]\n",len2,p2);
*/
	cl_set_parm_char(pInfoParmW,p2,len2);
	if (pre > 0) {
		pInfoParmW->pi_len = pre;
		pInfoParmW->pi_aux[0] = DEF_ZOK_CHAR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_date(pInfoParmW,ma,msg)
tdtINFO_PARM *pInfoParmW;
MPA *ma;
char *msg;
{
	int  attr,size,rc;
	time_t tt;
	long lValue;
	struct  tm *stm;
	tdtINFO_PARM tInfoParm;

	if (!pInfoParmW || !ma) return -1;
	if (!msg) msg="";

	attr = pInfoParmW->pi_attr;
	size = pInfoParmW->pi_dlen;
	if (attr == DEF_ZOK_DATE) {
		memcpy(ma,pInfoParmW->pi_data,size);
	}
	else if (attr == DEF_ZOK_CHAR) {
		if (rc=cl_func_to_date(&tInfoParm,1,&pInfoParmW)) return rc;
		memcpy(ma,tInfoParm.pi_data,sizeofMPA());
	}
	else {
		if ((rc=cl_get_parm_long(pInfoParmW,&lValue,msg)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		tt = lValue;
		stm = localtime(&tt);
		akxc_tm2mpa(ma,stm);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_parm_date(pInfoParmW,ma)
tdtINFO_PARM *pInfoParmW;
MPA *ma;
{
	int rc;

	if (!pInfoParmW || !ma) return -1;
	rc = cl_set_parm_mpa(pInfoParmW,ma);
	pInfoParmW->pi_attr = DEF_ZOK_DATE;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int get_time_intval(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	int  rc,len,m,code_type;
	char *p1,c1,wrk[5];
	long lValue;

	if (pInfoParm->pi_attr == DEF_ZOK_CHAR) {
		code_type = cl_get_char_code_type(pInfoParm,1);
		p1 = pInfoParm->pi_data;
		len = pInfoParm->pi_dlen;
		m = akxqmbsnlen(code_type,p1,len);
	  if (m == 1) {
		rc = atoi(p1);
		if (rc) return rc;
		len = X_MIN(len,4);
		akxcuppern(wrk,p1,len);
		c1 = wrk[0];
		if (c1=='M' && wrk[1]=='I') c1 = 'N';
		/* 2018.7.22 */
		if (c1 == 'Y') rc = 1;
		else if (c1 == 'M') rc = 2;
		else if (c1 == 'D') rc = 3;
		else if (c1 == 'W') rc = 8;
		else if (c1 == 'H') rc = 4;
		else if (c1 == 'N') rc = 5;
		else if (c1 == 'S') rc = 6;
		else if (c1 == 'Q') rc = 7;
	  }
	  else rc = 0;
	}
	else {
		if ((rc=cl_get_parm_long(pInfoParm,&lValue,"get_time_intval")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		rc = lValue;
	}
/*
printf("get_time_intval: rc=%d\n",rc);
*/
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_term_index(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	return get_time_intval(pInfoParm);
}

/****************************************/
/*										*/
/****************************************/
static int _func_add_to_date(pInfoParmW,nparm,ppParm,iDATE,iINTVAL,iADD)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
int iDATE,iINTVAL,iADD;
{
	int  rc,n;
	struct tm stm,*ptm;
	time_t tt;
	MPA  maz,*ma;
	long lValue;

	if ((n=get_time_intval(ppParm[iINTVAL])) < 0) return n;
	else if (!n) return ECL_SCRIPT_ERROR;

	if ((rc=cl_get_parm_long(ppParm[iADD],&lValue,"date_add")) < 0) return rc;
	else if (rc > 0) return ECL_SCRIPT_ERROR;
/*
printf("cl_func_date_add: lValue=%d\n",lValue);
*/
	ma = (MPA *)cl_get_tmpMPA(&maz);
	if (rc=cl_get_parm_date(ppParm[iDATE],ma,"date_add")) return rc;

	if (rc=akxc_date_add(ma,lValue,n)) return rc;

	rc = cl_set_parm_date(pInfoParmW,ma);
DEBUGOUT_InfoParm(151,"cl_date_add: rc=%d",pInfoParmW,rc,0);
	return rc;
}

/****************************************/
/*result = DATE_ADD(ԊԊu̕, l, t) */
/*										*/
/****************************************/
int cl_func_date_add(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	return _func_add_to_date(pInfoParmW,nparm,ppParm,2,0,1);
}

/****************************************/
/*result = ADD_TO_DATE(t, ԊԊu̕, l) */
/*										*/
/****************************************/
int cl_func_add_to_date(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	return _func_add_to_date(pInfoParmW,nparm,ppParm,0,1,2);
}

/****************************************/
/*										*/
/****************************************/
int cl_func_date_diff(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	int rc,n,n0;
	MPA ma1z,ma2z,*ma,*ma1,*ma2;
#if 1	/* 2018.7.23 */
	double tt,d;
#else
	time_t tt;
#endif
/*
result = date_diff ( ԊԊu̕, t1, t2 )
*/
	if ((n0=get_time_intval(ppParm[0])) < 0) return n;
	else if (!n0) return ECL_SCRIPT_ERROR;

	ma1 = (MPA *)cl_get_tmpMPA(&ma1z);
	ma2 = (MPA *)cl_get_tmpMPA(&ma2z);
	if (rc=cl_get_parm_date(ppParm[1],ma1,"date_diff1")) return rc;
	if (rc=cl_get_parm_date(ppParm[2],ma2,"date_diff2")) return rc;

	if ((n=n0) == 7) n = 2;
	else if (n == 8) n = 3;
	rc = akxc_date_diff_sub(&tt,n,ma1,ma2);
#if 1	/* 2018.7.23 */
	if (n0 >= 7) {
		if (n0 == 7) d = 3.0;
		else d = 7.0;
		tt /= d;
	}
	cl_set_parm_double(pInfoParmW,tt);
#else
	if (n0 <= 6) {
		cl_set_parm_long(pInfoParmW,tt);
	}
	else {
		m_l2mpa(tt,&ma1);
		if (n0 == 7) ma = m_get_i(3);
		else ma = m_get_i(7);
		m_div(&ma2,&ma1,ma);
		cl_set_parm_mpa(pInfoParmW,&ma2);
	}
#endif
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_add_months(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	tdtINFO_PARM *ppParmW[3],tInfoParm;
/*
result = add_months(t, )
*/
	cl_set_parm_char(&tInfoParm,"M",1);
	ppParmW[0] = &tInfoParm;
	ppParmW[1] = ppParm[1];
	ppParmW[2] = ppParm[0];
	return cl_func_date_add(pInfoParmW,3,ppParmW);
}

/****************************************/
/*										*/
/****************************************/
int cl_func_last_day(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	int  rc,m,d;
	MPA  maz,*ma;
/*
result = add_months(t, )
*/
	ma = (MPA *)cl_get_tmpMPA(&maz);
	if (rc=cl_get_parm_date(ppParm[0],ma,"last_day")) return rc;
	ma->num[3] = akxc_days_of_month(ma->num[0]*100 + ma->num[1],ma->num[2]);
	ma->num[4] = ma->num[5] = ma->num[6] = 0;
	return cl_set_parm_date(pInfoParmW,ma);
}

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_date(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtINFO_PARM *pInfoParmW,*pInfoParm1,*pInfoParm2;
char *pOperator;
{
	char *_fn_="cl_cmpt_date";
	int    rc,atr1,atr2,exception_save;
	long   lValue;
	char   op;
	double dtt;
	MPA    maz,*pma1,*pma2,*ma;
	tdtINFO_PARM *pInfo1,*pInfo2;
	DATE   stm,*ptm;
	time_t tt1,tt2,tt;

	exception_save = pGlobTable->exception;
	pGlobTable->exception = MATH_ETC_ERROR_EXCEPTION;
	op = *pOperator;
	if (op!='+' && op!='-') {
		ERROROUT2(FORMAT(238),_fn_,pOperator);	/* %s: Z(%s)͎gpł܂B*/
		return ECL_SCRIPT_ERROR;
	}
	atr1 = pInfoParm1->pi_attr;
	atr2 = pInfoParm2->pi_attr;
	if (atr1==DEF_ZOK_DATE && atr2==DEF_ZOK_DATE) {
		if (op != '-') {
			ERROROUT2(FORMAT(238),_fn_,pOperator);	/* %s: Z(%s)͎gpł܂B*/
			return ECL_SCRIPT_ERROR;
		}
		rc = akxc_date_diff_sub(&dtt,3,pInfoParm1->pi_data,pInfoParm2->pi_data);
		cl_set_parm_double(pInfoParmW,dtt);
	}
	else {
		if (atr1 != DEF_ZOK_DATE) {
			pInfo1 = pInfoParm2;
			pInfo2 = pInfoParm1;
		}
		else if (atr2 != DEF_ZOK_DATE) {
			pInfo1 = pInfoParm1;
			pInfo2 = pInfoParm2;
		}
		else {
			return ECL_SCRIPT_ERROR;
		}
		if ((rc=cl_get_parm_long(pInfo2,&lValue,"date_math")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		ma = (MPA *)cl_get_tmpMPA(&maz);
		memcpy(ma,pInfo1->pi_data,sizeofMPA());
		akxc_mpa2tm(&stm,ma);
		if (op == '+') stm.tm_mday += lValue;		/*  */
		else           stm.tm_mday -= lValue;		/*  */
		tt1 = mktime(&stm);
		if (!(ptm = localtime(&tt1))) return ECL_SCRIPT_ERROR;
		akxc_tm2mpa(ma,ptm);
		cl_set_parm_mpa(pInfoParmW,ma);
		pInfoParmW->pi_attr = DEF_ZOK_DATE;
	}
	pGlobTable->exception = exception_save;
	return rc;
}
