static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  z񏈗                                               *
*                                                                             *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern CLCOMMON CLcommon;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
int cl_array_check_valid(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	static char *_fn_ = "cl_array_check_valid";
	int rc,iINVALID,ix;
	tdtINFO_PARM *pInfo;
	tdtArrayIndex *pIndex,*pIndex0;
	char *name;

	rc = 0;
	if (pInfoParm->pi_id == 'R') {
DEBUGOUT_InfoParm(194,"cl_array_check_valid: pInfoParm=",pInfoParm,0,0);
		if ((pInfo=(tdtINFO_PARM *)pInfoParm->pi_paux) && pInfo!=pInfoParm) {
DEBUGOUT_InfoParm(194,"cl_array_check_valid: pInfo=",pInfo,0,0);
			iINVALID = 0;
			if (pInfo->pi_id != 'R') iINVALID = 1;
			else {
				if ((ix=akxs_xhasl(pGLprocTable->pha_gid,'R',pInfo->pi_hlen,0)) <= 0) iINVALID = 2;
				else {
					if (rc = cl_get_array_index(pInfoParm,&pIndex)) return rc;
					if (rc = cl_get_array_index(pInfo,&pIndex0)) return rc;
					if (pIndex0->pVarIndex != pIndex->pVarIndex) iINVALID = 3;
				}
/*
printf("cl_array_check_valid: ix=%d pi_hlen=%d\n",ix,pInfo->pi_hlen);
*/
			}
			if (iINVALID) {
/*
printf("cl_array_check_valid: iINVALID=%d\n",iINVALID);
*/
				if (!(name=(char *)pInfoParm->pi_pos)) name = AKX_NULL_PRINT;
				if (iINVALID == 3)
						/* %s: Rs[z[%s]̃f[^悪Ē`ꂽߖ{z͖łB*/
					ERROROUT2(FORMAT(659),_fn_,name);
				else
						/* %s: Rs[̔z[%s]łB(%d) */
					ERROROUT3(FORMAT(231),_fn_,name,iINVALID);
				rc = ECL_SCRIPT_ERROR;
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_array_index(pInfoParm,ppIndex)
tdtINFO_PARM *pInfoParm;
tdtArrayIndex **ppIndex;
{
	char c;
	int  rc;

	if (!pInfoParm || !ppIndex) return -1;
	*ppIndex = NULL;
	if (((c=pInfoParm->pi_id)=='A' || c=='R') &&
		pInfoParm->pi_dlen == sizeof(tdtArrayIndex)) {
		*ppIndex = (tdtArrayIndex *)pInfoParm->pi_data;

DEBUGOUT_InfoParm(194,"cl_get_array_index: ",pInfoParm,0,0);

		rc = 0;
	}
	else rc = ECL_SYSTEM_ERROR;
	return rc;
}

/************************************/
/*									*/
/************************************/
int cl_get_array_psize(pInfoParm,pcn,ppSize,ppTBL)
tdtINFO_PARM *pInfoParm;
char *pcn;
int **ppSize;
tdtINFO_PARM ****ppTBL;
{
	int opt;
	char cn,*name;

	cn = '\0';
	opt = 0;
	if (pInfoParm->pi_aux[1] & D_AUX1_LOCAL_VAR) opt = D_GX_OPT_SET_LOCAL;
	if (pInfoParm->pi_id == 'A') {
		name = (char *)pInfoParm->pi_pos;
/*
printf("cl_get_array_psize: name=[%s]\n",name);
*/
		cn = *name;
		if (cn!='%' && cn!='#') cn = '$';
	}
	if (pcn) *pcn = cn;
	return cl_def_get_psize(cn,NULL,NULL,opt,ppSize,ppTBL);
}

/****************************************/
/*										*/
/****************************************/
int cl_update_map_array_max(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	int rc,*pSize,*index,m;
	char cn;
	tdtArrayIndex *pIndex;

	rc = 0;
	if (pInfoParm->pi_id == 'A') {
		if ((rc=cl_get_array_psize(pInfoParm,&cn,&pSize,NULL)) >= 0) {
			rc = 0;
			if (cn=='$' || cn=='%') {
				pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
				index = pIndex->index;
				if ((m=pSize[7]-index[3]+1) > index[2]) index[2] = m;
/*
printf("cl_update_map_array_max: index[2]=%d\n",index[2]);
*/
				if (index[2] < 0) index[2] = 0;
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_array_index_tbl(pInfoParm,pIndex,ppTBL,pMsg)
tdtINFO_PARM *pInfoParm;
tdtArrayIndex *pIndex;
tdtINFO_PARM ****ppTBL;
char *pMsg;
{
	int iRc;
	/* 2021.6.14 */
	tdtArrayIndex *pIndexW,**ppIndex;

	if (pIndex) {
		pIndexW = pIndex;
		ppIndex = &pIndexW;
	}
	else ppIndex = NULL;
	if (!(iRc=cl_get_array_index_tbl_ref(pInfoParm,ppIndex,ppTBL,pMsg))) {
		if (pIndex && pIndexW!=pIndex) memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return iRc;
}

/********1*********2*********3*********4*********5*********6*********7*/
/*	F	pInfoParm : z or Mapp Index						  */
/*						ÂƂ́Aindex[2]XVB				  */
/*			ppIndex : = NULL̂ƂApInfo͕ԂȂB				  */
/*					  <>NULL̂ƂA*ppIndex ɂ́A&tIndex A		  */
/*					    ݒ肳Ă邱							  */
/*					  *ppIndex ɂ́AA or R ̂ƂA				  */
/*						zpIndexԂB					  */
/*					  A,R ȊÔƂ́Aȉ					  */
/*						index[1]:Mapp Indexz̍ővf܂ł̐ */
/*						index[3]:Mapp Index							  */
/*			ppTBL	: <>NULL̂ƂA								  */
/*						Mapp Index̔zւ̃|C^Ԃ		  */
/*			pMsg	: Ăь̃Rg							  */
/*					  = NULL̂Ƃ́AʂŌĂ΂֐ɂȂ	  */
/**********************************************************************/
int cl_get_array_index_tbl_ref(pInfoParm,ppIndex,ppTBL,pMsg)
tdtINFO_PARM *pInfoParm;
tdtArrayIndex **ppIndex;
tdtINFO_PARM ****ppTBL;
char *pMsg;
{
	static char *_fn_ = "cl_get_array_index_tbl_ref";
	ScrPrCT	*pScCT;
	ProcCT  *proc;
	int *index;
	tdtINFO_PARM ***pTBL,*pInfo;
	tdtArrayIndex *pIndex,tIndex;
	int iRc,*pSize,m,tSize[4],opt;
	char c,*name,cn;

DEBUGOUT_InfoParm(191,"cl_get_array_index_tbl_ref:Enter: ",pInfoParm,0,0);
DEBUGOUTL4(191,"%s:Enter: ppIndex=%08x ppTBL=%08x pMsg=[%s]",_fn_,ppIndex,ppTBL,pMsg);

	cn = '\0';
	pTBL = NULL;
	pSize = NULL;
	if (ppTBL) *ppTBL = pTBL;
	/* 2021.6.14 */
	if (ppIndex) {
		pIndex = *ppIndex;
		if (pInfoParm->pi_data != (char *)pIndex) memset(pIndex,0,sizeof(tdtArrayIndex));
	}
	else {
		pIndex = &tIndex;
		memset(pIndex,0,sizeof(tdtArrayIndex));
	}
	if ((c=pInfoParm->pi_id) != 'R') {
		/* 2021.6.14 */
		if ((iRc=cl_get_array_psize(pInfoParm,&cn,&pSize,&pTBL)) < 0) return iRc;
		if (ppTBL) *ppTBL = pTBL;
	}
	else if (c == 'R') {
#if 1	/* 2023.5.10 */
		if (iRc = cl_array_check_valid(pInfoParm)) return iRc;
#else
		if ((pInfo=(tdtInfoParm *)pInfoParm->pi_paux) && pInfo!=pInfoParm) {
			if (pInfo->pi_id != 'R') {
				if (!(name=(char *)pInfoParm->pi_pos)) name = AKX_NULL_PRINT;
				/* %s: Rs[̔z[%s]łB */
				ERROROUT2(FORMAT(231),_fn_,name);
				return ECL_SCRIPT_ERROR;
			}
		}
#endif
		pSize = tSize;
	}
	index = pIndex->index;
/*
printf("cl_get_array_index_tbl_ref:1 pIndex=%08x Index=%08x\n",pIndex,index);
*/
DEBUGOUTL5(191,"cl_get_array_index_tbl_ref:1 index = %d %d %d %d %d",
index[0],index[1],index[2],index[3],index[4]);

	if (c == 'A' || c == 'R') {
		if (iRc = cl_get_array_index(pInfoParm,&pIndex)) return iRc;
		if (ppIndex) *ppIndex = pIndex;
		index = pIndex->index;
/*
printf("cl_get_array_index_tbl_ref:2 pIndex=%08x Index=%08x index[2]=%d\n",pIndex,index,index[2]);
*/
	}
	else {
		if (iRc = cl_get_parm_bin(pInfoParm,index+3,pMsg)) return iRc;
		index[1] = pSize[2] - (index[3] - 1);
	}

DEBUGOUTL5(191,"cl_get_array_index_tbl_ref:2 index = %d %d %d %d %d",
index[0],index[1],index[2],index[3],index[4]);

	if ((c=='R' && index[3]<0) ||
	    (c!='R' && (index[3]<=0 || index[3]>pSize[2]))) {
		ERROROUT1(FORMAT(232),index[3]);	/* CfbNX̏l(%d)słB */
		return -1;
	}
	/* mappedarray ̂Ƃ́Amap pSize[7]傫甽fB*/
	if (c=='A' && pSize && (cn=='$' || cn=='%' || cn=='#')) {
/*
printf("cl_get_array_index_tbl_ref:reflect pSize[7]=%d index[2]=%d index[3]=%d\n",pSize[7],index[2],index[3]);
*/
#if 1	/* 2023.2.10 */
		if ((m=pSize[7]-index[3]+1)>index[2] && m<=index[1]) index[2] = m;
#else
		if ((m=pSize[7]-index[3]+1)>index[2]) index[2] = m;
#endif
/*
printf("cl_get_array_index_tbl_ref:reflect index[2]=%d\n",index[2]);
*/
DEBUGOUTL5(191,"cl_get_array_index_tbl_ref:3 index = %d %d %d %d %d",
index[0],index[1],index[2],index[3],index[4]);
	}
/*
printf("cl_get_array_index_tbl_ref: index=%d %d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4],index[5]);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_check_use_mapped_array(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	char *name,c;

	if (pInfoParm->pi_id == 'A') {
		name = (char *)pInfoParm->pi_pos;
/*
printf("cl_check_use_mapped_array: name=[%s]\n",name);
*/
		if ((c=*name)=='%' || c=='#') {
			ERROROUT1(FORMAT(233),name);	/* włȂz(%s)łB */
			return -1;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_check_use_hash_array(pInfoParmArray,pIndex)
tdtINFO_PARM *pInfoParmArray;
tdtArrayIndex *pIndex;
{
	if (pIndex->xhp ||
	    (pInfoParmArray->pi_id=='R' && (pIndex->index[2] < 0))) {
		/* cl_check_use_hash_array: can't use hash array[%s]!! */
		ERROROUT1(FORMAT(234),(char *)pInfoParmArray->pi_pos);
		return -1;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,opt)
tdtArrayIndex *pIndex;
tdtINFO_PARM ***pTBL;
int  ix;
char opt;
{
	int iRc,attr,attr0,iParm[4],*index;
	tdtINFO_PARM *pInfoParm,rInfoParm;

DEBUGOUTL4(194,"cl_get_array_and_var_ent_opt:Enter: pIndex=%08x pTBL=%08x ix=%d opt=%c",pIndex,pTBL,ix,opt);

	pInfoParm = NULL;
	if (pTBL)
		pInfoParm = cl_get_var_ent_opt(pTBL,ix,opt);
	else if (pIndex) {
		attr = pIndex->uAttr[0];
DEBUGOUTL1(194,"cl_get_array_and_var_ent_opt: attr=%d",attr);
		if (attr) {
			attr0 = 0;
			if ((attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) && !pIndex->size) {
				attr0 = attr;
				attr = DEF_ZOK_VARI;

DEBUGOUTL3(194,"cl_get_array_and_var_ent_opt: ix=%d opt=%c attr0=%d",ix,opt,attr0);

			}
#if 1	/* 2021.11.23 */
			else if (attr & 0x10) {
				attr0 = attr;
				attr = DEF_ZOK_VARI;
			}
#endif
			if (attr == DEF_ZOK_VARI) {
				pInfoParm = cl_get_array_ent_opt(pIndex->pVarIndex,ix,opt);
				if (pInfoParm) {
DEBUGOUT_InfoParm(194,"cl_get_array_and_var_ent_opt: attr0=%d",pInfoParm,attr0,0);
					if (attr0 && !(pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA)) {
						iParm[0] = attr0;
						iParm[1] = 0;
						cl_set_parm_init(pInfoParm,iParm,0x01);
					}
				}
			}
			else {
				if (!cl_get_array_val_opt(&rInfoParm,pIndex,ix,'s'))
					pInfoParm = (tdtINFO_PARM *)rInfoParm.pi_pos;
#if 1	/* 2022.8.26 */
					if (opt == 's') pInfoParm->pi_data = rInfoParm.pi_paux;
#endif
			}
			if (pInfoParm && opt=='s') {
				index = pIndex->index;

DEBUGOUTL3(194,"cl_get_array_and_var_ent_opt: index=%08x ix=%d index[2]=%d",index,ix,index[2]);

				index[2] = X_MAX(index[2],ix);
/*
printf("cl_get_array_and_var_ent_opt: opt=%c index=%08x ix=%d index[2]=%d\n",opt,index,ix,index[2]);
*/
			}
		}
	}

	return pInfoParm;
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_array_and_var_ent(pIndex,pTBL,ix)
tdtArrayIndex *pIndex;
tdtINFO_PARM ***pTBL;
int  ix;
{
	return cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_conv_index(pInfoParm,pIndex)
tdtINFO_PARM *pInfoParm;
tdtArrayIndex *pIndex;
{
	tdtArrayIndex tIndex;
	int  attr,i,ji_1,mx,iSTART,iIXPOS,f,m1,m2,opt15;
	int  n,*index,*index_info,nn,iRANGE,ndim,nn1,nn2;
	char c,*varnam;

	if (!pInfoParm || !pIndex) return ECL_SYSTEM_ERROR;
	c = pInfoParm->pi_id;
	n = pInfoParm->pi_dlen;
/*
printf("cl_gx_conv_index: pInfoParm->pi_id=%c len=%d\n",c,n);
*/
    if ((n == sizeof(tdtArrayIndex)) && ((c == 'A') || (c == 'R'))) {
		if (!pInfoParm->pi_data) return ECL_SYSTEM_ERROR;
		memcpy(&tIndex,pInfoParm->pi_data,n);
		pIndex->pVarIndex = tIndex.pVarIndex;
		pIndex->size = tIndex.size;
		memcpy(pIndex->uAttr,tIndex.uAttr,sizeof(pIndex->uAttr));
		pIndex->xhp = tIndex.xhp;
	}
	else return ECL_SYSTEM_ERROR;

	index = tIndex.index;

DEBUGOUTL5(191,"cl_gx_conv_index: index[0]..[4] = %d %d %d %d %d",
index[0],index[1],index[2],index[3],index[4]);
DEBUGOUTL5(191,"cl_gx_conv_index: index[5]..[9] = %d %d %d %d %d",
index[5],index[6],index[7],index[8],index[9]);

	index_info = pIndex->index;	/* w肳ꂽẽCfbNX */

DEBUGOUTL5(191,"cl_gx_conv_index: index_info[0]..[4] = %d %d %d %d %d",
index_info[0],index_info[1],index_info[2],index_info[3],index_info[4]);
DEBUGOUTL5(191,"cl_gx_conv_index: index_info[5]..[9] = %d %d %d %d %d",
index_info[5],index_info[6],index_info[7],index_info[8],index_info[9]);

	ndim = index[0];
	ji_1 = X_MIN(index_info[0],ndim);
	opt15 = cl_get_option(15,0);
	iSTART = opt15 & 0x01;
	iIXPOS = opt15 & 0x02;
	mx = ji_1;
	if (!(varnam=(char *)pInfoParm->pi_pos)) varnam = AKX_NULL_PRINT;
	for (i=1;i<=ndim;i++) {
		if (i <= ji_1) {
			n = index_info[i+3];
			nn = index[i+3];
			if (nn <= 0) {
				/* cl_gx_conv_index:[%s]̃CfbNXTCY0łBi=%d index=%d (def=None) */
				ERROROUT3(FORMAT(235),varnam,i,n);
				return ECL_SCRIPT_ERROR;
			}
			m1 = 0;
			m2 = nn - 1;
				m1 = index[i+ndim+3];
				m2 += m1;
			if (n<m1 || n>m2) {
				/* cl_gx_conv_index:[%s]̃CfbNX͈͊OłBi=%d index=%d (def=%d..%d) */
				ERROROUT5(FORMAT(236),varnam,i,n,m1,m2);
				return ECL_SCRIPT_ERROR;
			}
		}
		else if (index[i+3] > 1) mx = i;
	}
/*
printf("cl_gx_conv_index: mx=%d ji_1=%d\n",mx,ji_1);
*/
	if (ji_1 > 0) {
		if (iIXPOS) {
			n = index_info[mx+3];
			n -= index[mx+ndim+3];
			for (i=1;i<mx;i++) {
				nn = index_info[mx-i+3];
				nn -= index[mx-i+ndim+3];
/*
printf("cl_gx_conv_index: i=%d n=%d nn=%d f=%x\n",i,n,nn,f);
*/
				n = n*index[mx-i+3] + nn;
			}
		}
		else {
			n = index_info[4];
			n -= index[1+ndim+3];
			for (i=2;i<=mx;i++) {
/*
printf("cl_gx_conv_index: i=%d n=%d\n",i,n);
*/
				nn = index_info[i+3];
				nn -= index[i+ndim+3];
				n = n*index[i+3] + nn;
			}
		}
	}
/*
printf("cl_gx_conv_index: n=%d index[3]=%d\n",n,index[3]);
*/
	return n + index[3];
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_array_ent_opt(pVarIndex,iParmNo,opt)
tdtINFO_PARM *pVarIndex[];
int iParmNo;
char opt;
{
	tdtINFO_PARM *pDummy;

	if (!pVarIndex) return NULL;

	if (!(pDummy = pVarIndex[--iParmNo])) {
		if (opt == 's' || (pGlobTable->options[0] & 0x01)) {
			if (pDummy=(tdtINFO_PARM *)Malloc(sizeof(tdtINFO_PARM))) {
				memset(pDummy,0,sizeof(tdtINFO_PARM));
				pVarIndex[iParmNo] = pDummy;
				if (pGlobTable->options[0] & 0x01) cl_null_data(pDummy);
			}
		}
	}
	return pDummy;
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_array_ent(pVarIndex,iParmNo)
tdtINFO_PARM *pVarIndex[];
int iParmNo;
{
	return cl_get_array_ent_opt(pVarIndex,iParmNo,'s');
}

/****************************************/
/*										*/
/****************************************/
int cl_free_array_ent(pIndex)
tdtArrayIndex *pIndex;
{
	tdtINFO_PARM *cpDat,**pVarIndex,**p,*pDummy;
	int *index;
	int i,n,ix,k,maxreg,attr;
	XHASHB *xhp;

	if ((xhp=(XHASHB *)pIndex->xhp)) {
		maxreg = akxs_xhash(xhp,'m',NULL);
		for (k=1;k<=maxreg;k++) {
			xhp->xha_xhix = k;
			ix = akxs_xhash2(xhp,'k',NULL,&cpDat);
			if (ix > 0) {
				memcpy(&pDummy,cpDat,sizeof(tdtINFO_PARM *));
				if (pDummy) {
					cl_free_info_parm(pDummy);
					Free(pDummy);
				}
			}
		}
		akxs_xhash_free(xhp);
		pIndex->xhp = NULL;
		if (pVarIndex = pIndex->pVarIndex) {
			if (!(pIndex->uAttr[1] & D_ATR1_NO_MALLOC)) Free(pVarIndex);
			pIndex->pVarIndex = NULL;
		}
	}
	else if (pVarIndex = pIndex->pVarIndex) {
		if (((attr=pIndex->uAttr[0])==DEF_ZOK_VARI) ||
		    ((attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) && !pIndex->size)) {
			index = pIndex->index;
			n = index[1];
			for (i=0,p=pVarIndex;i<n;i++,p++) {
				if (pDummy = *p) {
					cl_free_info_parm(pDummy);
					Free(pDummy);
				}
			}
		}
/*
printf("cl_free_array_ent: pIndex->uAttr[1]=%08x\n",pIndex->uAttr[1]);
*/
		if (!(pIndex->uAttr[1] & D_ATR1_NO_MALLOC)) Free(pVarIndex);
		pIndex->pVarIndex = NULL;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_array_val_opt(pInfoParmW,pIndex,iParmNo,opt)
tdtINFO_PARM *pInfoParmW;
tdtArrayIndex *pIndex;
int iParmNo;
char opt;
{
	tdtINFO_PARM *pInfoParm, *pParm;
	char *p,*pp,*ps;
	uchar uSCALE;
	int *pi,val,attr,len,size,*index,iCOMPLEX;
	double *pd;

	if (!pIndex) return -1;
	attr = pIndex->uAttr[0];
	size = pIndex->size;
DEBUGOUTL2(194,"cl_get_array_val_opt: attr=%d size=%d",attr,size);
	if (!attr) {
		/* cl_get_array_val_opt: can't use hash arrray!! */
		ERROROUT(FORMAT(237));
		return ECL_SCRIPT_ERROR;
	}
	p = (char *)pIndex->pVarIndex;
	iParmNo--;
/*
printf("cl_get_array_val_opt: iParmNo=%d pIndex->uaux1=%04x p=%08x\n",iParmNo,pIndex->uaux1,p);
*/
	if (iCOMPLEX=(pIndex->uaux1 & D_AULN_COMPLEX_DATA)) iParmNo += iParmNo;
#if 1	/* 2023.5.16 */
	if (attr == 2) {
		uSCALE = pIndex->uAttr[3];
	}
#else
	if (attr>=2 && attr<=4) {
		ps = p + size*pIndex->index[1] + iParmNo;
		uSCALE = *(uchar *)ps;
	}
#endif
	else uSCALE = 0;
	if (opt == 's') {
		if (!(pInfoParm=(tdtINFO_PARM *)cl_tmp_const_malloc(sizeof(tdtINFO_PARM))))
			return ECL_SYSTEM_ERROR;
		pParm = pInfoParm;
	}
	else if (!(pParm = pInfoParmW)) return -1;

	if (attr == DEF_ZOK_BINA) {
		pp = (char *)&((int *)p)[iParmNo];
		pi = (int *)pp;
		cl_set_parm_bin(pParm,*pi);
/*
printf("cl_get_array_val_opt:BINA iParmNo=%d pp=%08x *pi=%d\n",iParmNo,pp,*pi);
*/
		if (iCOMPLEX) pParm->pi_hlen = *(pi+1);
	}
	else if (attr == DEF_ZOK_FLOA) {
		pp = (char *)&((double *)p)[iParmNo];
		pd = (double *)pp;
		cl_set_parm_double(pParm,*pd);
/*
printf("cl_get_array_val_opt:FLOA iParmNo=%d pp=%08x *pd=%e\n",iParmNo,pp,*pd);
*/
		if (iCOMPLEX) {
			pParm->pi_scale &= ~D_DATA_LPOSDATA;
			pParm->pi_data = pp;
		}
	}
	else if (attr == DEF_ZOK_DECI) {
		/* 2021.10.11 */
		pp = p + iParmNo*sizeofMPA();
		memset(pParm,0,sizeof(tdtINFO_PARM));
		pParm->pi_id = ' ';
		pParm->pi_attr = DEF_ZOK_DECI;
		pParm->pi_dlen = sizeofMPA();
		pParm->pi_data = pp;
		pParm->pi_hlen = pIndex->uAttr[2];	/* precision */
		pParm->pi_pos = pIndex->uAttr[3];	/* scale */
	}
	else if (attr == DEF_ZOK_CHAR) {
		pp = p + iParmNo*(size+1);
		*(pp+size) = '\0';
		cl_set_parm_char(pParm,pp,strlen(pp));
	}
	else if (attr == DEF_ZOK_DATE) {
		/* 2021.10.11 */
		pp = p + iParmNo*sizeofMPA();
		cl_set_parm_date(pParm,(MPA *)pp);
	}
	else if (attr == DEF_ZOK_BULK) {
		pp = p + iParmNo*(size+sizeof(int));
		memcpy(&len,pp+size,sizeof(int));
		cl_set_parm_char(pParm,pp,len);
		pParm->pi_attr = attr;
	}
	pParm->pi_scale |= uSCALE;
DEBUGOUTL2(194,"cl_get_array_val_opt: p=%08x pp=%08x",p,pp);
DEBUGOUT_InfoParm(194,"cl_get_array_val_opt: iParm-1=%d opt=%c",pParm,iParmNo,opt);
/*
printf("cl_get_array_val_opt: opt=%c attr=%d pp=%08x scale=%02x\n",opt,attr,pp,uSCALE);
*/
	if (opt == 's') {
		pInfoParm->pi_aux[0] = attr;
		pInfoParm->pi_len = size;
		pInfoParm->pi_paux = pp;
		cl_set_parm_long(pInfoParmW,(long)pInfoParm);
		pInfoParmW->pi_id  = 'S';
#if 1	/* 2022.8.26 */
		pInfoParmW->pi_paux = ps;
/*
printf("cl_get_array_val_opt: iParmNo=%d scale=%02x\n",iParmNo,*ps);
*/
#endif
DEBUGOUT_InfoParm(194,"cl_get_array_val_opt: ",pInfoParmW,0,0);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_get_info_parm(ppParmI,pIndex1,pTBL1,ix1,opt)
tdtINFO_PARM **ppParmI;
tdtArrayIndex *pIndex1;
tdtINFO_PARM ***pTBL1;
int ix1;
char opt;
{
	XHASHB *xhp1;
	tdtINFO_PARM *pParmI;
	int iRc;
	char *cpKey,*cpDat;

	iRc = 0;
	pParmI = NULL;
	xhp1 = pIndex1->xhp;
DEBUGOUTL1(194,"cl_array_get_info_parm: xhp1=%08x",xhp1);
	if (xhp1) {
		xhp1->xha_xhix = ix1;
		if ((iRc=akxs_xhash2(xhp1,'P',&cpKey,&cpDat)) > 0) {
			memcpy(&pParmI,cpDat,sizeof(tdtINFO_PARM *));
			xhp1->xha_hashb->ha_key = cpKey;
/*
printf("cl_array_get_info_parm: ix1=%d key=[%s] pParm=%08x\n",ix1,cpKey,pParmI);
*/
		}
	}
	else {
		pParmI = cl_get_array_and_var_ent_opt(pIndex1,pTBL1,ix1,opt);
		iRc = 1;
	}
	*ppParmI = pParmI;
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_array_info(pInfoParm,pIndex,ppTBL,iParm)
tdtINFO_PARM *pInfoParm;
tdtArrayIndex *pIndex;
tdtINFO_PARM ****ppTBL;
int iParm[];
{
	tdtArrayIndex *pIndexW;
	int iRc;

	pIndexW = pIndex;
	if (!(iRc=cl_get_array_info_ref(pInfoParm,&pIndexW,ppTBL,iParm))) {
		if (pIndexW != pIndex) memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return iRc;
}

/********1*********2*********3*********4*********5*******/
/*	F	ppIndex : *ppIndex ɂ́A&tIndex A		*/
/*					    ݒ肳Ă邱				*/
/*					  *ppIndex ɂ́AA or R ̂ƂA	*/
/*						zpIndexԂB		*/
/*		ʏz:										*/
/*			iParm[1] : ővf						*/
/*			iParm[2] : off_set (z̊Jnʒu(擪1))*/
/*			iParm[3] : ݒςݗvf̐擪̍őʒu(擪1)*/
/*														*/
/*			iParm[2]`iParm[3]*wŏo͂zParmNoł͈̔͂ƂȂ */
/*			iParm[3]-iParm[2]+1o͂			*/
/*		HASHz:										*/
/*			iParm[1] : ővf						*/
/*			iParm[2] : 1								*/
/*			iParm[3] : ݒςݗvf					*/
/********************************************************/
int cl_get_array_info_ref(pInfoParm,ppIndex,ppTBL,iParm)
tdtINFO_PARM *pInfoParm;
tdtArrayIndex **ppIndex;
tdtINFO_PARM ****ppTBL;
int iParm[];
{
	int iRc,ix0,*index,offset;
	XHASHB *xhp;
	tdtArrayIndex *pIndex;

	mem_set_int(iParm,0,4);
	pIndex = *ppIndex;
/*
printf("cl_get_array_info_ref:1 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	if (pInfoParm->pi_data != (char *)pIndex) memset(pIndex,0,sizeof(tdtArrayIndex));
	if (iRc=cl_get_array_index_tbl_ref(pInfoParm,ppIndex,ppTBL,"cl_get_array_info_ref:")) return iRc;
	if (pIndex = *ppIndex) {
/*
printf("cl_get_array_info_ref:2 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
		if (pInfoParm->pi_id=='R' && (xhp=pIndex->xhp)) {
			iParm[1] = akxs_xhash2(xhp,'M',NULL,NULL);	/* ővf */
			iParm[2] = 1;								/* Hash Index̊Jnԍ */
			iParm[3] = akxs_xhash2(xhp,'U',NULL,NULL);	/* ݒςݗvf */
		}
		else {
			index = pIndex->index;
/*
printf("cl_get_array_info_ref: index=%08x index[1]..[3] =%d %d %d\n",index,index[1],index[2],index[3]);
*/
			iParm[1] = index[1];	/* ővf */
			iParm[2] = index[3];	/* off_set (z̊Jnʒu(擪1))*/
			offset = index[3] - 1;
#if 0	/* 2023.2.10 */
			iParm[3] = index[1];
			if (index[2] < index[1]) iParm[3] = index[2] + offset;
#else
			iParm[3] = X_MIN(index[2],index[1]) + offset;	/* ݒςݗvf̐擪̍őʒu(擪1), <0 HASH 2020.4.30 */
#endif
			/* iParm[2]`iParm[3]*wŏo͂zParmNoł͈̔͂ƂȂ */

DEBUGOUTL4(194,"cl_get_array_info_ref: iParm[0]..[3] =%d %d %d %d",iParm[0],iParm[1],iParm[2],iParm[3]);

		}
/*
printf("cl_get_array_info_ref: iParm[0]..[3] =%d %d %d %d\n",iParm[0],iParm[1],iParm[2],iParm[3]);
*/
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_mapped_array(pInfoParmW,pInfoParm1,pOperator,pInfoParm2)
char *pOperator;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
tdtINFO_PARM *pInfoParmW;
{
	static char *_fn_="cl_get_mapped_array";
	tdtINFO_PARM *pInfoParmA,*pInfoParm,*pparm[MAX_ARRAY_DIM],*pInfo;
	tdtArrayIndex *pIndex;
	char c,id1,id2,id,*p;
	int rc,*index,n,i,m,nr,iUNSIGN,nparm;
	long ix;
	ulong uix;
	tdtRB_CTL *pCt,*pCtI;

	if ((c=*pOperator)!='+' && c!='-') {
		/* %s: Z(%s)͎gpł܂B */
		ERROROUT2(FORMAT(238),_fn_,pOperator);
		return ECL_SCRIPT_ERROR;
	}
	/* 2023.2.8 */
	if ((id1=pInfoParm1->pi_id)=='A' || id1=='R') {
		pInfoParmA = pInfoParm1;
		pInfoParm  = pInfoParm2;
	}
	else if ((id2=pInfoParm2->pi_id)=='A' || id2=='R') {
		pInfoParmA = pInfoParm2;
		pInfoParm  = pInfoParm1;
	}
	else {
		return -1;
	}
	if ((id=pInfoParm->pi_id)==' ') {
		nparm = 1;
#if 0
		pparm[0] = pInfoParm;
		if (rc=cl_get_parm_bin(pInfoParm,&ix,FORMAT(163))) return rc;	/*  */
		iUNSIGN = pInfoParm->pi_scale & D_DATA_UNSIGNED;
#endif
	}
	else if (id=='N' || id=='L') {
		pCtI = (tdtRB_CTL *)pInfoParm->pi_data;
		akxs_rb_read(pCtI,0);
		nparm = 0;
		while (pInfo=(tdtINFO_PARM *)akxs_rb_read(pCtI,1)) {
			pparm[nparm++] = pInfo;
		}
		if (!nparm) {
			ERROROUT2(FORMAT(76),_fn_,"map index ");	/* %s: %s܂B*/
			return ECL_SCRIPT_ERROR;
		}
		else if (nparm == 1) {
			pInfoParm = pparm[0];
		}
	}
	else {
		return -1;
	}
	pIndex = (tdtArrayIndex *)pInfoParmA->pi_data;
	if (pIndex->xhp) {
		/* %s: Azz(%s)͎wł܂B */
		ERROROUT2(FORMAT(239),_fn_,pInfoParmA->pi_pos);
		return ECL_SCRIPT_ERROR;
	}
	if (rc=cl_gx_rep_info_set_ign(pInfoParmW,pInfoParmA,1)) return rc;
	pIndex = (tdtArrayIndex *)pInfoParmW->pi_data;
	pIndex->uAttr[1] = D_ATR1_NO_MALLOC;
	index = pIndex->index;
  if (nparm > 1) {
	if ((rc=_set_index2(0,nparm,NULL,0,index,_fn_,pparm)) < 0) return rc;
  }
  else {
	if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) {
		/* %s:  %d  }bvCfbNXɔ͈͎w[%s]́Awł܂B */
		cl_get_range_str(pInfoParm,&p);
		if (!p) p = "";
		ERROROUT3(FORMAT(420),_fn_,1,p);
		return ECL_SCRIPT_ERROR;
	}
	if (rc=cl_get_parm_bin(pInfoParm,&ix,FORMAT(163))) return rc;	/*  */
	iUNSIGN = pInfoParm1->pi_scale & D_DATA_UNSIGNED;
	if (!iUNSIGN && c=='-') ix = -ix;	/* add 2021.3.29 */
	n = index[1];
/*
printf("cl_get_mapped_array: ix=%d n=%d index=%d %d %d %d %d %d\n",
ix,n,index[0],index[1],index[2],index[3],index[4],index[5]);
*/
#if 1	/* 2021.3.29 */
	if (iUNSIGN) {
		if (c == '+') i = index[3] + uix;
		else i = index[3] - uix;
	}
	else i = index[3] + ix;
#else
	i = ix;
#endif
	if (i<=0 || i>n) {
		/* %s: mapʒu(%d)͈͊OłB */
		ERROROUT2(FORMAT(240),_fn_,i);
		return ECL_SCRIPT_ERROR;
	}
#if 1	/* 2021.3.29 */
	index[3] = i;
#else
	index[3] += i;
#endif
	nr = n - ix;
	index[0] = 1;
	index[1] = nr;
	index[2] -= ix;
	if (index[2] <0 ) index[2] = 0;
	index[4] = nr;
/*	index[5] = 0;	2023.8.8 del */
/*
printf("cl_get_mapped_array: ix=%d nr=%d index=%d %d %d %d %d %d\n",
ix,nr,index[0],index[1],index[2],index[3],index[4],index[5]);
*/
  }
DEBUGOUT_InfoParm(170,"cl_get_mapped_array: ",pInfoParmW,0,0);

	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_map(pInfoParmW,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int nparm;
tdtINFO_PARM *ppParm[];
{
	static char *_fn_="cl_array_map";
	tdtINFO_PARM *pInfoParmA;
	tdtArrayIndex *pIndex;
	char c,id1,id2;
	int rc,ix,*index,n,i,ind[MAX_ARRAY_DIM+1],f,iRANGE,iSTART,ndim,i1,i2,k;

	pInfoParmA = ppParm[0];
	if ((id1=pInfoParmA->pi_id)!='A' && id1!='R') {
		/* %s: Pzł͂܂Bid=[%c] */
		ERROROUT2(FORMAT(246),_fn_,id1);
		return ECL_SCRIPT_ERROR;
	}
	pIndex = (tdtArrayIndex *)pInfoParmA->pi_data;
	if (pIndex->xhp) {
		/* %s: Azz(%s)͎wł܂B */
		ERROROUT2(FORMAT(239),_fn_,pInfoParmA->pi_pos);
		return ECL_SCRIPT_ERROR;
	}
	if (nparm==2 && ((id1=ppParm[1]->pi_id)=='L' || id1=='N')) {
		return cl_get_mapped_array(pInfoParmW,ppParm[0],"+",ppParm[1]);
	}
	if (rc=cl_func_index(&ix,nparm,ppParm)) return rc;
	index = pIndex->index;
	ndim = index[0];
	nparm = X_MIN(nparm-1,ndim);
	for (i=1;i<=nparm;i++) {
		if (rc=cl_get_parm_bin(ppParm[i],&ind[i],"index")) return rc;
/*
printf("cl_array_map: ind[%d]=%d\n",i,ind[i]);
*/
	}
	if (rc=cl_gx_rep_info_set_ign(pInfoParmW,pInfoParmA,1)) return rc;
	pIndex = (tdtArrayIndex *)pInfoParmW->pi_data;
	index = pIndex->index;
	n = index[1];
/*
printf("cl_array_map: index=");
for (i=0;i<ndim*2+4;i++) printf("%d ",index[i]);
printf("ix=%d\n",ix);
*/
	i = ix;
	if (i<=0 || i>n) {
		/* %s: mapʒu(%d)͈͊OłB */
		ERROROUT2(FORMAT(240),_fn_,i);
		return ECL_SCRIPT_ERROR;
	}
	index[3] += i;
	if (pGlobTable->options[14] & 0x01) iSTART = 1;
	else iSTART = 0;
	i1 = 4;
	i2 = i1 + ndim;
	n = 1;
	for (i=1;i<=nparm;i++,i1++,i2++) {
		index[i1] -= ind[i] - index[i2];
		if (index[i1] <= 0) {
			/* %s: mapʒu(i=%d %d)͈͊OłB */
			ERROROUT3(FORMAT(247),_fn_,i,ind[i]);
			return ECL_SCRIPT_ERROR;
		}
		n *= index[i1];
/*
printf("cl_array_map: index[%d]=%d n=%d\n",i1,index[i1],n);
*/
	}
	for (;i<=ndim;i++,i1++) {
		n *= index[i1];
/*
printf("              index[%d]=%d n=%d\n",i1,index[i1],n);
*/
	}
	index[2] -= index[1] - n;
	if (index[2] < 0) index[2] = 0;
/*	index[0] = i;	del 2021.5.5 */
/*
printf("cl_array_map: index=");
for (i=0;i<ndim*2+4;i++) printf("%d ",index[i]);
printf("\n");
*/
DEBUGOUT_InfoParm(170,"cl_get_mapped_array: ",pInfoParmW,0,0);

	return 0;
}
