static char sccsid[]="%Z% %M% %I% %D% %T%";
/*
	cc -g -DLINUX -I../include testkmp.c -o testkmp
*/
#include <akxcommon.h>
main()
{
	int  next[128];
	int  buf_len,ret,i,key_len;
	char buf[128],key[128];

	printf("Enter text : ");
	gets(buf);
	buf_len = strlen(buf);
	for(;;) {
		printf("Enter key ==>");
		gets(key);
		if (!*key) break;
		key_len = strlen(key);
		ret = findKMP(buf,buf_len,key,key_len,next);
		for (i=0;i<key_len;i++) printf("next[%2d]=%d\n",i,next[i]);
		printf("ret= %d\n",ret);
	}
	exit(0);
}

int getKMPNext(char *str, int str_len, int next[])
{
	int i,j,n;

	if (!str || !next) return -1;

	next[0] = -1;
	n = next[0];
	for (i=0;i<str_len;i++) {
		while (n >= 0) {
			if (str[i] == str[n]) break;
			 n = next[n];
		}
		n++;
		j = i + 1;
		if (str[j] == str[n]) next[j] = next[n];
		else next[j] = n;
	}
	return 0;
}

int findKMP(char *text, int text_len, char *str, int str_len, int next[])
{
	int ret,text_idx_len,text_idx,n;

	if (!text || !str || !next) return -1;

	if (ret=getKMPNext(str,str_len,next)) return ret;

	text_idx_len = text_len - str_len + 1;
	n = 0;
	for (text_idx=0;text_idx<text_idx_len;text_idx++) {
		while (n >= 0) {
			if (text[text_idx] == str[n]) break;
			n = next[n];
		}
		n++;
		if (str_len <= n) return text_idx - str_len + 2;
	}
	return 0;
}
