static	char	sccsid[]="%Z% %M% %I% %D% %T%";
/*********************************************************/
/*								*/
/*	name service						*/
/*								*/
/*		coded   by A.Kobayashi	1992.02.21		*/
/*		updated by A.Kobayashi	1992.07.06		*/
/*		updated by A.Kobayashi	1996.01.25		*/
/*		updated by A.Kobayashi	1996.06.07		*/
/*								*/
/*********************************************************/

#include	"akbcommon.h"

int akb_gs_akbname(cpBlock,cpName,cpArg)
char *cpBlock,*cpName,*cpArg;
{
	char *argv[2];
	int n;

	n = akb_gs_akbstpl(cpBlock,cpName,argv,2);
	if (n != 2) {
/*
printf("akb_gs_akbname:n=%d\n",n);
*/
		*cpArg = '\0';
		if (n >=0 ) n = -1;
		return n;
	}
	strcpy(cpArg,argv[1]);
	return (strlen(cpArg));
}

int akbgetakbservname(cpProcName,service)
char *cpProcName,*service;
{
	int n;

	n = akb_gs_akbname(BLK_SERVICE,cpProcName,service);
	if (n <= 0) {
		PRINTOUT2("akbgetakbservname : not found %s in %s",cpProcName,akb_akb_inf(0));
		*service = 0;
		return -1;
	}
	return (n);
}

char *akb_akb_home(iReSet)
int iReSet;
{
	static int iAkbHome=1;
	static char *cpHome=NULL;

	if (iAkbHome || iReSet) {
		iAkbHome = 0;
		cpHome = getenv(AKB_HOME);
#ifdef DEBUG
printf("akb_akb_home:%s\n",cpHome);
#endif
	}
	return cpHome;
}

char *akb_akb_home_add(cpFile)
char *cpFile;
{
	static char *cpPath=NULL;
	char *p;

	p = akxt_add_dir2(akb_akb_home(0),cpFile,&cpPath);
	if (!p) p = cpFile;
	return p;
}

#define OLD_GSAKBNAPL_MAXARGV
#define D_GSAKBNAPL_MAXARGV	32
#define D_GSAKBNAPL_INTERVAL	30
typedef struct {
#ifndef FIXED_CHECH_LEN
	long len;
#endif
	int  Nn;
	char *Nargv[D_GSAKBNAPL_MAXARGV];
	char wrk[D_RECORD_BUFSIZE];
	char buf[D_RECORD_BUFSIZE];
} qNaplCtl;

int akb_gs_akbstpl(cpBlock,cpName,argv,maxargv)
char *cpBlock,*cpName,**argv;
int  maxargv;
{
	return akb_gs_akbstpli(cpBlock,1,cpName,argv,maxargv);
}

int akb_gs_akbstpli(cpBlock,colm,cpName,argv,maxargv)
char *cpBlock,*cpName,**argv;
int  maxargv,colm;
{
	return akb_gs_akbstplix(cpBlock,colm,cpName,argv,maxargv,3);
}

int akb_gs_akbstplix(cpBlock,colm,cpName,argv,maxargv,opt)
char *cpBlock,*cpName,**argv;
int  maxargv,colm,opt;
{
	int n, ret, i, len;
	char key[D_RECORD_BUFSIZE],*cpPath,*p;
	static qCacheCtlHead *pCH=NULL;
	tdtCACHE_CTL qCt;
	qNaplCtl *pNt;
	static qNaplCtl qNt;

	if (cpPath=akb_akb_home_add(akb_akb_inf(0))) {
#if 1	/* 2000.12.8 Koba */
		ret = 0;
		if (maxargv <= D_GSAKBNAPL_MAXARGV) {
			if (!pCH) {
				pCH = akxs_cache_new(20);
				if (pCH) pCH->ch_interval = D_GSAKBNAPL_INTERVAL;
			}
			if (pCH) ret = 1;
		}
		if (ret) {
#else
		if (pCH) {
#endif
			pCH->ch_opt |= 0x04;
#ifdef FIXED_CHECH_LEN
			pCH->ch_cshlen = sizeof(qNaplCtl);
#else
			pCH->ch_cshlen = -1;
#endif
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
			sprintf(key,"%s.%d.%s.%d",cpBlock,colm,cpName,maxargv);
#else
			sprintf(key,"%s.%d.%s",cpBlock,colm,cpName);
#endif
			ret = akxs_cache_chk(pCH,key,&qCt);
#ifdef DEBUG
printf("akb_gs_akbstplix: CacheChk key=[%s] ret=%d\n",key,ret);
#endif
			if (ret) {
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
				if (maxargv>sizeof(qNt.Nargv)/sizeof(char *))
					maxargv = sizeof(qNt.Nargv)/sizeof(char *);
				n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
				                qNt.buf,sizeof(qNt.buf),opt);
#else
				n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,
				                qNt.Nargv,D_GSAKBNAPL_MAXARGV,
				                qNt.buf,sizeof(qNt.buf),opt);
#endif
#if 1	/* 2000.12.18 Koba rsǎΉ */
				if (n == 0) {
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
					n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
					                qNt.buf,sizeof(qNt.buf),opt);
#else
					n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,
					                qNt.Nargv,D_GSAKBNAPL_MAXARGV,
					                qNt.buf,sizeof(qNt.buf),opt);
#endif
				}
#endif
/*
printf("akb_gs_akbstplix: %s %s in %s, n=%d\n",cpBlock,cpName,cpPath,n);
*/
				if (n < 0) return n;
				else {
					qNt.Nn = n;
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
					memcpy(qNt.Nargv,argv,sizeof(char *)*n);
#endif
					qCt.ca_data = (char *)&qNt;
#ifndef FIXED_CHECH_LEN
					qNt.len = 0;
/*
printf("akb_gs_akbstpl:set: n=%d, name=[%s]\n",n,cpName);
*/
					for (i=0;i<n;i++) {
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
						qNt.len += strlen(argv[i]) + 1;
#else
						qNt.len += strlen(qNt.Nargv[i]) + 1;
#endif
/*
printf("set: i=%d, qNt.len=%d, argv=[%s]\n",i,qNt.len,argv[i]);
*/
					}
					memcpy(&qNt.Nargv[n],qNt.buf,qNt.len);
					qNt.len += sizeof(long) + sizeof(char *)*n;
/*
printf("akb_gs_akbstplix:set: qNt.len=%d\n",qNt.len);
*/
#endif
					if (ret == -22) {	/* Key o^*/
						qCt.ca_key  = key;
						qCt.ca_cmp1 = cpPath;
						i = akxs_cache_set(pCH,&qCt);
					}
					else if (ret > 0) {		/* LbV*/
						i = akxs_cache_set(pCH,&qCt);
						if (i<0) akxs_cache_del(pCH,key);
					}
					else return ret;
					if (i < 0) return i;
#ifdef DEBUG
printf("akb_gs_akbstplix: CacheSet n=%d,i=%d key=[%s]\n",pCH->ch_imax,i,key);
#endif
				}
			}
			else {
			/* Nargv̓éAqNt.buf̒wĂ̂qNtɖ߂Ȃ
			   eoȂ*/
			/*
				pNt = (qNaplCtl *)qCt.ca_data;
				n = pNt->Nn;
				memcpy(argv,pNt->Nargv,sizeof(char *)*n);
			*/
#ifdef FIXED_CHECH_LEN
				memcpy((char *)&qNt,qCt.ca_data,sizeof(qNaplCtl));
#else
				memcpy((char *)&qNt.len,qCt.ca_data,sizeof(long));
				memcpy(&qNt.Nn,qCt.ca_data+sizeof(long),qNt.len);
				qNt.len -= (sizeof(long) + sizeof(char *)*qNt.Nn);
				memcpy(qNt.buf,&qNt.Nargv[qNt.Nn],qNt.len);
/*
printf("akb_gs_akbstplix:get: n=%d, qNt.len=%d\n",qNt.Nn,qNt.len);
for (i=0;i<qNt.Nn;i++) printf("get: i=%d, argv=[%s]\n",i,qNt.Nargv[i]);
*/
#endif
				n = qNt.Nn;
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
				memcpy(argv,qNt.Nargv,sizeof(char *)*n);
#endif
			}
#ifndef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
			if (n > maxargv) n = maxargv;
			memcpy(argv,qNt.Nargv,sizeof(char *)*n);
			if (n < maxargv) {
				if (n>0) {
					p = argv[n-1];
					p += strlen(p) + 1;
				}
				else p = qNt.buf;
				for (i=n;i<maxargv;i++) {
					argv[i] = p;
				}
			}
#endif
		}
		else
			n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
			                qNt.buf,sizeof(qNt.buf),opt);
	}
	else n = -2;
#ifdef DEBUG
printf("akb_gs_akbstplix: %s %s in %s, n=%d\n",cpBlock,cpName,cpPath,n);
#endif
	return n;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_get_proc_name(iPid,cpProcName)
int  iPid;
char *cpProcName;
{
	int iRc;
	static char *argv[2];
	char buf[12];

	sprintf(buf,"%d",iPid);
	iRc = akb_gs_akbstpli(BLK_PROCESS,2,buf,argv,2);
	if (iRc > 0) {
		if (cpProcName) strcpy(cpProcName,argv[0]);
		else cpProcName = argv[0];
	}
	else {
		if (cpProcName) strcpy(cpProcName,buf);
		else cpProcName = NULL;
	}
	return cpProcName;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_akb_inf(iReSet)
int iReSet;
{
	static char *cpInf=NULL;

	if (!cpInf || iReSet) {
		cpInf = getenv(AKB_INF);
		if (!cpInf) cpInf = AKBINF;
#ifdef DEBUG
printf("akb_akb_inf:%s\n",cpInf);
#endif
	}
	return cpInf;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_proc_id(cpProcName)
char *cpProcName;
{
	int iRc;
	char *argv[2];

	iRc = akb_gs_akbstpl(BLK_PROCESS,cpProcName,argv,2);
	if (iRc >= 2) {
		iRc = atoi(argv[1]);
	}
	else if (iRc >= 0) {
		iRc = -1;
	}
	return iRc;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_proc_name2(iPid,cpProcName)
int  iPid;
char *cpProcName;
{
	int iRc;
	char *argv[2],buf[12];

	if (cpProcName) *cpProcName = '\0';
	sprintf(buf,"%d",iPid);
	iRc = akb_gs_akbstpli(BLK_PROCESS,2,buf,argv,2);
	if (iRc > 0) {
		if (cpProcName) strcpy(cpProcName,argv[0]);
		iRc = strlen(argv[0]);
	}
	return iRc;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_proc_name3(iPid,cpDefalt,cppProcName)
int  iPid;
char *cpDefalt,**cppProcName;
{
	int len;
	char *p,*cpName;

	if (!cppProcName) return -1;
	p = akb_get_proc_name(iPid,NULL);
	if (!p) {
		if (cpDefalt) p = cpDefalt;
		else return 0;
	}
	len = strlen(p) + 1;
	cpName = *cppProcName;
	if (cpName) {
		cpName = Realloc(cpName,len);
	}
	else {
		cpName = Malloc(len);
	}
	if (!cpName) return -2;
	strcpy(cpName,p);
	*cppProcName = cpName;
	return len;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_apsys_id(cpAPSysName,parm)
char *cpAPSysName;
long parm[];
{
	int n,iRc,ret;
	char *argv[3];

	if (!cpAPSysName || !parm) return -1;

	parm[0] = parm[1] = 0;
	iRc = akb_gs_akbstpl(BLK_HOSTCONNECT,cpAPSysName,argv,3);
	if (iRc >= 3) {
		parm[1] = akb_get_port_no(argv[2]);
	}
	if (iRc >= 2) {
		ret = akb_get_host_addr(argv[1],&parm[0]);
		if (ret < 0) iRc = ret;
	}
	if (iRc > 0) iRc--;
	return iRc;
}
