static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akbCrePack.c								*/
/*												*/
/*			coded by A.Kobayashi 2010/06/10		*/
/*												*/
/************************************************/
#include "akbcommon.h"

/********************************************************/
/*														*/
/********************************************************/
int akb_create_pk_data(applid,tpHead,tpSendMsgCom,cppPacket)
char            *applid;
tdtCommPackHead   *tpHead;
tdtMsgCom       *tpSendMsgCom;
char            **cppPacket;
{
	INT4 lPackLen, lFileLen, lw, lLen;
	char *cpPacket,*cp,*cpF,cver;
	int i,l,iHSize,iINDIRECT;
	struct stat tStat;

	if (!tpHead || !tpSendMsgCom || !cppPacket) return -1;
	*cppPacket = NULL;
	if (tpSendMsgCom->msg_mlen < 0 ||
	    (tpSendMsgCom->msg_mlen>0 && !tpSendMsgCom->msg_pmsg))
		return -1;
	iINDIRECT = (tpSendMsgCom->msg_form & AKB_PFM_INDIRECT);
	if (tpSendMsgCom->msg_filc>0 && tpSendMsgCom->msg_filv) iINDIRECT = 1;
	AKBGETHSIZEETC(tpHead,cver,iHSize,lLen)
	if (iINDIRECT) {
		lPackLen = iHSize+tpSendMsgCom->msg_mlen+4+sizeof(INT4);
		if (tpSendMsgCom->msg_filc>0 && !tpSendMsgCom->msg_filv) return -2;
/*
printf("akb_create_pk_data: tpSendMsgCom=%08x msg_filc=%d\n",tpSendMsgCom,tpSendMsgCom->msg_filc);
*/
		for (i=0;i<tpSendMsgCom->msg_filc;i++) {
/*
printf("akb_create_pk_data: msg_filv[%d]=%08x\n",i,tpSendMsgCom->msg_filv[i]);
*/
			if (!(cpF=tpSendMsgCom->msg_filv[i])) return -3;
/*
printf("akb_create_pk_data: i=%d cpF=%08x [%s]\n",i,cpF,cpF);
*/
			if (!(l=strlen(cpF))) return -4;
			lPackLen += l+4+sizeof(INT4);
		}
		if (!(cpPacket=Malloc(lPackLen+1))) return D_ERR_MEM_ALLOC;
		*cppPacket = cpPacket;
		lw = lPackLen - iHSize;
		tpHead->cph_plen = htonl(lw);
		memcpy(cpPacket,tpHead,iHSize);
		cp = cpPacket + iHSize;
		*cp++ = 'P';
		*cp++ = '\0';
		*cp++ = '\0';
		*cp++ = '\0';
		lw = htonl(tpSendMsgCom->msg_mlen);
		memcpy(cp,(char *)&lw,sizeof(INT4));
		cp += sizeof(INT4);
		if (tpSendMsgCom->msg_mlen && tpSendMsgCom->msg_pmsg)
			memcpy(cp,tpSendMsgCom->msg_pmsg,tpSendMsgCom->msg_mlen);
		cp += tpSendMsgCom->msg_mlen;
		for (i=0;i<tpSendMsgCom->msg_filc;i++) {
			if (!(cpF = tpSendMsgCom->msg_filv[i])) return -3;
			l   = strlen(cpF);
			*cp++ = 'F';
			*cp++ = l + sizeof(INT4);
			*cp++ = '\0';
			*cp++ = '\0';
			if (stat(akb_akb_home_add(cpF),&tStat)) return -5;
			lFileLen = tStat.st_size;
			lw = htonl(lFileLen);
			memcpy(cp,(char *)&lw,sizeof(INT4));
			cp += sizeof(INT4);
			memcpy(cp,cpF,l);
			cp += l;
		}
		tpHead = (pCommPackHead)cpPacket;
		tpHead->cph_prt.prt_send |= AKB_PFM_INDIRECT;
	}
	else {
		if ((l=tpSendMsgCom->msg_mlen) > 0) l++;
		if (!(cpPacket=Malloc(iHSize+l)))
			return -6;
		tpHead->cph_plen = htonl(tpSendMsgCom->msg_mlen);
		memcpy(cpPacket,tpHead,iHSize);
		if (tpSendMsgCom->msg_mlen && tpSendMsgCom->msg_pmsg)
			memcpy(cpPacket+iHSize,tpSendMsgCom->msg_pmsg,
			       tpSendMsgCom->msg_mlen);
	}
	*cppPacket = cpPacket;
	tpHead = (pCommPackHead)cpPacket;
	AKBGETHSIZEETC(tpHead,cver,iHSize,lLen)
	lPackLen = iHSize + lLen;
	return lPackLen;
}

/********************************************************/
/*														*/
/********************************************************/
int akb_set_recv_msg(pPacket,tpRcMsg,cppFilev,cppToFree)
char       *pPacket;
tdtMsgCom  *tpRcMsg;
char       **cppFilev;
char       **cppToFree;
{
	tdtCommPackHead   *pHead,tHead;
	char *pPa, cver;
	int iRc,iHSize;
	INT4 lLen, lm, ld, lw;

	if (!pPacket || !tpRcMsg || !cppToFree) {
/*
printf("akb_set_recv_msg: pPacket=%08x tpRcMsg=%08x cppToFree=%08x\n",pPacket,tpRcMsg,cppToFree);
*/
		return -1;
	}
	pHead = (pCommPackHead)pPacket;
	AKBGETHSIZE(pHead,iHSize)
	*cppToFree = NULL;
	pPa = pPacket;

	memset(tpRcMsg,0,sizeof(tdtMsgCom));
	pHead = (pCommPackHead)pPa;
	AKBGETHSIZE(pHead,iHSize)
	cver = pHead->cph_prt.prt_ver;
	tpRcMsg->msg_form = pHead->cph_prt.prt_send;
	if (pHead->cph_sinf.ind_thrd) {	/* Command */
		tpRcMsg->msg_disp = 0;
		tpRcMsg->msg_aopt  |= pHead->cph_dinf.ind_disp;
		tpRcMsg->msg_pret      = ntohs(pHead->cph_dinf.ind_pano);
		tpRcMsg->msg_resv        = pHead->cph_sinf.ind_disp;
	}
	else {
		tpRcMsg->msg_disp = pHead->cph_dinf.ind_disp;
		tpRcMsg->msg_aopt  |= pHead->cph_sinf.ind_disp;
		tpRcMsg->msg_pret      = ntohs(pHead->cph_sinf.ind_pano);
	}
/*	tpRcMsg->usClassId = ntohs(pHead->SrcInf.usClassId);	*/
	lLen = ntohl(pHead->cph_plen);
	tpRcMsg->msg_pmsg   = NULL;
	tpRcMsg->msg_filc = 0;
	tpRcMsg->msg_filv = cppFilev;
	if (lLen < 0) return -3;
	else if (lLen > 0) {
		pPa += iHSize;
	    if (tpRcMsg->msg_form & AKB_PFM_INDIRECT) {
			while (lLen>8) {
				lm = *(unsigned char *)(pPa+1);
				memcpy((char *)&lw,pPa+4,sizeof(INT4));
				ld = ntohl(lw);
				if (ld < 0) return -4;
				if (*pPa== 'P') {
					if (ld > 0)
						tpRcMsg->msg_pmsg = pPa + 4 + sizeof(INT4);
					else
						tpRcMsg->msg_pmsg = NULL;
					tpRcMsg->msg_mlen = lm = ld;
				}
				else if (*pPa== 'F') {
					if (!tpRcMsg->msg_filv) {
						if (!(tpRcMsg->msg_filv=(char **)Malloc(256*sizeof(char *))))
							return -5;
					}
					lm -= sizeof(INT4);
					memcpy(pPa+1,pPa+8,lm);
					*(pPa+1+lm) = '\0';
					memcpy(pPa+lm+2,(char *)&ld,sizeof(INT4));
					if (tpRcMsg->msg_filc < 255)
						tpRcMsg->msg_filv[tpRcMsg->msg_filc++] = pPa+1;
				}
				else return -6;
				pPa  += lm + 4 + sizeof(INT4);
				lLen -= lm + 4 + sizeof(INT4);
			}
		}
		else {
			tpRcMsg->msg_mlen = lLen;
			tpRcMsg->msg_pmsg   = pPa;
		}
	}
	if (tpRcMsg->msg_filv) tpRcMsg->msg_filv[tpRcMsg->msg_filc] = NULL;

	return 0;
}
