static	char	sccsid[]="%Z% %M% %I% %E% %U%";
#include "colmn.h"

/****************************************/
/* clesc_cut()							*/
/****************************************/
int clesc_cut(prp,len,p)
char *prp,*p;
int len;
{
	int n;
	char c;

	n = 0;
	while (len--) {
		if ((c=*prp++) != ESCAPE_CODE) {
			*p++ = c;
			n++;
		}
	}
	return n;
}

/****************************************/
/* clcnvt_index()						*/
/****************************************/
int clcnvt_index(sz,dlm)
char *sz,*dlm;
{
	char *p,c,*pFind,cb1,cb2;
	int i,j;

	p=sz;
/*
printf("clcnvt_index:sz=[%s]\n",p);
*/
	if ((c=*p)=='$' || c=='%' || c=='#') {
		i = clcnvt_index(p+1,dlm) + 1;
	}
	else if (c=='{' || c=='(') {
		cb1 = c;
		if (c=='{') cb2 = '}';
		else cb2 = ')';
		i=j=1;
		p++;
		while (c=*p++) {
			i++;
			if (c==cb1) j++;
			else if (c==cb2) {
				if (--j == 0) {
					*p = '\0';
					break;
				}
			}
		}
	}
	else {
		i=0;
		while (c=*p++) {
			if (c == ESCAPE_CODE) {
				i++;
				p++;
			}
			else if (c=='[') break;
			else if (strchr(dlm,c)) break;
			i++;
		}
		if (c=='[') {
			j=1;
			p++;
			i += 2;
			while (c=*p++) {
				i++;
				if (c=='[') j++;
				else if (c==']') {
					if (--j == 0) {
						*p = '\0';
						break;
					}
				}
			}
		}
	}
/*
printf("clcnvt_index:i=%d sz=[%s]\n",i,sz);
*/
	return i;
}

/****************************************/
/* clcnvtb2c_opt()						*/
/****************************************/
int clcnvtb2c_opt(bip,len,bu,rlen,opt)
char *bip, *bu;
int  len,rlen,opt;
{
#if 1	/* 2022.10.15 */
	int interval;

	interval = len;
	if (!(opt & 0x02)) {
		if (D_BULK_TYPE == 3) interval = 1;
	}
	return akxcxtocn(bip,len,bu,rlen,interval);
#else
	char *bp, *p;
	int  i, iHigh, iLow, rlen;

	if (!bip || !bu) return -1;
	else if (len<=0) return len;

	rlen = len*D_BULK_TYPE;
	bp = bip;
	p = bu;
	for (i=0; i<len; i++) {
		iHigh = *bp >> 4 & 0x0F;
		iLow  = *bp++ & 0x0F;
		if (iHigh >= 10)
			*p++ = (iHigh - 10) + 'a';
		else
			*p++ = iHigh + 0x30;
		if (iLow >= 10)
			*p++ = (iLow - 10) + 'a';
		else
			*p++ = iLow  + 0x30;
#if D_BULK_TYPE == 3
		*p++ = ' ';
#endif
	}
	*p = '\0';
	return rlen;
#endif
}

/****************************************/
/* clcnvtb2c()							*/
/****************************************/
int clcnvtb2c(bip,len,bu)
char *bip, *bu;
int  len;
{
	return clcnvtb2c_opt(bip,len,bu,INT_MAX,0);
}

/****************************************/
/* int cl_sqlcnvt_data()				*/
/****************************************/
int cl_sqlcnvt_data(pPrm,ppRslt,piRsltLen,opt)
tdtInfoParm *pPrm;
char **ppRslt;
int   *piRsltLen,opt;
{
	int i,attr,len,Value,ret,len_n,rlen;
	char *szItoA,*pBulk,*dat,*p;
	double dValue;
	char   w1[16];

	*ppRslt = NULL;
	*piRsltLen = 0;
	if ((dat=pPrm->pi_data) == NULL) {
		return NormalEnd;
	}
	ret = 0;
	len = pPrm->pi_dlen;
	attr = pPrm->pi_attr;
	if (attr==DEF_ZOK_BULK && !(opt & 0x01)) {
		rlen = len + 6;
		if((p = Malloc(rlen)) == NULL) return ECL_SYSTEM_ERROR;
		pBulk = p;
		*pBulk++ = 0x50;
		*pBulk++ = 0x00;
		len_n = htonl(len);
		memcpy(pBulk,&len_n,sizeof(int));
		pBulk += sizeof(int);
		memcpy(pBulk,dat,len);
		*ppRslt    = p;
		*piRsltLen = rlen;
	}
	else {
		dat = w1;
		if ((len = parm_to_char(pPrm,&dat,NULL))<0) {
			return  ECL_SCRIPT_ERROR;
		}
		if (*ppRslt=Malloc(len+1)) {
			memzcpy(*ppRslt,dat,len);
			*piRsltLen = len;
		}
		else ret = ECL_SYSTEM_ERROR;
	}
	return ret;
}

/****************************************/
/* cl_sqlcnvt()							*/
/****************************************/
int cl_sqlcnvt(pszSQL,ppszRet)	/* K-00040 */
char *pszSQL,**ppszRet;	/* K-00040 */
{
	int ret,iSqlLen;

	ret = 0;
	if (pszSQL) {
		if (!ppszRet) ret = -1;
		else {
			if ((iSqlLen=strlen(pszSQL)) > 0) {
				ret = cl_sqlncnvt(pszSQL,iSqlLen,ppszRet,0);
			}
			else *ppszRet = NULL;
		}
	}
	return ret;
}

/************************************************/
/* cl_sqlncnvt()								*/
/*		opt : 0x01: bulk16iɕϊ	*/
/************************************************/
int cl_sqlncnvt(pszSQL,iSqlLen,ppszRet,opt)
char *pszSQL,**ppszRet;
int iSqlLen,opt;
{
	static char derimitor[] = " ,'=%$#\n\t()<>[]{}!^+-*/.&|@~\"\\;";
	static char *szRetBuff=NULL;
	static long szRetBuffLen=0;
	char szWorkb[4096],*szWork,*pWork,c,*pGet;
	int  iWrtPos,iCnt,iGet;
	parmList   pl;
	tdtInfoParm *ppL,InfoParm;
	ScrPrCT *pScCT;
	int rc,iSaveLen;

	if (!pszSQL || iSqlLen <= 0) {
		if (ppszRet) *ppszRet = NULL;
		return 0;
	}
	if (!ppszRet) return -1;
	if (!(pScCT = cl_search_src_ct())) return ECL_SYSTEM_ERROR;

	if (szRetBuff) Free(szRetBuff);
	szRetBuffLen=0;
	szRetBuff = NULL;
	*ppszRet = NULL;
	pWork = NULL;
	if (iSqlLen+1>4096) {
		if (!(pWork=Malloc(iSqlLen+1))) return ECL_SYSTEM_ERROR;
		szWork = pWork;
	}
	else
		szWork = szWorkb;
	memcpy(szWork,pszSQL,iSqlLen+1);
	szRetBuffLen=((iSqlLen+4096)/4096)*4096;	/* I[NULL+1̂ŁAiSqlLen+̂4096ŗǂ */
	if (!(szRetBuff=Malloc(szRetBuffLen))) {
		if (pWork) Free(pWork);	/* K-00040 */
		return ECL_SYSTEM_ERROR;
	}

	iWrtPos = 0;
	iGet = 0;
	pGet = NULL;
	for (iCnt=0;iCnt<iSqlLen;) {
		c = pszSQL[iCnt];
		switch( c ) {
		case '%' :
		case '$' :
		case '#' :
			if (pl.prmlen=clcnvt_index(&szWork[iCnt+1],derimitor)) {
				pl.prmlen++;
				pl.prp = &szWork[iCnt];
				iSaveLen = pl.prmlen;
				pl.prmlen = clesc_cut(pl.prp,pl.prmlen,pl.prp);
				if (akxnskipto(pl.prp,pl.prmlen,"([") >= pl.prmlen)
					rc = cl_gx_get_info_parm(pScCT,'r',&pl,&ppL);
				else {
					ppL = &InfoParm;
					rc = cl_gx_expsn_obj_opt(pl.prp,pl.prmlen,NULL,NULL,ppL,0);
				}
				if (rc) {
					if (pWork) Free(pWork);	/* K-00040 */
					return rc;
				}
				pl.prmlen = iSaveLen;
				if (!cl_sqlcnvt_data(ppL,&pGet,&iGet,opt)) {
					if (iWrtPos+iGet+1>szRetBuffLen) {	/* K-00040 */
						szRetBuffLen=((iWrtPos+iGet+4096)/4096)*4096;
						if (!(szRetBuff=Realloc(szRetBuff,szRetBuffLen))) {
							if (pWork) Free(pWork);	/* K-00040 */
							return ECL_SYSTEM_ERROR;
						}
					}
					iWrtPos += cmn_mem_wrt( &szRetBuff[ iWrtPos ], pGet, iGet );
					iCnt += pl.prmlen;
					szWork[iCnt] = pszSQL[iCnt];
					if (pGet) Free(pGet);	/* A.Koba 6.19 */
					break;
				}
				else {
					if (pWork) Free(pWork);	/* K-00040 */
					return ECL_SCRIPT_ERROR;
				}
			}
		default :
			if (c == ESCAPE_CODE) {
				if (++iCnt < iSqlLen) szRetBuff[iWrtPos] = pszSQL[iCnt];
			}
			else szRetBuff[iWrtPos] = c;
			iWrtPos++;
			iCnt++;
			if (iWrtPos+1>szRetBuffLen) {	/* K-00040 */
				szRetBuffLen=((iWrtPos+4096)/4096)*4096;
				if (!(szRetBuff=Realloc(szRetBuff,szRetBuffLen))) {
					if (pWork) Free(pWork);	/* K-00040 */
					return ECL_SYSTEM_ERROR;
				}
			}
		}
	}
	szRetBuff[iWrtPos] = '\0';
	if (pWork) Free(pWork);	/* K-00040 */
	*ppszRet = szRetBuff;

DEBUGOUTL1(170,"cl_sqlcnvt: szRetBuff=[%s]",szRetBuff);

	return iWrtPos ;	/* K-00040 */
}
