static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  萔ϊ ( l )                                      *
*                                                                             *
*      ֐@@@F@int cl_conv_sysvar( pparmList , pInfoParm )            *
*                      (I)prmList	*pparmList                                *
*                      (O)tdtInfoParm	*pInfoParm                            *
*                                                                             *
*            F@Ȃ                                                   *
*                                                                             *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern CLCOMMON CLcommon;
extern GlobalCt *pGlobTable;
extern M_FILE *m_stdin,*m_stdout,*m_stderr;

static int getverdate();

static int clgetdate(buf,len)
char *buf;
int len;
{
	char *p; /* yyyy/mm/dd hh:mi:ss */

	p = akx_log_time();
	memcpy(buf,p,4);
	memcpy(buf+4,p+5,2);
	memcpy(buf+6,p+8,2);
	*(buf+8) = '\0';
	return 8;
}

static int clgettime(buf,len)
char *buf;
int len;
{
	char *p; /* yyyy/mm/dd hh:mi:ss */

	p = akx_log_time();
	memcpy(buf,p+11,2);
	memcpy(buf+2,p+14,2);
	memcpy(buf+4,p+17,3);
	return 6;
}

int clgetsysdate(ma)
MPA *ma;
{
	time_t  tw;
	struct  tm *stm;
	struct  timeval tval;

	akxe_get_msec(NULL,&tval);
	tw  = tval.tv_sec;
/*
printf("clgetsysdate: sec=%d usec=%d %08x\n",tw,tval.tv_usec,tval.tv_usec);
*/
	stm = localtime(&tw);
	return akxc_tm2mpa(ma,stm,tval.tv_usec);
}

int cl_conv_sysvar(pparmList, pInfoParm)
parmList   *pparmList;
tdtInfoParm  *pInfoParm;
{
	int  rc,i,id;
	int  vrtype,vrlen,vrlen1,len;
	long lValue;
	ulong ulValue;
	double dVal;
	char *pBuff,*pGlob,buf[64],*pv,**pName,*p,*nam;
	ScrPrCT *scrprct;
	ProcCT  *proc;
	tdtExtValName *pExv;
	tdtException *ep;
	MPA maz,*ma;

	if (!pparmList || !pInfoParm) {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return ECL_SYSTEM_ERROR;
	}
	if (!pparmList->prp) {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return ECL_SYSTEM_ERROR;
	}

	nam = pparmList->prp;
	len = pparmList->prmlen;
/*
printf("cl_conv_sysvar: name=[%s] len=%d\n",nam,len);
*/
	ma = (MPA *)cl_get_tmpMPA(&maz);
	if (*nam == '$') {
		nam++;
		len--;
	}
	if (ep=cl_get_exception_name(nam,len,0)) {
		lValue = ep->id;
		vrtype = DEF_ZOK_BINA;
		vrlen = sizeof(long);
	}
	else if (pExv = cl_get_sysvar_name(nam,len,0)) {
		vrtype = pExv->attr;
		id     = pExv->id;
		vrlen = sizeof(long);
/*
printf("cl_conv_sysvar: name=[%s] vrtype=%d id=%d\n",nam,vrtype,id);
*/
		if (id>=D_EXV_CHAR && id<=D_EXV_DOUBLE) {
			lValue = id - D_EXV_CHAR + DEF_ZOK_CHAR;
			if (lValue > 7) lValue -= 6;
		}
		else if (id==D_EXV_UINT || id==D_EXV_ULONG) lValue = DEF_ZOK_BINA | DEF_ZOK_USMASK;
		else if (id>=D_EXV_SYSCODE && id<=D_EXV_EBCDIK)
				lValue = id - D_EXV_SYSCODE + CD_TYPE_SYSTEM;
		else if (id == D_EXV_WIDE)   lValue = CD_TYPE_WIDE;
		else if (id == D_EXV_NARROW) lValue = CD_TYPE_NARROW;
		else if (id>=D_EXV_UPPER && id<=D_EXV_PROPER)
				lValue = id - D_EXV_UPPER + CD_TYPE_UPPER;
		else if (id == D_EXV_HEBON)  lValue = CD_TYPE_HEBON;
		else {
			switch (id) {
			case D_EXV_ERROR:
				lValue = pGlobTable->error;
				break;
		
			case D_EXV_ERRMSG:
				if (pGlobTable->err_hist[0].parlen > 0) pGlob = pGlobTable->err_hist[0].par;
				else pGlob = pGlobTable->errmsg;
				vrlen = strlen(pGlob);
				break;
		
			case D_EXV_ERRNO:
				lValue = pGlobTable->err_no;
				break;
			case D_EXV_STRERROR:
				pGlob = strerror(pGlobTable->err_no);
				vrlen = strlen(pGlob);
				break;
			case D_EXV_TUPLE:
				lValue = pGlobTable->tuppl;
				break;
			case D_EXV_COLUMN:
				lValue = pGlobTable->column;
				break;
			case D_EXV_USERID:
				pGlob = pGlobTable->usrcod;
				if ((vrlen=strlen(pGlob))>16) vrlen = 16;
				break;
			case D_EXV_DATE:
				pGlob = buf;
				vrlen=clgetdate(buf,64);
				break;
			case D_EXV_TIME:
				pGlob = buf;
				vrlen=clgettime(buf,64);
				break;
			case D_EXV_DATETIME:
				pGlob = akx_log_time();
				vrlen = strlen(pGlob);
				break;
			case D_EXV_HID:
				pGlob = pGlobTable->Hid;
				vrlen = strlen(pGlob);
				break;
			case D_EXV_EXCEPTION:
				if (!(lValue = pGlobTable->exception)) {
					proc = cl_search_proc_ct();
					lValue = proc->exception;
				}
				break;
			case D_EXV_USERINF:
				pGlob = pGlobTable->usrinf;
				vrlen = strlen(pGlob);
				break;
			case D_EXV_VERSION:
				vrlen = getverdate(0,&pGlob);
				break;
			case D_EXV_MAKEDATE:
				vrlen = getverdate(1,&pGlob);
				break;
			case D_EXV_STDIN:
				lValue = (long)m_stdin;
				break;
			case D_EXV_STDOUT:
				lValue = (long)m_stdout;
				break;
			case D_EXV_STDERR:
				lValue = (long)m_stderr;
				break;
			case D_EXV_SCRIPTNAME:
				if (scrprct = cl_search_src_ct())
					pGlob = scrprct->pId;
				else pGlob = AKX_NULL_PRINT;
				vrlen = strlen(pGlob);
				break;
			case D_EXV_PROCNAME:
				if (proc = cl_search_proc_ct())
					pGlob = proc->ProcNM;
				else pGlob = AKX_NULL_PRINT;
				vrlen = strlen(pGlob);
				break;
			case D_EXV_SCRIPTLINE:
				lValue = pGlobTable->script_line;
				break;
			case D_EXV_NULL:
				return cl_null_parm(pInfoParm);
				break;
			case D_EXV_PI:
				dVal = M_PI;
				break;
			case D_EXV_PI2:
				rc = m_set_a(ma,MPA_PI_STR);
				break;
			case D_EXV_M_E:
				dVal = M_E;
				break;
			case D_EXV_M_E2:
				rc = m_set_a(ma,MPA_ME_STR);
				break;
			case D_EXV_SYSDATE:
				rc = clgetsysdate(ma);
				break;
			case D_EXV_CHAR_MIN:
				lValue = CHAR_MIN;
				break;
			case D_EXV_CHAR_MAX:
				lValue = CHAR_MAX;
				break;
			case D_EXV_UCHAR_MAX:
				lValue = UCHAR_MAX;
				break;
			case D_EXV_SHORT_MIN:
				lValue = SHRT_MIN;
				break;
			case D_EXV_SHORT_MAX:
				lValue = SHRT_MAX;
				break;
			case D_EXV_USHORT_MAX:
				lValue = USHRT_MAX;
				break;
			case D_EXV_INT_MIN:
				lValue = INT_MIN;
				break;
			case D_EXV_INT_MAX:
				lValue = INT_MAX;
				break;
			case D_EXV_UINT_MAX:
				ulValue = UINT_MAX;
			/*	rc = m_set_a(ma,MPA_UINT_MAX_STR);	*/
				break;
			case D_EXV_LONG_MIN:
				lValue = LONG_MIN;
				break;
			case D_EXV_LONG_MAX:
				lValue = LONG_MAX;
				break;
			case D_EXV_ULONG_MAX:
				ulValue = ULONG_MAX;
			/*	rc = m_set_a(ma,MPA_ULONG_MAX_STR);	*/
				break;
			case D_EXV_CODE_TYPE:
				lValue = akxt_get_code_type();
				break;
			case D_EXV_EOF:
				lValue = ECL_END_OF_FILE;	/* EOF; 2022.6.24 */
				break;
			case D_EXV_IN_ERROR:
				lValue = ECL_IN_ERROR;
				break;
			default:
				return ECL_SYSTEM_ERROR;
			}
		}
	}
	else {
		return ECL_SCRIPT_ERROR;
	}

	if (vrtype == DEF_ZOK_CHAR) {
		if  (!(pBuff = cl_const_malloc(vrlen+1))) {
			ERROROUT("const_malloc error.");
			return rc;
		}
		memzcpy(pBuff,pGlob ,vrlen);
		cl_set_parm_char(pInfoParm,pBuff,vrlen);
	}
	else if (vrtype == DEF_ZOK_FLOA) {
		cl_set_parm_double(pInfoParm,dVal);
	}
	else if (vrtype == DEF_ZOK_BINA) {
		cl_set_parm_long(pInfoParm,lValue);
	}
	else if (vrtype==DEF_ZOK_DECI || vrtype==DEF_ZOK_DATE) {
		cl_set_parm_mpa(pInfoParm,ma);
		pInfoParm->pi_attr = vrtype;
	}
	else if (vrtype==DEF_ZOK_UINT || vrtype==DEF_ZOK_ULNG) {
		cl_set_parm_long(pInfoParm,ulValue);
		pInfoParm->pi_scale |= D_DATA_UNSIGNED;
	}
	else {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return -1;
	}
	pInfoParm->pi_aux[1] = D_AUX1_PROTECTED;
	return NORMAL;
}

static int getverdate(i,pd)
int  i;
char **pd;
{
	char *pVD[2];
	int  iVDL[2];

	aka_get_ver_date(pVD,iVDL);
	*pd = pVD[i];

	return iVDL[i];
}
