static char sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************************************
*																			*
*	ړI	F	lZ											*
*																			*
*	֐		F	int cl_cmpt_math(pAns, pOprtr, pInfoParm1, pInfoParm2)	*
*						(O)int		 *pAns									*
*						(I)char		 *pOprtr								*
*						(I)tdtInfoParm *pInfoParm1							*
*						(I)tdtInfoParm *pInfoParm2							*
*																			*
*	߂l		F	ERROR													*
*					NORMAL													*
*																			*
*	Tv	F															*
*																			*
*****************************************************************************/
#include <colmn.h>

extern GlobalCt  *pGlobTable;
extern int giOptions[];

/* static int over_or_under; 2019.8.31 */

/****************************************/
/*										*/
/****************************************/
static int _cmpt_power(pAns, pOprtr, pInfoParm1, pInfoParm2,iParm)
int			*pAns;
char		*pOprtr;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int			iParm[];
{
	int rc;
	tdtInfoParm	*ppParm[2];

	ppParm[0] = pInfoParm1;
	ppParm[1] = pInfoParm2;
	if (rc=func_math(pAns,"**",2,ppParm,D_FUC_POWER)) return rc;
	iParm[0] = DEF_ZOK_FLOA;
	iParm[1] = sizeof(double);
	return DEF_ZOK_FLOA;
}

/****************************************/
/*										*/
/****************************************/
static int _cmpt_mult(pAns,ntimes,pInfoParm1,iParm)
int *pAns;
long ntimes;
tdtInfoParm	*pInfoParm1;
int iParm[];
{
	int i,attr,rc;
	tdtInfoParm	tInfoParm,tInfoParmW;

	cl_set_parm_long(&tInfoParmW,0);
	cl_set_parm_long(&tInfoParm,1);
/*
printf("_cmpt_mult: ntimes=%d\n",ntimes);
*/
#if 1	/* 2019.8.31 */
	iParm[4] = 0;
#else
	over_or_under = 0;
#endif
	for (i=0;i<ntimes;i++) {
		if ((rc=cl_gx_bexp(&tInfoParmW,&tInfoParm,"*",pInfoParm1,0,NULL)) < 0) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ+5,"_cmpt_mult: i=%d",&tInfoParmW,i,0);

		cl_gx_copy_info(&tInfoParm,&tInfoParmW);
#if 1	/* 2019.8.31 */
		if (tInfoParmW.pi_alen & D_AULN_OVERFLOW) {
			iParm[4] = D_AULN_OVERFLOW;
#else
		if (over_or_under) {
#endif
			pGlobTable->error = 0;
			break;
		}
	}
	memcpy(pAns,tInfoParm.pi_data,tInfoParm.pi_dlen);
	iParm[0] = tInfoParm.pi_attr;
	iParm[1] = tInfoParm.pi_dlen;
	return tInfoParm.pi_attr;
}

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_math(pAns, pOprtr, pInfoParm1, pInfoParm2,iParm)
int			*pAns;
char		*pOprtr;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int			iParm[];
{
	int		rc,atr1,atr2,iAttr[3],opt,exception_save,over_or_under;
	int		Val1[NMPA_INT],Val2[NMPA_INT];
	long	Value1,Value2,Value3;
	double	dValue1,dValue2,dVal;
	char	op,*p;
	MPA		*mpa1,*mpa2;

	over_or_under = 0;
#if 1	/* 2019.8.31 */
	mem_set_int(iParm,0,5);
#else
	iParm[0] = iParm[1] = 0;
#endif
	if (!stricmp(pOprtr,"MOD")) op = '%';
	else op = *pOprtr;
	if (op=='*' && pOprtr[1]=='*') {
		if ((rc=cl_get_parm_mpa(pInfoParm2,Val2,"Parm2:",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		atr2 = iAttr[0];
		if (atr2 == DEF_ZOK_BINA) {
			Value2 = CL_GET_VAL_BIN(Val2);
			if (Value2 > 10) op = 'P';
		}
		else op = 'P';
/*
printf("cl_cmpt_math: atr2=%d op=%c\n",atr2,op);
*/
		if (op == 'P') return _cmpt_power(pAns,pOprtr,pInfoParm1,pInfoParm2,iParm);
		else return _cmpt_mult(pAns,Value2,pInfoParm1,iParm);
	}
	exception_save = pGlobTable->exception;
	pGlobTable->exception = MATH_ETC_ERROR_EXCEPTION;

	if ((rc=cl_get_parm_mpa(pInfoParm1,Val1,"Parm1:",iAttr)) < 0) return rc;
	else if (rc > 0) return ECL_SCRIPT_ERROR;
	atr1 = iAttr[0];
	if (atr1 == DEF_ZOK_BINA) Value1 = CL_GET_VAL_BIN(Val1);
	else if (atr1 == DEF_ZOK_FLOA) memcpy(&dValue1,Val1,sizeof(double));
	else if (atr1 == DEF_ZOK_DECI) ;
	else return ECL_SCRIPT_ERROR;
	mpa1 = (MPA *)Val1;

	if (pInfoParm1 == pInfoParm2) {
		atr2 = atr1;
		Value2 = Value1;
		dValue2 = dValue1;
		mpa2 = mpa1;
	}
	else if (pInfoParm2) {
		if ((rc=cl_get_parm_mpa(pInfoParm2,Val2,"Parm2:",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		atr2 = iAttr[0];
		if (atr2 == DEF_ZOK_BINA) Value2 = CL_GET_VAL_BIN(Val2);
		else if (atr2 == DEF_ZOK_FLOA) memcpy(&dValue2,Val2,sizeof(double));
		else if (atr2 == DEF_ZOK_DECI) ;
		else return ECL_SCRIPT_ERROR;
		mpa2 = (MPA *)Val2;
	}
	else {
		atr2 = atr1;
		Value2 = 0;
		dValue2 = 0.0;
		mpa2 = (MPA *)Val2;
		*mpa2 = *m_get_i(0);
	}
	pGlobTable->exception = exception_save;

DEBUGOUTL3(LVL_GXEXOBJ,"cl_cmpt_math: atr1=%d op=[%c] atr2=%d",atr1,op,atr2);

	if (op=='+' || op=='-' || op=='*' || op=='/' || op=='.' || op=='%') {
		if ((atr1==DEF_ZOK_FLOA || atr2==DEF_ZOK_FLOA) && op!='%') {
			iParm[1] = sizeof(double);
			if (atr1 == DEF_ZOK_BINA) dValue1 = Value1;
			else if (atr1 == DEF_ZOK_DECI) m_dset(&dValue1,mpa1);
			if (atr2 == DEF_ZOK_BINA) dValue2 = Value2;
			else if (atr2 == DEF_ZOK_DECI) m_dset(&dValue2,mpa2);

DEBUGOUTL2(LVL_GXEXOBJ,"cl_cmpt_math: dValue1=%f dValue2=%f",dValue1,dValue2);

			switch( op ) {
			case '+':
				dVal = dValue1 + dValue2;
				break;
			case '-':
				dVal = dValue1 - dValue2;
				break;
			case '*':
				dVal = dValue1 * dValue2;
				break;
			case '/':
				if (dValue2 == 0.0) {
					ERROROUT(FORMAT(261));	/* zerofBoCh܂B */
					pGlobTable->exception = MATH_COMP_DEVIDE_EXCEPTION;
					return ECL_SCRIPT_ERROR;
				}
				dVal = dValue1 / dValue2;
				break;
			case '.':
				*pAns = sizeof(double);
				p = (char *)(pAns+1);
				memcpy(p,&dValue1,sizeof(double));
				memcpy(p+sizeof(double),&dValue2,sizeof(double));
				iParm[0] = DEF_ZOK_FLOA;
				return DEF_ZOK_FLOA;
			}
			memcpy(pAns,&dVal,sizeof(double));
			iParm[0] = DEF_ZOK_FLOA;
			return DEF_ZOK_FLOA;
		}
		else if (atr1==DEF_ZOK_DECI || atr2==DEF_ZOK_DECI ||
		         ((atr1==DEF_ZOK_FLOA || atr2==DEF_ZOK_FLOA) && op=='%')) {
			iParm[1] = sizeof(MPA);
			if (atr1 == DEF_ZOK_BINA) m_i2mpa(Value1,mpa1);
			else if (atr1 == DEF_ZOK_FLOA) m_d2mpa(dValue1,mpa1);
			if (atr2 == DEF_ZOK_BINA) m_i2mpa(Value2,mpa2);
			else if (atr2 == DEF_ZOK_FLOA) m_d2mpa(dValue2,mpa2);
			switch( op ) {
			case '+':
				rc = m_add((MPA*)pAns,mpa1,mpa2);
				break;
			case '-':
				rc = m_sub((MPA*)pAns,mpa1,mpa2);
				break;
			case '*':
				rc = m_mul((MPA*)pAns,mpa1,mpa2);
				break;
			case '/':
			case '%':
				if (op == '/')
					rc = m_div((MPA*)pAns,mpa1,mpa2);
				else
					rc = m_mod((MPA*)pAns,mpa1,mpa2);
				if (rc == MPA_ERR_ZERODIVIDE) {
					ERROROUT(FORMAT(261));	/* zerofBoCh܂B */
					pGlobTable->exception = MATH_COMP_DEVIDE_EXCEPTION;
					return ECL_SCRIPT_ERROR;
				}
				break;
			case '.':
				*pAns = sizeof(MPA);
				p = (char *)(pAns+1);
				memcpy(p,mpa1,sizeof(MPA));
				memcpy(p+sizeof(MPA),mpa2,sizeof(MPA));
			}
#if 1	/* 2018.6.17 */
			if (rc) {
				rc = cl_chk_error_mpa(rc,NULL,NULL,0);
				if (rc) return ECL_SCRIPT_ERROR;
			}
#else
			if (rc > 0) {
				opt = pGlobTable->options[15];
				if (rc==MPA_ERR_OVERFLOW || rc==MPA_ERR_OVERFLOW_I) {
					if (opt & 0x01) {
						pGlobTable->error = ECL_DEC_OVERFLOW;
						rc = 0;
					}
					if (rc || (opt & 0x02))
						ERROROUT1(FORMAT(594),"MPA");	/* (W)%s: I[o[t[܂B */
				}
				else if (rc==MPA_ERR_UNDERFLOW) {
					if (!(opt & 0x04)) {
						pGlobTable->error = ECL_DEC_UNDERFLOW;
						rc = 0;
					}
					if (rc || (opt & 0x08))
						ERROROUT1(FORMAT(595),"MPA");	/* (W)%s: A_[t[܂B */
				}
				if (rc) return ECL_SCRIPT_ERROR;
			}
#endif
			iParm[0] = DEF_ZOK_DECI;
			return DEF_ZOK_DECI;
		}
	}

	if (!stricmp(pOprtr,"ABS")) {
		if (atr1 == DEF_ZOK_FLOA) {
			dVal = X_ABS(dValue2);
			memcpy(pAns,&dVal,sizeof(double));
			rc = DEF_ZOK_FLOA;
			iParm[1] = sizeof(double);
		}
		else if (atr1 == DEF_ZOK_DECI) {
			mpa1->sign = 0;
			memcpy(pAns,mpa1,sizeof(MPA));
			rc = DEF_ZOK_DECI;
			iParm[1] = sizeof(MPA);
		}
		else {
			*pAns = X_ABS(Value2);
			rc = DEF_ZOK_BINA;
			iParm[1] = sizeof(long);
		}
		iParm[0] = rc;
		return rc;
	}

	iParm[1] = sizeof(long);
	if (atr1 == DEF_ZOK_FLOA) Value1 = cl_chk_over_flow_d2_i(dValue1,"cl_cmpt_math:dVal1");
	else if (atr1 == DEF_ZOK_DECI) m_mpa2l(mpa1,&Value1);
	if (atr2 == DEF_ZOK_FLOA) Value2 = cl_chk_over_flow_d2_i(dValue2,"cl_cmpt_math:dVal2");
	else if (atr2 == DEF_ZOK_DECI) m_mpa2l(mpa2,&Value2);
	switch (op) {
		case '&':
			Value3 = Value1 & Value2;
			break;
		case '^':
			Value3 = Value1 ^ Value2;
			break;
		case '|':
			Value3 = Value1 | Value2;
			break;
		case '~':
			Value3 = ~ Value2;
			break;
		case '+':
			Value3 = Value1 + Value2;
			Value3 = cl_chk_over_flow_long_add(Value3,Value1,Value2,"Add",&over_or_under);
			break;
		case '-':
			Value3 = Value1 - Value2;
			Value3 = cl_chk_over_flow_long_add(Value3,Value1,-Value2,"Sub",&over_or_under);
			break;
		case '*':
			Value3 = Value1 * Value2;
			Value3 = cl_chk_over_flow_long_mult(Value3,Value1,Value2,"Mult",&over_or_under);
			break;
		case '%':
			if (!Value2) {
				/* MOD: zerofBoCh܂B */
				ERROROUT(stradd("MOD: ",FORMAT(261)));
				pGlobTable->exception = MATH_COMP_DEVIDE_EXCEPTION;
				return ECL_SCRIPT_ERROR;
			}
			Value3 = Value1 % Value2;
			break;
		case '/':
			if (!Value2) {
				ERROROUT(FORMAT(261));	/* zerofBoCh܂B */
				pGlobTable->exception = MATH_COMP_DEVIDE_EXCEPTION;
				return ECL_SCRIPT_ERROR;
			}
			Value3 = Value1 / Value2;
			break;
		case '.':
			iParm[1] = sizeof(int);
			pAns[0] = sizeof(int);
			pAns[1] = Value1;
			pAns[2] = Value2;
			iParm[0] = DEF_ZOK_BINA;
			return DEF_ZOK_BINA;
		default:
			if (!stricmp(pOprtr,"MOD")) {
				if (!Value2) {
					/* MOD: zerofBoCh܂B */
					ERROROUT(stradd("MOD: ",FORMAT(261)));
					pGlobTable->exception = MATH_COMP_DEVIDE_EXCEPTION;
					return ECL_SCRIPT_ERROR;
				}
				Value3 = Value1 % Value2;
			}
			else if(!strcmp(pOprtr, "<<"))
				Value3 = Value1 << Value2;
			else if(!strcmp(pOprtr, ">>"))
				Value3 = Value1 >> Value2;
			else {
				pGlobTable->exception = MATH_COMP_EXCEPTION;
				return ECL_SYSTEM_ERROR;
			}
	}
#if defined(_LP64)
	memcpy(pAns,&Value3,sizeof(long));
#else
	*pAns = Value3;
#endif
	iParm[0] = DEF_ZOK_BINA;
	iParm[4] = over_or_under;
	return DEF_ZOK_BINA;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_error_mpa(rc,pMsg,p,len)
int rc;
char *p,*pMsg;
int len;
{
	int opt;
	char buf[33];
/*
printf("cl_chk_error_mpa: rc=%d\n",rc);
*/
	opt = pGlobTable->options[15];
	if (rc==MPA_ERR_OVERFLOW || rc==MPA_ERR_OVERFLOW_I) {
		if (opt & 0x01) {
			pGlobTable->error = ECL_DEC_OVERFLOW;
			rc = 0;
		}
		if (rc || (opt & 0x02))
			ERROROUT1(FORMAT(594),"MPA");	/* (W)%s: I[o[t[܂B */
	}
	else if (rc==MPA_ERR_UNDERFLOW) {
		if (!(opt & 0x04)) {
			pGlobTable->error = ECL_DEC_UNDERFLOW;
			rc = 0;
		}
		if (rc || (opt & 0x08))
			ERROROUT1(FORMAT(595),"MPA");	/* (W)%s: A_[t[܂B */
	}
	else {
		opt = pGlobTable->options[16];
		if (rc==MPA_ERR_INVALID && (opt & 0x10)) 
			rc = 0;
		else {
			if (pMsg=cl_conv_msg_check(pMsg,rc)) {
				if (p)
					memnzcpy(buf,p,len,sizeof(buf)-1);
				else
					*buf = '\0';
				/* %sPOi_[%s]̎w肪Ă܂(rc=%d)B */
				ERROROUT3(FORMAT(308),pMsg,buf,rc);
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_long_add(Val3,Val1,Val2,name,pstat)
long Val3,Val1,Val2;
char *name;
int *pstat;
{
	long ret;
	int  over_or_under=0;

	ret = Val3;
	if (Val1>0 && Val2>0 && Val3<0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
#if defined(_LP64)
		ret = LONG_MAX;
#else
		ret = INT_MAX;
#endif
	}
	else if (Val1<0 && Val2<0 && Val3>0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
#if defined(_LP64)
		ret = LONG_MIN;
#else
		ret = INT_MIN;
#endif
	}
	if (pstat) *pstat = over_or_under;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_long_mult(Val3,Val1,Val2,name,pstat)
long Val3,Val1,Val2;
char *name;
int *pstat;
{
	long ret;
	int  over_or_under=0;

	ret = Val3;
	if (((Val1>0 && Val2>0) || (Val1<0 && Val2<0)) && Val3<0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
#if defined(_LP64)
		ret = LONG_MAX;
#else
		ret = INT_MAX;
#endif
	}
	else if (((Val1>0 && Val2<0) || (Val1<0 && Val2>0)) && Val3>0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
#if defined(_LP64)
		ret = LONG_MIN;
#else
		ret = INT_MIN;
#endif
	}
	if (pstat) *pstat = over_or_under;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
#if defined(_LP64)
int cl_get_parm_long(pInfoParm,pValue,pMsg)
#else
int cl_get_parm_bin(pInfoParm,pValue,pMsg)
#endif
tdtInfoParm *pInfoParm;
long *pValue;
char *pMsg;
{
	int rc,Val[NMPA_INT],iAttr[3];
	double dValue;
	long   lValue;

	if ((rc=cl_get_parm_mpa(pInfoParm,Val,pMsg,iAttr)) >= 0) {
		if (iAttr[0] == DEF_ZOK_DECI) {
			rc = m_mpa2l((MPA *)Val,pValue);
			if (rc == MPA_ERR_OVERFLOW_I) {
					/* (W)%s: (%s)I[ot[܂B */
				ERROROUT2(FORMAT(280),pMsg,m_mpa2str_exp((MPA *)Val,0,0,0));
				rc = 0;
			}
		}
		else if (iAttr[0] == DEF_ZOK_FLOA) {
			memcpy(&dValue,Val,sizeof(double));
#if 1	/* 2019.11.27 */
			*pValue = cl_chk_over_flow_d2_i(dValue,pMsg);
#else
			*pValue = dValue;
#endif
		}
		else
#if defined(_LP64)
			memcpy(pValue,Val,sizeof(long));
#else
			*pValue = Val[0];
#endif
		if (rc > 0) rc = -rc;
	}
	return rc;
}

#if defined(_LP64)
/****************************************/
/*										*/
/****************************************/
int cl_get_parm_bin(pInfoParm,pValue,pMsg)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
{
	long lVal;
	int rc;

	if ((rc=cl_get_parm_long(pInfoParm,&lVal,pMsg)) >= 0) {
		*pValue = lVal;
	}
	return rc;
}
#endif
#if 0
/****************************************/
/*										*/
/****************************************/
int cl_get_parm_bin_err(pInfoParm,pValue,pMsg)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
{
	int rc;

	if ((rc=cl_get_parm_bin(pInfoParm,pValue,pMsg)) > 0) rc = -rc;
	return rc;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_get_parm_mpa_opt(pInfoParm,pValue,pMsg,iAttr,opt)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
int  opt;
{
#ifdef GET_PARM_RANGE
	int rc;
	ushort len;

	len = pInfoParm->pi_alen;
	pInfoParm->pi_alen &= ~D_AULN_RANGE_DATA;
	rc = cl_get_parm_range_mpa(pInfoParm,pValue,pMsg,iAttr,opt);
	pInfoParm->pi_alen = len;
	return rc;
#else
	int rc,len,attr,iVal;
	double dVal;
	long lVal;
	char *p;
	struct tm stm;

	if (!pInfoParm || !pValue || !iAttr) return -1;
	if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
/*
printf("cl_get_parm_mpa: Attr=%d\n",pInfoParm->pi_attr);
*/
	rc = 0;
	p = pInfoParm->pi_data;
	len = pInfoParm->pi_dlen;
	if ((attr=pInfoParm->pi_attr) == DEF_ZOK_BINA) {
		if (len == sizeof(int)) lVal = cl_get_data_int(pInfoParm);
		else lVal = cl_get_data_long(pInfoParm);
		len = sizeof(long);
		memcpy(pValue,&lVal,len);
	}
	else if (attr==DEF_ZOK_FLOA || attr==DEF_ZOK_DECI) {
		memcpy(pValue,p,len);
	}
	else if (pInfoParm->pi_attr == DEF_ZOK_CHAR) {
#if 1
		return cl_conv_const_nsub(p,len,pValue,pMsg,iAttr,opt);
#else
		if ((rc=cl_conv_const_nsub(p,len,pValue,pMsg,iAttr,opt)) > 0) rc = ECL_SCRIPT_ERROR;
		return rc;
#endif
	}
	else if (pInfoParm->pi_attr == DEF_ZOK_DATE) {
		cl_mpa2tm(&stm,pInfoParm->pi_data);
		lVal = mktime(&stm);
		len = sizeof(long);
		memcpy(pValue,&lVal,len);
		attr = DEF_ZOK_BINA;
	}
	else {
		if (pMsg=cl_conv_msg_check(pMsg,-1)) {
			/* %s: p[^̌^l^ł͂܂B */
			ERROROUT1(FORMAT(266),pMsg);
		}
		rc = ECL_SCRIPT_ERROR;
	}
	iAttr[0] = attr;
	iAttr[1] = len;
	return rc;
#endif
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_mpa(pInfoParm,pValue,pMsg,iAttr)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
	int opt,attr;

	opt = pGlobTable->options[16];
#if 1	/* 2018.5.28 */
	attr = iAttr[0];
	if ((attr & 0xffffff00) == D_GX_OPT_USE_ATTR) attr &= 0xff;
	else attr = 0;
	iAttr[0] = attr;
#else
	iAttr[0] = 0;
#endif
	return cl_get_parm_mpa_opt(pInfoParm,pValue,pMsg,iAttr,opt);
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_double(pInfoParm,pValue,pMsg,iAttr)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
#ifdef GET_PARM_RANGE
	int rc;
	ushort len;

	len = pInfoParm->pi_alen;
	pInfoParm->pi_alen &= ~D_AULN_RANGE_DATA;
	rc = cl_get_parm_range_double(pInfoParm,pValue,pMsg,iAttr);
	pInfoParm->pi_alen = len;
	return rc;
#else
	int rc,Val[NMPA_INT],atr;
	double dval;

	if ((rc=cl_get_parm_mpa(pInfoParm,Val,pMsg,iAttr)) >= 0) {
		if ((atr=iAttr[0]) == DEF_ZOK_DECI) {
			rc = m_dset((double *)pValue,(MPA *)Val);
#if 1	/* 2019.11.27 */
		}
		else if (atr == DEF_ZOK_BINA) {
			dval = Val[0];
			memcpy(pValue,&dval,sizeof(double));
		}
		else memcpy(pValue,Val,sizeof(double));
		if (rc > 0) rc = ECL_SCRIPT_ERROR;	/* -rc; */
		iAttr[0] = DEF_ZOK_FLOA;
		iAttr[1] = sizeof(double);
#else
			iAttr[0] = DEF_ZOK_FLOA;
			iAttr[1] = sizeof(double);
		}
		else memcpy(pValue,Val,sizeof(double));
		if (rc > 0) rc = ECL_SCRIPT_ERROR;	/* -rc; */
#endif
	}
	return rc;
#endif
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_dec(pInfoParm,pValue,pMsg,iAttr)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
	int rc,Val[NMPA_INT],atr;
	double dVal;

	if ((rc=cl_get_parm_mpa(pInfoParm,Val,pMsg,iAttr)) >= 0) {
/*
printf("cl_get_parm_dec: rc=%d iAttr=%d %d Val=%d\n",rc,iAttr[0],iAttr[1],Val[0]);
*/
		rc = 0;
		if ((atr=iAttr[0]) == DEF_ZOK_BINA) {
			rc = m_l2mpa(Val[0],(MPA *)pValue);
		}
		else if (atr == DEF_ZOK_FLOA) {
			memcpy(&dVal,Val,sizeof(double));
			rc = m_d2mpa(dVal,(MPA *)pValue);
		}
		else {
			memcpy(pValue,Val,sizeof(MPA));
		}
		if (rc > 0) rc = ECL_SCRIPT_ERROR;	/* -rc; */
		iAttr[0] = DEF_ZOK_DECI;
		iAttr[1] = sizeof(MPA);
	}
/*
printf("cl_get_parm_dec:Exit rc=%d\n",rc);
*/
	return rc;
}

/****************************************/
/*										*/
/****************************************/
long cl_get_data_long(pInfoParm)
tdtInfoParm *pInfoParm;
{
	long lVal;

	if (pInfoParm->pi_scale == 0x40) lVal = pInfoParm->pi_pos;
	else memcpy((char *)&lVal,pInfoParm->pi_data,sizeof(long));
	return lVal;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_data_int(pInfoParm)
tdtInfoParm *pInfoParm;
{
	int iVal;

	if (pInfoParm->pi_scale == 0x40) iVal = pInfoParm->pi_pos;
	else memcpy((char *)&iVal,pInfoParm->pi_data,sizeof(int));
	return iVal;
}

/****************************************/
/*  oۑς݃f[^w̕ϐɐݒ肷 */
/****************************************/
int _ex_xhash_set_var(pInfoParm,pInfoParmI)
tdtInfoParm *pInfoParm, *pInfoParmI;
{
	char cId;
	tdtInfoParm ***pTBL;
	int  rc,ix;
	tdtArrayIndex tIndex;

DEBUGOUT_InfoParm(194,"_ex_xhash_set_var:IN ",pInfoParmI,0,0);
	if (rc=cl_get_array_index_tbl(pInfoParm,&tIndex,&pTBL,"_ex_xhash_set_var:"))
		return ECL_SCRIPT_ERROR;
#if 1	/* 2017.7.23 koba */
	ix = tIndex.index[3];
#else
	ix = tIndex.index[0];
#endif
	cId = pInfoParm->pi_id;
	if (cId == 'R')
		pInfoParm=cl_get_array_ent(tIndex.pVarIndex,ix);
	else pInfoParm = cl_get_var_ent(pTBL,ix);
	rc = cl_gx_rep_info_set(pInfoParm,pInfoParmI,1);
	if (rc) return ECL_SCRIPT_ERROR;
DEBUGOUT_InfoParm(194,"_ex_xhash_set_var: ix=%d cId=[%c]",pInfoParm,ix,cId);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_xhash(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	static char *_fn_="cl_ex_xhash";
	int  ret,rc;
	char w1[32],*p1,*key,*cpDat,**cppDat,cCmd,c0,c1,cId,atr;
	tdtInfoParm *pInfoParm,tInfoParm;
	tdtInfoParm ***pTBL;
	XHASHB *xhp;
	int  i,iVal[4],ix,len,klen,attr;
	static char *cval[]={"sKeyLen","lMaxReg","lPreReg","DataFlag"};
	tdtArrayIndex tIndex;
	double dVal;

	if (nparm > 5) {
		/* %s: ]ȃp[^(nparm=%d)܂B */
		ERROROUT2(FORMAT(267),_fn_,nparm);
		return ECL_SCRIPT_ERROR;
	}

	pInfoParm = ppParm[0];
	if (pInfoParm->pi_attr == DEF_ZOK_CHAR) {
		memnzcpy(w1,pInfoParm->pi_data,pInfoParm->pi_dlen,sizeof(w1)-1);
		if (!stricmp(w1,"New")) {
			memset(iVal,0,sizeof(int)*4);
			for (i=1;i<nparm;i++) {
				if (ret=cl_get_parm_bin(ppParm[i],&iVal[i-1],cval[i-1]))
					return ECL_SCRIPT_ERROR;
			}
DEBUGOUT4("_xhash: K=%d M=%d S=%d D=%d",iVal[0],iVal[1],iVal[2],iVal[3]);
			if (iVal[0] < 0) {
				ERROROUT(FORMAT(268));	/* Xhash: L[͂OȏłB */
				return ECL_SCRIPT_ERROR;
			}
			else if (iVal[0] > 0) iVal[0] += 8;
			if (iVal[3] > 0) iVal[3] = sizeof(tdtInfoParm);
			else iVal[3] = -2;
			xhp = akxs_xhashm_new2(iVal[0],iVal[1],iVal[2],iVal[3],cl_tmp_const_malloc,NULL);
/*
printf("_xhash: xha_id[1]=[%c]\n",xhp->xha_id[1]);
*/
			memcpy(pWork,&xhp,sizeof(XHASHB *));
		}
		else {
			/* Xhash: Pp[^'New'ł͂܂B */
			ERROROUT1(FORMAT(269),w1);
			return ECL_SCRIPT_ERROR;
		}
	}
	else if (pInfoParm->pi_attr == DEF_ZOK_BINA) {
		/*
		 *  nbV\ւ̃|C^擾
		 */
		if (!(xhp=(XHASHB *)cl_get_data_long(pInfoParm))) {
			/* Xhash: nbVTableւ̃|C^mtkkłB */
			ERROROUT(FORMAT(270));
			return ECL_SCRIPT_ERROR;
		}
		c0 = xhp->xha_id[0];
		c1 = xhp->xha_id[1];
		if (c0=='H'||c0=='N'||c0=='U'||c1=='X'||c1=='L'||c1=='2'||c1=='H') ;
		else {
			/* Xhash: nbVTablesłBid='%c%c' */
			ERROROUT2(FORMAT(271),c0,c1);
			return ECL_SCRIPT_ERROR;
		}
		/*
		 *  R}h擾
		 */
		if (nparm < 2) {
			/* Xhash: R}h̎w肪܂B */
			ERROROUT(FORMAT(272));
			return ECL_SCRIPT_ERROR;
		}
		p1 = w1;
		if ((ret = parm_to_char(ppParm[1],&p1,NULL)) < 0) return ret;
		cCmd = toupper(*p1);
		if (!stricmp(p1,"Free")) {
			ret = akxs_xhash_free(xhp);
		/*	memcpy(pWork,&ret,sizeof(int));	*/
		}
		else if (cCmd=='U'||cCmd=='M') {
			ret = akxs_xhash2(xhp,cCmd,NULL,NULL);
		}
		else if (cCmd=='K'||cCmd=='P') {
			if (nparm < 3) {
				/* Xhash: Index̎w肪܂Bcmd=[%s] */
				ERROROUT1(FORMAT(273),w1);
				return ECL_SCRIPT_ERROR;
			}
			pInfoParm = ppParm[2];
			if (ret=cl_get_parm_bin(pInfoParm,&ix,"Index"))
				return ECL_SCRIPT_ERROR;
/*
printf("cl_ex_xhash: cmd=%c ix=%d\n",cCmd,ix);
*/
			xhp->xha_xhix = ix;
			ret = akxs_xhash2(xhp,'P',&key,&cpDat);
			if (ret > 0) {
				if (nparm>=4) {
#if 1
					len = xhp->xha_keylen;
					if (len > 0) {
						p1 = key + 4;
						memcpy(&klen,p1,sizeof(int));
						len -= 8;
						p1 += 4;
						switch (key[0]) {
							case DEF_ZOK_CHAR:
								rc = cl_set_parm_char(&tInfoParm,p1,klen);
								break;
							case DEF_ZOK_BINA:
								memcpy(&ix,p1,klen);
								rc = cl_set_parm_bin(&tInfoParm,ix);
								break;
							case DEF_ZOK_FLOA:
								memcpy(&dVal,p1,klen);
								rc = cl_set_parm_double(&tInfoParm,dVal);
								break;
							case DEF_ZOK_DECI:
								if (!(rc=cl_set_parm_mpa(&tInfoParm,p1))) {
									tInfoParm.pi_hlen = key[2];	/* precision */
									tInfoParm.pi_pos = key[3];	/* scale */
								}
								break;
							case DEF_ZOK_BULK:
								rc = cl_set_parm_char(&tInfoParm,p1,klen);
								pInfoParm->pi_attr = key[0];
								break;
							default:
								rc = -100;
						}
						if (rc) return rc;
					}
					else {
						cl_set_parm_char(&tInfoParm,key,len);
					}
#else
					cl_set_parm_char(&tInfoParm,key,xhp->xha_keylen);
#endif
					rc = _ex_xhash_set_var(ppParm[3],&tInfoParm);
					if (rc < 0) return ECL_SCRIPT_ERROR;
				}
				if (nparm>=5 && xhp->xha_datlen>-2) {
					memcpy(&tInfoParm,cpDat,sizeof(tdtInfoParm));
					rc = _ex_xhash_set_var(ppParm[4],&tInfoParm);
					if (rc < 0) return ECL_SCRIPT_ERROR;
				}
			}
		}
		else if (cCmd=='R'||cCmd=='D'||cCmd=='S') {
			/*
			 *  L[擾
			 */
			pInfoParm = ppParm[2];
			if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
			key  = pInfoParm->pi_data;
			klen = pInfoParm->pi_dlen;
			len = xhp->xha_keylen;
/*
printf("cl_ex_xhash: len=%d klen=%d\n",len,klen);
*/
			if (len > 0) {
				len -= 8;
				atr = pInfoParm->pi_attr;
				if (atr!=DEF_ZOK_CHAR && atr!=DEF_ZOK_BULK && len<klen) {
					/* %s: L[(%d)L[`(%d) */
					ERROROUT3(FORMAT(279),_fn_,klen,len);
					return ECL_SCRIPT_ERROR;
				}
				key = cl_tmp_const_malloc(len+8);
				key[0] = atr;
				key[1] = 0;
				key[2] = pInfoParm->pi_hlen;
				key[3] = pInfoParm->pi_pos;
				p1 = key + 4;
				memcpy(p1,&klen,sizeof(int));
				p1 += 4;
				if (atr==DEF_ZOK_CHAR || atr==DEF_ZOK_BULK) {
					if (klen < len) memset(p1+klen,' ',len-klen);
				}
				memcpy(p1,pInfoParm->pi_data,klen);
			}
			else {
				key = w1;
				if ((ret=parm_to_char(pInfoParm,&key,NULL)) < 0) return ret;
			}
			/*
			 *  ۑpf[^̐ݒA܂́Aۑς݃f[^o
			 */
			cppDat = NULL;
			if (nparm >= 4) {
				if (xhp->xha_datlen > -2) {
					pInfoParm = ppParm[3];
					if (cCmd == 'S') {
						memset(&tInfoParm,0,sizeof(tdtInfoParm));
						rc = cl_gx_rep_info_set(&tInfoParm,pInfoParm,1);
						if (rc) return ECL_SCRIPT_ERROR;
						cppDat = (char **)&tInfoParm;
DEBUGOUT_InfoParm(194,"_xhash:lDatLen=%d cmd=[%c]",&tInfoParm,xhp->xha_datlen,cCmd);
					}
					else cppDat = &cpDat;
				}
				else {
					ERROROUT(FORMAT(274));	/* Xhash: f[^͎wł܂B */
					return ECL_SCRIPT_ERROR;
				}
			}
			/*
			 *  nbV
			 */
			ret = akxs_xhash2(xhp,cCmd,key,cppDat);
/*
printf("_xhash: cmd=[%c] key=[%s] ret=%d\n",cCmd,key,ret);
*/
			if (nparm>=4 && ret>0 && (cCmd=='R'||cCmd=='D')) {
				/*
				 *  oۑς݃f[^w̕ϐɐݒ肷
				 */
				memcpy(&tInfoParm,cpDat,sizeof(tdtInfoParm));
DEBUGOUT_InfoParm(194,"_xhash: index=%d cmd=[%c]",&tInfoParm,ret,cCmd);
				rc = _ex_xhash_set_var(pInfoParm,&tInfoParm);
				if (rc < 0) return ECL_SCRIPT_ERROR;
			}
		}
		else {
			/* Xhash: R}hĂ܂Bcmd=[%s] */
			ERROROUT1(FORMAT(275),p1);
			return ECL_SCRIPT_ERROR;
		}
		memcpy(pWork,&ret,sizeof(int));
	}
	else {
		/* Xhash: Pp[^̌^^łl^ł܂B */
		ERROROUT(FORMAT(276));
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_d2_l(d,name)
double d;
char *name;
{
	long l;

#if defined(_LP64)
	if (d>9.0e18 || d<-9.0e18) {
		ERROROUT2(FORMAT(277),name,d);	/* (W)%s: (%e)I[ot[܂B */
		if (d > 0.0) l = LONG_MAX;
		else l = LONG_MIN;
	}
	else l = d;
#else
	l = cl_chk_over_flow_d2_i(d,name);
#endif
	return l;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_over_flow_d2_i(d,name)
double d;
char *name;
{
	int i;

	if (d>2147483647.0 || d<-2147483648.0) {
		ERROROUT2(FORMAT(277),name,d);	/* (W)%s: (%e)I[ot[܂B */
		if (d > 0.0) i = INT_MAX;
		else i = INT_MIN;
	}
	else i = d;
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_over_flow_l2_i(l,name)
long l;
char *name;
{
	int i;

#if defined(_LP64)
	if (l>INT_MAX || l<INT_MIN) {
		ERROROUT2(FORMAT(278),name,l);	/* (W)%s: (%ll)I[ot[܂B */
		if (l > 0) i = INT_MAX;
		else i = INT_MIN;
	}
	else i = l;
#endif
	return (int)l;
}

/****************************************/
/*										*/
/****************************************/
long cl_get_val_long(val)
int val[];
{
	long lVal;

#if defined(_LP64)
	memcpy(&lVal,val,sizeof(long));
	return lVal;
#else
	return val[0];
#endif
}

#ifdef GET_PARM_RANGE
/****************************************/
/*										*/
/****************************************/
int cl_get_parm_range_mpa_opt(pInfoParm,pValue,pMsg,iAttr,opt)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[],opt;
{
	int rc,len,attr,iVal,iRANGE;
	double dVal;
	long lVal;
	char *p,*pV;

	if (!pInfoParm || !pValue || !iAttr) return -1;
	if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
/*
printf("cl_get_parm_mpa: Attr=%d\n",pInfoParm->pi_attr);
*/
	rc = 0;
	pV = (char *)pValue;
	iRANGE = pInfoParm->pi_alen & D_AULN_RANGE_DATA;
	p = pInfoParm->pi_data;
	len = pInfoParm->pi_dlen;
	if ((attr=pInfoParm->pi_attr) == DEF_ZOK_BINA) {
		if (len == sizeof(int)) lVal = cl_get_data_int(pInfoParm);
		else lVal = cl_get_data_long(pInfoParm);
		len = sizeof(long);
		memcpy(pV,&lVal,len);
		if (iRANGE) memcpy(pV,&pInfoParm->pi_hlen,len);
	}
	else if (attr==DEF_ZOK_FLOA || attr==DEF_ZOK_DECI) {
		memcpy(pV,p,len);
		if (iRANGE) memcpy(pV+len,p+len,len);
	}
	else if (attr == DEF_ZOK_CHAR) {
		if (rc = cl_conv_const_nsub(p,len,pV,pMsg,iAttr,opt)) return rc;
		if (iRANGE) rc = cl_conv_const_nsub(p+len,len,pV+iAttr[1],pMsg,iAttr);
		return rc;
	}
	else {
		if (pMsg=cl_conv_msg_check(pMsg,-1)) {
			/* %s: p[^̌^l^ł͂܂B */
			ERROROUT1(FORMAT(266),pMsg);
		}
		rc = ECL_SCRIPT_ERROR;
	}
	iAttr[0] = attr;
	iAttr[1] = len;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_range_mpa(pInfoParm,pValue,pMsg,iAttr)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
	iAttr[0] = 0;
	return cl_get_parm_range_mpa_opt(pInfoParm,pValue,pMsg,iAttr,0)
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_range_double(pInfoParm,pValue,pMsg,iAttr)
tdtInfoParm *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
	int rc,Val[NMPA_INT*2];
	double dval;
	char *pV,*pv;

	if ((rc=cl_get_parm_range_mpa(pInfoParm,Val,pMsg,iAttr)) >= 0) {
		if (iAttr[0] == DEF_ZOK_DECI) {
			rc = m_dset((double *)pValue,(MPA *)Val);
			iAttr[0] = DEF_ZOK_FLOA;
			iAttr[1] = sizeof(double);
			if (!rc && (pInfoParm->pi_alen & D_AULN_RANGE_DATA)) {
				pV = (char *)pValue + sizeof(MPA);
				pv = (char *)Val + sizeof(double);
				rc = m_dset((double *)pV,(MPA *)pv);
			}
		}
		else memcpy(pValue,Val,iAttr[1]*2);
		if (rc > 0) rc = -rc;
	}
	return rc;
}
#endif
