static char sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************/
/*								*/
/*      coded by A.Kobayashi 2010.5.20   */
/*								*/
/******************************************/
#include "akxcommon.h"

#if defined(AIX) || defined(WIN) || defined(HPUX) || defined(CYGWIN)
#define SJIS
#else
#define EUC
#endif

#ifndef SS2
#define SS2		0x8e	/* Hankaku Kana */
#define SS3		0x8f	/* G3 AREA      */
#endif

#ifdef EUC
static uchar  gucCodeType = CD_TYPE_EUC;
#else
static uchar  gucCodeType = CD_TYPE_SJIS;
#endif

static uchar kigo[]=
{' '
,'!','"','#','$','%','&','\'','(',')','*'
,'+',',','-','.','/',':',';','<','=','>'
,'?','@','[','\\',']','^','_','`','{','|'
,'}','~','\'','"','\'','"','\0'};

static ushort dkigo[]=
{0x2121
,0x212a,0x2149,0x2174,0x2170,0x2173,0x2175,0x2147,0x214a,0x214b,0x2176
,0x215c,0x2124,0x215d,0x2125,0x213f,0x2127,0x2128,0x2163,0x2161,0x2164
,0x2129,0x2177,0x214e,0x216f,0x214f,0x2130,0x2132,0x212e,0x2150,0x2143
,0x2151,0x2141,0x216c,0x216d,0x212d,0x212f,0x0000};

typedef struct {
	short flag;
	short hkey;
	short next;
	short data;
} HaslCell;

#define HASL_MSO	29

static HaslCell gCell[41]=
{0,   0, 0,  0
,1,8526, 0, 91
,1,8527,35, 93
,1,8528,39,123
,1,8529, 0,125
,1,8559, 0, 92
,1,8560, 0, 36
,0,   0, 0,  0
,0,   0, 0,  0
,1,8563, 0, 37
,1,8564, 0, 35
,1,8565, 0, 38
,1,8566, 0, 42
,1,8567, 0, 64
,1,8481, 0, 32
,1,8540,31, 43
,1,8541, 0, 45
,1,8484,37, 44
,1,8485, 0, 46
,1,8515, 0,124
,1,8487,32, 58
,1,8488, 0, 59
,1,8547,34, 60
,1,8490,30, 33
,0,   0, 0,  0
,1,8521, 0, 34
,1,8522,40, 40
,1,8523,36, 41
,1,8495, 0, 34
,1,8496, 0, 94
,1,8519,33, 39
,1,8511, 0, 47
,1,8545, 0, 61
,1,8548, 0, 62
,1,8489, 0, 63
,1,8498,38, 95
,1,8494, 0, 96
,1,8513, 0,126
,1,8556, 0, 39
,1,8557, 0, 34
,1,8493, 0, 39};

typedef struct {
	ushort knj_s;
	ushort knj_e;
	char   step;
	uchar  kna_s;
	uchar  kna_e;
	uchar  dakuten;
} tdtKanaKan;

static tdtKanaKan kanakan[]=
{0x2522,0x252a,2,0xb1,0xb5,0
,0x2521,0x2529,2,0xa7,0xab,0
,0x252b,0x2533,2,0xb6,0xba,0
,0x252c,0x2534,2,0xb6,0xba,0xde
,0x2535,0x253d,2,0xbb,0xbf,0
,0x2536,0x253e,2,0xbb,0xbf,0xde
,0x253f,0x2541,2,0xc0,0xc1,0
,0x2543,0x2543,1,0xaf,0xaf,0
,0x2544,0x2544,1,0xc2,0xc2,0
,0x2546,0x2548,2,0xc3,0xc4,0
,0x2540,0x2542,2,0xc0,0xc1,0xde
,0x2545,0x2545,1,0xc2,0xc2,0xde
,0x2547,0x2549,2,0xc3,0xc4,0xde
,0x254a,0x254e,1,0xc5,0xc9,0
,0x254f,0x255b,3,0xca,0xce,0
,0x2550,0x255c,3,0xca,0xce,0xde
,0x2551,0x255d,3,0xca,0xce,0xdf
,0x255e,0x2562,1,0xcf,0xd3,0
,0x2564,0x2568,2,0xd4,0xd6,0
,0x2563,0x2567,2,0xac,0xae,0
,0x2569,0x256d,1,0xd7,0xdb,0
,0x256f,0x256f,1,0xdc,0xdc,0
,0x2570,0x2570,1,0xb2,0xb2,0
,0x2571,0x2571,1,0xb4,0xb4,0
,0x2572,0x2572,1,0xa6,0xa6,0
,0x2573,0x2573,1,0xdd,0xdd,0
,0x2574,0x2574,1,0xb3,0xb3,0xde
,0x2575,0x2575,1,0xb6,0xb6,0
,0x2576,0x2576,1,0xb9,0xb9,0
,0x213c,0x213c,1,0xb0,0xb0,0
,0x213d,0x213e,1,0x2d,0x2d,0
,0,0,0,0,0,0};

static ushort _kigo2zen(uc)
uchar uc;
{
	ushort us;

	if (uc == ' ') us = 0x2121;
	else if (uc>='!' && uc<='/') us = dkigo[uc-'!'+1];
	else if (uc>=':' && uc<='@') us = dkigo[uc-':'+16];
	else if (uc>='[' && uc<='`') us = dkigo[uc-'['+23];
	else if (uc>='{' && uc<='~') us = dkigo[uc-'{'+29];
	else us = 0;

	return us;
}

static uchar _zen2kigo(us)
short us;
{
	int i,n;
	HaslCell *cell,*ce;

	cell = gCell;
	i = (n=us)%HASL_MSO+1;
L10:
	ce = &cell[i];
	if (ce->hkey == us) return (uchar)ce->data;
	else if ((i=ce->next)>0) goto L10;

	return 0;
}

static int _kanjikana(us,ucp)
ushort us;
uchar  *ucp;
{
	tdtKanaKan *p;
	ushort wus,wus_e;
	uchar uc;
	int byte,k,kk;

	byte = 0;
	p = kanakan;
	while (p->knj_s) {
		uc = p->kna_s;
		wus_e = p->knj_e;
		k = p->step;
		kk = 0;
		if (uc < p->kna_e) kk++;
		for (wus=p->knj_s; wus<=wus_e; wus+=k,uc+=kk) {
			if (us == wus) {
				*ucp++ = uc;
				byte++;
				if (uc = p->dakuten) {
					*ucp++ = uc;
					byte++;
				}
				break;
			}
		}
		if (byte) break;
		p++;
	}
	return byte;
}

static int _kanakanji(uc,uc1,usp)
uchar uc,uc1;
ushort *usp;
{
	tdtKanaKan *p;
	uchar uc_s,uc_e;
	ushort us;
	int byte,k;

	us = byte = 0;
	p = kanakan;
	if (uc1!=0xde && uc1!=0xdf) uc1 = 0;
	while (p->knj_s) {
		if (uc1 == p->dakuten) {
			uc_s = p->kna_s;
			uc_e = p->kna_e;
			if (uc>=uc_s && uc<=uc_e) {
				us = p->knj_s + (uc-uc_s)*p->step;
				byte++;
				if (uc1) byte++;
				break;
			}
		}
		p++;
	}
	if (!us && uc1) byte = _kanakanji(uc,0,usp);
	else if (usp) *usp = us;
	return byte;
}

int akxt_set_code_type(ucCodeType)
uchar ucCodeType;
{
	return gucCodeType = ucCodeType;
}

int akxt_get_code_type()
{
	return gucCodeType;
}

int akxqissjis(c)
uchar c;
{
	if ((c>=0x81 && c<=0x9f) || (c>=0xe0 && c<=0xfc))
		return 2;
	else
		return 0;
}

int akxqkanjilen1(c1)
uchar c1;
{
	return akxqmbslen1(gucCodeType,c1);
}

int akxqmbslen1(code_type,c1)
uchar code_type,c1;
{
	uchar p[4];

	p[0] = c1;
	if (code_type == CD_TYPE_EUC) {
		/************************/
		/*	EUC					*/
		/************************/
		p[1] = 0xa1;
	}
	else if (code_type == CD_TYPE_SJIS) {
		/************************/
		/*	SJIS				*/
		/************************/
		p[1] = 0x40;
	}
	else if (code_type == CD_TYPE_UTF8) {
		/************************/
		/*	UTF-8				*/
		/************************/
	}
	return akxqmbslen(code_type,p);
}

int akxqkanjilen(p)
uchar *p;
{
	return akxqmbslen(gucCodeType,p);
}

int akxqkanjilen2(p,len)
uchar *p;
int   len;
{
	return akxqmbsnlen(gucCodeType,p,len);
}

int akxqmbsnlen(code_type,p,len)
uchar code_type,*p;
int len;
{
	uchar c1,c2;

	if (!p) return 0;
	if (!code_type) code_type = gucCodeType;

	if (code_type == CD_TYPE_EUC) {
		/**************************/
		/*    EUC                 */
		/**************************/
		c1 = *p++;
		c2 = *p;
		if (c1==SS3) return 3;
		else if ((c1==SS2) ||
			((c1>=0xa1) && (c1<=0xfe) && (c2>=0xa1) && (c2<=0xfe))) return 2;
	}
	else if (code_type == CD_TYPE_SJIS) {
		/**************************/
		/*    SJIS                */
		/**************************/
		c2 = *(p+1);
		if (akxqissjis(*p) &&
		    ((c2>=0x40 && c2<=0x7e)||(c2>=0x80 && c2<=0xfc))) return 2;
	}
	else if (code_type == CD_TYPE_UTF8) {
		/**************************/
		/*    UTF-8               */
		/**************************/
		return akxqu8nlen(*p,len);
	}
	return 1;
}

int akxqmbslen(code_type,p)
uchar code_type,*p;
{
	int len;

	if ((len=akxqmbsnlen(code_type,p,4)) < 0) len = -len;
	return len;
}

int akxqiskanji1(c1)
uchar c1;
{
	return akxqismbs1(gucCodeType,c1);
}

int akxqismbs1(code_type,c1)
uchar code_type,c1;
{
	int len;

	if ((len=akxqmbslen1(code_type,c1)) == 1) len = 0;
	return len;
}

int akxqiskanji(p)
uchar *p;
{
	return akxqismbs(gucCodeType,p);
}

int akxqismbs(code_type,p)
uchar code_type,*p;
{
	int len;

	if ((len=akxqmbslen(code_type,p)) == 1) len = 0;
	return len;
}

#if 1
int akxqisank_type(int type, char c)
{
	int rc;
	uchar uc;

	rc = 0;
	uc = (uchar)c;
	if (type == CD_TYPE_SJIS) {
		if ((uc>=0x20 && uc<=0x7e) || (uc>=0xa1 && uc<=0xdf)) rc = 1;
	}
/*	else if (type==CD_TYPE_EUC I1 type==CD_TYPE_UTF8) I */
	else {
		if (uc>=0x20 && uc<=0x7e) rc = 1;
	}
	return rc;
}

int akxqisank(char c)
{
	return akxqisank_type(gucCodeType, c);
}

char akxctoank_type(int type, char c)
{
	if (!akxqisank_type(gucCodeType, c)) c = '.';
	return c;
}

char akxctoank(char c)
{
	return akxctoank_type(gucCodeType, c);
}
#else
int akxqisank(c)
uchar c;
{
	if (gucCodeType==CD_TYPE_EUC || gucCodeType==CD_TYPE_UTF8) {
		/************************/
		/*	EUC or UTF-8		*/
		/************************/
		if ((c>=0x20 && c<=0x7e))
			return (1);
		else
			return (0);
	}
	else if (gucCodeType == CD_TYPE_SJIS) {
		/************************/
		/*	SJIS				*/
		/************************/
		if ((c>=0x20 && c<=0x7e) ||
		    (c>=0xa1 && c<=0xdf) )
			return (1);
		else
			return (0);
	}
}

char akxctoank(c)
uchar c;
{
	if (akxqisank(c))
		return ((char)c);
	else
		return ('.');
}
#endif
/****************************/
/*	EUC --> S-JIS			*/
/****************************/
static ushort sj_to_euc();
static ushort jis_to_sj();

#define	Z_BEGIN		0xa1	/* Zenkaku Start */
#define	Z_END		0xfe	/* Zenkaku End */
#define AKX_DEFAULT_CODE	0x3f3f	/* '??' */;

int akxcetos(n, inc, outc)
int		n;
unsigned char *inc, *outc;
{
	int i, j, stat, max=n;
	ushort c,c1,c2;
	ushort s1,s2;
	uchar *pi=inc,*po=outc;

	stat = j = 0;
	for (i=0;i<max;i++) {
		c = *pi++;
		switch (stat) {
		case 0:
			if (Z_BEGIN <= c  && c <= Z_END) { /* Zenkaku */
				c1 = c & 0x7f;
				stat = 1;
			}
			else if (c == SS2) {	 /* Hankaku Kana */
				stat = 2;
			}
			else {	/* ASCII */
				*po++ = c;
				j++;
			}
			break;
		case 1:
			stat = 0;
			if (!(c & 0x80)) {
				*po++ = '?';
				*po++ = '?';
				j += 2;
				break;
			}
		 	c2 = c & 0x7f;
			jis_to_sj(c1,c2,&s1,&s2); /* Convert JIS to Sift_JIS */
			*po++ = s1;
			*po++ = s2;
			j += 2;
			break;
		case 2:
			*po++ = c;
			j++;
			stat = 0;
			break;
		}
	}
	if (stat) j = -j;
	return j;
}

static ushort jis_to_sj(jis1,jis2,ibm1,ibm2)
ushort jis1,jis2,*ibm1,*ibm2;
{
	ushort sj1,sj2;

	if(jis1 >= 0x5f) jis1 += 0x80;

	if(jis1 & 0x01) {
		if(jis2 >= 0x60) jis2 = jis2 + 0x01;
		sj1 = (jis1 - 0x31)/2 + 0x89;
		sj2 = jis2 + 0x1f;
	}
	else {
		sj1 = (jis1 - 0x30)/2 + 0x88;
		sj2 = jis2 + 0x7e;
	}
	sj1 &= 0xff;
	sj2 &= 0xff;
	*ibm1 = sj1;
	*ibm2 = sj2;
	return sj1<<8 + sj2;
}

/****************************************/
/*	S-JIS --> EUC  Convert Routine		*/
/*	opt=0:only replace					*/
/*	rep=NULL:replace default			*/
/*	   =""  :suppress					*/
/****************************************/
int akxcstoe2(n, inc, outc, opt, rep)
uchar *inc,*outc,*rep;
int n,opt;
{
	int i, j, stat, replen=-1,max=n;
	ushort c,c1;
	ushort s1,s2,us;
	uchar w[3];
	uchar *pi=inc,*po=outc;

	if (rep) replen = strlen(rep);
	stat = j = 0;
	for (i=0;i<max;i++) {
		c = *pi++;
		switch (stat) {
		case 0:
			if((c>=0x81 && c<=0x9f) || (c>=0xe0 && c<=0xfc)) {
				c1 = c;			/* ZENKAKU */
				stat = 1;
			}
			else if((0xa1 <= c) && (c <= 0xdf)) { /* Hankaku Kana */
				*po++ = SS2;
				*po++ = c;
				j += 2;
			}
			else { 				/* ASCII */
				*po++ = c;
				j++;
			}
			break;
		case 1:
			stat = 0;
			if (c<0x40 || c==0x7f || c>0xfc) {	/* invalid */
				*po++ = '?';
				j++;
				i--;
			}
			else {
				if (c1<0xf0) {
					sj_to_euc(c1,c,&s1,&s2);/* Change Shift_JIS into EUC */
				}
				else {
					if (replen<0) {
						us = AKX_DEFAULT_CODE;
						s1 = us>>8;
						s2 = us & 0x00ff;
					}
					else {
						if (replen>0) {
							memcpy(po,rep,replen);
							j += replen;
							po += replen;
						}
						continue;
					}
				}
				*po++ = s1;
				*po++ = s2;
				j += 2;
			}
			break;
		}
	}
	return j;
}

int akxcstoe(n, inc, outc)
int				n;
uchar	*inc, *outc;
{
	return akxcstoe2(n, inc, outc, 0, NULL);
}

static ushort sj_to_euc(sj1,sj2,euc1,euc2)
ushort sj1,sj2,*euc1,*euc2;
{
	ushort eu1,eu2;

	if (sj1 >= 0xe0) sj1 -=  0x40;	/* The 2nd standard of JIS */

	if (sj2 >= 0x9f) {
		eu1 = (sj1 - 0x88)*2 + 0xb0;
		eu2 = sj2 + 0x02;
	}
	else {
		if (sj2 >= 0x7f) sj2 -= 0x01;
		eu1 = (sj1 - 0x89)*2 + 0xb1;
		eu2 = sj2 + 0x61;
	}
	*euc1 = eu1;
	*euc2 = eu2;
	return eu1<<8 + eu2;
}

int akxcjtos1(jis,sjis)
uchar *jis,*sjis;
{
	ushort c1,c2;

	c1 = *jis++;
	c2 = *jis;

	if (c1 & 1) {
		c1 = (c1 >> 1) + 0x71;
		c2 += 0x1f;
		if (c2 >= 0x7f) c2++;
	}
	else {
		c1 = (c1 >> 1) + 0x70;
		c2 += 0x7e;
	}
	if (c1 > 0x9f) c1 += 0x40;

	c1 &= 0xff;
	c2 &= 0xff;
	*sjis++ = c1;
	*sjis   = c2;

	return (c1<<8 | c2);
}

int akxcstoj1(sjis,jis)
uchar *sjis,*jis;
{
	ushort c1,c2;

	c1 = *sjis++;
	c2 = *sjis;

	c1 -= (c1 <= 0x9f) ? 0x70 : 0xb0;
	c1 <<= 1;
	if (c2 < 0x9f) {
		c2 -= (c2 < 0x7f) ? 0x1f : 0x20;
		c1--;
	}
	else
		c2 -= 0x7e;

	c1 &= 0xff;
	c2 &= 0xff;
	*jis++ = c1;
	*jis   = c2;

	return (c1<<8 | c2);
}

/****************************************/
/*	Sp JIS --> type					*/
/****************************************/
ushort akxcfromjis(pd,ps,type)
char *ps,*pd;
int type;
{
	ushort us,usw;

	if (type == CD_TYPE_EUC) {
		pd[0] = ps[0] | 0x80;
		pd[1] = ps[1] | 0x80;
	}
	else if (type == CD_TYPE_SJIS) {
		akxcjtos1(ps,pd);
	}
	memcpy(&usw,pd,2);
	us = ntohs(usw);
	return us;
}

/****************************************/
/*	Sp type --> JIS					*/
/****************************************/
ushort akxctojis(pd,ps,type)
char *ps,*pd;
int type;
{
	ushort us,usw;

	if (type == CD_TYPE_EUC) {
		pd[0] = ps[0] & 0x7f;
		pd[1] = ps[1] & 0x7f;
	}
	else if (type == CD_TYPE_SJIS) {
		akxcstoj1(ps,pd);
	}
	memcpy(&usw,pd,2);
	us = ntohs(usw);
	return us;
}

/****************************************/
/*	Zenkaku --> Hankaku					*/
/****************************************/
int akxctohan(n, inc, outc)
int  n;
char *inc,*outc;
{
	return akxctohan_opt(n, inc, outc, 0);
}

int akxctohan_opt(n, inc, outc, opt)
int  n,opt;
char *inc,*outc;
{
	int  len1,type,i,byte;
	char *p1,*p,w[5];
	uchar  uc;
	ushort us,usw;

	len1 = n;
	p1 = inc;
	p  = outc;
	type = akxt_get_code_type();
	for (i=0;i<len1;i++) {
		if (akxqiskanji(p1)) {
#if 1
			us = akxctojis(w,p1,type);
#else
			memcpy((char *)&usw,p1,2);
			if (type == CD_TYPE_EUC)
				usw &= 0x7f7f;
			else if (type == CD_TYPE_SJIS) {
				akxcstoj1(p1,&usw);
			}
			us = ntohs(usw);
#endif
			byte = 0;
			uc = 0;
			if (!(opt & 0x01) && us >= 0x2330 && us <= 0x2339) { /* 0-9 */
				uc = (us - 0x2330) + '0';
			}
			else if (!(opt & 0x02) && us >= 0x2341 && us <= 0x235A) { /* A-Z */
				uc = (us - 0x2341) + 'A';
			}
			else if (!(opt & 0x04) && us >= 0x2361 && us <= 0x237a) { /* a-z */
				uc = (us - 0x2361) + 'a';
			}
			else if (!(opt & 0x10) &&
			         ((us >= 0x2501 && us <= 0x2576) || /* @-  */
			          (us >= 0x213c && us <= 0x213e))) { /* [ \ ]  */
				byte = _kanjikana(us,p);
			}
			else if (!(opt & 0x08)) uc = _zen2kigo(us);
			if (byte) {
				p  += byte;
				p1 += 2;
			}
			else if (uc) {
				*p++ = uc;
				p1 += 2;
			}
			else {
				*p++ = *p1++;
				*p++ = *p1++;
			}
			i++;
		}
		else {
			*p++ = *p1++;
		}
	}
	*p = '\0';
	return strlen(outc);
}

/****************************************/
/*	Hankaku --> Zenkaku					*/
/****************************************/
int akxctozen(n, inc, outc)
int  n;
char *inc,*outc;
{
	int  len1,type,i,byte,out_len,nn[3];
	char *p1,*p;
	uchar  uc,uc1;
	ushort us,usw;

	len1 = n;
	p1 = inc;
	p  = outc;
	out_len = 0;
	type = akxt_get_code_type();
#if 1
	while (len1 > 0) {
		byte = akxctozen1_type(len1, p1, p, nn, type);
		if (outc) p += byte;
		p1 += nn[0];
		len1 -= nn[0];
		out_len += byte;
	}
	if (outc) outc[out_len] = '\0';
#else
	for (i=0;i<len1;i++) {
		if ((byte=akxqkanjilen(p1)) >= 2) {
			if (outc) {
				memcpy(p,p1,byte);
				p += byte;
				p1 += byte;
			}
			i += byte-1;
			out_len += byte;
		}
		else {
			uc = *p1++;
			us = 0;
			if ((uc >= '0' && uc <= '9') ||
			    (uc >= 'A' && uc <= 'Z') ||
			    (uc >= 'a' && uc <= 'z')) {
				if (outc) {
					if (!(opt & 0x01) && uc >= '0' && uc <= '9') {
						us = (uc - '0') + 0x2330;
					}
					else if (!(opt & 0x02) && uc >= 'A' && uc <= 'Z') {
						us = (uc - 'A') + 0x2341;
					}
					else if (!(opt & 0x04) && uc >= 'a' && uc <= 'z') {
						us = (uc - 'a') + 0x2361;
					}
				}
				else us = 0x2121;
			}
			else if (uc >= 0xa6 && uc <= 0xdd) {
				if (i < len1) uc1 = *p1;
				else uc1 = 0;
				byte = _kanakanji(uc,uc1,&us);
				if (byte == 2) {
					i++;
					p1++;
				}
			}
			else us = _kigo2zen(uc);

			if (us) {
				if (outc) {
					usw = htons(us);
					us = akxcfromjis(p,&usw,type);
					p += 2;
				}
				out_len += 2;
			}
			else {
				if (outc) *p++ = uc;
				out_len++;
			}
		}
	}
	if (outc) *p = '\0';
#endif
	return out_len;
}

int akxctozen1(n, inc, outc, nn)
int  n,nn[];
char *inc,*outc;
{
	int out_len;

	out_len = akxctozen1_type(n, inc, outc, nn, -1);
	if (outc) outc[out_len] = '\0';
	return out_len;
}

int akxctozen1_type(n, inc, outc, nn, type)
int  n,nn[],type;
char *inc,*outc;
{
	return akxctozen1_type_opt(n, inc, outc, nn, type, 0);
}

int akxctozen1_type_opt(n, inc, outc, nn, type, opt)
int  n,nn[],type,opt;
char *inc,*outc;
{
	int  len1,i,byte,out_len;
	char *p1,*p;
	uchar  uc,uc1;
	ushort us,usw;

	len1 = n;
	p1 = inc;
	p  = outc;
	out_len = 0;
	if (type < 0) type = akxt_get_code_type();
	if (len1 >= 2) {
		if ((byte=akxqkanjilen(p1)) >= 2) {
			nn[0] = byte;
			nn[1] = byte;
			nn[2] = 1;
			if (outc) {
				memcpy(outc,inc,byte);
				outc[byte] = '\0';
			}
			return byte;
		}
	}
	us = 0;
	byte = 1;
	uc = *p1++;
	if ((uc >= '0' && uc <= '9') ||
	    (uc >= 'A' && uc <= 'Z') ||
	    (uc >= 'a' && uc <= 'z')) {
		if (outc) {
			if (!(opt & 0x01) && uc >= '0' && uc <= '9') {
				us = (uc - '0') + 0x2330;
			}
			else if (!(opt & 0x02) && uc >= 'A' && uc <= 'Z') {
				us = (uc - 'A') + 0x2341;
			}
			else if (!(opt & 0x04) && uc >= 'a' && uc <= 'z') {
				us = (uc - 'a') + 0x2361;
			}
		}
		else us = 0x2121;
	}
	else if (!(opt & 0x10) && uc >= 0xa6 && uc <= 0xdd) {
		if (len1 > 1) uc1 = *p1;
		else uc1 = 0;
		byte = _kanakanji(uc,uc1,&us);
	}
	else if (!(opt & 0x08)) us = _kigo2zen(uc);

	if (us) {
		if (outc) {
			usw = htons(us);
			us = akxcfromjis(p,&usw,type);
			p += 2;
		}
		out_len += 2;
	}
	else {
		if (outc) *p++ = uc;
		out_len++;
	}
/*	if (outc) *p = '\0';	*/
	nn[0] = byte;
	nn[1] = out_len;
	nn[2] = byte;
	return nn[1];
}

int akxt_chk_lang_type(lang)
char *lang;
{
	int type=0;

	if (!strcmp(lang,"ja_JP") || !strcmp(lang,"ujis"))
		type = CD_TYPE_EUC;
	else if (!strcmp(lang,"Ja_JP")) type = CD_TYPE_SJIS;
	else if (!strcmp(lang,"JA_JP")) type = CD_TYPE_UTF8;
	else if (!strcmp(lang,"ja")) type = akxt_get_code_type();
	else {
		if (stristr(lang,"EUC")) type = CD_TYPE_EUC;
		else if (stristr(lang,"SJIS") || stristr(lang,"S-JIS"))
			type = CD_TYPE_SJIS;
		else if (stristr(lang,"UTF8") || stristr(lang,"UTF-8"))
			type = CD_TYPE_UTF8;
	}
	return type;
}

int akxt_get_lang_type(key,opt,buf,buflen)
char *key,*buf;
int  opt,buflen;
{
	static struct {
		char *lang;
		int   type;
	} reg[]={NULL,0,NULL,0};

	char *lang=NULL,*p;
	int  type=-1,i=-1;

	if (!key) key = "LANG";

	if (!strcmp(key,"LANG")) i = 0;
	else if (!strcmp(key,"NLS_LANG")) i = 1;

	if (!opt && i>=0) {
		if (lang = reg[i].lang) {
			type = reg[i].type;
			i = -2;
		}
	}

	if (!lang) {
		if (lang=getenv(key)) {
#if 1
			if (!(type=akxt_chk_lang_type(lang))) type = -1;
#else
			if (!strcmp(lang,"ja_JP") || !strcmp(lang,"ujis"))
				type = CD_TYPE_EUC;
			else if (!strcmp(lang,"Ja_JP")) type = CD_TYPE_SJIS;
			else if (!strcmp(lang,"JA_JP")) type = CD_TYPE_UTF8;
			else if (!strcmp(lang,"ja")) type = akxt_get_code_type();
			else {
				if (stristr(lang,"EUC")) type = CD_TYPE_EUC;
				else if (stristr(lang,"SJIS") || stristr(lang,"S-JIS"))
					type = CD_TYPE_SJIS;
				else if (stristr(lang,"UTF8") || stristr(lang,"UTF-8"))
					type = CD_TYPE_UTF8;
			}
#endif
		}
		else lang = "";
	}

	if (buf) strnzcpy(buf,lang,buflen-1);
	if (i >= 0) {
		if (p=reg[i].lang) Free(p);
		reg[i].lang = Strdup(lang);
		reg[i].type = type;
	}
	return type;
}

/****************************************/
/*										*/
/****************************************/
int akxt_code_trans(pParm, pParmd)
tdtGeneralData *pParm, *pParmd;
{
	int rc,len_s,len_d;
	uchar type_s,type_d,ds_d;
	char  *up_s,*up_d;

	type_s = pParm->gd_code;
	type_d = pParmd->gd_code;
	up_s = pParm->gd_data;
	up_d = pParmd->gd_data;
	len_s = pParm->gd_dlen;
	pParmd->gd_attr = AKX_ZOK_CHAR;
	if (up_d) ds_d = pParmd->gd_scale;
	else pParmd->gd_scale = ds_d = 0;
	pParmd->gd_dlen  = 0;
	if (len_s<=0 || type_s==type_d) {
		if (len_s>=0 && up_d) {
			memnzcpy(up_d,up_s,len_s,len_s);
		}
		return pParmd->gd_dlen=len_s;
	}
	if (type_d == CD_TYPE_EUC) {
		if (type_s == CD_TYPE_SJIS) {
			if (!up_d) {
				if (!(up_d=Malloc(len_s*2+1))) return -1;
				ds_d = AKX_DATA_MALLOC;
			}
			len_d = akxcstoe(len_s,up_s,up_d);
		}
		else {
			return -1;
		}
	}
	else if (type_d == CD_TYPE_SJIS) {
		if (type_s == CD_TYPE_EUC) {
			if (!up_d) {
				if (!(up_d=Malloc(len_s+1))) return -1;
				ds_d = AKX_DATA_MALLOC;
			}
			len_d = akxcetos(len_s,up_s,up_d);
		}
		else if (type_s == CD_TYPE_UTF8) {
			if (!up_d) {
				if (!(up_d=Malloc(len_s+1))) return -1;
				ds_d = AKX_DATA_MALLOC;
			}
			len_d = akxcu8tos(len_s,up_s,up_d);
		}
		else {
			return -1;
		}
	}
	else if (type_d == CD_TYPE_UTF8) {
		if (type_s == CD_TYPE_SJIS) {
			if (!up_d) {
				if (!(up_d=Malloc(len_s*3+1))) return -1;
				ds_d = AKX_DATA_MALLOC;
			}
			len_d = akxcstou8(len_s,up_s,up_d);
		}
		else {
			return -1;
		}
	}
	else {
		return -1;
	}
	pParmd->gd_data = up_d;
	pParmd->gd_scale = ds_d;
	if (len_d >= 0) {
		up_d[len_d] = '\0';
	}
	else if (ds_d & AKX_DATA_MALLOC) {
		Free(up_d);
		pParmd->gd_data = NULL;
		pParmd->gd_scale = 0;
	}
	return pParmd->gd_dlen=len_d;
}

int akxqmlen(s,slen)
char *s;
{
	char *p=s;
	int len=slen;
	int count,m;

	count = 0;
	while (len > 0) {
		if (len >= 2) {
			m = akxqkanjilen(p);
			len -= m;
			p += m;
		}
		else {
			len--;
			p++;
		}
		count++;
	}
	return count;
}

int akxqm2len(s,slen,mlen)
char *s;
{
	char *p=s;
	int len=slen;
	int i,count,m;

	count = 0;
	for (i=0;i<mlen && len>0;i++) {
		if (len >= 2) {
			m = akxqkanjilen(p);
			len -= m;
			p += m;
			count += m;
		}
		else {
			len--;
			p++;
			count++;
		}
	}
	return count;
}

int akxqstrlen(s)
char *s;
{
	return akxqmlen(s,strlen(s));
}

/********************************************************/
/*														*/
/********************************************************/
int akxcuppern(d,s,len)
char *d,*s;
int len;
{
	return  akxcuplwn(0,d,s,len);
}

/********************************************************/
/*														*/
/********************************************************/
int akxclowern(d,s,len)
char *d,*s;
int len;
{
	return  akxcuplwn(1,d,s,len);
}

/********************************************************/
/*														*/
/********************************************************/
int akxcuplwn(opt,d,s,len)
int opt;	/* 0:upper, 1:lower */
char *d,*s;
int len;
{
	char *pd,*ps;
	int  n,i;

	if (d && s) {
		pd = d;
		ps = s;
	}
	else {
		if (s) {
			pd = ps = s;
		}
		else if (d) {
			pd = ps = d;
		}
		else return -1;
	}
	for (i=0;i<len;) {
		n = akxcuplw(pd,ps,opt);
		ps += n;
		pd += n;
		i += n;
	}
	*pd = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcuplw(pd,ps,opt)
char *pd,*ps;
int opt;	/* 0:upper, 1:lower */
{
	int n,type;
	ushort us,usw;
	char c,cc,w[5];

	if (n=akxqiskanji(ps)) {
		type = akxt_get_code_type();
		us = akxctojis(w,ps,type);
/*
printf("akxcuplw: us=0x%02x\n",us);
*/
		usw = 0;
		if (us >= 0x2341 && us <= 0x235A) { /* A-Z */
			if (opt) usw = 0x2361 + us - 0x2341;
		}
		else if (us >= 0x2361 && us <= 0x237a) { /* a-z */
			if (!opt) usw = 0x2341 + us - 0x2361;
		}
		if (usw) {
/*
printf("akxcuplw: usw=0x%02x\n",usw);
*/
			us = htons(usw);
			memcpy(w,(char *)&us,2);
			us = akxcfromjis(pd,w,type);
		}
		else if (pd != ps) memcpy(pd,ps,n);
	}
	else {
		c = *ps;
		if (opt) cc = tolower(c);
		else cc = toupper(c);
		*pd = cc;
		n = 1;
	}
	return n;
}

/****************************/
/*	UTF-8					*/
/****************************/
#define AKX_SJIS_START		0x8140
#define AKX_SJIS_OFFSET		(AKX_SJIS_START-256)
#define AKX_SJIS_MAX		(65536-AKX_SJIS_OFFSET)
#define AKX_SJIS_HASH_MAX	12000

static int gexe_set_utf8=0;
static UINT4 *gucs4=NULL;
static UINT4 *gutf8=NULL;
static HASHB *ha=NULL;
static HASHB *ha4=NULL;
static char *hkey[2],*h4key[2];
static char *utf8_file;

int akxc_set_utf8_file(file)
char *file;
{
	if (!(utf8_file=Strdup(file))) return -1;
	return 0;
}

int akxc_set_sj_utf8(file)
char *file;
{
	FILE *fp;
	char buf[128],parm[256],*argv[3],*p,c,*hkey[2],*h4key[2];
	int  len,n,ret,offset,iha4;
	ushort ucs2;
	UINT4  val,sj,utf8,ucs4,ix;

	if (!file) return -1;
	if (!(fp=fopen(file,"r"))) {
		XERROROUTL5(200,"%s open error",file,0,0,0,0);
		return -2;
	}

	gexe_set_utf8 = 1;
	len = AKX_SJIS_MAX*sizeof(UINT4)*2;
	if (!gucs4) {
		if (!(gucs4=(UINT4 *)Malloc(len))) {
			XERROROUTL5(200,"gucs4 malloc error",0,0,0,0,0);
			ret = -3;
			goto Err;
		}
	}
	memset(gucs4,0,len);
	gutf8 = gucs4 + AKX_SJIS_MAX;

	if (ha) akxs_hasl_free(ha);
	ha = akxs_hasl_new(4,AKX_SJIS_HASH_MAX,0);
	if (!ha) {
		XERROROUTL5(200,"akxs_hasl_new errno=%d",errno,0,0,0,0);
		ret = -3;
		goto Err;
	}
/*
printf("UTF8: id=%c%c len=%d maxreg=%d mso=%d\n",
ha->ha_id[0],ha->ha_id[1],ha->ha_keylen,ha->ha_maxreg,ha->ha_prereg);
*/
	ha->ha_key = (char *)hkey;
	if (ha4) akxs_hasl_free(ha4);
	ha4 = akxs_hasl_new(4,AKX_SJIS_HASH_MAX,0);
	if (!ha4) {
		XERROROUTL5(200,"akxs_hasl_new errno=%d",errno,0,0,0,0);
		ret = -4;
		goto Err;
	}
/*
printf("UCS4: id=%c%c len=%d maxreg=%d mso=%d\n",
ha->ha_id[0],ha->ha_id[1],ha->ha_keylen,ha->ha_maxreg,ha->ha_prereg);
*/
	ha4->ha_key = (char *)h4key;
/*
printf("--sjis-- --ucs4-- --utf8-- - ix- -iha- -iha4\n");
*/
	while ((len = akxa_read_line(buf,sizeof(buf),fp)) > 0) {
		if ((c=*buf) == '#') continue;
		else if (c == '\t') offset = 1;
		else offset = 8;
		n = akxtgetargv2(buf+offset,argv,3,parm,sizeof(parm),1);
		if (n >= 2) {
			p = argv[0] + 2;
			ret = akxccvx(p,strlen(p),&val);
			sj = val;
			if (n>=3 && *argv[2]=='(') p = argv[2] + 1;
			else p = argv[1] + 2;
			ret = akxccvx(p,strlen(p),&val);
			ucs4 = val;
			if (ucs4 <= 0x7f) {
				utf8 = ucs4<<24;
			}
			else if (ucs4 <= 0x7ff) {
				utf8 = ((ucs4&0x07c0)<<2 | (ucs4&0x3f) | 0xc080)<<16;
			}
			else if (ucs4 <= 0xffff) {
				utf8 = ((ucs4&0xf000)<<4 | (ucs4&0x0fc0)<<2 | (ucs4&0x3f) |
				        0xe08080)<<8;
			}
			else {
				utf8 = (ucs4&0x1c0000)<<6 | (ucs4&0x3f000)<<4 |
				       (ucs4&0xfc0)<<2 | (ucs4&0x3f) | 0xf0808080;
			}
			if ((ix=sj) >= AKX_SJIS_START) ix = sj - AKX_SJIS_OFFSET;
			gucs4[ix] = ucs4;
			gutf8[ix] = utf8;
			hkey[1] = (char *)sj;
			ret = akxshasls(ha,utf8);
			h4key[1] = (char *)sj;
			iha4 = akxshasls(ha4,ucs4);
/*
printf("%08x %08x %08x %5d %5d %5d\n",sj,ucs4,utf8,ix,ret,iha4);
*/
		}
	}
	ret = 0;
Err:
	fclose(fp);
	return ret;
}

int akxc_sj_to_utf8(sjis,utf8c,ucs4)
ushort  sjis;
uchar  *utf8c;
UINT4  *ucs4;
{
	UINT4 sj,ix,utf8,w;
	int len,ret;

	if (!gexe_set_utf8) {
		if (ret=akxc_set_sj_utf8(utf8_file)) return ret;
	}
	if (!gutf8) return -1;
	sj = sjis;
	if ((ix=sj) >= AKX_SJIS_START) ix = sj - AKX_SJIS_OFFSET;
/*
printf("akxc_sj_to_utf8: %04x %08x\n",sjis,utf8);
*/
	if (utf8c) {
		utf8 = gutf8[ix];
		len = akxqu8len((utf8>>24) & 0xff);
		w = htonl(utf8);
		memcpy(utf8c,&w,len);
	}
	else len = 0;
	if (ucs4) *ucs4 = gucs4[ix];
	return len;
}

int akxcstou8(n, inc, outc)
int   n;
uchar *inc, *outc;
{
	int i,j,len;
	uchar  c1;
	ushort sjis;

	j = 0;
	for (i=0;i<n;i++,inc++) {
		sjis = c1 = *inc;
		if (akxqiskanji1(c1)) {
			if (i+1 < n) {
				if (akxqiskanji(inc)) {
					i++;
					sjis = sjis<<8 | *(++inc);
				}
			}
			else break;
		}
		len = akxc_sj_to_utf8(sjis,outc,NULL);
		outc += len;
		j    += len;
	}
	return j;
}

int akxc_utf8_to_sj(utf8c,sjis,ucs4)
uchar  *utf8c;
ushort *sjis;
UINT4  *ucs4;
{
	int len,ret;
	UINT4 w,utf8,ix,sj,ucs4w;
	char **argv;

	if (!gexe_set_utf8) {
		if (ret=akxc_set_sj_utf8(utf8_file)) return ret;
	}
	if (!ha) return -1;
	len = akxqu8len(*utf8c);
	sj = ucs4w = w = 0;
	memcpy(&w,utf8c,len);
	utf8 = ntohl(w);
	if ((ret = akxshaslr(ha,utf8)) > 0) {
/*
printf("akxc_utf8_to_sj: ha->ha_key=%08x hkey=%08x\n",ha->ha_key,hkey);
*/
		if (!(argv=(char **)ha->ha_key)) return -1;
		sj = (UINT4)argv[1];
		if ((ix=sj) >= AKX_SJIS_START) ix = sj - AKX_SJIS_OFFSET;
		ucs4w = gucs4[ix];
	}
	if (sjis) *sjis = sj;
	if (ucs4) *ucs4 = ucs4w;
/*
printf("akxc_utf8_to_sj: utf8=%08x len=%d ih=%5d sj=%04x ucs4=%04x\n",utf8,len,ret,sj,ucs4w);
*/
	return len;
}

int akxcu8tos(n, inc, outc)
int   n;
uchar *inc, *outc;
{
	int i,j,len;
	ushort sjis;

	j = 0;
	for (i=0;i<n;i+=len) {
		if ((len = akxc_utf8_to_sj(inc,&sjis,NULL)) < 0) return len;
		inc += len;
		if (sjis) {
			*outc = sjis;
			if (sjis & 0xff00) {
				outc[1] = *outc;
				*outc++ = sjis>>8;
				j++;
			}
			outc++;
			j++;
		}
	}
	return j;
}

#if 1
int akxqu8len(c)
uchar c;
{
	UINT4 u1;
	int mlen;

	mlen = 1;
	u1 = (UINT4)c;
	if (u1 < 0xc2) ;
	else if (u1 < 0xe0) {
		if (u1 <= 0xdf) mlen = 2;
	}
	else if (u1 < 0xf0) {
		if (u1 <= 0xed) mlen = 3;
	}
	else if (u1 <= 0xf4) mlen = 4;
	return mlen;
}

int akxqu8nlen(p_str, len)
char *p_str;
int len;
{
	UINT4 u1,u2,u3,u4;
	int mlen;
	char *p;

	if (!(p=p_str)) return -1;
	if (len <= 0) return akxqu8len(*p);
/*	else if (len == 1) return 1; */

	mlen = 1;
	u1 = (UINT4)*p & 0xff;
/*
printf("akxqu8nlen: len=%d u1=%08x\nh,len,u1);
*/
	if (u1 < 0xc2) ;
	else if (u1 < 0xe0) {
		if (u1<=0xdf) {
			if (len >= 2) {
				u2 = (UINT4)*(++p) & 0xff;
				if (u2>=0x80 && u2<=0xbf) mlen = 2;
			}
			else mlen = -2;
		}
	}
	else if (u1 < 0xf0) {
		if (len >= 3) {
			u2 = (UINT4)*(++p) & 0xff;
			if (u1==0xe0) {
				if (u2>=0xa0 && u2<=0xbf) mlen = 3;
			}
			else if ((u1>=0xe1 && u1<=0xec) || (u1>=0xee && u1<=0xef)) {
				if (u2>=0x80 && u2<=0xbf) mlen = 3;
			}
			else if (u1==0xed) {
				if (u2>=0x80 && u2<=0x9f) mlen = 3;
			}
			if (mlen>1) {
				u3 = (UINT4)*(++p) & 0xff;
				if (u1==0xef && u2==0xbb && u3==0xbf) mlen = 103; /* BOM */
				else if (u3>=0x80 && u3<=0xbf) ;
				else mlen = 1;
			}
		}
		else mlen = -3;
	}
	else {
		if (len >= 4) {
			u2 = (UINT4)*(++p) & 0xff;
			if (u1==0xf0) {
				if (u2>=0x90 && u2<=0xbf) mlen = 4;
			}
			else if (u1<0xf4) {
				if (u2>=0x80 && u2<=0xbf) mlen = 4;
			}
			else if (u1==0xf4) {
				if (u2>=0x80 && u2<=0x8f) mlen = 4;
			}
			if (mlen>1) {
				u3 = (UINT4)*(++p) & 0xff;
				if (u3>=0x80 && u3<=0xbf) {
					u4 = (int)*(++p) & 0xff;
					if (u4>=0x80 && u4<=0xbf) ;
					else mlen = 1;
				}
				else mlen = 1;
			}
		}
		else mlen = -4;
	}
	return mlen;
}
#else
int akxqu8len(c1)
uchar c1;
{
	UINT4 utf8;
	int len;

	utf8 = c1;
	if (!(utf8 & 0x80)) len = 1;
	else if ((utf8 & 0xe0) == 0xc0) len = 2;
	else if ((utf8 & 0xf0) == 0xe0) len = 3;
	else len = 4;
	return len;
}
#endif
