#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[#]SH_'			;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

#SH_LS
#!/bin/sh
# AGPLv3+
:<<'E==='
/* Copyright (C) 2023 Momi-g

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
E===

:<< 'E==='
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief control mouse with keyboard
@_syno
	wmpp [-hHVvs]
	wmpp [-fe file|xpr]
	wmpp [-0q]
@tl_dr
		@(code)--@
	~$ wmpp		#>> boot daemon, dfl keybind is:
	#>> nmlk(+shift)+ up/down/left/right
	#>> nmlk+ zxcvb (btn1-5)
	#>> nmlk+ esc (kill daemon)
	
	~$ wmpp -0	#>> $? == suc/fail == alive/not
	~$ wmpp -q	#>> quit daemon
		@()--@
@_opt
		@(list_o)
	-hHVvs: help, Ver, verbose, -v 0/1/2 == quiet/dfl/verbose, sample code--
	-fe [file|xpr]: use ctgfile or expression. see '-s'
	-0 : test alive as '~$ kill -0'. rc $? == 0/not0 == alive/not
	-q : quit daemon
		@()
@_desc
	move mouse cursor with keyboard.
		@(code)--@
	- up/down/left/right (charmode, move by 9pt(==12pxcel) etc)
	- tap btn1-3 key >> click
	- hold btn1-3 keydown then keyup >> drag
	- hold btn4,5 >> repeat
		@()--@
	see '-s' for settings or others. --
	
@exit_status suc/fail == 0/not0 --
@notes
		@(code)--@
	- portable
	- almost all click target has text. so move on the fontsize grid
	- use sneaking(pixel move) like an FPS game for detailed move
		@()--@

@depend	xdpyinfo, xdotool, xinput [,xbindkeys]
@compat	posix-shell
@copyright	Copyright (C) 2023 Momi-g, AGPLv3+
@_ver 2023-01-30 v1.0.3 (2023-01-21 v1.0.0)
@_see `xcape(1)` (tap/hold idea)
#SH_docE
E===
#SH_ED

#SH_HD
#SH_ED

#SH_SC
f_usage(){
cat << 'E==='
HowTo (*SH_bn*, control mouse pointer with keyboard)
opt: -hHVvs(help,version,verbose,eg), -fe(ctgfile/expression),
     -0(isrun), -q(uit)
------
~$ wmpp #>> deamon init
( nmlk(+shift)+ up/down/left/right/esc(kill) in dfl, see '-s' opt)
~$ wmpp -0	#>> test alive/no
~$ wmpp -q	#>> kill daemon
E===
exit 0
}

f_usageH(){
	cat <<-'E==='|sed -e'1d;$d'
	#SH_rf* *SH_bn*.1.txt
	E===
	exit 0
}

f_verinfo(){
		cat <<- 'E==='
	*SH_bn* *SH_ver*
	*SH_copy* 
		E===
	exit 0
}

f_vlv_def(){
 f_err(){ echo "*SH_bn*:---err. $1" && exit ${2:-1};}>/dev/stderr
 f_srr(){ while :;do echo "*SH_bn*:---errstop. $*"; sleep 1000;done; }>/dev/stderr
 f_wrr(){ echo "*SH_bn*:---msg. $*";} >/dev/stderr
 f_drr(){ echo "*SH_bn*:---dbg. $*";} >/dev/stderr
 f_vrr(){ echo "*SH_bn*:---val";echo "$(s_val "$@")";} >/dev/stderr
 s_val()(
 	[ "${1##@*}" = "" ] && echo "$@" && return
 	for _vbg; do
 	set -- "$_vbg" "$(eval 'printf "%s@" "$'"$_vbg"'"')"
 	printf '%s#%s:%s;\n' "$1" $((${#2}-1)) "${2%?}"
 	done
 )
 _f_nrr(){
 	tm=3000
 	[ "$2" != "" ] && tm="$2"
 	command -v notify-send >/dev/null 2>&1 || return
 	notify-send "(*SH_bn*) $1" -t "$tm"
 }
 f_NRR(){ _f_nrr "$@"; echo "*SH_bn*:---msg. $*">/dev/stderr; }
 f_nrr(){ _f_nrr "$@"; }
}
f_vlv_def
f_vlv(){
	[ "$1" = 0 ] && {
		f_err(){ exit ${2:-1}; }
		f_nrr(){ :; }
#		f_drr(){ :; }
		f_wrr(){ :; }
		f_vrr(){ :; }
	}
	[ "$1" = 1 ] && {
#		f_drr(){ :; }
#		f_wrr(){ :; }
		f_vrr(){ :; }
	}	
	[ "$1" = 2 ] && :
}
pcho(){ printf '%s\n' "$@";}
#SH_TSS
eq(){ _eq "$@"; }
nq(){ _neq "$@"; }

test_0(){
	# f_grr "test start: needs 30s..." 8000
	eq 1 1
}
#SH_TSE

f_sample(){
cat << 'E==='
	#-- dflctg
# - line header '#' is cmt. tail '#' may works as cmt too
# - *SH_bn* uses 'eval (line)' for parse. pay attention to space/tab
# - [=:] is equals to 1spc ' ',  a=1 == a:1 == a 1 (tr '=:,' ' ')

	#-- cmn
#-- *SH_bn* grab(eat) the keybind/fall-through == 1/0
grab=1

#-- font/pixel uses for cursor move size
fontsize 8pt	#>> x/y == 12/24 pix (dep on dpi, x/y ratio 1/2)
pixelsize 1	#>> x/y == 1/1 pix

#-- sfx 'c/p' is font(char)/pixelsize for mv. 
dx 1.5c		#>> == 18p
dy 1c		#>> == 24p 

#-- delay for repeat. delay_i is init delay
delay_i=0.1	#>> second 0.06 == 60ms
delay=0.006

	#-- cursor-keybind
# - pointer move. each bind uses upper setting
# - use param: grab / font,pixsz / dx,dy / delay,delay_i
# - ~$ xev/xmodmap -pke for search kc (kc111==arrow-Up)

up	 {+l(+a)}:kc111
down {+l(+a)}:kc116
left {+l(+a)}:kc113
right {+l(+a)}:kc114

# - +l kc111(or +l+a kc111) works as ptrup. path-through the modstate
# - mod takes: +s +l +c +m1(+a) +m2(+n) +m3-5
# - out/in parlen() == needs/accept


	#-- cursor-keybind(sneak, pixcel move)
#-- change move size 1char >> 1pixel
dx 1p
dy 1p
delay_i=0.08
delay=0.002

up	 {+l+s(+a)}:kc111
down {+l+s(+a)}:kc116
left {+l+s(+a)}:kc113
right {+l+s(+a)}:kc114


	#--- click-keybind
# - use param: grab / delay_i / delay
# - param 'delay_i' hasnt/has pfx '@' == tap_hold / always_click mode
# - param 'delay' works as repeat_delay. set no repeat if <0

#-- btn1-3(normal btn)
delay_i=0.15	#>> if 200ms keydown, set 'mousedown(drag)' instead of 'click'
# delay=-1	#>> tap/hold mode doesnt use 'delay' param

btn1 {+l(+s+c+a)}:kc52		#>> kc52-56 == zxcvb
btn2 {+l(+s+c+a)}:kc53
btn3 {+l(+s+c+a)}:kc54

#-- btn4/5(wheel up/dn)
delay_i=@0.15	#>> always click mode, pfx '@'
delay=0.02		#>> repeat delay 0s (nowait)

btn4 {+l(+s+c+a)}:kc55
btn5 {+l(+s+c+a)}:kc56


	#-- daemon control
quit {+l+s}:kc9	#>> quit daemon (kc9==esc)
reset {+l}:kc9	#>> stop cursor mv, all btnup (for panic/debug)


	#-- note
# recommend to use 'l/n/m4(win)' or these combo for 'click modflg' (+l in dfl)
# s/c/a affects to: txt_select / txt_resize / window resize,move

E===
exit 0
}

f_loadcfg(){
	[ $# = 0 ]&& set -- "$(f_sample)"
	cfg="$1"
	
	#-- use hdoc for 'eval'
	while read -r s;do
f_vrr s
		set -- $s
		eval "$@" || {
			f_NRR "badcfg: $*"
			exit 1
		}
	done <<-E===
	$(pcho "$cfg"|tr '=:,' ' '|sed -e 's/[{][^}]*[}]/"&"/g')
	E===
	
	#--cfg_qq
	f_bldflt	#-- f_ifhit()
	f_bldgrab	#-- xbind.ini
}

#SH_TSS
test_cfg(){
	f_loadcfg
	_suc
	f_vrr _13839
	_suc
}
#SH_TSE

#--preset
dpi=$(xdpyinfo|grep resolution|tr -c '0123456789' ' '|awk '{print $1}')
cx_=0
cy_=0
dx_=0
dy_=0
px_=0
py_=0

dst_=
grab_=
delay_i_=0
delay_=0
ini_=0

gli_=
mst_=
ful_=

fontsize(){
	fsz=${1%%[!0-9]*}
	cx_=$(awk "BEGIN{ printf(\"%d\",$fsz*$dpi*1/72) }")	#-- 1c==9pt==12pix
	cy_=$(awk "BEGIN{ printf(\"%d\",$fsz*$dpi*2/72) }")	#-- 1c==9pt==12pix
}
pixelsize(){
	px_=${1%%[!0-9]*}
	py_="$px_"
}

#SH_TSS
test_sz(){
	dpi=96
	fontsize 9pt
	eq "$cx_" 12
	eq "$cy_" 24
	
	pixelsize 2
	eq "$px_" 2
	eq "$py_" 2
}
#SH_TSE

#-- do conv when read cfg
#dx 1.5c / dy 1c
dx(){
	buf=$(pcho "$1"|sed -e "s/c/*$cx_/;s/p/*$px_/")
	buf='dx_=$(awk "BEGIN{print '$buf'}")'
	eval "$buf"
 f_vrr buf dx_
#	pcho "$dx_"
}
dy(){
	buf=$(pcho "$1"|sed -e "s/c/*$cy_/;s/p/*$py_/")
	buf='dy_=$(awk "BEGIN{print '$buf'}")'
	eval "$buf"
 f_vrr buf dy_
#	pcho "$dy_"
}
#SH_TSS
test_xy(){
	cx_=10
	cy_=16
	
	px_=4
	py_=4

#---
	dx 1.5c
	eq "$dx_" 15
	
	dy 1.5c
	eq "$dy_" 24

	dx 1.5p
	eq "$dx_" 6
	dy 1.5p
	eq "$dy_" 6
}
#SH_TSE

grab(){	[ "$1" != 1 ]&& set -- 0; grab_="$1"; }
delay(){ [ "$1" = '' ]&& set -- 0; delay_="$1"; }
delay_i(){ [ "$1" = '' ]&& set -- 0; delay_i_="$1"; }

up(){ f_regist up "$@";}
down(){ f_regist down "$@";}
left(){ f_regist left "$@";}
right(){ f_regist right "$@";}

btn1(){ f_regist btn1 "$@";}
btn2(){ f_regist btn2 "$@";}
btn3(){ f_regist btn3 "$@";}
btn4(){ f_regist btn4 "$@";}
btn5(){ f_regist btn5 "$@";}

reset(){ f_regist reset "$@";}		#-- bash cmd 'reset' isnt posix
quit(){ f_regist quit "$@";}

	# f_mod2msk '{+s(+c+m1)}'
f_mod2msk()(
	s=$(echo "$1"|tr '{}()+' '\n'|tr '[:upper:]' '[:lower:]'|awk '
	$1=="s" {print "0x01"}
	$1=="l" {print "0x02"}
	$1=="c" {print "0x04"}
	$1=="a" {print "0x08"}
	$1=="n" {print "0x10"}
	$1=="m1" {print "0x08"}
	$1=="m2" {print "0x10"}
	$1=="m3" {print "0x20"}
	$1=="m4" {print "0x40"}
	$1=="m5" {print "0x80"}
	'|sort -u
	)
	set -- $s
	buf=$(pcho "$*"|tr ' ' '+')
	buf='echo $(('"$buf"'))'
	eval "$buf"		#-- ret 45 etc-- mask
)

#-- up {+l+s(+a)}:kc111

#-- f_regist up {+l+s(+a)}:kc111
f_regist(){
	#-- precalc sw cmnval, dx etc / inputfilter
	f_addsw "$@"		#>> var only
	f_addflt "$@"		#>> bld f_ishit()
	f_addgrab "$@"		#>> bld f_bldgrab, output xbindkeys -f inifile
}

#-- f_m2m '{+s+l(+c+n)}:kc110
#-- set mst,ful (== 23, 45 etc)
f_mod2mst(){
f_wrr "$@"
	s="$1"
	ss="${s%%(*}"	#-- need str m2k allow '{}()' >> del in func
	kc=${2##*[!0-9]}
	mcn=$(f_mod2msk "$ss")	#--1st, kick no touch, 'modcode for needs'
	mca=$(f_mod2msk "$s")	#--2nd, fulllist for all
f_vrr kc	
	mst_=$(( (kc<<8)+mcn))		#--num 123_255 etc
	ful_=$(( (kc<<8)+mca))
#	echo $mst $ful
}

f_addflt(){
	f_mod2mst "$2" "$3"
	mst="$mst_"
	ful="$ful_"
 f_vrr mst ful
	buf=$(printf 'test $((n&%s)) = %s && test $((n&%s)) = "$n" && eval "$_%s" && return 0' "$mst" "$mst" "$ful" "$ful" )
	flt_=$(printf '%s\n%s' "$flt_" "$buf")
 f_vrr flt
}

#SH_TSS
test_flt(){
	f_addflt up '{+s+c}' kc110
	echo "$buf"
}
#SH_TSE



f_bldflt(){
	flt_=$(printf 'f_ishit(){\n mod=$1;kc=$2\n n=$(( (kc<<8)+mod))\n %s\n return 1;}' "$flt_")

#	echo "$flt_">/dev/stderr
#	sleep 10

	eval "$flt_"
}

#-- f_addgrab 'up' '{+s+l(+c)} kc100
f_addgrab(){	
	kc=${3##*[!0-9]}
	f_mod2mst "$2" "$3"
	mst=$(( mst_-(kc<<8) ))
	ful=$(( ful_-(kc<<8) ))
	nst=$((ful& ~mst))	#関係者, modのみ mst/fulはkc<<8込み
	
f_vrr mst ful nst kc

:<<E==
#--https://ark4rk.hatenablog.com/entry/2018/03/07/230257		# 低次から削る系
uint S; // 集合
for (uint T=S; ; T=(T-1)&S) {
    // 処理
    if (T==0) break;
}
E==
	#-- f_combo 0x44 (==0b110101: list all bit comb)
	f_combo(){
	nst="$1";buf="0"
	t=$nst
	while :;do
		[ $t = 0 ] && break
		buf="$buf $t"
		t=$(( (t-1)&nst))
	done
	echo "$buf"
	}
	
	li=$(f_combo "$nst" )
f_vrr li
	buf=''
	for i in $li; do
		buf="$buf $(( i|mst ))"
	done
	
	#-- comboは0bit込み。最後にmst合成 後工程用にkcを乗っける
	buf="$kc $buf"
f_vrr buf
	gli_=$(pcho "$gli_" "$buf")
}

# f_addgrab "$@"
# f_addgrab 'up' '{+s+c(+l)}:kc110'
f_bldgrab(){
	buf=$(
	echo "$gli_"|awk '{
	for(i=2;i<=NF;i++){ printf("\n\"\"\nm:%#x + c:%s\n", $i, $1)}
	}'
	)
	
	#-- for xkeybinds: grab setting
	ini_="
keystate_numlock = enable
keystate_capslock = enable
keystate_scrolllock= enable

$buf
"
	echo "$ini_"
}

f_addsw(){
#	dst="$1"
	dst="${1%%[0-9]*}"		#--btn
	nn=${1##*[!0-9]}

#nn=${1##*[!0-9]}

#-- f_addgrab 'up' '{+s+l(+c)}:kc100
	f_mod2mst "$2" "$3"
	mst=$mst_
	ful=$ful_
	
f_vrr mcm mcf kc mst ful
	case "$dst" in
	(up|down|left|right)
		buf="_$ful='dx_=$dx_;dy_=$dy_;dst_=$dst;delay_i_=$delay_i_;delay_=$delay_'"
		eval "$buf"
	;;
	(quit|reset|btn)
		buf="_$ful='dst_=$dst;bnum_=$nn;delay_i_=$delay_i_;delay_=$delay_'"
		eval "$buf"
	;;
	(*)
		f_NRR "badreq: $c"
		f_kill
		exit 1
	;;
	esac
 f_vrr buf
}

#SH_TSS
test_sw(){
	f_addsw up '{+s+c}' kc110
	echo "$buf"
}
#SH_TSE

# fsz=9px/1.0p
#-- main_code/daemon: read from fifo
f_readloop(){
	#--init, 
	
#	f_ad v pid kc 
	f_ad(){
		buf="pid_$1=$2;kc_$1=$3"
		eval "$buf"
	}
	# f_qd v, h, b1 etc
	f_qd(){
		buf='kill -9 "$pid_'$1'";unset pid_'$1' kc_'$1
		eval "$buf"
	} 2>/dev/null
	
	#f_isd kc_hb1, pid_v etc
	f_isd(){
		buf='[ -z "$'$1'" ] && return 1'
		eval "$buf"
		return 0
	}
	
	f_reset(){
		for i in v h b1 b2 b3 b4 b5 hb1 hb2 hb3 hb4 hb5;do
			f_qd $i
		done

		for i in $(seq 1 5);do 
			xdotool mouseup $i
		done
		f_nrr "reset"
	}

	#-- mainloop:  on/off 0 26 (decimal)
	while read -r updn mod kc; do
f_vrr pid_h kc_h pid_v kd_v cmd mod kc
	echo		#--alive pipe test
	[ $((mod+0)) -ge 0 ] && [ $((mod+0)) -le 128 ] || {
		f_NRR "err: bad mod, 0<mod<128"
		break
	}

	#--release trigger: click/stop_mv
	[ "$updn" = off ] && {
		#--loop
		for i in v h b1 b2 b3 b4 b5; do
			buf='[ "$kc_'$i'" = "$kc" ]'
			eval "$buf" && f_qd $i
			# 上書きは $kc_v が新顔なので二重stopはしないで無視される
		done

		#--tap/hold
		for i in hb1 hb2 hb3 hb4 hb5; do
			buf='[ "$kc_'$i'" = "$kc" ]'
			eval "$buf" && {
				eval 'kill -0 "$pid_'$i'"' && xdotool click --delay 0 $bnum_ && f_qd $i
				#-- tapはリセットするがholdは残す unhold msgが欲しい。残しても悪影響はないはず
			}
		done
		#--hold. なにもしない。adも残す>>unholdでnote用
		continue
	}

	#--on
	f_ishit "$mod" "$kc" || continue
f_vrr n mod kc $? delay_i_ delay_

	[ "$dst_" = "up" ] && dst_=down && dy_=-$dy_	#--use belowcode
	[ "$dst_" = "down" ] && {
		#--kill preloop
		f_isd v && f_qd v
		( while :; do xdotool mousemove_relative -- 0 $dy_ sleep $delay_i_;delay_i_=$delay_;done) &
		f_ad v $! $kc
		continue
	}
	
	[ "$dst_" = "left" ] && dst_=right && dx_=-$dx_
	[ "$dst_" = "right" ] && {
		f_isd h && f_qd h
		( while :; do xdotool mousemove_relative -- $dx_ 0 sleep $delay_i_;delay_i_=$delay_; done) &
		f_ad h $! $kc
		continue
	}

	#--quitとresetだけは完全一致
	[ "$dst_" = "quit" ] && break
	[ "$dst_" = "reset" ] && { f_reset; continue; }

	#-- btm start holdcount
	[ "$dst_" = "btn" ] && {
		f_isd kc_hb$bnum_ && {
			f_nrr "unhold btn$bnum_"
			f_qd hb$bnum_
		}

		#--btn4/5: repeat type
		[ "${delay_i_#@}" != "$delay_i_" ] && {
			(
			delay_i_="${delay_i_#@}"
			while :; do xdotool click --delay 0 -- $bnum_ sleep $delay_i_;delay_i_=$delay_; done
			) &
			f_ad b$bnum_ $! $kc
			continue
		}

		#--tap|hold
		(
		xdotool sleep $delay_i_
		f_nrr "hold btn$bnum_ $delay_i_ sec"
		xdotool mousedown $bnum_
		) &
		f_ad hb$bnum_ $! $kc
		continue
	}
		#-- others== invalid cmd
	f_NRR "invalid mode: $dst_"
	break

		done

	f_reset
	f_nrr "quit daemon"
	#exit
}

f_boot(){
	#-- loop
	f_kill 0 || f_getkey| f_readloop| f_amon
	#-- break
	f_kill >/dev/null 2>&1
	exit
}

# cmd/mod/kc, up 0 36, down 0 45
f_getkey(){
	xinput --test-xi2 --root |
	while read -r _1 _2 _3 _4 _5 _6 _7 _8 _9;do
	[ "$_4" = "(KeyPress)" ] && printf '\n%s ' "@ $_4"
	[ "$_4" = "(KeyRelease)" ] && printf '\n%s ' "@ $_4"
	[ "$_1" = "detail:" ] && printf '%s ' "$_2"
	[ "$_1" = "flags:" ] && printf '%s ' "$_2"
	[ "$_1" = "modifiers:" ] && printf '%s\n' "$_9"
	done |
	while read -r a b c d e;do
	[ "$a" != "@" ] && continue
	[ "$d" = "repeat" ] && continue
	[ "$b" = "(KeyPress)" ] && b=on
	[ "$b" = "(KeyRelease)" ] && b=off
	echo "$b $d $c"
	done
}
#SH_TSS
test_gk_(){
	return
	f_getkey
}
#SH_TSE

f_rungrab(){
	fl="$1"	
	[ "$grab_" = 1 ] && {
		command -v xbindkeys >/dev/null 2>&1
		[ $? != 0 ] && {
			f_wrr "xbindkeys not found. set 'grab=0'"
			exit 1
		}
		echo "$ini_" > "$fl"
		if [ "$vlv" -ge 2 ] ;then
			xbindkeys -v -f "$fl" &
		else
			xbindkeys -v -f "$fl" >/dev/null 2>&1 &
		fi
	#--add qqcmd
		echo "#kill -9 $!" >> "$fl"		
	}
}

#-- add keygrab trick
f_amon(){
	pid=$(eval 'echo $$')
	#--use as: daemon_flg/ini_buffer/qqproc
	fl="/tmp/*SH_bn*.alive.$pid"
	touch "$fl"
 f_rungrab "$fl"
 
	echo "#rm -f $fl" >> "$fl"	#-- cmtline in fl exec at exit
	
	#-- start amon
	while read -r a;do
		[ -e "$fl" ] || exit
	done
}

f_kill()(
	fl="$(f_afile)"
	[ -z "$fl" ] && return 1
	echo "$fl"
	[ "$1" != '0' ] && [ "$1" != '-0' ] && {
		eval "$(cat "$fl"|sed -ne 's/^#//p')"
		rm -f $fl
	}
	return 0
)
f_afile()( ls /tmp/*SH_bn*.alive.* 2>/dev/null )


# xipath:  Copyright (C) 2022 Momi-g, AGPLv3+
xipath()(
	p=''; [ "${1#-[Pf]}" = "" ] && p=1 && shift
	c="$PWD"
	b=${1##*/}
	d=${1%"$b"}
	[ "${d#./}" = "" ] && d="$c"/
	[ "$d" = "../" ] && d="${c%/*}"/
	s="$d$b"
	while [ -L "$s" ];do
		buf="$s: symbolic link to @"	#--format for posix locale
		s=$(LC_ALL=C file -h "$s"|cut -b ${#buf}-;echo @)
		s="${s%??}"
	done
	buf=$(printf '%s@' "$s"|sed -e "s/[*?[]/\\&/g")
	find -L -path "${buf%?}" -type l|grep .&&exit 1		#--see posix 'find'
	d="${s%/*}/"
	[ -z "$p" ] || { cd "$d"; d="$(pwd -P)/";}
	echo "$d${s##*/}@"
)
# xipath: ---end

#-- ~$ wmdd -a 4
*SH_bn*(){
	cdir_=$(pwd)
	sdir_=$(xipath $0)
	sdir_=${sdir_%?}
	export PATH="$sdir_:$PATH"
	hash -r
	cd "$cdir_"

		while getopts ":hHVsv:f:e:0q" c && v="$OPTARG" && xx=1; do
		while [ "$xx" = 1 ]&&xx=0; do case "$c" in	#-- xx: fall-through magic		
	(h) f_usage	;;
	(H) f_usageH	;;
	(V) f_verinfo	;;
	(s) f_sample	;;
	( v) [ "${v%[0-2]}" = "" ]&&vlv=$v|| { xx=1;c=:; v="-v $v != 0/1/2";} ;;
	
	( f) cfg="$(cat $v)";;
	( e) cfg="$v";;
	(0) f_kill 0;exit ;;
	(q) f_kill 9 >/dev/null 2>&1 ;exit ;;
	([?:]) f_err "bad opt: $v: $*" ;;	
		esac; done; done; shift $(($OPTIND-1))
	[ "$?" != 0 ] && f_err "$OPTARG" && exit 1

		#-- preset
# f_drr *SH_ln*:"$1, $opt_m, $msg"
	vlv=${vlv:-1}
#	vlv=${vlv:-2}
	f_vlv "$vlv"
	[ -z "$cfg" ] && cfg=$(f_sample)

	#-- load+set
	f_loadcfg "$cfg"
	
	#--fork
	f_kill 0 && { f_wrr "already running";		exit 1;	}
	
 f_wrr "boot daemon"
	f_boot &
}

*SH_bn*_main(){ *SH_bn* "$@"; }
*SH_bn*_main "$@" || exit	#SH_MAIN

#SH_TSS
test_cmd(){
	cmd="*SH_bn*"
#	./$cmd; return
	./$cmd -h;	_suc 1
	./$cmd -H;	_suc 2
	./$cmd -V;	_suc 3
	./$cmd -s;	_suc 4

	echo "ok: test_cmd"
}
#SH_TSE


#SH_TSS
test_w_(){
	awkcode='
function f_impl(s,	a,b,arr){
	return s
}

function f_sort(arr,	mdx,suc){
	for(i in arr){mdx++}
	suc=1; while(suc) {suc=0; for(i=2;i<=mdx;i++) {
	if(arr[i-1]>arr[i]) {buf=arr[i]; arr[i]=arr[i-1] ;arr[i-1]=buf; suc=1; }
	} }
}
function f_uniq(arr, 	mdx,bi,brr){
	for(i in arr){mdx++}
	for(i=1;i<=mdx;i++){ if(arr[i] != brr[bi+0]){ bi++; brr[bi]=arr[i] } }
	split("",arr)
	for(i in brr){ arr[i]=brr[i] }
}
function _runtest(){	#"function _runtest()" >> "0" for ignore but save testcode
	eq(10, 10)
	return
	
	s="{+s+c+l+m1+m2+m3+m4+m5}"
	q="+Control+Lock+Mod1+Mod2+Mod3+Mod4+Mod5+Shift "
	s=f_impl(s)
	eq(s, q)
}
'
awk '
BEGIN{
	_runtest()
	printf("fail/all: %s/%s\n", test_fail+0, test_all+0) > "/dev/stderr"
	exit(0)
}

#*SH_rf* 0 awktool.awk

'"$awkcode"
	nq 1 0
}
#SH_TSE

:<<'EEE'
change log
--
2023-01-30  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.sh(all): rewrite. add tap/hold, btn4/5 repeat, cfg_loader()

	* *SH_bn*.sh.sh(test): add sloppy testcode

2023-01-27  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.sh(main): fix typo, cfg >> ctg

2023-01-21  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.sh(all): init v1.0.0

EEE
#SH_ED

#SH_OP _ a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
#SH_OP h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout	GPLv3+"	 #*/
#SH_OP f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0|tr -d ' \t'|grep -F '()' #*/
#SH_OP t $e"$CW";ftt "$@";$p"bash --posix $Ox $tf"|fvd
#SH_OP T $e"$CW";ftt "$@";$p"dash $Ox $tf"|fvd
#SH_OP i $e"$Cb";$p'shellcheck -s sh -e SC2046,SC2086,SC2004,SC2154,SC2015,SC2006,SC2030,SC2031,SC2145 $bn.sh'|fv
#SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0>eg.sh #;$p"luajit eg.lua"|fv
#SH_OP x Ox="-x";fvd(){ fv 2>&1|tee dbg.txt; } 
#SH_OP v Ov="-v2"

#SH_OP b $e"$CW"
#SH_OP W fpp;$e"$Cm$O$Cw">/dev/null;fborn;chmod 755 $bn $bn.sh;$e"$Cs";$p"$bn $Rs $Rh $tf"	#*/
#SH_OP o $e"$CW";$p'fman $Rh 1'|fv		#*/

#SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
mandoc -Thtml <$bn.$2 >$bn.$2.html
man -Tutf8 -l -<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
"|fv
#(echo '.mso ja.tmac';cat $bn.$2)|man -Tutf8 -l -|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
)

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)
fvd(){ fv; }

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frv|fry|flit|frf)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

#-- longcmd
frf()(
# *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
awk -v tg="${C##*]}rf" -v cs='#' -v ce='' 'index($0,tg){
s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
m="[ -f \"%s\" ]&&(echo \"%s--copyfrom %s %s\";cat \"%s\";echo \"%s--copyend %s %s\")"
mm="[ -f \"%s\" ]&&(_=\"%s%s%s\";cat \"%s\";_=\"%s%s%s\")"
for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,cs,v,ce,v,cs,v,ce))}
next
}
{print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
fry()(buf=`awk '$1~ /^@license|^@copy/ {$1="";print;exit}'<$R0`;sed -e "s@\*${C##*]}copy\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte()(
cat > $Rm-
suite=$(cat $Rm-|awk '$1~/^test_[^(]*\(\)/{print $1}'|sed -e 's/[(].*//g'|$e"$gfn")
[ $# = 0 ] && suite="$suite $suite"|| suite="$suite $@"
suite=`$p'%s\n' "$suite"|tr '[ \t]' '\n'|sort|uniq -d|fsl`
(cat $bn $Rm-|grep -vF "${C##*]}MAIN"
$p'[ $# = 0 ]&&set -- '"$suite"';for fc;do echo "--$fc():">/dev/stderr;$fc;done;_res')
rm -f $Rm-
)
ftt()(shunit_m $Ov>$Rm;fte "$@"<$tf>>$Rm;mv $Rm $tf)

fborn(){
gfn="grep -v '_$'";fgR "${C}TSS_" "${C}TSE"<$R0 |fgr0 "${C}TSS" "${C}TSE"|fbn|fte>tests.code
gfn="cat -";fgr0 "${C}TSS" "${C}TSE"<$R0|fbn>$tf
fgR "${C}TSS" "${C}TSE"<$Rs|fbn|tee $Rm>$bn;mv -f $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
R0="${R0%?}"
}
fpp(){ awk "{gsub(/[*]${C##*]}ln[*]/,NR);print}"<$R0>${R0}_; R0="$R0"_; $p"${R0}"; }
#SH_DE
