static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/*                                                                  */
/*	akxlog.c	 													*/
/*                                                                  */
/*			by A.Kobayashi 2001.11.13								*/
/*                                                                  */
/********************************************************************/
#include	"akxcommon.h"

static int giLogFlg[X_LOG_NO_MAX_RESV]=
	{D_LOG_FLG_STDERR | D_LOG_FLG_FILE
	,D_LOG_FLG_STDOUT | D_LOG_FLG_FILE | D_LOG_FLG_NO_SRC
	,D_LOG_FLG_NONE
	,D_LOG_FLG_NONE
	,D_LOG_FLG_NONE};
static int giLogGrpMask[X_LOG_NO_MAX_RESV]={0,0,0x7fffff00,0,0};
static tdtLogCtlHead *gtlh=NULL;

/********************************************/
/*                                          */
/********************************************/
static int _log_new()
{
	tdtLogCtl *tlc;
	int i;

	if (!gtlh) {
		if (gtlh = akxa_log_new(X_LOG_NO_MAX)) {
			for (i=0;i<X_LOG_NO_MAX_RESV;i++) {
				tlc = akxa_log_get_ctl(gtlh,i);
				tlc->log_flg = giLogFlg[i];
				tlc->log_grp_mask = giLogGrpMask[i];
				tlc->log_rot.rot_file_max = 3;
			}
			akxa_log_set_file_name(gtlh,X_LOG_NO_ERROR, XERROR_LOG_FILE);
			akxa_log_set_file_name(gtlh,X_LOG_NO_PRINT, XPRINT_LOG_FILE);
			akxa_log_set_file_name(gtlh,X_LOG_NO_DEBUG, XDEBUG_LOG_FILE);
		}
		else return -1;
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
tdtLogCtlHead *akx_log_get_object()
{
	return gtlh;
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_out_level(level,logno,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,logno,line;
{
	if (_log_new()) return -1;
	return akxa_log_out_level_main(gtlh,logno,
	                           level,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akx_error_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
	if (_log_new()) return -1;
	akx_log_flg(X_LOG_NO_ERROR, D_LOG_FLG_PRIORITY |
	                          akb_log_flg(X_LOG_NO_ERROR,D_LOG_FLG_CHECK));
	return akxa_log_out_level_pri_main(gtlh,
		X_LOG_NO_ERROR,level,file,line,AKX_LOG_ERR,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akx_print_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
/*
akxaxdump("akx_print_out_level: format",format,32);
*/
	if (_log_new()) return -1;
	akx_log_flg(X_LOG_NO_PRINT, D_LOG_FLG_NO_SRC |
	                          akb_log_flg(X_LOG_NO_PRINT,D_LOG_FLG_CHECK));
	return akxa_log_out_level_pri_main(gtlh,
		X_LOG_NO_PRINT,level,file,line,AKX_LOG_INFO,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akx_debug_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
	if (_log_new()) return -1;
	return akxa_log_out_level_pri_main(gtlh,
		X_LOG_NO_DEBUG,level,file,line,AKX_LOG_DEBUG,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_set_up_name(cpProcName)
char *cpProcName;
{
	int f=0,ret=0;

	if (_log_new()) return -1;
	if (cpProcName && *cpProcName) f = 1;
	if (f) akxa_log_set_proc_name(gtlh,cpProcName);

	return ret;
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_level(i,level)
int i,level;
{
	if (_log_new()) return -1;
	return akxa_log_level(gtlh,i,level);
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_flg(i,f)
int i,f;
{
	if (_log_new()) return -1;
	return akxa_log_flg(gtlh,i,f);
}

/********************************************/
/*                                          */
/********************************************/
char *akx_log_set_file_name(i, cpFile)
int  i;
char *cpFile;
{
	if (_log_new()) return NULL;
	return akxa_log_set_file_name(gtlh, i, cpFile);
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_set_parm(argc,argv,iParm)
int  argc,iParm[];
char *argv[];
{
	if (_log_new()) return -1;
	return akxa_log_set_parm(gtlh,argc,argv,iParm);
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_set_parm2(argc,argv,nparm,iParm)
int  argc,nparm,iParm[];
char *argv[];
{
	if (_log_new()) return -1;
	return akxa_log_set_parm2(gtlh,argc,argv,nparm,iParm);
}

/********************************************/
/*                                          */
/********************************************/
int akx_log_set_command_parm(opt_c,parm_string)
char opt_c,*parm_string;
{
	static tdtGeneralData logno_set[]=
		 {{0,0,0,0,0,"L",-1}
		,{X_LOG_NO_ERROR,0,0,0,0,"E",-1}
		,{X_LOG_NO_PRINT,0,0,0,0,"P",-1}
		,{X_LOG_NO_DEBUG,0,0,0,0,"D",D_LOG_FLG_STDERR}
		};
	char opt_string[2];

	if (_log_new()) return -1;
	opt_string[0] = akxcupper(opt_c);
	opt_string[1] = '\0';
	return akxa_log_set_command_parm(gtlh,4,logno_set,opt_string,parm_string,0);
}
