//
//option 17 1;
option 20 17;
define decimal aa[4];
proc main;
// initialize
	a = 1.0;
	b = 1.0/u_sqrt(2.0);
	t = 0.25;
	p = 1.0;

	d_b = 10.0;
	i = 1;
//	x = (a+b)**2/(4*t);
	x = a + b;
	x = (x*x)/(t*4.0);
	print i++ x;

// run
	loop 20;
		x_b = x;
#*ifdef NARABI
//print /p+5 a b t p;
		[a,b,t,p] = update(a,b,t,p,aa);
#*else
		update(a,b,t,p,aa);
		a = aa[0];
		b = aa[1];
		t = aa[2];
		p = aa[3];
#*endif
//		x = (a+b)**2/(4*t);
		x = a + b;
		x = (x*x)/(t*4.0);
		print i++ x;
		d = x_b - x;
		print /p+30,2 d;
		if abs(d)<=1.0e-50 thenl break;
	end loop;
	print /c- 0 x;
	print PI2;
	return $ERROR;
end proc;

// update algorithm
function update(a, b, t, p, aa);
//	new_a = (a+b)/2.0;
	new_a = (a+b)*0.5;
	new_b = u_sqrt(a*b);
//	new_t = t-p*(a-new_a)**2;
	new_t = a-new_a;
	new_t = t-p*new_t*new_t;
//	new_p = 2.0*p;
	new_p = p+p;
#*ifdef NARABI
//print new_a new_b new_t new_p;
	return [new_a,new_b,new_t,new_p];
#*else
	aa[0] = new_a;
	aa[1] = new_b;
	aa[2] = new_t;
	aa[3] = new_p;
	return 0;
#*endif
end func;

function u_sqrt(b);
	x0 = b;
	if (x0 > 0) then
		if (x0 >= 4) thenl x0 *= 0.5;
		for i=1 to 10;
			d = ((y=x0*x0)-b)/(x0+x0);
			x0 -= d;
//print i x0;
			if (abs(d) <= 1.0e-50) thenl break;
		next;
		if (y > b) then x0--; endif;
	end if;
	return x0;
end func;
