static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************************
*																				*
*	ړI	F	rZ												*
*																				*
*	֐		F	int cl_cmpt_comp(pAns , pOprtr , pInfoParm1 , pInfoParm2)	*
*						(O)int	*pAns											*
*						(I)char	*pOprtr											*
*						(I)tdtInfoParm *pInfoParm1								*
*						(I)tdtInfoParm *pInfoParm2								*
*																				*
*	߂l		F	ERROR														*
*					NORMAL														*
*																				*
*	Tv	F																*
*																				*
*********************************************************************************/
#include <colmn.h>
extern CLPRTBL *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

static char *Enzan[]={
	"EQ","iEQ","==","",
	"NE","iNE","!=","<>","><","",
	"GT",">","",
	"LT","<","",
	"GE",">=","=>","",
	"LE","<=","=<",NULL};
static unsigned char jg[6][3]={
	{0,1,0},
	{1,0,1},
	{0,0,1},
	{1,0,0},
	{0,1,1},
	{1,1,0}};

static int _get_comp_no(pOprtr,opt)
char *pOprtr;
int opt;
{
	int i,opr;
#if 1	/* 2019.8.30 */
	opr = akxs_seqr_str(Enzan,-1,pOprtr,0x11);
	if (!opr) {
		if (opt) {
			/* cl_cmpt_comp: Zq(%s)Ɍ肪܂B */
			ERROROUT2(FORMAT(245),"cl_cmpt_comp",pOprtr);
		}
		opr = -1;
	}
	else opr--;
#else
	for (i=0,opr=0;;i++) {
		if (!Enzan[i]) {
			if (opt) {
				/* cl_cmpt_comp: Zq(%s)Ɍ肪܂B */
				ERROROUT2(FORMAT(245),"cl_cmpt_comp",pOprtr);
			}
			return -1;
		}
		else if (!(*Enzan[i])) opr++;
		else if (!stricmp(pOprtr,Enzan[i])) break;
	}
#endif
	return opr;
}

static int _memcmplen(p1,len1,p2,len2,opt)
char *p1,*p2;
int  len1,len2,opt;
{
#if 1	/* 2019.10.12 */
	return akxmbncmp_opt(p1,len1,p2,len2,opt);
#else
	int result;

	if (len1==0 && len2==0) result = 0;
	else if(len1 < len2) {
		if (!(result = opt?akxmemicmp(p1,p2,len1):memcmp(p1,p2,len1)))
			result = -1;
	}
	else if(len1 > len2) {
		if (!(result = opt?akxmemicmp(p1,p2,len2):memcmp(p1,p2,len2)))
			result = 1;
	}
	else {
		result = opt?akxmemicmp(p1,p2,len1):memcmp(p1,p2,len1);
	}
	return result;
#endif
}

static int _comp_array(pAns,pOprtr,pInfoParm1,pInfoParm2)
int *pAns;
char *pOprtr;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
{
	tdtInfoParm *ppParm[6],Info,Info1;

	cl_set_parm_char(&Info1,pOprtr,strlen(pOprtr));
	cl_null_parm(&Info);
	ppParm[0] = pInfoParm1;
	ppParm[1] = &Info;
	ppParm[2] = pInfoParm2;
	ppParm[3] = &Info;
	ppParm[4] = &Info;
	ppParm[5] = &Info1;
	return cl_array_ope_opt(pAns,6,ppParm,D_FUC_ARRAY_CMP,0x01);
}

int cl_cmpt_comp(pAns,pOprtr,pInfoParm1,pInfoParm2,narg,prmp)
int			*pAns;
char		*pOprtr;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int			narg;
parmList    *prmp[];
{
	return cl_cmpt_comp_opt(pAns,pOprtr,pInfoParm1,pInfoParm2,narg,prmp,0);
}

int cl_cmpt_comp_opt(pAns,pOprtr,pInfoParm1,pInfoParm2,narg,prmp,cmp_opt)
int			*pAns;
char		*pOprtr;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int			narg;
parmList    *prmp[];
int         cmp_opt;
{
	int    rc,atr1,atr2,result,len1,len2,like,opt,mflg,flags[2];
	int    Value1,Value2,Val1[NMPA_INT],Val2[NMPA_INT];
	int    ope,parm[5],nparm,iDATA1,iDATA2;
	double dVal1,dVal2;
	char   *dat1,*dat2,id1,id2;
	char   errbuf[256];
	MPA *mpa1,*mpa2,*mpa,ma1,ma2;
	tdtInfoParm *ppParm[PM_MAX],*pParm,InfoParmW;

	int opr,i;

DEBUGOUT_InfoParm(110,"cl_cmpt_comp:1: pOprtr=[%s] narg=%d",pInfoParm1,pOprtr,narg);
DEBUGOUT_InfoParm(110,"cl_cmpt_comp:2:",pInfoParm2,0,0);

	*pAns = 0;
	rc = NORMAL;
#if 1
	if ((id1=pInfoParm1->pi_id) != (id2=pInfoParm2->pi_id)) {
		/* p[^̃f[^hc(id1=%c id2=%c)Ă܂B */
		ERROROUT2(FORMAT(241),id1,id2);
		return -1;
	}
#endif
/*
	if (id1 != ' ') {
		result = 0;
		*pAns = result;
		return DEF_ZOK_BINA;
	}
*/
	if (cmp_opt & 0x01) {
		iDATA1 = 1;
		iDATA2 = 1;
	}
	else {
		iDATA1 = pInfoParm1->pi_aux[0] & DEF_ZOK_DATA;
		iDATA2 = pInfoParm2->pi_aux[0] & DEF_ZOK_DATA;
	}
	atr1 = pInfoParm1->pi_attr;
	atr2 = pInfoParm2->pi_attr;
	len1 = pInfoParm1->pi_dlen;
	len2 = pInfoParm2->pi_dlen;
	dat1 = pInfoParm1->pi_data;
	dat2 = pInfoParm2->pi_data;
  if (id1 == ' ') {
	if ((atr1==DEF_ZOK_CHAR && !len1) || (atr2==DEF_ZOK_CHAR && !len2) ||
	    (atr1==atr2) ||
	    ((atr1==DEF_ZOK_BINA || atr1==DEF_ZOK_FLOA || atr1==DEF_ZOK_DECI || atr1==DEF_ZOK_DATE) &&
	     (atr2==DEF_ZOK_BINA || atr2==DEF_ZOK_FLOA || atr2==DEF_ZOK_DECI || atr2==DEF_ZOK_DATE))) {
		;
	}
	else if (!(pGlobTable->options[1] & 0x01) && atr1!=DEF_ZOK_BULK && atr2!=DEF_ZOK_BULK) {
		if (atr1 == 1) {
			pInfoParm1 = &InfoParmW;
			if ((rc=cl_conv_const_n_str(&InfoParmW, dat1, len1)) < 0) return rc;
			atr1 = pInfoParm1->pi_attr;
			len1 = pInfoParm1->pi_dlen;
			dat1 = pInfoParm1->pi_data;
		}
		else if (atr2 == 1) {
			pInfoParm2 = &InfoParmW;
			if ((rc=cl_conv_const_n_str(&InfoParmW, dat2, len2)) < 0) return rc;
			atr2 = pInfoParm2->pi_attr;
			len2 = pInfoParm2->pi_dlen;
			dat2 = pInfoParm2->pi_data;
		}
	}
	else {
/*
printf("attr1 = %d, attr2 = %d\n",atr1,atr2);
*/
		/* p[^̌^(attr1=%d attr2=%d)Ă܂B */
		ERROROUT2(FORMAT(242),atr1,atr2);
		return -1;
	}

	if ((atr1 == DEF_ZOK_BINA || atr1 == DEF_ZOK_FLOA || atr1==DEF_ZOK_DECI) &&
	    (atr2 == DEF_ZOK_BINA || atr2 == DEF_ZOK_FLOA || atr2==DEF_ZOK_DECI)) {
		if (len1==0 || dat1==NULL) {
			ERROROUT1(FORMAT(243),FORMAT(248));	/* p[^kłB */
		 	return -1;
		}
		if (len2==0 || dat2==NULL) {
			ERROROUT1(FORMAT(243),FORMAT(249));	/* p[^kłB */
		 	return -1;
		}
		mpa1 = (MPA *)dat1;
		mpa2 = (MPA *)dat2;
		if (atr1 == DEF_ZOK_BINA)
			Value1 = cl_get_data_long(pInfoParm1);
		/*	memcpy(&Value1, dat1, sizeof(int));	*/
		else if (atr1 == DEF_ZOK_FLOA)
			memcpy(&dVal1, dat1, sizeof(double));
		if (atr2 == DEF_ZOK_BINA)
			Value2 = cl_get_data_long(pInfoParm2);
		/*	memcpy(&Value2, dat2, sizeof(int));	*/
		else if (atr2 == DEF_ZOK_FLOA)
			memcpy(&dVal2, dat2, sizeof(double));
		if (atr1 == DEF_ZOK_FLOA || atr2 == DEF_ZOK_FLOA) {
			if (atr1 == DEF_ZOK_BINA) dVal1 = Value1;
			else if (atr1 == DEF_ZOK_DECI) m_dset(&dVal1,mpa1);
			if (atr2 == DEF_ZOK_BINA) dVal2 = Value2;
			else if (atr2 == DEF_ZOK_DECI) m_dset(&dVal2,mpa2);
			if (toupper(*pOprtr) == 'M') {
				if (!stricmp(pOprtr,"MAX")) dVal1 = X_MAX(dVal1,dVal2);
				else if (!stricmp(pOprtr,"MIN")) dVal1 = X_MIN(dVal1,dVal2);
				else return -1;
				memcpy(pAns,&dVal1,sizeof(double));
				return DEF_ZOK_FLOA;
			}
			else {
				if (dVal1 == dVal2)
					result = 0;
				else if (dVal1 > dVal2)
					result = 1 ;
				else
					result = -1;
			}
		}
		else if (atr1 == DEF_ZOK_DECI || atr2 == DEF_ZOK_DECI ||
		         (atr1==DEF_ZOK_DATE && atr2==DEF_ZOK_DATE)) {
			if (atr1 == DEF_ZOK_BINA) {
				mpa1 = (MPA *)Val1;
				m_l2mpa(Value1,mpa1);
			}
			if (atr2 == DEF_ZOK_BINA) {
				mpa2 = (MPA *)Val2;
				m_l2mpa(Value2,mpa2);
			}
			result = m_cmp(mpa1,mpa2);
			if (toupper(*pOprtr) == 'M') {
				if (!stricmp(pOprtr,"MAX")) mpa = result>0 ? mpa1: mpa2;
				else if (!stricmp(pOprtr,"MIN")) mpa = result<0 ? mpa1: mpa2;
				else return -1;
				memcpy(pAns,mpa,sizeof(MPA));
				return DEF_ZOK_DECI;
			}
		}
		else {
			if (toupper(*pOprtr) == 'M') {
				if (!stricmp(pOprtr,"MAX")) result = X_MAX(Value1,Value2);
				else if (!stricmp(pOprtr,"MIN")) result = X_MIN(Value1,Value2);
				else return -1;
				*pAns = result;
				return DEF_ZOK_BINA;
			}
			else {
				if ( Value1 == Value2 )
					result = 0;
				else if ( Value1 > Value2 )
					result = 1;
				else
					result = -1;
			}
		}
	}
	else if (atr1==DEF_ZOK_DATE || atr2==DEF_ZOK_DATE) {
		if ((rc=cl_get_parm_date(pInfoParm1,&ma1,"CMP DATE1")) < 0) return rc;
		if ((rc=cl_get_parm_date(pInfoParm2,&ma2,"CMP DATE2")) < 0) return rc;
		result = _memcmplen(ma1.num,ma1.len,ma2.num,ma2.len,0);
		if (toupper(*pOprtr) == 'M') {
			if (!stricmp(pOprtr,"MAX")) mpa = result>0 ? &ma1: &ma2;
			else if (!stricmp(pOprtr,"MIN")) mpa = result<0 ? &ma1: &ma2;
			else return -1;
			memcpy(pAns,mpa,sizeof(MPA));
			return DEF_ZOK_DATE;
		}
	}
	else {
/*
printf("op=[%s] len1=%d s1=[%.*s] len2=%d s2=[%.*s]\n",pOprtr,
pInfoParm1->pi_dlen,pInfoParm1->pi_dlen,pInfoParm1->pi_data,
pInfoParm2->pi_dlen,pInfoParm2->pi_dlen,pInfoParm2->pi_data);
*/
		mflg = (pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX) ? 0x04 : 0;
		opt = 0;
		if (!stricmp(pOprtr,"LIKE")||(opt=!stricmp(pOprtr,"iLIKE"))) {
			rc = akxs_xlike(dat1,len1,dat2,len2,opt);
			if (rc < 0) return rc;
			else if (rc > 0) result = 0;	/* unmatch */
			else result = 1;	/* match */
			*pAns = result;
			return DEF_ZOK_BINA;
		}
		else if (!stricmp(pOprtr,"IN")||(opt=!stricmp(pOprtr,"iIN"))) {
			if (cl_get_func_name(pOprtr,parm)) {
				ope = parm[1];
				ppParm[0] = pInfoParm1;
				ppParm[1] = pInfoParm2;
				nparm = narg + 2;
				if (!(pParm=(tdtInfoParm *)cl_tmp_const_malloc(nparm*sizeof(tdtInfoParm))))
					 return ECL_MALLOC_ERROR;
				for (i=0;i<narg;i++) {
					if ((rc=cl_gx_exp_obj_opt(1,&prmp[i],NULL,pParm,0)) < 0) return rc;
					ppParm[i+2] = pParm++;
				}
				return cl_func_comp(&pAns,pOprtr,nparm,ppParm,ope);
			}
			else return -1;
		}
		else if (!stricmp(pOprtr,"INSTR")||(opt=!stricmp(pOprtr,"INiSTR"))) {
/*
printf("cl_cmpt_comp: opt=%d\n",opt);
*/
			*pAns = akxs_in_mem_opt(dat1,len1,dat2,len2,opt+mflg);
			return DEF_ZOK_BINA;
		}
		else if (!stricmp(pOprtr,"INrSTR")||(opt=!stricmp(pOprtr,"INirSTR"))) {
/*
printf("cl_cmpt_comp: R opt=%d\n",opt);
*/
			*pAns = akxs_in_mem_opt(dat1,len1,dat2,len2,opt+2+mflg);
			return DEF_ZOK_BINA;
		}
		else if (!stricmp(pOprtr,"REGEX")||(opt=!stricmp(pOprtr,"iREGEX"))) {
 			flags[0] = REG_EXTENDED;
			if (opt) flags[0] |= REG_ICASE;
			flags[1] = 0;
			if (*dat1 || !*dat2) {
				rc = akxs_regex(dat2,dat1,0,NULL,flags,sizeof(errbuf),errbuf);
/*
printf("cl_cmpt_comp: regex rc=%d\n",rc);
*/
				if (rc && rc!=REG_NOMATCH) {
					ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
					return -1;
				}
				else rc = rc ? 0 : 1;
			}
			else if (!strcmp(dat2,"()")) rc = 1;
			else rc = 0;
			*pAns = rc;
			return DEF_ZOK_BINA;
		}
		else if (!stricmp(pOprtr,"SKIP_OPT")) {
			opt = (pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX) ? 0x04 : 0;
			rc = akx_skip_opt(dat1,len1,dat2,opt|0x08);
			len1 = akxqmlen(dat1,len1);
			if (rc >= len1) rc = 0;
			else rc++;
			*pAns = rc;
			return DEF_ZOK_BINA;
		}
		if (!stricmp(pOprtr,"iEQ") || !stricmp(pOprtr,"iNE")) opt = 1;
		else opt = 0;
/*
printf("cl_cmpt_comp: opt=%d\n",opt);
*/
		result = _memcmplen(dat1,len1,dat2,len2,opt);
	}
  }
  else if (id1=='L' || id1=='N') {
		parm[0] = parm[1] = 0;
		parm[2] = -1;
		if ((rc=cl_comp_list(pOprtr,pInfoParm1,pInfoParm2,parm,0x01)) >= 0) {
			*pAns = rc;
			rc = DEF_ZOK_BINA;
		}
		return rc;
  }
  else if ((id1=='A' || id1=='R') && (id2=='A' || id2=='R') && iDATA1 && iDATA2) {
		if ((rc=_comp_array(pAns,pOprtr,pInfoParm1,pInfoParm2)) >= 0)
			 rc = DEF_ZOK_BINA;
		return rc;
  }
  else {
		if (!stricmp(pOprtr,"iEQ") || !stricmp(pOprtr,"iNE")) opt = 1;
		else opt = 0;
		result = _memcmplen(dat1,len1,dat2,len2,opt);
  }
#if 1	/* 2019.7.31 */
	if ((opr=_get_comp_no(pOprtr,1)) < 0) {
		*pAns = 0;
		return -1;
	}
#else
	for (i=0,opr=0;;i++) {
		if (!Enzan[i]) {
			/* cl_cmpt_comp: Zq(%s)Ɍ肪܂B */
			ERROROUT2(FORMAT(245),"cl_cmpt_comp",pOprtr);
			*pAns = 0 ;
		 	return -1;
		}
		else if (!(*Enzan[i])) opr++;
		else if (!stricmp(pOprtr,Enzan[i])) break;
	}
#endif
	if (result<0) i = 0;
	else if (result>0) i = 2;
	else i = 1;
	*pAns = jg[opr][i];
/*
printf("cl_cmpt_comp: opr=%d, result=%d\n",opr,result);
*/

	return DEF_ZOK_BINA;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_comp(ppWork,pOperator,nparm,ppParm,ope)
char **ppWork;
char *pOperator;
tdtInfoParm **ppParm;
int nparm,ope;
{
	tdtInfoParm *pInfoParm;
	int  i,len1,len2,iRc,pos[2],attr,opt,pos_min,pos_max,lenm,i1,optw;
	char *pWork;
	char ww[64],*pp[2],*pp0,*p,c;
	int		rc,atr1,atr2,iAttr[3],result;
	int		Value1,Val1[NMPA_INT],Val2[NMPA_INT],iVal;
	int		Value2;
	double  dValue1,dValue2,dVal;
	char    op;
	char    errbuf[256];
	MPA     *mpa1,*mpa2,*mpa,ma1,ma2;
	parmList pList;
/*
printf("cl_func_comp: pOperator=[%s] ope=%d nparm=%d\n",pOperator,ope,nparm);
*/
	pGlobTable->error = 0;
	pWork = *ppWork;
	iRc = attr = opt = 0;
	switch (ope) {
	case D_FUC_ILIKE:
		opt++;
	case D_FUC_LIKE:
/*
printf("cl_func_comp: opt=%d nparm=%d\n",opt,nparm);
*/
	/*	pp[0] = ww;	*/
		pp[1] = ww + 32;
		if ((i1=cl_get_str_pos(nparm,ppParm,0,pp,&len1,NULL,NULL,"LIKEs")) < 0) return i1;
		if (i1 < nparm-1) {
			pInfoParm = ppParm[nparm-1];
			if (pInfoParm->pi_attr == DEF_ZOK_BINA) {
				opt |= cl_get_data_int(pInfoParm) & 0x03;
				nparm--;
/*
printf("cl_func_comp:LIKE: i1=%d opt=%d nparm=%d\n",i1,opt,nparm);
*/
			}
		}
		for (i=i1;i<nparm;i++) {
			if ((iRc=parm_to_char(ppParm[i],&pp[1],NULL)) < 0) goto Err;
			len2 = iRc;
			if ((iRc=akxs_xlike(pp[0],len1,pp[1],len2,opt))<0)
				goto Err;
/*
printf("cl_func_comp: i=%d iRc=%d\n",i,iRc);
*/
			if (!iRc) break;
		}
		iRc = iRc ? 0 : i-i1+1;
		memcpy(pWork,&iRc,sizeof(int));
		iRc = DEF_ZOK_BINA;
		break;
	case D_FUC_INIRSTR:
		opt++;
	case D_FUC_INRSTR:
		opt++;
	case D_FUC_INISTR:
	case D_FUC_IIN:
		opt++;
	case D_FUC_INSTR:
	case D_FUC_IN:
		opt += (pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX) ? 0x04 : 0;
		if (ope==D_FUC_IIN || ope==D_FUC_IN) opt += 0x08;
/*
printf("cl_func_comp: opt=%d\n",opt);
*/
	/*	pp[0] = ww;	*/
		pp[1] = ww + 32;
		if ((i1=cl_get_str_pos(nparm,ppParm,0,pp,&len1,&lenm,pos,"INSTRs")) < 0) return i1;
		if (i1 < nparm-1) {
			pInfoParm = ppParm[nparm-1];
			if (pInfoParm->pi_attr == DEF_ZOK_BINA) {
				optw = cl_get_data_int(pInfoParm);
				opt |= (optw & 0x01) | ((optw & 0x02)<<4);
				nparm--;
/*
printf("cl_func_comp:IN: i1=%d opt=%d nparm=%d\n",i1,opt,nparm);
*/
			}
		}
		pp0 = pp[0];
		pos_min = lenm + 1;
		pos_max = 0;
		for (i=i1;i<nparm;i++) {
			if ((iRc=parm_to_char(ppParm[i],&pp[1],NULL)) < 0) goto Err;
			len2 = iRc;
			if ((iRc=akxs_in_mem_opt(pp0,len1,pp[1],len2,opt)) < 0) goto Err;
/*
printf("cl_func_comp: i=%d iRc=%d\n",i,iRc);
*/
			if (iRc) {
				if (opt & 0x08) {
					pos_max = i - i1 + 1;
					break;
				}
				else {
					if (iRc < pos_min) pos_min = iRc;
					if (iRc > pos_max) pos_max = iRc;
				}
			}
		}
/*
printf("INSTR: nparm=%d i1=%d opt=%d pos=%d lenm=%d pos_min=%d pos_max=%d\n",
nparm,i1,opt,pos[0],lenm,pos_min,pos_max);
*/
		if (opt & 0x08) {
			pos_min = pos_max;
		}
		else {
			if (opt & 0x02) pos_min = pos_max;
			else if (pos_min == lenm+1) pos_min = 0;
			if (!(pGlobTable->options[17] & 0x01) && pos_min) pos_min += pos[0] - 1;
		}
		memcpy(pWork,&pos_min,sizeof(int));
		iRc = DEF_ZOK_BINA;
		break;
	case D_FUC_MAX:
	case D_FUC_MIN:
		pInfoParm = ppParm[0];
		attr = pInfoParm->pi_attr;
		if (attr==DEF_ZOK_BINA || attr==DEF_ZOK_FLOA || attr==DEF_ZOK_DECI) {
			if ((rc=cl_get_parm_mpa(pInfoParm,Val1,"Parm1:",iAttr)) < 0)
				return rc;
			else if (rc > 0) return ECL_SCRIPT_ERROR;
			atr1 = iAttr[0];
			if (atr1 == DEF_ZOK_BINA) Value1 = CL_GET_VAL_BIN(Val1);
			else if (atr1 == DEF_ZOK_FLOA)
				memcpy(&dValue1,Val1,sizeof(double));
			else if (atr1 == DEF_ZOK_DECI) mpa1 = (MPA *)Val1;
			else return ECL_SCRIPT_ERROR;
			for (i=1;i<nparm;i++) {
				if ((rc=cl_get_parm_mpa(ppParm[i],Val2,"Parm1:",iAttr)) < 0)
					return rc;
				else if (rc > 0) return ECL_SCRIPT_ERROR;
				atr2 = iAttr[0];
				if (atr2 == DEF_ZOK_BINA) Value2 = CL_GET_VAL_BIN(Val2);
				else if (atr2 == DEF_ZOK_FLOA) {
					memcpy(&dValue2,Val2,sizeof(double));
				}
				else if (atr2 == DEF_ZOK_DECI) mpa2 = (MPA *)Val2;
				else return ECL_SCRIPT_ERROR;
				if (atr1 == DEF_ZOK_BINA) {
					if (atr2 == DEF_ZOK_FLOA) Value2 = cl_chk_over_flow_d2_i(dValue2,"cl_func_comp");
					else if (atr2 == DEF_ZOK_DECI) m_mpa2i(mpa2,&Value2);
					if (ope == D_FUC_MAX) {
						if (Value2 > Value1) Value1 = Value2;
					}
					else {
						if (Value2 < Value1) Value1 = Value2;
					}
				}
				else if (atr1 == DEF_ZOK_DECI) {
					mpa2 = (MPA *)Val2;
					if (atr2 == DEF_ZOK_BINA) m_i2mpa(Value2,mpa2);
					else if (atr2 == DEF_ZOK_FLOA) m_d2mpa(dValue2,mpa2);
					result = m_cmp(mpa1,mpa2);
					if (ope == D_FUC_MAX) mpa = result>0 ? mpa1 : mpa2;
					else mpa = result<0 ? mpa1 : mpa2;
					if (mpa1 != mpa) memcpy(mpa1,mpa,sizeof(MPA));
				}
				else {
					if (atr2 == DEF_ZOK_BINA) dValue2 = Value2;
					if (ope == D_FUC_MAX) {
						if (dValue2 > dValue1) dValue1 = dValue2;
					}
					else {
						if (dValue2 < dValue1) dValue1 = dValue2;
					}
				}
			}
			if (atr1 == DEF_ZOK_BINA) memcpy(pWork,&Value1,sizeof(int));
			else if (atr1 == DEF_ZOK_DECI) {
				if (!(pWork=cl_tmp_const_malloc(sizeof(MPA)))) return ECL_MALLOC_ERROR;
				memcpy(pWork,mpa1,sizeof(MPA));
				*ppWork = pWork;
/*
printf("cl_func_comp: atr1=%d\n",atr1);
*/
			}
			else memcpy(pWork,&dValue1,sizeof(double));
			iRc = atr1;
		}
		else if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_DATE) {
			if (attr==DEF_ZOK_CHAR) {
				iRc = parm_to_char_tmp(ppParm[0],&pp[0],0);
				len1 = iRc;
			}
			else {
				mpa1 = &ma1;
				mpa2 = &ma2;
				iRc = cl_get_parm_date(ppParm[0],mpa1,"MAX/MIN");
				pp[0] = ma1.num;
				len1 = ma1.len;
/*
printf("cl_func_comp: len1=%d pp[0]=%08x\n",len1,pp[0]);
*/
			}
			if (iRc < 0) goto Err;
			for (i=1;i<nparm;i++) {
				if (attr==DEF_ZOK_CHAR) {
					iRc = parm_to_char_tmp(ppParm[i],&pp[1],0);
					len2 = iRc;
				}
				else {
					iRc = cl_get_parm_date(ppParm[i],mpa2,"MAX/MIN");
					pp[1] = mpa2->num;
					len2 = mpa2->len;
/*
printf("cl_func_comp: len2=%d pp[1]=%08x\n",len2,pp[1]);
*/
				}
				if (iRc < 0) goto Err;
				rc = _memcmplen(pp[0],len1,pp[1],len2,0);
				if (((ope==D_FUC_MAX) && (rc<0)) ||
				    ((ope==D_FUC_MIN) && (rc>0))) {
					pp[0] = pp[1];
					len1 = len2;
/*
printf("cl_func_comp: len1=%d pp[0]=%08x\n",len1,pp[0]);
*/
					if (attr==DEF_ZOK_DATE) {
						mpa = mpa2;
						mpa2 = mpa1;
						mpa1 = mpa;
					}
				}
			}
		/*	if (!(pWork = cl_tmp_const_malloc(len1+1))) goto Err;
			memzcpy(pWork,pp[0],len1);
			*ppWork = pWork; */
			if (attr==DEF_ZOK_CHAR) pWork = pp[0];
			else {
				if (!(pWork=cl_tmp_const_malloc(sizeof(MPA)))) return ECL_MALLOC_ERROR;
				memcpy(pWork,mpa1,sizeof(MPA));
/*
printf("cl_func_comp: attr=%d\n",attr);
*/
			}
			*ppWork = pWork;
			iRc = attr;
		}
		else {
			/* %s: p[^̌^(%d)Ă܂B */
			ERROROUT2(FORMAT(285),"cl_func_comp",attr);
			return -1;
		}
		break;
	case D_FUC_IREGEX:
		opt++;
	case D_FUC_REGEX:
		Val1[0] = REG_EXTENDED;
		if (opt) Val1[0] |= REG_ICASE;
		Val1[1] = 0;
	/*	pp[0] = &ww[0];	*/
		pp[1] = &ww[32];
		if ((i1=cl_get_str_pos(nparm,ppParm,0,pp,&len1,NULL,NULL,"REGEXs")) < 0) return i1;
		pp0 = strmem(pp[0],len1);
/*
printf("cl_func_comp: opt=%1d Val1[0]=%02x pp0=[%s] len1=%d\n",opt,Val1[0],pp0,len1);
*/
		for (i=i1;i<nparm;i++) {
			if ((iRc=parm_to_char(ppParm[i],&pp[1],NULL)) < 0) goto Err;
/*
printf("cl_func_comp:                  pp[%d]=[%s]\n",i,pp[1]);
*/
			if (*pp[0] || !*pp[1]) {
				iRc = akxs_regex(pp[1],pp0,0,NULL,Val1,sizeof(errbuf),errbuf);
/*
printf("cl_func_comp: regex iRc=%d\n",iRc);
*/
				if (iRc && iRc!=REG_NOMATCH) {
					ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
					iRc = -1;
					goto Err;
				}
			}
			else if (!strcmp(pp[1],"()")) iRc = 0;
			else iRc = 1;
			if (!iRc) break;
		}
		iRc = iRc ? 0 : i-i1+1;
		memcpy(pWork,&iRc,sizeof(int));
		iRc = DEF_ZOK_BINA;
		break;
	case D_FUC_SKIP_OPT:
		opt = (pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX) ? 0x04 : 0;
		opt |= 0x08;
	/*	pp[0] = ww;	*/
		pp[1] = ww + 32;
		if ((i1=cl_get_str_pos(nparm,ppParm,0,pp,Val1,&lenm,pos,"SKIP_OPT")) < 0) return i1;
		if ((iRc=parm_to_char(ppParm[i1],&pp[1],NULL)) < 0) goto Err;
		Val1[1] = iRc;
/*
printf("cl_func_comp: skip_opt: pp[0]=[%s] Val1[0]=%d i1=%d pp[1]=[%s] Val1[1]=%d lenm=%d pos=%d\n",
pp[0],Val1[0],i1,pp[1],Val1[1],lenm,pos[0]);
*/
		i1++;
		if (nparm > i1) {
			pInfoParm = ppParm[i1];
			if (pInfoParm->pi_attr==DEF_ZOK_CHAR) {
				p = pInfoParm->pi_data;
				len1 = pInfoParm->pi_dlen;
				for (i=0;i<len1;i++) {
					c = toupper(*p++);
					if (c=='I') opt |= 0x01;
					else if (c=='R') opt |= 0x02;
					else if (c=='M') opt |= 0x04;
				/*	else if (c=='B') opt &= ~0x04;	*/
					else if (c=='T') opt |= 0x08;
					else if (c=='N') opt &= ~0x08;
				}
			}
			else {
				opt &= 0x04;
				if (iRc=cl_get_parm_bin(pInfoParm,&iVal,"skip_opt")) goto Err;
				opt |= iVal;
			}
/*
printf("cl_func_comp: skip_opt: opt=%08x\n",opt);
*/
		}
		iRc = akx_skip_opt(pp[0],Val1[0],pp[1],opt);
/*
printf("cl_func_comp: skip_opt: iRc=%d lenm=%d pos=%d\n",iRc,lenm,pos[0]);
*/
#if 1
		pos[0]--;
		if (!(pGlobTable->options[17] & 0x08)) {
			iRc += pos[0];
			lenm += pos[0];
		}
		if (!(opt & 0x02)) {
			if ((opt & 0x08) && (iRc>=lenm)) iRc = 0;
			else iRc++;
		}
#else
		if (opt & 0x02) {	/* reverse */
			if (opt & 0x08) {	/* to */
				;
			}
			else {	/* in */
			/*	if (iRc > 0) iRc--;	*/
			}
		}
		else {
			if (opt & 0x08) {	/* to */
				if (iRc >= lenm) iRc = 0;
				else iRc++;
			}
			else {	/* in */
				iRc++;
			}
		}
#endif
		memcpy(pWork,&iRc,sizeof(int));
		iRc = DEF_ZOK_BINA;
		break;
	default:
		ERROROUT2("pOperator(%s)ope(%d)słB",pOperator,ope);
		return ECL_SCRIPT_ERROR;
	}
 Err:
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int _get_str_pos(pos,ppp0,plen1,plenm)
int pos[];
char **ppp0;
int *plen1,*plenm;
{
	parmList pList;
	char *pp0;
	int mflg,rc,len1,lenm;
/*
printf("cl_get_str_pos: pos=%d ppp0=%08x plen1=%08x plenm=%08x\n",
pos,ppp0,plen1,plenm);
*/
	mflg = pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX;
	pp0 = *ppp0;
/*
printf("_get_str_pos:1: pp0=[%s]\n",pp0);
*/
	if (plen1) len1 = *plen1;
	else len1 = strlen(pp0);
	lenm = len1;
	if (lenm>0 && mflg) lenm = akxqmlen(pp0,len1);
	if (lenm > 0) {
		if (pos[0] <= 0) ;
		else if (pos[0] <= lenm) {
			if (pos[1] < 0) lenm -= pos[0] - 1;
			else lenm = pos[1];
			if (mflg) {
				len1 = substr_mlen(&pList,pp0,len1,pos[0],lenm);
				pp0 = pList.prp;
				if (plen1) *plen1 = len1;
			}
			else pp0 += pos[0] - 1;
			*ppp0 = pp0;
		}
		else {
			*ppp0 = "";
			lenm = len1 = 0;
			if (plen1) *plen1 = len1;
		}
	}
	if (plenm) *plenm = lenm;
/*
printf("_get_str_pos: mflg=%08x len1=%d lenm=%d pos=%d\n",mflg,len1,lenm,pos[0]);
printf("_get_str_pos:2: pp0=[%s]\n",pp0);
*/
	return 0;
}

/********1*********2*********3*********4*********5********6*********7/
/* @\ : Jnʒuƒ߂									*/
/*  : i         : JnʒuԂpos̈ʒu						*/
/*		              pInfoParm͈͎ŵƂ́A0Œ			*/
/*		  pInfoParm : p[^̃|C^							*/
/*		  pos       : pos[i] : Jnʒu 							*/
/*		            : pos[1] :  (͈͎ŵƂ̂ݐݒ)		*/
/* ԋp : ^[R[h											*/
/*		  = 0 : 												*/
/*		  < 0 : G[												*/
/* 쐬 : 20XX.XX.XX Akito Konayashi								*/
/* XV :															*/
/********************************************************************/
int _get_pos_len(i,pInfoParm,pos)
int i;
tdtInfoParm *pInfoParm;
int pos[];
{
	int rc;
	tdtInfoParm tInfoParm;

	if (pInfoParm->pi_id != ' ') return ECL_SYNTAX_ERROR;
	else if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) {
		if (i) {
			/* _get_pos: ͈͎w肪擪ȊOɂ܂Bi=%d */
			ERROROUT1(FORMAT(250),i);
			return ECL_SCRIPT_ERROR;
		}
		if (rc=cl_get_parm_bin(pInfoParm,pos,"str_pos1")) return rc;
		cl_gx_copy_info(&tInfoParm,pInfoParm);
		if (tInfoParm.pi_attr == DEF_ZOK_BINA) tInfoParm.pi_pos = tInfoParm.pi_hlen;
		else tInfoParm.pi_data += tInfoParm.pi_dlen;
		if (rc=cl_get_parm_bin(&tInfoParm,&pos[1],"str_pos2")) return rc;
		pos[1] -= pos[0] - 1;
	}
	else {
		if (rc=cl_get_parm_bin(pInfoParm,&pos[i],"str_posi")) return rc;
	}
	return 0;
}

/********1*********2*********3*********4*********5********6*********7/
/* @\ : u[,Jnʒu[,]]v`͂				*/
/*  : nparm	 : p[^										*/
/*		  ppParm : p[^̃|C^z							*/
/*		  i1     : ̃p[^ʒu(擪0)					*/
/*		  ppp0   : Jnʒũ|C^Ԃ					*/
/*		  plen1  : (oCg)										*/
/*		  plenm  : () 										*/
/*		  ppos   : (݂̂̂Ƃ́A)						*/
/*		           pos[0] : Jnʒu()							*/
/*		         : pos[1] : ()								*/
/*		  msg    : ĂяõRg								*/
/* ԋp : >0 : u,Jnʒu[,]v̎̃p[^ʒu		*/
/*		  <0 : G[												*/
/* 쐬 : 20XX.XX.XX Akito Konayashi								*/
/* XV :															*/
/********************************************************************/
int cl_get_str_pos(nparm,ppParm,i1,ppp0,plen1,plenm,ppos,msg)
int nparm;
tdtInfoParm *ppParm[];
char **ppp0;
int *plen1,*plenm,ppos[];
char *msg;
{
	tdtInfoParm *pInfoParm;
	int len1,lenm,rc,iGET,pos[2],mflg;
	char *pp0;

	if (nparm < i1+1) return -1;
	*ppp0 = NULL;
	if ((rc=parm_to_char(ppParm[i1],ppp0,NULL)) < 0) return rc;
	lenm = len1 = rc;
	i1++;
	pos[1] = -1;
	if (nparm >= i1+1) {
		if (!(pInfoParm = ppParm[i1])) return -2;
		if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_BINA) {
#if 1
			if (rc=_get_pos_len(0,pInfoParm,pos)) return rc;
#else
			pos[0] = cl_get_data_long(pInfoParm);
#endif
			i1++;
			iGET = 1;
			if (nparm >= i1+1) {
				if (!(pInfoParm = ppParm[i1])) return -111;
				if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_BINA) {
					if (rc=_get_pos_len(1,pInfoParm,pos)) return rc;
					i1++;
				}
			}
		}
		else {
			iGET = 0;
			pos[0] = 1;
		}
		if (ppos) {
			ppos[0] = pos[0];
			ppos[1] = pos[1];
		}
	}
	else {
		if (ppos) {
			pos[0] = ppos[0];
			pos[1] = ppos[1];
		}
		else  return -11;
		iGET = 1;
	}
	if (iGET) {
		if (rc=_get_str_pos(pos,ppp0,&len1,&lenm)) return rc;
	}
	else {
		mflg = pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX;
		if (len1>0 && mflg) lenm = akxqmlen(*ppp0,len1);
	}
	if (plen1) *plen1 = len1;
	if (plenm) *plenm = lenm;
	return i1;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_str_pos2(nparm,pParm,i1,ppp0,plen1,plenm,ppos,msg)
int nparm;
tdtInfoParm *pParm;
char **ppp0;
int *plen1,*plenm,*ppos;
char *msg;
{
	tdtInfoParm *ppParm[3];
	int rc,pos[2];

	ppParm[0] = &pParm[0];
	ppParm[1] = &pParm[1];
	if (nparm > 2) ppParm[2] = &pParm[2];
	if (ppos) pos[0] = *ppos;
	pos[1] = -1;
	rc = cl_get_str_pos(nparm,ppParm,i1,ppp0,plen1,plenm,pos,msg);
	if (ppos) *ppos = pos[0];
	return rc;
}

/****************************************/
/*										*/
/****************************************/
#if 1
int cl_gx_str_pos(pInfoParmW,pInfoParm1,optW,pInfoParm2)
tdtInfoParm *pInfoParmW,*pInfoParm1,*pInfoParm2;
int optW;
{
	parmList pList;
	tdtInfoParm  tInfoParm,tInfoParm2[2],*pInfoParm;
	int pos[2],len1,rc,nparm,i,j;
	char *pp0;

DEBUGOUTL1(161,"--->cl_gx_str_pos: optW=%08x",optW);
DEBUGOUT_InfoParm(161,"pInfoParm1:",pInfoParm1,0,0);
DEBUGOUT_InfoParm(161,"pInfoParm2:",pInfoParm2,0,0);

	if (pInfoParm1->pi_id != ' ') return ECL_SYNTAX_ERROR;

	if ((pInfoParm2->pi_alen & D_AULN_NAME_DATA) && pInfoParm2->pi_attr==DEF_ZOK_CHAR) {
		memset(&pList,0,sizeof(parmList));
		pList.prp = pInfoParm2->pi_data;
		pList.prmlen = pInfoParm2->pi_dlen;
		if ((rc=cl_conv_arg(&pList,&tInfoParm)) < 0) {
			if (rc != ECL_DEFINED_ARRAY) return rc;
		}

DEBUGOUT_InfoParm(0,"cl_gx_str_pos:1: rc=%d",&tInfoParm,rc,0);

		if (rc == NAME_CONST) {
			pList.prp = tInfoParm.pi_data;
			pList.prmlen = tInfoParm.pi_dlen;
			if (rc = cl_conv_parm(&pList,&tInfoParm)) {
				if (rc != ECL_DEFINED_ARRAY) return rc;
			}

DEBUGOUT_InfoParm(0,"cl_gx_str_pos:2: rc=%d",&tInfoParm,rc,0);

		}
		if (tInfoParm.pi_id != ' ') return ECL_SYNTAX_ERROR;
		pInfoParm2 = &tInfoParm;
	}
#else
int cl_gx_str_pos(pInfoParmW,pInfoParm1,optW,p2,len2)
tdtInfoParm *pInfoParmW,*pInfoParm1;
int optW;
char *p2;
int len2;
{
	parmList pList;
	tdtInfoParm  tInfoParm,tInfoParm2[2],*pInfoParm,*pInfoParm2;
	int pos[2],len1,rc,nparm,i,j;
	char *pp0;

	if (pInfoParm1->pi_id != ' ') return ECL_SYNTAX_ERROR;

	memset(&pList,0,sizeof(parmList));
	pList.prp = p2;
	pList.prmlen = len2;
	if ((rc=cl_conv_arg(&pList,&tInfoParm)) < 0) return rc;

DEBUGOUT_InfoParm(0,"cl_gx_str_pos:1: ",&tInfoParm,0,0);

	if (rc == NAME_CONST) {
		pList.prp = tInfoParm.pi_data;
		pList.prmlen = tInfoParm.pi_dlen;
		if (rc = cl_conv_parm(&pList,&tInfoParm)) return rc;

DEBUGOUT_InfoParm(0,"cl_gx_str_pos:2: ",&tInfoParm,0,0);

	}
	if (tInfoParm.pi_id != ' ') return ECL_SYNTAX_ERROR;
	pInfoParm2 = &tInfoParm;
#endif
	pos[1] = -1;
	if (pInfoParm2->pi_attr==DEF_ZOK_CHAR) {
		if (rc= cl_gx_exps_obj_opt(pInfoParm2->pi_data,NULL,NULL,tInfoParm2,D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE)) return rc;
		if ((tInfoParm2[0].pi_alen & D_AULN_PARMINFO2) &&
		    (nparm=X_MIN(tInfoParm2[1].pi_pos,2))) {
			pInfoParm = (tdtInfoParm *)tInfoParm2[1].pi_data;
		}
		else {
			nparm = 1;
			pInfoParm = tInfoParm2;
		}
		for (i=0;i<nparm;i++,pInfoParm++) {
DEBUGOUT_InfoParm(0,"cl_gx_str_pos: i=%d",pInfoParm,i,0);
			if (rc=_get_pos_len(i,pInfoParm,pos)) return rc;
			if (pos[1] >= 0) break;
		}
	}
	else if (rc=_get_pos_len(0,pInfoParm2,pos)) return rc;

/*	pp0 = ww;	*/
	if ((rc=cl_get_str_pos(1,&pInfoParm1,0,&pp0,&len1,NULL,pos,"str_pos")) < 0) return rc;
/*
printf("cl_gx_str_pos: len1=%d pos[0]=%d\n",len1,pos[0]);
*/
	if (!(pp0=Memdup(pp0,len1))) return ECL_MALLOC_ERROR;
	cl_set_parm_char(pInfoParmW,pp0,len1);
	return 0;
}

/********1*********2*********3*********4*********5*********6*********7***/
/*																		*/
/*	 :  iParm		: iParm[0] : Ώ1̔rJnʒu				*/
/*						  iParm[1] : Ώ2̔rJnʒu				*/
/*						  iParm[2] : r							*/
/*									   < 0 : Ώۂ̍ő܂Ŕr */
/*			cmp_opt		: rIvV								*/
/*							= 0x01 : rΏۂ̐܂߂đSĂA		*/
/*									 vƂA1Ԃ				*/
/*	ԋp :  cmp_opt0x01												*/
/*			=0̂ƂAv											*/
/*			=1̂ƂA1/0=v/sv									*/
/********1*********2*********3*********4*********5*********6*********7***/
int cl_comp_list(pOprtr,pInfoParm1,pInfoParm2,iParm,cmp_opt)
char *pOprtr;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int iParm[],cmp_opt;
{
	tdtInfoParm *p1,*p2;
	int i1,i2,ix1,ix2,nm,Ans,rc,nu1,nu2,match;
	tdtRbCtl *pCt1,*pCt2;
/*
printf("cl_comp_list:Enter pOprtr=[%s] iParm=%d %d %d cmp_opt=%d\n",
pOprtr,iParm[0],iParm[1],iParm[2],cmp_opt);
*/
	if ((ix1=iParm[0]) < 0) ix1 = 0;
	if ((ix2=iParm[1]) < 0) ix2 = 0;
	nm  = iParm[2];
	Ans = 0;
	pCt1 = (tdtRbCtl *)pInfoParm1->pi_data;
	pCt2 = (tdtRbCtl *)pInfoParm2->pi_data;
	match = 0;
	nu1 = pCt1->rb_used - ix1;
	nu2 = pCt2->rb_used - ix2;
	if (nm >= 0) {
		if (nu1 > nm) nu1 = nm;
		if (nu2 > nm) nu2 = nm;
	}
/*
printf("cl_comp_list:nu1=%d nu2=%d\n",nu1,nu2);
*/
	if (nu1>0 && nu2>0 && (!(cmp_opt & 0x01) || nu1==nu2)) {
		akxs_rb_read(pCt1,0);
		akxs_rb_read(pCt2,0);
		while (ix1-- > 0) {
			if (!(p1=(tdtInfoParm *)akxs_rb_read(pCt1,1))) break;
		}
		while (ix2-- > 0) {
			if (!(p2=(tdtInfoParm *)akxs_rb_read(pCt2,1))) break;
		}
		while (p1=(tdtInfoParm *)akxs_rb_read(pCt1,1)) {
			if (!(p2 = (tdtInfoParm *)akxs_rb_read(pCt2,1))) break;
			if ((rc=cl_cmpt_comp_opt(&Ans,pOprtr,p1,p2,0,NULL,0x01)) < 0) {
/*
printf("cl_comp_list:rc=%d\n",rc);
*/
				Ans = rc;
				break;
			}
			else if (!Ans) {
/*
printf("cl_comp_list:Ans=%d\n",Ans);
*/
				break;
			}
			match++;
/*
printf("cl_comp_list:rc=%d Ans=%d match=%d\n",rc,Ans,match);
*/
			if (nm>0 && match>=nm) break;
		}
	}
	if (Ans && (!(cmp_opt & 0x01))) Ans = match;
	return Ans;
}
