static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi() 2010.5.27		*/
/*											*/
/********************************************/
#include "akxcommon.h"

static MPA _MMAX = {
	'M','P',
	 0, /* opt  */
	52,	/* alen */
	51,	/* len  */
MAXEXP,	/* exp  */
	 0,	/* sign */
	 0,	/* zero */
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 0};

static MPA _M0 = {
	'M','P',
	0,  /* opt  */
	52,	/* alen */
	0,	/* len  */
	0,	/* exp */
	0,	/* sign */
	1,	/* zero */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0};

static MPA _M1 = {
	'M','P',
	0,  /* opt  */
	52,	/* alen */
	1,	/* len  */
	0,	/* exp */
	0,	/* sign */
	0,	/* zero */
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0};

/********************************/
/*								*/
/********************************/
MPA *m_get_i(int i)
{
	if (i==1) return &_M1;
	else return &_M0;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_MMAX()
{
	return &_MMAX;
}

/********************************/
/*								*/
/********************************/
MPA *m_cpy(MPA *d,MPA *s,int iCPY)
{
	memcpy(d,s,sizeof(MPA));
	return d;
}

/********************************/
/*	m_set_an	MPA <-- "123"	*/
/********************************/
int m_set_an(MPA *a, char *s, int len_s)
{
	char *p,cc;
	int c, exp, i, pflag, sign, nzflag, pos, n, j, syo, lens, ret, at;
	char *q;

	if (!a || !s) return -1;
	lens = len_s;
	p = s;
	sign = 0;
	while ((lens > 0) && (cc = *p)) {
		if(cc == '-') sign = 1;
		else if(cc!='+' && cc!=' ' && cc!='0') break;
		p++;
		lens--;
	}
	*a = _M0;
	a->zero = 0;
	at = ret = pos = exp = syo = 0;
	pflag = nzflag = 0;
	while ((lens-- > 0) && (cc = *p++)) {
		at++;
		if (cc == '.') {
			if (pflag) {
				ret = at;
				break;
			}
			if (at==1) syo--;
			pflag = 1;
		}
		else if (cc=='E' || cc=='e') {
			exp += atoi(p);
			break;
		}
		else if(cc == '+' || cc == '-') {
			exp += atoi(p-1);
			break;
		}
		else {
			c = cc - '0';
			if (c<0 || c>9) {
				ret = at;
				break;
			}
			if (c) nzflag = 1;
			if (pos < NMPA) {
				if (nzflag) a->num[pos++] = c;
				else syo--;
				if (!pflag) exp++;
			}
		}
	}
	if (exp) exp--;
	if (syo) exp += syo;
	a->exp  = exp;
	a->sign = sign;
	a->len  = pos;
	if ((at=m_normalize(a)) < 0) ret = at;
/*
m_print("m_set_an: ",a,0);
*/
	return ret;
}

/********************************/
/*	m_set_a		MPA <-- "123"	*/
/********************************/
int m_set_a(MPA *a, char *s)
{
	if (!s) return -1;
	return m_set_an(a,s,strlen(s));
}

MPA *m_pset_an(MPA *a, char *s, int len)
{
	int ret;
	ret = m_set_an(a,s,len);
	if (ret) return &_M0;
	return a;
}

MPA *m_pset_a(MPA *a, char *s)
{
	if (!s) return &_M0;
	return m_pset_an(a,s,strlen(s));
}

/********************************/
/*								*/
/********************************/
int m_normalize(MPA *a)
{
	int pos,i,n,exp,sgn;
	char *q,*r;

	sgn = a->sign;
	exp = a->exp;
	pos = a->len;
	q = a->num + pos - 1;
	while (pos>0 && !*q--) pos--;
	if (pos) {
		i = 0;
		q = a->num;
		while (i<pos && !*q) {
			i++;
			q++;
		}
		if (i > 0) {
			n = i;
			r = a->num;
			for (;i<pos;i++) {
				*r++ = *q;
				*q++ = 0;
			}
			pos -= n;
			exp -= n;
		}
	}
	else {
		a->sign = 0;
		exp  = 0;
		a->zero = 1;
	}
	if (pos > NMPA) {
		pos = NMPA;
		a->num[pos] = 0;
	}
	a->len  = pos;

	if (exp > MAXEXP) {
		*a = _MMAX;
		a->sign = sgn;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*a = _M0;
		return MPA_ERR_UNDERFLOW;
	}
	a->exp = exp;
	return 0;
}

/********************************/
/*								*/
/********************************/
int m_cmp(MPA *a, MPA *b)
{
	int mca;

	if (!a || !b) return -1;
	if (a->zero) {
		if (b->zero) return 0;
		return (b->sign)? 1: -1;
	}
	if (b->zero) return (a->sign)? -1: 1;
	if (a->sign == b->sign) {
		mca = m_cmp_a(a, b);
		return (a->sign)? -mca: mca;
	}
	return (a->sign)? -1: 1;
}

/****************************************/
/*	m_cmp_a		compare |MPA| vs |MPA|	*/
/****************************************/
int m_cmp_a(MPA *aa, MPA *bb)
{
	int i,a_exp,b_exp;
	char *p, *q;

	if (!aa || !bb) return -1;
	if (aa->zero) return (bb->zero)? 0: -1;
	if (bb->zero) return 1;
	if ((a_exp=aa->exp) > (b_exp=bb->exp)) return 1;
	else if (a_exp < b_exp) return -1;

	for(i = 0, p = aa->num, q = bb->num; i <= NMPA; i++, p++, q++)
		if(*p != *q) return (*p > *q)? 1: -1;
	return 0;
}

/****************************************/
/*	m_add		MPA c <-- MPA a + MPA b	*/
/****************************************/
int m_add(MPA *c, MPA *a, MPA *b)
{
	int cmp,ret;
/*
m_print("m_add:a: ",a,0);
m_print("m_add:b: ",b,0);
*/
	if(a->zero)	{
		*c = *b;
		return 0;
	}
	else if (b->zero) {
		*c = *a;
		return 0;
	}
	ret = 0;
	if (a->sign == b->sign) {
		ret = m_add_a(c, a, b);
		c->sign = a->sign;
	}
	else {
		cmp = m_cmp_a(a, b);
		if(!cmp) {
			*c = _M0;
			return 0;
		}
		else if (cmp > 0) {
			ret = m_sub_a(c, a, b);
			c->sign = a->sign;
		}
		else {
			ret = m_sub_a(c, b, a);
			c->sign = b->sign;
		}
	}
/*
m_print("m_add:c: ",c,0);
*/
	return ret;
}

/****************************************/
/*	m_sub		MPA c <-- MPA a - MPA b	*/
/****************************************/
int m_sub(MPA *c, MPA *a, MPA *b)
{
	int cmp,ret;

	if (a->zero) {
		if (b->zero) {
			*c = _M0;
			return 0;
		}
		*c = *b;
		c->sign = 1 - c->sign;
		return 0;
	}
	if (b->zero) {
		*c = *a;
		return 0;
	}
	else if (a->sign != b->sign) {
		ret = m_add_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	cmp = m_cmp_a(a, b);
	if (!cmp) {
		*c = _M0;
		return 0;
	}
	else if (cmp > 0) {
		ret = m_sub_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	ret = m_sub_a(c, b, a);
	c->sign = 1 - b->sign;
	return ret;
}

/************************************************/
/*	m_add_a		MPA ans <-- |MPA a| + |MPA b|	*/
/************************************************/
int m_add_a(MPA *ans, MPA *a, MPA *b)
{
	MPA c,*pc,*pa,*pb;
	char *pan,*pbn;
	int i, u, n, ia, ib, ia1, len1;

	if (!ans || !a || !b) return -1;
	c.sign = 0;
	if (a->zero) {
		*ans = *b;
		return 0;
	}
	if (b->zero) {
		*ans = *a;
		return 0;
	}
	if (a->exp >= b->exp) {
		c = *a;
		pb = b;
	}
	else {
		c = *b;
		pb = a;
	}
	pa = &c;
	c.zero = 0;
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib) > NMPA) {
		ib -= ia-NMPA;
		ia = NMPA;
	}
	if (ib < 0) {
		*ans = c;
		return 0;
	}
	len1 = pa->len - 1;
	ia1 = ia + 1;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	u = 0;
	while (ib-- >= 0) {
		u += *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) >= RADIX) {
			n = u - RADIX;
			u = 1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >= 0) {
			u += *pan;
			if ((n=u) >= RADIX) {
				*pan-- = u - RADIX;
				u = 1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
#if 1
			if (ia1 > pa->len) pa->len = ia1;
#endif
			if (pa->len < NMPA) pa->len++;
			i = pa->len - 1;
			pan = pa->num + i;
			pbn = pan - 1;
			while (i-- > 0) *pan-- = *pbn--;
			pa->num[0] = u;
			pa->exp++;
		}
	}
	if (ia1 > pa->len) pa->len = ia1;
	*ans = c;
/*
m_print("m_add_a:ans: ",ans,0);
*/
	return m_normalize(ans);
}

/************************************************/
/*	m_sub_a		MPA ans <-- |MPA a| - |MPA b|	*/
/************************************************/
int m_sub_a(MPA *ans, MPA *a, MPA *b)
{
	MPA c,*pc,*pa,*pb;
	char *pan,*pbn;;
	int u, n, ia, ib, ia1, len1, len;

	if (!ans || !a || !b) return -1;
	c.sign = 0;
	pa = &c;
	pb = b;
	c = *a;
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib) > NMPA) {
		ib -= ia-NMPA;
		ia = NMPA;
	}
	if (ib < 0) {
		*ans = c;
		return 0;
	}
	len = pa->len;
	len1 = len - 1;
	ia1 = ia + 1;
	u = 0;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	while (ib-- >= 0) {
		u -= *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) < 0) {
			n = u + RADIX;
			u = -1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >=0) {
			u = *pan + u;
			if ((n=u) < 0) {
				*pan-- = u + RADIX;
				u = -1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
			*ans = _M0;
			return MPA_ERR_A_LT_B;
		}
	}
	if (ia1 > len) pa->len = ia1;
	*ans = c;
	return m_normalize(ans);
}

/********************************/
/*	m_add1		MPA a += MPA b	*/
/********************************/
int m_add1(MPA *a, MPA *b)
{
	return m_add(a,a,b);
}

/********************************/
/*	m_sub1		MPA a -= MPA b	*/
/********************************/
int m_sub1(MPA *a, MPA *b)
{
	return m_sub(a,a,b);
}

/************************************/
/*	m_add1_a.c	|MPA a| += |MPA b|	*/
/************************************/
int m_add1_a(MPA *a, MPA *b)
{
	return m_add_a(a,a,b);
}

/************************************/
/*	m_sub1_a	|MPA a| -= |MPA b|	*/
/************************************/
int m_sub1_a(MPA *a, MPA *b)
{
	return m_sub_a(a,a,b);
}

/********************************************/
/*	m_mul		MPA ans <-- MPA a * MPA b	*/
/********************************************/
int m_mul(MPA *ans, MPA *a, MPA *b)
{
	MPA c;
	int i, j, m, *r, *xp, u, v, exp;
	int x[NMPA2];
	char *p, *q;

	if (!ans || !a || !b) return -1;
	if (a->zero || b->zero) {
		*ans = _M0;
		return 0;
	}
	memset(x,0,sizeof(x));
	m = a->len + b->len - 1;
	if (m >= NMPA2) m = NMPA2 - 1;
	for (i=b->len-1, xp=x+m, p=b->num+i; i>=0; i--, xp--, p--) {
		if ((v = *p)) {
			j = a->len - 1;
			q = a->num + j;
			r = xp;
			if (v == 1) {
				while (j-- >= 0) *r-- += *q--;
			}
			else if (v == 2) {
				while (j-- >= 0) {
					u = *q--;
					*r-- += u<<1;
				}
			}
			else {
				while (j-- >= 0) *r-- += *q-- * v;
			}
		}
	}
	c = _M0;
	i = m;
	xp = x + i;
	p = c.num + i;
	u = 0;
	while (i >= 0) {
		if (i == NMPA) u += 5;
		*xp += u;
		if (*xp >= RADIX) {
			u = *xp/RADIX;
			*xp %= RADIX;
		}
		else u = 0;
		if (i-- < NMPA) *p = *xp;
		p--;
		xp--;
	}

	exp = (int)a->exp + (int)b->exp + 1;
	if (exp > MAXEXP) {
		*ans = _MMAX;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*ans = _M0;
		return MPA_ERR_UNDERFLOW;
	}
	a->exp = exp;
	c.zero = 0;
	c.sign = (a->sign == b->sign)? 0: 1;
	c.exp = exp;
	if ((c.len=m+1) > NMPA1) c.len = NMPA1;
	*ans = c;
	m_normalize(ans);
	return 0;
}

/********************************************/
/*	m_div		MPA ans <-- MPA a / MPA b	*/
/********************************************/
int m_div(MPA *ans, MPA *aa, MPA *b)
{
	MPA c, a, t;
	int d, i, exp;
	short b_sign,b_exp;
	char *pcn;

	if (!ans || !aa || !b) return -1;
	t = *aa;
	m_normalize(&t);
	if (t.zero)	{
/*	if (aa->zero) {	*/
		*ans = _M0;
		return 0;
	}
	t = *b;
	m_normalize(&t);
	if (t.zero)	{
/*	if (b->zero) {	*/
		*ans = _MMAX;
		return MPA_ERR_ZERODIVIDE;
	}
	a = *aa;
	b_sign = b->sign;
	b_exp  = b->exp;
	c = _M0;
	c.zero = 0;
	c.sign = (a.sign == b->sign)? 0: 1;
	a.sign = b->sign = 0;

	exp = (int)a.exp - (int)b->exp;
	if (exp > MAXEXP) {
		*ans = _MMAX;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*ans = _M0;
		return MPA_ERR_UNDERFLOW;
	}

	c.exp = exp;
	a.exp = b->exp = 0;
	for (i=0,pcn=c.num;i<=NMPA;) {
		d = 0;
		for (;;) {
			t = a;
			m_sub1(&a,b);
			if (a.sign) {
				a = t;
				a.exp++;
				break;
			}
			d++;
		}
		*pcn++ = d;
		i++;
		if (a.zero) break;
	}
	c.len = i;
	*ans = c;
	m_normalize(ans);
	b->sign = b_sign;
	b->exp  = b_exp;

	return 0;
}

/********************************/
/*	m_mul1		MPA a *= MPA b	*/
/********************************/
int m_mul1(MPA *a, MPA *b)
{
	return m_mul(a,a,b);
}

/********************************/
/*	m_div1		MPA a /= MPA b	*/
/********************************/
int m_div1(MPA *a, MPA *b)
{
	return m_div(a,a,b);
}

/************************************/
/*	m_pack		DEC a <-- MPA b	*/
/************************************/
int m_pack(char *a, int dec_size, MPA *b)
{
	int i,len,size,ret,dsize;
	char *pam,*pbm,c1,c2;

	if (!a || !b) return -1;
	pam = a;
	pbm = b->num;
	size = b->len;
	len = size/2;
	ret = len + 1;
	if (dec_size > 0) {
		if (size > dec_size) return MPA_ERR_SIZE_OVER;
		dsize = dec_size/2 + 1;
		for (i=0;i<dsize-ret;i++) *pam++ = '\0';
	}
	else dsize = ret;
	if (!(size % 2)) {
		c1 = *pbm++;
		*pam++ = c1 & 0x0f;
		len--;
	}
	for (i=0;i<len;i++) {
		c1 = *pbm++;
		c2 = *pbm++;
		*pam++ = c1<<4 | (c2 & 0x0f);
	}
	c1 = *pbm;
	if (b->sign) c2 = 0x0d;
	else c2 = 0x0c;
	*pam = c1<<4 | (c2 & 0x0f);
	return dsize;
}

/************************************/
/*	m_unpack	MPA a <-- DEC b		*/
/************************************/
int m_unpack(MPA *a, char *b, int size, int scale)
{
	int i,len;
	char *pam,*pbm,c,d;

	if (!a || !b) return -1;
	*a = _M0;
	pam = a->num;
	pbm = b;
	len = size/2;
	if (!(size % 2)) {
		c = *pbm++;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		len--;
	}
	for (i=0;i<len;i++) {
		c = *pbm++;
		*pam++ = d = c>>4 & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
	}
	c = *pbm;
	*pam = d = c>>4 & 0x0f;
	if (d > 9) return MPA_ERR_INVALID;
	c &= 0x0f;
	if (c == 0x0d) a->sign = 1;
	else if (c==0x0c || !c) a->sign = 0;
	else return -1;
	a->exp = size - scale - 1;
	a->len = size;
	a->zero = 0;
	m_normalize(a);
	return 0;
}

/********************************/
/*	m_mpa2d						*/
/********************************/
int m_mpa2d(MPA *a, double *dval)
{
	double d;
	int i,exp;
	char *p, *q;

	if (a->zero) {
		*dval = 0.0;
		return 0;
	}
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = (double)*p++;
	while (i-- > 0) {
		d = d * (double)RADIX + (double)*p++;
		exp--;
	}
	while (exp > 0) {
		d *= (double)RADIX;
		exp--;
	}
	while (exp < 0) {
		d /= (double)RADIX;
		exp++;
	}
	if (a->sign) d = -d;
	*dval = d;
	return 0;
}

int m_dset(double *dval, MPA *a)
{
	return m_mpa2d(a, dval);
}

/********************************/
/*	m_mpa2l						*/
/********************************/
int m_mpa2l(MPA *a, long *val)
{
	int ret, i, exp;
	long d;
	char *p,c;

	if (!a || !val) return -1;
	*val = 0;
	if (a->zero || a->exp < 0) return 0;
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = *p++;
	ret = 0;
	while (exp-- > 0) {
		d *= RADIX;
		if (i-- > 0) d += *p++;
		if (d < 0) {
			ret = MPA_ERR_OVERFLOW_I;
			break;
		}
	}
	if (ret) {
		if (a->sign) d = LONG_MIN;
		else d = LONG_MAX;
	}
	else if (a->sign) d = -d;
	*val = d;
	return ret;
}

/********************************/
/*	m_mpa2i						*/
/********************************/
int m_mpa2i(MPA *a, int *val)
{
	int ret;
	long l=0;

	ret = m_mpa2l(a,&l);
	*val = l;
	return ret;
}

/********************************/
/*	m_mpa2an					*/
/********************************/
int m_mpa2an(MPA *a, char *s, int len_s, int opt)
{
	char *p;
	int lens,exp,len;
	char *pan,c;
/*
m_print("m_mpa2an: ",a,0);
*/
	p = s;
	if (!a || !p) return -1;
	if ((lens=len_s) <= 0) return -1;
	lens--;
	if (a->zero) {
		if (opt&0x01) {
			if (lens > 0) {
				if (lens == 1) *p++ = '0';
				else if (lens >= 2) {
					*p++ = '.';
					*p++ = '0';
				}
			}
		}
		else {
			if (lens-- > 0) *p++ = '0';
			if ((opt&(0x02|0x04)) && lens-- > 0) *p++ = '.';
			if ((opt&0x04) && lens-- > 0) *p++ = '0';
		}
	}
	else {
		if (a->sign && lens-- > 0) *p++ = '-';
		len = a->len;
		pan = a->num;
		if ((exp=a->exp) < 0) {
			if (!(opt&0x01) && lens-- > 0) *p++ = '0';
			if (lens-- > 0) *p++ = '.';
			exp++;
			while (exp++ < 0 && lens-- > 0) *p++ = '0';
			while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
		}
		else {
			while (exp-- >= 0 && lens-- > 0) {
				if (len > 0) {
					c = *pan++ + '0';
					len--;
				}
				else c = '0';
				*p++ = c;
			}
 			if ((len>0||(opt&(0x02|0x04))) && lens-- > 0) *p++ = '.';
			if (len > 0) {
				while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
			}
			else if ((opt&0x04) && lens>0) *p++ = '0';
		}
	}
	*p = '\0';
	return strlen(s);
}

/********************************/
/*	m_i2mpa						*/
/********************************/
int m_i2mpa(int val, MPA *a)
{
	int n, exp, len, w;
	char *p, *q;

	*a = _M0;
	if(!(n=val)) return 0;
	a->zero = 0;
	if (n < 0) {
		a->sign = 1;
		n = -n;
	}
	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX;
		n /= RADIX;
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	m_normalize(a);
	return 0;
}

/********************************/
/*	m_d2mpa						*/
/********************************/
int m_d2mpa(double d, MPA *m)
{
	int i,exp;
	char *p;
	double a;

	a = d;
	*m = _M0;
	if (a == 0.) return 0;
	m->zero = 0;
	if (a < 0.) {
		m->sign = 1;
		a = - a;
	}
	exp = 0;
	while (a >= (double)RADIX) {
		exp++;
		a /= (double)RADIX;
	}
	while (a < 1.) {
		exp--;
		a *= (double)RADIX;
	}
	p = m->num;
	i = 0;
	do {
		*p = (int)a;
		a -= (double)*p++;
		a *= (double)RADIX;
	} while(a != 0. && ++i <= NMPA);
	m->len = i;
	for (i++; i <= NMPA; i++) *p++ = 0;
	m->exp = exp;
	m_normalize(m);
	return 0;
}

/********************************/
/*	m_scale						*/
/********************************/
int m_scale(MPA *mpa,int precision,int scale,int opt)
/* opt=0:ľܓ/1:؎̂/2:؏グ  */
{
	MPA p5;
	int pre_exp,i,sign,len,exp;
	char *p;

	if (!mpa) return -1;
	if (precision<=0 || precision>NMPA) return -2;
#if 1
	if (mpa->zero) {
		mpa->zero = 0;
		mpa->exp = -scale;
		mpa->len = 1;
		mpa->num[0] = 0;
		return 0;
	}
#else
	if (mpa->zero) return 0;
#endif
	if ((opt & 0x03) != 0x01) {
		memcpy(&p5,m_get_i(1),sizeof(MPA));
		p5.sign = mpa->sign;
		if (opt & 0x02) {
			i = mpa->exp + 1 + scale;
			p = mpa->num + i;
			i = mpa->len - i;
			while (i-- > 0) {
				if (*p++) {
					p5.exp = -scale;
					m_add1(mpa,&p5);	/* ؏グ */
					break;
				}
			}
		}
		else {
			p5.exp = -(scale+1);
			p5.num[0] = 5;
			m_add1(mpa,&p5);	/* ľܓ */
		}
		if (mpa->zero)/* return 0;	*/
			return m_scale(mpa,precision,scale,0);
	}
	pre_exp = precision - scale - 1;
	exp = mpa->exp;
	if (exp > pre_exp) {
		sign = mpa->sign;
		memset(mpa,0,sizeof(MPA));
		mpa->exp = pre_exp;
		mpa->sign = sign;
		mpa->len = precision;
		p = mpa->num;
		i = precision;
		while (i--) *p++ = 9;
		return MPA_ERR_OVERFLOW;
	}
	else if ((len=scale+exp+1) <= 0) {
		memcpy(mpa,m_get_i(0),sizeof(MPA));
		return m_scale(mpa,precision,scale,0);
	/*	return 12;	*/
	}
	else {
		i = mpa->len - len;
		if (i > 0) {
			p = mpa->num + len;
		}
		else if (i < 0) {
			p = mpa->num + mpa->len;
			i = -i;
		}
		mpa->len = len;
		while (i-- > 0) *p++ = 0;
	}
	return 0;
}

/********************************/
/*	m_print						*/
/********************************/
void m_print(char *s, MPA *a, int _short)
{
	int i;
	char *p;

	printf("%s\n", s);
	printf("exp =%d\n", a->exp);
	printf("zero=%d\n", a->zero);
	printf("len =%d\n", a->len);
	if(a->sign)	putchar('-');
	else		putchar('+');
	for (i = 0, p = a->num; i <= NMPA; i++) {
		printf("%d ",*p++);
	}
	putchar('\n');
	return;
}

/********************************/
/*	m_ll2mpa					*/
/********************************/
int m_ll2mpa(off_t val, MPA *a)
{
	off_t n;
	int exp, len, w, v[2], v1, v2;
	char *p, *q;

	if (sizeof(off_t) == sizeof(int)) return m_i2mpa(val,a);
	*a = _M0;
	if(!(n=val)) return 0;
	a->zero = 0;
	if (n < 0) {
		a->sign = 1;
		n = -n;
	}
	memcpy(v,&n,sizeof(off_t));
	if (1 == htonl(1)) {
		v1 = v[0];
		v2 = v[1];
	}
	else {
		v1 = v[1];
		v2 = v[0];
	}
	if (!v1) return m_i2mpa(v2,a);
	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX;
		n /= RADIX;
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	m_normalize(a);
	return 0;
}

/********************************/
/*	m_is_mpa0					*/
/********************************/
int m_is_mpa0(MPA *a)
{
	if (!a) return 0;
	return a->zero;
}
