static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*     akxccvn  (rad, ss, len, pnum )                */
/*     akxccvd  (ss, len, pnum)                      */
/*     akxcgcvn ( s, n, pnum )                       */
/*                                                   */
/*****************************************************/
#include "akxcommon.h"
#include <math.h>

static char *sep=" \t\n\r";

/********************************/
/*	akxqsign					*/
/********************************/
int akxqsign(char *s, int len_s, int parm[], char *sep, int opt)
{
	char *p,cc;
	int  sign,nzflag,lens,zero,at,i_sig,nsign,opt2;

	if (!s || !parm) return -1;
	if (!sep) sep = " \t";
	lens = len_s;
	p = s;
	at = zero = nsign = i_sig = 0;
	sign = nzflag = 1;
	opt2 = opt & AKX_CNVN_OPT_COMMA;
	while ((lens-- > 0) && (cc = *p++)) {
		at++;
		if (nzflag == 1) {
			if (cc == '-' || cc == '+') {
				if (cc == '-') sign = -sign;
				nsign++;
				if (nsign >= 2) i_sig = at;
			}
			else if (cc == '0') {
				zero++;
				nzflag = 0;
			}
		/*
			else if (opt2) {
				if (cc==',' && lens>=1 && (cc=*p)>='0' && cc<='9') ;
				else break;
			}
		*/
			else if (!strchr(sep,cc)) break;
		}
		else {
			if (cc != '0') break;
			zero++;
		}
	}
	parm[0] = sign;
	parm[1] = nsign;
	parm[2] = i_sig;
	parm[3] = zero;
	parm[4] = nzflag;
/*
printf("akxqsign: at=%d sign=%d nsign=%d i_sig=%d zero=%d nzflag=%d\n",
at,sign,nsign,i_sig,zero,nzflag);
*/
	return at;
}

static int _cvl(rad,ss,len,pnum,ppos)
int rad,len,*ppos;
char *ss;
long *pnum;
{
	char c,*s;
	long num,num0,radm1,d;
	int i,sig,ret,parm[5];

	if (ppos) *ppos = 0;
	if (pnum) *pnum = 0;
	if (!(s=ss)) return -1;
	if (rad<2 || rad>16) return -2;
#if 0	/* 2018.5.26 */
	i = akxqsign(ss,len,parm,sep,0);
	rc = parm[2];
	if (i>=len && !parm[3]) rc = -1;
	if (rc) return rc;
	s += i;
	sig = parm[0];
#else
	sig = 0;
	for (i=0;i<len;i++) {
		if ((c=*s) == '-') {
			if (sig) break;
			sig = -1;
		}
		else if (c == '+') {
			if (sig) break;
			sig = 1;
		}
		else if (!strchr(sep,c)) break;
		s++;
	}
	if (ppos) *ppos = i;
	if (i>=len) return -1;
#endif
	ret = 0;
	radm1 = rad - 1;
	num0 = num = 0;
	d = -1;
	for (;i<len;i++) {
		c = *s++;
	/*	if (c=='\0' || strchr(sep,c)) break;	*/
		if (c>='0' && c<='9') d = c - '0';
		else d = -1;
		if (rad>10) {
			if (c>='a' && c<='f') d = c - 'a' + 10;
			else if (c>='A' && c<='F') d = c - 'A' + 10;
		}
		if (d<0 || d>radm1) {
			ret = i + 1;
			break;
		}
		if (sig>=0) {
			num = num*rad + d;
			if (num<num0) {
				ret = -3;
				num = LONG_MAX;
				break;
			}
		}
		else {
			num = num*rad - d;
			if (num>num0) {
				ret = -3;
				num = LONG_MIN;
				break;
			}
		}
		num0 = num;
	}
	if (pnum) *pnum = num;
	if (!ret && d<0) ret = -1;
	if (ppos) *ppos = i;
	return ret;
}

int akxccvl(rad,ss,len,pnum)
int rad,len;
char *ss;
long *pnum;
{
	return _cvl(rad,ss,len,pnum,NULL);
}

int akxccvn(rad,ss,len,pnum)
int rad,len;
char *ss;
int *pnum;
{
	return akxccvn2(rad,ss,len,pnum,NULL);
}

int akxccvn2(rad,ss,len,pnum,ppos)
int rad,len;
char *ss;
int *pnum,*ppos;
{
#if defined(_LP64)
	int ret,num;
	long lnum;

	rc = _cvl(rad,ss,len,&lnum,ppos);
	if (lnum > INT_MAX) {
		num = INT_MAX;
		ret = -3;
	}
	else if (lnum <INT_MIN) {
		num = INT_MIN;
		ret = -3;
	}
	else num = lnum;
	if (pnum) *pnum = num;
	return ret;
#else
	return _cvl(rad,ss,len,pnum,ppos);
#endif
}

static int _cvnd(ss,len,dpnum)
char *ss;
int  len;
double *dpnum;
{
	char c,*s;
	int i,d,sig,rc,parm[5];
	double dnum;

	if (dpnum) *dpnum = 0.0;
	if (!(s=ss)) return -1;
#if 0	/* 2018.5.26 */
	i = akxqsign(ss,len,parm,sep,0);
	rc = parm[2];
	if (i>=len && !parm[3]) rc = -1;
	if (rc) return rc;
	s += i;
	sig = parm[0];
#else
	sig = 0;
	for (i=0;i<len;i++) {
		if ((c=*s) == '-') {
			if (sig) break;
			sig = -1;
		}
		else if (c == '+') {
			if (sig) break;
			sig = 1;
		}
		else if (!strchr(sep,c)) break;
		s++;
	}
	if (i>=len) return -1;
#endif
	rc = 0;
	dnum = 0.0;
	d = -1;
	for (;i<len;i++) {
		c = *s++;
	/*	if (c=='\0' || strchr(sep,c)) break;
		else */if (c>='0' && c<='9') d = c - '0';
		else {
			d = -1;
			rc = i + 1;
			break;
		}
		dnum = dnum*10.0 + d;
	}
	if (dpnum) {
		if (sig<0) dnum = -dnum;
		*dpnum = dnum;
	}
	if (!rc && d<0) rc = -1;
	return rc;
}

int akxccvd(ss,len,dpnum)
char *ss;
int  len;
double *dpnum;
{
	int rc,i,n,sig,iexp,nflg,ns;
	double dNum;
	char c,*s;

	if (dpnum) *dpnum = 0.0;
	if (!(s=ss)) return -1;
	i = nflg = sig = ns = 0;
	dNum = 0.0;
	if (*s != '.') {
		rc = _cvnd(s,len,&dNum);
		if (rc < 0) return rc;
		else if (!rc) {
			if (dpnum) *dpnum = dNum;
			return 0;
		}
		if (dNum < 0.0) {
			sig = -1;
			dNum = -dNum;
		}
		s += --rc;
		i = rc;
		nflg = 1;
	}
	rc = 0;
	if (*s == '.') {
		for (++i,++s;i<len;i++,s++) {
			if ((c=(*s - '0'))<0 || c>9) break;
			dNum = dNum*10.0 + c;
			ns++;
			nflg = 1;
		}
	}
	if (!nflg) return -1;
	iexp = 0;
	if (i < len) {
		if ((c=akxcupper(*s++))=='E' || c=='D') {
			i++;
			if (c=='D' && (i>=len || (i<len && strchr(sep,*s)))) ;
			else {
				if ((rc = akxccvn(10,s,len-i,&iexp)) < 0) rc -= 10*i;
				else if (rc > 0) rc += i;
			}
		}
		else {
			if (c=='F') {
				if (i+1 < len) c = akxcupper(*s);
				else c = '\0';
			}
			if (c=='\0' || strchr(sep,c)) ;
			else rc = i + 1;
		}
	}
	if (dNum) {
		if (iexp -= ns) dNum *= pow(10.0,(double)iexp);
		if (sig) dNum = -dNum;
	}
	if (dpnum) *dpnum = dNum;
	return rc;
}

int akxcgcvl(wd0,len0,pnum)
char *wd0;
int len0;
int *pnum;
{
	int n31w=0,rc,i,len,len1,len2,s,skip,iLONG;
	char ch,*wd,*wd1,*wd2;
	long lnum;

	rc = s = 0;
	iLONG = 1;
	wd  = wd0;
	len = len0;
	skip = akxnskipin(wd,len," \t");
	wd += skip;
	len = akxnrskipin(wd,len-skip,sep);
	if (len<=0) rc = -1;
	else if (len >= 3) {
		wd1  = wd;
		len1 = len;
		if ((ch = *wd1)=='+' || ch=='-') {
			if (ch == '-') s = -1;
			len1--;
			wd1++;
		}
		if (*wd1 == '0') {
			iLONG = 0;
			wd2  = wd1  + 2;
			len2 = len1 - 2;
			skip += 2;
			switch (wd1[1]) {
				case 'D':
				case 'd':
					rc = akxccvn(10,wd2,len2,&n31w);
					break;
				case 'X':
				case 'x':
					rc = akxccvx(wd2,len2,&n31w);
					break;
				case 'B':
				case 'b':
					rc = akxccvb(wd2,len2,&n31w);
					break;
				case 'O':
				case 'o':
					rc = akxccvo(wd2,len2,&n31w);
					break;
				default:
					skip -= 2;
					s = 0;
					iLONG = 1;
			}
			if (rc == -3) {
				if (s) n31w = INT_MIN;
				else n31w = INT_MAX;
			}
			else if (s) n31w = -n31w;
			lnum = n31w;
		}
	}
	if (iLONG) {
		rc = akxccvl(10,wd,len,&lnum);
	}
	if (pnum) memcpy(pnum,&lnum,sizeof(long));
	if (rc > 0) rc += skip;
	return rc;
}

int akxcgcvn(wd0,len0,pnum)
char *wd0;
int len0;
int *pnum;
{
#if defined(_LP64)
	int rc,num;
	long lnum;

	rc = akxcgcvl(wd0,len0,&lnum);
	if (lnum > INT_MAX) {
		num = INT_MAX;
		rc = -3;
	}
	else if (lnum <INT_MIN) {
		num = INT_MIN;
		rc = -3;
	}
	else num = lnum;
	if (pnum) *pnum = num;
	return rc;
#else
	return akxcgcvl(wd0,len0,pnum);
#endif
}

int akxccvx(wd0,len0,pnum)
char *wd0;
int len0;
uint *pnum;
{
	int rc,i,len;
	uint uVal, n;
	char c,*wd;

	wd  = wd0;
	len = len0;
	uVal = rc = 0;
	if (len <= 0) return -1;
	for (i=0;i<len;i++,wd++) {
		if (uVal & 0xf0000000) {
			rc = -3;
			break;
		}
		if ((c = *wd)>='0' && c<='9') n = c - '0';
		else if (c>='a' && c<='f') n = c - 'a' + 10;
		else if (c>='A' && c<='F') n = c - 'A' + 10;
		else {
			rc = i + 1;
			break;
		}
		uVal <<= 4;
		uVal |= n;
	}
	*pnum = uVal;

	return rc;
}

int akxccvo(wd0,len0,pnum)
char *wd0;
int len0;
uint *pnum;
{
	int rc,i,len;
	uint uVal,n;
	char *wd;

	wd  = wd0;
	len = len0;
	uVal = rc = 0;
	if (len <= 0) return -1;
	for (i=0;i<len;i++,wd++) {
		if (uVal & 0xa0000000) {
			rc = -3;
			break;
		}
		n = *wd - '0';
		if (n>=0 && n<=7) {
			uVal <<= 3;
			uVal |= n;
		}
		else {
			rc = i + 1;
			break;
		}
	}
	*pnum = uVal;

	return rc;
}

int akxccvb(wd0,len0,pnum)
char *wd0;
int len0;
uint *pnum;
{
	int rc,i,len;
	uint uVal,n;
	char *wd;

	wd  = wd0;
	len = len0;
	uVal = rc = 0;
	if (len <= 0) return -1;
	for (i=0;i<len;i++,wd++) {
		if (uVal & 0x80000000) {
			rc = -3;
			break;
		}
		n = *wd - '0';
		if (!n) {
			uVal <<= 1;
		}
		else if (n == 1) {
			uVal <<= 1;
			uVal |= 1;
		}
		else {
			rc = i + 1;
			break;
		}
	}
	*pnum = uVal;

	return rc;
}

/********************************************************************/
/*  @\ : int̒l𕶎ɕϊ								*/
/*   : IN : value   : T[`Ώە|C^z				*/
/*				str     : o͂GAւ̃|C^		*/
/*				radix   : i (2,8,10,16)							*/
/*				str_len : str̒(oCg)							*/
/*						  ENULLI[܂߂		*/
/*						  EȂƂ́AtāA	*/
/*						  @ʂ							*/
/*						  <0 ̂Ƃ́A`FbNȂ				*/
/*  ԋp : = -1 : str == NULL										*/
/*		   = -2 : radix s										*/
/*		   >= 0 :  (oCg)									*/
/********************************************************************/
int akxcitoa(value,str,radix,str_len)
int value;
char *str;
int radix,str_len;
{
	int i,sign,m;
	char *p,c;

	if (!(p=str)) return -1;
	if (!(radix==2 || radix==8 || radix==10 || radix==16)) return -2;

	if (str_len > 0) str_len--;

	if ((sign = value) < 0) {
		value = -value;
		if (str_len > 0) str_len--;
	}
	i = 0;
	do {
		if (str_len >= 0) {
			if (i >= str_len) break;
		}
		i++;
		m = value % radix;
		c = m + '0';
		if (radix==16 && m>=10) c = m - 10 + 'a';
		*p++ = c;
	} while ((value /= radix) > 0);

	if (sign < 0) {
		*p++ = '-';
		i++;
	}
	*p = '\0';

	return akxtreverse(str,i);
}

int akxtreverse(str,len)
char *str;
int len;
{
	int c,i,j;

	for (i=0,j=len-1;i<j;i++,j--) {
		c = str[i];
		str[i] = str[j];
		str[j] = c;
	}
	return len;
}
