static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F                                                 *
*                                                                             *
*      ֐@@@F@int cl_gx_rep_set( pparmList , ppmList )               *
*                      (O)parmList  *pparmList                                *
*                      (I)prmList  *pprmList                                  *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern int giOptions[];
/* extern CLPRTBL CLprocTable;	*/
extern GlobalCt  *pGlobTable;

static int _list_info_set();
static int _array_hash_clr();
static int _list_array_set();

/****************************************/
/*										*/
/****************************************/
int cl_gx_rep_set(pparmList ,pInfoParm)
parmList  *pparmList;
tdtInfoParm *pInfoParm;
{
	int		rc;
	ScrPrCT *pSPCT;
	tdtInfoParm *pInfoParmW;

	pSPCT = cl_search_src_ct();

	if (rc= cl_gx_get_info_parm(pSPCT,'s',pparmList,&pInfoParmW)) {
		return rc;
	}

	return cl_gx_rep_info_set(pInfoParmW ,pInfoParm ,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_rep_set_global( pparmList ,pInfoParm )
parmList  *pparmList;
tdtInfoParm *pInfoParm;
{
	/* %s: %sɂ͑ł܂B */
	ERROROUT2(FORMAT(126),"cl_gx_rep_set_global",pparmList->prp);
	return ECL_SCRIPT_ERROR;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info(nparm,ppParm,pIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtInfoParm *pInfoParm;
	int iRc,ix0,*index;
	XHASHB *xhp;

	pInfoParm = ppParm[0];
	if (opt & 0x02) {
		if (iRc = cl_check_use_mapped_array(pInfoParm)) return iRc;
	}
	if (iRc = cl_get_array_info(pInfoParm,pIndex,ppTBL,iParm)) return iRc;
	if ((opt & 0x01) && pIndex->xhp) {
		return 2000;
	}
	if (iRc = cl_check_use_hash_array(pInfoParm,pIndex)) return iRc;

	ix0 = 0;
	if (nparm >= 2) {
		pInfoParm = ppParm[1];
		if (pInfoParm->pi_dlen>0) {
			if (iRc = cl_get_parm_bin(pInfoParm,&ix0,"_get_array_info.ix0:")) return iRc;
			if (ix0 < 0) {
				ERROROUT1(FORMAT(222),ix0);	/* Jnʒu(%d)słB */
				return -1;
			}
		}
	}
	iParm[0] = ix0;
	iParm[1] -= ix0;
	iParm[2] += ix0;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _get_array_num(nparm,ppParm,nm1,pNum)
int  nparm;
tdtInfoParm *ppParm[];
int nm1,*pNum;
{
	tdtInfoParm *pInfoParm;
	int nm,iRc;

	nm = *pNum;
/*
printf("_get_array_num: nparm=%d nm1=%d nm=%d\n",nparm,nm1,nm);
*/
	if (nparm >= 1) {
		pInfoParm = ppParm[0];
		if (pInfoParm->pi_dlen>0) {
			if (iRc = cl_get_parm_bin(pInfoParm,&nm,"_get_array_num:")) return iRc;
			if (nm < 0) {
				ERROROUT1(FORMAT(223),nm);	/* (%d)słB */
				return -1;
			}
			else if (nm1>0 && nm>nm1) {
				/* f[^(%d)ž(%d)𒴂Ă܂B܂B */
				ERROROUT2(FORMAT(224),nm,nm1);
				nm = nm1;
			}
		}
	}
	*pNum = nm;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_array(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix0,ix,nm,count,len;
	char c,*name,*p1;
	tdtArrayIndex tIndex;
	int *index,iParm[3];

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	nm = nparm - 2;
	iRc = _get_array_info(nparm,ppParm,&tIndex,&pTBL,iParm,3);
	if (iRc == 2000) {
		if (iRc=_array_hash_clr(ppParm[0]->pi_data)) return iRc;
		for (i=count=0;i<nm;i+=2) {
			if ((len=parm_to_char_tmp(ppParm[i+2],&p1,0)) < 0) return len;
			else if (len > 0) {
				if (i+1<nm && !cl_is_null_parm(pInfoParm=ppParm[i+3])) {
					if (!(pInfoParmW=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
					memset(pInfoParmW,0,sizeof(tdtInfoParm));
					if (iRc = cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
					ix = akxs_xhash2(tIndex.xhp,'s',p1,&pInfoParmW);
					if (ix <= 0) {
						if (ix == 0) ix = -12;
						return ix;
					}
					count++;
				}
			}
		}
		memcpy(pWork,&count,sizeof(int));
		return 0;
	}
	else if (iRc) return iRc;
/*
printf("cl_set_array: nm=%d iParm=%d %d %d\n",nm,iParm[0],iParm[2],iParm[2]);
*/
	ix0 = iParm[0];
	ix  = iParm[2];
	if (nm > iParm[1]) {
		/* f[^(%d)ž(%d)𒴂Ă܂B܂B */
		ERROROUT2(FORMAT(224),nm,iParm[1]);
		nm = iParm[1];
	}

	for (i=count=0;i<nm;i++,ix++) {
		pInfoParm = ppParm[i+2];
		if (!cl_is_null_parm(pInfoParm)) {
			pInfoParmW = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
			if (pInfoParmW) {
				if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
			}
			else {
				return -1;
			}
			count++;
		}
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _list_copy_info(pCt,pCtI)
tdtRbCtl *pCt,*pCtI;
{
	tdtInfoParm *p,*pInfoParm;
	int rc=0;

	if (!pCt || !pCtI) return -1;
	if (pCt == pCtI) return 0;
	akxs_rb_read(pCtI,0);
	while (p=(tdtInfoParm *)akxs_rb_read(pCtI,1)) {
DEBUGOUT_InfoParm(198,"_list_copy_info: ",p,0,0);
		if (!(pInfoParm=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return ECL_MALLOC_ERROR;
		rc = _list_info_set(pInfoParm,p);
		if (!cl_tmp_rbset_n(pCt,pInfoParm)) return ECL_MALLOC_ERROR;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _list_copy(pInfoParmO,pInfoParmI)
tdtInfoParm *pInfoParmO,*pInfoParmI;
{
	int rc;
	tdtRbCtl *pCt,*pCtI;

	if (!pInfoParmO || !pInfoParmI) return -1;
	if (pInfoParmO == pInfoParmI) return 0;
	if (!(pCt = cl_tmp_rb_new(0,0))) return ECL_MALLOC_ERROR;
	pInfoParmO->pi_data = (char *)pCt;
	pCtI = (tdtRbCtl *)pInfoParmI->pi_data;
	rc = _list_copy_info(pCt,pCtI);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _list_info_set(pInfoParmO ,pInfoParmI)
tdtInfoParm  *pInfoParmO, *pInfoParmI;
{
	int rc;
	char c;

	if (!pInfoParmO || !pInfoParmI) return -1;
	if (pInfoParmO == pInfoParmI) return 0;
	*pInfoParmO = *pInfoParmI;
DEBUGOUT_InfoParm(198,"_list_info_set: ",pInfoParmI,0,0);
	if ((c=pInfoParmO->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) {
		if ((rc=_list_copy(pInfoParmO,pInfoParmI)) < 0) return rc;
	}
	else {
#if 1
		if (rc=cl_gx_rep_info_copy_data(pInfoParmO,pInfoParmI,1 | D_GX_OPT_ALC_TMP)) return rc;
#else
		if (pInfoParmO->pi_scale & D_DATA_LPOSDATA)
			pInfoParmO->pi_data = (char *)&pInfoParmO->pi_pos;
		else {
			pInfoParmO->pi_scale &= ~D_DATA_MALLOC;
			if (pInfoParmI->pi_dlen > 0) {
				if (!(pInfoParmO->pi_data=cl_tmp_const_malloc(pInfoParmI->pi_dlen+1))) {
					return ECL_MALLOC_ERROR;
				}
				memzcpy(pInfoParmO->pi_data,pInfoParmI->pi_data,pInfoParmI->pi_dlen);
			}
		}
#endif
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2, *p;
	int i,rc,opt1;
	tdtRbCtl *pCt;

	opt1 = pGlobTable->options[4] & 0x01;
	cl_null_data(pInfoParmW);
	if (nparm > 0 || opt1) {
		pInfoParmW->pi_id   = D_DATA_ID_LIST;
		pInfoParmW->pi_attr = DEF_ZOK_BULK;
		pInfoParmW->pi_dlen  = sizeof(tdtRbCtl);
		if (!(pCt = cl_tmp_rb_new(0,0))) return ECL_MALLOC_ERROR;
		pInfoParmW->pi_data = (char *)pCt;
	}
	for (i=0;i<nparm;i++) {
		p = ppParm[i];
DEBUGOUT_InfoParm(197,"cl_set_list:s: i=%d",p,i,0);
		if (p->pi_aux[0] & DEF_ZOK_DATA) {
			if ((rc=_list_array_set(pCt,p)) < 0) return rc;
		}
#if 1	/* 2019.5.16 */
		else {
#else
		else if (!cl_is_null_parm(p)) {
#endif
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((rc=_list_info_set(pInfoParm1,p)) < 0) return rc;
DEBUGOUT_InfoParm(198,"cl_set_list:d: i=%d",pInfoParm1,i,0);
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
tdtRbCtl *cl_tmp_rb_new(lBS,lRM)
long lBS,lRM;
{
	tdtRbCtl *pCt;
	tdtRbChain *p1,*p2;

	if (!(pCt = (tdtRbCtl *)cl_tmp_const_malloc(sizeof(tdtRbCtl)))) return NULL;
	memset(pCt,0,sizeof(tdtRbCtl));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	if (!(p1 = (tdtRbChain *)cl_tmp_const_malloc(sizeof(tdtRbChain)))) {
		return NULL;
	}
	pCt->rb_cur = pCt->rb_waddr = pCt->rb_raddr = p1;
	p1->rbc_buf = NULL;
	if (!(p2 = (tdtRbChain *)cl_tmp_const_malloc(sizeof(tdtRbChain)))) {
		return NULL;
	}
	pCt->rb_wpriv = p2;
	p2->rbc_buf = NULL;
	p1->rbc_next = p2;
	p2->rbc_next = p1;
	pCt->rb_num = 2;
	return pCt;
}

/****************************************/
/*										*/
/****************************************/
char *cl_tmp_rbset_n(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn, *pp;

	if (!pCt || !addr) return NULL;
	
	pw = pCt->rb_waddr;
	if (pw->rbc_buf) {
		if (!(pn = (tdtRbChain *)cl_tmp_const_malloc(sizeof(tdtRbChain)))) return NULL;
		pp = pCt->rb_wpriv;
		pCt->rb_waddr = pp->rbc_next = pn;
		pn->rbc_next = pw;
		pw = pCt->rb_waddr;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	pCt->rb_waddr = pw->rbc_next;
	pCt->rb_wpriv = pw;
	pCt->rb_used++;
	return addr;
}

/****************************************/
/*										*/
/****************************************/
int cl_cons_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2, *p;
	int i,rc,opt1;
	tdtRbCtl *pCt;
	char c;

	opt1 = pGlobTable->options[4] & 0x01;
	cl_null_data(pInfoParmW);
	if (nparm > 0 || opt1) {
		pInfoParmW->pi_id   = D_DATA_ID_LIST;
		pInfoParmW->pi_attr = DEF_ZOK_BULK;
		pInfoParmW->pi_dlen  = sizeof(tdtRbCtl);
		if (!(pCt = cl_tmp_rb_new(0,0))) return ECL_MALLOC_ERROR;
		pInfoParmW->pi_data = (char *)pCt;
		if (nparm > 0) {
			if (ppParm[0]->pi_id==D_DATA_ID_NARABI)
				pInfoParmW->pi_id = D_DATA_ID_NARABI;
		}
	}
	for (i=0;i<nparm;i++) {
		p = ppParm[i];
		if ((c=p->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) {
			if ((rc=_list_copy_info(pCt,p->pi_data)) < 0) return rc;
		}
		else if (p->pi_aux[0] & DEF_ZOK_DATA) {
			if ((rc=_list_array_set(pCt,p)) < 0) return rc;
		}
		else if (!cl_is_null_parm(p)) {
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((rc=_list_info_set(pInfoParm1,p)) < 0) return rc;
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,len;
	char w1[32],*p1;
	tdtInfoParm **pp;

	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	ret = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) {
		ERROROUT(FORMAT(225));	/* w肪słB */
		return len;
	}
	nparm--;
	pp = &ppParm[1];
	if (!stricmp(p1,"LIST")||!stricmp(p1,"APPEND"))
		ret = cl_set_list(pInfoParmW,nparm,pp);
	else if (!stricmp(p1,"FIRST")) ret = cl_ope_list(pInfoParmW,nparm,pp,D_FUC_FIRST,NULL,0);
	else if (!stricmp(p1,"REST")) ret = cl_ope_list(pInfoParmW,nparm,pp,D_FUC_REST,NULL,0);
	else if (!stricmp(p1,"CONS")) ret = cl_cons_list(pInfoParmW,nparm,pp);
	else if (!stricmp(p1,"LIST_REF")) ret = cl_ope_list(pInfoParmW,nparm,pp,D_FUC_LIST_REF,NULL,0);
	else {
		ERROROUT1(FORMAT(226),p1);	/* w(%s)słB */
		ret = ECL_SCRIPT_ERROR;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ope_list(pInfoParmW,nparm,ppParm,ope,pdummy,dummy)
tdtInfoParm *pInfoParmW;
int  nparm,ope,dummy;
tdtInfoParm *ppParm[];
char *pdummy;
{
	tdtInfoParm *pInfoParm,*p,tInfoParm;
	int rc,n,opt1,i,m;
	tdtRbCtl *pCt;

	rc = 0;
	cl_null_data(pInfoParmW);
	pInfoParm = ppParm[0];
	if (cl_is_null_parm(pInfoParm) || cl_is_null_data(pInfoParm)) return 0;
	if (pInfoParm->pi_id!=D_DATA_ID_LIST) {
		ERROROUT(FORMAT(227));	/* Xgł͂܂B */
		return ECL_SCRIPT_ERROR;
	}
	if (ope == D_FUC_FIRST) {
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if (p = (tdtInfoParm *)akxs_rb_get(pCt)) {
			if (p->pi_id==D_DATA_ID_LIST)
				rc = _list_info_set(pInfoParmW,p);
			else
				cl_gx_copy_info(pInfoParmW,p);
		}
	}
	else if (ope == D_FUC_REST) {
		rc = _list_info_set(pInfoParmW,pInfoParm);
		opt1 = pGlobTable->options[4] & 0x01;
		n = akxs_rb_used(pCt=(tdtRbCtl *)pInfoParmW->pi_data);
		if (n>1 || opt1) {
			if (nparm > 1) {
				if ((rc=cl_get_parm_bin(ppParm[1],&m,"cl_ope_list REST:"))<0) return rc;
				rc = 0;
				m = X_MIN(n,m);
				for (i=0;i<m;i++) if (!akxs_rb_get_n(pCt)) break;
			}
			else akxs_rb_get_n(pCt);
		}
		else cl_null_data(pInfoParmW);
	}
	else if (ope == D_FUC_LIST_REF) {
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if ((n=akxs_rb_used(pCt)) <= 0) return 0;
		if (nparm > 1) {
			if ((rc=cl_get_parm_bin(ppParm[1],&m,"cl_ope_list REF:"))<0) return rc;
		}
		else m = 0;
		rc = 0;
		if (m < 0) {
			ERROROUT1(FORMAT(228),m);	/* Qƈʒu(%d)słB */
			return ECL_SCRIPT_ERROR;
		}
		if (m < n) {
			akxs_rb_read(pCt,0);
			for (i=0;i<=m;i++) if (!(p=(tdtInfoParm *)akxs_rb_read(pCt,1))) break;
			if (p) {
				if (p->pi_id==D_DATA_ID_LIST)
					rc = _list_info_set(pInfoParmW,p);
				else
					cl_gx_copy_info(pInfoParmW,p);
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_index(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int i,n,ix;
	tdtInfoParm *ppm[5];

	ppm[0] = ppParm[0];
	n = X_MIN(nparm,4);
	for (i=1;i<n;i++) ppm[i+1] = ppParm[i];
	ix = cl_gx_array_bexp(NULL,nparm+1,ppm,0);
	if (ix >= 0) ix--;
	memcpy(pWork,&ix,sizeof(int));
	if (ix > 0) ix = 0;
	return ix;
}

/****************************************/
/*										*/
/****************************************/
static int _array_cpy(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,rInfoParm;
	tdtInfoParm ***pTBL1,***pTBL2;
	int iRc,n,i,ix1,ix2,nm,nm1,nm2,count;
	tdtArrayIndex tIndex1,tIndex2,*pIndex;
	int *index1,*index2,iParm[3];
	char c,*name,*cpKey,*cpDat;
	XHASHB *xhpI,*xhpO;

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	if (iRc = _get_array_info(nparm,ppParm,&tIndex1,&pTBL1,iParm,3)) {
		if (iRc == 2000) xhpO = tIndex1.xhp;
		else return iRc;
	}
	else xhpO = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];

	if (iRc = _get_array_info(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhpI = tIndex2.xhp;
		else return iRc;
	}
	else xhpI = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];

	if (!((xhpO && xhpI)||(!xhpO && !xhpI))) {
		/* array_to Azzł͂܂B */
		if (!xhpO) ERROROUT1(FORMAT(229),"_array_cpy: array_to");
		/* array_from Azzł͂܂B */
		else if (!xhpI) ERROROUT1(FORMAT(229),"_array_cpy: array_from");
		return -1;
	}

	if (nm2 < nm1) nm1 = nm2;
	nm = nm1;
	if (iRc = _get_array_num(nparm-4,&ppParm[4],nm1,&nm)) return iRc;

	if (xhpO) {
		if (iRc=_array_hash_clr(pIndex=(tdtArrayIndex *)ppParm[0]->pi_data)) return iRc;
		xhpO = pIndex->xhp;
	}

	for (count=0,i=1;;i++) {
		if (xhpI) {
			if (i>nm1 || count>=nm) break;
			xhpI->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhpI,'P',&cpKey,&cpDat)) > 0) {
				memcpy(&pInfoParm,cpDat,sizeof(tdtInfoParm *));
				if (!(pInfoParmW=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
				memset(pInfoParmW,0,sizeof(tdtInfoParm));
				ix1 = akxs_xhash2(xhpO,'s',cpKey,&pInfoParmW);
				if (ix1 <= 0) {
					if (ix1 == 0) ix1 = -12;
					return ix1;
				}
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			if (i > nm) break;
			pInfoParmW = cl_get_array_and_var_ent(&tIndex1,pTBL1,ix1);
			pInfoParm  = cl_get_array_and_var_ent(&tIndex2,pTBL2,ix2);
			ix1++;
			ix2++;
		}
		if (pInfoParmW && pInfoParm) {
			if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
		count++;
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_hash_clr(pIndex)
tdtArrayIndex *pIndex;
{
	int iRc,lMaxReg,lDatLen;
	XHASHB *xhp;

	if ((iRc=akxs_xhash2(xhp=pIndex->xhp,'u',NULL,NULL)) > 0) {
		lMaxReg = xhp->xha_maxreg;
		lDatLen = xhp->xha_datlen;
		akxs_xhash_free(xhp);
		if (!(pIndex->xhp = akxs_xhash_new2(0,lMaxReg,0,lDatLen))) return -9;
		iRc = 0;
	}
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
static int _array_clr(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,rInfoParm;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix,nm,nm1,count;
	char c,*name;
	tdtArrayIndex tIndex,*pIndex;
	int *index,iParm[3];

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	if (iRc = _get_array_info(nparm,ppParm,&tIndex,&pTBL,iParm,3)) {
		if (iRc == 2000) iRc = _array_hash_clr(ppParm[0]->pi_data);
		return iRc;
	}
	nm1 = iParm[1];
	ix  = iParm[2];

	nm = nm1;
	if (iRc = _get_array_num(nparm-3,&ppParm[3],nm1,&nm)) return iRc;

	if (nparm >= 3) {
		pInfoParm = ppParm[2];
	}
	else {
		pInfoParm = &rInfoParm;
		cl_null_parm(pInfoParm);
	}
	for (i=count=0;i<nm;i++,ix++) {
		pInfoParmW = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		if (pInfoParmW) {
			if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
		count++;
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_cmp(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2;
	tdtInfoParm ***pTBL1,***pTBL2;
	int iRc,n,i,ix1,ix2,nm,nm1,nm2,len,iAns,iParm[3],count,match;
	tdtArrayIndex tIndex1,tIndex2;
	char *p1;
	char *cpKey,*cpDat;
	XHASHB *xhp1,*xhp2;

	iAns = 0;
	memcpy(pWork,&iAns,sizeof(int));

	if (iRc = _get_array_info(nparm,ppParm,&tIndex1,&pTBL1,iParm,1)) {
		if (iRc == 2000) xhp1 = tIndex1.xhp;
		else return iRc;
	}
	else xhp1 = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];

	if (iRc = _get_array_info(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhp2 = tIndex2.xhp;
		else return iRc;
	}
	else xhp2 = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];

	if (!((xhp1 && xhp2)||(!xhp1 && !xhp2))) {
		/* array1 Azzł͂܂B */
		if (!xhp1) ERROROUT1(FORMAT(229),"_array_cmp: array1");
		/* array2 Azzł͂܂B */
		else if (!xhp2) ERROROUT1(FORMAT(229),"_array_cmp: array2");
		return -1;
	}

	if (nm2 < nm1) nm1 = nm2;
	nm = nm1;
	if (iRc = _get_array_num(nparm-4,&ppParm[4],nm1,&nm)) return iRc;

	p1 = "==";
	if (nparm >= 6) {
		pInfoParm1 = ppParm[5];
		if (iRc=cl_check_attr(pInfoParm1,DEF_ZOK_CHAR,"_array_cmp.cmp")) return iRc;
		if (pInfoParm1->pi_dlen > 0) p1 = pInfoParm1->pi_data;
	}
	count=match=0;
	for (i=1;;i++) {
		if (xhp1) {
			if (i>nm1 || count>=nm) break;
			xhp1->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhp1,'P',&cpKey,&cpDat)) > 0) {
				memcpy(&pInfoParm1,cpDat,sizeof(tdtInfoParm *));
				if ((iRc=akxs_xhash2(xhp2,'R',cpKey,&cpDat)) > 0) {
					memcpy(&pInfoParm2,cpDat,sizeof(tdtInfoParm *));
				}
				else if (iRc < 0) return iRc;
				else continue;
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			if (i > nm) break;
			pInfoParm1 = cl_get_array_and_var_ent(&tIndex1,pTBL1,ix1);
			pInfoParm2 = cl_get_array_and_var_ent(&tIndex2,pTBL2,ix2);
			ix1++;
			ix2++;
		}
		if (pInfoParm1 && pInfoParm2) {
			count++;
			if ((iRc=cl_cmpt_comp(&iAns,p1,pInfoParm1,pInfoParm2,0,NULL)) < 0) iAns = 0;
			if (!iAns) break;
			match++;
		}
		else {
			return -1;
		}
	}
	memcpy(pWork,&match,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_bxp(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParmW,*pInfoParm2,tInfoParm;
	tdtInfoParm ***pTBL1,***pTBL2,***pTBL3;
	int iRc,n,i,ix1,ix2,ix3,nm,nm1,nm2,nm3,len,count,iParm[3];
	tdtArrayIndex tIndex1,tIndex2,tIndex3,*pIndex;
	XHASHB *xhp1,*xhp2,*xhp3;
	char *p1,*cpKey,*cpDat;

	count = 0;
	memcpy(pWork,&count,sizeof(int));

	if (iRc = _get_array_info(nparm,ppParm,&tIndex1,&pTBL1,iParm,3)) {
		if (iRc == 2000) xhp1 = tIndex1.xhp;
		else return iRc;
	}
	else xhp1 = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];

	if (iRc = _get_array_info(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhp2 = tIndex2.xhp;
		else return iRc;
	}
	else xhp2 = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];

	if (iRc = _get_array_info(nparm-4,&ppParm[4],&tIndex3,&pTBL3,iParm,1)) {
		if (iRc == 2000) xhp3 = tIndex3.xhp;
		else return iRc;
	}
	else xhp3 = NULL;
	nm3  = iParm[1];
	ix3  = iParm[2];

	if (!((xhp1 && xhp2 && xhp3)||(!xhp1 && !xhp2 && !xhp3))) {
		/* array_to Azzł͂܂B */
		if (!xhp1) ERROROUT1(FORMAT(229),"_array_bxp: array_to");
		/* array_1 Azzł͂܂B */
		if (!xhp2) ERROROUT1(FORMAT(229),"_array_bxp: array_1");
		/* array_2 Azzł͂܂B */
		if (!xhp3) ERROROUT1(FORMAT(229),"_array_bxp: array_2");
		return -1;
	}

	if (nm2 < nm1) nm1 = nm2;
	if (nm3 < nm1) nm1 = nm3;
	nm = nm1;
	if (iRc = _get_array_num(nparm-6,&ppParm[6],nm1,&nm)) return iRc;

	p1 = "+";
	if (nparm >= 8) {
		pInfoParmW = ppParm[7];
		if (iRc=cl_check_attr(pInfoParmW,DEF_ZOK_CHAR,"_array_bxp.bxp")) return iRc;
		if (pInfoParmW->pi_dlen > 0) p1 = pInfoParmW->pi_data;
	}

	if (xhp1) {
		if (iRc=_array_hash_clr(pIndex=(tdtArrayIndex *)ppParm[0]->pi_data)) return iRc;
		xhp1 = pIndex->xhp;
	}

	for (count=0,i=1;;i++) {
		if (xhp2) {
			if (i>nm1 || count>=nm) break;
			xhp2->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhp2,'P',&cpKey,&cpDat)) > 0) {
				memcpy(&pInfoParm1,cpDat,sizeof(tdtInfoParm *));
				if ((iRc=akxs_xhash2(xhp3,'R',cpKey,&cpDat)) > 0) {
					memcpy(&pInfoParm2,cpDat,sizeof(tdtInfoParm *));
				}
				else if (iRc < 0) return iRc;
				else continue;
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			if (i > nm) break;
			pInfoParmW = cl_get_array_and_var_ent(&tIndex1,pTBL1,ix1);
			pInfoParm1 = cl_get_array_and_var_ent(&tIndex2,pTBL2,ix2);
			pInfoParm2 = cl_get_array_and_var_ent(&tIndex3,pTBL3,ix3);
			ix1++;
			ix2++;
			ix3++;
		}
		if (pInfoParm1 && pInfoParm2) {
			if (iRc=cl_gx_bexp(&tInfoParm,pInfoParm1,p1,pInfoParm2,0,0)) return iRc;
			if (xhp2) {
				if (!(pInfoParmW=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
				memset(pInfoParmW,0,sizeof(tdtInfoParm));
				ix1 = akxs_xhash2(xhp1,'s',cpKey,&pInfoParmW);
				if (ix1 <= 0) {
					if (ix1 == 0) ix1 = -12;
					return ix1;
				}
			}
			else {
				if (!pInfoParmW) return -1;
				if (iRc=cl_gx_rep_info_set(pInfoParmW,&tInfoParm,1)) return iRc;
			}
			count++;
		}
		else {
			return -1;
		}
	}
	memcpy(pWork,&count,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_ope(pWork,nparm,ppParm,ope)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
int  ope;
{
	int ret;

	if      (ope == D_FUC_ARRAY_CPY) ret = _array_cpy(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_CLR) ret = _array_clr(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_CMP) ret = _array_cmp(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_BXP) ret = _array_bxp(pWork,nparm,ppParm);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static int _list_array_set(pCt,pInfoParmI)
tdtRbCtl *pCt;
tdtInfoParm *pInfoParmI;
{
	tdtInfoParm *pInfoParm1,*pInfoParm;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix,nm,len,iAns,iParm[3],count,match;
	tdtArrayIndex tIndex;
	char *p1;
	char *cpKey,*cpDat;
	XHASHB *xhp;

	if (iRc = _get_array_info(1,&pInfoParmI,&tIndex,&pTBL,iParm,3)) {
		if (iRc == 2000) xhp = tIndex.xhp;
		return iRc;
	}
	else xhp = NULL;
	nm = iParm[1];
	ix = iParm[2];

	for (i=1;i<=nm;i++,ix++) {
		if (xhp) {
			xhp->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhp,'P',&cpKey,&cpDat)) > 0) {
				memcpy(&pInfoParm,cpDat,sizeof(tdtInfoParm *));
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			pInfoParm = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		}
		if (pInfoParm) {
			if (cl_is_undef_parm(pInfoParm) || cl_is_null_parm(pInfoParm)) continue;
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((iRc=_list_info_set(pInfoParm1,pInfoParm)) < 0) return iRc;
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
		else {
			return -1;
		}
	}

	return iRc;
}
