static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************************/
/* <cldPath.c>                                         */
/*      exec command  process                          */
/*******************************************************/
#include "colmn.h"

#undef DEBUG

extern condList  CLcList;		/* 񃊃Xg */
extern CLNCB     CLSTCB;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable;

/**************************************************************/
/* cl_process_msg_pre_send                                    */
/**************************************************************/
int cl_process_msg_pre_send(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc = 0, cmd;

	if (leaf) {
		cmd = leaf->cmd.cid;
		proc->Curleaf = leaf;
		cl_ret_leaf_push(proc,leaf);
		if (cmd == C_SQL)
			rc = cl_process_sqlsnd(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		else if (cmd == C_SLEEP)
			rc = cl_process_sleep_snd(leaf->cmd.prmnum,leaf->cmd.prmp,proc);
		else if (cmd == C_MSG)
			rc = cl_process_messag_send(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		if (rc) {
			pGlobTable->error = rc;
			if (!pGlobTable->exception)
				pGlobTable->exception = cl_mk_exception_code(COMM_EXCEPTION,rc);
			pGlobTable->tuppl = 0;
		}
		else {
			cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_ON);
			cmn_set_stat(RTN_PR,&proc->ptype,L_ON);
		}
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_msg_pre_return                                  */
/**************************************************************/
int cl_process_msg_pre_return(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	ScrPrCT *scrprct;
	ProcCT  *procct;
	int rc, cmd;

	if (leaf) {
		procct = cl_search_proc_ct();
		if ((cmd=leaf->cmd.cid) == C_SQL)
			rc = cl_process_sqlrcv(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		else if (cmd == C_SLEEP)
			rc = cl_process_sleep_rcv(leaf->cmd.prmnum,leaf->cmd.prmp);
		else if (cmd == C_MSG)
			rc = cl_process_message_recv(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
		if (pCLprocTable->WaitPacketp) Free(pCLprocTable->WaitPacketp);
		pCLprocTable->WaitPacketp = NULL;
		cmn_set_stat(RTN_PR,&procct->ptype,L_OFF);
		cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_OFF);
	}
	else {
		ERROROUT("cl_process_msg_pre_return:leaf==NULL");
		rc = ECL_SYSTEM_ERROR;
	}

	return rc;
}

/**************************************************************/
/* cl_proc_bexp                                               */
/**************************************************************/
int cl_process_bexp(cid, leaf, proc)
int     cid;
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;

	if (leaf && proc) {
		if (cid == C_BEXP) rc = cl_proc_bexp(leaf,proc);
		else rc = cl_process_let(leaf,proc);
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_read                                            */
/**************************************************************/
int cl_process_read(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;

	if (leaf && proc) {
		rc = cl_proc_read(leaf->cmd.prmnum,leaf->cmd.prmp,proc->Obj);
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_output                                          */
/**************************************************************/
int cl_process_output(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int   rc;

	if (leaf && proc)  rc = cl_proc_output(leaf,proc);
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_leave                                           */
/**************************************************************/
int cl_process_leave(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;

	if (leaf && proc) {
		/* kd`uds */
		rc = cl_proc_leave(leaf, proc);
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}

/**************************************************************/
/* cl_process_messag_send                                     */
/**************************************************************/
int cl_process_messag_send(nprm,prmp,pbxobj)
int nprm;
parmList *prmp[];
GXObject *pbxobj[];
{
	char *p;
	int rc;

	p = prmp[0]->prp;
 	if (!stricmp(p,"SEND") ||
 	    !stricmp(p,"POST") ||
 	    !stricmp(p,"REPLY"))
			rc = cl_process_msg_snd(nprm,prmp,pbxobj);
	else if (!stricmp(p,"SQL"))
			rc = cl_process_sqlsnd(nprm-1,prmp+1,pbxobj);
	else if (!stricmp(p,"SLEEP"))
			rc = cl_process_sleep_snd(nprm-1,prmp+1,pbxobj);
	else {
		ERROROUT1("[%s] not SQL,SLEEP,SEND,POST,REPLY",p);
		rc = ECL_EX_MSG;
	}
	return rc;
}

/**************************************************************/
/* cl_process_message_recv                                    */
/**************************************************************/
int cl_process_message_recv(nprm,prmp,pbxobj)
int nprm;
parmList *prmp[];
GXObject *pbxobj[];
{
	char *p;
	int rc;

	p = prmp[0]->prp;
 	if (!stricmp(p,"SEND") ||
 	    !stricmp(p,"POST") ||
 	    !stricmp(p,"REPLY"))
			rc = cl_process_msg_rcv(nprm,prmp,pbxobj);
	else if (!stricmp(p,"SQL"))
			rc = cl_process_sqlrcv(nprm-1,prmp+1,pbxobj);
	else if (!stricmp(p,"SLEEP"))
			rc = cl_process_sleep_rcv(nprm-1,prmp+1);
	else {
		ERROROUT1("[%s] not SQL,SLEEP,SEND,POST,REPLY",p);
		rc = ECL_SYSTEM_ERROR;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _add_src(pQue,n1,n2,s,s_len)
tdtQueCtl *pQue;
int n1,n2;
char *s;
int s_len;
{
	int rc,n;
	char *cp;
/*
printf("_add_src: n1=%d n2=%d s_len=%d s=[%s]\n",n1,n2,s_len,s);
*/
	if (s_len <= 0) return 0;
	if ((rc=akxs_que_peek(pQue,QUE_BOT,&cp)) > 0) {
		memcpy(&n,cp,sizeof(int));
		n += n2;
	}
	else n = n1;
	cp = Malloc(sizeof(int)+s_len+1);
	memcpy(cp,&n,sizeof(int));
	memzcpy(cp+sizeof(int),s,s_len);
	akxs_que_put(pQue,QUE_BOT,cp);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _ins_src(pQue,num,s,s_len)
tdtQueCtl *pQue;
int num;
char *s;
int s_len;
{
	int rc,n;
	char *cp;
/*
printf("_ins_src: num=%d s_len=%d s=[%s]\n",num,s_len,s);
*/
	akxs_que_move(pQue,QUE_TOP);
	n = 0;
	for (;;) {
		if ((rc=akxs_que_peek(pQue,QUE_PEEK_CUR,&cp)) < 0) return rc;
		else if (!rc) break;
		memcpy(&n,cp,sizeof(int));
/*
printf("_ins_src: peek: rc=%d n=%d\n",rc,n);
*/
		if (n >= num) break;
		akxs_que_move(pQue,QUE_NEXT);
	}
	if (n == num) {
		akxs_que_get(pQue,QUE_CUR,&cp);
		Free(cp);
	}
	if (s_len > 0) {
		akxs_que_move(pQue,QUE_PREV);
		cp = Malloc(sizeof(int)+s_len+1);
		memcpy(cp,&num,sizeof(int));
		memzcpy(cp+sizeof(int),s,s_len);
		akxs_que_put(pQue,QUE_CUR,cp);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _list_src(pQue,argc,argv)
tdtQueCtl *pQue;
int argc;
char *argv[];
{
	int rc,n;
	char *cp;
	Leaf *leafTop;

	cp = argv[0];
	if (toupper(*cp)=='T'/* || !stricmp(cp,"tree")*/) {
		if (leafTop = search_top_leaf()) col_leaf_print(leafTop);
	}
	else {
		akxs_que_move(pQue,QUE_TOP);
		while (akxs_que_peek(pQue,QUE_PEEK_NEXT,&cp) > 0) {
			memcpy(&n,cp,sizeof(int));
			printf("%5d %s\n",n,cp+sizeof(int));
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _renum_src(pQue,n1,n2)
tdtQueCtl *pQue;
int n1,n2;
{
	int rc,n;
	char *cp;

	n = n1;
	akxs_que_move(pQue,QUE_TOP);
	for (;;) {
		if ((rc=akxs_que_peek(pQue,QUE_PEEK_CUR,&cp)) <= 0) break;
		memcpy(cp,&n,sizeof(int));
		n += n2;
		akxs_que_move(pQue,QUE_NEXT);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _auto_mode(pQue,line,count)
tdtQueCtl *pQue;
char *line;
int count;
{
	int rc,pos;
	char *cp;

	if (pQue) {
		if ((rc=akxs_que_peek(pQue,QUE_PEEK_NEXT,&cp)) > 0) {
			strcpy(line,cp+sizeof(int));
			pos = strlen(line);
		}
		else pos = 0;
	}
	else {
		if (count == 1) {
			strcpy(line,"quit;");
			rc = 1;
			pos = strlen(line);
		}
		else {
			pos = rc = 0;
		}
	}
	strcpy(line+pos,"\n");
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _del_src(pQue,argc,argv)
tdtQueCtl *pQue;
int argc;
char *argv[];
{
	int flg=0;
	Leaf *leafTop;
	char *cp;

	cp = argv[0];
	if (toupper(*cp)=='T'/* || !stricmp(cp,"tree")*/) flg = 0;
	else flg = 1;

	if (flg) akxs_que_all_free(pQue);

	if (leafTop = search_top_leaf()) {
		cl_leaf_clear(leafTop);
	}
	CLSTCB.TopStack = NULL;
	return flg;
}

/****************************************/
/*										*/
/****************************************/
static int _editor(line,line_max)
char *line;
int line_max;
{
	static char *help[]=
{"/            ͗ɕۑꂽsB"
,"/list [tree] treeȂ̂Ƃ́A͗ɕۑꂽ\x96\\B"
,"             treêƂ́Aς݃R}htreê݂\x96\\B"
,"/renum [l][,|][l]"
,"             ̔Ԃ̃ftHglύXAsԍU蒼B"
,"             lȗ邩A[ȉ̂Ƃ́AftHgl͕ύXȂB"
,"/del [tree]  treeȂ̂Ƃ́A͗ɕۑꂽƐς݃R}htree"
,"             Sč폜B"
,"             treêƂ́Aς݃R}htreê݂폜B"
,"/tree        ͗ɕۑꂽR}htree𐶐B"
,"/quit        IB"
,NULL
};
	static tdtQueCtl *pQue=NULL,*pQueAuto=NULL;
	static int n1=10,n2=10,auto_mode=0,tree_mode=0;
	char buf[128],work[128],*p,*argv[10],c,**he;
	int rc,len,line_len,num,s_len,pos,argc;
	SSP_S ssp;

	if (!pQue) pQue = akxs_que_new(0,0);
	if (auto_mode) {
		rc = _auto_mode(pQueAuto,line,auto_mode);
/*
printf("_editor:auto_mode: tree_mode=%d rc=%d line=[%s]\n",tree_mode,rc,line);
*/
		if (rc > 0) {
			auto_mode++;
			return 0;
		}
		else {
			auto_mode = 0;
			if (!tree_mode) return 0;
		}
	}
	tree_mode = 0;
	for (;;) {
		printf("%s",CLcList.fname);
		if ((line_len=akxa_read_line_opt(buf,sizeof(buf),stdin,2)) >= 0) {
			ssp.sp = 0;
			ssp.wd = work;
			if ((len=akxtgwse(buf,&ssp," \n",1)) > 0) {
				CLcList.fname = ">";	/* prompt */
				if ((c=*work) == '/') {
					pos = len + 1;
					argc = akxtgetargv2(buf+ssp.sp+1,argv,10,work+pos,sizeof(work)-pos,0x04);
					p = work + 1;
					if (!(c=toupper(*p)) || c=='T') {
						if (c == 'T') tree_mode = 1;
						else tree_mode = 0;
						argv[0] = "tree";
						_del_src(NULL,1,argv);
						auto_mode = 1;
						pQueAuto = pQue;
						akxs_que_move(pQue,QUE_TOP,NULL);
						rc = _auto_mode(pQue,line,auto_mode);
/*
printf("_editor: work=[%s] auto_mode=%d tree_mode=%d rc=%d line=[%s]\n",work,auto_mode,tree_mode,rc,line);
*/
						if (rc > 0) {
							auto_mode++;
							break;
						}
						else {
							auto_mode = 0;
							if (!tree_mode) break;
						}
					}
					else if (c=='L'/* || !stricmp(p,"list")*/) {
						_list_src(pQue,argc,argv);
					}
					else if (c=='R'/* || !stricmp(work,"/renum")*/) {
						if ((num=atoi(argv[0])) > 0) n1 = num;
						if ((num=atoi(argv[1])) > 0) n2 = num;
						_renum_src(pQue,n1,n2);
					}
					else if (c=='D'/* || !stricmp(work,"/del")*/) {
						if (_del_src(pQue,argc,argv)) pQue = akxs_que_new(0,0);
					}
					else if (c=='Q'/* || !stricmp(work,"/quit")*/) {
						argv[0] = "tree";
						_del_src(NULL,1,argv);
						auto_mode = 1;
						pQueAuto = NULL;
						rc = _auto_mode(NULL,line,auto_mode);
						return 0;
					}
					else if (c=='H'/* || !stricmp(work,"/help")*/) {
						he = help;
						while (p = *he++) printf("%s\n",p);
						putchar('\n');
					}
					else {
						printf("*** [%s] is no subcommand.\n",work);
					}
				}
				else {
					rc = akxcgcvn(work,len,&num);
					if (!rc || rc>1) {
						if (num <= 0) continue;
						rc--;
						if (rc > 0) {
							pos = ssp.sp - len + rc;
						}
						else {
							pos = ssp.sp + 1;
							if (akxtgwse(buf,&ssp," \n",1) <= 0) pos = line_len;
						}
						p = buf + pos;
						s_len = line_len - pos;
						rc = _ins_src(pQue,num,p,s_len);
					}
					else {
						p = buf;
						s_len = line_len;
						_add_src(pQue,n1,n2,buf,line_len);
						memcpy(line,p,s_len);
						strcpy(line+s_len,"\n");
						break;
					}
				}
			}
			else {
				strcpy(line,"\n");
				break;
			}
		}
	}
	return len;
}

/**************************************************************/
/* cl_process_interactive                                    */
/**************************************************************/
int cl_process_interactive(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int len,rc;
	char buf[256];
	ScrPrCT *scrptct;
	Leaf    tleaf,*leafTop;

	if (!leaf || !proc) return ECL_SYSTEM_ERROR;
	if (!(scrptct=cl_search_src_ct())) return ECL_SYSTEM_ERROR;

	if (!(CLcList.ConstCt=cl_const_ct_new())) {
		ERROROUT("Malloc ConstCt");
		return -1;
	}
#if 1
	CLcList.fp = (FILE *)_editor;
	CLcList.option |= D_SCRPT_FUNC;
#else
	CLcList.fp = stdin;
#endif
	CLcList.line = 0;
	CLcList.fname = "coal>";	/* prompt */
	CLcList.fullname = "stdin";
	memset(&tleaf,0,sizeof(Leaf));

	scrptct->pFlag |= D_SCRPT_INTERACTIVE;
	rc = 0;
	for (;;) {
		CLSTCB.TopStack = NULL;
		if (leaf->leftleaf) {
		/*	if (proc->Nextleaf == leaf->leftleaf) proc->Nextleaf = NULL;	*/
			cl_leaf_clear(leaf->leftleaf);
			leaf->leftleaf = NULL;
		}
	/*	printf("coal>");	*/
	/*	printf("Enter Command.\n");	*/
#if 1
		if ((rc=cl_lex()) == -1) {
			printf("\n");
			break;
		}
		else if (!rc) {
			if (leafTop = search_top_leaf()) {
				cl_ret_leaf_push(proc,leaf);
				leaf->leftleaf = leafTop;
				proc->Nextleaf = leaf->leftleaf;
			}
			else rc = -1;
			CLSTCB.TopStack = NULL;
			break;
		}
	}
#else
		if ((rc=cl_lex()) == -1) break;
		else {
			if (leafTop = search_top_leaf()) {
				rc = cl_node_process(leafTop,proc);
				if (!rc && cmn_chk_stat(SCR_ED,&pCLprocTable->ScrSt) != L_OFF) break;
				if (!pGlobTable->error && cmn_chk_stat(RTN_PR | RET_PR,&proc->ptype)!=L_OFF) break;
			}
		}
	}
	printf("\n");
#endif
	scrptct->pFlag &= ~D_SCRPT_INTERACTIVE;
	return rc;
}
