static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi 2010.05.10		*/
/*											*/
/********************************************/
#include "akxcommon.h"

static char *gsep=" \t,;()[]{}<>='\"!^*/";

/********************************************************/
/*														*/
/********************************************************/
int memicmp(sa,sb,len)
uchar *sa,*sb;
int len;
{
	uchar ca,cb;
	int i,dif;

	dif = 0;
	for (i=0;i<len;i++) {
		ca = *sa++;
		cb = *sb++;
		if (dif=akxcupper(ca)-akxcupper(cb)) break;
	}

	return dif;
}

/********************************************************/
/*														*/
/********************************************************/
int memzcpy(d, s, len)
char *d,*s;
int len;
{
	*(d+len) = '\0';
	memcpy(d,s,len);
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memnzcpy(d, s, len, n)
char *d,*s;
int len,n;
{
	if (n < len) len = n;
	if (len < 0) len = 0;
	memzcpy(d,s,len);
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memcat(d, s, len)
char *d,*s;
int len;
{
	memzcpy(d+strlen(d),s,len);
	return len;
}

#if !defined(SUNOS5) && !defined(SUNOS) && !defined(LINUX)
/********************************************************/
/*														*/
/********************************************************/
int stricmp(sa,sb)
uchar *sa,*sb;
{
	uchar ca,cb;
	int d=0;

	for (;;) {
		ca = *sa++;
		cb = *sb++;
		if (!ca && !cb) break;
		if (d=akxcupper(ca)-akxcupper(cb)) break;
	}

	return d;
}
#endif

#if defined(SUNOS) || defined(AIX)
/********************************************************/
/*														*/
/********************************************************/
char *strerror(err)
int err;
{
	char *p;
	extern char *sys_errlist[];
	extern int  sys_nerr;

	if (err>=0 && err<sys_nerr) p = sys_errlist[err];
	else p = AKX_NULL_PRINT;
	return p;
}
#endif

/********************************************************/
/*														*/
/********************************************************/
char *strnzcpy(d, s, len)
char *d,*s;
int len;
{
	if (len < 0) len = 0;
	*(d+len) = '\0';
	return strncpy(d,s,len);
}

/****************************************/
/*										*/
/****************************************/
int akxmemwork(len,pp1,pp0,work,w_len)
int  len;
char **pp0,**pp1,*work;
int  w_len;
{
	char *p,*mem;
	int im;

	if (!pp1 || len<0) return -1;
	im = 1;
	mem = work;
	if (work && len<w_len) im = 0;
	if (im) {
		if (pp0) {
			if (p=MRealloc(*pp0,len+1)) {
				mem = *pp0 = p;
			}
		}
		else p = NULL;
		if (!p) {
			if (work) len = w_len -1;
			else len = -1;
		}
	}
	*pp1 = mem;

	return len;
}

/****************************************/
/*										*/
/****************************************/
char *strmem(s,len)
char *s;
int  len;
{
	static char wrk[256],*p0=NULL;
	char *p;

	if ((len=akxmemwork(len,&p,&p0,wrk,sizeof(wrk))) >= 0) {
		memnzcpy(p,s,len);
	}
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *memaddv0(argc,argv,argl,pp0)
int   argc;
char *argv[];
int   argl[];
char **pp0;
{
	char *p,*p0,*pp,*pM;
	int  alen,blen;
	int i,len,same;

	if (!pp0) return NULL;
/*
printf("memadd0: alen=%d a=[%s] blen=%d b=[%s]\n",alen,a,blen,b);
*/
	p0 = *pp0;
	len = 1;
	same = 0;
	for (i=0;i<argc;i++) {
		len += argl[i];
		if (!argv[i]) same = 1;
	}
	if (!p0 || same) {
		if (!(pM=Malloc(len))) return NULL;
	}
	else {
		if (!(pM=Realloc(p0,len))) return NULL;
		p0 = NULL;
	}
	pp = pM;
	for (i=0;i<argc;i++) {
		if (p=argv[i]) {
			memcpy(pp,p,len=argl[i]);
			pp += len;
		}
	}
	*pp = '\0';
	if (p0) Free(p0);
/*
printf("memaddv0:%s\n",p);
*/
	*pp0 = pM;
	return pM;
}

/****************************************/
/*										*/
/****************************************/
char *memaddv(argc,argv,argl)
int   argc;
char *argv[];
int   argl[];
{
	static char *p0=NULL;

	return memaddv0(argc,argv,argl,&p0);
}
/****************************************/
/*										*/
/****************************************/
char *memadd0(a,alen,b,blen,pp0)
char *a,*b,**pp0;
int  alen,blen;
{
	char *argv[2];
	int   argl[2];

	argv[0] = a;
	argv[1] = b;
	argl[0] = alen;
	argl[1] = blen;
	return memaddv0(2,argv,argl,pp0);
}
/****************************************/
/*										*/
/****************************************/
char *memadd(a,alen,b,blen)
char *a,*b;
int  alen,blen;
{
	static char *p0=NULL;

	return memadd0(a,alen,b,blen,&p0);
}

/****************************************/
/*										*/
/****************************************/
char *straddv(argc,argv)
int   argc;
char *argv[];
{
	int i,*argl=NULL;
	char *p;

	if (argc<=0 || !argv) return NULL;
	if (!(argl=(int *)MRealloc(argl,argc*sizeof(int)))) return NULL;
	memset(argl,0,argc*sizeof(int));
	for (i=0;i<argc;i++) {
		if (p=argv[i]) argl[i] = strlen(p);
	}
	return memaddv(argc,argv,argl);
}

/****************************************/
/*										*/
/****************************************/
char *stradd5(a,b,c,d,e)
char *a,*b,*c,*d,*e;
{
	char *argv[5];

	argv[0] = a;
	argv[1] = b;
	argv[2] = c;
	argv[3] = d;
	argv[4] = e;
	return straddv(5,argv);
}

/****************************************/
/*										*/
/****************************************/
char *stradd(a,b)
char *a,*b;
{
	if (!a) return b;
	if (!*a) return b;
	if (!b) return a;
	if (!*b) return a;
	return stradd5(a,b,NULL,NULL,NULL);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrnlen(s,len)
char *s;
int len;
{
	int i;
	char *p=s;

	for (i=0;i<len;i++) if (!*p++) break;

	return i;
}

/********************************************************/
/*														*/
/********************************************************/
char akxcupper(cc)
char cc;
{
	char c;

	if ((c=cc)>='a' && c<='z') c &= ~0x20;
	return c;
}

/****************************************************************************/
/* 0x01 = 0/1 : sXy[Xƃ^uXLbvȂ / XLbv			*/
/* 0x02 = 0/1 : QdpAp͂Ȃ(sSG[) / ͂	*/
/* 0x04 = 0/1 : QdpAp̘̒AQ̂PɂȂ	*/
/*              / Pɂ												*/
/* 0x08 = 0/1 : QdpAp̏ / Ȃ				*/
/* 0x10 = 0/1 : ؂蕶ȊO܂ŃXLbvȂ / L	*/
/* 0x20 = 0/1 : gpBsspl->wdmaxgp								*/
/*      wdmax= 0:ssp->wdɃ[hi[A[h̐擪AhX	*/
/*      wdmax<>0:ssp->wdɃ[hi[ (wdmax<0:`FbNȂ)	*/
/* 0x40 = 0/1 : '\n'܂'\r'I[Ƃ / I[ƂȂ					*/
/*				(=1 ́Ap̂Ƃ̂ݗL)								*/
/* 0x100 = 1 : p̏Ȃ											*/
/* 0x200 = 1 : Qdp̏Ȃ										*/
/****************************************************************************/
int akxtgwnsl(buf, len, sspl, sep, opt)
char *buf, *sep;
SSPL_S *sspl;
int len, opt;
{
	int	opt_0,opt_1,opt_2,opt_3,opt_4,opt_5,opt_6,opt_8,opt_9;
	int i, l, pos, nsep, lmax, m;
	char *s, ch, *w, quat, *psep;
	uchar pattr[4],code_type;

	if (!buf || !sspl) return -2;
	if (!sep) sep = gsep;

	pos = sspl->sp;
	w = sspl->wd;
	lmax = sspl->wdmax;
	pattr[1] = 0;
	sspl->attr[0] = 0;
	sspl->attr[1] = 0;
	sspl->attr[2] = 0;
	sspl->attr[3] = 0;
	opt_2 = opt & 0x04;
	if (lmax) opt_5 = 1;
	else {
		opt_2 = 0;
		opt_5 = 0;
	}
	if (opt_5) *w = '\0';
	else sspl->wd = "";

	if (pos > len) return -1;
	else if (pos == len) {
		sspl->sp++;
		return 0;
	}

	nsep = strlen(sep);
	s = buf + pos;
	pattr[1] = 0;
	opt_0 = opt & 0x01;
	opt_1 = opt & 0x02;
	opt_3 = !(opt & 0x08);
	opt_4 = opt & 0x10;
	opt_6 = !(opt & 0x40);
	opt_8 = !(opt & (0x100 | 0x08));
	opt_9 = !(opt & (0x200 | 0x08));
	l = 0;

	if ((code_type=sspl->code) == CD_TYPE_SYSTEM) code_type = akxt_get_code_type();

	if (opt_4) {
		while((pos<len)&&((ch=*s++)!='\0')) {
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			for (i=0,psep=sep;i<nsep;i++) {
				if (ch == *psep++) break;
			}
			if (i>=nsep) {
				l = 1;
				break;
			}
			pos++;
		}
		sspl->sp = pos;
		if (opt_5) *w = '\0';
		else sspl->wd = s;
		return l;
	}
	if (opt_0) {
		while((pos<len)&&(((ch=*s)==' ')||(ch=='\t')||
		                  (!opt_6 && ((ch=='\n')||(ch=='\r'))))) {
			pos++;
			s++;
		}
		if (pos>=len) {
			sspl->sp = pos;
			if (opt_5) *w = '\0';
			else sspl->wd = s;
			return l;
		}
	}
	if (!opt_5) sspl->wd = s;
	ch = *s;
/*	if (opt_3 && (pos<len) && (ch=='"' || ch=='\'')) {	*/
	if ((pos<len) && ((ch=='"' && opt_9) || (ch=='\'' && opt_8))) {
		if (opt_1 && !opt_5) sspl->wd++;
		if (ch=='"') sspl->attr[0] = 6;
		else if (ch=='\'') sspl->attr[0] = 5;
		quat=ch;
		pos++;
		s++;
		if (!opt_1) {
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
		}
		while((pos<len)&&((ch=*s)!='\0')) {
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			if (m=akxqismbs(code_type,s)) {
				l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
				pos += m;
				s += m;
				sspl->attr[1] = 1;
			}
			else {
				pos++;
				s++;
				if (ch == quat) {
					if ((pos >= len) || (*s != quat)) {
						if (!opt_1) {
							l = akxwdmax_chk(&w,pattr,lmax,l,ch);
						}
						if (opt_5) *w = '\0';
						sspl->sp = pos;
						if (pattr[1]) sspl->attr[2] = 0x02;
						return l;
					}
					else {
						sspl->attr[3] = 1;
						if (!opt_2) {
							l = akxwdmax_chk(&w,pattr,lmax,l,ch);
						}
						l = akxwdmax_chk(&w,pattr,lmax,l,quat);
						pos++;
						s++;
					}
				}
				else {
					l = akxwdmax_chk(&w,pattr,lmax,l,ch);
				}
			}
		}
		if (opt_5) *w = '\0';
		sspl->sp = pos;
		if (!opt_1) sspl->attr[2] = 1;
		if (pattr[1]) sspl->attr[2] |= 0x02;
		return l;
	}
	for (i=0,psep=sep;i<nsep;i++) {
		if (ch==*psep++) {
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
			if (opt_5) *w = '\0';
			pos++;
			sspl->sp = pos;
			sspl->attr[0] = ch | 0x80;
			if (pattr[1]) sspl->attr[2] = 0x02;
			return l;
		}
	}
	while ((pos<len)&&((ch=*s)!='\0')) {
		if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
		if ((pos+1<len) && (m=akxqismbs(code_type,s))) {
			l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
			pos += m;
			s += m;
			sspl->attr[1] = 1;
		}
		else {
			if ((pos+1==len) && akxqismbs1(code_type,*s)) {
				pos++;
				break;
			}
			for (i=0,psep=sep;i<nsep;i++) {
				if (ch==*psep++) {
					if (opt_5) *w = '\0';
					sspl->sp = pos;
					sspl->attr[0] = 1;
					if (pattr[1]) sspl->attr[2] = 0x02;
					return l;
				}
			}
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
			pos++;
			s++;
		}
	}
	if (opt_5) *w = '\0';
	sspl->sp = pos;
	if (l>0) sspl->attr[0] = 1;
	if (pattr[1]) sspl->attr[2] = 0x02;
	return l;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwns(buf, len, ssp, sep, opt)
char *buf, *sep;
SSP_S *ssp;
int len, opt;
{
	SSPL_S sspl;
	int ret;

	memcpy(&sspl,ssp,sizeof(SSP_S));
	if (opt & 0x20) sspl.wdmax = 0;
	else sspl.wdmax = -1;
	sspl.code = 0;
	ret = akxtgwnsl(buf,len,&sspl, sep, opt);
	memcpy(ssp,&sspl,sizeof(SSP_S));
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwse(buf, ssp, sep, opt)
char *buf, *sep;
SSP_S *ssp;
int opt;
{
	return akxtgwns(buf,INT_MAX,ssp,sep,opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwsp(buf, ssp)
char *buf;
SSP_S *ssp;
{
	return akxtgwse(buf,ssp,gsep,0x01);
}

/********************************************************/
/*														*/
/********************************************************/
int akxtpknsl(s, slen, ssp, sep, opt)
char *s, *sep;
SSPL_S *ssp;
int slen, opt;
{
	int pos,len;

	if (!ssp) return -1;
	pos = ssp->sp;
	len = akxtgwnsl(s,slen,ssp,sep,opt);
	ssp->sp = pos;
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtpkns(s, slen, ssp, sep, opt)
char *s, *sep;
SSP_S *ssp;
int slen, opt;
{
	int pos,len;

	if (!ssp) return -1;
	pos = ssp->sp;
	len = akxtgwns(s,slen,ssp,sep,opt);
	ssp->sp = pos;
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcctox(puc,len,pux)
uchar *puc,*pux;
int len;
{
	int sw,m,n;
	uchar *pucw,*puxw,uc;

	if (!(pucw=puc) || !(puxw=pux)) return -1;
	n = len;
	m=sw=0;
	while (n--) {
		uc = *pucw++;
 		if   ((uc>='0') && (uc<='9')) uc -= '0';
		else if ((uc>='A') && (uc<='F')) uc -= 'A' + 10;
		else if ((uc>='a') && (uc<='f')) uc -= 'a' + 10;
		else uc = 0;
		if (sw) {
			*puxw |= uc;
			sw=0;
			puxw++;
		}
		else {
			*puxw = uc<<4;
			sw=1;
			m++;
		}
	}
	return m;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtsrepc(s,cs,cd)
char *s,cs,cd;
{
	int n=0;
	char c;

	while (c=*s) {
		if (c == cs) {
			n++;
			*s = cd;
		}
		s++;
	}
	return n;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxt_get_last_name(delm,path)
char *delm, *path;
{
	int len, i;
	char *name, *p;

	if (!path) return NULL;
	if (!delm) return path;
	if (!(*delm)) return path;

	len = strlen(name=path);
	i = akxnrskipto(name,len,delm);
	if (i >= 0) name += i;
	return name;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcxtoc(s,len,d)
char *s, *d;
int len;
{
	int i;
	uchar ucH, ucL;

	for (i=0;i<len;i++) {
		ucH = *s >> 4 & 0x0F;
		ucL  = *s++ & 0x0F;
		if (ucH >= 10) *d++ = (ucH-10) + 'a';
		else *d++ = ucH + '0';
		if (ucL >= 10) *d++ = (ucL-10) + 'a';
		else *d++ = ucL + '0';
	}
	return len*2;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxt_add_dir2(cpDir,cpFile,cppPath)
char *cpDir,*cpFile,**cppPath;
{
	char *cpPath;
	char *p;
	int len;

	if (!cpDir) return cpFile;
	if (!(*cpDir)) return cpFile;
	if (!cpFile || !*cpFile) return cpDir;
	if (*cpFile == '/') return cpFile;
	if (!cppPath) return NULL;

	cpPath = *cppPath;
	len = strlen(cpDir) + strlen(cpFile) + 2 + 8;
	if (cpPath) {
		if (!(cpPath=Realloc(cpPath,len))) return NULL;
	}
	else {
		if (!(cpPath=Malloc(len))) return NULL;
	}
	strcpy(cpPath,cpDir);
	p = cpPath + strlen(cpPath);
	if (*(p-1) != '/') *p++ = '/';
	strcpy(p,cpFile);
	*cppPath = cpPath;
	return cpPath;
}

/********************************************************/
/*														*/
/********************************************************/
int akxt_set_bits(ipBits,iMask,iSet)
int *ipBits,iMask,iSet;
{
	int b,m,i;

	b = *ipBits;
	m = iMask;
	if (i=iSet) {
		if (i < 0) b &= ~m;
		else if (i == 1) b |= m;
		else b = m;
		*ipBits = b;
	}
	return b & m;
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_in_mem_opt(target,ltar,str,lstr,opt)
char *target,*str;
int  ltar,lstr,opt;
{
	char *pt,*ps,z1[5];
	int  i,k,n,opt01,opt02,opt04,opt08,pos,unmatch;
	int  opt20,m,optw,nn[3],mtar,mstr,len,kk,mm;

	if ((pt=target) && (ps=str)) {
/*
printf("akxs_in_mem_opt: ltar=%d pt=[%s]\n",ltar,pt);
printf("                 lstr=%d ps=[%s]\n",lstr,ps);
*/
		opt01 = opt & 0x01;	/* ignore case */
		opt02 = opt & 0x02;	/* reverse */
		opt04 = opt & 0x04;	/* return moji position */
		opt08 = opt & 0x08;	/* compare top only */
		opt20 = opt & 0x20;	/* ignore zenkaku hankaku */
		optw = 0x10 | opt01 | (opt20>>4);
		if (opt20) {
			mtar = akxctozen(ltar,pt,0);
			mstr = akxctozen(lstr,ps,0);
			if (opt08 && (mtar != mstr)) return 0;
		}
		else {
			if (opt08 && (ltar != lstr)) return 0;
			mstr = akxqmlen(ps,lstr);
			mtar = akxqmlen(pt,ltar);
		}
		n = mtar - mstr + 1;
/*		n = ltar - lstr + 1;	*/
		if (opt08 && n>1) n = 1;
/*
printf("akxs_in_mem_opt: n=%d opt=%04x optw=%04x\n",n,opt,optw);
*/
		pos = 0;
		len = ltar;
		i = kk = 1;
#if 1
		for (k=1;k<=n;k++) {
#else
		for (k=1,i=1;i<=n;i++,k++,pt++) {
#endif
/*
printf("akxs_in_mem_opt: k=%d i=%d kk=%d len=%d\n",k,i,kk,len);
*/
#if 1
			unmatch = akxmbncmp_opt(pt,len,ps,lstr,optw);
#else
			if (opt01) unmatch = akxmemicmp(pt,ps,lstr);	/* ignore case */
			else       unmatch = akxmemcmp(pt,ps,lstr);
#endif
			if (!unmatch) {
				if (opt04) {
					if (opt02) pos = kk;	/* reverse */
					else return kk;
				}
				else {
					if (opt02) pos = i;	/* reverse */
					else return i;
				}
			}
			mm = m = 1;
			if (opt20) {
				akxctozen1(len,pt,0,nn);
				m = nn[0];
				mm = nn[2];
/*
printf("akxs_in_mem_opt:opt20: m=%d mm=%d\n",m,mm);
*/
			}
			else if (i < n) {
				m = akxqkanjilen(pt);
/*
printf("akxs_in_mem_opt: m=%d\n",m);
*/
			}
			len -= m;
			kk += mm;
			i  += m;
			pt += m;
		}
		return pos;
	}
	else return -1;
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_in_str_opt(target,str,opt)
char *target,*str;
{
	char *pt,*ps;

	if ((pt=target) && (ps=str))
		return akxs_in_mem_opt(pt,strlen(pt),ps,strlen(ps),opt);
	else
		return -1;
}

/********************************************************/
/*														*/
/********************************************************/
int inistr(target,str)
char *target,*str;
{
	return akxs_in_str_opt(target,str,1);
}

/********************************************************/
/*														*/
/********************************************************/
char *stristr(target,str)
char *target,*str;
{
	int i;

	if ((i=akxs_in_str_opt(target,str,1)) > 0) return target+i-1;
	return NULL;
}

/****************************************/
/*	Get General-Purpose Data			*/
/*		coded by A.Kobayashi 2003.11.19	*/
/****************************************/
int akxt_get_gep_data(klen,p,kpp,plalen)
int  klen;
char *p,**kpp;
int  *plalen;
{
	int  lalen;
	INT4 lklen;

	if (!p) return -1;
	if (klen>0) lalen=lklen=klen;
	else if (klen<0) {
		memcpy(&lklen,p,sizeof(INT4));
		if (lklen<0) return -2;
		p += sizeof(INT4);
		lalen=lklen+sizeof(INT4);
	}
	else {
		lklen=strlen(p);
		lalen=lklen+1;
	}
	if (kpp) *kpp = p;
	if (plalen) *plalen = lalen;
	return lklen;
}

/****************************************/
/*	Cmp General-Purpose Data			*/
/*		coded by A.Kobayashi 2003.11.25	*/
/****************************************/
int akxt_cmp_gep_data_opt(klen,kp,lklen,p,opt)
int  klen,lklen;
char *kp,*p;
{
	INT4 ldlen;
	int  s,iCASE;

	if (!kp || !p) return -256;
	iCASE = opt & 0x01;
	if (klen>0) {
		if (iCASE) s = akxmemicmp(kp,p,lklen);
		else s = memcmp(kp,p,lklen);
	}
	else {
		if (klen<0) {
			memcpy(&ldlen,p,sizeof(INT4));
			if (ldlen<0) return -257;
			if (!(s=ldlen-lklen)) {
				if (iCASE) s = akxmemicmp(kp,p,lklen);
				else s = memcmp(kp,p+sizeof(INT4),lklen);
			}
		}
		else {
			if (iCASE) s = akxstricmp(kp,p);
			else s = strcmp(kp,p);
		}
	}
	return s;
}

/********************************************************/
/*														*/
/********************************************************/
int akxt_cmp_gep_data(klen,kp,lklen,p)
int  klen,lklen;
char *kp,*p;
{
	return akxt_cmp_gep_data_opt(klen,kp,lklen,p,0);
}

/********************************************************/
/*														*/
/********************************************************/
tdtConvMsgHead *akxc_conv_msg_new(mesg)
tdtMessages mesg[];
{
	tdtConvMsgHead *p;

	if (p=(tdtConvMsgHead *)Malloc(sizeof(tdtConvMsgHead))) {
		p->cmh_try      = 1;
		p->cmh_langmax  = -1;
		p->cmh_no_max   = 0;
		p->cmh_messages = mesg;
		p->cmh_index    = NULL;
		p->cmh_xhp      = NULL;
		akxc_conv_msg(p,1,0);
	}
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxc_conv_msg(cmh,no,lang)
tdtConvMsgHead *cmh;
int no,lang;
{
	tdtRbChain *xhp;
	tdtMessages *mesg,*me,**index;
	int  langmax,no_max,i,k,ix,reg_max;
	char *p;

	if (!cmh) return NULL;
	if (!(mesg=cmh->cmh_messages)) return NULL;
	me = &mesg[0];
	if (no <= 0) return (char *)me->mm_msg;

	xhp   = cmh->cmh_xhp;
	index = cmh->cmh_index;
	p = "";
	if (cmh->cmh_try && !xhp && !index) {
		cmh->cmh_try = 0;
		for (k=0;k<3;k++) {
			if (!me->mm_msg[k] || !*me->mm_msg[k]) break;
		}
		cmh->cmh_langmax = k - 1;
		no_max = k = 0;
		reg_max = me->mm_msgno;
		me++;
		for (;(i=me->mm_msgno)>=0;me++) {
			k++;
			if (i > no_max) no_max = i;
		}
		cmh->cmh_no_max = no_max;
/*
printf("akxc_conv_msg: langmax=%d msg_count=%d no_max=%d\n",cmh->cmh_langmax,k,no_max);
*/
		if (k > no_max/2) {
			if (index = (tdtMessages **)Malloc(sizeof(tdtMessages *)*no_max)) {
				memset(index,0,sizeof(tdtMessages *)*no_max);
				for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
					index[i-1] = me;
				}
			}
		}
		if (!index && k>100) {
			if (reg_max <= 0) reg_max = k;
			if (xhp=akxs_xhasl_new(sizeof(int),reg_max,0,0)) {
				for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
					if (akxs_xhasl(xhp,'S',i,&me) <= 0) {
						akxs_xhasl_free(xhp);
						xhp = NULL;
						break;
					}
				}
			}
		}
		cmh->cmh_xhp   = xhp;
		cmh->cmh_index = index;
/*
printf("akxc_conv_msg: xhp=%08x index=%08x\n",xhp,index);
*/
	}
	langmax = cmh->cmh_langmax;
	no_max  = cmh->cmh_no_max;
	ix = 0;
	if ((lang>=0 && lang<=langmax) && no<=no_max) {
		if (index) {
			if (me = index[no-1]) ix = no;
		}
		else if (xhp) {
			ix = akxs_xhasl(xhp,'R',no,&me);
		}
		else {
			for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
				if (i == no) {
					ix = i;
					break;
				}
			}
		}
		if (ix > 0) {
			p = me->mm_msg[lang];
			if (!p || !*p) {
				for (k=lang+1;k<=langmax;k++) {
					if ((p=me->mm_msg[k]) && *p) break;
				}
			}
		}
	}
/*
printf("akxc_conv_msg: no=%d ix=%d\n",no,ix);
*/
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
int akx_get_gen_int_data(p)
tdtGeneralData *p;
{
	int len,i=0;
	short s;
	char *pd;

	if (p && (pd=p->gd_data)) {
		if (len == 4) memcpy(&i,pd,sizeof(INT4));
		else if ((len=p->gd_dlen) == 2) {
			memcpy(&s,pd,sizeof(short));
			i = s;
		}
		else i = *(uchar *)pd;
	}
	return i;
}

/********************************************************/
/*														*/
/********************************************************/
UINT4 akxcmb2ul(s,len)
uchar *s;
int  len;	/* >=1, <=4 */
{
	uchar *p=s;
	int n=len;
	UINT4 ul;

#if 1
	if (n <= 0) ul = 0;
	else {
		ul = *p++;
		if (n == 2) ul = ul<<8 | *p;
		else if (n == 3) ul = (ul<<8 | *p)<<8 | *(p+1);
		else if (n == 1) ;
		else ul = ((ul<<8 | *p)<<8 | *(p+1))<<8 | *(p+2);
	}
#else	/* [v̕x */
	ul = 0;
	while (n-- > 0) {
		ul = ul<<8 | *p++;
	}
#endif
	return ul;
}

/********************************************************/
/*														*/
/********************************************************/
int akxmbcmp(s1,m1,s2,m2)
uchar *s1,*s2;
int m1,m2;
{
	return akxcmb2ul(s1,m1) - akxcmb2ul(s2,m2);
}

/********************************************************/
/*	ƕr							*/
/********************************************************/
int akxmbncmp_opt(pstr1,nstr1,pstr2,nstr2,opt)
uchar *pstr1,*pstr2;
int nstr1,nstr2,opt;
{
	uchar *s1,*s2,c1,c2;
	int len1,len2,m1,m2,opt01,opt02,opt10,dif;
	uchar u1[5],u2[5],z1[5],z2[5],uc,*p1,*p2;
	int n1,n2,nn[3];

	if (!(s1=pstr1) || !(s2=pstr2)) return -1;
/*
printtx("akxmbncmp_opt",pstr1,nstr1);
printtx("             ",pstr2,nstr2);
printf("             : opt=%04x\n",opt);
*/
	if (!(len1=nstr1) || !(len2=nstr2)) return 0;
	opt01 = opt & 0x01;	/* ignore case */
	opt02 = opt & 0x02;	/* ignore zenkaku hankaku */
	opt10 = opt & 0x10;	/* memcmp (gp) */
	dif = 0;
	for (;;) {
		c1 = c2 = '\0';
		if (len1 > 0) c1 = *s1;
		if (len2 > 0) c2 = *s2;
		if (!opt10 && !c1 && !c2) break;
		m1 = m2 = 1;
		if (len1 >= 2) m1 = akxqkanjilen(s1);
		if (len2 >= 2) m2 = akxqkanjilen(s2);
/*
printf("akxmbncmp_opt: m1=%d m2=%d\n",m1,m2);
*/
		if (m1==1 && m2==1) {
			if (opt01) {
				c1 = akxcupper(c1);
				c2 = akxcupper(c2);
			}
/*
printf("akxmbncmp_opt: c1=[%c] c2=[%c]\n",c1,c2);
*/
			if (dif=c1-c2) break;
			len1--;
			len2--;
			s1++;
			s2++;
		}
		else {
			n1 =m1;
			n2 =m2;
			if (opt02) {
				p1 = s1;
				p2 = s2;
				if (m1 == 1) {
					m1 = akxctozen1(len1,s1,z1,nn);
					n1 = nn[0];
					p1 = z1;
/*
printtx("akxmbncmp_opt:zen1:1",p1,m1);
*/
				}
				if (m2 == 1) {
					m2 = akxctozen1(len2,s2,z2,nn);
					n2 = nn[0];
					p2 = z2;
/*
printtx("akxmbncmp_optzen1:2",p2,m2);
*/
				}
				if (opt & 0x01) {
					akxcuplw(u1,z1,0);
					akxcuplw(u2,z2,0);
					p1 = u1;
					p2 = u2;
/*
printtx("akxmbncmp_opt:up:1",p1,m1);
printtx("             :up:2",p2,m2);
*/
				}
			}
			else {
				if (m1 > len1) m1 = len1;
				if (m2 > len2) m2 = len2;
				p1 = s1;
				p2 = s2;
			}
			if (dif=akxmbcmp(p1,m1,p2,m2)) break;
/*
printf("akxmbncmp_opt: n1=%d n2=%d\n",n1,n2);
*/
			s1 += n1;
			s2 += n2;
			len1 -= n1;
			len2 -= n2;
		}
		if (len1<=0 || len2<=0) break;
	}
	return dif;
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrcmp(s1,s2)
uchar *s1,*s2;
{
	return akxmbncmp_opt(s1,strlen(s1),s2,strlen(s2),0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstricmp(s1,s2)
uchar *s1,*s2;
{
	return akxmbncmp_opt(s1,strlen(s1),s2,strlen(s2),0x01);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemcmp(s1,s2,len)
uchar *s1,*s2;
int len;
{
	if (len <= 0) return 0;
	else return akxmbncmp_opt(s1,len,s2,len,0x10);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemicmp(s1,s2,len)
uchar *s1,*s2;
int len;
{
	if (len <= 0) return 0;
	else return akxmbncmp_opt(s1,len,s2,len,0x11);
}

/********************************************************/
/*	(pm1,len)̕(pm2)ʒuԂ		*/
/********************************************************/
int akx_mem_chr_opt(pm1,pm2,len,opt)
uchar *pm1,*pm2;
int len,opt;
{
	uchar *s1,*s2,c1,c2;
	int pos,opt01,n,m1,m2,dif;

	if (!(s1=pm1) || !(s2=pm2)) return -1;
	opt01 = opt & 0x01;	/* ignore case */
	if (!(m2=akxqiskanji(s2))) {
		c2 = *s2;
		 if (opt01) c2 = akxcupper(c2);
	}
	pos=0;
	n = len;
	while (n > 0) {
		if (n >= 2) m1=akxqiskanji(s1);
		else m1=0;
		if (m1 && m2) {
			if (m1==m2 && n>=m1) {
				if (!memcmp(s1,s2,m1)) {
					pos=len-n+1;
					break;
				}
			}
		}
		else if (m1==m2) {
			c1 = *s1;
			if (opt01) dif=akxcupper(c1)-c2;
			else dif=c1-c2;
			if (!dif) {
				pos=len-n+1;
				break;
			}
		}
		if (m1) {
			s1+=m1;
			n -=m1;
		}
		else {
			s1++;
			n--;
		}
	}

	return pos;
}

/********************************************************/
/*														*/
/********************************************************/
int akx_skip_opt(buf,len,ptn,opt)
char *buf,*ptn;
int  len,opt;
{
	int  i,lptn,m,k,flg,flgb;
	char *p;
	int  n,opt01,opt02,opt04,opt08,pos,match;

	if (!buf || !ptn) return -1;
	opt04 = opt & 0x04;	/* return moji position */
/*
	if (!*ptn) {
		if (opt04) pos = akxqmlen(buf,len);
		else pos = len;
		return pos;
	}
*/
	opt01 = opt & 0x01;	/* ignore case */
	opt02 = opt & 0x02;	/* reverse */
	opt08 = opt & 0x08;	/* 0/1=in/to */
	if (opt02) opt08 = opt08 ? 0 : 1;
	pos = 0;
	p = buf;
	m = 1;
	flgb = 0;
	lptn=strlen(ptn);
	for (i=k=0;i<len;k++) {
		if (!(*p)) break;
		match = akx_mem_chr_opt(ptn,p,lptn,opt01);
		flg = (opt08 && match) || (!opt08 && !match);
		if (opt02) {
			if (!flgb && flg) {
				if (opt04) pos = k;
				else pos = i;
			}
			flgb = flg;
		}
		else {
			if (flg) {
				if (opt04) i = k;
				return i;
			}
		}
		m=akxqkanjilen(p);
		p += m;
		i += m;
	}
	if (opt02) {
		if (!flgb) {
			if (opt04) pos = k;
			else pos = i;
		}
	}
	else {
		if (opt04) pos = k;
		else pos = i;
	}
	return pos;
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipin(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnrskipin(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x02);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipto(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x08);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnrskipto(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x08|0x02);
}

/********************************************************/
/*														*/
/********************************************************/
int akx_conv_yen1(s,len,ssp)
uchar *s;
int    len;
SSP_S *ssp;
{
	uchar *p,c,uc,escape,cc;
	int i,h,n,max,rad,d;

	i = ssp->sp;
	ssp->attr[1] = '\0';
	if (i >= len) return -1;
	p = s + i++;
	escape = ssp->attr[0];
	c = *p++;
	if (escape && c==escape && i<len) {
		c = *p;
		if ((c>='0' && c<='9') || c=='x') {
			if (c == 'x') {
				max = 2;
				rad = 16;
				i++;
				p++;
			}
			else {
				max = 3;
				rad = 8;
			}
			max = X_MIN(i+max,len);
			n=0;
			uc = '\0';
			for (;i<max;i++,p++) {
				c = *p;
				if (c>='0' && c<='7') d = c - '0';
				else d = -1;
				if (rad == 16) {
					if (c>='a' && c<='f') d = c - 'a' + 10;
					else if (c>='A' && c<='F') d = c - 'A' + 10;
				}
				if (d>=0 && d<rad) {
					uc = uc*rad + d;
					n++;
				}
				else {
					break;
				}
			}
			c = uc;
		}
		else {
			switch (c) {
				case 'n': c = '\n'; break;
				case 'r': c = '\r'; break;
				case 't': c = '\t'; break;
				case 'b': c = '\b'; break;
				case 'f': c = '\f'; break;
			}
			i++;
		}
	}
	ssp->sp = i;
	ssp->attr[1] = c;
	return 0;
}
/********************************************************/
/*														*/
/********************************************************/
int akxtsapb(opt,pData,len)
int opt;	/* 0: 1:O 2: O*/
char *pData;
int len;
{
	int i,ol;
	char *p, *pb, c;

	p = pData;
	for (ol=0;ol<len;ol++) {
		if (!*p) break;
		p++;
	}
	p = pData;
	if (opt >= 1) {
		while (ol>0 && ((c = *p) == ' ') || (c == '\t')) {
			p++;
			ol--;
		}
		if (ol <= 0) {
			*pData = '\0';
			return (0);
		}
	}
	if (opt <= 1) {
		pb = p + ol - 1;
		while (ol>0) {
			if (((c = *pb--) != ' ') && (c != '\t')) break;
			ol--;
		}
	}
	if (opt>=1 && pData != p) memcpy(pData,p,ol);

	if (ol<len) pData[ol] = '\0';
	return (ol);
}

/********************************************************/
/*														*/
/********************************************************/
int akxttrim(opt,pData,len)
int opt;	/* 0: 1:O 2: O*/
char *pData;
int len;
{
	int i,ol,ib;
	char *p, c, *pp;

	if (!(p = pData)) return -1;
	else if ((ol = len) <= 0) return ol;

	if (opt >= 1) {
		while (ol>0 && ((c = *p) == ' ') || (c == '\t')) {
			p++;
			ol--;
		}
		if (ol <= 0) {
			*pData = '\0';
			return 0;
		}
	}
	pp = p;
	if (opt <= 1) {
		ib = -1;
		for (i=0;i<ol;i++,p++) {
			if (((c = *p)==' ') || (c=='\t')) {
				ib = i;
				for (;i<ol;i++,p++) {
					if (((c = *p)==' ') || (c=='\t')) ;
					else {
						if (c) ib = -1;
						break;
					}
				}
			}
			if (!c) {
				ol = i;
				break;
			}
		}
		if (ib >= 0) ol = ib;
	}

	if (opt>=1 && pData != pp) memcpy(pData,pp,ol);

	if (ol<len) pData[ol] = '\0';
	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
void printtx(msg,p,len)
char *msg,*p;
int len;
{
	int i;

	printf("%s:",msg);
	printf(" len=%d text=[",len);
	for (i=0;i<len;i++) printf("%c",*p++);
	printf("]\n");
}
