static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************************/
/* <clprbreak.c>                                       */
/*      break process   @@@                         */
/*******************************************************/

#include "colmn.h"

/************************************/
/*									*/
/************************************/
static int _push_break(leaf,proc,n,cid)
Leaf   *leaf;
ProcCT *proc;
int n,cid;
{
	static Leaf	Retleaf;
	Leaf	*retleaf;
/*
printf("_push_break: n=%d cmd=%08x %s\n",n,cid,cl_gets_cmd_name(cid));
*/
	retleaf = &Retleaf;
	memcpy(retleaf,leaf,sizeof(Leaf));
	retleaf->rightleaf = NULL;
	retleaf->leftleaf  = NULL;
	cl_copy_cmd(&(retleaf->cmd),&(leaf->cmd));
	retleaf->cmd.sub_cid = cid;
	retleaf->cmd.parnum = n;
	retleaf->cmd.prmnum = 0;
	retleaf->cmd.prmp = NULL;
	cl_ret_leaf_push(proc,retleaf);
	return 0;
}

/************************************/
/*									*/
/************************************/
int cl_pop_finally(proc,pcrLCB)
ProcCT *proc;
BlockCB *pcrLCB;
{
	static int try_cida[]={C_CATCH,C_FINALLY,C_ENDTRY,0};
	Leaf    *leafw;

	if (!(leafw=cl_ret_leaf_pop_search(proc,try_cida,3))) return -1;
	while (leafw) {
		if (leafw->cmd.cid == C_FINALLY) {
			proc->pcrBlockCB = pcrLCB;
			proc->Nextleaf = leafw;
			return C_FINALLY;
		}
		leafw=leafw->rightleaf;
	}
	/* OTRYԂɖ߂ */
	proc->pFlag = pcrLCB->pFlag;
	proc->ucExcept = pcrLCB->ucExcept;
	return 0;
}

/************************************/
/* _check_in_loop					*/
/************************************/
static int _check_in_loop(proc)
ProcCT  *proc;
{
	if (!cmn_chk_stat(LOP_PR,&proc->ptype)) {
		ERROROUT("Outside of loop !!");
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/************************************/
/* _check_in_loop_switch			*/
/************************************/
BlockCB *_check_in_loop_switch(proc)
ProcCT  *proc;
{
	BlockCB *pcrLCB;
	int cmd;

	pcrLCB = proc->pcrBlockCB;
	while (pcrLCB) {
		cmd = pcrLCB->cid;
/*
printf("_check_in_loop_switch: cmd=%08x %s\n",cmd,cl_gets_cmd_name(cmd));
*/
		if (cmd==C_LOOP || cmd==C_FOR || cmd==C_DO || cmd==C_SWITCH) return pcrLCB;
		pcrLCB = pcrLCB->preBlockCB;
	}
	return NULL;
}


/************************************/
/* _set_up_level					*/
/************************************/
static int _set_up_level(leaf,proc,ip,msg,err,cmd)
Leaf    *leaf;
ProcCT  *proc;
int      ip;
char    *msg;
int      err;
int      cmd;
{
	int rc,level,n,cid;
	BlockCB *pcrLCB;
/*
printf("_set_up_level: cmd=%08x %s parnum=%d\n",
cmd,cl_gets_cmd_name(cmd),leaf->cmd.parnum);
*/
	if (leaf->cmd.sub_cid > 0) {
		level = leaf->cmd.parnum;
	}
	else if (leaf->cmd.prmnum > ip) {
		rc = cl_get_gx_exp_bin(leaf->cmd.prmnum-ip,&(leaf->cmd.prmp[ip]),proc->Obj,
		                   &level,0x01,msg,err);
		if (rc) {
			if (rc == ECL_NULL_DATA) level = 1;
			else return rc;
		}
/*
printf("_set_up_level: level=%d\n",level);
*/
		if (level < 0) {
			ERROROUT2(FORMAT(411),msg,level);	/* %sx(%d)słB */
			return err;
		}
		else if (!level) return C_SKIP_COMMAND;
	}
	else level = 1;

	pcrLCB = proc->pcrBlockCB;
#if 0	/* 2017.3.21 mod 1-->0 */
	if (cmd == C_SWITCH) {
		if (level > 1) {
			ERROROUT2(FORMAT(411),msg,level);	/* %sx(%d)słB */
			return err;
		}
	}
#endif
	for (n=level;;) {
		if (!pcrLCB) {
			ERROROUT2(FORMAT(412),msg,level);	/* %sx(%d)I[ołB */
			return err;
		}

DEBUGOUTL4(200,"_set_up_level: pcrLCB=%08x n=%d cid=%08x %s",pcrLCB,n,pcrLCB->cid,cl_gets_cmd_name(pcrLCB->cid));

		if ((cid=pcrLCB->cid)==C_TRY) {
			rc = cl_pop_finally(proc,pcrLCB);
			if (rc) {
				if (rc == C_FINALLY) {
					_push_break(leaf,proc,n,cmd);
				}
				return rc;
			}
		}
#if 0	/* 2017.3.21 */
		else if (cmd == C_SWITCH) {
			if (cmd == C_SWITCH) break;
			else if (cid==C_LOOP || cid==C_FOR || cid==C_DO) return -1;
		}
		else if (cid==C_LOOP || cid==C_FOR || cid==C_DO) {
#endif
		else if (cid==C_LOOP || cid==C_FOR || cid==C_DO || cid==C_SWITCH) {
			if (--n <= 0) break;
		}
		pcrLCB->iUsed = 0;
		pcrLCB = pcrLCB->preBlockCB;
	}
	proc->pcrBlockCB = pcrLCB;
	return 0;
}

/************************************/
/* cl_process_break                 */
/************************************/
int cl_process_break(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc,cmd;
	BlockCB *pIfCB;

	if (!leaf || !proc) return ECL_SYSTEM_ERROR;
#if 1

DEBUGOUTL3(110,"cl_process_break: sub_cmd=%08x %s parnum=%d",
leaf->cmd.sub_cid,cl_gets_cmd_name(leaf->cmd.sub_cid),leaf->cmd.parnum);

	rc = 0;
	if ((cmd=leaf->cmd.sub_cid) > 0) ;
	else {
		if (!(pIfCB = _check_in_loop_switch(proc))) {
			ERROROUT("Outside of loop or switch!!");
			rc = ECL_SCRIPT_ERROR;
		}
		cmd = pIfCB->cid;
	}
#else
	if (!(pIfCB = proc->pcrBlockCB)) return -1;
	if (pIfCB->cid == C_SWITCH) {
		rc = _set_up_level(leaf,proc,0,"cl_process_break: ",ECL_EX_BREAK);
		if (!rc) {
			pIfCB->iLoopMax = C_BREAK;
			proc->Nextleaf = cl_ret_leaf_pop(proc);
		}
		else if (rc == C_SKIP_COMMAND) rc = 0;
		return rc;
	}
	rc = _check_in_loop(proc);
#endif
	if (!rc) {
		rc = _set_up_level(leaf,proc,0,"cl_process_break: ",ECL_EX_BREAK,cmd);

DEBUGOUTL1(110,"cl_process_break: rc=%d",rc);

		if (!rc) {
			if (!(pIfCB = proc->pcrBlockCB)) return -1;
			if (pIfCB->cid == C_SWITCH) {
				pIfCB->iLoopMax = C_BREAK;
			/*	proc->Nextleaf = cl_ret_leaf_pop(proc);	*/
				rc = cl_set_continue(leaf,proc);
			}
			else {
				pIfCB->iLoopCounter = 0x7ffffffe;
				cmn_set_stat(BRK_PR,&proc->ptype,L_ON);
				rc = cl_set_continue(leaf,proc);
			}
		}
		else if (rc == C_SKIP_COMMAND) rc = 0;
		else if (rc == C_FINALLY) {
			cmn_set_stat(BRK_PR,&proc->ptype,L_ON);
			rc = 0;
		}
	}
	return rc;
}

/************************************/
/* cl_set_continue					*/
/************************************/
int cl_set_continue(leaf,proc)
Leaf    *leaf;
ProcCT  *proc;
{
	int rc;
	BlockCB *pcrLCB;
	Leaf   *loop_leaf,*leafw;

	loop_leaf = NULL;
	if (pcrLCB=proc->pcrBlockCB) {
		if (pcrLCB->iUsed) loop_leaf = pcrLCB->Blockleaf;
	}

DEBUGOUTL3(110,"cl_set_continue: pcrLCB=%08x iUsed=%d loop_leaf=%08x",pcrLCB,pcrLCB->iUsed,loop_leaf);

	if (loop_leaf) {
		while (leafw=cl_ret_leaf_pop(proc)) {

DEBUGOUTL1(190,"cl_set_continue: leafw=%08x",leafw);

			if (leafw == loop_leaf) break;
		}
		if (leafw) {
			proc->Nextleaf = loop_leaf;
DEBUGOUTL1(190,"cl_set_continue: found leaf=%08x",loop_leaf);
			rc = 0;
		}
		else rc = ECL_SYSTEM_ERROR;
	}
	else rc = ECL_SYSTEM_ERROR;
	return rc;
}

/************************************/
/* cl_process_continue                */
/************************************/
int cl_process_continue(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	return cl_pr_continue(leaf,proc,0);
}

/************************************/
/* cl_pr_continue						*/
/************************************/
int cl_pr_continue(leaf, proc, ip)
Leaf    *leaf;
ProcCT  *proc;
int      ip;
{
	int rc;
	BlockCB *pIfCB;

	if (leaf && proc) {
#if 1	/* 2017.3.12 */
		if (!(pIfCB = _check_in_loop_switch(proc))) {
			ERROROUT("Outside of loop or switch!!");
			rc = ECL_SCRIPT_ERROR;
		}
		else {
#else
		rc = _check_in_loop(proc);
		if (!rc) {
#endif
			rc = _set_up_level(leaf,proc,ip,"cl_pr_continue: ",ECL_EX_CONTINUE,0);
#if 1	/* 2017.3.12 */
			if (!rc) {
				if (!(pIfCB = proc->pcrBlockCB)) return -1;
				if (pIfCB->cid == C_SWITCH) {
					pIfCB->iLoopMax = C_BREAK;
					proc->Nextleaf = cl_ret_leaf_pop(proc);
				}
				else
					rc = cl_set_continue(leaf,proc);
			}
#else
			if (!rc) rc = cl_set_continue(leaf,proc);
#endif
 			else if (rc == C_SKIP_COMMAND) rc = 0;
			else if (rc == C_FINALLY) {
				cmn_set_stat(BRK_PR,&proc->ptype,L_ON);
				rc = 0;
			}
		}
	}
	else rc = ECL_SYSTEM_ERROR;

	return rc;
}
