static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************************************
*																			*
*	ړI@F mojiZ												*
*																			*
*	֐@  F int cl_cmpt_string(pAns, pOprtr, pInfoParm1, pInfoParm2)	*
*				(O)char		*pAns											*
*				(I)char  	*pOprtr											*
*				(I)tdtInfoParm *pInfoParm1									*
*				(I)tdtInfoParm *pInfoParm2									*
*																			*
*	߂l@@F ERROR														*
*				 NORMAL														*
*																			*
*	Tv@F															*
*																			*
*****************************************************************************/
#include <colmn.h>

#define ARGSEP  '&'
#define ARGSEP2 '@'
#define ARGPOS  '&'
#define ARGPOS2 '@'
extern CLPRTBL  *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern CLCOMMON CLcommon;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_string(pAns, pOprtr, pInfoParm1, pInfoParm2, nparm0, prmp)
	char		**pAns;
	char		*pOprtr;
	tdtInfoParm	*pInfoParm1;
	tdtInfoParm	*pInfoParm2;
	int nparm0;
	parmList  *prmp[];
{
	int rc,len,bmode,mflg,nparm;
	char *p;
	tdtInfoParm InfoParm3,*pInfoParm3;
	tdtInfoParm **ppParm,*pParm,*ppParm0[2],pParm0[2];

DEBUGOUTL2(120,"cl_cmpt_string:Enter nparm=%d pOprtr=[%s]",nparm,pOprtr);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_cmpt_string: pInfoParm1=",pInfoParm1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_cmpt_string: pInfoParm2=",pInfoParm2,0,0);

	if (pAns) *pAns = NULL ;
	else {
		ERROROUT("pAns == NULL");
		return (-1);
	}
	nparm = nparm0;
	bmode = 0;
	mflg = pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX;
	if (!stricmp(pOprtr,"CONCAT") || !stricmp(pOprtr,"&+") || !stricmp(pOprtr,"|+")) {
		rc=concat(pAns,pInfoParm1,pInfoParm2,nparm,prmp,NULL);
	}
	else if (!stricmp(pOprtr,"SUBSTR") || (bmode=!stricmp(pOprtr,"SUBSTRB")) ||
	         !stricmp(pOprtr,"MID")    || (bmode=!stricmp(pOprtr,"MIDB"))) {
		if (nparm>0) {
			if ((rc=cl_gx_exp_obj_opt(1,&prmp[0],NULL,&InfoParm3,0)) < 0) return rc;
			pInfoParm3 = &InfoParm3;
		}
		else pInfoParm3 = NULL;
		if (bmode) mflg = 0;
		rc=substrm(pAns,mflg,pInfoParm1,pInfoParm2,pInfoParm3);
	}
	else if (!stricmp(pOprtr,"REP"))
		rc=replace(pAns,pInfoParm1,pInfoParm2);
	else if (!stricmp(pOprtr,"CONDAS"))			/* K-00044 */
		rc=condas(pAns,pInfoParm1,pInfoParm2);
	else {
		pParm = pParm0;
		ppParm = ppParm0;
		nparm = 2;
		cl_gx_copy_info(&pParm[0],pInfoParm1);
		cl_gx_copy_info(&pParm[1],pInfoParm2);
		ppParm[0] = pInfoParm1;
		ppParm[1] = pInfoParm2;
		if (!stricmp(pOprtr,"TRIM"))
			rc = cl_trim(pAns,nparm,ppParm);
		else if (!stricmp(pOprtr,"STRINGS"))
			rc = cl_strings(pAns,nparm,ppParm);
		else if (!stricmp(pOprtr,"LEFT") || (bmode=!stricmp(pOprtr,"LEFTB"))) {
			if (bmode) mflg = 0;
			rc = cl_leftm(pAns,mflg,nparm,ppParm);
		}
		else if (!stricmp(pOprtr,"RIGHT") || (bmode=!stricmp(pOprtr,"RIGHTB"))) {
			if (bmode) mflg = 0;
			rc = cl_rightm(pAns,mflg,nparm,ppParm);
		}
/*
		else if (!stricmp(pOprtr,"EDIT"))
			rc = cl_edit(pAns,nparm,ppParm);
*/
		else {
#if 1	/* 2021.4.23 */
			rc = cl_gx_bexp_func_bexp(&InfoParm3,pInfoParm1,pOprtr,pInfoParm2,nparm0,prmp);
			*pAns = InfoParm3.pi_data;
#else
			/* cl_cmpt_string: ZqɌ肪܂B */
			ERROROUT2(FORMAT(245),"cl_cmpt_string",pOprtr);
			*pAns = NULL ;
			return( -1 );
#endif
		}
	}
if (*pAns) {
	ParList2 par2;
	p = *pAns;
	cl_sep_string_with_type(&par2,p,strlen(p));
	DEBUGOUTL2(120,"cl_cmpt_string:Exit rc=%d *p=[%s]",rc,par2.par);
}
else DEBUGOUTL1(120,"cl_cmpt_string:Exit rc=%d *pAns=NULL",rc);
	return (rc);
}

/****************************************/
/*										*/
/****************************************/
int concat(pAns, pInfoParm1, pInfoParm2, nparm, prmp, pParm)
char		**pAns;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int nparm;
parmList  *prmp[];
tdtInfoParm	*pParm;
{
	static char *_fn_ = "concat";
	int rc,len1,i,max_layer,code_type,mcode[2];
	char *p1,*pWork,*p;
	parmList **prmpW;
	tdtInfoParm *pParmW,*pParm12[2],*pInfo;
	tdtIterate_ctl tIter_ctl;
	tdtIterate *pIter;

DEBUGOUTL5(180,"concat:Enter pInfoParm1=%08x pInfoParm2=%08x nparm=%d prmp=%08x pParm=%08x",
pInfoParm1,pInfoParm2,nparm,prmp,pParm);

	pWork = NULL;
	*pAns = pWork;
	rc = 0;
	code_type = -1;
	max_layer = -1;
	len1 = 0;
	pParm12[0] = pInfoParm1;
	pParm12[1] = pInfoParm2;
	mcode[0] = code_type;
	mcode[1] = 0;
	for (i=0;i<2;i++) {
		if (pParmW=pParm12[i]) {
			if ((rc=cl_iterate_info_init(&tIter_ctl,NULL,pParmW,max_layer)) < 0) goto err;
			for (;;) {
				if ((rc=cl_iterate_info(&tIter_ctl)) < 0) goto err;
				pIter = tIter_ctl.itc_pIter;
				if (!(pInfo=pIter->it_pInfo)) break;
			/*	if (!i) code_type = cl_get_char_code_type(pInfo,2);	*/
				if ((rc=cl_concat_info(&pWork,len1,pInfo,mcode)) < 0) goto err;
				len1 = rc;
			}
		}
	}
	prmpW = NULL;
	pParmW = NULL;
	for (i=0;i<nparm;i++) {
		if (pParm) pParmW = &pParm[i];
		else prmpW = &prmp[i];
		if ((rc=cl_iterate_info_init(&tIter_ctl,prmpW,pParmW,max_layer)) < 0) goto err;
		for (;;) {
			if ((rc=cl_iterate_info(&tIter_ctl)) < 0) goto err;
			pIter = tIter_ctl.itc_pIter;
			if (!(pInfo=pIter->it_pInfo)) break;
			if ((rc=cl_concat_info(&pWork,len1,pInfo,mcode)) < 0) goto err;
			len1 = rc;
		}
	}
	p1 = pWork;
	if (pWork = cl_tmp_const_malloc(len1+3)) {
		p = pWork;
		code_type = mcode[0];
		if (code_type < 0) code_type = 0;
		p = cl_set_type_to_string(p,len1,code_type);
		memzcpy(p,p1,len1);
	}
	else rc = ECL_MALLOC_ERROR;
	if (p1) Free(p1);
	*pAns = pWork;
err:

DEBUGOUTL3(180,"%s:Exit rc=%d pWork=%08x",_fn_,rc,pWork);

	if (rc<0 && pWork) {
		Free(pWork);
		*pAns = NULL;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_concat_info(ppWork,len1,pInfoParmW,mcode)
char **ppWork;
int len1,mcode[];
tdtInfoParm	*pInfoParmW;
{
	static char *_fn_ = "concat_info";
	int len,len2,code_type,type,iM1,iM2;
	char id,*p2,*pWork;

DEBUGOUTL3(180,"%s:Enter len1=%d pInfoParmW=%08x",_fn_,len1,pInfoParmW);

	if (!pInfoParmW) return len1;

	code_type = mcode[0];
	iM1 = mcode[1];
	pWork = *ppWork;
	id = pInfoParmW->pi_id;

DEBUGOUTL2(180,"%s: id=[%c]",_fn_,id);

	if (id == 'S') {
		pInfoParmW = (tdtInfoParm *)pInfoParmW->pi_pos;
		id = pInfoParmW->pi_id;

DEBUGOUTL2(180,"%s: id=[%c]",_fn_,id);

	}

DEBUGOUT_InfoParm(180,"%s: pInfoParmW=",pInfoParmW,_fn_,0);

	if (cl_is_undef_parm(pInfoParmW) || cl_is_null_parm(pInfoParmW)) ;
	else if (id == ' ') {
		p2 = NULL;
		if ((len2=parm_to_char(pInfoParmW,&p2,NULL)) < 0) {
			len1 = -1;
		}
		else {
			type = cl_get_char_code_type(pInfoParmW,1);
			iM2 = cl_is_mbyte(pInfoParmW,type);
			if (code_type < 0) code_type = type;
			else if (iM1 | iM2) {
				if (akxq_code_type_cmp(code_type,type)) {
					ERROROUT3(FORMAT(648),_fn_,code_type,type);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
					return ECL_SCRIPT_ERROR;
				}
			}
			mcode[0] = code_type;
			mcode[1] = iM1 | iM2;
			len = len1+len2;
			if (!(pWork = MRealloc(pWork,len+1))) {
				ERROROUT("concat: malloc error");
				len1 = ECL_MALLOC_ERROR;
			}
			else {
				memzcpy(pWork+len1,p2,len2);
				len1 = len;

DEBUGOUTL4(180,"%s: len2=%d len1=%d pWork=[%s]",_fn_,len2,len1,pWork);

			}
		}
	}
	if (len1 < 0) {
		if (pWork) Free(pWork);
		pWork = NULL;
	}
	*ppWork = pWork;

DEBUGOUTL3(180,"%s:Exit len1=%d pWork=%08x",_fn_,len1,pWork);

	return len1;
}

/****************************************/
/*										*/
/****************************************/
int substr_mlen(par2,p1,len1,msp,mn)
ParList2 *par2;
char *p1;
int  len1,msp,mn;
{
	int i,n,m,code_type;
	char *p,*psp;

	if (mn <= 0) {
		psp = NULL;
		n = 0;
	}
	else {
		code_type = GET_TYPE_OPT(par2->option);
		p = p1;
		for (i=1;i<msp;i++) {
			if (m=akxqismbs(code_type,p)) p += m;
			else p++;
		}
		psp = p;
		n = 0;
		for (i=0;i<mn;i++) {
			if (m=akxqismbs(code_type,p)) {
				p += m;
				n += m;
			}
			else {
				p++;
				n++;
			}
		}
	}
	par2->par = psp;
	par2->parlen = n;
	return n;
}

/****************************************/
/*										*/
/****************************************/
int substr_len(mflg,par2,pInfoParm1,pInfoParm2,pInfoParm3)
int mflg;
ParList2 *par2;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
tdtInfoParm *pInfoParm3;
{
	int  rc,len1,len2,value,sp,n,i,mlen,attr,code_type;
	char w1[16],w2[26],*p1,*p2,*psp,*p;
	char *pAns;

	rc = NORMAL;
	p1 = w1;
	if ((len1 = parm_to_char(pInfoParm1,&p1,NULL))<0) {
		return len1;
	}
/*
akxaxdump("p1",p1,len1);
*/
	code_type = cl_get_char_code_type(pInfoParm1,1);
	if (mflg) {
		mlen = akxqmlen_type(p1,len1,code_type);
		if (mlen == len1) mflg = 0;
		else len1 = mlen;
	}
	if ((attr=pInfoParm2->pi_attr)==DEF_ZOK_BINA ||
	     attr == DEF_ZOK_FLOA || attr == DEF_ZOK_DECI) {
		if (rc = cl_get_parm_bin(pInfoParm2,&sp,"substr.p2")) return rc;
		if (sp < 0) sp = len1+sp+1;
		if ((n=len1-sp+1)<0) n=0;
/*
printf("substr parm2 bin:sp=%d n=%d\n",sp,n);
*/
	}
	else if (attr == DEF_ZOK_CHAR) {
		if ((len2=pInfoParm2->pi_dlen)>25) len2=25;
		memcpy(w2,pInfoParm2->pi_data,len2);
		w2[len2]='\0';
		for (i=0;i<len2;i++) {
			if (w2[i]==',') break;
		}
		rc = axccvn(10,w2,i,&sp);
		if (rc == -1) sp = 1;
		else if (rc>0 || rc< -1) {
			ERROROUT(FORMAT(281));	/* Jnʒuł͂܂B */
			return -1;
		}
		if (sp < 0) sp = len1+sp+1;
		if (i>=len2-1) {
			if ((n=len1-sp+1)<0) n=0;
		}
		else {
			rc = axccvn(10,w2+i+1,len2-(i+1),&n);
			if (rc>0 || rc< -1) {
				ERROROUT(FORMAT(282));	/* ł͂܂B */
		 		return -1;
	 		}
			else if (rc == -1) {
				if ((n=len1-sp+1)<0) n=0;
			}
			if (n>(len1-sp+1)) n=len1-sp+1;
		}
/*
printf("substr parm2 char:sp=%d n=%d\n",sp,n);
*/
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),"substr_len",attr);
		 return -1;
	}
	if (pInfoParm3) {
		if (pInfoParm3->pi_dlen > 0) {
			if (rc = cl_get_parm_bin(pInfoParm3,&n,"substr.p3")) return rc;
		}
		else n=len1-sp+1;
/*
printf("substr parm3:n=%d\n",n);
*/
		if (n>(len1-sp+1)) n=len1-sp+1;
	}
	par2->option = SET_TYPE_OPT(code_type);
	if (n<0) n=0;
	if (sp<1 || sp>len1) n=0;
	if (mflg) {
		n = substr_mlen(par2,p1,len1,sp,n);
		psp = par2->par;
	}
	else psp=p1+sp-1;
	if (!(p = cl_tmp_const_malloc(n+1))) {
		ERROROUT("substr:malloc error");
	 	return ECL_MALLOC_ERROR;
	}
	pAns = p;
#if 0
	if (n>0) {
		p = cl_set_type_to_string(p,n,code_type);
		memzcpy(p,psp,n);
	}
	else *pAns='\0';
#else
	if (n>0) memcpy(pAns,psp,n);
	*(pAns+n)='\0';
#endif
/*
printf("substr:p=[%s] sp=%d n=%d\n",p1,sp,n);
printf("substr:pAns=[%s]\n",pAns);
*/
	par2->par = pAns;
	par2->parlen = n;

	return NORMAL;
}

/****************************************/
/*										*/
/****************************************/
int substrm(pAns, mflg, pInfoParm1, pInfoParm2, pInfoParm3)
char **pAns;
int  mflg;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
tdtInfoParm *pInfoParm3;
{
	int ret,n;
	char *p;
	ParList2 par2;

	ret = substr_len(mflg,&par2,pInfoParm1,pInfoParm2,pInfoParm3);
	if ((n=par2.parlen) > 0) {
		if (!(p = cl_tmp_const_malloc(n+3))) {
			ERROROUT("substrm: malloc error");
			return ECL_MALLOC_ERROR;
		}
		*pAns = p;
		p = cl_set_type_to_string(p,n,GET_TYPE_OPT(par2.option));
		memzcpy(p,par2.par,n);
	}
	else *pAns = par2.par;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int substr(pAns, pInfoParm1, pInfoParm2, pInfoParm3)
char **pAns;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
tdtInfoParm *pInfoParm3;
{
	return substrm(pAns,pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX
	              ,pInfoParm1,pInfoParm2,pInfoParm3);
}

/****************************************/
/*										*/
/****************************************/
int replace(pAns, pInfoParm1, pInfoParm2)
char **pAns;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
{
	static char *_fn_ = "replace";
	int  rc,len1,len2,value,i,j,index,attr,code_type1,code_type2,m,iM1,iM2;
	char w1[16],w2[16],*p1,*p2,*p,argpos,*p0,c;
	struct ume {
		int spi;
		int len;
	} *pp;

	rc = NORMAL;
	if ((attr=pInfoParm1->pi_attr) == DEF_ZOK_BINA) {
		value = cl_get_data_long(pInfoParm1);
		cmn_i_to_a(value,w1);
		p1   = w1;
		len1 = strlen(w1);
	}
	else if (attr == DEF_ZOK_CHAR) {
		p1   = pInfoParm1->pi_data;
		len1 = pInfoParm1->pi_dlen;
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),_fn_,attr);
		return -1;
	}
	if ((attr=pInfoParm2->pi_attr) == DEF_ZOK_BINA) {
		value = cl_get_data_long(pInfoParm2);
		cmn_i_to_a(value,w2);
		p2   = w2;
		len2 = strlen(w2);
	}
	else if (attr == DEF_ZOK_CHAR) {
		p2   = pInfoParm2->pi_data;
		len2 = pInfoParm2->pi_dlen;
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),_fn_,attr);
	}
	code_type1 = cl_get_char_code_type(pInfoParm1,1);
	code_type2 = cl_get_char_code_type(pInfoParm2,1);
	iM1 = cl_is_mbyte(pInfoParm1,code_type1);
	iM2 = cl_is_mbyte(pInfoParm2,code_type2);
printf("%s: code_type1=%d code_type2=%d iM1=%d iM2=%d\n",_fn_,code_type1,code_type2,iM1,iM2);
/*	if (code_type1 != code_type2) {	*/
	if ((iM1 | iM2) && akxq_code_type_cmp(code_type1,code_type2)) {
		ERROROUT3(FORMAT(648),_fn_,code_type1,code_type2);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
		return ECL_SCRIPT_ERROR;
	}

	if (!(p0 = *pAns = cl_tmp_const_malloc(len1+len2+3))) {
		ERROROUT("replace: malloc error");
		return -1;
	}
	p = cl_set_type_to_string(p0,len1+len2,code_type1);
	value=0;
#if 1	/* 2022.11.30 */
	i = 0;
	while (i < len2-1) {
		m = akxqmbsnlen(code_type1,p2+i,len2-i);
		if (m == 1) {
			if ((c=p2[i])==ARGSEP || c==ARGSEP2) {
				i++;
				m = akxqmbsnlen(code_type1,p2+i,len2-i);
				if (m == 1) {
					if (p2[i] == c) {
						value++;
					}
					i++;
				}
				else i += m;
			}
			else i++;
		}
		else i += m;
	}
#else
	for (i=0;i<len2-1;i++) {
		if (((p2[i]==ARGSEP)&&(p2[i+1]==ARGSEP)) ||
			((p2[i]==ARGSEP2)&&(p2[i+1]==ARGSEP2))) {
			i++;
			value++;
		}
	}
#endif
	if (!(pp = (struct ume *)Malloc((value+1)*8))) {
		ERROROUT("replace: malloc error");
		Free(p);
		*pAns = NULL;
		return -1;
	}
	value=0;
	pp[value].spi=0;
#if 1	/* 2022.11.30 */
	i = 0;
	while (i < len2-1) {
		m = akxqmbsnlen(code_type1,p2+i,len2-i);
		if (m == 1) {
			if ((c=p2[i])==ARGSEP || c==ARGSEP2) {
				i++;
				m = akxqmbsnlen(code_type1,p2+i,len2-i);
				if (m == 1) {
					if (p2[i] == c) {
						pp[value].len=i-1-pp[value].spi;
						pp[++value].spi=i+1;
					}
					i++;
				}
				else i += m;
			}
			else i++;
		}
		else i += m;
	}
#else
	for (i=0;i<len2-1;i++) {
		if (((p2[i]==ARGSEP)&&(p2[i+1]==ARGSEP)) ||
			 ((p2[i]==ARGSEP2)&&(p2[i+1]==ARGSEP2))) {
			pp[value].len=i-pp[value].spi;
			i++;
			pp[++value].spi=i+1;
		}
	}
#endif
	pp[value].len=len2-pp[value].spi;
	if (pp[value].len>0) value++;
	for (i=0;i<len1;i++) {
#if 1	/* 2022.11.30 */
		m = akxqmbsnlen(code_type1,p1+i,len1-i);
		if (m > 1) {
			memcpy(p,p1+i,m);
			p += m;
			i += m - 1;
			continue;
		}
#endif
		if ((p1[i]!=ARGPOS) && (p1[i]!=ARGPOS2)) {
			*p++ = p1[i];
			continue;
		}
		argpos = p1[i];
		if (i<len1-1 && p1[i+1]>='0' && p1[i+1]<='9') {
			for (j=i+2;j<len1;j++) {
				if (p1[j]<'0' || p1[j]>'9')
					break;
			}
			if (j<len1 && p1[j]==argpos) {
				if (axccvn(10,p1+i+1,j-(i+1),&index)) {
					/* replace: uw肪ł͂܂B */
					ERROROUT(FORMAT(284));
					Free(p0);
					Free(pp);
					*pAns = NULL;
	 				return( -1 );
				}
				if (index<value) {
					memcpy(p,p2+pp[index].spi,pp[index].len);
					p+=pp[index].len;
					i=j;
					continue;
				}
				else if ( argpos == ARGPOS ) {
					i = j;
					continue;
				}
			}
		}
		*p++ = argpos;
	}
	*p='\0';
	Free(pp);
	return( NORMAL );
}

/****************************************/
/*										*/
/****************************************/
int condas(pAns, pInfoParm1, pInfoParm2)
char **pAns;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
{
	static char *_fn_ = "condas";
	int  rc,len1,len2,value,i,flag,attr,code_type1,code_type2,m,iM1,iM2;
	char w1[16],w2[26],*p1,*p2,*p2w,sepc,*peq,*pt,*pf;
	char *p,*p1w,*p0;

	p1w = p2w = NULL;
	rc = -1;
	p1 = w1;
	if ((len1 = parm_to_char(pInfoParm1,&p1,NULL))<0) {
		return rc;
	}

	if ((attr=pInfoParm2->pi_attr)==DEF_ZOK_CHAR && pInfoParm2->pi_dlen>2) {
		p2   = pInfoParm2->pi_data;
		len2 = pInfoParm2->pi_dlen;
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),_fn_,attr);
		goto err;
	}
	code_type1 = cl_get_char_code_type(pInfoParm1,1);
	code_type2 = cl_get_char_code_type(pInfoParm2,1);
	iM1 = cl_is_mbyte(pInfoParm1,code_type1);
	iM2 = cl_is_mbyte(pInfoParm2,code_type2);
/*	if (code_type1 != code_type2) {	*/
	if ((iM1 | iM2) && akxq_code_type_cmp(code_type1,code_type2)) {
		ERROROUT3(FORMAT(648),_fn_,code_type1,code_type2);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
		return ECL_SCRIPT_ERROR;
	}
	m = akxqmbsnlen(code_type2,p2,len2);
	if (m != 1) {
		ERROROUT("condas: no 1st seperator.");
		goto err;
	}
	if (!(p2w = Malloc(len2+1))) {
		ERROROUT("condas: p2w malloc error");
		goto err;
	}
	memcpy(p2w,p2,len2);
	*(p2w+len2) = '\0';
	sepc = *p2w;
	pt = peq = p2w + 1;
	i = 1;
	for (;i<len2;i++,pt++) {
		m = akxqmbsnlen(code_type2,pt,len2-i);
		if (m == 1) {
			if (*pt == sepc) break;
		}
		else {
			m--;
			pt += m;
			i  += m;
		}
	}
	if (i>=len2) {
		ERROROUT("condas: no 2nd seperator.");
		goto err;
	}
	*pt++ = '\0';
/*
printf("%s:1 i=%d pt=[%s]\n",_fn_,i,pt);
*/
	i++;
	pf = pt;
	for (;i<len2;i++,pf++) {
		m = akxqmbsnlen(code_type2,pf,len2-i);
		if (m == 1) {
			if (*pf == sepc) break;
		}
		else {
			m--;
			pf += m;
			i  += m;
		}
	}
	if (i>=len2) {
		ERROROUT("condas: no 3rd seperator.");
		goto err;
	}
	*pf++ = '\0';
/*
printf("%s:2 i=%d pf=[%s]\n",_fn_,i,pf);
*/
	if (strcmp(p1,peq))
		p2 = pf;
	else
		p2 = pt;
	p = p2;
/*
printf("%s:3 len2=%d p=[%s]\n",_fn_,len2,p);
*/
	while (*p) {
		if (i > len2) break;
		m = akxqmbsnlen(code_type2,p,len2-i);
/*
printf("%s:4 i=%d m=%d\n",_fn_,i,m);
*/
		if (m > 1) {
			p += m;
			i += m;
		}
		else if (*p == '%') {
			p++;
			i++;
			m = akxqmbsnlen(code_type2,p,len2-i);
/*
printf("%s:5 i=%d m=%d\n",_fn_,i,m);
*/
			if (m > 1) {
				p += m;
				i += m;
			}
			else {
				if (*p=='q') {
					*p = 's';
					if (len1==0) break;
					len1 += len1;
					if (!(p1w = Malloc(len1+1))) {
						ERROROUT("condas: p1w malloc error");
						goto err;
					}
					p = p1w;
					while (*p++ = *p1) {
						if (*p1++ == M_QUOTE1) *p++ = M_QUOTE1;
					}
					*p = '\0';
					p1 = p1w;
					break;
				}
				p++;
				i++;
			}
		}
		else {
			p++;
			i++;
		}
	}

	if (*pAns = p0 = cl_tmp_const_malloc(len1+len2+3)) {
		p = cl_set_type_to_string(p0,len1+len2,code_type1);
		sprintf(p,p2,p1);
		rc = 0;
	}
	else ERROROUT("condas: pAns malloc error");

err:
	if (p1w) Free(p1w);
	if (p2w) Free(p2w);
	return rc;
}

/********************************************************/
/*	l̂Ƃ́Ap1_len>0  *p1<>NULLȂ*p1ɕԂB*/
/*	p1_len=0 Ȃ *p1͐ݒ肵ȂĂ悢					*/
/********************************************************/
int cl_parm_to_char_opt(pInfoParm1,p1,p1_len,p1_free)
tdtInfoParm	*pInfoParm1;
char **p1, **p1_free;
int p1_len;
{
	int len1, ret, attr,iP1USE, im, opt, dec_pre, pre, size, p_len;
	long value;
	char *p,*pp,wrk[10];
	double dValue,dw;
	MPA *mpa;
/*
printf("parm_to_char: pInfoParm1=%08x p1=%08x p1_len=%d p1_free=%08x\n",pInfoParm1,p1,p1_len,p1_free);
*/
	if (!pInfoParm1 || !p1) return -1;
	if (p1_len>0 && *p1) {
		iP1USE = p1_len;
		**p1 = '\0';
		p_len = p1_len;
	}
	else {
		iP1USE = 0;
		p_len = 32;
	}
	if (p1_free) {
		im = D_OPT_ALC_MALLOC;
		*p1_free = NULL;
	}
	else im = D_OPT_ALC_TMP;
	if (ret=cl_check_data_id(pInfoParm1,0)) return ret+ECL_CHK_VAR_ERROR;
	if ((attr=pInfoParm1->pi_attr) == DEF_ZOK_BINA) {
		value = cl_get_data_long(pInfoParm1);
		if (iP1USE) p = *p1;
		else {
			if (!(p = cl_opt_malloc(im,p_len))) {
				ERROROUT("parm_to_char: BINA p cl_opt_malloc error");
				return -1;
			}
			*p1 = p;
			if (p1_free) *p1_free = p;
		}
		if (pInfoParm1->pi_scale & D_DATA_UNSIGNED) akxcultoa(value,p,10,p_len);
		else akxcltoa(value,p,10,p_len);
		len1 = strlen(p);
/*
printf("parm_to_char: p=[%s]\n",p);
*/
	}
	else if (attr == DEF_ZOK_FLOA) {
		memcpy(&dValue,pInfoParm1->pi_data,sizeof(double));
		if (iP1USE) p = *p1;
		else {
			if (!(p = cl_opt_malloc(im,p_len))) {
				ERROROUT("parm_to_char: FLOA p cl_opt_malloc error");
				return -1;
			}
			*p1 = p;
			if (p1_free) *p1_free = p;
		}
		if ((len1=cl_double_to_str(p,p_len,dValue)) < 0) return len1;
	}
	else if (attr == DEF_ZOK_DECI) {
		mpa = (MPA *)pInfoParm1->pi_data;
		size = pGlobTable->options[19] & 0xffff;
		pre = size & 0xff;
		dec_pre = pInfoParm1->pi_hlen;
		if ((opt = pGlobTable->options[10]) & 0x40) {
			if (pre > 0) len1 = pre;
			else len1 = mpa->len;
			len1 += 8;
		}
		else {
			if ((len1=mpa->exp*2) < 0) len1 = -len1;
			len1 += mpa->len*2 + 4 + dec_pre;	/* ȂƂ\Ȓ */
		}
/*
printf("parm_to_char: len1=%d\n",len1);
*/
		if (!(p = cl_opt_malloc(im,len1))) {
			ERROROUT("parm_to_char: DECI p cl_opt_malloc error");
			return -1;
		}
		len1 = cl_mpa2an(mpa,p,len1,0,dec_pre,pInfoParm1->pi_pos);
		*p1 = p;
		if (p1_free) *p1_free = p;
	}
	else if (attr == DEF_ZOK_CHAR) {
		len1 = pInfoParm1->pi_dlen;
/*
printf("parm_to_char: attr=%d len1=%d\n",attr,len1);
*/
		pp = pInfoParm1->pi_data;
		if (pInfoParm1->pi_alen & D_AULN_RANGE_DATA) len1 = akxstrnlen(pp,len1);
		if (len1 > 0) {
			*p1 = pp;
/*
printf("parm_to_char: p1=[%s]\n",*p1);
*/
			/* 0x80nmłȂƂ́A̍ŌɃkȂ\̂
			   stringɕϊ */
			if (p1_len<0 || !(pInfoParm1->pi_scale & 0x80)) {
				if (!(p = cl_opt_malloc(im,len1+1))) {
					ERROROUT("parm_to_char: CHAR p cl_opt_malloc error");
					return -1;
				}
				memzcpy(p,pp,len1);
				*p1 = p;
				if (p1_free) *p1_free = p;
			}
		}
		else *p1 = "";
	}
	else if (attr == DEF_ZOK_BULK) {
		len1 = pInfoParm1->pi_dlen;
		if (len1>0) {
			if (!(p = cl_opt_malloc(im,len1*D_BULK_TYPE+1))) {
				ERROROUT("parm_to_char: BULK p cl_opt_malloc error");
				return -1;
			}
			len1 = clcnvtb2c(pInfoParm1->pi_data,len1,p);
			*p1 = p;
			if (p1_free) *p1_free = p;
		}
	}
	else if (attr == DEF_ZOK_DATE) {
		if (!(p = cl_opt_malloc(im,20))) {
			ERROROUT("parm_to_char: DATE p cl_opt_malloc error");
			return -1;
		}
		len1 = akxc_date2uxstr(p,20,NULL,pInfoParm1->pi_data);
		*p1 = p;
		if (p1_free) *p1_free = p;
	}
	else if (attr) {
		/* %s: p[^̌^(%d)Ă܂B */;
		ERROROUT2(FORMAT(285),"parm_to_char",attr);
		 return -1;
	}
	else {
		/* parm_to_char: ϐ܂̓f[^`łB */
		ERROROUT(FORMAT(286));
		 return ECL_NDEFVAR_ERROR;
	}
/*
printf("parm_to_char:Exit len1=%d\n",len1);
*/
	return len1;
}

/****************************************/
/*										*/
/****************************************/
int cl_double_to_str(s,s_len,dValue)
char *s;
int s_len;
double dValue;
{
	int pre,len1,pos1,pos2,pos3,inx,pre1,inx1,n,leng,pos20,pre2,sei,ret,opt;
	int opt11,iZSUP;
	char *p,*p1,*pp,wrk[10],buf[30];
	double dw;
	MPA10W wz,*w;

	if (!s || s_len<2) return -1;

	opt = cl_get_option(20,0) & 0xffff;
	pre = opt & 0xff;
	inx = opt>>8;
	if (pre > 0) {
		if (pre > MAXDBLPRE) pre = MAXDBLPRE;
		iZSUP = 0;
	}
	else {
		if (dValue == 0.0) {
			s_len--;
			strnzcpy(s,"0.0",s_len);
			return strlen(s);
		}
		pre = MAXDBLPRE;
		iZSUP = 0x0100;
	}
	pre2 = pre + 2;
	len1 = s_len - 7;
	if (pre2 > len1) pre2 = len1;
	sprintf(wrk,"%%.%de",pre2);
	snprintf(s,s_len,wrk,dValue);
	len1 = strlen(s);
/*
printf("cl_double_to_str: s_len=%d pre=%d pre2=%d len1=%d s=[%s]\n",s_len,pre,pre2,len1,s);
*/
	w = (MPA10W *)cl_get_tmpMPA10W2(&wz,1);
	ret = m_an_to_mpa10_opt(w,s,s_len,0);
	opt11 = cl_get_option(11,0);
	opt = opt11 | (cl_get_option(12,0)<<12) | iZSUP;
	if (pre >= MAXDBLPRE) {
		ret = m_precision_10(w,pre+1,opt);
		iZSUP = opt & 0x0100;
		ret = m_precision_10(w,pre,0x1000 | iZSUP);
	}
	else ret = m_precision_10(w,pre,opt);
	if ((opt11 & 0x40) || (X_ABS(w->exp)>m_get_nmpa10())) {
		len1 = m_mpa10_to_exp(w,s,s_len,pre,inx,opt11);
		akxtsrepc(s,'E','e');
	}
	else
		len1 = m_mpa10_to_an(w,s,s_len,opt11);
	return len1;
}

/****************************************/
/*										*/
/****************************************/
int cl_mpa2an(mpa,work,w_len,m_flg,dec_pre,dec_sca)
MPA *mpa;
char *work;
int w_len,m_flg,dec_pre,dec_sca;
{
	int opt,pre,len,pre_inx,opt11,opt_dblpre,min_to_exp;
	MPA maz,*ma;
	MPA10W w;
/*
printf("cl_mpa2an: w_len=%d m_flg=%d dec_pre=%d dec_sca=%d\n",w_len,m_flg,dec_pre,dec_sca);
*/
	opt11 = cl_get_option(11,0);
	opt_dblpre = !(opt11 & 0x200);
	opt = opt11;
	if (m_flg > 0) {
		opt |= m_flg & 0x20;
		m_flg &= ~0x20;
	}
	if (opt & 0x80) {
		dec_pre = dec_sca = 0;
	}
	if (dec_pre > 0) opt &= ~0x06;
/*
printf("cl_mpa2an: opt=%04x exp=%d\n",opt,mpa->exp);
*/
	pre_inx = cl_get_option(20,0);
	pre = pre_inx & 0xffff;
	if (opt_dblpre) min_to_exp = MAXDBLPRE;
	else min_to_exp = m_get_nmpa10();
	min_to_exp = (min_to_exp+1)/2;
	if ((opt & 0x40) || (X_ABS(mpa->exp)>min_to_exp)) {
		opt = (opt & 0x010f) | ((pGlobTable->options[11]<<4) & 0xf0);
		if (opt_dblpre && !(pre & 0xff)) pre = MAXDBLPRE;	/* add 2022.7.18 */
		len = m_mpa2an_exp(mpa,work,w_len,pre & 0xff,pre>>8,opt);
	}
	else {
		if (m_flg > 0) opt |= 0x20;
		else if (m_flg < 0) opt &= ~0x20;
		if (mpa->zero && dec_pre>0 && dec_sca>0) {
			ma = (MPA *)cl_get_tmpMPA(&maz);
			m_cpy(ma,mpa,0);
			mpa = ma;
			m_scale(mpa,dec_pre,dec_sca,0);
/*
printf("cl_mpa2an: zero=%d exp=%d len=%d dec_pre=%d dec_sca=%d\n",mpa->zero,mpa->exp,mpa->len,dec_pre,dec_sca);
*/
		}
		if (opt_dblpre && dec_pre <= 0) {
			ma = (MPA *)cl_get_tmpMPA(&maz);
			m_cpy(ma,mpa,0);
			mpa = ma;
			m_precision(mpa,MAXDBLPRE,opt | 0x100);	/* add 2022.7.18 */
		}
		len = m_mpa2an(mpa,work,w_len,opt);
	}
	return len;
}

/****************************************/
/*	*p1͐ݒ肷Kv				*/
/****************************************/
int parm_to_char(pInfoParm1,p1,p1_free)
tdtInfoParm	*pInfoParm1;
char **p1, **p1_free;
{
/*
 * *p1͐ݒ肷KvB
 * BINAFLOAɂẮA*p1̃AhXɌʂԂB
 *   *p1NULL̂Ƃ́AȉƓB
 * CHAR,DECI,BULKɂẮA
 *     p1_free!=NULL ̂Ƃ́AMalloc(im=4)B
 *     p1_free==NULL ̂Ƃ́Acl_tmp_const_malloc(im=3)B
 */
 	int im;
 
	if (!pInfoParm1 || !p1) return -1;
	if (*p1) im = 16;	/* BINAFLOAɂẮAp1̃AhXɌʂԂ */
	else im = 0;
	return cl_parm_to_char_opt(pInfoParm1,p1,im,p1_free);
}

/*****************************************************/
/*	l̂Ƃ́Alen>0  *p1<>NULLȂ*p1ɕԂB*/
/*	len=0 Ȃ *p1͐ݒ肵ȂĂ悢				 */
/*****************************************************/
int parm_to_char_tmp(pInfoParm1,p1,len)
tdtInfoParm *pInfoParm1;
char **p1;
int len;
{
	return cl_parm_to_char_opt(pInfoParm1,p1,len,NULL);	/* cl_tmp_const_malloc */
}

/****************************************/
/*										*/
/****************************************/
int cl_get_ITBL_maxargs(nparm,ppParm,pIndex,ppTBL,iMINARGS,iMAXARGS,pmaxargs,set_defualt)
int nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iMINARGS,iMAXARGS,*pmaxargs,*set_defualt;
{
	tdtArrayIndex tIndex,*pIndexW;
	int ret;

	pIndexW = pIndex;
	ret = cl_get_ITBL_maxargs_ref(nparm,ppParm,&pIndexW,ppTBL,iMINARGS,iMAXARGS,pmaxargs,set_defualt);
	if (!ret) {
		memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return ret;
}

/********1*********2*********3*********4*********5*********6*********7*/
/*	F	nparm	: p[^ (>=1)							  */
/*			ppParm	: p[^̃|C^z						  */
/*					: ppParm[0]:z or Mapp Index				  */
/*					: ppParm[1]:ővfw						  */
/*			ppIndex : *ppIndex ɂ́A&tIndex A					  */
/*					    ݒ肳Ă邱							  */
/*					  *ppIndex ɂ́AA or R ̂ƂA				  */
/*						zpIndexԂB					  */
/*					  A,R ȊÔƂ́Aȉ					  */
/*						index[1]:map indexz̍ővf܂ł̐  */
/*						index[3]:map index							  */
/*			ppTBL	: Mapp Index̔zւ̃|C^Ԃ		  */
/*			iMINARGS:ővfw̍ŏl							  */
/*						<0,maxargs<0̂Ƃ́Amaxargs=0Ƃ		  */
/*			iMAXARGS:ővfw̍ől							  */
/*						<0̂Ƃ́AiMAXARGSɂ`FbNȂ		  */
/*		(I)	pmaxargs:ꂽővf(maxargs)ԂGA		  */
/*					 pmaxargs=NULL̂Ƃ́Aset_defualtݒ		  */
/*		(I)	set_defualt:pmaxargs<>NULLnparm>=2̂Ƃmaxargs	  */
/*						ԂGA									  */
/*		(O)	pmaxargs:ꂽővfԂ						  */
/*					 maxargs<=z̍ő`vf					  */
/*		(O)	set_defualt:pmaxargs<>NULL,nparm>=2̂Ƃmaxargs		  */
/*	ԋp :	<0: G[												  */
/*				=-1: iMINARGS>=0,iMAXARGS>=0̂ƂɁAővfw肪*/
/*					 ͈̔͊O										  */
/*				̑ : ̑̃G[								  */
/*			=0: 												  */
/**********************************************************************/
int cl_get_ITBL_maxargs_ref(nparm,ppParm,ppIndex,ppTBL,iMINARGS,iMAXARGS,pmaxargs,set_defualt)
int nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex **ppIndex;
tdtInfoParm ****ppTBL;
int iMINARGS,iMAXARGS,*pmaxargs,*set_defualt;
{
	int iRc,maxargs,set_val,*index,ret,ierr;
	tdtInfoParm *pInfoParm;
	tdtArrayIndex *pIndex;

	if (!ppIndex) return -1;
	pIndex = *ppIndex;
	index = pIndex->index;
	index[1] = index[0] = 0;
	if (nparm>=1 && pIndex && ppTBL) {
		pInfoParm = ppParm[0];
		if (ret = cl_check_use_mapped_array(pInfoParm)) return ret;
		if (ret = cl_get_array_index_tbl_ref(pInfoParm,ppIndex,ppTBL,"cl_get_ITBL_maxargs.index:")) return ret;
		pIndex = *ppIndex;
		index = pIndex->index;

DEBUGOUT_InfoParm(194,"cl_get_ITBL_maxargs:0",pInfoParm,0,0);

		if (ret = cl_check_use_hash_array(pInfoParm,pIndex)) return ret;
	}

DEBUGOUTL2(194,"cl_get_ITBL_maxargs: index[0]=%d index[1]=%d",index[0],index[1]);

	if (!pmaxargs) return 0;
	set_val = 0;
	if ((maxargs=iMAXARGS)>index[1] || maxargs<0) maxargs = index[1];
	if (nparm >= 2) {
		if (pInfoParm = ppParm[1]) {

DEBUGOUT_InfoParm(194,"cl_get_ITBL_maxargs:1 nparm=%d",pInfoParm,nparm,0);

			if (pInfoParm->pi_dlen > 0) {
				if (iRc = cl_get_parm_bin(pInfoParm,&maxargs,"cl_get_ITBL_maxargs.maxargs:")) {
					if (iRc > 0) iRc = -3;
					goto Err;
				}
				ierr = 0;
				if (iMINARGS < 0) {
					if (maxargs < 0) maxargs = 0;
				}
				else if (maxargs < iMINARGS) ierr = 1;
				if (iMAXARGS>=0 && maxargs>iMAXARGS) ierr += 2;
				if (ierr) {
					ERROROUT1(FORMAT(287),maxargs);	/* max_args(%d)słB */
					iRc = -1;
					goto Err;
				}
				if (maxargs > index[1]) {
					/* max_args(%d)ž(%d)𒴂Ă܂B܂B */
					if (cl_get_option(22,0) & 0x01) ERROROUT2(FORMAT(288),maxargs,index[1]);
					maxargs = index[1];
				}
				set_val = maxargs;
			}
		}
	}

DEBUGOUTL2(194,"cl_get_ITBL_maxargs: maxargs=%d set_val=%d",maxargs,set_val);

	iRc = 0;
  Err:
	if (pmaxargs) *pmaxargs = maxargs;
	if (set_defualt) *set_defualt = set_val;
	return iRc;
}

#define MAXARGS	256	/* max column of EXCEL */
/****************************************/
/*										*/
/****************************************/
static int _get_args_split(pWork,nparm,ppParm,i_split)
char *pWork;
int  nparm,i_split;
tdtInfoParm *ppParm[];	/* (buf,map_index,max_args[,sep],opt) */
{
	tdtInfoParm *pInfoParm,rInfoParm/*,*ppParm[2]*/;
	tdtInfoParm ***pTBL;
	int iRc,n,i,maxargs,opt,len,parmlen,alen,ix,*pSize,len5,set_defualt,nm,set_opt,opt_pos,sep_pos,code_type;
	char w1[32],*p1,*p2,parm[512],*argv[MAXARGS];
	char w5[32],*p5;
	ScrPrCT *pScCT;
	char c,*name;
	tdtArrayIndex tIndex,*pIndex;
	int  *index;

	p2 = NULL;
	iRc = 0;
	p1 = w1;
	if ((len = parm_to_char(pInfoParm=ppParm[0],&p1,NULL)) < 0) return len;
/*
printf("cl_get_args: len=%d p1=[%s]\n",len,p1);
*/
	code_type = cl_get_char_code_type(pInfoParm,1);
	pIndex = &tIndex;
	if (iRc=cl_get_ITBL_maxargs_ref(nparm-1,&ppParm[1],&pIndex,&pTBL,1,MAXARGS,
	                            &maxargs,&set_defualt)) return iRc;
	if (!len) {
		n = 0;
		goto zero;
	}
	if (i_split) {
		sep_pos = 4;
		opt_pos = 5;
	}
	else {
		opt_pos = 4;
		sep_pos = 5;
	}
	set_opt = 0;
	if (nparm>=opt_pos && ppParm[opt_pos-1]->pi_dlen>0) {
		if (iRc = cl_get_parm_bin(ppParm[opt_pos-1],&opt,"getargs.opt:")) goto err;
		set_opt = 1;

DEBUGOUTL1(191,"cl_get_args: opt=%08x",opt);

	}
	else if (i_split) opt = 0;
	else opt = AKX_ARGV_DELM_COM | AKX_ARGV_TERM_IGE |
	           AKX_ARGV_IGNR_EQU | AKX_ARGV_DELM_CLN;

	p5 = NULL;
	len5 = 0;
	if (nparm>=sep_pos && ppParm[sep_pos-1]->pi_dlen>0) {
		p5 = w5;
		if ((len5 = parm_to_char(ppParm[sep_pos-1],&p5,NULL)) < 0) goto err;
		if (!i_split) {
			if (len5 > 0) {

DEBUGOUTL2(191,"cl_get_args: sep=[%s] opt=%08x",p5,opt);

				if (!set_opt && *p5==',') opt |= AKX_ARGV_FOR_CSV;
			}
			else p5 = NULL;
		}
	}
#if 1	/* 2021.4.18 */
	parmlen = len + maxargs + 1;
	p2 = cl_tmp_const_malloc(parmlen);
#else
	p2 = parm;
	parmlen = sizeof(parm);
	alen = len + maxargs + 1;
	if (alen > parmlen) {
		if (!(p2=Malloc(alen))) {
			iRc = -1;
			goto err;
		}
		parmlen = alen;
	}
#endif

DEBUGOUTL4(194,"cl_get_args: len=%d parm=%08x parmlen=%d p2=%08x",len,parm,parmlen,p2);

	opt |= SET_TYPE_OPT(code_type);
	if (i_split)
		n = akxtnsplit(p1,len,argv,maxargs,p2,parmlen,p5,len5,opt);
	else 
		n = akxtgetargvns2(p1,len,argv,maxargs,p2,parmlen,p5,opt);
	if (n < 0) {
		iRc = n;
		goto err;
	}
 zero:
	if (i_split) nm = n;
	else nm = X_MAX(n,set_defualt);

DEBUGOUTL1(194,"cl_get_args: n=%d",n);

	index = pIndex->index;
	ix = index[3];
	for (i=0;i<nm;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
		if (pInfoParm) {

DEBUGOUT_InfoParm(194,"cl_get_args: i=%d ix=%d",pInfoParm,i,ix);

			if (i < n) {
				p1  = argv[i];
				len = strlen(p1);
			}
			else {
				p1  = "";
				len = 0;
			}
			cl_set_parm_char2(&rInfoParm,p1,len,code_type);
			if (iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) goto err;
		}
		else {
			iRc = -1;
			goto err;
		}
	}
	memcpy(pWork,&n,sizeof(int));
 err:
#if 0	/* 2021.4.18 */
	if (p2 && p2!=parm) Free(p2);
#endif

DEBUGOUTL1(194,"cl_get_args: iRc=%d",iRc);

	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_args(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,map_index,max_args,opt,sep) */
{
	return _get_args_split(pWork,nparm,ppParm,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_split(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,map_index,max_args,sep,opt) */
{
	return _get_args_split(pWork,nparm,ppParm,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_get_word(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];	/* (line,map_index,sep,opt) */
{
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL,*ppInfo[6];
	int iRc,n,opt,len,i,ix,wdsize,wdlen,len3,*index;
	char *line, *sep, wrk[512];
	tdtArrayIndex tIndex,*pIndex;
	SSPL_S sspl;

	n = -1;
	memcpy(pWork,&n,sizeof(int));
	iRc = 0;
	/*** line ***/
	line = NULL;
	if ((len = parm_to_char(pInfoParm=ppParm[0],&line,NULL)) <= 0) return len;
/*
printf("cl_get_word: len=%d line=[%s]\n",len,line);
*/
	/*** map_index ***/
	pIndex = &tIndex;
	if (iRc=cl_get_ITBL_maxargs_ref(1,&ppParm[1],&pIndex,&pTBL,0,0,0,0)) return iRc;
	index = pIndex->index;
/*
printf("cl_get_word: index=%d %d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4],index[5]);
*/
	if (index[1] < 6) {	/* 2020.12.30 4-->1 */
		ERROROUT1("zTCY(%d)́A6ȏKvłB",index[1]);
		return -1;
	}
	ix = index[3];
	for (i=0;i<6;i++,ix++) {
		ppInfo[i] = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
		if (!ppInfo[i]) return -1;
DEBUGOUT_InfoParm(194,"cl_get_word: i=%d",ppInfo[i],i,0);
	}
	memset(&sspl,0,sizeof(SSPL_S));
	sspl.wd = wrk;
	sspl.wdmax = sizeof(wrk);
	sspl.code = cl_get_char_code_type(pInfoParm,1);
	if (iRc = cl_get_parm_bin(ppInfo[0],&sspl.sp,"getwd.sp:")) return iRc;
	sspl.sp--;
/*
printf("cl_get_word: sp=%d\n",sspl.sp);
*/
	/*** wdlen ***/
	if (nparm>=5 && ppParm[4]->pi_dlen>0) {
		if (iRc = cl_get_parm_bin(ppParm[4],&wdlen,"getwd.opt:")) return iRc;
/*
printf("cl_get_word: wdlen=%d\n",wdlen);
*/
		if (wdlen > 0) {
			wdsize = wdlen + 1;
			if (wdsize > sspl.wdmax) {
				sspl.wd = cl_tmp_const_malloc(wdsize);
			}
			sspl.wdmax = wdsize;
		}
	}
/*
printf("cl_get_word: wdmax=%d\n",sspl.wdmax);
*/
	/*** sep ***/
	sep = NULL;
	if (nparm>=3 && ppParm[2]->pi_dlen>0) {
		if ((len3 = parm_to_char(ppParm[2],&sep,NULL)) < 0) return len3;
		else if (!len3) sep = NULL;
	}
/*
printf("cl_get_word: sep=[%s]\n",sep);
*/
	/*** opt ***/
	opt = 7;
	if (nparm>=4 && ppParm[3]->pi_dlen>0) {
		if (iRc = cl_get_parm_bin(ppParm[3],&opt,"getwd.opt:")) return iRc;
/*
printf("cl_get_word: opt=%08x\n",opt);
*/
	}

	n = akxtgwnsl(line,len,&sspl,sep,opt);
	if (n >= 0) {
/*
printf("cl_get_word: n=%d wd=[%s]\n",n,sspl.wd);
*/
		cl_set_parm_char2(&rInfoParm,sspl.wd,n,sspl.code);
		if (iRc=cl_gx_rep_info_set(ppInfo[1],&rInfoParm,1)) return iRc;
	}
	cl_set_parm_bin(ppInfo[0],sspl.sp+1);
	for (i=0;i<4;i++) {
		cl_set_parm_bin(ppInfo[i+2],sspl.attr[i]);
	}
	if (!n && !sspl.attr[0]) n = -1;

	memcpy(pWork,&n,sizeof(int));
/*
printf("cl_get_args: iRc=%d\n",iRc);
*/
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_trim(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,opt) */
{
	tdtInfoParm *pInfo;
	int  ret,opt,len,atr,lptr,code_type,opt_type;
	char *p1,*p2,*p;

	p2 = NULL;
	opt = ret = 0;
	if ((len = parm_to_char_tmp(pInfo=ppParm[0],&p1,-1)) < 0) return len;
	else if (len > 0) {
/*
printf("cl_trim: len=%d p1=[%s]\n",len,p1);
*/
		code_type = cl_get_char_code_type(pInfo,2);
		opt_type = SET_TYPE_OPT(code_type);
		if (nparm >= 2) {
			pInfo = ppParm[1];
			if ((atr=pInfo->pi_attr)>=2 && atr<=4) {
				if (ret = cl_get_parm_bin(pInfo,&opt,"trim.opt:")) return ret;
				nparm = 2;
/*
printf("clTrm: opt=%d\n",opt);
*/
			}
			else {
				if (cl_is_null_parm(pInfo)) ;
				else if ((lptr = parm_to_char_tmp(pInfo,&p2,-1)) < 0) return lptr;
/*
printf("cl_trim: p2=[%s]\n",p1);
*/
			}
		}
		if (nparm >= 3) {
			pInfo = ppParm[2];
			if (ret = cl_get_parm_bin(pInfo,&opt,"trim.opt:")) return ret;
/*
printf("clTrm:2 opt=%d\n",opt);
*/
		}
		len = akxtstrim(opt | opt_type,p1,len,p2);
/*
printf("cl_trim: len=%d p=[%s]\n",len,p);
*/
		if (len>0 && code_type!=akxt_get_code_type()) {
			if (p = cl_tmp_const_malloc(len+3)) {
				p2 = cl_set_type_to_string(p,len,code_type);
				memzcpy(p2,p1,len);
				p1 = p;
			}
			else {
				ERROROUT("cl_trim: pAns malloc error");
				ret = ECL_MALLOC_ERROR;
			}
		}
	}
	*pAns = p1;
	ret = 0;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_strings(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	int  ret,num,len,len_num,i,code_type;
	char w1[32],*p1,*p;
	tdtInfoParm *pInfo;

	*pAns = NULL;
	num = ret = 0;
	p1 = w1;
	if ((len = parm_to_char(pInfo=ppParm[0],&p1,NULL)) < 0) return len;
	else if (len > 0) {
/*
printf("cl_strings: len=%d p1=[%s]\n",len,p1);
*/
		if (ret = cl_get_parm_bin(ppParm[1],&num,"Strings.num:")) return ret;
	}
/*
printf("cl_strings: num=%d\n",num);
*/
	if ((len_num = len*num) > 0) {
		if (p = cl_tmp_const_malloc(len_num+3)) {
			*pAns = p;
			code_type = cl_get_char_code_type(pInfo,1);
			p = cl_set_type_to_string(p,len_num,code_type);
			for (i=0;i<num;i++,p+=len) {
				memcpy(p,p1,len);
			}
			*p = '\0';
		}
		else {
			ERROROUT("Strings: pAns malloc error");
			ret = ECL_MALLOC_ERROR;
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_leftm(pAns,mflg,nparm,ppParm)
char **pAns;
int  mflg;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_right_leftm(pAns,mflg,nparm,ppParm,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_left(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_leftm(pAns,pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX,nparm,ppParm);
}

/****************************************/
/*										*/
/****************************************/
int cl_right_leftm(pAns,mflg,nparm,ppParm,rl)
char **pAns;
int  mflg;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
int  rl;	/* 0:right / 1:left */
{
	tdtInfoParm tInfoParmS,tInfoParm1,tInfoParm2;
	int  ret,num,len,i,code_type;
	char w1[32],*p1;
/*
printf("cl_right_leftm: mflg=%d nparm=%d rl=%d\n",mflg,nparm,rl);
*/
	*pAns = NULL;
	num = ret = 0;
	code_type = cl_get_char_code_type(ppParm[0],1);
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) return len;
	else if (len > 0) {
/*
printf("cl_right_leftm: len=%d p1=[%s]\n",len,p1);
*/
		if (ret = cl_get_parm_bin(ppParm[1],&num,"Right/Left.num:")) return ret;
	}
/*
printf("cl_right_leftm: num=%d\n",num);
*/
	if (len>0 && num!=0) {
		cl_set_parm_char2(&tInfoParmS,p1,len,code_type);
		if (mflg) len = akxqmlen(p1,len);
		if (num < 0) {
			if ((num += len) <= 0) return 0;
		}
		if (rl) {	/* left */
			cl_set_parm_bin(&tInfoParm1,1);
			cl_set_parm_bin(&tInfoParm2,num);
			ret = substrm(pAns,mflg,&tInfoParmS,&tInfoParm1,&tInfoParm2);
		}
		else {		/* right */
			if ((i = len - num + 1) <= 0) i = 1;
			cl_set_parm_bin(&tInfoParm1,i);
			ret = substrm(pAns,mflg,&tInfoParmS,&tInfoParm1,NULL);
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_rightm(pAns,mflg,nparm,ppParm)
char **pAns;
int  mflg;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_right_leftm(pAns,mflg,nparm,ppParm,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_right(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_rightm(pAns,pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX,nparm,ppParm);
}
#if 0
/****************************************/
/*										*/
/****************************************/
int cl_in_str(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;	/* (buf,map_index,max_args,opt) */
{
	int  i,ret,opt,len[2],opt_type,type[2],iM;
	char w1[64],*p1[2];
	tdtInfoParm *pInfo;

	p1[0] = w1;
	p1[1] = w1 + 32;
	iM = 0;
	for (i=0;i<2;i++) {
		ret = parm_to_char((pInfo=&pParm[i]),&p1[i],NULL);
/*
printf("cl_in_str: i=%d len=%d p1=[%s]\n",i,ret,p1[i]);
*/
		if (ret < 0) return ret;
		type[i] = opt_type = cl_get_char_code_type(pInfo,opt);
		iM |= cl_is_mbyte(pInfo,opt_type);
		len[i] = ret;
	}
	if (iM && akxq_code_type_cmp(type[0],type[1])) {
		ERROROUT3(FORMAT(648),"cl_in_str",type[0],type[1]);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
		return ECL_SCRIPT_ERROR;
	}
	if (nparm >= 3) {
		if (ret = cl_get_parm_bin(&pParm[2],&opt,"option:")) return ret;
	}
	else opt = 0;
/*
printf("cl_in_str: opt=%d\n",opt);
*/
	opt_type = SET_TYPE_OPT(pParm[0].pi_code);
	ret = akxs_in_mem_opt(p1[0],len[0],p1[1],len[1],opt | opt_type);
/*
printf("cl_in_str: ret=%d\n",ret);
*/
	memcpy(pWork,&ret,sizeof(int));
	if (ret >= 0) ret = 0;
	return ret;
}
#endif
/****************************************/
/*										*/
/****************************************/
static int _edit_width(widths,p_b,data,len)
int widths;
char *p_b,*data;
int len;
{
	int width;

	if ((width=widths) < 0) width = -width;

	if (widths >= 0) {
		memzcpy(p_b,data,len);
		if (width > len) {
			memset(p_b+len,' ',width-len);
			*(p_b+width) = '\0';
		}
	}
	else if (widths < 0) {
		if (width > len) {
			memset(p_b,' ',width-len);
			p_b += width-len;
		}
		memzcpy(p_b,data,len);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _edit_sub_s(pp_b,form,c0,widths,pInfoParm,iOpta)
char **pp_b,*form,c0;
tdtInfoParm *pInfoParm;
int iOpta[],widths;
{
	int  len_d,width,iSTR;
	char *p,*p_b,buf[256],*p_d,attr,w1[16],id;

/*
DEBUGOUT_InfoParm(0,"cl_edit: ",pInfoParm,0,0);
*/
	p_b = *pp_b;
		if ((width=widths) < 0) width = -width;
			id   = pInfoParm->pi_id;
			attr = pInfoParm->pi_attr;
			p_d  = pInfoParm->pi_data;
			len_d = pInfoParm->pi_dlen;
				if (id==' ' &&
				    !(pInfoParm->pi_aux[0] & DEF_ZOK_DATA) &&
				    !(pInfoParm->pi_alen & D_AULN_RANGE_DATA)) {
					if (attr != DEF_ZOK_CHAR) {
						p_d = w1;
						len_d = parm_to_char(pInfoParm,&p_d,NULL);
					}
/*
printf("cl_edit: p_d=[%s]\n",p_d);
*/
				}
				else {
					iSTR = 0;
					if (iOpta) {
						if (iOpta[1] & D_PRN_OPT_NGEN) {
							if (c0 == 'S') iOpta[1] |= D_PRN_OPT_LTGT;
							len_d = cl_str_print(&p_d,pInfoParm,iOpta);
							if (len_d == ECL_EX_CONTINUE) len_d = 0;
							iSTR = 1;
						}
						else len_d = -1;
					}
					else len_d = -1;
					if (len_d<0 && !iSTR) len_d = parm_to_char(pInfoParm,&p_d,NULL);
				}
				if (len_d < 0) {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
				else {
					if (len_d>width && len_d>sizeof(buf)-1) {
						if (!(p_b = cl_tmp_const_malloc(len_d+1))) {
							*pp_b = NULL;
							return -1;
						}
						*pp_b = p_b;
					}
/*
printf("cl_edit: form=[%s] p_d=[%s]\n",form,p_d);
*/
					sprintf(p_b,form,p_d);
				}
/*
printf("cl_edit:Exit form=[%s] p_d=[%s]\n",form,p_d);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_edit_sub(pAns,format,nparm,ppParm,iOpta)
char **pAns,*format;
int  nparm;
tdtInfoParm **ppParm;	/* (buf,opt) */
int iOpta[];
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	tdtInfoParm *pInfoParm;
	int  len_f,len_d,i,len,ipa,val,width,widths,ret,iVal[2],iAttr[3],iSTR;
	int  isca,scale,len1,len2,opt,slen;
	char form[256],buf[256],*p_b,*p,*p_f,*p_d,c,c0,attr,w1[16],id,*p_p,*pp,buf2[100];
	double dValue;
	uchar uc;
	MPA *mpa,mpaz;
/*
printf("cl_edit_sub:Enter nparm=%d format=[%s]\n",nparm,format);
*/
	if (!pAns) return -1;
	*pAns = NULL;
	len_f = strlen(p_f=format);
	if (len_f <= 0) return 0;
	ipa = 0;
	buf[0] = '\0';
	mcat.mc_ipos = 0;
	for (;;) {
/*
printf("cl_edit_sub:1: len_f=%d p_f=[%s]\n",len_f,p_f);
*/
		c = '\0';
		scale = isca = i = 0;
		while (i<len_f && (c=*(p_f+i))) {
			if (c=='%') {
				if (*(p_f+i+1)=='%') {
					akxtmcat(&mcat,p_f,i);
					i++;
					p_f += i;
					len_f -= i;
					i = 0;
				}
				else break;
			}
			i++;
		}
		akxtmcat(&mcat,p_f,i);
		if (c != '%') {
			break;
		}
		p_f += i;
		len_f -= i;
/*
printf("cl_edit_sub:2: len_f=%d p_f=[%s]\n",len_f,p_f);
*/
		widths = atoi(p_f+1);
		if ((width=widths) < 0) width = -width;
		i = 1;
		p_b = buf;
		if (width > sizeof(buf)-1) {
			if (!(p_b=cl_tmp_const_malloc(width+1))) return -1;
		}
		*p_b = '\0';
		while (i<len_f && (c=*(p_f+i)) &&
		       ((c>='0' && c<='9')||(c=='.')||(c=='+')||(c=='-'))) {
			i++;
			if (c == '.') isca = i;
		}
		i++;
		if (ipa < nparm) {
			memnzcpy(form,p_f,i,sizeof(form));
/*
printf("cl_edit_sub: form=[%s] widths=%d i=%d\n",form,widths,i);
*/
			if (isca) scale = atoi(form+isca);
			if (c == 'S') *(form+i-1) = 's';
			c0 = c;
			c = toupper(c);
			pInfoParm = ppParm[ipa];
			id   = pInfoParm->pi_id;
			attr = pInfoParm->pi_attr;
			p_d  = pInfoParm->pi_data;
			len_d = pInfoParm->pi_dlen;
			if (len_d > 0) {
				if (attr==DEF_ZOK_FLOA)
					memcpy(&dValue,p_d,sizeof(double));
				else if (attr==DEF_ZOK_BINA)
					val = cl_get_data_long(pInfoParm);
			}
			if (len_d <= 0) {
				if (c=='S' && attr==DEF_ZOK_CHAR) {
					sprintf(p_b,form,"");
				}
				else {
					p = "(null)";
					_edit_width(widths,p_b,p,strlen(p));
				}
			}
			else if (c == 'S') {
#if 1	/* 2021.11.30 */
				if ((ret=_edit_sub_s(&p_b,form,c0,widths,pInfoParm,iOpta)) < 0) return ret;
#else
/*
DEBUGOUT_InfoParm(0,"cl_edit_sub: ",pInfoParm,0,0);
*/
				if (id==' ' &&
				    !(pInfoParm->pi_aux[0] & DEF_ZOK_DATA) &&
				    !(pInfoParm->pi_alen & D_AULN_RANGE_DATA)) {
					if (attr != DEF_ZOK_CHAR) {
						p_d = w1;
						len_d = parm_to_char(pInfoParm,&p_d,NULL);
					}
/*
printf("cl_edit_sub: p_d=[%s]\n",p_d);
*/
				}
				else {
					iSTR = 0;
					if (iOpta) {
						if (iOpta[1] & D_PRN_OPT_NGEN) {
							if (c0 == 'S') iOpta[1] |= D_PRN_OPT_LTGT;
							len_d = cl_str_print(&p_d,pInfoParm,iOpta);
							if (len_d == ECL_EX_CONTINUE) len_d = 0;
							iSTR = 1;
						}
						else len_d = -1;
					}
					else len_d = -1;
					if (len_d<0 && !iSTR) len_d = parm_to_char(pInfoParm,&p_d,NULL);
				}
				if (len_d < 0) {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
				else {
					if (len_d>width && len_d>sizeof(buf)-1) {
						if (!(p_b = cl_tmp_const_malloc(len_d+1))) return -1;
					}
/*
printf("cl_edit_sub: form=[%s] p_d=[%s]\n",form,p_d);
*/
					sprintf(p_b,form,p_d);
				}
#endif
			}
			else if (c == 'C') {
				if (attr==DEF_ZOK_FLOA) {
					val = dValue;
					uc = val;
				}
				else if (attr==DEF_ZOK_BINA) uc = val;
				else if (attr==DEF_ZOK_DECI) {
					if (cl_get_parm_bin(pInfoParm,&val,"cl_edit_sub:C")) uc = ' ';
					else uc = val;
				}
				else if (attr==DEF_ZOK_DATE) {
					p_d = w1;
					len_d = parm_to_char(pInfoParm,&p_d,NULL);
					if (len_d < 0) {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					}
					uc = (uchar)*p_d;
				}
				else uc = (uchar)*p_d;
				sprintf(p_b,form,uc);
			}
			else if (c=='F' || c=='E' || c=='G' || c=='A') {
				if (attr == DEF_ZOK_FLOA) sprintf(p_b,form,dValue);
				else if (attr == DEF_ZOK_BINA) {
					dValue = val;
					sprintf(p_b,form,dValue);
				}
				else if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_DECI) {
					if (ret=cl_get_parm_double(pInfoParm,&dValue,"cl_edit_sub:DOUBLE")) {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					/*	return -1;	*/
					}
					else {
						sprintf(p_b,form,dValue);
					}
				}
				else {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
			}
			else if (c=='D' || c=='I' || c=='O' || c=='U' || c=='X') {
				if (attr == DEF_ZOK_BINA) sprintf(p_b,form,val);
				else if (attr == DEF_ZOK_FLOA) {
					val = cl_chk_over_flow_d2_i(dValue,"cl_edit_sub");
					sprintf(p_b,form,val);
				}
				else if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_DECI) {
					if (ret=cl_get_parm_bin(pInfoParm,&val,"cl_edit_sub:BIN")) {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					/*	return -1;	*/
					}
					else sprintf(p_b,form,val);
				}
				else if (attr==DEF_ZOK_DATE) {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
				else sprintf(p_b,form,p_d);
			}
			else if (c == 'R') {
				p_p = form + i - 1;
				if (attr == DEF_ZOK_BINA) {
					if (pInfoParm->pi_pos & D_DATA_UNSIGNED) *p_p = 'u';
					else *p_p = 'd';
					sprintf(p_b,form,val);
				}
				else if (attr == DEF_ZOK_FLOA) {
					*p_p = 'g';
					sprintf(p_b,form,dValue);
				}
				else if (attr == DEF_ZOK_CHAR) {
					*p_p = 's';
					sprintf(p_b,form,p_d);
				}
				else if (attr==DEF_ZOK_DECI) {
/*
printf("cl_edit_sub: form=[%s] widths=%d isca=%d scale=%d\n",form,widths,isca,scale);
*/
					mpa = (MPA *)cl_get_tmpMPA(&mpaz);
					m_cpy(mpa,(MPA *)p_d,0);
					if (isca) {
						opt = cl_get_option(12,0);
						ret = cl_mpa_scale(mpa,width-1,scale,opt);
						opt = 0;
						if (scale > 0) opt = 6;
						pp = m_mpa2scastr(mpa,NULL,0,scale,opt);
						len1 = strlen(pp);
					}
					else {
						opt = ret = 0;
						len1 = cl_mpa2an(mpa,buf2,sizeof(buf2),0,0,0);
					/*	slen = MAXDBLPRE+1;
						len1 =m_mpa2an(mpa,buf2,slen,opt);	*/
						pp = buf2;
					}
					if (ret >= 0) {
					/*	pp = m_mpa2scastr(mpa,NULL,0,scale,opt);
						len1 = strlen(pp);	*/
/*
printf("cl_edit_sub: pp=[%s] len1=%d\n",pp,len1);
*/
						if (len1 < width) {
							len2 = width - len1;
/*
printf("cl_edit_sub: len2=%d\n",len2);
*/
							if (widths < 0) {
								memcpy(p_b,pp,len1);
								memset(p_b+len1,' ',len2);
								*(p_b+width) = '\0';
							}
							else {
								memset(p_b,' ',len2);
								memzcpy(p_b+len2,pp,len1);
							}
						}
						else p_b = pp;
					}
					else {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					}
				}
				else {
#if 1
					*p_p = 's';
					if ((ret=_edit_sub_s(&p_b,form,c0,widths,pInfoParm,iOpta)) < 0) return ret;
#else
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
#endif
				}
			}
			else {
				sprintf(p_b,form,p_d);
			}
			ipa++;
		}
		else {
			p = "(N/A)";
			_edit_width(widths,p_b,p,strlen(p));
		}
		akxtmcats(&mcat,p_b);
		p_f += i;
		len_f -= i;
	}
	*pAns = mcat.mc_bufp;
	return mcat.mc_ipos;
}

/****************************************/
/*										*/
/****************************************/
int cl_edit_opta(pAns,nparm,ppParm,iOpta)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
int iOpta[];
{
	tdtInfoParm *pInfoParm;
	int ret,len_f;
	char *pWork,*p,*format;
/*
printf("cl_edit_opta:Enter nparm=%d\n",nparm);
*/
	if (!pAns) return -1;
	*pAns = NULL;
	ret = 0;
	pWork = "";
	if (nparm > 0) {
		pInfoParm = ppParm[0];
/*
DEBUGOUT_InfoParm(0,"cl_edit_opta: ",pInfoParm,0,0);
*/
		len_f = pInfoParm->pi_dlen;
/*
printf("cl_edit_opta: len_f=%d\n",len_f);
*/
		if (len_f > 0) {
/*
printf("cl_edit_opta: attr=%d\n",pInfoParm->pi_attr);
*/
			if (pInfoParm->pi_attr != DEF_ZOK_CHAR) return -2;
			format = pInfoParm->pi_data;
			if ((ret=cl_edit_sub(&pWork,format,nparm-1,&ppParm[1],iOpta)) < 0) return ret;
		}
	}
	if (!(p=cl_tmp_const_malloc(ret+1))) return -1;
	memzcpy(p,pWork,ret);
	*pAns = p;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_edit(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int iOpta[MAX_PRINT_FLGS+1],opt13;

	mem_set_int(iOpta,0,MAX_PRINT_FLGS+1);
	opt13 = cl_get_option(13,0);
	return cl_edit_opta(pAns,nparm,ppParm,iOpta);
}

/****************************************/
/*										*/
/****************************************/
int cl_eedit(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int iOpta[MAX_PRINT_FLGS+1],opt13;

	mem_set_int(iOpta,0,MAX_PRINT_FLGS+1);
	opt13 = cl_get_option(13,0);
	if (opt13 & 0x40) iOpta[1] & ~D_PRN_OPT_NGEN;
	else iOpta[1] |= D_PRN_OPT_NGEN;
	if (opt13 & 0x80) iOpta[1] &= ~D_PRN_OPT_LTGT;
	else iOpta[1] |= D_PRN_OPT_LTGT;
	return cl_edit_opta(pAns,nparm,ppParm,iOpta);
}

/****************************************/
/*										*/
/****************************************/
int cl_chr(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	int  ret,val[2],i;
	char w[2],*p;

	*pAns = NULL;
	ret = 0;
	mcat.mc_ipos = 0;
	for (i=0;i<nparm;i++) {
		if (ret=cl_get_parm_bin(ppParm[i],val,"cl_chr:")) return ret;
		w[0] = val[0];
		akxtmcat(&mcat,w,1);
	}
	if (mcat.mc_ipos > 0) {
		if (p = cl_tmp_const_malloc(mcat.mc_ipos+1)) {
			memzcpy(p,mcat.mc_bufp,mcat.mc_ipos);
			*pAns = p;
		}
		else {
			return -1;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_asc(pWork,mflg,nparm,ppParm)
char *pWork;
int  mflg,nparm;
tdtInfoParm *ppParm[];
{
	int  ret,num,n,nn,code_type;
	uchar w1[32],*p1;
	char *p;

	memset(pWork,0,sizeof(int));
	p1 = w1;
	if ((ret = parm_to_char(ppParm[0],&p1,NULL)) > 0) {
		code_type = akxt_get_code_type();
		if (mflg) n = akxqmbslen(code_type,p1);
		else n = 1;
		num = 0;
		p = (char *)&num;
		memcpy(p+4-n,p1,n);
		nn = ntohl(num);
		memcpy(pWork,&nn,sizeof(int));
	}
	if (ret > 0) ret = 0;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static int _like_pat_rzcpy(str1,str2,len)
char *str1,*str2;
int len;
{
	int len1,m,mlen,len2;
	char *p1,*p2,c,*pp;

	if (!(p1=str1) || !(p2=str2)) return -1;
/*
printf("_like_pat_rzcpy: len=%d str2=[%s]\n",len,str2);
*/
	mlen = 0;
	len1 = len;
	p1 += len1;
	*p1 = '\0';
	while (len1 > 0) {
		mlen++;
		m = akxqkanjilen2(p2,len1);
		if (m >= 2) {
			p1 -= m;
			memcpy(p1,p2,m);
			len1 -=m;
			p2 += m;
		}
		else if ((c=*p2)=='\\') {
			p2++;
			len1--;
			m = akxqkanjilen2(p2,len1);
			p1 -= m;
			memcpy(p1,p2,m);
			p1--;
			*p1 = c;
			p2 += m;
			len1 -= m;
			mlen++;
		}
		else if (c=='[') {
			len2 = 1;
			pp = p2;
			pp++;
			len1--;
			while (len1 > 0) {
				mlen++;
				m = akxqkanjilen2(pp,len1);
				if (m >= 2) len2 += m;
				else if ((c=*pp)=='\\') {
					pp++;
					len1--;
					m = akxqkanjilen2(pp,len1);
					pp += m;
					len1 -= m;
					len2 += m;
					mlen++;
				}
				else {
					pp++;
					len1--;
					len2++;
					if (c == ']') break;
				}
			}
			p1 -= len2;
			memcpy(p1,p2,len2);
			p2 = pp;
		}
		else {
			p1--;
			*p1 = *p2++;
			len1--;
		}
	}
/*
printf("_like_pat_rzcpy: mlen=%d str1=[%s]\n",mlen,str1);
*/
	return mlen;
}

/********************************************/
/*											*/
/* ԋp : < 0 : G[̈ʒu(擪-(1))	*/
/*		  = 0 : PNAMÊ					*/
/*		  > 0 : texẗʒu(擪1)			*/
/********************************************/
int _get_pos_text(nparm,ppParm)
int nparm;
tdtInfoParm *ppParm[];
{
	int i;
	tdtInfoParm *pInfoParm;

	i = 0;
	for (i=0;i<nparm;i++) {
		if (pInfoParm = ppParm[i]) {
			if (pInfoParm->pi_id != D_DATA_ID_PNAME) {
				i++;
				break;
			}
		}
		else {
			i = -(i+1);
			break;
		}
	}
/*
printf("_get_pos_text: i=%d\n",i);
*/
	return i;
}

/********1*********2********3*********4*********5*********6******/
/*  : IN													*/
/*			nparm	 : p[^								*/
/*			ppParm[] : ȉ̃p[^							*/
/*						line [,start [,len]]					*/
/*						start,len͕̓͂P				*/
/*			pos0[]	 : start,lenԂintz					*/
/*						NULL̂Ƃ̓G[						*/
/*		  OUT													*/
/*			pos0[]	 : 											*/
/*						pos0[0]:start(wlA擪1)			*/
/*						pos0[1]:len(wl)						*/
/*						pos0[2]:start܂len̎̈ʒu		*/
/* ԋp : < 0 : G[											*/
/*		  = 0 : nparm<=0ppParm[1]lłȂ					*/
/*		  = 1 : ppParm[1](start)lł					*/
/*		  = 2 : ppParm[1](start)ppParm[2](len)lł	*/
/****************************************************************/
int _get_parm_str_pos(nparm,ppParm,pos0)
int nparm,pos0[];
tdtInfoParm **ppParm;
{
	tdtInfoParm *pInfoParm;
	int ret,shift,i;

	if (!pos0) return -1;
	shift = 0;
	pos0[0] = 1;
	pos0[1] = -1;
#if 1
	pos0[2] = 0;
	for (i=1;i<nparm;i++) {
		if (shift >= 2) break;
		pInfoParm = ppParm[i];
		if (pInfoParm->pi_id != D_DATA_ID_PNAME) {
			if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_BINA) {
				if ((ret=_get_pos_len(shift,pInfoParm,pos0)) < 0) return ret;
				shift++;
				if (ret) {
					shift++;
				}
			}
			else break;
		}
	}
	pos0[2] = i;
/*
printf("_get_parm_str_pos: nparm=%d shift=%d pos0=%d %d %d\n",nparm,shift,pos0[0],pos0[1],pos0[2]);
*/
#else
	if (nparm >= 2) {
		pInfoParm = ppParm[1];
		if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_BINA) {
			if (ret=_get_pos_len(0,pInfoParm,pos0)) return ret;
			shift = 1;
			if (nparm >= 3) {
				pInfoParm = ppParm[2];
				if (pInfoParm->pi_attr==DEF_ZOK_BINA) {
					if (ret=_get_pos_len(1,pInfoParm,pos0)) return ret;
					shift = 2;
				}
			}
		}
	}
#endif
	return shift;
}

/********1*********2********3*********4*********5*********6******/
/*  : IN													*/
/*			nparm	 : p[^								*/
/*			ppParm[] : ȉ̃p[^							*/
/*						line [,start [,len]]					*/
/*						start,len͕̓͂P				*/
/*			pa[]	 : linẽAhXԂ|C^z			*/
/*						NULL̂Ƃ́AȂĂstart,len		*/
/*						`FbN͍s							*/
/*			lena[]	 : line̒Ԃintz					*/
/*			max_pa	 : pa[],lena[]̔z						*/
/*						5ȉ̂Ƃ1ƌȂ					*/
/*		  OUT													*/
/*			pa[]	 : 											*/
/*						pa[0]:line+start						*/
/*						pa[5]:line̐擪AhX				*/
/*			lena[]	 : 											*/
/*						lena[0]:p[0]̒(oCg)				*/
/*						lena[5]:linẽoCg					*/
/*						lena[6]:start(oCgA擪1)			*/
/*						lena[7]:start܂ŃXLbvoCg	*/
/*						lena[8]:start,len̎̈ʒu				*/
/* ԋp : < 0 : G[											*/
/*		  = 0 : nparm<=0ppParm[1]lłȂ					*/
/*		  = 1 : ppParm[1](start)lł					*/
/*		  = 2 : ppParm[1](start)ppParm[2](len)lł	*/
/****************************************************************/
static int _get_text_str_pos(nparm,ppParm,pa,lena,max_pa)
int nparm,lena[],max_pa;
tdtInfoParm **ppParm;
char *pa[];
{
	int ret,shift,len1,len2,pos0[3],len0,posa1[4],i1;
	char *p1;

	if (pa) pa[0] = NULL;
	if (lena) {
		lena[0] = 0;
		if (max_pa >= 6) lena[5] = 0;
	}
	if (nparm <= 0) return 0;

	ret = shift = len1 = len0 = 0;
	if (pa) {
#if 1	/* 2022.10.20 */
		if ((i1=_get_pos_text(nparm,ppParm)) < 0) return i1;
		else if (!i1) {
			ERROROUT2(FORMAT(76),"_get_text_str_pos","text");		/* %s: %s܂B*/
			return ECL_SCRIPT_ERROR;
		}
		i1--;
#endif
		p1 = NULL;
		if ((ret=parm_to_char(ppParm[i1],&p1,NULL)) >= 0) {
			len0 = len1 = ret;
		}
		else shift = ret;
		if (max_pa >= 6) pa[5] = p1;
	}
	pos0[0] = 1;
	if (lena && max_pa>=8) lena[7] = 0;
	if ((shift=_get_parm_str_pos(nparm-i1,&ppParm[i1],pos0)) > 0) {
		if (len1 > 0) {	/* pa!=NULL̏܂ł */
#if 1	/* 2022.6.19 */
			_get_str_pos_posb(p1,len0,pos0,posa1);
			len1 = posa1[0];
			p1 += len1;
			if (lena && max_pa>=8) lena[7] = len1;
			len1 = posa1[1];
#else
			len2 = len1;
			if ((ret=_get_str_pos(pos0,&p1,&len2,NULL)) >= 0) {
				if (lena && max_pa>=8) lena[7] = len1 - len2;
				len1 = len2;
			}
#endif
		}
	}

	if (pa) pa[0] = p1;
	if (lena) {
		lena[0] = len1;
		if (max_pa >= 6) lena[5] = len0;
		if (max_pa >= 7) lena[6] = pos0[0];
		if (max_pa >= 9) lena[8] = pos0[2] + i1;
	}

	return shift;
}

/********1*********2********3*********4*********5*********6******/
/*  : IN													*/
/*			nparm	 : p[^								*/
/*			ppParm[] : ȉ̊֐p[^						*/
/*					IN (line[,start,len],pat,opt,escape)		*/
/*					REP(line[,start,len],pat,rep,opt,escape)	*/
/*			pa[]	 : ̃̕|C^z					*/
/*						p1[1]:NULL/char w[32*4]̐擪AhX	*/
/*			pos_opt	 :IvV								*/
/*						=3:in, =4:like							*/
/*			shift    :  = 0 : start,len Ȃ					*/
/*						= 1 : start     					*/
/*						= 2 : start,len 					*/
/*			lena[]	 : lena[8] : paẗʒu						*/
/*		  OUT													*/
/*			pa[]	 : ̃̕|C^z					*/
/*						p1[1]:pat̐擪AhX					*/
/*						pos_opt = 3 (in)̂Ƃ					*/
/*							p1[2]:opt							*/
/*						pos_opt = 4 (rep)̂Ƃ					*/
/*							p1[2]:rep							*/
/*							p1[3]:opt							*/
/*						optlŵƂ́Ap1[]=NULL,		*/
/*						llen[]ɐݒ肳					*/
/*			lena[]	 : z(oCg)							*/
/*						lena[0]:p[0]̒(oCg)				*/
/*						lena[1]:p[1]̒(oCg)				*/
/*						lena[2]:p[2]̒(oCg)				*/
/*						lena[3]:p[3]̒(oCg)				*/
/****************************************************************/
static int _get_pat_rep(nparm,ppParm,pa,lena,pos_opt,shift)
int nparm,lena[],pos_opt,shift;
tdtInfoParm **ppParm;
char *pa[];
{
	int ret,i,j,n,nn,inx_opt,atr,val;
	tdtInfoParm *pInfoParm;

	n = X_MIN(nparm,pos_opt);
	for (i=2;i<n;i++) {
		pa[i] = pa[i-1] + 32;
	}
	ret = 0;
	nn = X_MIN(nparm,pos_opt+shift);
	inx_opt = pos_opt -1 ;
	for (i=1,j=1;i<nn;i++) {
		if ((i==1 && shift) || (i==2 && shift==2)) ;
		else {
			pInfoParm = ppParm[i];
			if (ret=cl_check_data_id(pInfoParm,0)) ret += ECL_CHK_VAR_ERROR;
			else {
				atr = pInfoParm->pi_attr;
				if (j == inx_opt) {
					if (atr == DEF_ZOK_CHAR) 
						ret = parm_to_char(pInfoParm,&pa[j],NULL);
					else if (atr==DEF_ZOK_BINA || atr==DEF_ZOK_FLOA || atr==DEF_ZOK_DECI) {
						pa[j] = NULL;
						if ((ret=cl_get_parm_bin(pInfoParm,&val,"_get_pat_rep:")) >= 0) ret = val;
/*
printf("_get_pat_rep: j=%d ret=%d\n",j,ret);
*/
					}
					else {
						ERROROUT(FORMAT(395));	/* f[^^słB*/
						ret = ECL_SCRIPT_ERROR;
					}
				}
				else ret = parm_to_char(pInfoParm,&pa[j],NULL);
/*
printf("_get_pat_rep: pa[%d]=[%s]\n",j,pa[j]);
*/
			}
			if (ret < 0) break;
			lena[j++] = ret;
		}
		ret = 0;
	}
	if (n < pos_opt) pa[inx_opt] = NULL;
	return ret;
}

/********1*********2********3*********4*********5*********6******/
/*  : IN													*/
/****************************************************************/
int _get_edit_rep_pat(pat,patlen,escape,iOpt,pa,lena)
char *pat,escape,*pa[];
int patlen,iOpt[],lena[];
{
	char *plen1,*plen2,c,c1,c2,*p;
	int ret,iTOP,iG,iBTM,iRVS;

	if (!pat) return -1;
	if (patlen <= 0) return 0;
	p = pat;
	plen1 = p + patlen - 1;
	if (!(pat = cl_tmp_const_malloc(patlen+3))) {
		return ECL_MALLOC_ERROR;
	}
	iG   = iOpt[1];
	iTOP = iOpt[2];
	iBTM = iOpt[3];
	iRVS = iOpt[5];
	memzcpy(pat+1,p,patlen);
	if (patlen==1 && *p==escape) {
		*pat = '%';
		*(pat+2) = escape;
		*(pat+3) = '%';
		patlen = 4;
	}
	else {
		if (patlen >= 2) plen2 = plen1 - 1;
		else plen2 = plen1 + 1;
		if ((c=*p) == '^') {
			iTOP = 1;
			iG = 0;
			pat += 2;
			patlen--;
		}
		else if (c == '%') {
			pat++;
		}
		else if (c == '$') pat++;
		else {
			*pat = '%';
			patlen++;
		}
		if ((c2=*plen2) != escape) {
			if ((c1=*plen1) == '$') {
				iBTM = 1;
				iG = 0;
				patlen--;
			}
			else if (c1 == '%') ;
			else if (c1 != '^') {
				*(pat+patlen) = '%';
				patlen++;
			}
		}
		else {
			*(pat+patlen) = '%';
			patlen++;
		}
	}
	*(pat+patlen) = '\0';
	if (iRVS) {
		if (!(p = cl_tmp_const_malloc(patlen+1))) {
			ret = ECL_MALLOC_ERROR;
		}
		else {
			_like_pat_rzcpy(p,pat,patlen);
			pat = p;
		}
	}
	pa[4] = pat;
	lena[4] = patlen;
	iOpt[1] = iG;
	iOpt[2] = iTOP;
	iOpt[3] = iBTM;
	return ret;
}

/********1*********2********3*********4*********5*********6******/
/* @\ : QƃIvV񒆂ɂIIvV񒆂	*/
/*		  ɑΉIvVORԂ					*/
/*  : IN													*/
/*			sel_opt_str : IIvV(ignore case)		*/
/*											  (\[gsv)		*/
/*						  NULL̂Ƃ́Aref_opt_strgp	*/
/*			max_sel_opt : IIvV				*/
/*			ref_opt_str : QƃIvV(啶)(~)	*/
/*			max_ref_opt : QƃIvV				*/
/*			ref_opta[]  : QƃIvVz					*/
/* ԋp : IIvVlOR									*/
/*			ref_opt_str=NULL or ref_opta=NULL or max_ref_opt<=0	*/
/*			̂Ƃ́A0 Ԃ									*/
/****************************************************************/
int _get_sel_ref_opt(sel_opt_str,max_sel_opt,ref_opt_str,max_ref_opt,ref_opta)
char *sel_opt_str,*ref_opt_str;
int max_sel_opt,max_ref_opt,ref_opta[];
{
	int i,j,opt,*ref_opt,i_sel,i_ref,max_i;
	char *p_sel,*p_ref,c_sel,c_ref,max_c,c;

	if (!ref_opt_str || !ref_opta || max_ref_opt<=0 || max_sel_opt<=0) return 0;
	if (!sel_opt_str) {
		sel_opt_str = ref_opt_str;
		max_sel_opt = max_ref_opt;
	}
/*
printf("_get_sel_ref_opt: max_sel_opt=%d sel_opt_str=[%s]\n",max_sel_opt,sel_opt_str);
printf("_get_sel_ref_opt: max_ref_opt=%d sel_ref_str=[%s]\n",max_ref_opt,ref_opt_str);
*/
	/*
	   sel_opt_str啶ɕϊ
	*/
	p_sel = sel_opt_str;
	for (i=0;i<max_sel_opt;i++) {
		*p_sel = akxcupper(*p_sel);
		p_sel++;
	}
/*
printf("_get_sel_ref_opt: upper: sel_opt_str=[%s]\n",sel_opt_str);
*/
	/*
	   sel_opt_str~Ƀ\[g
	*/
	akxnstrsort_opt(sel_opt_str,max_sel_opt,1);
/*
printf("_get_sel_ref_opt: sort : sel_opt_str=[%s]\n",sel_opt_str);
*/
	/*
	   }b`OɂIIvVlOR
	*/
	opt = 0;
	p_sel = sel_opt_str;
	p_ref = ref_opt_str;
	ref_opt = ref_opta;
	i_sel = i_ref = 0;
	for (;;) {
		if (i_sel>=max_sel_opt && i_ref>=max_ref_opt) break;
		c_sel = *p_sel;
		c_ref = *p_ref;
		if ((!c_sel || c_sel==' ') && (!c_ref || c_ref==' ')) break;
		if (c_sel == c_ref) {
			opt |= *ref_opt;
			ref_opt++;
			p_sel++;
			p_ref++;
			i_sel++;
			i_ref++;
		}
		else if (c_sel < c_ref) {
			ref_opt++;
			p_ref++;
			i_ref++;
		}
	/*	else if (c_sel > c_ref) {	*/
		else {
			p_sel++;
			i_sel++;
		}
	}
/*
printf("_get_sel_ref_opt: opt=%08x\n",opt);
*/
	return opt;
}

/********1*********2********3*********4*********5*********6******/
/* @\ : replikepIvV(IZOLIG)IIvV		*/
/*		  񒆂̕ɑΉIvVORԂ			*/
/*  : IN													*/
/*			sel_opt_str : IIvV(ignore case)		*/
/*											  (\[gsv)		*/
/*			max_sel_opt : IIvV				*/
/* ԋp : IIvVlOR									*/
/*		  sel_opt_str=NULL̂Ƃ́AreplikepIvVlԂ	*/
/****************************************************************/
int _get_opt_replike(sel_opt_str,max_sel_opt)
char *sel_opt_str;
int max_sel_opt;
{
	static char *ref_opt_str = "ZROLIG";
	static int ref_opta[] = {AKX_LIKE_IGN_HAZE,AKX_LIKE_REVERSE, D_LINE_PAT_ONLY>>8,
	                         AKX_LIKE_LNGMATCH,AKX_LIKE_IGN_CASE,D_LINE_PAT_GLOBAL>>8};

	return _get_sel_ref_opt(sel_opt_str,max_sel_opt,ref_opt_str,strlen(ref_opt_str),ref_opta);
}

/********1*********2********3*********4*********5*********6******/
/*  : IN													*/
/*			nparm	 : p[^								*/
/*			ppParm[] : ȉ̊֐p[^						*/
/*					INLIKE (line[,start,len],pat,opt,escape)	*/
/*					REPLIKE(line[,start,len],pat,rep,opt,escape)*/
/*			pos_opt	 :IvV								*/
/*						0x000f : =4:replike, =3:inlike			*/
/*						0x1000 : revers							*/
/*						0x2000 : Œv[h					*/
/*		  OUT													*/
/*			p1[]	 : ̃̕|C^z					*/
/*						p1[0]:line+start						*/
/*						p1[1]:pat̐擪AhX				*/
/*						pos_opt = 3 (inlike)̂Ƃ				*/
/*							p1[2]:opt							*/
/*						pos_opt = 4 (replike)̂Ƃ				*/
/*							p1[2]:rep							*/
/*							p1[3]:opt							*/
/*						p1[4]:ҏWpat						*/
/*						p1[5]:line̐擪AhX				*/
/*			len[]	 : z(oCg)							*/
/*						len[0]:p[0]̒(oCg)				*/
/*						len[1]:p[1]̒(oCg)				*/
/*						len[2]:p[2]̒(oCg)				*/
/*						len[3]:p[3]̒(oCg)				*/
/*						len[4]:p[4]̒(oCg)				*/
/*						len[5]:linẽoCg					*/
/*						len[6]:start							*/
/*						len[7]:start܂ŃXLbvoCg	*/
/*			iOpt[]	 : ݒIvV							*/
/*						iOpt[0] = iCASE							*/
/*						iOpt[1] = iG							*/
/*						iOpt[2] = iTOP							*/
/*						iOpt[3] = iBTM							*/
/*						iOpt[4] = iONLY							*/
/*						iOpt[5] = iRVS | iLCMP					*/
/*			pplike	 : LIKE\̂ւ̃|C^ԂAhX		*/
/****************************************************************/
int _get_line_pat(nparm,ppParm,p1,len,iOpt,pplike,pos_opt)
int nparm,len[],iOpt[];
tdtInfoParm **ppParm;
char *p1[];
tdtLike **pplike;
int pos_opt;
{
	static tdtLike *plike=NULL;
	int  optw,iCASE,iG,iTOP,iBTM,iONLY,iRVS,iLCMP;
	int  i,n,ret,opt,patlen,ll,pos_escape,pos0_opt,pos0_escape,j,shift,nn,code_type1,code_type2,iM1,iM2;
	char *p,*pat,*plen1,*pp,*plen2,c,c1,c2;
	uchar *pesc,escape;
	tdtInfoParm *pInfoParm;

	mem_set_int(len,0,8);
	mem_set_addr(&p1[2],NULL,5);
	code_type1 = cl_get_char_code_type(ppParm[0],1);
	iM1 = cl_is_mbyte(ppParm[0],code_type1);
	p1[1] = p1[0] + 32;
	if ((shift=_get_text_str_pos(nparm,ppParm,p1,len,9)) < 0) return shift;
	code_type2 = cl_get_char_code_type(pInfoParm=ppParm[shift+1],1);
	iM2 = cl_is_mbyte(pInfoParm,code_type2);
/*
printf("_get_line_pat: shift=%d code_type1=%d code_type2=%d iM1=%d iM2=%d\n",shift,code_type1,code_type2,iM1,iM2);
*/
	if ((iM1 | iM2) && akxq_code_type_cmp(code_type1,code_type2)) {
		ERROROUT3(FORMAT(648),"cl_replace",code_type1,code_type2);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
		return ECL_SCRIPT_ERROR;
	}
	iTOP = iBTM = 0;
	iG    = pos_opt & D_LINE_PAT_GLOBAL;
	iONLY = pos_opt & D_LINE_PAT_ONLY;
	optw = pos_opt>>8;
	iCASE = optw & (AKX_LIKE_IGN_CASE | AKX_LIKE_IGN_HAZE);
	iRVS  = optw & AKX_LIKE_REVERSE;
	iLCMP = optw & AKX_LIKE_LNGMATCH;
	pos_opt &= 0x0f;
	pos_escape = pos_opt + 1;
	pos0_opt = pos_opt - 1;
	pos0_escape = pos_escape - 1;

	if ((ret=_get_pat_rep(nparm,ppParm,p1,len,pos_opt,shift)) < 0) return ret;
/*
cl_str_conv_put(&pp,p1[1],len[1]);
printf("_get_line_pat: pat=[%s] opt=[%s]\n",pp,p1[pos0_opt]);
if (pat != pp) Free(pp);
*/
#if 1	/* 2022.10.21 */
	if (p = p1[pos0_opt]) {
		n = _get_opt_replike(p,strlen(p));
	}
	else n = len[pos0_opt];
	if (n > 0) {
#else
	if (p = p1[pos0_opt]) {
		if (inistr(p,"i")) iCASE |= AKX_LIKE_IGN_CASE;
		if (inistr(p,"g")) iG = 1;
		if (inistr(p,"o")) iONLY = 1;
		if (inistr(p,"z")) iCASE |= AKX_LIKE_IGN_HAZE;
		if (inistr(p,"l")) iLCMP = AKX_LIKE_LNGMATCH;
		if (inistr(p,"r")) iRVS = AKX_LIKE_REVERSE;
	}
	else if ((n=len[pos0_opt]) > 0) {
#endif
		iG    = n & (D_LINE_PAT_GLOBAL>>8);
		iONLY = n & (D_LINE_PAT_ONLY>>8);
		iCASE = n & (AKX_LIKE_IGN_CASE | AKX_LIKE_IGN_HAZE);
		iRVS  = n & AKX_LIKE_REVERSE;
		iLCMP = n & AKX_LIKE_LNGMATCH;
/*
printf("_get_line_pat: n=%08x iCASE=%d iG=%d iONLY=%d iLCMP=%02x iRVS=%02x\n",n,iCASE,iG,iONLY,iLCMP,iRVS);
*/
	}
	plike = *pplike;
	opt = iCASE | iLCMP | SET_TYPE_OPT(code_type1);
	if (plike) plike->lk_option = opt;
	else if (!(plike = akxs_xlike_new(0,opt))) return -1;
	*pplike = plike;

/*	escape = 0xff;	*/
	if (nparm >= pos_escape+shift) {
		if ((ret=parm_to_char_tmp(ppParm[pos0_escape+shift],&pesc,0)) < 0) goto Err;
		if (!(escape = *pesc)) escape = 0xff;
		plike->lk_escape = escape;
	}
	else escape = akxs_like_escape(0xff);
	if (iRVS) {
		if (!(p = cl_tmp_const_malloc(len[0]+1))) {
			ret = ECL_MALLOC_ERROR;
			goto Err;
		}
		cmn_mrzcpy(p,p1[0],len[0]);
		p1[0] = p;
	}
	if ((ret=akxs_xlike_set_line(plike,p1[0],len[0])) < 0) goto Err;

	pat = p = p1[1];
	patlen = len[1];
#if 1	/* 2022.10.11 */
	iOpt[1] = iG;
	iOpt[2] = iTOP;
	iOpt[3] = iBTM;
	iOpt[5] = iRVS;
	ret = _get_edit_rep_pat(pat,patlen,escape,iOpt,p1,len);
	iOpt[0] = iCASE;
#else
  if (patlen > 0) {
	plen1 = p + patlen - 1;
	if (!(pat = cl_tmp_const_malloc(patlen+3))) {
		ret = ECL_MALLOC_ERROR;
		goto Err;
	}
	memzcpy(pat+1,p,patlen);

	if (patlen==1 && *p==escape) {
		*pat = '%';
		*(pat+2) = escape;
		*(pat+3) = '%';
		patlen = 4;
	}
	else {
		if (patlen >= 2) plen2 = plen1 - 1;
		else plen2 = plen1 + 1;
		if ((c=*p) == '^') {
			iTOP = 1;
			iG = 0;
			pat += 2;
			patlen--;
		}
		else if (c == '%') {
			pat++;
		}
		else if (c == '$') pat++;
		else {
			*pat = '%';
			patlen++;
		}
		if ((c2=*plen2) != escape) {
			if ((c1=*plen1) == '$') {
				iBTM = 1;
				iG = 0;
				patlen--;
			}
			else if (c1 == '%') ;
			else if (c1 != '^') {
				*(pat+patlen) = '%';
				patlen++;
			}
		}
		else {
			*(pat+patlen) = '%';
			patlen++;
		}
	}
	*(pat+patlen) = '\0';
	if (iRVS) {
		if (!(p = cl_tmp_const_malloc(patlen+1))) {
			ret = ECL_MALLOC_ERROR;
			goto Err;
		}
		_like_pat_rzcpy(p,pat,patlen);
		pat = p;
	}
/*
printf("_get_line_pat: iCASE=%d iG=%d iONLY=%d iLCMP=%02x iRVS=%02x iTOP=%d iBTM=%d\n",
iCASE,iG,iONLY,iLCMP,iRVS,iTOP,iBTM);
cl_str_conv_put(&pp,pat,patlen);
printf("_get_line_pat: la=%d patlen=%d pat=[%s]\n",plike->lk_la,patlen,pp);
if (pat != pp) Free(pp);
*/
  }
	p1[4] = pat;
	len[4] = patlen;
	iOpt[0] = iCASE;
	iOpt[1] = iG;
	iOpt[2] = iTOP;
	iOpt[3] = iBTM;
#endif
	iOpt[4] = iONLY;
	iOpt[5] = iRVS | iLCMP;
	return 0;
 Err:
/*
printf("_get_line_pat:Exit ret=%d\n",ret);
*/
	akxs_xlike_free(plike);
	*pplike = NULL;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_replace(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int ret,shift,posa[2],old_len,m,pat_len,i_yen,lena[9],opt,d_len,i,len1,rem,code_type1,code_type2,iM1;
	char *old_str,*pat,*p,c,w1[128],*pa[7],*p0;
	tdtInfoParm *pInfoParm,tInfoParm;

	code_type1 = cl_get_char_code_type(ppParm[0],1);
	iM1 = cl_is_mbyte(ppParm[0],code_type1);
	pa[0] = w1;
	pa[1] = pa[0] + 32;
	shift = _get_text_str_pos(nparm,ppParm,pa,lena,9);
/*
printf("cl_replace: shift=%d lena[0]=%d lena[5]=%d lena[6]=%d lena[7]=%d\n",shift,lena[0],lena[5],lena[6],lena[7]);
*/
	if (nparm < shift+3) {
		return ECL_FEW_PARAMETER;
	}
	code_type2 = cl_get_char_code_type(ppParm[shift+1],1);
	iM1 |= cl_is_mbyte(ppParm[shift+1],code_type2);
	if (iM1 && akxq_code_type_cmp(code_type1,code_type2)) {
		ERROROUT3(FORMAT(648),"cl_replace",code_type1,code_type2);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
		return ECL_SCRIPT_ERROR;
	}
	if ((ret=_get_pat_rep(nparm,ppParm,pa,lena,4,shift)) < 0) return ret;
	for (i=0;i<nparm-shift;i++) {
		if (!pa[i]) return -1;
/*
printf("cl_replace: lena[%d]=%d pa[%d]=[%s]\n",i,lena[i],i,pa[i]);
*/
	}
	if (p=pa[3]) {
		opt = 0;
		if (inistr(p,"i")) opt |= 0x01;
		if (inistr(p,"z")) opt |= 0x20;
		if (inistr(p,"k")) opt |= 0x4000;
	}
	else opt = lena[3];

  if (!(opt & 0x4000)) {
	d_len = lena[0] + 1;
	if (lena[1]>0 && lena[2]>lena[1]) {
		d_len = (lena[0]/lena[1]+1)*lena[2] + 1;
	}
	len1 = lena[7] + lena[0];
	d_len += len1 + lena[5];
/*
printf("cl_replace: d_len=%d\n",d_len);
*/
	if (!(p0 = cl_tmp_const_malloc(d_len+3))) return ECL_MALLOC_ERROR;
	p = p0;
	p = cl_set_type_to_string(p,d_len,code_type1);
/*	if (d_len>0 && code_type) {
		*p++ = 0x01;
		*p++ = code_type;
	}	*/
	if (lena[7]) {
		memcpy(p,pa[5],lena[7]);
		p += lena[7];
	}
	opt |= SET_TYPE_OPT(code_type1);
	ret = akxcreplace_opt2(p,d_len,pa[0],lena[0],pa[1],pa[2],opt);
	if (ret >= 0) {
		d_len = ret;
		rem = lena[5] - len1;
/*
printf("cl_replace: d_len=%d rem=%d len1=%d\n",d_len,rem,len1);
*/
		if (rem > 0) memzcpy(p+d_len,pa[5]+len1,rem);
		ret = 0;
	}
	*pAns = p0;
  }
  else {
	pInfoParm = ppParm[shift+1];
	if ((old_len=parm_to_char_tmp(pInfoParm,&old_str,0)) < 0) return old_len;
	if (!(pat = cl_tmp_const_malloc(old_len+old_len+1))) return ECL_MALLOC_ERROR;
	p = pat;
	pat_len = m = i_yen = 0;
	while (old_len > 0) {
	/*	m = akxqkanjilen2(old_str,old_len);	*/
		m = akxqmbsnlen(code_type1,old_str,old_len);
		if (m == 1) {
			if ((c=*old_str)=='%' || c=='_'/* || c=='\\'*/) {
				*p++ = '\\';
				pat_len++;
				i_yen = 1;
			}
			*p++ = c;
		}
		else {
			memcpy(p,old_str,m);
			p += m;
		}
		pat_len += m;
		old_str += m;
		old_len -= m;
	}
	if (i_yen) {
		*p = '\0';
/*
printf("cl_replace: pat_len=%d pat=[%s]\n",pat_len,pat);
*/
		cl_set_parm_char2(&tInfoParm,pat,pat_len,code_type1);
		ppParm[shift+1] = &tInfoParm;
	}
	ret = cl_rep_like(pAns,nparm,ppParm);
	ppParm[shift+1] = pInfoParm;
  }
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_repchar(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int ret,shift,posa[3],old_len,m,pat_len,code_type1,code_type2,dtlen,iM1,iM2;
	char *old_str,*p,c,pat[6];
	tdtInfoParm *pInfo1,*pInfo2,tInfo1,tInfo2;
	ParList2 par2;

	pInfo1 = ppParm[0];
	code_type1 = cl_get_char_code_type(pInfo1,1);
	iM1 = cl_is_mbyte(pInfo1,code_type1);
	shift = _get_parm_str_pos(nparm,ppParm,posa);
	if (nparm < shift+3) {
		return ECL_FEW_PARAMETER;
	}
	pInfo2 = ppParm[shift+1];
	code_type1 = cl_get_char_code_type(pInfo2,1);
	iM2 = cl_is_mbyte(pInfo2,code_type2);
	if ((iM1 | iM2) && akxq_code_type_cmp(code_type1,code_type2)) {
		ERROROUT3(FORMAT(648),"cl_repchar",code_type1,code_type2);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
		return ECL_SCRIPT_ERROR;
	}
	ppParm[shift+1] = &tInfo2;
	if ((old_len=parm_to_char_tmp(pInfo2,&old_str,0)) < 0) return old_len;
	while (old_len > 0) {
	/*	m = akxqkanjilen2(old_str,old_len);	*/
		m = akxqmbsnlen(code_type1,old_str,old_len);
		p = pat;
		pat_len = m;
		if (m == 1) {
			if ((c=*old_str)=='\\') {
				*p++ = c;
				old_str++;
				old_len--;
			/*	m = akxqkanjilen2(old_str,old_len);	*/
				m = akxqmbsnlen(code_type1,old_str,old_len);
				pat_len += m;
			}
		}
		memzcpy(p,old_str,m);
/*
printf("cl_repchar: pat_len=%d pat=[%s]\n",pat_len,pat);
*/
		cl_set_parm_char2(&tInfo2,pat,pat_len,code_type1);
		if ((ret=cl_replace(pAns,nparm,ppParm)) < 0) break;
		if (p = *pAns) {
			dtlen = strlen(p);
			if ((ret=cl_sep_string_with_type(&par2,p,dtlen)) > 0) {
				code_type1 = par2.option;
				p = par2.par;
				dtlen = par2.parlen;
			}
/*
printf("cl_repchar: *pAns=[%s]\n",p);
*/
			cl_set_parm_char2(&tInfo1,p,dtlen,code_type1);
			ppParm[0] = &tInfo1;
			old_str += m;
			old_len -= m;
		}
		else {
			ret = ECL_SYNTAX_ERROR;
			break;
		}
	}
	ppParm[shift+1] = pInfo2;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_repstrs(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int ret,shift,posa[3],i,code_type1,code_type2,dtlen;
	char *p;
	tdtInfoParm tInfo1,*pParm[6];
	ParList2 par2;

	code_type1 = cl_get_char_code_type(ppParm[0],1);
	shift = _get_parm_str_pos(nparm-1,ppParm+1,posa);
/*
printf("cl_repstrs: shift=%d\n",shift);
*/
	if (nparm < shift+4) {
		return ECL_FEW_PARAMETER;
	}
	mem_cpy_addr(pParm,ppParm+1,shift+1);
	pParm[shift+2] = ppParm[nparm-1];
	pParm[shift+3] = ppParm[0];
	for (i=0;i<nparm-(shift+3);i++) {
		pParm[shift+1] = ppParm[shift+2+i];
		if ((ret=cl_replace(pAns,shift+4,pParm)) < 0) break;
		if (p = *pAns) {
			dtlen = strlen(p);
			if ((ret=cl_sep_string_with_type(&par2,p,dtlen)) > 0) {
				code_type1 = par2.option;
				p = par2.par;
				dtlen = par2.parlen;
			}
/*
printf("cl_repstrs: pAns=[%s]\n",p);
*/
			cl_set_parm_char2(&tInfo1,p,dtlen,code_type1);
			pParm[0] = &tInfo1;
		}
		else {
			ret = ECL_SYNTAX_ERROR;
			break;
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_rep_like(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	tdtLike *plike;
	int  iCASE,iG,iTOP,iBTM,pos[6],sp,iONLY,iOpt[6];
	int  i,n,ret,opt,len[9],is,patlen,ll;
	char w1[128],*p1[9],*p,*pat,*plen1,*pp,*plen2,c,c1,c2;
	uchar *pesc,escape;

	*pAns = NULL;
	plike = NULL;
	p1[0] = w1;
	if (ret=_get_line_pat(nparm,ppParm,p1,len,iOpt,&plike,4)) return ret;
/*
printf("cl_rep_like: len[0]=%d p1[0]=[%s] len[4]=%d p1[4]=[%s]\n",len[0],p1[0],len[4],p1[4]);
printf("cl_rep_like: len[1]=%d p1[1]=[%s]\n",len[1],p1[1]);
*/
	if (!len[1]) {
		ll = len[0];
		pp = p1[0];
		goto end;
	}
	pat = p1[4];
	patlen = len[4];
	iG    = iOpt[1];
	iTOP  = iOpt[2];
	iBTM  = iOpt[3];
	iONLY = iOpt[4];
	memset(pos,0,sizeof(pos));
	is = sp = 0;
	mcat.mc_ipos = 0;
	if (!(cl_get_option(18,0) & 0x04) && !iONLY && len[7]>0) {
/*
printf("cl_rep_like: len[7]=%d p1[5]=[%s]\n",len[7],p1[5]);
*/
		if ((ret=akxtmcat(&mcat,p1[5],len[7]))<0) goto err;
	}
	if (patlen == 0) {
		if (iTOP) {
			if ((ret=akxtmcat(&mcat,p1[2],len[2]))<0) goto err;
		}
		if ((ret=akxtmcat(&mcat,p1[0],len[0]))<0) goto err;
		if (iBTM) {
			if ((ret=akxtmcat(&mcat,p1[2],len[2]))<0) goto err;
		}
	}
	else {
#if 1	/* 2022.3.26 */
		if ((ret=akxs_xlike_set_pat(plike,pat,patlen)) < 0) goto err;
#endif
		while (sp < plike->lk_la) {
			ret = akxs_pxlike(plike,pos);
			if (!ret) {
/*
printf("cl_rep_like: is=%d pos=%d %d %d %d\n",is,pos[0],pos[1],pos[2],pos[3]);
*/
				if (iONLY) {
					if ((ret=akxtmcat(&mcat,p1[0]+pos[0],pos[1]))<0) goto err;
				}
				else {
					if ((ret=akxtmcat(&mcat,p1[0]+is,pos[0]-is))<0) goto err;
					if ((ret=akxtmcat(&mcat,p1[2],len[2]))<0) goto err;
				}
				is = pos[0] + pos[1];
				if (iG) sp = pos[2] + pos[3];
				else break;
			}
			else {
				if (ret < 0) goto err;
				break;
			}
		}
		if (!iONLY) {
/*
printf("cl_rep_like: len[5]=%d p1[0]+is=[%s] is=%d\n",len[5],p1[0]+is,is);
*/
			if ((ret=akxtmcat(&mcat,p1[0]+is,len[5]-is))<0) goto err;
		}
	}
	ret = 0;
	ll = mcat.mc_ipos;
	pp = mcat.mc_bufp;
 end:
	if (ll > 0) {
		if (p = cl_tmp_const_malloc(ll+1)) {
			memzcpy(p,pp,ll);
/*
printf("cl_rep_like: ll=%d p=[%s]\n",ll,p);
*/
			*pAns = p;
		}
		else ret = -1;
	}
 err:
/*
printf("cl_rep_like:Exit ret=%d\n",ret);
*/
	akxs_xlike_free(plike);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_shsbs(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	tdtInfoParm tInfoParm,*pInfoParm,*pInfo;
	int ret,pos0[2],len1,shift,code_type,code_pat,m,iM1;
	char *pcmd,*pat,c,sep,cmd,*perr,*p1;

	pInfoParm = ppParm[0];
	code_type = cl_get_char_code_type(pInfoParm,1);
	iM1 = cl_is_mbyte(pInfoParm,code_type);
	/* 2022.3.17 */
	if ((shift=_get_text_str_pos(nparm,ppParm,&p1,&len1,1)) < 0) return shift;
	pInfoParm = &tInfoParm;
	cl_set_parm_char2(pInfoParm,p1,len1,code_type);

	cmd = '\0';
	perr = NULL;
	pat = NULL;
	if ((ret=parm_to_char(pInfo=ppParm[shift+1],&pat,NULL)) > 0) {
		code_pat = cl_get_char_code_type(pInfo,1);
		iM1 |= cl_is_mbyte(pInfo,code_pat);
		if (iM1 && akxq_code_type_cmp(code_type,code_pat)) {
			ERROROUT3(FORMAT(648),"cl_shsbs",code_type,code_pat);	/* %s: R[hقȂĂ܂B1=%d 2=%d */
			return ECL_SCRIPT_ERROR;
		}
		m = akxqmbsnlen(code_pat,pat,ret);
		if (m == 1) ret = akxtstrim(SET_TYPE_OPT(code_pat),pat,ret,AKX_TRIM_SPACE2);
	}
	if (ret > 0) {
		if (m==1 && ((c=*pat)=='%' || c=='#' || c=='/' || c=='s' || c=='S')) {
			ret = cl_gx_str_edit(pInfoParmW,pInfoParm,pat,ret);
		}
		else {
			if (!perr) perr = pat;
			ERROROUT2(FORMAT(628),"cl_shsbs",perr);	/* %s: ҏWw[%s]Ă܂B*/
			ret = ECL_SYNTAX_ERROR;
		}
	}
	else if (!ret) {
		ERROROUT1(FORMAT(629),"cl_shsbs");	/* %s: ҏWw肪łB*/
		return ECL_SYNTAX_ERROR;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_glip_grep(pInfoParmW,nparm,ppParm,iLIKE)
tdtInfoParm *pInfoParmW;
int  nparm,iLIKE;
tdtInfoParm **ppParm;
{
	static char *pnama[]={"OPT"};
	MCAT mcat;
	tdtInfoParm tInfoParm,*pInfoParm,*pParmW[1];
	int ret,pos0[2],lena[9],shift,len1,optw,opt,iOpt[6],patlen,atr;
	int i,i1,k,len,posa[3],posa1[4],ii,lenw,i_min,i_max,iOPT,max_layer,i_elm;
	char *pcmd,*pat,c,sep,cmd,escape,*pa[9],*p1,*p,*pp;
	tdtLike *plike, **plikea;
	regex_t *preg,**prega;
	char errbuf[256];
	int errcode,flags[2];
	long lVal1;
	tdtIterate_ctl tIter_ctl;
	tdtIterate *pIter;

	cl_null_data(pInfoParmW);
	memset(&mcat,0,sizeof(MCAT));
	mcat.mc_extlen = 256;
	iOPT = opt = 0;
	pParmW[0] = NULL;
	if ((ret=cl_get_pname_info(nparm,ppParm,pParmW,pnama,1)) > 0) {
		pInfoParm = pParmW[0];
		if (pInfoParm->pi_id == ' ') {
			if ((atr=pInfoParm->pi_attr) == DEF_ZOK_CHAR) {
				p1 = NULL;
				if ((ret=parm_to_char(pParmW[0],&p1,NULL)) < 0) return ret;
				opt = _get_opt_replike(p1,ret);
			}
			else /*if ((atr=pInfoParm->pi_attr) == DEF_ZOK_BINA)*/ {
				if ((ret=cl_get_parm_long(pParmW[0],&lVal1,"opt:")) < 0) return ret;
				opt = lVal1;
			}
		}
		iOPT = 1;
/*
printf("cl_glip_grep: opt=%08x\n",opt);
*/
	}
#if 1	/* 2022.10.20 */
	if ((i1=_get_pos_text(nparm,ppParm)) < 0) return i1;
	else if (!i1) {
		ERROROUT2(FORMAT(76),"cl_glip_grep","text");		/* %s: %s܂B*/
		return ECL_SCRIPT_ERROR;
	}
	i1--;
#endif
#if 1	/* 2022.10.24 */
	max_layer = -1;
	if ((ret=cl_iterate_info_init(&tIter_ctl,NULL,ppParm[i1],max_layer)) < 0) return ret;
#else
	p1 = NULL;
	if ((len1=parm_to_char(ppParm[i1],&p1,NULL)) < 0) return len1;
#endif
	/*
	   w肪΁Astart,len擾
	*/
	if ((shift=_get_parm_str_pos(nparm-i1,&ppParm[i1],posa)) < 0) return shift;
/*
printf("cl_glip_grep: shift=%d posa[0]=%d posa[1]=%d len1=%d p1=[%s]\n",shift,posa[0],posa[1],len1,p1);
*/
	/*
	   w肪΁Aoption擾
	*/
	if (!iOPT) {
		if (shift < nparm-1) {
			nparm = _get_nparm_opt(nparm,ppParm,&optw);
/*
printf("cl_glip_grep: optw=%08x\n",optw);
*/
			opt = optw;
		}
	}
/*	k = nparm - shift;	*/
	i1 += posa[2];
	k = nparm - i1 + 1;
/*
printf("cl_glip_grep: i1=%d k=%d p1=[%s]\n",i1,k,p1);
*/
	if (iLIKE) {
		/*
		   p^[̉͌ʂۑLIKE\̂ւ̃|C^mۂ
		*/
		if (!(plikea = (tdtLike **)cl_tmp_const_malloc(sizeof(tdtLike *)*k))) return ECL_MALLOC_ERROR;
	}
	else {
		/*
		   p^[̉͌ʂۑregex_t\̂Ƃւ̃|C^mۂ
		*/
		if (!(prega = (regex_t **)cl_tmp_const_malloc(sizeof(regex_t *)*k))) return ECL_MALLOC_ERROR;
		if (!(preg = (regex_t *)cl_tmp_const_malloc(sizeof(regex_t)*k))) return ECL_MALLOC_ERROR;
		flags[0] = flags[1] = 0;
		flags[0] = REG_EXTENDED;
		if (opt & 0x01) flags[0] |= REG_ICASE;
	}
/*	i1 = shift + 1;	*/
	k = 0;
	/*
	   p^[oA͌ʂۑ
	*/
	for (i=i1;i<nparm;i++) {
		pInfoParm = ppParm[i];
		if (pInfoParm->pi_id == D_DATA_ID_PNAME) continue;
		if ((patlen=parm_to_char_tmp(pInfoParm,&pat,0)) < 0) return patlen;
		if (iLIKE) {
			mem_set_int(iOpt,0,6);
			escape = '\0';
			ret = _get_edit_rep_pat(pat,patlen,escape,iOpt,pa,lena);
/*
printf("cl_glip_grep: k=%d len1=%d p1=[%s]\n",k,lena[4],pa[4]);
*/
			if (!(plike = akxs_xlike_new(0,opt))) return -1;
			if ((ret=akxs_xlike_set_pat(plike,pa[4],lena[4])) < 0) break;
			plikea[k++] = plike;
		}
		else {
			prega[k++] = preg;
			if (errcode = regcomp(preg,pat,flags[0])) {
				ret = -1;
				goto Err;
			}
/*
printf("cl_glip_grep: regcomp k=%d preg=%08x errcode=%d\n",k,preg,errcode);
*/
			preg++;
		}
	}
	if (iLIKE) {
		/*
		   Ώۃf[^pLIKE\̂쐬
		*/
		if (!(plike = akxs_xlike_new(0,opt))) return -1;
	}

#if 1	/* 2022.10.24 */
  i_elm = 1;
  for (;;) {
	if ((ret=cl_iterate_info(&tIter_ctl)) < 0) break;
	pIter = tIter_ctl.itc_pIter;
	if (!pIter->it_pInfo) break;
	p1 = NULL;
	if ((len1=parm_to_char(pIter->it_pInfo,&p1,NULL)) < 0) {
		ret = len1;
		break;
	}
#endif
	p = p1;
	len = len1;
	i_min = posa[0];
	i_max = i_min + posa[1] - 1;
/*
printf("cl_glip_grep: i_min=%d i_max=%d\n",i_min,i_max);
*/
#if 1	/* 2022.10.24 */
	if (opt & 0x200) {
		if (i_elm < i_min) len1 = 0;	/* ̗vf̓XLbv */
		else if (i_elm > i_max) break;
		i_elm++;
	}
#endif
	ii = 1;
	while (len1 > 0) {
		len = akxnskipto(p,len1,"\r\n");	/* sR[h܂ł̒(byte)߂ */
/*
printf("cl_glip_grep: len=%d p=[%s]\n",len,p);
*/
		if (len > 0) {
			lenw = len;
			/* ܂AsŜT[`ΏۂƂ */
			posa1[0] = 0;
			posa1[1] = len;
			if (opt & 0x100) {
				if (ii < i_min)  lenw = 0;	/* ̍s̓XLbv */
				else if (ii > i_max) break;
			}
#if 1	/* 2022.10.24 */
			else if (!(opt & 0x200)) {
#else
			else {
#endif
				/* start,lenɑ΂Ώۃf[^̃oCgl߂ */
				_get_str_pos_posb(p,len,posa,posa1);
/*
printf("cl_glip_grep: posa1=%d %d %d %d\n",posa1[0],posa1[1],posa1[2],posa1[3]);
*/
			}
			if (lenw > 0) {
				p1 = p + posa1[0];
				pp = p1 + posa1[1];
				c = *pp;
				*pp = '\0';		/* ́Aregexec()p */
				if (iLIKE) {
					/* Ώۃf[^̃T[`͈͂LIKEpɐݒ肷 */
					if ((ret=akxs_xlike_set_line(plike,p1,posa1[1])) < 0) break;
				}
				/* p^[͌ʂ߂Ȃp^[}b`Os */
				for (i=0;i<k;i++) {
					if (iLIKE) {
						plike->lk_maskctl = plikea[i]->lk_maskctl;
						ret = akxs_pxlike(plike,NULL);
					}
					else {
						errcode = regexec(prega[i],p1,0,NULL,flags[1]);
						if (errcode && errcode!=REG_NOMATCH) {
							ret = -2;
							goto Err;
						}
/*
printf("cl_glip_grep: regexec i=%d preg=%08x errcode=%d\n",i,preg,errcode);
*/
						ret = errcode;
					}
/*
printf("cl_glip_grep: i=%d ret=%d\n",i,ret);
*/
					if (!ret) {
						*pp = c;	/* ȂƁAŃf[^؂ */
						/* ԋpsf[^Ԃɂ́As */
						if (mcat.mc_ipos > 0) akxtmcats(&mcat,"\n");
						akxtmcat(&mcat,p,len);
						break;
					}
					ret = 0;
				}
				*pp = c;	/* ȂƁAsR[hXLbvłɖ[v */
			}
			p += len;
			len1 -= len;
		}
		if ((len=akxnskipin(p,len1,"\r\n")) > 0) {	/* sR[h̒߂ */
/*
printf("cl_glip_grep: CrLf len=%d\n",len);
*/
			p += len;
			len1 -= len;
		}
		ii++;
	}
#if 1	/* 2022.10.24 */
  }
#endif
	if ((len=mcat.mc_ipos) > 0) {
/*
printf("cl_glip_grep: mc_ipos=%d mc_bufp=[%s]\n",len,mcat.mc_bufp);
*/
		/* mcat.mc_bufṕAFree()̂ŁAtmpɃRs[ĕԋp */
		if (p = cl_tmp_const_malloc(len+1)) {
			memzcpy(p,mcat.mc_bufp,len);
			cl_set_parm_char(pInfoParmW,p,len);
		}
		else ret = ECL_MALLOC_ERROR;
	}
	if (p=mcat.mc_bufp) Free(p);
	if (iLIKE) {
		akxs_xlike_free(plike);
		for (i=0;i<k;i++) Free(plikea[i]);
	}
	return ret;
Err:
/*
printf("cl_glip_grep: k=%d i=%d preg=%08x errcode=%d\n",k,i,preg,errcode);
*/
	regerror(errcode,preg,errbuf,sizeof(errbuf));
	ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_glip(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	return cl_glip_grep(pInfoParmW,nparm,ppParm,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_grep(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	return cl_glip_grep(pInfoParmW,nparm,ppParm,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_in_like(pWork,mflg,nparm,ppParm)
char *pWork;
int  mflg;
int  nparm;
tdtInfoParm **ppParm;
{
/* INLIKE(pos,npos,line,pat,opt,escape)	*/
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL;
	tdtArrayIndex tIndex,*pIndex;
	int  *index;
	tdtLike *plike;
	int  iCASE,iG,iTOP,iBTM,iONLY,iOpt[6],iRVS;
	int  iRc,i,len[9],is,sp,patlen,pos[4],ix,maxargs,lenm,len0;
	char w1[128],*p1[9],*pat;

	iRc = 0;
	pInfoParm = ppParm[1];
	if ((i=pInfoParm->pi_dlen)>0) {
		if (iRc = cl_get_parm_bin(pInfoParm,&maxargs,"InLike.maxargs:")) return iRc;
		if (maxargs < 0) {
			/* max_pos(%d)słB */
			ERROROUT1(FORMAT(289),maxargs);
			return -1;
		}
	}
	else maxargs = 1;
/*
printf("cl_in_like: maxargs=%d\n",maxargs);
*/
	pIndex = &tIndex;
	if (maxargs) {
		if (iRc=cl_get_ITBL_maxargs_ref(1,ppParm,&pIndex,&pTBL,0,0,0,0)) return iRc;
		index = pIndex->index;
		ix = index[3];
		if (i > 0) {
			if (maxargs > index[1]/2) {
				/* max_pos(%d)ž/2(%d)𒴂Ă܂B܂B */
				ERROROUT2(FORMAT(290),maxargs,index[1]/2);
				maxargs = index[1]/2;
			}
		}
		else maxargs = index[1]/2;
	}
	p1[0] = w1;
	plike = NULL;
	if (iRc=_get_line_pat(nparm-2,&ppParm[2],p1,len,iOpt,&plike,3)) return iRc;
	patlen = len[4];
	pat = p1[4];
	iG = iOpt[1];
	iRVS = iOpt[5] & AKX_LIKE_REVERSE;
/*
printf("cl_in_like: patlen=%d pat=%08x iG=%d iRVS=%02x\n",patlen,pat,iG,iRVS);
*/
	memset(pos,0,sizeof(pos));
	if (patlen == 0) {
		sp = plike->lk_la;
	}
	else {
		if (mflg) lenm = akxqmlen(p1[0],len[0]);
		else lenm = len[0];
#if 1	/* 2022.3.28 */
		if ((iRc=akxs_xlike_set_pat(plike,pat,patlen)) < 0) goto Err;
#endif
		sp = 0;
	}
	is = 0;
	while (sp < plike->lk_la) {
		if (patlen > 0) {
			if (iRc=akxs_pxlike(plike,pos)) {
				if (iRc < 0) goto Err;
				else break;
			}
/*
printf("cl_in_like: is=%d pos=%d %d %d %d\n",is,pos[0],pos[1],pos[2],pos[3]);
*/
		}
		if (is++ < maxargs) {
			if (mflg) {
				if (iRVS) len0 = lenm - (pos[2] + pos[3]) + 1;
				else len0 = pos[2] + 1;
				len[0] = len0;
				len[1] = pos[3];
			}
			else {
				if (iRVS) len0 = lenm - (pos[0] + pos[1]) + 1;
				else len0 = pos[0] + 1;
				len[0] = len0;
				len[1] = pos[1];
			}
			if (!(cl_get_option(18,0) & 0x02) && len[6]>1) len[0] += len[6] - 1;
			for (i=0;i<2;i++,ix++) {
				pInfoParm = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
				if (pInfoParm) {
DEBUGOUT_InfoParm(194,"cl_in_like: i=%d ix=%d",pInfoParm,i,ix);
					cl_set_parm_bin(&rInfoParm,len[i]);
					if (iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) goto Err;
				}
				else {
					iRc = -1;
					goto Err;
				}
			}
		}
		if (iG) sp = pos[0] + pos[1];
		else break;
	}
	memcpy(pWork,&is,sizeof(int));
	iRc = 0;
 Err:
/*
printf("cl_in_like:Exit iRc=%d\n",iRc);
*/
	akxs_xlike_free(plike);
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_rlpad(pAns,mflg,nparm,ppParm,ope,pOperator)
char **pAns;
int  mflg,nparm;
tdtInfoParm **ppParm;	/* (buf,num) */
int  ope;
char *pOperator;
{
	static char *Pad=" ";
	tdtInfoParm rParm[3],*pParm[2];
	int ret,len,str_len,pad_len,add_len,str_lenm,pad_lenm,add_lenm,i;
	char *pWork,*p1,*p2;
	char w1[32],*str,*pad;
/*
printf("cl_rlpad:Enter mflg=%d nparm=%d ope=%08x pOperator=[%s]\n",mflg,nparm,ope,pOperator);
*/
	*pAns = "";
	str = w1;
	if ((str_len=parm_to_char(ppParm[0],&str,NULL)) < 0) return str_len;
	if (mflg) str_lenm = akxqmlen(str,str_len);
	else str_lenm = str_len;
/*
printf("cl_rlpad: str_lenm=%d\n",str_lenm);
*/
	if (ret=cl_get_parm_bin(ppParm[1],&len,"cl_rlpad:len:")) return ret;
/*
printf("cl_rlpad: ret=%d len=%d\n",ret,len);
*/
	ret = 0;
	if (len > str_lenm) {	/* 2020.12.10 str_len --> str_lenm */
		if (nparm >= 3) {
			pad = w1;
			if ((ret=parm_to_char(ppParm[2],&pad,NULL)) < 0) return ret;
			if (!*pad) pad = Pad;
		}
		else pad = Pad;
		pad_len = strlen(pad);
		cl_set_parm_char(&rParm[0],pad,pad_len);
		if (mflg) pad_lenm = akxqmlen(pad,pad_len);
		else pad_lenm = pad_len;
		add_lenm = len-str_lenm;
		if (pad_lenm > 1) add_lenm = (add_lenm+pad_lenm-1)/pad_lenm;
/*
printf("cl_rlpad: pad=[%s] pad_len=%d pad_len=%d add_lenm=%d\n",pad,pad_len,pad_lenm,add_lenm);
*/
		add_len = add_lenm*pad_len;
		pWork = cl_tmp_const_malloc(str_len+add_len+1);
		if (ope==D_FUC_LPAD || ope==D_FUC_LPADB) {
			p2 = pWork;
			p1 = pWork + add_len;
		}
		else {
			p1 = pWork;
			p2 = pWork + str_len;
		}
		memcpy(p1,str,str_len);
		for (i=0;i<add_lenm;i++) {
			memcpy(p2,pad,pad_len);
			p2 += pad_len;
		}
		str_len += add_len;
		pWork[str_len] = '\0';
/*
printf("cl_rlpad: pWork=[%s]\n",pWork);
*/
		cl_set_parm_char(&rParm[0],pWork,str_len);
	}
	else cl_set_parm_char(&rParm[0],str,str_len);

	cl_set_parm_bin(&rParm[1],len);
	pParm[0] = &rParm[0];
	pParm[1] = &rParm[1];
	if (ope==D_FUC_LPAD || ope==D_FUC_LPADB)
		ret = cl_rightm(pAns,mflg,2,pParm);
	else
		ret = cl_leftm(pAns,mflg,2,pParm);
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*		IN  : pInfoParm    : BIN  : R[h						*/
/*							 CHAR : R[h					*/
/*			  tr_dtypea[0] : R[h̃ftHgl				*/
/*		OUT : tr_dtypea[0] : 1)R[h=0̂Ƃ́AftHg	*/
/*							   lԂB							*/
/*							   ftHgl=0̂Ƃ́Asystem		*/
/*							   R[hԂB					*/
/*							 2)R[h>0̂Ƃ́AΉ	*/
/*							   R[hԂB					*/
/*			  tr_code[0]   : R[hԂB					*/
/********************************************************************/
int cl_get_code_type(pInfoParm,tr_dtypea,tr_code)
tdtInfoParm *pInfoParm;
int  tr_dtypea[];
char *tr_code[];
{
	int  ret,len,outlen,i,i1,tr_dtype,atr,opt,i0,tr_stype;
	char ww[16],*p1,*p,**code_str;

	if (!pInfoParm && !tr_dtypea && !tr_code) return 0;
	ret = 0;
	if (tr_dtypea) tr_dtype = tr_dtypea[0];
	p = "";
	if (pInfoParm) {
		atr = pInfoParm->pi_attr;
		if (atr == DEF_ZOK_BINA) {
			tr_dtype = cl_get_data_int(pInfoParm);
		/*	if (tr_dtype==CD_TYPE_NARROW || tr_dtype==CD_TYPE_WIDE) ;	*/
		}
		else {
			p = ww;
			if (!(ret = parm_to_char(pInfoParm,&p,0))) atr = DEF_ZOK_BINA;
			else {
				code_str = akxc_get_code_str_addr();
				i0 = akxs_seqr_str(code_str,-1,p,0x31);
				if (i0 > 0) {
					tr_dtype = atoi(code_str[i0-1]);
					p = code_str[i0];
				/*	if (tr_dtype >= CD_TYPE_NARROW) ;	*/
				}
				else {
					/* ϊf[^^Cv(%s)Ă܂B*/
					ERROROUT1(FORMAT(601),p);
					ret = ECL_SCRIPT_ERROR;
				}
			}
		}
	}
	else atr = DEF_ZOK_BINA;
	if (!ret && atr==DEF_ZOK_BINA){
		if (!tr_dtype) tr_dtype = akxt_get_code_type();
		if (!(p=akxc_get_code_str(tr_dtype))) {
			/* ϊf[^^Cv(%d)Ă܂B*/
			ERROROUT1(FORMAT(602),tr_dtype);
			ret = ECL_SCRIPT_ERROR;
		}
	}
	if (tr_dtypea) tr_dtypea[0] = tr_dtype;
	if (tr_code) tr_code[0] = p;
	return ret;
}

/****************************************/
/*	rstr=str_conv(str, to [,from])		*/
/****************************************/
#if 1	/* 2022.11.21 */
int cl_func_str_conv(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
#else
int cl_func_str_conv(pAns,nparm,ppParm)
char **pAns;
#endif
int  nparm;
tdtInfoParm *ppParm[];
{
	char *outbuf;		/* output buffer  */
	int  ret,len,outlen,i,i1,tr_dtype,atr,tr_dtypea[2],opt,i0,tr_stype;
	char ww[16],*p1,*tr_code[2],*p,**code_str;
	tdtInfoParm *pInfoParm;

	p1 = ww;
	if ((ret = parm_to_char(ppParm[0],&p1,0)) < 0) return ret;
	len = ret;
/*
printf("cl_func_str_conv: len=%d p1=[%s]\n",len,p1);
*/
	ret = 0;
	/* tr_dtypea[0] : to_code   */
	/* tr_dtypea[1] : from_code */
	tr_dtypea[0] = 0;
	tr_dtypea[1] = cl_get_char_code_type(ppParm[0],1);
/*
printf("cl_func_str_conv: tr_dtypea[1]=%d\n",tr_dtypea[1]);
*/
	tr_code[0] = tr_code[1] = "";
	code_str = akxc_get_code_str_addr();
	i1 = 1;
	for (i=0;i<2;i++) {
#if 1	/* 2022.4.10 */
		if (nparm > i1) pInfoParm = ppParm[i1];
		else pInfoParm = NULL;
		if ((ret=cl_get_code_type(pInfoParm,&tr_dtypea[i],&tr_code[i])) < 0) return ret;
/*
printf("cl_func_str_conv: i=%d tr_dtype=%d tr_code=[%s]\n",i,tr_dtypea[i],tr_code[i]);
*/
		tr_dtype = tr_dtypea[i];
		if (tr_dtype==CD_TYPE_NARROW || tr_dtype==CD_TYPE_WIDE) break;
		i1++;
	}
#else
		tr_dtype = 0;
		p = "";
		if (nparm > i1) {
			pInfoParm = ppParm[i1];
			atr = pInfoParm->pi_attr;
			if (atr == DEF_ZOK_BINA) {
				tr_dtype = cl_get_data_int(pInfoParm);
				if (tr_dtype==CD_TYPE_NARROW || tr_dtype==CD_TYPE_WIDE) break;
			}
			else {
				p = ww;
				if ((ret = parm_to_char(ppParm[i1],&p,0)) < 0) return ret;
				else if (!ret) atr = DEF_ZOK_BINA;
				else {
					i0 = akxs_seqr_str(code_str,-1,p,0x31);
					if (i0 > 0) {
						tr_dtype = atoi(code_str[i0-1]);
						p = code_str[i0];
						if (tr_dtype >= CD_TYPE_NARROW) break;
					}
					else {
						/* ϊf[^^Cv(%s)Ă܂B*/
						ERROROUT1(FORMAT(601),p);
						return ECL_SCRIPT_ERROR;
					}
				}
			}
		}
		else atr = DEF_ZOK_BINA;
		if (atr == DEF_ZOK_BINA){

			if (!tr_dtype) tr_dtype = akxt_get_code_type();
			if (!(p=akxc_get_code_str(tr_dtype))) {
				/* ϊf[^^Cv(%d)Ă܂B*/
				ERROROUT1(FORMAT(602),tr_dtype);
				return ECL_SCRIPT_ERROR;
			}
		}
		tr_dtypea[i] = tr_dtype;
		tr_code[i] = p;
		i1++;
	}
#endif
/*
printf("cl_func_str_conv: tr_dtype=%d\n",tr_dtype);
*/
#if 1	/* 2022.11.21 */
  ret = 0;
  if (len > 0) {
#else
	if (len <= 0) {
		if (pAns) *pAns = "";
		return 0;
	}
#endif
/*	tr_stype = CD_TYPE_SJIS;	*/
	tr_dtype = tr_dtypea[0];
	tr_stype = tr_dtypea[1];
	if (tr_dtype==CD_TYPE_NARROW || tr_dtype==CD_TYPE_WIDE) {
		outlen = len*4 + 1;
		outbuf = cl_tmp_const_malloc(outlen);
/*
printf("cl_func_str_conv: outlen=%d outbuf=%08x\n",outlen,outbuf);
*/
		if (tr_dtype == CD_TYPE_NARROW)
			ret = akxctohan_type(len,p1,outbuf,tr_stype);
		else
			ret = akxctozen_type(len,p1,outbuf,tr_stype);
#if 1	/* 2022.11.21 */
		tr_dtype = tr_stype;
	}
	else {
		ret = _func_str_conv(&outbuf,tr_dtypea,tr_code,p1,len);
	}
  }
	if (ret >= 0) {
		cl_set_parm_char2(pInfoParmW,outbuf,ret,tr_dtype);
		ret = 0;
	}
#else
		if (pAns) *pAns = outbuf;
		return 0;
	}
	ret = _func_str_conv(pAns,tr_dtypea,tr_code,p1,len);
	if (ret > 0) ret = 0;
#endif
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int _func_str_conv(pAns,tr_dtypea,tr_code,p1,len)
char **pAns;
int  tr_dtypea[],len;
char *tr_code[],*p1;
{
	int  ret,opt;
	char *p,*pW;

	ret = 0;
/*
printf("cl_func_str_conv: tr_code[0]=[%s] tr_code[1]=[%s] tr_dtypea[0]=%d tr_dtypea[1]=%d\n"
,tr_code[0],tr_code[1],tr_dtypea[0],tr_dtypea[1]);
*/
	opt = (cl_get_option(9,0) & 0x10)<<12;
	pW = p1;
	ret = akxc_str_conv(&p,tr_dtypea,tr_code,p1,len,opt);
	if (ret>=0 && p!=p1) {
		if (!(pW = cl_tmp_const_malloc(ret+1))) return ECL_MALLOC_ERROR;
		memzcpy(pW,p,ret);
		Free(p);
	}
	*pAns = pW;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_str_conv_type(pp2,p1,len1,typed,types)
char *p1,**pp2;
int len1,typed,types;
{
	char *p;
	int  ret,tr_dtypea[2];
	tdtGeneralData tParms,tParmd;
/*
printf("cl_str_conv_type: len1=%d typed=%d types=%d\n",len1,typed,types);
*/
	if (!types) types = akxt_get_code_type();
	if (!typed) typed = akxt_get_code_type();
	if (types==typed || len1<=0) {
		if (pp2) *pp2 = p1;
		ret = len1;
	}
	else {
#if 1	/* 2022.12.3 */
	tr_dtypea[0] = typed;
	tr_dtypea[1] = types;
	return _func_str_conv(pp2,tr_dtypea,NULL,p1,len1);
#else
		memset(&tParms,0,sizeof(tdtGeneralData));
		memset(&tParmd,0,sizeof(tdtGeneralData));
		tParms.gd_code = types;
		tParmd.gd_code = typed;
		tParms.gd_data = p1;
		tParms.gd_dlen = len1;
		if ((ret = akxt_code_trans(&tParms,&tParmd)) >= 0) {
			p = tParmd.gd_data;
			if (pp2) *pp2 = p;
			else {
				memzcpy(p1,p,ret);
				if (tParmd.gd_scale & AKX_DATA_MALLOC) Free(p);
			}
		}
#endif
	}
/*
printf("cl_str_conv_type: ret=%d\n",ret);
*/
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_str_conv_get(p2,p1,len1)
char *p1,**p2;
int len1;
{
	int opt,typed,types;

	opt = cl_get_option(21,0);
	types = (opt>>8) & CD_TYPE_CODE;
	typed = akxt_get_code_type();
	return cl_str_conv_type(p2,p1,len1,typed,types);
}

/****************************************/
/*										*/
/****************************************/
int cl_str_conv_put(p2,p1,len1)
char *p1,**p2;
int len1;
{
	int opt,types,typed;

	opt = cl_get_option(21,0);
	typed = opt & CD_TYPE_CODE;
	types = akxt_get_code_type();
	return cl_str_conv_type(p2,p1,len1,typed,types);
}

/****************************************/
/*										*/
/* inba[] : ͕̊ẽoCgԂz	*/
/****************************************/
int _pat_tozen2(n,inc,outc,inba,exchars)
int  n;
char *inc,*outc,*inba,*exchars;
{
	int  len1,i,byte,out_len,nn[3],tozen;
	char *p1,*p,*pb,c;
	uchar  uc,uc1;
	ushort us,usw;

	len1 = n;
	p1 = inc;
	p  = outc;
	pb = inba;
	out_len = 0;
	while (len1 > 0) {
		byte = akxqkanjilen2(p1,len1);
		tozen = 1;
		if (byte == 1) {
			if ((c=*p1) == '\\') {
			/*	if (outc) *p++ = c;	*/
				p1++;
				len1--;
			/*	out_len++;
				if (inba) *pb++ = 1;	*/
			/*	byte = akxqkanjilen2(p1,len1);	*/
			}
			else if (exchars) {
				if (instrchar(exchars,c) > 0) tozen = 0;
			}
		}
		if (tozen) byte = akxctozen1_type_opt(len1,p1,p,nn,0,0);
		else {
			if (outc) *p = *p1;
			nn[0] = 1;
		}
		if (outc) p += byte;
		p1 += nn[0];
		len1 -= nn[0];
		out_len += byte;
		if (inba) *pb++ = nn[0];
	}
	if (outc) *p = '\0';
	return out_len;
}

/****************************************/
/*										*/
/****************************************/
static int _get_regex_line_pat(nparm,ppParm,p1,len,pos_opt,iOpt,pinba)
int  nparm,len[],pos_opt,iOpt[];
tdtInfoParm **ppParm;
char *p1[],**pinba;
{
	static char *_fn="_get_regex_line_pat";
	int  iRc,patlen,pos0_opt,iCASE,iG,iHAZE,shift,n,opt_len,code_type;
	char *pat,*p,*pp,*patba,*inba;

	code_type = cl_get_char_code_type(ppParm[0],1);
	pos0_opt = pos_opt - 1;
	if ((shift=_get_text_str_pos(nparm,ppParm,p1,len,9)) < 0) return shift;
	if ((iRc=_get_pat_rep(nparm,ppParm,p1,len,pos_opt,shift)) < 0) return iRc;
	if (!len[1]) return 0;
	iCASE = iG = iHAZE = 0;
	if (p = p1[pos0_opt]) {
/*
printf("_get_regex_line_pat: p1[pos0_opt]=[%s]\n",p);
*/
		if (inistr(p,"i")) iCASE = AKX_LIKE_IGN_CASE;
		if (inistr(p,"g")) iG = 1;
#if 1
		opt_len = len[pos0_opt];
		if (akxnskipin(p,opt_len," \\tiIgG") < opt_len) {
			ERROROUT2(FORMAT(630),_fn,"{i | g}");	/* %s: %sȊO͎wł܂B*/
		}
#else
		if (inistr(p,"z")) iHAZE = AKX_LIKE_IGN_HAZE;
		iOpt[2] = iHAZE;
#endif
		iOpt[0] = iCASE;
		iOpt[1] = iG;
	}
	else if ((n=len[pos0_opt]) > 0) {
#if 1
		if (n & ~(AKX_LIKE_IGN_CASE | (D_LINE_PAT_GLOBAL>>8))) {
			ERROROUT2(FORMAT(630),_fn,"{0x01 | 0x04}");	/* %s: %sȊO͎wł܂B*/
		}
		iG    = n & (D_LINE_PAT_GLOBAL>>8);
		iCASE = n & AKX_LIKE_IGN_CASE;
#else
		iONLY = n & (D_LINE_PAT_ONLY>>8);
		iCASE = n & (AKX_LIKE_IGN_CASE | AKX_LIKE_IGN_HAZE);
		iRVS  = n & AKX_LIKE_REVERSE;
		iLCMP = n & AKX_LIKE_LNGMATCH;
#endif
/*
printf("_get_line_pat: n=%08x iCASE=%d iG=%d iONLY=%d iLCMP=%02x iRVS=%02x\n",n,iCASE,iG,iONLY,iLCMP,iRVS);
*/
	}
#if 0
	if (iHAZE) {
		pat = p1[1];
		patlen = len[1];
#if 1	/* 2022.3.25 */
		if ((akxnskipto(pat,patlen,"(){}")>=patlen)) {
			if (!(p=cl_tmp_const_malloc(patlen*2+3))) return ECL_MALLOC_ERROR;
			len[1] = _rep_wildcard(p,pat,patlen,'s',code_type);
			p1[1] = p;
/*
cl_str_conv_put(&pp,p,len[1]);
printf("_get_regex_line_pat: pat=[%s]\n",pp);
if (pat != pp) Free(pp);
*/
			return shift | 0x10;
		}
#endif
		if (!(pat = cl_tmp_const_malloc(patlen*4+1))) return ECL_MALLOC_ERROR;
		if (!(patba = cl_tmp_const_malloc(patlen))) return ECL_MALLOC_ERROR;
		if ((iRc=_pat_tozen2(patlen,p1[1],pat,patba,".*[]^$!(){}")) < 0) return iRc;
		if (iCASE) {
			if (!(pp = cl_tmp_const_malloc(iRc+1))) return ECL_MALLOC_ERROR;
			if ((iRc=akxcuplwn(0,pp,pat,iRc)) < 0) return iRc;
			pat = pp;
		}
		len[1] = iRc;
		p1[1] = pat;
/*
cl_str_conv_put(&pp,pat,iRc);
printf("_get_regex_line_pat: pat=[%s]\n",pp);
if (pat != pp) Free(pp);
*/
		if (!(p = cl_tmp_const_malloc(len[0]*4+1))) return ECL_MALLOC_ERROR;
		if (!(inba = cl_tmp_const_malloc(len[0]))) return ECL_MALLOC_ERROR;
		if ((iRc=akxctozen2(len[0],p1[0],p,inba)) < 0) return iRc;
		if (iCASE) {
			if (!(pp = cl_tmp_const_malloc(iRc+1))) return ECL_MALLOC_ERROR;
			if ((iRc=akxcuplwn(0,pp,p,iRc)) < 0) return iRc;
			p = pp;
		}
		*pinba = inba;
		p1[0] = p;
		len[0] = iRc;
/*
cl_str_conv_put(&pp,p,iRc);
printf("_get_regex_line_pat: p=[%s]\n",pp);
if (p != pp) Free(pp);
*/
	}
#endif
	return shift;
}

/****************************************/
/*										*/
/****************************************/
int cl_in_regex(pWork,mflg,nparm,ppParm)
char *pWork;
int  mflg;
int  nparm;
tdtInfoParm **ppParm;
{
/* INREGEX(pos,npos,line,pat,opt,escape)	*/
	tdtInfoParm *pInfoParm,rInfoParm,*ppParm2[7];
	tdtInfoParm ***pTBL;
	tdtArrayIndex tIndex,*pIndex;
	int  *index;
	tdtLike *plike;
	int  iCASE,iG,iHAZE,iOpt[6],flags[2],shift;
	int  iRc,i,len[8],k,is,patlen,pos0,pos1,pos2,ix,maxargs,lenm,len0,n,nn,j,pos_opt,pos0_opt;
	int  posm,byte1,byte2;
	char w1[128],*p1[7],*pat,errbuf[256],*p,*patba,*inba,*pp,*p0,*inb;
	regex_t reg;
	regmatch_t pmatch[2];
	tdtInfoParm tInfoParm;

	iRc = 0;
	pInfoParm = ppParm[1];
	if ((i=pInfoParm->pi_dlen)>0) {
		if (iRc = cl_get_parm_bin(pInfoParm,&maxargs,"InRegex.maxargs:")) return iRc;
		if (maxargs < 0) {
			/* max_pos(%d)słB */
			ERROROUT1(FORMAT(289),maxargs);
			return -1;
		}
	}
	else maxargs = 1;
/*
printf("cl_in_like: maxargs=%d\n",maxargs);
*/
	is = 0;
	pIndex = &tIndex;
	if (maxargs) {
		if (iRc=cl_get_ITBL_maxargs_ref(1,ppParm,&pIndex,&pTBL,0,0,0,0)) return iRc;
		index = pIndex->index;
		ix = index[3];
		if (i > 0) {
			if (maxargs > index[1]/2) {
					/* max_pos(%d)ž/2(%d)𒴂Ă܂B܂B*/
				ERROROUT2(FORMAT(290),maxargs,index[1]/2);
				maxargs = index[1]/2;
			}
		}
		else maxargs = index[1]/2;
		if (maxargs > MAX_REGEX_MATCH) {
				/* %s: max_pos(%d)l(%d)𒴂Ă܂B܂B*/
			ERROROUT2(FORMAT(205),maxargs,MAX_REGEX_MATCH);
			maxargs = MAX_REGEX_MATCH;
		}
	}
	else goto End;

	p1[0] = w1;
	p1[1] = p1[0] + 32;
	pos_opt = 3;
	if ((shift=_get_regex_line_pat(nparm-2,&ppParm[2],p1,len,pos_opt,iOpt,&inba)) < 0) return shift;
#if 0
	else if (shift & 0x10) {
		cl_set_parm_char(&tInfoParm,p1[1],len[1]);
		nparm = X_MIN(nparm,7);
		mem_cpy_addr(ppParm2,ppParm,nparm);
		ppParm2[(shift & 0x0f)+3] = &tInfoParm;
		return cl_in_like(pWork,mflg,nparm,ppParm2);
	}
#endif
	if (!len[1]) goto End;

	iCASE = iOpt[0];
	iG    = iOpt[1];
	iHAZE = iOpt[2];

	pat = p1[1];
	patlen = len[1];
	if (!iG) maxargs = 1;
	flags[0] = REG_EXTENDED | REG_NEWLINE;
	if (iCASE/* && !iHAZE*/) flags[0] |= REG_ICASE;
	flags[1] = 0;
/*
printf("cl_in_regex: p1[0]=[%s] pat=[%s] maxargs=%d\n",p1[0],pat,maxargs);
*/
	iRc = regcomp(&reg,pat,flags[0]);
	if (iRc) {
		regerror(iRc,&reg,errbuf,sizeof(errbuf));
		ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
		iRc = -1;
	}
	else {
		p0 = p1[0];
		p = p0;
		len[0] = 1;
		len[1] = pos0 = k = 0;
		inb = inba;
		while (k<maxargs) {
			iRc = regexec(&reg,p,2,pmatch,flags[1]);
			if (iRc) {
				if (iRc != REG_NOMATCH) {
					regerror(iRc,&reg,errbuf,sizeof(errbuf));
					ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
					iRc = -1;
				}
				break;
			}
			if ((pos1=pmatch[0].rm_so) < 0) break;
			pos2 = pmatch[0].rm_eo;
			lenm = len0 = pos2 - pos1;
/*
printf("cl_in_regex: k=%d pos1=%d pos2=%d\n",k,pos1,pos2);
*/
#if 0
			if (iHAZE) {
				lenm = akxqmlen(p+pos1,len0);
				posm = akxqmlen(p,pos1);
/*
printf("cl_in_regex: posm=%d lenm=%d\n",posm,lenm);
*/
				byte1 = mem_sum_byte(inb,posm);
				byte2 = mem_sum_byte(inb+posm,lenm);
/*
printf("cl_in_regex: byte1=%d byte2=%d\n",byte1,byte2);
*/
				inb += posm + lenm;
				pos1 = akxqmlen(p0,byte1) + len[0]-1 + len[1];
				lenm = akxqmlen(p0+byte1,byte2);
				p0 += byte1 + byte2;
			}
			else
#endif
			if (mflg) {
				lenm = akxqmlen(p+pos1,len0);
				pos1 = akxqmlen(p,pos1) + len[0]-1 + len[1];
			}
			else pos1 += pos0;
/*
printf("cl_in_regex: pos1=%d lenm=%d\n",pos1,lenm);
*/
			len[0] = pos1 + 1;
			len[1] = lenm;
			if (!(cl_get_option(18,0) & 0x02) && len[6]>1) len[0] += len[6] - 1;
			for (i=0;i<2;i++,ix++) {
				pInfoParm = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
				if (pInfoParm) {
DEBUGOUT_InfoParm(194,"cl_in_regex: i=%d ix=%d",pInfoParm,i,ix);
					cl_set_parm_bin(&rInfoParm,len[i]);
					if ((iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) < 0) break;
				}
				else {
					iRc = -1;
					break;
				}
			}
			if (iRc < 0) break;
			is++;
			k++;
			p += pos2;
			pos0 = pos2;
		}
	}
	regfree(&reg);
 End:
	memcpy(pWork,&is,sizeof(int));
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_rep_regex(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
/* REPREGEX(line,pat,rep,opt,escape)	*/
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	int  iCASE,iG,iHAZE,flags[2],shift,iOpt[3];
	int  iRc,len[7],pos0,pos1,pos2,lenm,n,nn,j,pos_opt,pos0_opt,ll,patlen;
	char w1[128],*p1[7],*pat,errbuf[256],*p,*pp,*inba;
	regex_t reg;
	regmatch_t pmatch[2];
	tdtInfoParm tInfoParm,*ppParm2[6];

	*pAns = NULL;
	iRc = 0;
	p1[0] = w1;
	p1[1] = p1[0] + 32;
	pos_opt = 4;
	if ((shift=_get_regex_line_pat(nparm,ppParm,p1,len,pos_opt,iOpt,&inba)) < 0) return shift;
#if 0
	else if (shift & 0x10) {
		cl_set_parm_char(&tInfoParm,p1[1],len[1]);
		nparm = X_MIN(nparm,6);
		mem_cpy_addr(ppParm2,ppParm,nparm);
		ppParm2[(shift & 0x0f)+1] = &tInfoParm;
		return cl_rep_like(pAns,nparm,ppParm2);
	}
#endif
	if (!len[1]) {
		ll = len[0];
		pp = p1[0];
		goto End;
	}
	iCASE = iOpt[0];
	iG    = iOpt[1];
	iHAZE = iOpt[2];

	pat = p1[1];
	patlen = len[1];
	flags[0] = REG_EXTENDED | REG_NEWLINE;
	if (iCASE/* && !iHAZE*/) flags[0] |= REG_ICASE;
	flags[1] = 0;
/*
printf("cl_rep_regex: p1[0]=[%s] pat=[%s]\n",p1[0],pat);
*/
	iRc = regcomp(&reg,pat,flags[0]);
	if (iRc) {
		regerror(iRc,&reg,errbuf,sizeof(errbuf));
		ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
		iRc = -1;
	}
	else {
/*
printf("cl_rep_regex: len[7]=%d p1[5]=[%s]\n",len[7],p1[5]);
*/
		mcat.mc_ipos = 0;
		if (!(cl_get_option(18,0) & 0x04) && len[7]>0) {
			if ((iRc=akxtmcat(&mcat,p1[5],len[7])) < 0) return iRc;
		}
		p = p1[0];
		lenm = len[0];
		pos0 = 0;
		while (pos0 < lenm) {
			iRc = regexec(&reg,p,2,pmatch,flags[1]);
			if (iRc) {
				if (iRc != REG_NOMATCH) {
					regerror(iRc,&reg,errbuf,sizeof(errbuf));
					ERROROUT1(FORMAT(244),errbuf);	/* REGEX: %s */
					iRc = -1;
				}
				break;
			}
			if ((pos1=pmatch[0].rm_so) < 0) break;
			pos2 = pmatch[0].rm_eo;
/*
printf("cl_rep_regex: pos1=%d pos2=%d\n",pos1,pos2);
*/
			if ((iRc=akxtmcat(&mcat,p,pos1)) < 0) break;
			if ((iRc=akxtmcat(&mcat,p1[2],len[2])) < 0) break;
			p += pos2;
			pos0 = pos2;
			if (!iG) break;
		}
		iRc = akxtmcat(&mcat,p,lenm-pos0);
	}
	regfree(&reg);
	if (iRc >= 0) {
		iRc = 0;
		ll = mcat.mc_ipos;
		pp = mcat.mc_bufp;
	}
 End:
	if (!iRc) {
		if (ll > 0) {
			if (p = cl_tmp_const_malloc(ll+1)) {
				memzcpy(p,pp,ll);
				*pAns = p;
			}
			else iRc = -1;
		}
	}
	return iRc;
}
