#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[#]SH_'			;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

#SH_LS
#!/bin/sh
# AGPLv3+
:<< 'EEE'
/* Copyright (C) 2022 Momi-g

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
EEE

:<< 'EEE'
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief set app window as dropdown mode as quake/terminator etc
@_syno
	wmdd [-hHVvs] ...
	wmdd -m gridnum [wid|-a|(none == -a)]
	wmdd -rt [wid|grid|-a|(none == -a)]
	wmdd -k
@tl_dr
		@(code)--@
	+----+----+----+ display grid
	| 1  | 2  | 3  |
	+----+----+----+
	| 4  | 5  | 6  |
	+----+----+----+
	| 7  | 8  | 9  |
	+----+----+----+	

	~$ wmdd -m 3 0x1234		#>> move(==set) wid 0x1234 to grid 3 pos
	~$ # wmdd -m 3 -a	#>> '-a' is conved to active win wid
	~$ # wmdd -m 3		#>> use active win if noarg
	~$ wmdd -t 3 	#>> active/hide grid 3(==0x1234) win
	~$ wmdd -r 0x1234	#>> remove grid 3(==0x1234) setting
	~$ wmdd -r -1	#>> remove all grid setting (-1)
	~$ wmdd -k	#>> kill deamon
		@()--@
@_opt
		@(list_o)
	-hHVvs: help, Ver, verbose, -v 0/1/2 == quiet/dfl/verbose, sample code--
		'-v' opt works only when 1st exec(== daemon boot).
	-m 1-9 [wid]: set target wid to grid 1-9. use active window if no wid
	-t [1-9|wid]: toggle active/hide target grid/wid
	-r [-1|1-9|wid]: remove target grid/wid from grid. remove all if -1.
	-k: kill daemon
	-a: used as active window wid, 0x1234 etc
		@()
@_desc
	quake/terminator window on/off toggle(F12) is useful.
	this pg supplies the same work to any x11 app. --
	each grid can holds only 1 app window. --
@exit_status suc/fail == 0/not0
@notes -
@depend	xprop, wmctrl, xwininfo, w_resize
@compat	posix-shell
@copyright	Copyright (C) 2022 Momi-g, AGPLv3+
@_ver 2022-12-21 v1.0.1 (2022-12-11 v1.0.0)
@_see w_resize(1)
#SH_docE
EEE
#SH_ED

#SH_HD
#SH_ED

#SH_SC
f_err(){ echo "*SH_bn*:---err. $*" && exit 1;}>/dev/stderr

f_srr(){ while :;do echo "*SH_bn*:---errstop. $*"; sleep 1000;done; }>/dev/stderr
f_wrr(){ echo "*SH_bn*:---msg. $*";} >/dev/stderr
f_vrr(){ echo "*SH_bn*:---val";echo "$(s_val "$@")";} >/dev/stderr
s_val()(
	[ "${1##@*}" = "" ] && echo "$@" && return
	for _vbg; do
	set -- "$_vbg" "$(eval 'printf "%s@" "$'"$_vbg"'"')"
	printf '%s#%s:%s;\n' "$1" $((${#2}-1)) "${2%?}"
	done
)
_f_nrr(){
	tm=5000
	[ "$2" != "" ] && tm="$2"
	command -v notify-send >/dev/null 2>&1 || return
	notify-send "(*SH_bn*) $1" -t "$tm"
}
f_NRR(){ _f_nrr "$@"; }
f_nrr(){ _f_nrr "$@"; }
f_drr(){ _f_nrr "$@"; }

f_vlv(){
	[ "$1" = 0 ] && {
		f_err(){ exit 1; }
		f_nrr(){ :; }
		f_drr(){ :; }
		f_wrr(){ :; }
		f_vrr(){ :; }
	}
	[ "$1" = 1 ] && {
		f_drr(){ :; }
		f_wrr(){ :; }
		f_vrr(){ :; }
	}	
	[ "$1" = 2 ] && :
}

#SH_TSS
eq(){ _eq "$@"; }
nq(){ _neq "$@"; }

test_0init(){
	# f_grr "test start: needs 30s..." 8000
	eq 1 1
}
#SH_TSE

f_usage(){
cat << 'EEE'
HowTo (*SH_bn*, enable x11 app dropdown mode)
opt: -hHVvs(help,Ver,verbose,eg), -mrt(move,remove,toggle), -a(ctive), -k(ill)
------
	+----+----+----+ display grid
	| 1  | 2  | 3  |
	+----+----+----+
	| 4  | 5  | 6  |
	+----+----+----+
	| 7  | 8  | 9  |
	+----+----+----+	

~$ wmdd -m 3 0x1234	#>> move(==set) wid 0x1234 to grid 3 pos
~$ # wmdd -m 3 -a	#>> select active wid if '-a'
~$ # wmdd -m 3	#>> select active wid if noarg
~$ wmdd -t 3 	#>> activate/hide grid 3(==0x1234) win
~$ wmdd -v 0 -r 3	#>> remove grid 3 setting, verbose lv0 (0/1/2)
~$ wmdd -r -1	#>> remove all grid setting (-1)
~$ wmdd -k		#>> kill daemon
EEE
exit 0
}

f_usageH(){
	cat <<- 'E E'|sed -e'1d;$d'
	#SH_rf* *SH_bn*.1.txt
	E E
	exit 0
}

f_verinfo(){
		cat <<- 'EEE'
	*SH_bn* *SH_ver*
	*SH_copy* 
		EEE
	exit 0
}

f_sample(){
	
cat << 'EEE'
#!/bin/sh
#-- mytile.sh: ~$ *SH_bn* -s > mytile.sh && sh ./mytile.sh
fl='/tmp/*SH_bn*_bind.ini'

echo '
shift + Up
 ;wmdd -m 2
shift + Down
 ;wmdd -m 8

F4
 ;wmdd -t 2
F3
 ;wmdd -r
F2
 ;wmdd -i
F1
 ;wmdd -k; echo "killall sxhkd..."; killall sxhkd; ps aux|grep sxhkd
'  > "$fl"

sxhkd -c "$fl" && sleep 1 && rm "$fl" &
echo "
	push keys as:
1. shift+ (arrow)up
2. F4 and F4 (toggle)
3. shift+ (arrow)down (>> warning)
4. F3 (unset)
5. shift+ (arrow)down (>> suc)
6. F2 (info)
7. F1 (close *SH_bn* and ~$ killall sxhkd )
"
EEE
exit 0
}


f_widstack(){
	# grep formateed stacklist
	#  -f _NET_ACTIVE_WINDOW 32c '=$0+\n' 0+はarrをカンマ区切りで全出力
	buf=$(xprop -root _NET_CLIENT_LIST_STACKING _NET_CURRENT_DESKTOP _NET_ACTIVE_WINDOW|
	sed -e 's/.*[#=:]//'|tr ',' ' '|awk '
	NR==1 {print "stk=\"" $0 "\"" }
	NR==2 {print "dsk=" $1 }
	NR==3 {print "act=" $1 }')
	eval "$buf"
# echo "$buf" >/dev/stderr
# stk="  1a00003  4600003 ..."
# dsk=0
# act0x4600066

# デスクトップはworkspaceとかスクリーンとか仮想デスクトップとかいわれてる奴。
# 0:1.2で 0個目の物理接続マシンの1個目のxサーバ(rootウィンドウ)で2つめのスクリーン。
# widを比較して存在を合体。並び順とwmctrlから見える
	wl=$(wmctrl -l|awk '$2!=-1{print $2 " " $1}'|sort -n)
	set -- $stk
	{ echo "$wl" ;echo "$stk"|tr ' ' '\n'; }|tr '[:upper:]' '[:lower:]' | 
		sed -e 's/0x0*/0x/'| awk -v act="$act" -v  dsk="$dsk" 'BEGIN{m=0}
	NF==0 { next }
	NF!=1 {
		buf=""
		if($1==dsk){ buf="@" }
		arr[$2]=buf $0
		drr[$2]=$1
	}
	NF==1 && arr[$1]!=""{
		i=drr[$1]
		if(i>m){ m=i }		
		if($1==act){ buf="focus" }
		else{ buf="-" }	
		srrn[i]=srrn[i]+1
		srr[i]=arr[$1] " " srrn[i] " " buf "\n" srr[i]
	}
	END{ for(i=0;i<=m;i++){ print( srr[i] ) } }'|awk '$1!=""{print}'
# *0 0x6600004 8 focus
# *0 0x582608e 1 -
# 1 0x582d188 6 -
}

#SH_TSS
test_stk(){
	f_widstack
	_suc
	echo "ok: test_stk"
}
#SH_TSE

# w_resize(){
# 	if command -v w_resize >/dev/null 2>&1 ; then
# 		w_resize "$@"
# 	else
# 		sh ./w_resize "$@"
# 	fi
# }
# https://stackoverflow.com/questions/7035/how-to-show-a-gui-message-box-from-a-bash-script-in-linux

#-- f_getg3al 3 "$_widlist"
f_getgval(){
	case "$1" in
		([1-9]) : ;;
		(*) return ;;
	esac 
	eval 'buf="$_p'$1'"'
	echo "$buf"
}
#SH_TSS
test_gval(){
	_p1=100
	res=$(f_getgval 1)
	_suc; eq "$res" 100
	
	_p8="0x1234:{ wmctrl -e 1,0,0,-1,-1; }"
	res=$(f_getgval 8)
	_suc; eq "$res" "$_p8"
	echo "ok: test_gval"
	#./$cmd -h
}
#SH_TSE

#-- f_setgval 4 "any_text_for_save_prop_etc"
f_setgval(){
	id="$1"
	s="$2"
	case "$1" in
		([1-9]) : ;;
		(*) return ;;
	esac 
	cmd="_p$id="'"$s"'
	eval "$cmd"
}

#SH_TSS
test_sval(){
	_p2=123
	_p4=abc

	eq "$_p2" "123"
	f_setgval 2 hello
	_suc
	nq "$_p2" "123"
	eq "$_p2" "hello"
	
	s='gw'
	f_setgval 4 "$s"
	_suc
	eq "$_p4" "$s"
}
#SH_TSE

f_init(){
	#--fork
		#-- alive monitor, pipetrap, destroy pipe >> del tmpfiles
	f_ptrap(){
		read -r fl_p
		while read -r a; do :; done
		[ -e "$fl_p" ] && echo 'kill' >"$fl_p"
		rm -f "$fl_p"
	}
	
	nm="/tmp/*SH_bn*"pipe
	[ -e "$nm" ] && sleep 1 && [ -e "$nm" ] && f_nrr "$nm exist. stop" && exit 1
	mkfifo -m 666 "$nm" #-- blockmode , normalfile == ng
	f_readloop "$nm"| f_ptrap	&	#-- "$nm" is rm in f_readloop()
	
	cid=$!
	fl_p="$nm.$cid"
	mkfifo -m 666 "$fl_p" || {
		f_NRR "fatal err. mkfifo '$fl_p' failed"
		exit 1
	}
	echo "$fl_p" > "$nm"	# 1st:block, 2nd:EPIPE
#https://unix.stackexchange.com/questions/433345/under-what-conditions-exactly-does-sigpipe-happen
	[ "$_testflg" = 1 ] && echo "$fl_p"
}

f_iswid(){ xwininfo -id $1 >/dev/null 2>&1; }

f_readloop(){
	read -r fl_p < "$1"		#-- $1==pipe, blocking
	rm -f "$1"
	echo "$fl_p"	#-- info for f_ptrap

	_f_remove() {
		f_(){
			buf=$(f_getgval "$1")	# 0x1234:{...orig_pos_cmd }
			wid=${buf%%:*}
			cmd=${buf#*:}
			[ "$2" != "-1" ] && [ "$cmd" = "" ] && 	f_nrr "remove: failed. grid $1 is empty"
			[ "$cmd" != "" ] && {
				#-- exist or not
				f_iswid "$wid" && eval "$cmd"
				f_setgval "$1" ""
			}
		}
		[ "$1" != "-1" ] && { f_ "$1"; return; }
		for i in $(seq 1 9);do f_ "$i" '-1'; done
	}

	_f_kill(){
		_f_remove -1
		while [ -e "$fl_p" ]; do
			rm -f "$fl_p" 2>/dev/null
f_drr "*SH_ln* del $fl_p"
		done
		f_nrr "cmd: $mode: daemon killed"
f_drr "*SH_ln* $(ls /tmp)"
	}
	
	#-- coreloop
	unset _p1 _p2 _p3 _p4 _p5 _p6 _p7 _p8 _p9
		while [ -e "$fl_p" ]; do
# https://stackoverflow.com/questions/4867780/linux-named-pipes-losing-data
#>> Named pipes lose their contents when the last process closes them. 
	slist=$(cat "$fl_p" 2>/dev/null) || break		#--save all pipefile input
		#-- NOTE: namedpipe is opened as <> and send/recv discriptor is grabbed by 'cat'
		#-- del fpipe close() only input '<' but output '>' is alive.
		#-- need dummy 'echo >fpipe' from f_ptrap() to kill 'cat' proc
		#-- see f_ptrap() code
	[ "$slist" = "" ] && break
	echo || { _f_kill; break; }	#-- f_ptrap() alive monitor
	
	#-- 'ps' cmd detect this blocking line 'cat'

	while read -r mode gnum wid; do		#-- << "fl_p" at end 	
	
	#-- arg normalize: gwid>>grid, grid>>gwid, search bothval
	buf=$(printf '%d' "${gnum:-0}" 2>/dev/null)
	[ $? != 0 ] && {
		f_NRR "fatal: badinput: $mode, $gnum, $wid"
		continue
	}
	[ "$buf" -gt 9 ] && buf=$(printf '0x%x' $buf)
	gnum="$buf"
	gwid=""
		
	if [ "$gnum" = "-1" ] && [ "$mode" = "remove" ]; then
		_f_remove "$gnum"
		continue
	elif [ "${gnum#[1-9]}" = "" ]; then
	#-- 1-9
		buf=$(f_getgval "$gnum")
		gwid=${buf%%:*}
#f_drr "@@@ $buf @ $gwid" 20000
	else
	#-- 0x1234
		ng=""
		for i in $(seq 1 9);do
			buf=$(f_getgval "$i")
			buf=${buf%%:*}
			[ $((buf - gnum )) = 0 ] && ng=$i && break
		done
		gwid="$gnum"
		gnum="$ng"
	fi
	#--isexist >> del
	[ "$gwid" = 0 ] && gwid=""
	[ "$gwid" != "" ] && {
		f_iswid "$gwid" || {
			[ "$gnum" != "" ] && f_setgval "$gnum" ""
			gwid=""
			gnum=""
		}
	}
 #-- normalize_end
 # mode, gnum, wid + gwid   gnum=="" >> nogrid, gwid=="" nowindow

	#--- switch_cmd
# f_drr "*****  $mode $gnum $wid $gwid" 20000

	#-- -r/-R == wid=0
	[ "$mode" = "remove" ] && {
		[ "$gnum" = "" ] && {
			f_nrr "window isnt in grid: $gwid"
			continue
		}
		_f_remove "$gnum"
		continue
	}

	[ "$mode" = "move" ] && {
			#-- isexist, not gwid. direct input
		f_iswid "$wid" || {
			f_nrr "move: wid not found: $gnum, $wid"
			continue
		}

			#--- ck_dup_err
		buf=" 1$_p1 2$_p2 3$_p3 4$_p4 5$_p5 6$_p6 7$_p7 8$_p8 9$_p9"
		s="${buf%%$wid*}"
		[ "$buf" != "$s" ] && {
			i=${s##* }
			f_nrr "move: failed. grid $i holds: $wid"
			continue
		}
			#--- assign
		sv=$(w_resize $wid)
		f_setgval "$gnum" "$wid:$sv"
		rcmd="w_resize -m p$gnum $wid"
# f_grr "add: $rcmd"
		eval "$rcmd"
		continue
	}
	
	#--- info
	[ "$mode" = "state" ] && {
		#-- update
		for i in $(seq 1 9); do
			buf=$(f_getgval "$i")
			wid=${buf%%:*}
			[ "$buf" = "" ] && continue
			f_iswid "$wid" && continue
			f_setgval "$i" ''
		done
		
		[ "$_p1" = "" ] && b1="-" || b1=1
		[ "$_p2" = "" ] && b2="-" || b2=2
		[ "$_p3" = "" ] && b3="-" || b3=3
		[ "$_p4" = "" ] && b4="-" || b4=4
		[ "$_p5" = "" ] && b5="-" || b5=5
		[ "$_p6" = "" ] && b6="-" || b6=6
		[ "$_p7" = "" ] && b7="-" || b7=7
		[ "$_p8" = "" ] && b8="-" || b8=8
		[ "$_p9" = "" ] && b9="-" || b9=9
		buf=$(cat<<- EEE
		
		| $b1 | $b2 | $b3 |
		| $b4 | $b5 | $b6 |
		| $b7 | $b8 | $b9 |
		EEE
		)
		f_NRR "$buf"
		continue
	}
	
	[ "$mode" = "toggle" ] && {
		wid="$gwid"
		[ "$wid" = "" ] && { f_nrr "grid $gnum: id empty/nowid"; continue; }
			#--- ag_err
		l=$(f_widstack|grep @|grep "$wid")
		[ $? != 0 ] && { f_nrr "grid/win $gnum: not found in workspace"; continue; }
			#--- "act >> hide / hide >> act
		[ "${l#*focus}" != "$l" ] && wmctrl -ir $wid -b toggle,hidden		
		[ "${l#*focus}" = "$l" ] && wmctrl -ia $wid
		continue
	}

#f_grr "hit kill? $mode, $gnum $wid" 30000	
		#-- others== invalid cmd
	[ "$mode" != "kill" ] && f_NRR "detect badreq, close daemon: $mode/$gnum/$wid"
	_f_kill
	break
		done <<- EEE
		$(echo "$slist"| awk '$1 {print}')
		EEE

		done
f_drr " ***exit_coreloop*** "
}

#SH_TSS
test_move(){
		#-- d-class
	xterm &
	wid_p=$!
	sleep 1
	wmctrl -r :ACTIVE: -e 1,200,100,400,300
	wid=$( xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2 )
	
	_testflg=1
	#-- boot / exit
	fl=$( (f_init)|(read -r a;echo "$a") )	#--exec in subprocess forcely
	
#	fl=$( (f_init) )
f_wrr "$fl"
	
	#-- boot/state/add/toggle/remove/exit
	echo state >$fl
	_suc
	
#sleep 1
	echo move 2 $wid >$fl
	_suc

#sleep 1
	echo state >$fl
	_suc

#sleep 1
	echo toggle 2  >$fl
	_suc

#sleep 1
	echo toggle 2  >$fl
	_suc

#sleep 1
	echo remove 2 >$fl
	_suc
	
#sleep 1
	echo state >$fl
	_suc

f_widstack
	ps
	[ -e "$fl" ] && echo kill >$fl
	buf=$(xprop -id $wid _NET_WM_PID|awk '{print $NF}')
f_wrr $buf $wid
	kill $buf
	
	sleep 1
 f_wrr "..clean pipefile"
	ls /tmp/wmddpipe*
	_fail
	
 f_wrr "..ok: test_cmd"
	#./$cmd -h
}
#SH_TSE

#-- ~$ wmdd -a 4
*SH_bn*(){
	_cdir="$PWD"
	_bname=${0##*/}
	_sdir=${0%"$_bname"}
	_sdir=${_sdir%/}
	[ "$_sdir" = "" ] && _sdir="$_cdir"
	[ "$_sdir" = "." ] && _sdir="$_cdir"
	[ "$_sdir" = ".." ] && _sdir=$(dirname "$_cdir")
	_s0="$_sdir/$_bname"
	export PATH="$_sdir:$PATH"
	hash -r
	cd "$_cdir"

		while getopts ":hHVsv:m:r1tika" c && v="$OPTARG"&&xx=1; do
		while [ "$xx" = 1 ]&&xx=0; do case "$c" in	#-- xx: fall-through magic		
	(h) f_usage	;;
	(H) f_usageH	;;
	(V) f_verinfo	;;
	(s) f_sample	;;
	( v) [ "${v%[0-2]}" = "" ]&&opt_v=$v|| { xx=1;c=:; v="-v $v != 0/1/2";} ;;
	
	( m) [ "${v%[1-9]}" = "" ]&&msg="move $v"|| { xx=1;c=:; v="-m $v != 0-9";} ;;
	(r) msg="remove" ;;
	(1) [ "$msg" = "remove" ]&&msg="$msg -1"|| { xx=1;c=:; v="needs '-r -1' etc";} ;;
	(t) msg="toggle" ;;
	(i) msg="state" ;;
	(k) msg="kill" ;;
	(a) opt_a=1 ;;
	([?:]) f_err "bad opt: $v: $*" ;;	
		esac; done; done; shift $(($OPTIND-1))
:<< SKIP
cmd=$(cat <<- 'END'   # 'END'.. not expand $foo etc. 
   # opt dfl  type	( +add command you want to test input opt)	
     -h   0	bool	f_usage
     -H   0	bool	f_usageH
     -V   0	bool	f_verinfo
     -s   0	bool	f_sample
     -v   1	int		'[ "${opt_v#[0-2]}" = "" ]' 

     -m   0	int		'[ "${opt_m#[1-9]}" = "" ] && msg="move $opt_m"'
     -r   0	bool	'msg="remove"'
     -1   0	bool	'[ "$msg" = "remove" ] && msg="$msg -1"'
     -t   0	bool	'msg="toggle"'
     
     -i   0	bool	'msg="state"'
     -a   0	bool
     -k   0	bool	'msg="kill"'
	END
)
	buf=`ckopt ":$cmd"`  #..or.. "$cmd"  (colon, quiet err mode as getopts )
	eval "$buf"
	[ "$?" != 0 ] && f_err "$OPTARG" && exit 1
SKIP

	[ "$msg" = "" ] && f_srr "badreq. see -h" && exit 1
	
		#-- preset
# f_wrr "$opt_v"
	opt_v=${opt_v:-1}
	f_vlv "$opt_v"
# echo 666 >/dev/stderr
f_wrr "$1, $opt_m, $msg"
	
		#-- tmpfile / dupexec check etc
	(
	buf=$(echo /tmp/wmddpipe.*|grep -vF '*')
	set -- $buf
	[ $# -gt 1 ] && f_NRR "detect many pipes: $buf, exit" && exit 1
	[ $# = 0 ] && f_init
f_wrr ___ $#
	) || exit 1

	fl_p=$(echo /tmp/wmddpipe.*|grep -vF '*')
	[ "$fl_p" = "" ] && {
		f_NRR "fatal: pipes /tmp/wmddpipe* failed. exit"
		exit 1
	}
	
		#-- target
	[ "$opt_a" != 1 ] && [ $# != 0 ] && {
		printf '%d' "$1" >/dev/null 2>&1 || {
		f_NRR "ag1 must be -1/1-9/0x...., exit: $@"
		exit 1
		}
	}

	[ "$opt_a" = 1 ] && set --
f_wrr "$1"
	[ "$#" = 0 ] && [ "$msg" != "" ] && {
		wid=$(f_widstack|grep focus|awk '{print $2}')
		[ "$wid" = "" ] && f_grr "failed to get active window: $@" && exit 1
		set -- $wid
	}
	msg="$msg $1"	#-- add 4 0x1234 / toggle 3 / remove 4

		#-- exec		
	echo "$msg" > "$fl_p"
f_wrr "$msg"
}

*SH_bn*_main(){ *SH_bn* "$@"; }
*SH_bn*_main "$@" || exit	#SH_MAIN

#SH_TSS
test_cmd(){
	cmd="*SH_bn*"
	./$cmd -h;	_suc 1
	./$cmd -H;	_suc 2
	./$cmd -V;	_suc 3
	echo "ok: test_cmd"
}
#SH_TSE

#SH_TSS
test_w_(){
	awkcode='
function f_impl(s,	a,b,arr){
	return s
}

function f_sort(arr,	mdx,suc){
	for(i in arr){mdx++}
	suc=1; while(suc) {suc=0; for(i=2;i<=mdx;i++) {
	if(arr[i-1]>arr[i]) {buf=arr[i]; arr[i]=arr[i-1] ;arr[i-1]=buf; suc=1; }
	} }
}
function f_uniq(arr, 	mdx,bi,brr){
	for(i in arr){mdx++}
	for(i=1;i<=mdx;i++){ if(arr[i] != brr[bi+0]){ bi++; brr[bi]=arr[i] } }
	split("",arr)
	for(i in brr){ arr[i]=brr[i] }
}
function _runtest(){	#"function _runtest()" >> "0" for ignore but save testcode
	eq(10, 10)
	return
	
	s="{+s+c+l+m1+m2+m3+m4+m5}"
	q="+Control+Lock+Mod1+Mod2+Mod3+Mod4+Mod5+Shift "
	s=f_impl(s)
	eq(s, q)
}
'
awk '
BEGIN{
	_runtest()
	printf("fail/all: %s/%s\n", test_fail+0, test_all+0) > "/dev/stderr"
	exit(0)
}

#*SH_rf* 0 awktool.awk

'"$awkcode"
	nq 1 0
}
#SH_TSE

:<<'EEE'
change log
--
2022-12-21  Momi-g	<dmy@dmy.dmy>

	* wmdd.sh.sh(all): add -i opt, improve code
	
	* wmdd.sh.sh(brp): update brp, add SH_ln code

2022-11-24  Momi-g	<dmy@dmy.dmy>

	* wmdd.sh.sh(all): init v1.0.0

EEE
#SH_ED

#SH_OP _ a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
#SH_OP h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout	GPLv3+"	 #*/
#SH_OP f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0|tr -d ' \t'|grep -F '()' #*/
#SH_OP t $e"$CW";ftt "$@";$p"bash --posix $Ox $tf"|fvd
#SH_OP T $e"$CW";ftt "$@";$p"dash $Ox $tf"|fvd
#SH_OP i $e"$Cb";$p'shellcheck -s sh -e SC2046,SC2086,SC2004,SC2154,SC2015,SC2006,SC2030,SC2031,SC2145 $bn.sh'|fv
#SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0>eg.sh #;$p"luajit eg.lua"|fv
#SH_OP x Ox="-x";fvd(){ fv 2>&1|tee dbg.txt; } 
#SH_OP v Ov="-v2"

#SH_OP b $e"$CW"
#SH_OP W fpp;$e"$Cm$O$Cw">/dev/null;fborn;chmod 755 $bn $bn.sh;$e"$Cs";$p"$bn $Rs $Rh $tf"	#*/
#SH_OP o $e"$CW";$p'fman $Rh 1'|fv		#*/

#SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
mandoc -Thtml <$bn.$2 >$bn.$2.html
man -Tutf8 -l -<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
"|fv
#(echo '.mso ja.tmac';cat $bn.$2)|man -Tutf8 -l -|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
)

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)
fvd(){ fv; }

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frv|fry|flit|frf)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

#-- longcmd
frf()(
# *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
awk -v tg="${C##*]}rf" -v cs='#' -v ce='' 'index($0,tg){
s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
m="[ -f \"%s\" ]&&(echo \"%s--copyfrom %s %s\";cat \"%s\";echo \"%s--copyend %s %s\")"
mm="[ -f \"%s\" ]&&(_=\"%s%s%s\";cat \"%s\";_=\"%s%s%s\")"
for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,cs,v,ce,v,cs,v,ce))}
next
}
{print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
fry()(buf=`awk '$1~ /^@license|^@copy/ {$1="";print;exit}'<$R0`;sed -e "s@\*${C##*]}copy\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte()(
cat > $Rm-
suite=$(cat $Rm-|awk '$1~/^test_[^(]*\(\)/{print $1}'|sed -e 's/[(].*//g'|$e"$gfn")
[ $# = 0 ] && suite="$suite $suite"|| suite="$suite $@"
suite=`$p'%s\n' "$suite"|tr '[ \t]' '\n'|sort|uniq -d|fsl`
(cat $bn $Rm-|grep -vF "${C##*]}MAIN"
$p'[ $# = 0 ]&&set -- '"$suite"';for fc;do echo "--$fc():">/dev/stderr;$fc;done;_res')
rm -f $Rm-
)
ftt()(shunit_m $Ov>$Rm;fte "$@"<$tf>>$Rm;mv $Rm $tf)

fborn(){
gfn="grep -v '_$'";fgR "${C}TSS_" "${C}TSE"<$R0 |fgr0 "${C}TSS" "${C}TSE"|fbn|fte>tests.code
gfn="cat -";fgr0 "${C}TSS" "${C}TSE"<$R0|fbn>$tf
fgR "${C}TSS" "${C}TSE"<$Rs|fbn|tee $Rm>$bn;mv -f $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
R0="${R0%?}"
}
fpp(){ awk "{gsub(/[*]${C##*]}ln[*]/,NR);print}"<$R0>${R0}_; R0="$R0"_; $p"${R0}"; }
#SH_DE
