

#include "wxPPlot.h"
#include "PPlotInteraction.h"

IMPLEMENT_DYNAMIC_CLASS(wxPPlot, wxPanel);

BEGIN_EVENT_TABLE(wxPPlot, wxPanel)
    EVT_PAINT  (wxPPlot::OnPaint)
    EVT_ERASE_BACKGROUND(wxPPlot::OnEraseBackground)
    EVT_MOUSE_EVENTS (wxPPlot::OnMouseEvent)
    EVT_KEY_DOWN(wxPPlot::OnKeyDown)
    EVT_SIZE(wxPPlot::OnResize)
END_EVENT_TABLE()


wxPPlot::wxPPlot()
{  // just empty default constructor

}

wxPPlot::wxPPlot (wxWindow *inParent):
//	wxScrolledWindow(inParent, 0, wxDefaultPosition, wxDefaultSize, wxHSCROLL | wxVSCROLL | wxNO_FULL_REPAINT_ON_RESIZE, "bla")
	wxPanel(inParent, -1, wxDefaultPosition, wxDefaultSize, 0, "bla"),
	mDC (0),
	mFont (0),
	mPen (0),
	mBrush (0)
{
   mInteractionContainer = mDefaultInteractionContainer = new DefaultInteractionContainer (mPPlot);
   SetPDrawer (&mPPlot);
}

wxPPlot::~wxPPlot () {
	delete mFont;
	delete mPen;
	delete mBrush;
    delete mInteractionContainer;
}

void wxPPlot::OnEraseBackground(wxEraseEvent& event)
{   // empty: just used to reduce flicker
}

void wxPPlot::OnPaint(wxPaintEvent &WXUNUSED(event))
{
    mDC = new wxBufferedPaintDC (this);
    PrepareDC(*mDC);

    if (!mFont) {
//    	mFont = new wxFont (mDC->GetFont ());
  //  	mDC->SetFont (*mFont);
    }
    if (!mPen) {
    	mPen = new wxPen ();
    	mDC->SetPen (*mPen);
    }

    if (!mBrush) {
    	mBrush = new wxBrush ();
    	mDC->SetBrush (*mBrush);
    }

    mPPlot.Draw (*this);

    delete mDC;
/*
    m_owner->PrepareDC(dc);

    dc.SetBackgroundMode( m_owner->m_backgroundMode );

    dc.Clear();
*/
}

void wxPPlot::OnResize(wxSizeEvent& event)
{
    Refresh();
}

void wxPPlot::OnMouseEvent (wxMouseEvent &inEvent) {
  int theModifierKeys = 0;
  if (inEvent.AltDown ()) {
      theModifierKeys = (theModifierKeys | PMouseEvent::kAlt);
  }
  if (inEvent.ControlDown ()) {
      theModifierKeys = (theModifierKeys | PMouseEvent::kControl);
  }
  if (inEvent.ShiftDown ()) {
      theModifierKeys = (theModifierKeys | PMouseEvent::kShift);
  }
  PMouseEvent theEvent;
  theEvent.SetModifierKeys (theModifierKeys);
  theEvent.mX = inEvent.GetX();
  theEvent.mY = inEvent.GetY();
  // because Moving() returns false if a mouse button is pressed, Dragging() is needed!!! (SV)
  if (inEvent.Moving () || inEvent.Dragging()) {
      theEvent.mType = PMouseEvent::kMove;
  }
  else if (inEvent.LeftDown ()) {
   theEvent.mType = PMouseEvent::kDown;
  }
  else if (inEvent.LeftUp ()) {
   theEvent.mType = PMouseEvent::kUp;
  }
  int theHasModifierKeys = theEvent.HasModifierKeys ();

  if (GetInteractionContainer ().HandleMouseEvent (theEvent)) {
//    update ();
    //repaint (rect (), FALSE);
    this->Refresh ();
  } else {
//      e->ignore ();
    inEvent.Skip ();
  }
}

void wxPPlot::OnKeyDown (wxKeyEvent &inEvent) {
  int theModifierKeys = 0;
  if (inEvent.AltDown ()) {
      theModifierKeys = (theModifierKeys | PMouseEvent::kAlt);
  }
  if (inEvent.ControlDown ()) {
      theModifierKeys = (theModifierKeys | PMouseEvent::kControl);
  }
  if (inEvent.ShiftDown ()) {
      theModifierKeys = (theModifierKeys | PMouseEvent::kShift);
  }
  int theRepeatCount = 0;// todo: implement;

  PKeyEvent::EKey theKeyCode = PKeyEvent::kNone;
  long theKey = inEvent.GetKeyCode();  // inEvent.KeyCode ();  // changed because of Keycode being deprecated by wx in the newer version now...
  char theChar = 0;
  switch (theKey) {
  case WXK_LEFT:
    theKeyCode = PKeyEvent::kArrowLeft;
    break;
  case WXK_UP:
    theKeyCode = PKeyEvent::kArrowUp;
    break;
  case WXK_DOWN:
    theKeyCode = PKeyEvent::kArrowDown;
    break;
  case WXK_DELETE:
    theKeyCode = PKeyEvent::kDelete;
    break;
  case WXK_RIGHT:
    theKeyCode = PKeyEvent::kArrowRight;
    break;
  default:
    if (theKey >= 'A' && theKey <='Z') {
      theKeyCode = PKeyEvent::kChar;
      theChar = 'a' + theKey-'A';
    }
    break;
  }
  if (theKeyCode != PKeyEvent::kNone) {
    PKeyEvent theEvent (theKeyCode, theRepeatCount, theModifierKeys, theChar);
    if (GetInteractionContainer ().HandleKeyEvent (theEvent)) {
//      inEvent->accept ();
  //    repaint (rect (), FALSE);
  Refresh ();
    }
    return;
  }
 inEvent.Skip ();
}

void wxPPlot::DrawLine (float inX1, float inY1, float inX2, float inY2) {
	mDC->DrawLine ( (wxCoord) inX1, (wxCoord) inY1, (wxCoord) inX2, (wxCoord) inY2); // explicit cast to avoid warnings
}

void wxPPlot::FillRect (int inX, int inY, int inW, int inH) {
	mDC->DrawRectangle (inX, inY, inW, inH);
}

void wxPPlot::InvertRect (int inX, int inY, int inW, int inH) {
	mDC->SetLogicalFunction (wxINVERT);
	mDC->DrawRectangle (inX, inY, inW, inH);
	mDC->SetLogicalFunction (wxCOPY);
}

void wxPPlot::SetClipRect (int inX, int inY, int inW, int inH) {
	mDC->SetClippingRegion (inX, inY, inW, inH);
}

long wxPPlot::GetWidth () const {
	int theW, theH;
	GetSize (&theW, &theH);
	return theW;
}

long wxPPlot::GetHeight () const {
	int theW, theH;
	GetSize (&theW, &theH);
	return theH;
}

void wxPPlot::SetLineColor (int inR, int inG, int inB) {
	wxColour theColour (inR, inG, inB);
	mPen->SetColour (theColour);
	mDC->SetPen (*mPen);

//    wxFont &theFont = mDC->GetFont ();
    mDC->SetTextForeground (theColour);
}

void wxPPlot::SetFillColor (int inR, int inG, int inB) {
	wxColour theColour (inR, inG, inB);
	mBrush->SetColour (theColour);
	mDC->SetBrush (*mBrush);
}

long wxPPlot::CalculateTextDrawSize (const char *inString) {
	wxCoord theW, theH;
	mDC->GetTextExtent (inString, &theW, &theH);
	return theW;
}

long wxPPlot::GetFontHeight () const {
	wxCoord theW, theH;
	mDC->GetTextExtent ("gI", &theW, &theH);
 	int theSize = theW;
	return theSize;
}

void wxPPlot::DrawText (int inX, int inY, const char *inString) {
	mDC->DrawText (inString, inX, inY-GetFontHeight ());
}

void wxPPlot::DrawRotatedText (int inX, int inY, float inDegrees, const char *inString) {
	mDC->DrawRotatedText(inString, inX-GetFontHeight (), inY, -inDegrees);
}



