/***************************************************************************
                          QPPlot.cpp  - qt widget for (p)plotting  
                             -------------------
    begin                : Thu Oct 17 21:59:18 CEST 2002
    copyright            : (C) 2002 by Pier Philipsen
    email                : pier@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "QPPlot.h"

#include <qpainter.h>

#include "../generic/PPlotInteraction.h"

// internal function

void Translate (Qt::ButtonState inState, int &outModifierKeys) {
  int theModifierKeys = 0;
  bool theAlt = inState & Qt::AltButton;
  bool theControl = inState & Qt::ControlButton;
  bool theShift = inState & Qt::ShiftButton;
  if (theAlt) {
    theModifierKeys = (theModifierKeys | PMouseEvent::kAlt);
    fprintf (stderr, "alt\n");
  }
  if (theControl) {
    theModifierKeys = (theModifierKeys | PMouseEvent::kControl);
    fprintf (stderr, "control\n");
  }
  if (theShift) {
    theModifierKeys = (theModifierKeys | PMouseEvent::kShift);
    fprintf (stderr, "shift\n");
  }
  fprintf (stderr, "modifier keys %d\n", theModifierKeys);
  outModifierKeys = theModifierKeys;
}

PMouseEvent TranslateMouseEvent (QMouseEvent * e) {

  int theModifierKeys = 0;
  Translate (e->state (), theModifierKeys);
  /*
  bool theAlt = e->state () & Qt::AltButton;
  bool theControl = e->state () & Qt::ControlButton;
  bool theShift = e->state () & Qt::ShiftButton;
  if (theAlt) {
    theModifierKeys = (theModifierKeys | PMouseEvent::kAlt);
    fprintf (stderr, "alt\n");
  }
  if (theControl) {
    theModifierKeys = (theModifierKeys | PMouseEvent::kControl);
    fprintf (stderr, "control\n");
  }
  if (theShift) {
    theModifierKeys = (theModifierKeys | PMouseEvent::kShift);
    fprintf (stderr, "shift\n");
  }
  fprintf (stderr, "modifier keys %d\n", theModifierKeys);
  */
  PMouseEvent theEvent (e->x(), e->y(), PMouseEvent::kDown, theModifierKeys);
  return theEvent;
}


QPPlotBase::QPPlotBase(QWidget *parent, const char *name) : 
  QWidget(parent, name, WDestructiveClose),
  mPainter (0),
  mPen (0),
  mFont (0),
  mPDrawer (0)
{
  setBackgroundColor (QColor (255,255,255));
  QSizePolicy thePolicy (QSizePolicy::Expanding, QSizePolicy::Expanding);
  setSizePolicy (thePolicy);

  setFocusPolicy (StrongFocus);
}

QPPlotBase::~QPPlotBase()
{
  emit (QPPlotDeleted ());
  delete mPainter;
  mPainter = 0;
  delete mPen;
  mPen = 0;
  delete mFont;
  mFont = 0;
}

void QPPlotBase::paintEvent (QPaintEvent *inEvent) {
  //QWidget::paintEvent (inEvent);


  if (!mPDrawer) {
    return;
  }

  emit (StartDraw ());

  delete mPainter;
  mPainter = 0;

  QRect theRect = rect ();
  QPixmap thePixmap (theRect.size ());
  thePixmap.fill( this, theRect.topLeft() );// fill with backgound

  if (!mPainter) mPainter = new QPainter (&thePixmap);

  if (!mPen) mPen = new QPen ();
  if (!mFont) mFont = new QFont ();


  mPainter->setPen (*mPen);
  mPainter->setFont (*mFont);

  mPDrawer->Draw (*this);
  mPainter->end();

  mPainter->begin (this);
//  mPainter->setPen (*mPen);
//  mPainter->setFont (*mFont);

//  mPDrawer->Draw (*this);
  mPainter->drawPixmap (theRect.topLeft (), thePixmap);

  mPainter->end ();
  emit (EndDraw ());
}

void QPPlotBase::DrawLine (float inX1, float inY1, float inX2, float inY2){

  if (mPainter) {
    //    mPainter->drawLine (PPlot::Round (inX1), PPlot::Round (inY1), PPlot::Round (inX2), PPlot::Round (inY2));
    mPainter->drawLine (inX1, inY1, inX2, inY2);
  }
}

void QPPlotBase::FillRect (int inX, int inY, int inW, int inH) {
  if (mPainter) {
//		mPainter->fillRect (inX, inY, inW, inH, mPainter->brush ());
    mPainter->drawRect (inX, inY, inW, inH);
  }
}

void QPPlotBase::InvertRect (int inX, int inY, int inW, int inH) {
  if (mPainter) {
//		mPainter->fillRect (inX, inY, inW, inH, mPainter->brush ());
    mPainter->setRasterOp (Qt::NotROP);
    mPainter->drawRect (inX, inY, inW, inH);
    mPainter->setRasterOp (Qt::CopyROP);
  }
}

void QPPlotBase::SetClipRect (int inX, int inY, int inW, int inH) {
  if (mPainter) {
    mPainter->setClipRect (inX, inY, inW, inH);
  }
}


void QPPlotBase::SetLineColor (int inR, int inG, int inB) {
  if (mPen) {
    mPen->setColor (QColor (inR, inG, inB));
    mPainter->setPen (*mPen);
  }
  return;
}
void QPPlotBase::SetFillColor (int inR, int inG, int inB) {
  if (mPainter) {
    mPainter->setBrush (QColor (inR, inG, inB));
  }
}

long QPPlotBase::CalculateTextDrawSize (const char *inString) {
  if (mPainter) {
    QFontMetrics theMetrics = mPainter->fontMetrics ();
    return theMetrics.width (inString);
  }
  return strlen (inString)*13;
}

void QPPlotBase::DrawText (int inX, int inY, const char *inString) {
  if (mPainter) {
    QFontMetrics theMetrics = mPainter->fontMetrics ();
    mPainter->drawText (inX, inY-theMetrics.descent (), inString);
  }
}

void QPPlotBase::DrawRotatedText (int inX, int inY, float inDegrees, const char *inString) {
  if (mPainter) {
    QFontMetrics theMetrics = mPainter->fontMetrics ();
    mPainter->rotate (inDegrees);
    QPoint thePos (inX, inY);
    thePos = mPainter->xFormDev (thePos);
    thePos -= QPoint (0,theMetrics.descent ());
    mPainter->drawText (thePos, inString);
    mPainter->rotate (-inDegrees);
  }
}

void QPPlotBase::SetStyle (const PStyle &inStyle) {
  if (mPen) {
    mPen->setWidth (inStyle.mPenWidth);
    mFont->setPointSize (inStyle.mFontSize);
    mPainter->setPen (*mPen);
    mPainter->setFont (*mFont);
  }
}

void QPPlotBase::keyPressEvent( QKeyEvent * inEvent) {
  int theKey = inEvent->key ();
  if (theKey == Key_Enter || theKey == Key_Return) {
    emit (QPPlotPressed (this));
    inEvent->accept ();
    return;
  }
  int theModifierKeys = 0;
  Translate (inEvent->state (), theModifierKeys);
  int theRepeatCount = inEvent->isAutoRepeat ();

  PKeyEvent::EKey theKeyCode = PKeyEvent::kNone;

  char theChar = 0;
  switch (theKey) {
  case Key_Left:
    theKeyCode = PKeyEvent::kArrowLeft;
    break;
  case Key_Up:
    theKeyCode = PKeyEvent::kArrowUp;
    break;
  case Key_Down:
    theKeyCode = PKeyEvent::kArrowDown;
    break;
  case Key_Delete:
    theKeyCode = PKeyEvent::kDelete;
    break;
  case Key_Right:
    theKeyCode = PKeyEvent::kArrowRight;
    break;
  default:
    if (theKey >= Key_A && theKey <=Key_Z) {
      theKeyCode = PKeyEvent::kChar;
      theChar = 'a' + theKey-Key_A;
    }
    fprintf (stderr, "char: %c\n", theChar);
    break;
  }
  if (theKeyCode != PKeyEvent::kNone) {
    PKeyEvent theEvent (theKeyCode, theRepeatCount, theModifierKeys, theChar);
    if (GetInteractionContainer ().HandleKeyEvent (theEvent)) {
      inEvent->accept ();
      repaint (rect (), FALSE);
    }
  }

  inEvent->ignore ();
}

void QPPlotBase::mouseDoubleClickEvent( QMouseEvent *inEvent ) {
    emit (QPPlotPressed (this));
    inEvent->accept ();
}

void QPPlotBase::mousePressEvent ( QMouseEvent * e ) {
  PMouseEvent theEvent = TranslateMouseEvent (e);
  theEvent.mType = PMouseEvent::kDown;
  if (GetInteractionContainer ().HandleMouseEvent (theEvent)) {
    //update ();
    repaint (rect (), FALSE);
  } else {
      e->ignore ();
  }
}

void QPPlotBase::mouseReleaseEvent ( QMouseEvent * e ) {

  PMouseEvent theEvent = TranslateMouseEvent (e);;
  theEvent.mType = PMouseEvent::kUp;
  if (GetInteractionContainer ().HandleMouseEvent (theEvent)) {
//    update ();
    repaint (rect (), FALSE);
  } else {
      e->ignore ();
  }
}

void QPPlotBase::mouseMoveEvent ( QMouseEvent * e ) {
  PMouseEvent theEvent = TranslateMouseEvent (e);
  theEvent.mType = PMouseEvent::kMove;
  if (GetInteractionContainer ().HandleMouseEvent (theEvent)) {
//    update ();
    repaint (rect (), FALSE);
  } else {
      e->ignore ();
  }
}

QPPlot::QPPlot(QWidget* parent, const char *name):
  QPPlotBase (parent, name),
  mInteractionContainer (0)
{
  mInteractionContainer = mDefaultInteractionContainer = new DefaultInteractionContainer (mPPlot);
  SetPDrawer (&mPPlot);
}


QPPlot::~QPPlot() {
  delete mInteractionContainer;
}
