%module pplot
 %{
 /* Includes the header in the wrapper code */
 #include "../generic/PPlot.h"
 using namespace std;
 %}
 
 /* Parse the header file to generate wrappers */

%typemap(in) PlotDataBase * {

    PlotData *thePlotData = new PlotData ();

    if ( ! PyList_Check($input) ) {
        PyErr_SetString(PyExc_TypeError,"not a list");
        delete thePlotData;
        return NULL;
    }

    int size = PyList_Size($input);     
    int i;
    float theValue;
    for ( i = 0; i < size; i++ ) {
        PyObject *o = PyList_GetItem($input,i);
        if ( PyFloat_Check(o) ) {
            theValue = (float)PyFloat_AsDouble(PyList_GetItem($input,i));
        } 
        else if ( PyInt_Check(o) ) {
            theValue = (float)PyInt_AsLong(PyList_GetItem($input,i));
        } 
        else {
            PyErr_SetString(PyExc_TypeError,"list must only contain numbers");
            delete thePlotData;
            return NULL;
        }
        thePlotData->push_back(theValue); 
    }

    $1 = thePlotData;
}


// convert PlotData to python array
%typemap(out) PlotDataBase * {

    if (!$1) {
        $result=NULL;
    }

    const RealPlotData *thePlotData = $1->GetRealPlotData ();

    $result = PyList_New(thePlotData->size());

    for ( long i = 0; i < thePlotData->size(); i++) {
        float theValue = (*thePlotData)[i];
        PyList_SetItem($result, i, PyFloat_FromDouble((double)theValue) );
    }

}

 %include "../generic/PPlot.h"
