// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/endian.h
//!
//! @brief vZ@̃GfBA擾CIɕϊ郉Cu
//!

#ifndef __INCLUDE_MIST_ENDIAN__
#define __INCLUDE_MIST_ENDIAN__

#ifndef __INCLUDE_MIST_CONF_H__
#include "mist_conf.h"
#endif


// mistOԂ̎n܂
_MIST_BEGIN


//! @addtogroup endian_group GfBAɊւ̎擾yѕϊ
//!
//! @code ̃wb_CN[h
//! #include <mist/config/endian.h>
//! @endcode
//!
//! @{




/// @brief oCgzƒl̃yA\NX
//! 
//! ef[^^ƃoCg𓯎ɗp邱Ƃ\ł
//! 
//! @param T c gpf[^^
//! 
template < class T >
union byte_array
{
public:
	typedef T      value_type;		///< @brief f[^^^Cv
	typedef size_t size_type;		///< @brief size_tɓ

private:
	value_type value;								///< @brief f[^^^Cv\l
	unsigned char byte[ sizeof( value_type ) ];		///< @brief loCg\ɒ

public:
	/// @brief ftHgRXgN^
	byte_array( ) : value( 0 ){ }


	/// @brief l v pď
	byte_array( const value_type v ) : value( v ){ }


	/// @brief  byte_array pď
	byte_array( const byte_array &v ) : value( v.value ){ }


	/// @brief oCgpďs
	//!
	//! @attention ͂oCg̗vf́Csizeof( value_type ) ȏłȂĂ͂ȂȂ
	//!
	byte_array( const unsigned char *b )
	{
		for( size_type i = 0 ; i < sizeof( value_type ) ; i++ )
		{
			byte[ i ] = b[ i ];
		}
	}

	/// @brief ŎgpoCgԂ
	size_type length( ) const { return( sizeof( value_type ) ); }

	/// @brief index Ŏw肳ĈʒũoCg擾
	unsigned char &operator[]( size_type index ){ return( byte[ index ] ); }

	/// @brief index Ŏw肳Ĉʒu const oCg擾
	const unsigned char &operator[]( size_type index ) const { return( byte[ index ] ); }

	/// @brief l擾
	const value_type get_value( ) const { return( value ); }

	/// @brief lݒ肷
	value_type set_value( const value_type &v ) { return( value = v ); }

	/// @brief oCg擾
	const unsigned char * get_bytes( ) const { return( byte ); }
};


/// @brief ݂̃}ṼGfBAgGfBAǂ𒲂ׂ
//! 
//! @retval true  c gGfBA
//! @retval false c rbOGfBA
//! 
inline bool _is_little_endian_( )
{
	return( byte_array< unsigned short >( 1 )[ 0 ] == 1 );
}


/// @brief ݂̃}ṼGfBArbOGfBAǂ𒲂ׂ
//! 
//! ڍׂȐ֐̎gp
//! 
//! @retval true  c rbOGfBA
//! @retval false c gGfBA
//! 
inline bool _is_big_endian_( )
{
	return( byte_array< unsigned short >( 1 )[ 0 ] == 0 );
}


/// @brief byte_arraỹoCgXbv
//! 
//! @param[in,out] bytes c oCgXbvf[^
//! 
template < class T >
inline void swap_bytes( byte_array< T > &bytes )
{
	typedef typename byte_array< T >::size_type size_type;
	byte_array< T > tmp( bytes );
	for( size_type i = 0 ; i < sizeof( T ) ; ++i )
	{
		bytes[ i ] = tmp[ sizeof( T ) - i - 1 ];
	}
}


/// @brief byte_arraỹf[^݂̌vZ@̃GfBAɍ킹
//! 
//! - gGfBǍvZ@ŁCrbOGfBÃf[^͂Cfrom_little_endian = false ƂƁCϊ̃f[^̓gGfBAƂȂ
//! - rbOGfBǍvZ@ŁCgGfBÃf[^͂Cfrom_little_endian = true  ƂƁCϊ̃f[^̓rbOGfBAƂȂ
//! - ȊȌꍇ͉ϊȂ
//! 
//! @param[in] bytes              c ϊf[^
//! @param[in] from_little_endian c ϊÕGfBA^Cv
//! 
//! @return ϊ̃f[^
//! 
template < class T >
inline byte_array< T > to_current_endian( const byte_array< T > &bytes, bool from_little_endian )
{
	static bool current_endian = _is_little_endian_( );
	if( current_endian != from_little_endian )
	{
		byte_array< T > tmp( bytes );
		swap_bytes( tmp );
		return( tmp );
	}
	else
	{
		return( bytes );
	}
}


/// @brief byte_arraỹf[^݂̌vZ@̃GfBAړĨGfBAɍ킹
//! 
//! - gGfBǍvZ@ŁCto_little_endian = false ƂƁCϊ̃f[^̓rbOGfBAƂȂ
//! - rbOGfBǍvZ@ŁCto_little_endian = true  ƂƁCϊ̃f[^̓gGfBAƂȂ
//! - ȊȌꍇ́Cꂼ̌vZ@̃GfBÂ܂܂ŉϊȂ
//! 
//! @param[in] bytes            c ϊf[^
//! @param[in] to_little_endian c ϊ̃GfBA^Cv
//! 
//! @return ϊ̃f[^
//! 
template < class T >
inline byte_array< T > from_current_endian( const byte_array< T > &bytes, bool to_little_endian )
{
	static bool current_endian = _is_little_endian_( );
	if( current_endian != to_little_endian )
	{
		byte_array< T > tmp( bytes );
		swap_bytes( tmp );
		return( tmp );
	}
	else
	{
		return( bytes );
	}
}



/// @}
//  GfBAɊւ̎擾yѕϊO[v̏I


// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_ENDIAN__
