/*
 * blt.h --
 *
 * Copyright 1991-1998 by Bell Labs Innovations for Lucent
 * Technologies.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that the copyright notice and warranty
 * disclaimer appear in supporting documentation, and that the names
 * of Lucent Technologies any of their entities not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Lucent Technologies disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and
 * fitness.  In no event shall Lucent Technologies be liable for any
 * special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits, whether in
 * an action of contract, negligence or other tortuous action, arising
 * out of or in connection with the use or performance of this
 * software.
 */

#ifndef _BLT_H
#define _BLT_H

#define BLT_MAJOR_VERSION 	2
#define BLT_MINOR_VERSION 	5
#define BLT_VERSION		"2.5"
#define BLT_PATCH_LEVEL		"2.5.3"
#define BLT_RELEASE_SERIAL	29

#include <tcl.h>

#ifdef BUILD_blt
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS	DLLEXPORT
#endif

#ifdef __cplusplus
#   define EXTERN extern "C" TCL_STORAGE_CLASS
#else
#   define EXTERN extern TCL_STORAGE_CLASS
#endif

#ifndef _ANSI_ARGS_
#   define _ANSI_ARGS_(x)       ()
#endif

#include <bltVector.h>
#include <bltHash.h>

typedef char *Blt_Uid;

EXTERN Blt_Uid Blt_GetUid _ANSI_ARGS_((char *string));
EXTERN void Blt_FreeUid _ANSI_ARGS_((Blt_Uid uid));
EXTERN Blt_Uid Blt_FindUid _ANSI_ARGS_((char *string));
EXTERN CONST char *Blt_InitStubs _ANSI_ARGS_((Tcl_Interp *interp, char *version, int exact));

#if (TCL_MAJOR_VERSION >= 8)
EXTERN int Blt_GetArrayFromObj _ANSI_ARGS_((Tcl_Interp *interp, 
	Tcl_Obj *objPtr, Blt_HashTable **tablePtrPtr));
EXTERN Tcl_Obj *Blt_NewArrayObj _ANSI_ARGS_((int objc, Tcl_Obj *objv[]));
EXTERN void Blt_RegisterArrayObj _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int Blt_IsArrayObj _ANSI_ARGS_((Tcl_Obj *obj));
#endif /* TCL_MAJOR_VERSION >= 8 */

#ifndef USE_BLT_STUBS
#include "bltOldConfig.h"
#else

#include "bltDecls.h"
#endif
#endif /*_BLT_H*/
