static char sccsid[]="%Z% %M% %I% %E% %U%";

#include "akbcommon.h"

static int giLOG_NO_MAX_RESV=D_LOG_NO_MAX_RESV;
static char *log_name[D_LOG_NO_MAX]=
	{"ERROR_LOG","PRINT_LOG","DEBUG_LOG","STATI_LOG","TRACE_LOG"
#ifdef NAMEX_LOG
	,"NAME5_LOG","NAME6_LOG","NAME7_LOG","NAME8_LOG","NAME9_LOG"};
#else
	,NULL,NULL,NULL,NULL,NULL};
#endif

static char *gcpLogOutBuf=NULL;
static int  giLogOutBufLen=0;

static int giLogFlg[D_LOG_NO_MAX_RESV]=
	{D_LOG_FLG_STDERR | D_LOG_FLG_FILE
	,D_LOG_FLG_STDOUT | D_LOG_FLG_FILE | D_LOG_FLG_NO_SRC
	,D_LOG_FLG_NONE
	,D_LOG_FLG_NONE
	,D_LOG_FLG_LOG_CLEAR};

static char *gcLogFile[D_LOG_NO_MAX_RESV]=
{ERROR_LOG_FILE,PRINT_LOG_FILE,DEBUG_LOG_FILE,STATI_LOG_FILE,TRACE_LOG_FILE};

static int giLogLevel[D_LOG_NO_MAX_RESV]={0,0,0,0,0};
static int giLogGrpMask[D_LOG_NO_MAX_RESV]={0,0,0x7fffff00,0,0};
static uchar gucTrace[256];
static tdtLOG_CTL_HEAD *gtlh=NULL;
static int (*StatisticsCount)()=NULL;	/* (i,msglen) */
/********************************************/
/*                                          */
/********************************************/
static int _akb_log_new()
{
	tdtLOG_CTL *tlc;
	int i;

	if (!gtlh) {
		memset(gucTrace,0,sizeof(gucTrace));
		if (gtlh = akxa_log_new(D_LOG_NO_MAX)) {
			gtlh->cur_dir = akb_akb_home(0);
			gtlh->log_max_resv = giLOG_NO_MAX_RESV;
			for (i=0;i<D_LOG_NO_MAX;i++) {
				tlc = akxa_log_get_ctl(gtlh,i);
				if (i < gtlh->log_max_resv) {
					tlc->log_flg   = giLogFlg[i];
					tlc->log_level = giLogLevel[i];
					tlc->log_grp_mask = giLogGrpMask[i];
					tlc->log_file = Strdup(gcLogFile[i]);
/*
printf("_akb_log_new: i=%d log_flg=%04x log_level=%08x log_grp_mask=%08x\n",i,tlc->log_flg,tlc->log_level,tlc->log_grp_mask);
*/
				}
				tlc->log_rot.rot_file_max    = 3;
#ifdef OLD_CHECK_POINT	/* 2001.11.2 Koba */
				tlc->log_rot.rot_check_point = 10;
#else
				tlc->log_rot.rot_check_point = 0;
#endif
			}
		}
		else return -1;
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_free()
{
	if (gtlh) {
		akxa_log_free(gtlh);
		gtlh = NULL;
	}
	if (gcpLogOutBuf) {
		Free(gcpLogOutBuf);
		gcpLogOutBuf = NULL;
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_flog_out_level_pri_main(log_no,level,file,line,pri,fp,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  log_no,level,line,pri;
FILE *fp;
{
	if (_akb_log_new()) return -1;
	if (!akxa_log_flag_check(akxa_log_get_ctl(gtlh,log_no))) return 0;

	if (log_no<gtlh->log_max_resv && !akb_log_set_file_name(log_no, NULL))
		akb_log_set_file_name(log_no, gcLogFile[log_no]);

	return akxa_flog_out_level_pri_main(gtlh,
		log_no,level,file,line,pri,fp,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*											*/
/********************************************/
int akb_log_out_level_pri_main(log_no,level,file,line,pri,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  log_no,level,line,pri;
{
	return akb_flog_out_level_pri_main(log_no,level,file,line,pri,
	                                   NULL,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_out_level_main(log_no,level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  log_no,level,line;
{
	return akb_log_out_level_pri_main(log_no,level,file,line,AKX_LOG_INFO,
	                             format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_out_main(log_no,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  log_no,line;
{
	return akb_log_out_level_main(log_no,0,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out_level_pri(level,file,line,pri,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line,pri;
{
	akb_log_flg(D_LOG_NO_ERROR, D_LOG_FLG_PRIORITY |
	                          akb_log_flg(D_LOG_NO_ERROR,D_LOG_FLG_CHECK));

	return akb_log_out_level_pri_main(D_LOG_NO_ERROR,
	                   level,file,line,pri,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*											*/
/********************************************/
int akb_ferror_out_level(level,file,line,fp,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
FILE *fp;
{
	return akb_flog_out_level_pri_main(D_LOG_NO_ERROR,
	                    level,file,line,AKX_LOG_ERR,fp,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
	return akb_ferror_out_level(level,file,line,NULL,format,a1,a2,a3,a4,a5);
}
/********************************************/
/*                                          */
/********************************************/
int akb_error_out_m(file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  line;
{
	return akb_error_out_level(0,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out(file,line,msg)
char *file,*msg;
int  line;
{
	return akb_error_out_m(file,line,"%s",msg,NULL,NULL,NULL,NULL);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out_rc(file,line,msg,rc)
char *file,*msg;
int  line,rc;
{
	return akb_error_out_m(file,line,"%s %d",msg,rc,NULL,NULL,NULL);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out_s(file,line,format,msg)
char *file,*msg,*format;
int  line;
{
	return akb_error_out_m(file,line,format,msg,NULL,NULL,NULL,NULL);
}

/********************************************/
/*                                          */
/********************************************/
int akb_fprint_out_level(level,file,line,fp,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
FILE *fp;
{
	akb_log_flg(D_LOG_NO_PRINT, D_LOG_FLG_NO_SRC |
	                          akb_log_flg(D_LOG_NO_PRINT,D_LOG_FLG_CHECK));

	return akb_flog_out_level_pri_main(D_LOG_NO_PRINT,
	                    level,file,line,AKX_LOG_INFO,fp,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*											*/
/********************************************/
int akb_print_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
	return akb_fprint_out_level(level,file,line,NULL,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_print_out(format,a1,a2,a3,a4,a5)
char *format,*a1,*a2,*a3,*a4,*a5;
{
	return akb_print_out_level(0,NULL,0,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_debug_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
	return akb_log_out_level_pri_main(D_LOG_NO_DEBUG,
	                  level,file,line,AKX_LOG_DEBUG,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_debug_out_m(file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  line;
{
	return akb_debug_out_level(0,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_debug_input(file,line,msg,x,pi)
char *file,*msg;
int  line, x, *pi;
{
	char buf[64];

    printf("%s(%d): %s %d ==> ", file, line, msg, x);
	gets(buf);
	if (pi && *buf) *pi = atoi(buf);
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_out(msg)
char *msg;
{
	char *p, c='\0';
	int len, ret;

	if (!msg) msg = akb_log_buf(0);
	if ((len = strlen(msg)) > 0) {
		p = msg + len - 1;
		if ((c=*p) == '\n') *p = '\0';
	}
	ret = akb_print_out("%s",msg,NULL,NULL,NULL,NULL);
	if (c == '\n') *p = c;
	return ret;
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_buf(len)
int len;
{
	if (len > 0) {
		if (gcpLogOutBuf) {
			if (len > giLogOutBufLen) {
				if (gcpLogOutBuf = Realloc(gcpLogOutBuf,len))
					giLogOutBufLen = len;
				else giLogOutBufLen = 0;
			}
		}
		else {
			if (gcpLogOutBuf = Malloc(len)) giLogOutBufLen = len;
			else giLogOutBufLen = 0;
		}
	}
	return gcpLogOutBuf;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_buf_len(opt)
int opt;
{
	return giLogOutBufLen;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_flg(i,f)
int i,f;
{
	if (_akb_log_new()) return -1;
	return akxa_log_flg(gtlh,i,f);
}

/********************************************/
/*                                          */
/********************************************/
void akb_log_set_proc_name(cpName)
char *cpName;
{
	if (_akb_log_new()) return;
	akxa_log_set_proc_name(gtlh,cpName);
	return;
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_get_proc_name()
{
	if (_akb_log_new()) return NULL;
	return akxa_log_get_proc_name(gtlh);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_akb_dump(iRW,pHead)
int  iRW;
pCOMM_PACK_HEAD pHead;
{
	char *p;

	p = akb_log_set_file_name(0, NULL);
	if (!p) p = akb_log_set_file_name(0, ERROR_LOG_FILE);
	akb_dump(p,iRW,pHead,pHead+1);
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_set_file_name(i, cpFile)
int  i;
char *cpFile;
{
	if (_akb_log_new()) return NULL;
	return akxa_log_set_file_name(gtlh, i, cpFile);
}

/********************************************/
/*                                          */
/********************************************/
int akb_get_log_time(buf,len,format)
char *buf,*format;
int  len;
{
	return akx_get_log_time(buf,len,format);
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_time()
{
	return akx_log_time();
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_parm2(argc,argv,nParm,iParm)
int  argc,nParm;
long iParm[];
char *argv[];
{
	if (_akb_log_new()) return -1;
	akxa_log_set_parm2(gtlh,argc,argv,nParm,iParm);
	if (argc>=3 && iParm[0]==D_LOG_NO_TRACE) {
		argv[0] = "-1";
		akxa_log_set_parm(gtlh,3,argv,iParm);
		if (iParm[2]>=0 && iParm[1]>=0) akb_trace_flg(iParm[2],iParm[1]);
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_parm(argc,argv,iParm)
int  argc;
long iParm[];
char *argv[];
{
	return akb_log_set_parm2(argc,argv,9,iParm);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_from_file(logno,file)
int logno;
char *file;
{
	char buf[D_RECORD_BUFSIZE];
	char parm[D_RECORD_BUFSIZE];
	FILE *fp;
	int argc;
	char *f,*argv[9];
	int iRc;
	long iParm[10];
/*
printf("akb_log_from_file:logno=%d,file=[%s]\n",logno,file);
*/
	f = akb_akb_home_add(file);
	if (fp = fopen(f,"r")) {
		while (akxa_read_line(buf,sizeof(buf),fp)) {
			argc = akxtgetargv2(buf,argv,9,parm,sizeof(parm),3);
			if (argc < 0) break;
			else if (argc >= 2) {
				if (!stricmp(argv[0],"srcfile")) {
					if (logno<0 || (logno>=0 && logno==atoi(argv[1])))
						iRc = akb_log_src_file(argc,argv);
				}
				else {
					if (logno<0 || (logno>=0 && logno==atoi(argv[0]))) {
						iRc = akb_log_set_parm2(argc,argv,10,iParm);
						if (iParm[6] == -2) iRc = D_ERR_MEM_ALLOC;
					}
				}
			}
		}
		fclose(fp);
	}
	else {
		ERROROUT1("akb_log_from_file:file[%s] open error.",f);
		return -1;
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
static int _log_setup2(c1,section,na1,na2,argv,n,pi)
char c1,*section,*na1,*na2,**argv;
int  n,*pi;
{
	char work[10];
	long iParm[10];

	if (n >= 2) {
		sprintf(work,"%d",*pi);
		argv[0] = work;
		if (!stricmp(argv[1],"-f") && n>=3) {
			akb_log_from_file(*pi,argv[2]);
		}
		else if (!stricmp(argv[1],"srcfile")) {
			argv[1] = work;
			akb_log_src_file(n,argv);
		}
		else {
			akb_log_set_parm2(n,argv,n,iParm);
			if (iParm[6] == -2) return D_ERR_MEM_ALLOC;
		}
	}
	return n;
}

int akb_log_setup2(cpProcName)
char *cpProcName;
{
/*
	static char *name[]=
		{"ERROR_LOG","PRINT_LOG","DEBUG_LOG","STATI_LOG","TRACE_LOG"};
*/
	char *argv[8],buf[81],*p,work[10],*namv[3];
	int i,n,w,len;

	namv[0] = D_SECTION_AKB_SYSTEM;
	namv[2] = cpProcName;
	for (i=0;i<giLOG_NO_MAX_RESV;i++) {
		if ((namv[1]=log_name[i]) && *namv[1]) {
			n = akb_gs_akb_stpl_func(namv,'.',"1 2 3 ",argv,8,_log_setup2,&i);
			if (n < 0) return n;
		}
	}

	namv[1] = "LOGDIR";
	n = akb_gs_akb_stpl_func(namv,'.',"2 3 1 ",argv,2,NULL,NULL);
	if (n < 0) return n;
	else if (n >= 2)
		if (!akb_log_set_dir(argv[1])) return D_ERR_MEM_ALLOC;

	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_setup()
{
	return akb_log_set_up_name(NULL);
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_set_dir(cpDir)
char *cpDir;
{
	if (_akb_log_new()) return NULL;
	return akxa_log_set_dir(gtlh,cpDir);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_up_name(cpProcName)
char *cpProcName;
{
	int ret;

	if (cpProcName && *cpProcName) akb_log_set_proc_name(cpProcName);
	ret = akb_log_setup2(cpProcName);
	if (akb_log_flg(D_LOG_NO_TRACE,D_LOG_FLG_CHECK) & D_LOG_FLG_LOG_CLEAR)
		akb_log_clear(D_LOG_NO_TRACE,0);

	return ret;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_grp_level(i,flg,level)
int i,flg,level;
{
	if (_akb_log_new()) return -1;
	return akxa_log_group_level(gtlh,i,flg,level);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_level(i,level)
int i,level;
{
	if (_akb_log_new()) return -1;
	return akxa_log_level(gtlh,i,level);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_grp_mask(i,levelbitc)
int i,levelbitc;
{
	if (_akb_log_new()) return -1;
	return akxa_log_grp_mask(gtlh,i,levelbitc);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_src_file(pCtChg,logno,ope,setno,file,line1,line2)
tdtRB_CTL *pCtChg;
char *file;
int  logno,ope,setno,line1,line2;
{
	if (_akb_log_new()) return -1;
	return akxa_log_set_src_file(gtlh,pCtChg,logno,ope,setno,file,line1,line2);
}

/*********************************************/
/*  argv[0]:"srcfile"                        */
/*  argv[1]:logno                            */
/*  argv[2]:filename  / setno    > 0         */
/*  argv[3]:line1     / filename != null     */
/*  argv[4]:line2     / line1    > 0         */
/*  argv[5]:          / line2    > 0         */
/*********************************************/
int akb_log_src_file(argc,argv)
int  argc;
char *argv[];
{
	if (_akb_log_new()) return -1;
	return akxa_log_src_file(gtlh,NULL,argc,argv);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_size(i,n,parm)
int i,n,parm[];
{
	if (_akb_log_new()) return -1;
	return akxa_log_size(gtlh,i,n,parm);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_out_check(log_no,level,file,line)
int  log_no,level,line;
char *file;
{
	tdtLOG_CTL *tlc;

	if (_akb_log_new()) return -1;
	if (!(tlc = akxa_log_get_ctl(gtlh,log_no))) return -1;
	return akxa_log_out_check(tlc,level,file,line);
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_flg(i,f)
int i,f;
{
/*
printf("akb_trace_flg:i=%d f=%d\n",i,f);
*/
	if (i>0 && i<256) {
		if (f >= 0) gucTrace[i] = f;
	}
	else if (i == 0) {
		memset(gucTrace,f,sizeof(gucTrace));
	}
	else {
		return -1;
	}

	return gucTrace[i];
}

/********************************************/
/*                                          */
/********************************************/
char *akb_trace_set_file_name(cpFile)
char *cpFile;
{
	return akb_log_set_file_name(D_LOG_NO_TRACE, cpFile);
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_check(ucTrace,iRW,sCmd)
unsigned char *ucTrace;
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
short sCmd;
{
	pCOMM_PACK_HEAD pHead;
	int iTrace, iFlag;
/*
printf("akb_trace_check:ucTrace=%08x,iRW=%d,sCmd=%d\n",ucTrace,iRW,sCmd);
*/
	if (ucTrace) iTrace = ucTrace[sCmd];
	else {
		if (sCmd<0 || sCmd>255) return 0;
		else iTrace = gucTrace[sCmd];
	}
/*
printf("akb_trace_check:iTrace=%d\n",iTrace);
*/
	if (sCmd == CM_CMD_SEND) sCmd = 0;
	iFlag = 0;
	if (!sCmd && ((iTrace & 0x03)==0x03)) {
		if ((!(iTrace & 0x04) && (iRW==0 || iRW==2)) ||
		    (iTrace & 0x04)) iFlag = 1;
	}
	else {
		if ((!iRW && (iTrace & 0x01)) ||
		    ( iRW && (iTrace & 0x02))) iFlag = 1;
	}
/*	if (iFlag) iFlag |= (iTrace & (AKB_TRACE_HEAD_ONLY | AKB_TRACE_BINARY)); */
	if (iFlag) iFlag |= (iTrace & 0x00f8);
	return iFlag;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace(ucTrace,fname,iRW,cpPacket)
unsigned char *ucTrace;
char *fname;
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
char *cpPacket;
{
	pCOMM_PACK_HEAD pHead;
	short sCmd;
	int iFlag,iHSize,opt=0;
	char *p;
	char *fn,buf[128];
	tdtLOG_CTL *tlc;

	if (!cpPacket) return -1;
#if 1	/* 2001.10.17 Koba */
	if (!ucTrace || !fname) return -1;
#endif
	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd = ntohs(pHead->cph_prt.prt_cmnd) & 0x00ff;

	if (_akb_log_new()) return -1;
	if (iFlag=akb_trace_check(ucTrace,iRW,sCmd)) {
		if (iFlag & AKB_TRACE_HEAD_ONLY) p = NULL;
		else {
			AKBGETHSIZE(pHead,iHSize)
			p = cpPacket + iHSize;
		}
	/*	if (iFlag & AKB_TRACE_BINARY) opt = 1;	*/
		opt = iFlag & 0x00f8;
#if 0	/* 2001.10.17 Koba */
		if (!fname) {
			fname = akb_trace_set_file_name(NULL);
			if (!fname) fname = akb_trace_set_file_name(TRACE_LOG_FILE);
		}
		fn = fname;
		if (tlc = akxa_log_get_ctl(gtlh,D_LOG_NO_TRACE)) {
			akxa_rotate(&tlc->log_rot,akb_akb_home_add(fn));
		/*
			if (tlc->log_rot.rot_file_no > 0) {
				fn = buf;
				sprintf(buf,"%s%d",fname,tlc->log_rot.rot_file_no);
			}
		*/
		}
		akb_dump2(fn,iRW,pHead,p,opt);
#else
		akb_dump2(fname,iRW,pHead,p,opt);
#endif
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_log_out(iRW,cpPacket,logflg,file,line,format,a1,a2,a3,a4,a5)
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
char *cpPacket;
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  logflg,line;
{
	pCOMM_PACK_HEAD pHead;
	short sCmd;
	int iFlag,iHSize,opt=0,iLogFlg;
	char *pBody,*p;
	char *fname,buf[256],*cpPath=NULL;
	tdtLOG_CTL *tlc;
/*
	static char *cpPath2=NULL,*cpPath3=NULL;
*/
	if (!cpPacket) return -1;
	if (_akb_log_new()) return -1;

	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd = ntohs(pHead->cph_prt.prt_cmnd) & 0x00ff;
	if (iFlag=akb_trace_check(NULL,iRW,sCmd)) {
/*
printf("iFlag = %08x\n",iFlag);
*/
		if (iFlag & AKB_TRACE_HEAD_ONLY) pBody = NULL;
		else {
			AKBGETHSIZE(pHead,iHSize);
			pBody = cpPacket + iHSize;
		}
	/*	if (iFlag & AKB_TRACE_BINARY) opt = 1; */
		opt = iFlag & 0x00f8;

		fname = akb_trace_set_file_name(NULL);
		if (!fname) fname = akb_trace_set_file_name(TRACE_LOG_FILE);
#if 0	/* 2003.7.12 Koba */
		p = akxt_add_dir2(gtlh->log_dir,fname,&cpPath2);
		if (!p) p = fname;
		cpPath = akxt_add_dir2(gtlh->cur_dir,p,&cpPath3);
		if (!cpPath) cpPath = p;
#else
		cpPath = akxa_log_file_path(gtlh,D_LOG_NO_TRACE,0);
#endif
		if (tlc = akxa_log_get_ctl(gtlh,D_LOG_NO_TRACE)) {
			cpPath = akxa_rotate(&tlc->log_rot,cpPath);
		/*
			if ((tlc->log_rot.rot_option & 0x01) && (tlc->log_rot.rot_file_no > 0)) {
				cpPath = buf;
				sprintf(buf,"%s%d",fname,tlc->log_rot.rot_file_no);
			}
		*/
		}
		if (opt & AKB_TRACE_LOGOUT) {
			iLogFlg = tlc->log_flg;
			tlc->log_flg = logflg;
			if (akxa_log_out_check(tlc,0,file,line))
				akxa_log_out(cpPath,logflg,NULL,file,line,format,a1,a2,a3,a4,a5);
			tlc->log_flg = iLogFlg;
		}
		akb_dump2(cpPath,iRW,pHead,pBody,opt);
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_out(iRW,cpPacket)
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
char *cpPacket;
{
	return akb_trace_log_out(iRW,cpPacket,0,0,0,0,0,0,0,0,0);
}

/********************************************/
/*                                          */
/********************************************/
int akbfixdmp(file,msg,dat,len)
char *file,*msg,*dat;
int len;
{
	static char *buf=NULL;
	int msglen;

	if (!msg) msg = "";
	msglen = strlen(msg) + 100;
	if (buf) buf = Realloc(buf,msglen);
	else buf = Malloc(msglen);
	if (buf) sprintf(buf,"%s %s",akb_log_time(),msg);
	return akxafixdmp(akb_akb_home_add(file),buf,dat,len);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_clear(log_no,option)
int log_no,option;
{
	if (_akb_log_new()) return -1;
	return akxa_log_clear(gtlh,log_no,option);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_setup_clear(log_no,option)
int log_no,option;
{
	if (akb_log_flg(log_no,D_LOG_FLG_CHECK) & D_LOG_FLG_LOG_CLEAR)
		akb_log_clear(log_no,option);

	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_func_statistics_count(func)
int (*func)();
{
	StatisticsCount = func;
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_statistics_count(i,len)
int i,len;
{
	int ret;

	if (StatisticsCount) ret = StatisticsCount(i,len);
	else ret = -1;

	return ret;
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_file_path(log_no,option)
int log_no,option;
{
	if (_akb_log_new()) return NULL;
	return akxa_log_file_path(gtlh,log_no,option);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_file_path_free_all()
{
	if (_akb_log_new()) return -1;
	return akxa_log_file_path_free_all(gtlh);
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_set_log_name(log_no,name)
int log_no;
char *name;
{
	if (log_no<0 || log_no>=D_LOG_NO_MAX) return NULL;
	if (_akb_log_new()) return NULL;
	if (name) {
		log_name[log_no] = Strdup(name);
		if (log_no+1 > giLOG_NO_MAX_RESV) {
			giLOG_NO_MAX_RESV = log_no + 1;
			gtlh->log_max_resv = giLOG_NO_MAX_RESV;
		}
	}
	return log_name[log_no];
}

/********************************************/
/*                                          */
/********************************************/
tdtLOG_CTL *akb_log_get_ctl(log_no)
int log_no;
{
	if (_akb_log_new()) return NULL;
	return akxa_log_get_ctl(gtlh,log_no);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_command_parm(opt_c,parm_string)
char opt_c,*parm_string;
{
	static tdtGENERAL_DATA logno_set[]=
		 {{0,0,0,0,0,"l",-1}
		,{D_LOG_NO_ERROR,0,0,0,0,"e",-1}
		,{D_LOG_NO_PRINT,0,0,0,0,"p",-1}
		,{D_LOG_NO_DEBUG,0,0,0,0,"d",D_LOG_FLG_STDERR}
		};
	char opt_string[2];

	if (_akb_log_new()) return -1;
	opt_string[0] = opt_c;
	opt_string[1] = '\0';
	return akxa_log_set_command_parm(gtlh,4,logno_set,opt_string,parm_string,0);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_grp_priority(i,flg,pri)
int i,flg,pri;
{
	if (_akb_log_new()) return -1;
	return akxa_log_group_priority(gtlh,i,flg,pri);
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_priority(i,pri)
int i,pri;
{
	if (_akb_log_new()) return -1;
	return akxa_log_priority(gtlh,i,pri);
}

/********************************************/
/*											*/
/********************************************/
int akb_get_log_no(name)
char *name;
{
	int i;
	char **p;

	if (!name) return -1;
	p = log_name;
	for (i=0;i<giLOG_NO_MAX_RESV;i++,p++) {
		if (!stricmp(name,*p)) return i;
	}
	return -1;
}

/********************************************/
/*											*/
/********************************************/
char *akb_get_log_name(log_no)
int log_no;
{
	char *p;

	if (log_no>=0 && log_no<giLOG_NO_MAX_RESV) {
		if (!(p=log_name[log_no])) p = "";
	}
	else p = NULL;
	return p;
}

/********************************************/
/*											*/
/********************************************/
int akb_log_level_check(log_no,level)
int  log_no,level;
{
	tdtLOG_CTL *tlc;

	if (_akb_log_new()) return -1;
	if (!(tlc = akxa_log_get_ctl(gtlh,log_no))) return -1;
	return akxa_log_level_check(tlc,level);
}

/****************************************/
/*										*/
/****************************************/
int akb_prdbg_out_l5(level,file,line,fmt,a1,a2,a3,a4,a5)
int level,line;
char *file,*fmt,*a1,*a2,*a3,*a4,*a5;
{
	return  akb_anydbg_out_l5(level,D_LOG_NO_PRINT,file,line,fmt,a1,a2,a3,a4,a5);
}

/****************************************/
/*										*/
/****************************************/
int akb_errdbg_out_l5(level,file,line,fmt,a1,a2,a3,a4,a5)
int level,line;
char *file,*fmt,*a1,*a2,*a3,*a4,*a5;
{
	return  akb_anydbg_out_l5(level,D_LOG_NO_ERROR,file,line,fmt,a1,a2,a3,a4,a5);
}

/****************************************/
/*										*/
/****************************************/
int akb_anydbg_out_l5(level,i_LOG_NO_PRINT,file,line,fmt,a1,a2,a3,a4,a5)
int level,line,i_LOG_NO_PRINT;
char *file,*fmt,*a1,*a2,*a3,*a4,*a5;
{
	int log_no,f_prn,f_dbg,l_prn,l_dbg,f,f_file,log_file,f_stdsys;
	char *pr_log_file;

	if (i_LOG_NO_PRINT == D_LOG_NO_DEBUG) {
		return akb_debug_out_level(level,file,line,fmt,a1,a2,a3,a4,a5);
	}
	else if (i_LOG_NO_PRINT == D_LOG_NO_PRINT) pr_log_file = PRINT_LOG_FILE;
	else if (i_LOG_NO_PRINT == D_LOG_NO_ERROR) pr_log_file = ERROR_LOG_FILE;
	else return -1;

	f_prn = LOGFLG(i_LOG_NO_PRINT,D_LOG_FLG_CHECK);
	if (i_LOG_NO_PRINT == D_LOG_NO_ERROR) f_prn &= ~D_LOG_FLG_FILE;
	f_dbg = LOGFLG(D_LOG_NO_DEBUG,D_LOG_FLG_CHECK);
	l_prn = LOGLEVELCHK(i_LOG_NO_PRINT,level);
	l_dbg = LOGLEVELCHK(D_LOG_NO_DEBUG,level);
	f_stdsys = D_LOG_FLG_STDOUT | D_LOG_FLG_STDERR | D_LOG_FLG_SYSLOG;
	f = (f_prn | f_dbg) & f_stdsys;

	if (l_dbg) log_no = D_LOG_NO_DEBUG;
	else if (l_prn) log_no = i_LOG_NO_PRINT;
	else return 0;
/*
printf("akb_prdbg_out_l5: log_no=%d\n",log_no);
*/
	log_file = log_no;
	if ((f_prn & D_LOG_FLG_FILE) && (f_dbg & D_LOG_FLG_FILE)) {
		if (!stricmp(akb_log_file_path(i_LOG_NO_PRINT,0x01),
		            akb_log_file_path(D_LOG_NO_DEBUG,0x01))) {
			if ( !stricmp(akb_log_set_file_name(i_LOG_NO_PRINT,NULL),PRINT_LOG_FILE)) {
				log_file = i_LOG_NO_PRINT;
				f_file = f_prn;
			}
			else {
				log_file = D_LOG_NO_DEBUG;
				f_file = f_dbg;
			}
		}
	}
/*
printf("akb_prdbg_out_l5: log_file=%d\n",log_file);
*/
	if (log_file == D_LOG_NO_DEBUG) {
		LOGFLG(log_file,f_dbg | f);
		akb_debug_out_level(0,file,line,fmt,a1,a2,a3,a4,a5);
	}
	else {
		LOGFLG(log_file,f_prn | f);
		akb_print_out_level(0,file,line,fmt,a1,a2,a3,a4,a5);
	}

	if (log_file != log_no) {
		LOGFLG(log_file,f_file & ~f_stdsys);
		if (log_file == D_LOG_NO_DEBUG)
			akb_debug_out_level(0,file,line,fmt,a1,a2,a3,a4,a5);
		else
			akb_print_out_level(0,file,line,fmt,a1,a2,a3,a4,a5);
	}

	LOGFLG(i_LOG_NO_PRINT,f_prn);
	LOGFLG(D_LOG_NO_DEBUG,f_dbg);

	return 0;
}
