static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akalib4.c
 *
 *        coded by A.Kobayashi 96/1/31
 *      updated by A.Kobayashi 2000/3/16
 *
 *************************************************/
#include "akacommon.h"

extern tdtMSG_CTL         tMsgCtl;
extern tdtCLASS_CTLHead   tClassHead;

static tdtWAIT_PACKET *new_wait_packet();
static tdtWAIT_METHOD *new_wait_method();

/********************************************************/
/*                                                      */
/********************************************************/
static int msg_out_put()
{
	int iRcW, iRcR, msec;
	struct timeval tval;

	while ((iRcW=aka_packet_write())>0) {
	/* ReadŃG[ɂȂĂAvZX͏IłȂ
		if ((iRcR=aka_packet_read(0))<0) {
			return iRcR;
		}
	*/
		msec = akb_nwselect_wait_time(&tval);
		if (msec > 0) {
/*
printf("msg_out_put: wait tv_sec=%d tv_usec=%d\n",tval.tv_sec,tval.tv_usec);
*/
			if (tval.tv_sec  > 0)  sleep(tval.tv_sec);
			if (tval.tv_usec > 0) usleep(tval.tv_usec);
		}
	}
	return iRcW;
}

#if 0	/* 2003.5.17  Koba */
/********************************************************/
/*                                                      */
/********************************************************/
static pSD_PACKET_TABLE ReFormPacket(pNew)
pSD_PACKET_TABLE pNew;
{
	int len,iHSize;
	char *cpW,*packet;
	pSD_PACKET_TABLE pOld;
	char procname[16];
	pCOMM_PACK_HEAD   pHead;

	if (tMsgCtl.host_id == tMsgCtl.my_host_id) {
		packet = pNew->sp_content;
		sprintf(procname,"P%d",tMsgCtl.us_proc);
		pHead = (pCOMM_PACK_HEAD)packet;
		AKBGETHSIZE(pHead,iHSize)
		len=akb_mem_to_indir_f(procname,packet,packet+iHSize,&cpW);
		if (len<0) {
			Free(packet);
			Free(pNew);
			return NULL;
		}
		else if (len>0) {
			Free(packet);
			pNew->sp_len = len;
			pNew->sp_content = cpW;
		}
	}
	else {
		/* vZXǗƈقȂzXgŉғĂƂ̕ϊ */
PRINTOUT2("deferent Host(pr=%08x,my=%08x). make Xpacket",
tMsgCtl.host_id,tMsgCtl.my_host_id);
		pOld = pNew;
		pNew = akb_make_xpacket(pOld);
		if (!pNew) {
			Free(packet);
			Free(pOld);
		}
	}

	return pNew;
}
#endif

/********************************************************/
/*      L[ɓAbZ[Wo͂              */
/********************************************************/
static int set_que_and_out_put(pCh,cpPacket,iSendLen,iQue,iOut)
tdtCHANNEL *pCh;
char *cpPacket;
int  iSendLen,iOut;
int  iQue;	/* =0:R, !=0:W */
{
	pSD_PACKET_TABLE  pNew,pOld;
	pCOMM_PACK_HEAD   pHs,pHd;
	tdtREP_HEAD *pRH;
	int ret;
	char *cpW;
	tdtRB_CTL *pRbCtl;

	if (pCh->sys_opt & AKA_CHSO_USE_AKB_HEAD) {
		pCh->woffset = 0;
	}
	else {
		pHs = (pCOMM_PACK_HEAD)cpPacket;
		if (pHs->cph_prt.prt_ver != 'A' && pHs->cph_sinf.ind_disp) {
			if (pHd = pCh->wpack_head) {
				memcpy((char *)&(pHd->cph_prt),(char *)&(pHs->cph_prt),
				       sizeof(tdtPROTCOL));
				memcpy((char *)&(pHd->cph_sinf),(char *)&(pHs->cph_dinf),
				       sizeof(tdtINDICATE));
				memcpy((char *)&(pHd->cph_dinf),(char *)&(pHs->cph_sinf),
				       sizeof(tdtINDICATE));
			/* 1999.5.14 Koba
				pHd->cph_plen = pHs->cph_plen ;
			*/
				pHd->cph_plen = 0 ;
#ifndef NO_CHANNEL_QUE
				if (pCh->wpack_que) {
					if (!(pRH=(tdtREP_HEAD *)Malloc(sizeof(tdtREP_HEAD))))
						return -18506203;
					memcpy((char *)pRH,(char *)pHd,sizeof(tdtCOMM_PACK_HEAD));
					pRH->instance_handle = pHs->cph_sinf.ind_thrd <<16 |
					                       pHs->cph_sinf.ind_clid;
					memset(pRH->sequence,0,sizeof(pRH->sequence));
					ret = akxs_que_put(pCh->wpack_que,QUE_DFLT,(char *)pRH);
/*
printf("set_que_and_out_put:akxs_que_put ret=%d\n",ret);
*/
					if (ret <= 0) {
						Free(cpPacket);
						Free(pRH);
						return -18506203;
					}
				}
#endif
			}
		}
	}

	if (!(pNew = akb_packet_tbl_new(0))) {
		Free(cpPacket);
		return -18506201;
	}
	pNew->sp_content = cpPacket;
	pNew->sp_len     = iSendLen;
	pNew->sp_ch      = pCh->index;
	pNew->sp_offset   = pCh->woffset;

DEBUGOUTL4(AKA_LOG_GROUP|250,
"set_que_and_out_put:iLen=%d iCh=%d offset=%d iQue=%d",
pNew->sp_len,pNew->sp_ch,pNew->sp_offset,iQue);

	if (iQue) {
		pRbCtl = tMsgCtl.rb_wctl;
/* 2003.5.17  Koba
		if (pNew->sp_ch==0) pNew = ReFormPacket(pNew);
*/
	}
	else
		pRbCtl = tMsgCtl.rb_rctl;

	/* L[ɓ */
	if (!akxs_rb_set_n(pRbCtl,pNew)) {
		Free(cpPacket);
		Free(pNew);
		return -18506202;
	}
	aka_statistics_count(1,pNew->sp_len);

	/* bZ[Wo͏ */
	if (iOut) return msg_out_put();
	return 0;
}

/********************************************************/
/*    L[𕪂āAbZ[Wo͂        */
/********************************************************/
static int Chkset_que_and_out_put(pHead,pCh,cpPacket,iSendLen,iOut)
pCOMM_PACK_HEAD   pHead;
tdtCHANNEL *pCh;
char *cpPacket;
int  iSendLen,iOut;
{
	int iQue;
	INT4 lWrk;

	if (pCh->sys_opt & AKA_CHSO_AKB_USED) iOut = iQue = 0;
	else if (pCh->index == 0 &&
	/*
	    ntohl(pHead->cph_dinf.ind_hoid)     == tMsgCtl.host_id &&
	*/
	    ntohs(pHead->cph_dinf.ind_prid) == tMsgCtl.us_proc  &&
		pHead->cph_prt.prt_ver != 'A') {
	    lWrk = ntohl(pHead->cph_dinf.ind_hoid);
		if (lWrk==tMsgCtl.host_id || lWrk==tMsgCtl.apsys_id)
			iOut = iQue = 0;	/* Read L[ɓ */
		else iQue = 1;
	}
	else {
		/* WriteL[ɓ */
		iQue = 1;
	}
	return set_que_and_out_put(pCh,cpPacket,iSendLen,iQue,iOut);
}

/********************************************************/
/*                                                      */
/********************************************************/
static int create_pk_data(tpHead,tpSendMsgCom,cppPacket)
tdtCOMM_PACK_HEAD   *tpHead;
AKAMSGCOM       *tpSendMsgCom;
char            **cppPacket;
{
	int lPackLen;

	lPackLen = akb_create_pk_data(NULL,tpHead,tpSendMsgCom,cppPacket);
	if (lPackLen < 0) lPackLen -= 18506300;
/*
else akxaxdump("create_pk_data:",*cppPacket,lPackLen);
*/
	return lPackLen;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int send_or_post_msg(lInstanceHandle,tpSendMsg,iSend,iWaitTime)
long       lInstanceHandle;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg;		/* bZ[WMp\̂ւ̃|C^ */
int iSend;		/* 0/1 = Post / Send */
int iWaitTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	tdtCOMM_PACK_HEAD   tHead,*pHead;
	tdtCOMM_PACK_HEADB  *pHeadB;
	tdtCOMM_PACK_HEADA  tHeadA;
	int             iThread,iClassId,iRc;
	INT4            iWrk,iWrk2;
	tdtCLASS_CTL     *tpClass;
	char            *cpPacket,*cpWaitPacket;
	int             iSendLen;
	tdtINSTANCE     *tpIns;
	tdtWAIT_PACKET   *tpWait;
	int             lmsec;
	struct timeval  ttime;
	int             iNullClass,iCh;
	tdtCHANNEL      *pCh;
	ushort          usWrk,usPacketNo;
	tdtCOM_OBJECT    *tpComObject=NULL;
	tdtINST_HNDL     tInstHndl;
	struct sockaddr_in *psa;
	ushort          usAPSysId;
	int             iAkbOption,iVER_B,iVER_A,iSET_SEQ,iCHANNEL,iCOMMAND;
	int             iEXTENSION;
	int             lOption;
	short           sCmnd;

	if (!tpSendMsg) return -18506402;

	iAkbOption = tpSendMsg->msg_aopt;
	iVER_B     = iAkbOption & AKA_AKO_VER_B;
	iCHANNEL   = iAkbOption & AKA_AKO_CHANNEL;
	iEXTENSION = iAkbOption & AKA_AKO_EXTENSION;

	if (iAkbOption & AKA_AKO_COMOBJECT) {
		tpComObject = (tdtCOM_OBJECT *)lInstanceHandle;
		lInstanceHandle = tpComObject->instance_handle;
	}

	if (lInstanceHandle) {
		/* NXƃXbhm̎o */
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18506402;	/* iRc:-1 ... -4 */
		iThread  = tInstHndl.thread;
		iClassId = tInstHndl.class_id;
		tpClass  = tInstHndl.class;
		tpIns    = tInstHndl.instance;
	}
	else {
		iThread  = 1;
		iClassId = 0;
		tpClass  = NULL;
		tpIns    = NULL;
	}

	if (iEXTENSION) {
		lOption = tpSendMsg->msg_kopt;
		iVER_A   = lOption & AKA_EXO_VER_A;
		iSET_SEQ = lOption & AKA_EXO_SET_SEQ;
		iCOMMAND = lOption & AKA_EXO_COMMAND;
	}
	else {
		iVER_A = iSET_SEQ = iCOMMAND = 0;
	}

	if (iVER_B && iVER_A) return -18506419;
	if (iSET_SEQ && (iVER_A || tpSendMsg->msg_disp==0 || !iCHANNEL))
		return -18506422;

	iNullClass = 0;
	/* pPbgg */
#ifdef NO_NULL_CLASS
	if (tpSendMsg->msg_prid == 0 || tpSendMsg->msg_disp>255)
		return -18506407;
#else
	if (tpSendMsg->msg_disp>255) return -18506407;
	/* NULLNXo̓`FbN */
/*
	if (!(tpSendMsg->msg_aopt & (AKA_AKO_VER_B | AKA_AKO_CHANNEL)) &&
	    tpSendMsg->msg_clid == 0) {
*/
	if (!(iVER_B | iCHANNEL) && tpSendMsg->msg_clid == 0) {
		if (tpSendMsg->msg_hoid && tpSendMsg->msg_hoid!=tMsgCtl.host_id)
			return -18506411;
		if (tpSendMsg->msg_prid && tpSendMsg->msg_prid!=tMsgCtl.us_proc)
			return -18506412;
		if (!tpSendMsg->msg_disp) return -18506413;
	    if (iVER_A) return -18506420;
		iNullClass = 1;
	}
#endif
	if (lInstanceHandle) {
		if ((tpClass->option & AKA_RCO_NOREPLY) &&
		    tpSendMsg->msg_disp) return -18506418;
	}
#if 0	/* 2000.9.13 Koba */
	tHead.cph_prt.prt_send  = tpSendMsg->msg_form;
#else
#if 0	/* 2000.12.1 Koba */
	tHead.cph_prt.prt_send = (tpSendMsg->msg_form & AKA_PFM_INDIRECT) |
	                            AKBPFMCDTYPE(akxt_get_code_type());
#else
	tHead.cph_prt.prt_send = tpSendMsg->msg_form & AKA_PFM_INDIRECT;
#endif
#endif
	tHead.cph_prt.prt_send |= tpSendMsg->msg_form & AKA_PFM_NEED_REPLY;
#ifndef NO_AKB_PFM_PRIORITY
	tHead.cph_prt.prt_send |= tpSendMsg->msg_form & AKA_PFM_PRIORITY;
#endif
	tHead.cph_prt.prt_cmnd = htons(AKB_CMD_SEND);
	if (!(iWrk = tpSendMsg->msg_hoid)) iWrk = tMsgCtl.host_id;
	iWrk2 = tMsgCtl.host_id;
	if (!iVER_A && !iVER_B) {
		if (iEXTENSION) {
			usAPSysId = tpSendMsg->msg_apid;
			if (usAPSysId && tMsgCtl.apsys_id &&
			    usAPSysId != tMsgCtl.apsys_id) iWrk = usAPSysId;
		}
		if (tMsgCtl.apsys_id && !(iWrk & 0xffff0000))
			iWrk2 = tMsgCtl.apsys_id;
	}
	tHead.cph_dinf.ind_hoid = htonl(iWrk);
	tHead.cph_sinf.ind_hoid  = htonl(iWrk2);
	tHead.cph_sinf.ind_disp  = tpSendMsg->msg_disp;
	tHead.cph_sinf.ind_thrd  = iThread;
	if (lInstanceHandle) {
		usPacketNo = ++tpClass->packet_number;
		tHead.cph_sinf.ind_pano = htons(usPacketNo);
		if (tpComObject) tpComObject->packet_no = usPacketNo;
	}
	else {
		tHead.cph_sinf.ind_pano = 0;
	}

	if (iVER_B) {
		pHeadB = (tdtCOMM_PACK_HEADB *)&tHead;
		pHeadB->phb_prt.prt_ver       = 'B';
		pHeadB->phb_dind.inb_prid = htons(tpSendMsg->msg_prid);
		pHeadB->phb_dind.inb_pkid  = 0;
		iWrk = tMsgCtl.us_proc;
		pHeadB->phb_sind.inb_prid = htonl(iWrk);
	}
	else {
		tHead.cph_prt.prt_ver        = 'C';
		tHead.cph_dinf.ind_clid   = htons(tpSendMsg->msg_clid);
		tHead.cph_dinf.ind_prid = htons(tpSendMsg->msg_prid);
		tHead.cph_dinf.ind_thrd    = 0;
		tHead.cph_dinf.ind_disp    = tpSendMsg->msg_aopt &
		             (AKA_AKO_NOREPLY | AKA_AKO_CHANNEL | AKA_AKO_MULTI_REPLY);
		tHead.cph_dinf.ind_pano   = 0;
		tHead.cph_sinf.ind_prid  = htons(tMsgCtl.us_proc);
		if (!tHead.cph_sinf.ind_disp)
			tHead.cph_dinf.ind_disp |= AKA_AKO_NOREPLY;
		usWrk = iClassId;
		tHead.cph_sinf.ind_clid = htons(usWrk);
	}
	if (iCOMMAND) {
		sCmnd = AKA_CLASS_BASE - tpSendMsg->msg_clid;
		tHead.cph_prt.prt_cmnd    = htons(sCmnd);
		tHead.cph_dinf.ind_clid   = 0;
	}
	tHead.cph_plen = 0 ;

	pHead = &tHead;
	if (tHead.cph_dinf.ind_disp & AKA_AKO_CHANNEL) {
		iCh = ntohs(tHead.cph_dinf.ind_prid);
#ifdef DEBUG
printf("send_or_post_msg:iCh=%d\n",iCh);
#endif
		if (iCh <= 0 || iCh >= tMsgCtl.channel_used) return -18506414;
		if (!(pCh = aka_channel_get(iCh))) return -18506414;
	/*
		pCh = &tMsgCtl.channel[iCh];
	*/
		if (pCh->sd <= 0) return -18506415;
		else if (AKAGETCHUDP(pCh->status)) {
			if (AKAGETCHUDPS(pCh->status)) return -18506421;
			psa = pCh->sa;
			tHead.cph_dinf.ind_hoid   = psa->sin_addr.s_addr;
			tHead.cph_dinf.ind_clid = psa->sin_port;
/*
printf("[send_or_post_msg] UDP host=%08x port=%d iCh=%d\n",
tHead.cph_dinf.ind_hoid,tHead.cph_dinf.ind_clid,iCh);
*/
		}
		if (!(pCh->sys_opt & AKA_CHSO_USE_AKB_HEAD)) {
		/*
			if (tpSendMsg->msg_form & AKA_PFM_INDIRECT) return -18506416;
		*/
			if (tpSendMsg->msg_mlen <= 0) return -18506417;
		}
	}
	else {
		if (!(pCh = aka_channel_get(0))) return -18506414;
	/*
		pCh = &tMsgCtl.channel[0];
	*/
	/*	if (pCh->iSd <= 0) return -18506415;	*/
		if (pCh->sd < 0) return -18506415;
		if (!tHead.cph_dinf.ind_prid) {
			tHead.cph_dinf.ind_prid = htons(tMsgCtl.us_proc);
		}
		/* M`oVXehcƈقȂƂ́AvgR`ɂ */
	/*
		if (!iVER_B && iEXTENSION) {
			usAPSysId = tpSendMsg->msg_apid;
			if (usAPSysId>0 && usAPSysId != tMsgCtl.apsys_id) iVER_A = 1;
		}
	*/
		/* vgR`wb_쐬 */
		if (iVER_A) {
			if (!(usAPSysId=tpSendMsg->msg_apid))
				usAPSysId = tMsgCtl.apsys_id;
			tHead.cph_prt.prt_ver = 'A';
			akb_set_head_to_a(&tHead,&tHeadA);
			tHeadA.pha_dinf.ina_apid = htons(usAPSysId);
			tHeadA.pha_sinf.ina_apid  = htons(tMsgCtl.apsys_id);
			pHead = (tdtCOMM_PACK_HEAD *)&tHeadA;
/*
akxaxdump("SendOrPost",pHead,sizeof(tHeadA));
*/
		}
	}

	if ((iSendLen=create_pk_data(pHead,tpSendMsg,&cpPacket))<=0) {
		ERROROUTRC("send_or_post_msg:create_pk_data ret=",iSendLen);
		if (iSendLen<0) return iSendLen;
		return -18506408;
	}
#ifdef DEBUG_X
akxaxdump("send_or_post_msg.Packet",cpPacket,iSendLen);
#endif
	if (lInstanceHandle && tHead.cph_sinf.ind_disp) {
		/* ^CAEgݒ */
		if ((lmsec=aka_get_msec(&ttime))<0) return -18506409;
		if (iWaitTime < 0) iWaitTime = tMsgCtl.send_msg_time_out;
		akxe_timer_add_msec(&ttime,&ttime,iWaitTime);
#ifdef DEBUG
printf("send_or_post_msg:ttime=%d:%d\n",ttime.tv_sec,ttime.tv_usec);
#endif
#ifdef DEBUG
printf("send_or_post_msg:tMsgCtl.iSendMsgMinWait=%d iWaitTime=%d lmsec=%d\n",tMsgCtl.send_msg_min_wait,iWaitTime,lmsec);
#endif
		if (tMsgCtl.send_msg_min_wait < 0 ||
		    iWaitTime < tMsgCtl.send_msg_min_wait)
			tMsgCtl.send_msg_min_wait = iWaitTime;

		/* vpPbg\̒ǉ */
#ifdef NEW_WAITPACKET_MSEC
		if (!(tpWait=new_wait_packet(tpIns,&ttime))) return -18506410;
#else
		if (!(tpWait=new_wait_packet(tpIns))) return -18506410;
		akxe_timer_set(&tpWait->time_out,&ttime);
		if (tpIns->kind & 0x02) tpWait->status |= AKA_WMSG_FUNC2;
#endif
#ifdef DEBUG
printf("send_or_post_msg:tpWait=%08x\n",tpWait);
#endif
		/* vl\̒ǉ */
		if (tpIns->method) {
			tdtWAIT_METHOD *pWaitMethod;

			if (!(pWaitMethod=new_wait_method(tpIns))) return -18506422;
			pWaitMethod->packet_no = usPacketNo;
			pWaitMethod->method  = tpIns->method;
printf("send_or_post_msg: usPacketNo=%d tpMethod=%08x\n",
usPacketNo,pWaitMethod->method);
		}
		if (iNullClass) {
			tpWait->status |= AKA_WMSG_NULL_CLASS;
			cpWaitPacket = cpPacket;
		}
		else {
			/* WaitPacketɃRs[ */
			if (!(cpWaitPacket=Malloc(iSendLen+1))) return -18506411;
			memcpy(cpWaitPacket,cpPacket,iSendLen);
		}
		tpWait->wait_packet=cpWaitPacket;
		pHead = (tdtCOMM_PACK_HEAD *)cpWaitPacket;
		if (pHead->cph_prt.prt_ver == 'B') {
			pHead->cph_prt.prt_ver = 'C';
			if (lInstanceHandle) {
				usWrk = iClassId;
				pHead->cph_sinf.ind_clid = htons(usWrk);
			}
		}
	}
	if (iNullClass) return 0;

#if 1
	if (!(iRc = Chkset_que_and_out_put(&tHead,pCh,cpPacket,iSendLen,iSend))) {
		if (iSET_SEQ)
			iRc = aka_channel_set_seq(iCh,tpSendMsg->msg_seql,tpSendMsg->msg_seqn);
	}
	return iRc;
#else
	if (ntohl(tHead.cph_dinf.ind_hoid)     == tMsgCtl.host_id &&
	    ntohs(tHead.cph_dinf.ind_prid) == tMsgCtl.us_proc  &&
		pHead->cph_prt.prt_ver != 'A') {
		/* Read L[ɓ */
		return set_que_and_out_put(pCh,cpPacket,iSendLen,tMsgCtl.rb_rctl,0);
	}
	else {
		/* WriteL[ɓ */
		return set_que_and_out_put(pCh,cpPacket,iSendLen,tMsgCtl.rb_wctl,iSend);
	}
#endif
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_reply_msg(lInstanceHandle,tpReplyMsgCom)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpReplyMsgCom   ;	/* bZ[WԐMp\̂ւ̃|C^ */
{
	tdtCOMM_PACK_HEAD   tHead, *pHead, tHeadN;
	tdtCOMM_PACK_HEADB  *pHeadB;
	tdtCOMM_PACK_HEADA  tHeadA,*pHeadA;
	int             iThread,iClassId,iCh,iRc;
	tdtCLASS_CTL     *tpClass;
	char            *cpPacket;
	int             iSendLen;
	tdtINSTANCE     *tpIns;
	char            cver;
	tdtCHANNEL      *pCh;
	tdtINST_HNDL     tInstHndl;
	short           sCmnd,sWrk;
	int             iEXTENSION,iREGIST;
	int             iAkbOption,lOption;

	if (tMsgCtl.sd<0) return -18506501;

	if (!tpReplyMsgCom) return -18506502;

	iAkbOption = tpReplyMsgCom->msg_aopt;
	iEXTENSION = iAkbOption & AKA_AKO_EXTENSION;
	iREGIST = 0;
	if (iEXTENSION) {
		lOption = tpReplyMsgCom->msg_kopt;
		iREGIST = lOption & AKA_EXO_REGIST;
	}

	/* NXƃXbhm̎o */
	if (lInstanceHandle) {
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18506502;
		iThread  = tInstHndl.thread;
		iClassId = tInstHndl.class_id;
		tpClass  = tInstHndl.class;
		tpIns    = tInstHndl.instance;
	}
	else return -18506504;

	pHead = tpIns->pack_head;
	pHeadB = (tdtCOMM_PACK_HEADB *)tpIns->pack_head;
	cver = pHead->cph_prt.prt_ver;
	sCmnd = pHead->cph_prt.prt_cmnd;
	if (!cver) return -18506510;
	else if (cver == 'B') {
		if (!pHeadB->phb_sind.inb_pkid) return -18506507;
	}
	else {
		if (cver == 'A') {
			akb_get_head_from_a(&tHeadN,pHead);
			pHead = &tHeadN;
		}
		if (!pHead->cph_sinf.ind_disp) return -18506509;
	}

	/* pPbgg */
	tHead.cph_prt.prt_ver        = cver;
#if 0	/* 2000.9.13 Koba */
	tHead.cph_prt.prt_send  = tpReplyMsgCom->msg_form;
#else
#if 1	/* 2000.12.1 Koba */
	tHead.cph_prt.prt_send = tpReplyMsgCom->msg_form & AKA_PFM_INDIRECT;
#else
#if 1	/* 2000.11.22 Koba */
	tHead.cph_prt.prt_send  = (pHead->cph_prt.prt_send & AKB_PFM_CDTYPE) |
	                            (tpReplyMsgCom->msg_form & AKA_PFM_INDIRECT);
#else
	tHead.cph_prt.prt_send = (tpReplyMsgCom->msg_form & AKA_PFM_INDIRECT) |
	                            AKBPFMCDTYPE(akxt_get_code_type());
#endif
#endif
#endif
#ifndef NO_AKB_PFM_PRIORITY
	tHead.cph_prt.prt_send |= (tpReplyMsgCom->msg_form & AKA_PFM_PRIORITY) |
	                            (pHead->cph_prt.prt_send & AKB_PFM_PRIORITY);
#endif
	tHead.cph_prt.prt_cmnd    = sCmnd /*htons(AKB_CMD_SEND)*/;
#ifdef DEBUG_X
akxaxdump("aka_reply_msg",pHead,sizeof(tdtCOMM_PACK_HEAD));
#endif
	memcpy(&tHead.cph_dinf,&pHead->cph_sinf,sizeof(tdtINDICATE));
	memcpy(&tHead.cph_sinf,&pHead->cph_dinf,sizeof(tdtINDICATE));
	if (cver == 'C') {
#if 0	/* 2000.11.22 Koba */
		tHead.cph_sinf.ind_disp    |= tpReplyMsgCom->msg_aopt;
#else
#if 0	/* 2001.4.18 Koba */
		tHead.cph_sinf.ind_disp     = tpReplyMsgCom->msg_aopt;
#else
		tHead.cph_sinf.ind_disp =
		 (tHead.cph_sinf.ind_disp & ~(AKA_AKO_NOREPLY | AKA_AKO_MULTI_REPLY))|
		 (tpReplyMsgCom->msg_aopt & (AKA_AKO_NOREPLY | AKA_AKO_MULTI_REPLY));
#endif
#endif
/*
printf("aka_reply_msg:option=%02x\n",tHead.cph_sinf.ind_disp);
*/
		tHead.cph_sinf.ind_pano    = 0;
	}
	tHead.cph_plen = 0;
	if (!tHead.cph_sinf.ind_hoid) tHead.cph_sinf.ind_hoid = htonl(tMsgCtl.host_id);
	if (!tHead.cph_sinf.ind_prid) {
		tHead.cph_sinf.ind_prid = htons(tMsgCtl.us_proc);
	}
	if (iREGIST && !tHead.cph_dinf.ind_prid) {
		sWrk = D_PRID_TERM_BASE + aka_get_msec(NULL);
		tHead.cph_dinf.ind_prid = htons(sWrk);
	}

	pHead = &tHead;
/*
	pCh = &tMsgCtl.channel[0];
*/
	if (tHead.cph_sinf.ind_disp & AKA_AKO_CHANNEL) {
		iCh = ntohs(tHead.cph_dinf.ind_prid);
		if (iCh <= 0 || iCh >= tMsgCtl.channel_used) return -18506514;
/*
printf("aka_reply_msg:iCh=%d\n",iCh);
*/
		if (!(pCh = aka_channel_get(iCh))) return -18506514;
	/*
		pCh = &tMsgCtl.channel[iCh];
	*/
		if (pCh->sd <= 0) return -18506515;
		else if (AKAGETCHUDPC(pCh->status)) return -18506518;
		if (!(pCh->sys_opt & AKA_CHSO_USE_AKB_HEAD)) {
		/*
			if (tpReplyMsgCom->msg_form & AKA_PFM_INDIRECT) return -18506516;
		*/
			if (tpReplyMsgCom->msg_mlen <= 0) return -18506517;
		}
	/*	tHead.PrtclId.sCommand = sCmnd;	*/
	}
	else {
		if (!(pCh = aka_channel_get(0))) return -18506414;
		if (cver == 'A') {
			akb_set_head_to_a(&tHead,&tHeadA);
			pHeadA = (tdtCOMM_PACK_HEADA *)tpIns->pack_head;
			tHeadA.pha_dinf.ina_apid = pHeadA->pha_sinf.ina_apid;
			tHeadA.pha_sinf.ina_apid  = pHeadA->pha_dinf.ina_apid;
			pHead = (tdtCOMM_PACK_HEAD *)&tHeadA;
		}
	}

	if ((iSendLen=create_pk_data(pHead,tpReplyMsgCom,&cpPacket))<=0) {
		if (iSendLen<0) return iSendLen;
		return -18506508;
	}
#if 1
	return Chkset_que_and_out_put(&tHead,pCh,cpPacket,iSendLen,1);
#else
	/* Write L[ɓAbZ[Wo͂ */
	/* CX^XĂяoAɁAREPLYԂlSENDŏo͂ */
	return set_que_and_out_put(pCh,cpPacket,iSendLen,tMsgCtl.rb_wctl,1);
#endif
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_send_msg(lInstanceHandle,tpSendMsg)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg    ;	/* bZ[WMp\̂ւ̃|C^ */
{
	if (tMsgCtl.sd<0) return -18506701;

	return send_or_post_msg(lInstanceHandle,tpSendMsg,1,-1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_post_msg(lInstanceHandle,tpSendMsg)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg    ;	/* bZ[WMp\̂ւ̃|C^ */
{
	if (tMsgCtl.sd<0) return -18506801;

	return send_or_post_msg(lInstanceHandle,tpSendMsg,0,-1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_send_msg_wait_time(lInstanceHandle,tpSendMsg,iWaitTime)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpSendMsg    ;	/* bZ[WMp\̂ւ̃|C^ */
int        iWaitTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	if (tMsgCtl.sd<0) return -18506901;

	return send_or_post_msg(lInstanceHandle,tpSendMsg,1,iWaitTime);
}

#ifdef NEW_WAITPACKET_MSEC
/********************************************************/
/*                                                      */
/********************************************************/
static tdtWAIT_PACKET *new_wait_packet(tpIns, ptval)
tdtINSTANCE *tpIns;
struct timeval *ptval;
{
	tdtWAIT_PACKET *tpWait,*tpNext,*tpNew;
	char *cpWaitPacket;

#ifdef DEBUG
printf("new_wait_packet: ttime=%d:%d\n",ptval->tv_sec,ptval->tv_usec);
#endif
	/* ^CAEg傫̂T */
	tpWait = NULL;
	tpNext = tpIns->wait_next;
	while (tpNext) {
#ifdef DEBUG
printf("new_wait_packet: tTimeOut=%d:%d\n",
tpNext->time_out.tv_sec,tpNext->time_out.tv_usec);
#endif
		if (timercmp(&tpNext->time_out,ptval,>) break;
		tpWait = tpNext;
		tpNext = tpNext->wait_next;
	}

	/* V\̂쐬 */
	if (!(tpNew=(tdtWAIT_PACKET *)Malloc(sizeof(tdtWAIT_PACKET)))) return NULL;
	memset(tpWait,0,sizeof(tdtWAIT_PACKET));
	akxe_timer_set(&tpNew->time_out,ptval);
/*
	tpNew->wait_packet = NULL;
	tpNew->status      = 0;
*/

	/* V\̂XgɂȂ */
	tpNew->wait_next = tpNext;
	if (tpWait) tpWait->wait_next = tpNew;
	else        tpIns->wait_next = tpNew;
	
	return tpNew;
}

#else
/********************************************************/
/*                                                      */
/********************************************************/
static tdtWAIT_PACKET *new_wait_packet(tpIns)
tdtINSTANCE *tpIns;
{
	tdtWAIT_PACKET *tpWait,*tpNext;
	char *cpWaitPacket;

	/* Xg̖T */
	tpWait = tpIns->wait_next;
	while (tpWait) {
		tpNext = tpWait;
		tpWait = tpNext->wait_next;
	}

	/* V\̂쐬 */
	if (!(tpWait=(tdtWAIT_PACKET *)Malloc(sizeof(tdtWAIT_PACKET)))) return NULL;
	memset(tpWait,0,sizeof(tdtWAIT_PACKET));
/*
	tpWait->wait_next = NULL;
	timerclear(&tpWait->time_out);
	tpWait->status    = 0;
*/

	/* V\̂Xg̖ɂȂ */
	if (tpIns->wait_next) tpNext->wait_next = tpWait;
	else                   tpIns->wait_next  = tpWait;
	
	return tpWait;
}
#endif

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_sleep(lInstanceHandle,iDisposition,iSleepTime)
long lInstanceHandle;	/* CX^Xʔԍ */
int  iDisposition;
int  iSleepTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	AKAMSGCOM tSendMsg;

	if (tMsgCtl.sd<0) return -18507001;

	memset(&tSendMsg,0,sizeof(AKAMSGCOM));
	tSendMsg.msg_disp = iDisposition;
	return aka_send_msg_wait_time(lInstanceHandle,&tSendMsg,iSleepTime);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_leave_msg(lInstanceHandle,tpLeaveMsg)
long       lInstanceHandle;	/* CX^Xʔԍ */
AKAMSGCOM *tpLeaveMsg;		/* bZ[WԐMp\̂ւ̃|C^ */
{
	tdtCOMM_PACK_HEAD   tHead, *pHead, tHeadN;
	tdtCOMM_PACK_HEADB  *pHeadB;
	tdtCOMM_PACK_HEADA  tHeadA,*pHeadA;
	int             iThread,iClassId,iCh,iRc;
	tdtCLASS_CTL     *tpClass;
	char            *cpPacket;
	int             iSendLen;
	INT4            lWrk,lWrk2;
	tdtINSTANCE     *tpIns;
	char            cver;
	tdtCHANNEL      *pCh;
	ushort          usWrk;
	tdtINST_HNDL     tInstHndl;
	struct sockaddr_in *psa;
	ushort          usAPSysId,usSrcAPSysId;
	int             iAkbOption,iVER_A,iVER_B,iEXTENSION;
	long            lOption;

	if (tMsgCtl.sd<0) return -18507101;

	if (!tpLeaveMsg) return -18507102;

	/* NXƃXbhm̎o */
	if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
		return iRc - 18507102;	/* iRc:-1 ... -4 */
	iThread  = tInstHndl.thread;
	iClassId = tInstHndl.class_id;
	tpClass  = tInstHndl.class;
	tpIns    = tInstHndl.instance;

	pHead = tpIns->pack_head;
	pHeadB = (tdtCOMM_PACK_HEADB *)pHead;
	cver = pHead->cph_prt.prt_ver;

	if (cver == 'A') {
		pHeadA = (tdtCOMM_PACK_HEADA *)pHead;
		usSrcAPSysId = ntohs(pHeadA->pha_sinf.ina_apid);
		akb_get_head_from_a(&tHeadN,pHead);
		pHead = &tHeadN;
	}

	iAkbOption = tpLeaveMsg->msg_aopt;
	iVER_B     = iAkbOption & AKA_AKO_VER_B;
	iEXTENSION = iAkbOption & AKA_AKO_EXTENSION;

	if (iAkbOption & AKA_AKO_LEAVE) {
		if (pHead->cph_dinf.ind_disp & AKB_AKO_LEAVE) return -18507107;
	}

	if (iEXTENSION) {
		iVER_A = tpLeaveMsg->msg_kopt & AKA_EXO_VER_A;
		usAPSysId = tpLeaveMsg->msg_apid;
	}
	else {
		iVER_A = 0;
	}

	/* pPbgg */
	tHead.cph_prt.prt_ver        = cver;
#if 0	/* 2000.11.22 Koba */
	tHead.cph_prt.prt_send  = tpLeaveMsg->msg_form;
#else
#if 1	/* 2000.12.1 Koba */
	tHead.cph_prt.prt_send = tpLeaveMsg->msg_form & AKA_PFM_INDIRECT;
#else
#if 0	/* 2000.11.22 Koba */
	tHead.cph_prt.prt_send  = (tHead.cph_prt.prt_send & AKB_PFM_CDTYPE) |
	                            (tpLeaveMsg->msg_form & AKA_PFM_INDIRECT);
#else
	tHead.cph_prt.prt_send = (tpLeaveMsg->msg_form & AKA_PFM_INDIRECT) |
	                            AKBPFMCDTYPE(akxt_get_code_type());
#endif
#endif
#endif
	tHead.cph_prt.prt_cmnd    = htons(AKB_CMD_SEND);
	memcpy(&tHead.cph_dinf,&pHead->cph_dinf,sizeof(tdtINDICATE));
	memcpy(&tHead.cph_sinf,&pHead->cph_sinf,sizeof(tdtINDICATE));
	if (!(lWrk = tpLeaveMsg->msg_hoid)) lWrk = tMsgCtl.host_id;
	lWrk2 = ntohl(tHead.cph_sinf.ind_hoid);
	if (!(lWrk2 & 0xffff0000) && !iVER_A && !iVER_B && iEXTENSION) {
		if (usAPSysId && tMsgCtl.apsys_id &&
		    usAPSysId != tMsgCtl.apsys_id) lWrk = usAPSysId;
	}
	tHead.cph_dinf.ind_hoid = htonl(lWrk);
	if (cver == 'B') {
		pHeadB = (tdtCOMM_PACK_HEADB *)&tHead;
		pHeadB->phb_dind.inb_prid = htons(tpLeaveMsg->msg_prid);
		pHeadB->phb_dind.inb_pkid  = 0;
	}
	else {
		tHead.cph_dinf.ind_clid   = htons(tpLeaveMsg->msg_clid);
		tHead.cph_dinf.ind_prid = htons(tpLeaveMsg->msg_prid);
		tHead.cph_dinf.ind_thrd    = 0;
		tHead.cph_dinf.ind_disp    = (tpLeaveMsg->msg_aopt &
		                             (AKA_AKO_NOREPLY | AKA_AKO_CHANNEL |
		                              AKA_AKO_MULTI_REPLY)) |
		                            AKB_AKO_LEAVE;
		tHead.cph_dinf.ind_pano   = 0;
	}
#ifdef DEBUG_X
akxaxdump("aka_leave_msg",pHead,sizeof(tdtCOMM_PACK_HEAD));
#endif
	tHead.cph_plen = 0 ;

	pHead = &tHead;
	if (tHead.cph_dinf.ind_disp & AKA_AKO_CHANNEL) {
	/*
		if (tpLeaveMsg->msg_form & AKA_PFM_INDIRECT) return -18506716;
	*/
		iCh = ntohs(tHead.cph_dinf.ind_prid);
		if (iCh <= 0 || iCh >= tMsgCtl.channel_used) return -18507114;
		if (!(pCh = aka_channel_get(iCh))) return -18507114;
	/*
		pCh = &tMsgCtl.channel[iCh];
	*/
		if (pCh->sd <= 0) return -18507115;
	/*	else if (psa=pCh->sa) {	*/
		else if (AKAGETCHUDP(pCh->status)) {
			if (AKAGETCHUDPS(pCh->status)) return -18507121;
			psa = pCh->sa;
			tHead.cph_dinf.ind_hoid   = psa->sin_addr.s_addr;
			tHead.cph_dinf.ind_clid = psa->sin_port;
/*
printf("[aka_leave_msg] UDP host=%08x port=%d iCh=%d\n",
tHead.cph_dinf.ind_hoid,tHead.cph_dinf.ind_clid,iCh);
*/
		}
	}
	else {
		if (!(pCh = aka_channel_get(0))) return -18507114;
	/*
		pCh = &tMsgCtl.channel[0];
	*/
		if (!tHead.cph_dinf.ind_prid) {
			tHead.cph_dinf.ind_prid = htons(tMsgCtl.us_proc);
		}
		/* M`oVXehcƈقȂƂ́AvgR`ɂ */
	/*
		if (!iVER_B && iEXTENSION) {
			if (usAPSysId>0 && usAPSysId != tMsgCtl.apsys_id) iVER_A = 1;
		}
	*/
		/* vgR`wb_쐬 */
		if (cver=='A' || iVER_A) {
			tHead.cph_prt.prt_ver = 'A';
			akb_set_head_to_a(&tHead,&tHeadA);
			tHeadA.pha_dinf.ina_apid = htons(usAPSysId);
			tHeadA.pha_sinf.ina_apid  = htons(usSrcAPSysId);
			pHead = (tdtCOMM_PACK_HEAD *)&tHeadA;
		}
	}

	if ((iSendLen=create_pk_data(pHead,tpLeaveMsg,&cpPacket))<=0) {
		if (iSendLen<0) return iSendLen;
		return -18507108;
	}
#if 1
	return Chkset_que_and_out_put(&tHead,pCh,cpPacket,iSendLen,1);
#else
	/* Write L[ɓAbZ[Wo͂ */
	return set_que_and_out_put(pCh,cpPacket,iSendLen,tMsgCtl.rb_wctl,1);
#endif
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_recv_msg(lInstanceHandle,tpComObject,iWaitTime,iOptions)
long           lInstanceHandle;
tdtCOM_OBJECT  *tpComObject;
int            iWaitTime;	/* msec */
int            iOptions;	/* 0/1/2 */
{
	struct timeval tmtime;
	uchar  ucStatus;
	int    iRc;
	char   *p;
	tdtRB_CTL *pRbTmp;
/*
	AKAMSGCOM *tpRecvMsg;
*/

	if (tMsgCtl.sd<0) return -18507301;
	if (!tpComObject) return -18507302;
	if (iOptions < 0 || iOptions > 2) return -18507306;

	tpComObject->options    = iOptions;
	tpComObject->recv_ins_hnd = lInstanceHandle;

	/* ^C}̕ۑƃNA */
	akxe_timer_set(&tmtime, &tMsgCtl.get_msg_time_out);
	ucStatus = tMsgCtl.rsv1;
	timerclear(&tMsgCtl.get_msg_time_out);
	tMsgCtl.rsv1 = 0;

	if (iWaitTime < 0) iWaitTime = tMsgCtl.send_msg_time_out;
	iWaitTime /= 100;	/* msec --> 1/10sec */

	/* Iv܂Ń[v */
	while ((iRc=aka_get_msg(iWaitTime)) > 0) {
		if (iRc=aka_dispatch_recv_msg(tpComObject)) break;
	}
	if (iRc == AKB_CMD_RECVMSG) {
		iRc = 0;
	/*
		tpRecvMsg = tpComObject->recv_ins->recv_msg_com;
		iRc = tpRecvMsg->msg_pret;
	*/
	}
	else if (!iRc) iRc = PACKET_TIMEOUT_ERROR;

	/* ^C}̕ */
	akxe_timer_set(&tMsgCtl.get_msg_time_out, &tmtime);
	tMsgCtl.rsv1 = ucStatus;

	while (p=akxs_rb_get_n(tMsgCtl.rb_rctl)) akxs_rb_set_n(tMsgCtl.rb_dwctl,p);
	pRbTmp = tMsgCtl.rb_rctl;
	tMsgCtl.rb_rctl = tMsgCtl.rb_dwctl;
	tMsgCtl.rb_dwctl = pRbTmp;

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_new_com_object(lInstanceHandle, tppComObject)
long  lInstanceHandle;
tdtCOM_OBJECT **tppComObject;
{
	int iRc;
	tdtINSTANCE     *tpIns=NULL;
	tdtINSTANCE     *tpInsn=NULL;
	tdtCOM_OBJECT    *p=NULL;
	tdtINST_HNDL     tInstHndl;

	if (tppComObject) *tppComObject = NULL;
	else return -18507402;

	if (tMsgCtl.sd<0) return -18507401;

	if (lInstanceHandle) {
		/* NXƃXbhm̎o */
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18507402;
		tpIns    = tInstHndl.instance;
	}

	if (!(p=(tdtCOM_OBJECT *)Malloc(sizeof(tdtCOM_OBJECT)))) {
		return -18507407;
	}
	if (!(tpInsn = (tdtINSTANCE *)Malloc(sizeof(tdtINSTANCE)))) {
		Free(p);
		return -18507408;
	}
	if (iRc = aka_instance_init(0, tpInsn, 0)) {
		aka_instance_buf_free(tpInsn);
		Free(tpInsn);
		Free(p);
		return iRc;
	}
	if (tpIns) {
		if (!tpIns->rb_com_object) {
			if (!(tpIns->rb_com_object = akxs_rb_init(0,0))) {
				aka_instance_buf_free(tpInsn);
				Free(tpInsn);
				Free(p);
				return -18507409;
			}
		}
		akxs_rb_set_n(tpIns->rb_com_object,p);
/*
printf("NewComObject:tpIns=%08x, pRbComObject=%08x, p=%08x\n",
tpIns,tpIns->rb_com_object,p);
*/
	}
	memset(p,0,sizeof(tdtCOM_OBJECT));
	p->instance_handle = lInstanceHandle;
	p->recv_ins = tpInsn;
	*tppComObject = p;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_free_com_object_sub(tpComObject, iopt)
tdtCOM_OBJECT *tpComObject;
int iopt;
{
	long  lInstanceHandle;
	int   iRc;
	tdtINSTANCE *tpIns;
	char *p;
	tdtRB_CTL  *pRbW;
	tdtINST_HNDL tInstHndl;

	if (!tpComObject) return -18507502;
	if (tMsgCtl.sd<0) return -18507501;

	lInstanceHandle = tpComObject->instance_handle;
	if (iopt && lInstanceHandle) {
		/* NXƃXbhm̎o */
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18507502;
		tpIns    = tInstHndl.instance;
		if (tpIns->rb_com_object) {
			pRbW = akxs_rb_init(0,0);
			while (p = akxs_rb_get_n(tpIns->rb_com_object)) {
				if (p != (char *)tpComObject) akxs_rb_set_n(pRbW,p);
			}
			akxs_rb_free(tpIns->rb_com_object);
			tpIns->rb_com_object = pRbW;
		}
	}
	aka_instance_buf_free(tpComObject->recv_ins);
	Free(tpComObject->recv_ins);
	if (tpComObject->to_free) Free(tpComObject->to_free);
	Free(tpComObject);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_free_com_object(tpComObject)
tdtCOM_OBJECT *tpComObject;
{
	return aka_free_com_object_sub(tpComObject, 1);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_post_msgWaitTime(lInstanceHandle,tpPostMsgCom,iWaitTime)
long       lInstanceHandle ;	/* CX^Xʔԍ */
AKAMSGCOM *tpPostMsgCom    ;	/* bZ[WMp\̂ւ̃|C^ */
int        iWaitTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	if (tMsgCtl.sd<0) return -18507701;

	return send_or_post_msg(lInstanceHandle,tpPostMsgCom,0,iWaitTime);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_sleep(lInstanceHandle,iSleepTime)
long lInstanceHandle;	/* CX^Xʔԍ */
int  iSleepTime;	/* >=0 :bZ[W̃^CAEg(msec) */
{
	AKAMSGCOM tSendMsg;
	tdtCOM_OBJECT *tpComObject;
	int iRc;

	if (tMsgCtl.sd<0) return -18507801;

	iRc = aka_new_com_object(lInstanceHandle, &tpComObject);
	if (iRc) return iRc;

	memset(&tSendMsg,0,sizeof(AKAMSGCOM));
	tSendMsg.msg_disp = 255;
	tSendMsg.msg_aopt   = AKA_AKO_COMOBJECT;
	iRc = aka_send_msg_wait_time(tpComObject,&tSendMsg,iSleepTime);
	if (iRc) return iRc;

	iRc = aka_recv_msg(lInstanceHandle,tpComObject,iSleepTime*2,0);
	if (iRc == PACKET_TIMEOUT_ERROR) iRc = 0;

	aka_free_com_object(tpComObject);

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_inst_comment(lInstanceHandle, cpText)
long  lInstanceHandle;
char  *cpText;
{
	int iRc;
	tdtINSTANCE *tpIns;
	tdtINST_HNDL tInstHndl;
	char *p;

	if (tMsgCtl.sd<0) return -18508101;

	if (lInstanceHandle) {
		/* NXƃXbhm̎o */
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18508102;
		if (tpIns = tInstHndl.instance) {
			if (cpText) {
				if (!(p = Strdup(cpText))) return -18508109;
			}
			else p = NULL;

			if (tpIns->comment) Free(tpIns->comment);
			tpIns->comment = p;
		}
		else return -18508108;
	}
	else return -18508107;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_inst_comment(lInstanceHandle, cppText)
long  lInstanceHandle;
char  **cppText;
{
	int iRc;
	tdtINSTANCE *tpIns;
	tdtINST_HNDL tInstHndl;
	char *p;

	if (!cppText) return -18508209;
	*cppText = NULL;
	if (tMsgCtl.sd<0) return -18508201;

	if (lInstanceHandle) {
		/* NXƃXbhm̎o */
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18508202;
		if (tpIns = tInstHndl.instance) {
			*cppText = tpIns->comment;
		}
		else return -18508208;
	}
	else return -18508107;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static tdtWAIT_METHOD *new_wait_method(tpIns)
tdtINSTANCE *tpIns;
{
	tdtWAIT_METHOD *tpWait,*tpNext;

	/* Xg̖T */
	tpWait = tpIns->wait_method;
	while (tpWait) {
		if (!tpWait->packet_no) break;
		tpNext = tpWait;
		tpWait = tpNext->wait_method;
	}
	if (tpWait) {
		tpNext = tpWait->wait_method;
		memset(tpWait,0,sizeof(tdtWAIT_METHOD));
		tpWait->wait_method = tpNext;
	}
	else {
		/* V\̂쐬 */
		if (!(tpWait=(tdtWAIT_METHOD *)Malloc(sizeof(tdtWAIT_METHOD))))
			return NULL;
		memset(tpWait,0,sizeof(tdtWAIT_METHOD));

		/* V\̂Xg̖ɂȂ */
		if (tpIns->wait_method) tpNext->wait_method  = tpWait;
		else                     tpIns->wait_method = tpWait;
	}
	return tpWait;
}
