static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************
*   : fZ												*
*   : int cl_cmpt_complex											*
*   : (O)tdtInfoParm *pInfoParmW :									*
*         (I)char        *pOprtr     :									*
*         (I)tdtInfoParm *pInfoParm1 :									*
*         (I)tdtInfoParm *pInfoParm2 :									*
*  ԋp : ERROR															*
*         NORMAL														*
*************************************************************************/
/********************************************/
/*	  coded by A.Kobayashi() 2022.07.01		*/
/*	  error code : -215250101`-215259999	*/
/********************************************/
/* 01- cl_xxxx	*/
/* 21- + - * /	*/
/* 31- **		*/
/* 41- abs		*/
/* 61- common	*/
#include <colmn.h>

extern GlobalCt  *pGlobTable;
extern int giOptions[];

/****************************************/
/*	61									*/
/****************************************/
int _is_1(pInfoParm)
tdtInfoParm	*pInfoParm;
{
	long lVal;
	int ret,atr;
	char *dat;
	double dVal;
	MPA *mpa,*mpa1;

	ret = 0;
	atr = pInfoParm->pi_attr;
	dat = pInfoParm->pi_data;
	if (atr == DEF_ZOK_BINA) {
		memcpy(&lVal,dat,sizeof(long));
		if (lVal == 1) ret = 1;
	}
	else if (atr == DEF_ZOK_FLOA) {
		memcpy(&dVal,dat,sizeof(double));
		if (dVal == 1.0) ret = 1;
	}
	else if (atr == DEF_ZOK_DECI) {
		mpa = (MPA *)dat;
		mpa1 = m_get_i(1);
		if (!m_cmp(mpa,mpa1)) ret = 1;
	}
	return ret;
}

/****************************************/
/*	62									*/
/****************************************/
int _set_complex(pComplex,pInfoParm1)
tdtInfoParm *pComplex,*pInfoParm1;
{
	tdtInfoParm	*pm[2],tInfoParm,*pInfo;

	pInfo = &tInfoParm;
	cl_set_parm_long(pInfo,0);
	if (pInfoParm1->pi_scale & D_DATA_IMAGE) {
		pm[0] = pInfo;
		pm[1] = pInfoParm1;
	}
	else {
		pm[0] = pInfoParm1;
		pm[1] = pInfo;
		pInfo->pi_scale |= D_DATA_IMAGE;
	}
	return cl_gx_range_set(pComplex,2,pm,0);
}

/****************************************/
/*	42									*/
/****************************************/
static int _abs_bouble(pInfoR,pInfoI,dVala)
tdtInfoParm	*pInfoR,*pInfoI;
double dVala[];
{
	double dVal1,dVal2;
	int ret;

	if ((ret=cl_get_parm_double_opt(pInfoR,&dVal1,"_complex_abs1",0)) < 0) return ret;
	if ((ret=cl_get_parm_double_opt(pInfoI,&dVal2,"_complex_abs2",0)) < 0) return ret;
	dVala[1] = dVal1;
	dVala[2] = dVal2;
	/* dVal1=1e300, dVal2=1e300 ̂ƂłI[o[t[A1.4142`e300 Ԃ */
	dVala[0] = sqrt(dVal1*dVal1 + dVal2*dVal2);
	return 0;
}
/****************************************/
/*	41									*/
/****************************************/
static int _complex_abs_bouble(pInfoParmW,pInfoR,pInfoI)
tdtInfoParm	*pInfoParmW,*pInfoR,*pInfoI;
{
#if 1
	double dVala[3];
	int ret;

	if ((ret=_abs_bouble(pInfoR,pInfoI,dVala)) < 0) return ret;
	cl_set_parm_double(pInfoParmW,dVala[0]);
#else
	double dVal1,dVal2;
	int ret;

	if ((ret=cl_get_parm_double_opt(pInfoR,&dVal1,"_complex_abs1",0)) < 0) return ret;
	if ((ret=cl_get_parm_double_opt(pInfoI,&dVal2,"_complex_abs2",0)) < 0) return ret;
	/* dVal1=1e300, dVal2=1e300 ̂ƂłI[o[t[A1.4142`e300 Ԃ */
	dVal1 = sqrt(dVal1*dVal1 + dVal2*dVal2);
	cl_set_parm_double(pInfoParmW,dVal1);
#endif
	return ret;
}

/****************************************/
/*	22									*/
/****************************************/
static int _inner_product(pInfoParmW,pInfoR,pInfoI)
tdtInfoParm	*pInfoParmW,*pInfoR,*pInfoI;
{
	int ret;

	tdtInfoParm	tInfoW1,tInfoW2;

	if ((ret=cl_cmpt_math_real(&tInfoW1,"*",pInfoR,pInfoR)) < 0) return ret;
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_inner_product: Enter tInfoW1=",&tInfoW1,0,0);
*/
	if ((ret=cl_cmpt_math_real(&tInfoW2,"*",pInfoI,pInfoI)) < 0) return ret;
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_inner_product: Enter tInfoW2=",&tInfoW2,0,0);
*/
	ret = cl_cmpt_math_real(pInfoParmW,"+",&tInfoW1,&tInfoW2);
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_inner_product: Enter pInfoParmW=",pInfoParmW,0,0);
*/
	return ret;
}

/****************************************/
/*	23									*/
/****************************************/
static int _complex_mul(pCmplxR,pCmplxI,pInfoR1,pInfoI1,pInfoR2,pInfoI2)
tdtInfoParm *pCmplxR,*pCmplxI,*pInfoR1,*pInfoI1,*pInfoR2,*pInfoI2;
{
	tdtInfoParm tInfoW1,tInfoW2,tInfoWR,*pInfoWR,tInfoWI,*pInfoWI;
	int ret;

	/*  */
	pInfoWR = &tInfoWR;	/* pCmplxR==pInfoR1 or pCmplxR==pInfoR2 Ή */
	if ((ret=cl_cmpt_math_real(&tInfoW1,"*",pInfoR1,pInfoR2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(&tInfoW2,"*",pInfoI1,pInfoI2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(pInfoWR,"-",&tInfoW1,&tInfoW2)) < 0) return ret;
	/*  */
	pInfoWI = &tInfoWI;	/* pCmplxI==pInfoI1 or pCmplxI==pInfoI2 Ή(́AȂĂǂ) */
	if ((ret=cl_cmpt_math_real(&tInfoW1,"*",pInfoR1,pInfoI2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(&tInfoW2,"*",pInfoI1,pInfoR2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(pInfoWI,"+",&tInfoW1,&tInfoW2)) < 0) return ret;
	/* ԋp */
	cl_gx_copy_info(pCmplxR,pInfoWR);
	cl_gx_copy_info(pCmplxI,pInfoWI);

	return 0;
}

/****************************************/
/*	24									*/
/****************************************/
static int _complex_div(pCmplxR,pCmplxI,pInfoR1,pInfoI1,pInfoR2,pInfoI2)
tdtInfoParm *pCmplxR,*pCmplxI,*pInfoR1,*pInfoI1,*pInfoR2,*pInfoI2;
{
	tdtInfoParm tInfoA,tInfoW1,tInfoW2,tInfoW3,tInfoWR,*pInfoA,*pInfoWR,tInfoWI,*pInfoWI;
	int ret,atrA,atr;
	double dVal;

	/*  */
	pInfoA = &tInfoA;
	if ((ret=_inner_product(pInfoA,pInfoR2,pInfoI2)) < 0) return ret;
	/*  */
	pInfoWR = &tInfoWR;	/* pCmplxR==pInfoR1 or pCmplxR==pInfoR2 Ή */
	if ((ret=cl_cmpt_math_real(&tInfoW1,"*",pInfoR1,pInfoR2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(&tInfoW2,"*",pInfoI1,pInfoI2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(&tInfoW3,"+",&tInfoW1,&tInfoW2)) < 0) return ret;
	if (pInfoA->pi_attr==DEF_ZOK_BINA && tInfoW3.pi_attr == DEF_ZOK_BINA) {
		dVal = cl_get_data_long(pInfoA);
		cl_set_parm_double(pInfoA,dVal);
	}
	if ((ret=cl_cmpt_math_real(pInfoWR,"/",&tInfoW3,pInfoA)) < 0) return ret;
	/*  */
	pInfoWI = &tInfoWI;	/* pCmplxI==pInfoI1 or pCmplxI==pInfoI2 Ή(́AȂĂǂ) */
	if ((ret=cl_cmpt_math_real(&tInfoW1,"*",pInfoI1,pInfoR2)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(&tInfoW2,"*",pInfoI2,pInfoR1)) < 0) return ret;
	if ((ret=cl_cmpt_math_real(&tInfoW3,"-",&tInfoW1,&tInfoW2)) < 0) return ret;
/*
	if (pInfoA->pi_attr==DEF_ZOK_BINA && tInfoW3.pi_attr == DEF_ZOK_BINA) {
		dVal = cl_get_data_long(pInfoA);
		cl_set_parm_double(pInfoA,dVal);
	}
*/
	if ((ret=cl_cmpt_math_real(pInfoWI,"/",&tInfoW3,pInfoA)) < 0) return ret;
	/* ԋp */
	cl_gx_copy_info(pCmplxR,pInfoWR);
	cl_gx_copy_info(pCmplxI,pInfoWI);
	return 0;
}

/****************************************/
/*	32									*/
/****************************************/
static int _complex_power_real(pInfoParmW,pInfoC,pInfoR)
tdtInfoParm	*pInfoParmW,*pInfoC,*pInfoR;
{
	int ret,i,lVal,iVal[2];
	double dVal1,dVal2,dVala[3],dValR,dValI,x;
	tdtInfoParm	tInfo,tInfoR,tInfoI,*ppParm[3],tCmplx[2];
	tdtInfoParm *pCmplxR,*pCmplxI,*pInfoR1,*pInfoI1,*pInfoR2,*pInfoI2;

	if (_is_1(pInfoR)) {
		cl_gx_copy_info(pInfoParmW,pInfoC);
		return 0;
	}
	ppParm[0] = &tInfoR;
	ppParm[1] = &tInfoI;
	ppParm[2] = &tInfo;
	if ((ret=cl_get_range_info(pInfoC,ppParm,iVal,0)) < 0) return ret;
	ret = 0;
	if (pInfoR->pi_attr == DEF_ZOK_BINA) {
		lVal = cl_get_data_long(pInfoR);
/*
printf("_complex_power_real: lVal=%d\n",lVal);
*/
		if (lVal <= 20) {
			pInfoR1 = ppParm[0];
			pInfoI1 = ppParm[1];
			pCmplxR = &tCmplx[0];
			pCmplxI = &tCmplx[1];
			cl_gx_copy_info(pCmplxR,pInfoR1);
			cl_gx_copy_info(pCmplxI,pInfoI1);
			for (i=1;i<lVal;i++) {
				if ((ret=_complex_mul(pCmplxR,pCmplxI,pCmplxR,pCmplxI,pInfoR1,pInfoI1)) < 0) return ret;
			}
			ppParm[0] = pCmplxR;
			ppParm[1] = pCmplxI;
			ret = 1;
		}
		else dVal2 = lVal;
	}
	else {
		if ((ret=cl_get_parm_double_opt(pInfoR,&dVal2,"_complex_power_real",0)) < 0) return ret;
		ret = 0;
	}
	if (!ret) {
		if ((ret=_abs_bouble(ppParm[0],ppParm[1],dVala)) < 0) return ret;
		dVal1 = dVala[0];
		dValR = dVala[1];
		dValI = dVala[2];
		dValR /= dVal1;
		dValI /= dVal1;
		if (dValR > dValI) x = asin(dValI);
		else x = acos(dValR);
		x *= dVal2;
		dVal1 = pow(dVal1,dVal2);
		dValR = dVal1 * cos(x);
		dValI = dVal1 * sin(x);
		pCmplxR = ppParm[0];
		pCmplxI = ppParm[1];
		cl_set_parm_double(pCmplxR,dValR);
		cl_set_parm_double(pCmplxI,dValI);
	}
	/* f */
/*
	ppParm[0] = pCmplxR;
	ppParm[1] = pCmplxI;
*/
	ppParm[1]->pi_scale |= D_DATA_IMAGE;
	if (cl_adjust_complex(pInfoParmW,ppParm[0],ppParm[1])) ret = 0;
	else ret = cl_gx_range_set(pInfoParmW,2,ppParm,0);
	return ret;
}

/****************************************/
/*	31	** p							*/
/****************************************/
static int _complex_power(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtInfoParm *pInfoParmW;
char *pOperator;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
{
	tdtInfoParm tComplex;
	int ret,iParm[5],iCOMPLEX1,iCOMPLEX2,iIMAGE1,iIMAGE2;
	long lValz[NMPA_LONG],*lVal,lValue;
	char op;

	iCOMPLEX1 = pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA;
	iCOMPLEX2 = pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA;
/*
printf("_complex_power: iCOMPLEX1=%d iCOMPLEX2=%d\n",iCOMPLEX1,iCOMPLEX2);
*/
	if (iCOMPLEX1 || iCOMPLEX2) {	/*  */
		if (iCOMPLEX1 && iCOMPLEX2) {	/* (a+bi)**(c+di) */
			ret = -215253196;
		}
		else if (iCOMPLEX1) {	/* (a+bi)**fȊO */
			iIMAGE2 = pInfoParm2->pi_scale & D_DATA_IMAGE;
			if (iIMAGE2) {	/* (a+bi)** */
				ret = -215253191;
			}
			else {	/* (a+bi)** */
				if (cl_is_zero(pInfoParm2)) return cl_set_parm_long(pInfoParmW,1);
			/*	ret = -215253192;	*/
				ret = _complex_power_real(pInfoParmW,pInfoParm1,pInfoParm2);
			}
		}
		else {	/* fȊO**(c+di) */
			iIMAGE1 = pInfoParm1->pi_scale & D_DATA_IMAGE;
			ret = -215253193;
		}
	}
	else {	/* fȊO**fȊO */
		iIMAGE2 = pInfoParm2->pi_scale & D_DATA_IMAGE;
		if (iIMAGE2) {	/* fȊO** */
			ret = -215253194;
		}
		else {	/* fȊO** */
			if (cl_is_zero(pInfoParm2)) return cl_set_parm_long(pInfoParmW,1);
			lVal = cl_get_tmpMPA(lValz);
			iParm[0] = 0;
			if ((ret=cl_get_parm_mpa_opt(pInfoParm2,lVal,"cl_cmpt_math_info(**)",iParm,0)) < 0) return ret;
			if (iParm[0] == DEF_ZOK_BINA) {	/* fȊO** */
				lValue = CL_GET_VAL_BIN(lVal);
				if ((ret=cl_cmpt_math(lVal,pOperator,pInfoParm1,pInfoParm2,iParm)) >= 0) {
					ret=cl_set_parm(pInfoParmW,lVal,0,iParm);
					lValue %= 4;
					if (lValue == 0) ;
					else if (lValue == 1) pInfoParmW->pi_scale |= D_DATA_IMAGE;
					else if (lValue == 2) cl_sign_reverse(pInfoParmW);
					else if (lValue == 3) {
						pInfoParmW->pi_scale |= D_DATA_IMAGE;
						cl_sign_reverse(pInfoParmW);
					}
				}
			}
			else {	/* fȊO**ȊO */
			/*	ret = -215253195;	*/
				_set_complex(&tComplex,pInfoParm1);
				ret = _complex_power_real(pInfoParmW,&tComplex,pInfoParm2);
			}
		}
	}
	return ret;
}

/****************************************/
/*	21									*/
/****************************************/
static int _cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtInfoParm *pInfoParmW;
char *pOperator;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
{
	tdtInfoParm *pComplex,tInfo,*ppParm[3],tCmplx[2];
	tdtInfoParm *pInfo1,*pInfo2,tCmplx1,tCmplx2;
	tdtInfoParm tInfoW1,tInfoW2,tInfoW3,tInfoA;
	tdtInfoParm tInfoR1,tInfoI1,tInfoR2,tInfoI2;
	long lValrz[NMPA_LONG],*lValr,lValiz[NMPA_LONG],*lVali;
	int ret,iVal[2],iParm[5],iCOMPLEX1,iCOMPLEX2,iIMAGE1,iIMAGE2;
	char op;

	if (!strcmp(pOperator,"**")) {
		/* ** ͂Ŏs */
		return _complex_power(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
	}

	iCOMPLEX1 = pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA;
	iCOMPLEX2 = pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA;
	op = *pOperator;
	pInfo1 = pInfoParm1;
	pInfo2 = pInfoParm2;
	if (!iCOMPLEX1) {
		pComplex = &tCmplx1;
		if ((ret=_set_complex(pComplex,pInfoParm1)) < 0) return ret;
		pInfo1 = pComplex;
	}
	if (pInfoParm1 == pInfoParm2)
		pInfo2 = pInfo1;
	else {
		if (!iCOMPLEX2) {
			pComplex = &tCmplx2;
			if ((ret=_set_complex(pComplex,pInfoParm2)) < 0) return ret;
			pInfo2 = pComplex;
		}
	}
	ppParm[0] = &tInfoR1;
	ppParm[1] = &tInfoI1;
	ppParm[2] = &tInfo;
	if ((ret=cl_get_range_info(pInfo1,ppParm,iVal,0)) < 0) return ret;
	/* ABŜƂ́ApInfoParm1==pInfoParm2Ȃ̂ŁApInfoParm1g */
	if (!stricmp(pOperator,"ABS")) {
		if (ppParm[0]->pi_attr==DEF_ZOK_FLOA || ppParm[1]->pi_attr==DEF_ZOK_FLOA)
			ret = _complex_abs_bouble(pInfoParmW,ppParm[0],ppParm[1]);
		else {
			if ((ret=_inner_product(&tInfoA,ppParm[0],ppParm[1])) < 0) return ret;
			ppParm[0] = &tInfoA;
			ret = func_math2(pInfoParmW,"SQRT",1,ppParm,D_FUC_SQRT);
		}
		return ret;
	}
	ppParm[0] = &tInfoR2;
	ppParm[1] = &tInfoI2;
	if ((ret=cl_get_range_info(pInfo2,ppParm,iVal,0)) < 0) return ret;
	if ((ret=cl_conv_upper(&tInfoR1,&tInfoR2)) < 0) return ret;
	if ((ret=cl_conv_upper(&tInfoI1,&tInfoI2)) < 0) return ret;
	lValr = cl_get_tmpMPA(lValrz);
	lVali = cl_get_tmpMPA(lValiz);
	if (op=='+' || op=='-') {	/* (a+jb)+-(c+jd)=a+-c+j(b+-d) */
		/*  */
		if ((ret=cl_cmpt_math_real(&tCmplx[0],pOperator,&tInfoR1,&tInfoR2)) < 0) return ret;
		/*  */
		if ((ret=cl_cmpt_math_real(&tCmplx[1],pOperator,&tInfoI1,&tInfoI2)) < 0) return ret;
	}
	else if (op == '*') {	/* (R1+jI1)*(R2+jI2)=(R1*R2-I1*I2)+j(R1*I2+I1*R2) */
#if 1
		if ((ret=_complex_mul(&tCmplx[0],&tCmplx[1],&tInfoR1,&tInfoI1,&tInfoR2,&tInfoI2)) < 0) return ret;
#else
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[0],"-",&tInfoW1,&tInfoW2)) < 0) return ret;
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[1],"+",&tInfoW1,&tInfoW2)) < 0) return ret;
#endif
	}
	else if (op == '/') {	/* (R1+jI1)/(R2+jI2)= (R1*R2+I1*I2)/A+j(I1*R2-I2*R1)/A, A=(R2*R2+I2*I2) */
#if 1
		if ((ret=_complex_div(&tCmplx[0],&tCmplx[1],&tInfoR1,&tInfoI1,&tInfoR2,&tInfoI2)) < 0) return ret;
#else
		/*  */
#if 1
		if ((ret=_inner_product(&tInfoA,&tInfoR2,&tInfoI2)) < 0) return ret;
#else
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR2,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoA,"+",&tInfoW1,&tInfoW2)) < 0) return ret;
#endif
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW3,"+",&tInfoW1,&tInfoW2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[0],"/",&tInfoW3,&tInfoA)) < 0) return ret;
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoI1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI2,&tInfoR1)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW3,"-",&tInfoW1,&tInfoW2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[1],"/",&tInfoW3,&tInfoA)) < 0) return ret;
#endif
	}
	/* f */
	ppParm[0] = &tCmplx[0];
	ppParm[1] = &tCmplx[1];
	ppParm[1]->pi_scale |= D_DATA_IMAGE;
#if 1
	if (cl_adjust_complex(pInfoParmW,ppParm[0],ppParm[1])) return 0;
#else
	if (!(cl_get_option(2,0) & 0x80)) {
		if (cl_is_zero(ppParm[1])) {
			cl_gx_copy_info(pInfoParmW,ppParm[0]);
			return 0;
		}
		if (cl_is_zero(ppParm[0])) {
			cl_gx_copy_info(pInfoParmW,ppParm[1]);
			return 0;
		}
	}
#endif
	ret = cl_gx_range_set(pInfoParmW,2,ppParm,0);
	return ret;
}

/****************************************/
/*	01									*/
/****************************************/
int cl_cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtInfoParm *pInfoParmW;
char *pOperator;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
{
	int ret,iParm[5],iCOMPLEX,iIMAGE1,iIMAGE2,ope;
	long lValz[NMPA_LONG],*lVal;
	char op;

DEBUGOUTL1(120,"cl_cmpt_complex: pOperator=[%s]",pOperator);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_cmpt_complex: Enter pInfoParm1=",pInfoParm1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"                       pInfoParm2=",pInfoParm2,0,0);

	op = *pOperator;
	if (!stricmp(pOperator,"ABS")) ;
	else if (op=='+' || op=='-' || op=='*' || op=='/') ;
	else {
		ERROROUT2(FORMAT(245),"cl_comp_complex",pOperator);	/* %s: Zq(%s)Ɍ肪܂B*/
		return ECL_SCRIPT_ERROR;
	}
	iCOMPLEX = ope = 0;
	if (op=='*' && pOperator[1]=='*') ope = 30;
	if ((pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA) || (pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA)) {
		iCOMPLEX = 2;
	}
	else {
		iIMAGE1 = pInfoParm1->pi_scale & D_DATA_IMAGE;
		iIMAGE2 = pInfoParm2->pi_scale & D_DATA_IMAGE;
		if (iIMAGE1 || iIMAGE2) {
			if (ope!=30 && iIMAGE1 && iIMAGE2) iCOMPLEX = 1;
			else iCOMPLEX = 2;
		}
	}
/*
printf("cl_cmpt_complex: pOperator=[%s] iCOMPLEX=%d\n",pOperator,iCOMPLEX);
*/
	if (iCOMPLEX == 2) {
		ret = _cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
	}
	else {
		lVal = cl_get_tmpMPA(lValz);
		if ((ret=cl_cmpt_math(lVal,pOperator,pInfoParm1,pInfoParm2,iParm)) >= 0) {
			ret=cl_set_parm(pInfoParmW,lVal,0,iParm);
			if (iCOMPLEX == 1) {
				if (iIMAGE1 && iIMAGE2) {
					if (op == '*') cl_sign_reverse(pInfoParmW);
					else if (op != '/') pInfoParmW->pi_scale |= D_DATA_IMAGE;
				}
				else {
					pInfoParmW->pi_scale |= D_DATA_IMAGE;
					if (op == '/') cl_sign_reverse(pInfoParmW);
				}
			}
		}
	}
	return ret;
}

/****************************************/
/*	02									*/
/****************************************/
int cl_func_complex(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	static char *_fn_="cl_func_complex";
	int i,rc,atr1,atr2,iAttr1[5],atr;
	long Val1z[NMPA_LONG*2+1],*Val1;
	double dVal1;
	char *p;
	tdtInfoParm *pInfo1,*pInfo2,tInfoParm[2],*ppInfo[2];

	pInfo1 = ppParm[0];
	pInfo2 = ppParm[1];
	if ((pInfo1->pi_alen & D_AULN_COMPLEX_DATA) || (pInfo2->pi_alen & D_AULN_COMPLEX_DATA)) {
		ERROROUT2(FORMAT(636),_fn_,FORMAT(635));	/* f *//*%s: %s͎gpł܂B*/
		return ECL_SCRIPT_ERROR;
	}
	atr2 = pInfo2->pi_attr;
	if (atr2>=DEF_ZOK_BINA && atr2<=DEF_ZOK_DECI) {
		if (pInfo1->pi_scale & D_DATA_IMAGE) {
			ERROROUT1(FORMAT(634),_fn_);	/* %s: ̈ʒuĂ܂B*/
			return ECL_SCRIPT_ERROR;
		}
	}
	Val1 = cl_get_tmpMPA(Val1z);
	p = "val1:";
	for (i=0;i<2;i++) {
		if ((rc=cl_get_parm_mpa(ppParm[i],Val1,p,iAttr1)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		atr = iAttr1[0];
		ppInfo[i] = &tInfoParm[i];
		if (atr == DEF_ZOK_BINA) {
			cl_set_parm_long(ppInfo[i],Val1[0]);
			if (iAttr1[D_IATTR_ULI] & AKX_NUM_U) ppInfo[i]->pi_scale |= D_DATA_UNSIGNED;
		}
		else if (atr == DEF_ZOK_FLOA) {
			memcpy(&dVal1,Val1,sizeof(double));
			cl_set_parm_double(ppInfo[i],dVal1);
		}
		else if (atr == DEF_ZOK_DECI)
			rc = cl_set_parm_mpa(ppInfo[i],(MPA *)Val1);
		else
			return -1;
		p = "val2:";
	}
	ppInfo[1]->pi_scale |= D_DATA_IMAGE;
	/* ֐̂Ƃ́Aʏ̓[ł̂܂ܕfɂ */
	if (cl_get_option(2,0) & 0x100) {
		if (cl_adjust_complex(pInfoParmW,ppInfo[0],ppInfo[1])) return 0;
	}
	rc = cl_gx_range_set(pInfoParmW,2,ppInfo,0);
	return rc;
}

/****************************************/
/*	03									*/
/****************************************/
int cl_adjust_complex(pInfoParmW,pInfoParm1,pInfoParm2)
tdtInfoParm *pInfoParmW,*pInfoParm1,*pInfoParm2;
{
	if (!(cl_get_option(2,0) & 0x80)) {
		if (cl_is_zero(pInfoParm2)) {
			cl_gx_copy_info(pInfoParmW,pInfoParm1);
			return 1;
		}
		if (cl_is_zero(pInfoParm1)) {
			cl_gx_copy_info(pInfoParmW,pInfoParm2);
			return 1;
		}
	}
	return 0;
}
