/* automatically generated by bus-device-auto.sh, do not edit! */
_TME_RCSID("$Id: bus-device-auto.sh,v 1.3 2009/08/29 17:52:04 fredette Exp $");

/* this gives the number of entries that must be in a generic bus
   router array for a device with a bus size of 8 * (2 ^ siz_lg2)
   bits: */
#define TME_BUS_ROUTER_INIT_SIZE(siz_lg2)                       \
  TME_BUS_ROUTER_INIT_INDEX(siz_lg2, (1 << (siz_lg2)) + 1, 0)


/* the 16-bit big-endian bus master bus router: */
const tme_bus_lane_t tme_bus_device_router_16eb[TME_BUS_ROUTER_INIT_SIZE(TME_BUS16_LOG2)] = {

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
};

/* the 16-bit little-endian bus master bus router: */
const tme_bus_lane_t tme_bus_device_router_16el[TME_BUS_ROUTER_INIT_SIZE(TME_BUS16_LOG2)] = {

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     (a 16-bit initiator cannot request 16 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
};

/* the 16-bit bus master DMA read function: */
int
tme_bus_device_dma_read_16(struct tme_bus_device *bus_device,
                           tme_bus_addr_t address_init,
                           tme_bus_addr_t size,
                           tme_uint8_t *buffer,
                           unsigned int locks)
{
  struct tme_bus_tlb *tlb, tlb_local;
  struct tme_bus_connection *conn_bus;
  tme_bus_addr_t count_minus_one, count;
  struct tme_bus_cycle cycle;
  tme_bus_addr_t address_resp;
  int shift;
  int err;

  /* assume no error: */
  err = TME_OK;

  /* loop while we have more bytes to read: */
  for (; err == TME_OK && size > 0; ) {

    /* hash this address into a TLB entry: */
    tlb = (*bus_device->tme_bus_device_tlb_hash)
            (bus_device,
             address_init,
             TME_BUS_CYCLE_READ);

    /* busy this TLB entry: */
    tme_bus_tlb_busy(tlb);

    /* if this TLB entry is invalid, doesn't cover this address, or if it doesn't
       allow reading, reload it: */
    if (tme_bus_tlb_is_invalid(tlb)
        || address_init < tlb->tme_bus_tlb_addr_first
        || address_init > tlb->tme_bus_tlb_addr_last
        || (tlb->tme_bus_tlb_emulator_off_read == TME_EMULATOR_OFF_UNDEF
            && !(tlb->tme_bus_tlb_cycles_ok & TME_BUS_CYCLE_READ))) {

      /* unbusy this TLB entry for filling: */
      tme_bus_tlb_unbusy_fill(tlb);

      /* pass this TLB's token: */
      tlb_local.tme_bus_tlb_token = tlb->tme_bus_tlb_token;

      /* get our bus connection: */
      conn_bus = tme_memory_atomic_pointer_read(struct tme_bus_connection *,
                                                bus_device->tme_bus_device_connection,
                                                &bus_device->tme_bus_device_connection_rwlock);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* reload the TLB entry: */
      err = (*conn_bus->tme_bus_tlb_fill)
              (conn_bus,
               &tlb_local,
               address_init,
               TME_BUS_CYCLE_READ);

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);

      /* return if we couldn't fill the TLB entry: */
      if (err != TME_OK) {
        return (err);
      }

      /* store the TLB entry: */
      *tlb = tlb_local;

      /* loop to check the newly filled TLB entry: */
      continue;
    }

    /* if this TLB entry allows fast reading: */
    if (tlb->tme_bus_tlb_emulator_off_read != TME_EMULATOR_OFF_UNDEF) {

      /* see how many bytes we can fast read from this TLB entry,
         starting at this address: */
      count_minus_one = (tlb->tme_bus_tlb_addr_last - address_init);

      /* read that many bytes or size bytes, whichever is smaller: */
      count_minus_one = TME_MIN(count_minus_one,
                                (size - 1));
      count = count_minus_one + 1;
      assert (count != 0);

      /* do the bus read: */
      tme_memory_bus_read_buffer((tlb->tme_bus_tlb_emulator_off_read + address_init), buffer, count, tlb->tme_bus_tlb_rwlock, sizeof(tme_uint8_t), sizeof(tme_uint16_t));

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);
    }

    /* otherwise, we have to do a slow read: */
    else {

      /* get the size of this bus cycle: */
      count = (1 << TME_BUS16_LOG2);
      count -= (address_init & (count - 1));
      count = TME_MIN(count, size);

      /* fill the cycle structure: */
      cycle.tme_bus_cycle_type = TME_BUS_CYCLE_READ;
      cycle.tme_bus_cycle_size = count;
      cycle.tme_bus_cycle_buffer = (tme_uint8_t *) buffer; /* XXX this breaks const */
      cycle.tme_bus_cycle_buffer_increment = 1;
      cycle.tme_bus_cycle_lane_routing
        = (bus_device->tme_bus_device_router
           + TME_BUS_ROUTER_INIT_INDEX(TME_BUS16_LOG2, count, address_init));

      /* XXX this should come from a socket configuration: */
      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS16_LOG2);

      /* form the physical address for the bus cycle handler: */
      address_resp = tlb->tme_bus_tlb_addr_offset + address_init;
      shift = tlb->tme_bus_tlb_addr_shift;
      if (shift < 0) {
        address_resp <<= (0 - shift);
      }
      else if (shift > 0) {
        address_resp >>= shift;
      }
      cycle.tme_bus_cycle_address = address_resp;

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* run the bus cycle: */
      err = (*tlb->tme_bus_tlb_cycle)
           (tlb->tme_bus_tlb_cycle_private, &cycle);

      /* if the TLB entry was invalidated before the read: */
      if (err == EBADF
          && tme_bus_tlb_is_invalid(tlb)) {
        count = 0;
      }

      /* otherwise, any other error might be a bus error: */
      else if (err != TME_OK) {
        err = tme_bus_tlb_fault(tlb, &cycle, err);
        assert (err != TME_OK);
      }

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);
    }

    /* update the address, buffer, and size and continue: */
    address_init += count;
    buffer += count;
    size -= count;
  }

  return (err);
}

/* the 16-bit bus master DMA write function: */
int
tme_bus_device_dma_write_16(struct tme_bus_device *bus_device,
                           tme_bus_addr_t address_init,
                           tme_bus_addr_t size,
                           const tme_uint8_t *buffer,
                           unsigned int locks)
{
  struct tme_bus_tlb *tlb, tlb_local;
  struct tme_bus_connection *conn_bus;
  tme_bus_addr_t count_minus_one, count;
  struct tme_bus_cycle cycle;
  tme_bus_addr_t address_resp;
  int shift;
  int err;

  /* assume no error: */
  err = TME_OK;

  /* loop while we have more bytes to write: */
  for (; err == TME_OK && size > 0; ) {

    /* hash this address into a TLB entry: */
    tlb = (*bus_device->tme_bus_device_tlb_hash)
            (bus_device,
             address_init,
             TME_BUS_CYCLE_WRITE);

    /* busy this TLB entry: */
    tme_bus_tlb_busy(tlb);

    /* if this TLB entry is invalid, doesn't cover this address, or if it doesn't
       allow writing, reload it: */
    if (tme_bus_tlb_is_invalid(tlb)
        || address_init < tlb->tme_bus_tlb_addr_first
        || address_init > tlb->tme_bus_tlb_addr_last
        || (tlb->tme_bus_tlb_emulator_off_write == TME_EMULATOR_OFF_UNDEF
            && !(tlb->tme_bus_tlb_cycles_ok & TME_BUS_CYCLE_WRITE))) {

      /* unbusy this TLB entry for filling: */
      tme_bus_tlb_unbusy_fill(tlb);

      /* pass this TLB's token: */
      tlb_local.tme_bus_tlb_token = tlb->tme_bus_tlb_token;

      /* get our bus connection: */
      conn_bus = tme_memory_atomic_pointer_read(struct tme_bus_connection *,
                                                bus_device->tme_bus_device_connection,
                                                &bus_device->tme_bus_device_connection_rwlock);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* reload the TLB entry: */
      err = (*conn_bus->tme_bus_tlb_fill)
              (conn_bus,
               &tlb_local,
               address_init,
               TME_BUS_CYCLE_WRITE);

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);

      /* return if we couldn't fill the TLB entry: */
      if (err != TME_OK) {
        return (err);
      }

      /* store the TLB entry: */
      *tlb = tlb_local;

      /* loop to check the newly filled TLB entry: */
      continue;
    }

    /* if this TLB entry allows fast writing: */
    if (tlb->tme_bus_tlb_emulator_off_write != TME_EMULATOR_OFF_UNDEF) {

      /* see how many bytes we can fast write to this TLB entry,
         starting at this address: */
      count_minus_one = (tlb->tme_bus_tlb_addr_last - address_init);

      /* write that many bytes or size bytes, whichever is smaller: */
      count_minus_one = TME_MIN(count_minus_one,
                                (size - 1));
      count = count_minus_one + 1;
      assert (count != 0);

      /* do the bus write: */
      tme_memory_bus_write_buffer((tlb->tme_bus_tlb_emulator_off_write + address_init), buffer, count, tlb->tme_bus_tlb_rwlock, sizeof(tme_uint8_t), sizeof(tme_uint16_t));

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);
    }

    /* otherwise, we have to do a slow write: */
    else {

      /* get the size of this bus cycle: */
      count = (1 << TME_BUS16_LOG2);
      count -= (address_init & (count - 1));
      count = TME_MIN(count, size);

      /* fill the cycle structure: */
      cycle.tme_bus_cycle_type = TME_BUS_CYCLE_WRITE;
      cycle.tme_bus_cycle_size = count;
      cycle.tme_bus_cycle_buffer = (tme_uint8_t *) buffer; /* XXX this breaks const */
      cycle.tme_bus_cycle_buffer_increment = 1;
      cycle.tme_bus_cycle_lane_routing
        = (bus_device->tme_bus_device_router
           + TME_BUS_ROUTER_INIT_INDEX(TME_BUS16_LOG2, count, address_init));

      /* XXX this should come from a socket configuration: */
      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS16_LOG2);

      /* form the physical address for the bus cycle handler: */
      address_resp = tlb->tme_bus_tlb_addr_offset + address_init;
      shift = tlb->tme_bus_tlb_addr_shift;
      if (shift < 0) {
        address_resp <<= (0 - shift);
      }
      else if (shift > 0) {
        address_resp >>= shift;
      }
      cycle.tme_bus_cycle_address = address_resp;

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* run the bus cycle: */
      err = (*tlb->tme_bus_tlb_cycle)
           (tlb->tme_bus_tlb_cycle_private, &cycle);

      /* if the TLB entry was invalidated before the write: */
      if (err == EBADF
          && tme_bus_tlb_is_invalid(tlb)) {
        count = 0;
      }

      /* otherwise, any other error might be a bus error: */
      else if (err != TME_OK) {
        err = tme_bus_tlb_fault(tlb, &cycle, err);
        assert (err != TME_OK);
      }

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);
    }

    /* update the address, buffer, and size and continue: */
    address_init += count;
    buffer += count;
    size -= count;
  }

  return (err);
}

/* the 32-bit big-endian bus master bus router: */
const tme_bus_lane_t tme_bus_device_router_32eb[TME_BUS_ROUTER_INIT_SIZE(TME_BUS32_LOG2)] = {

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,
};

/* the 32-bit little-endian bus master bus router: */
const tme_bus_lane_t tme_bus_device_router_32el[TME_BUS_ROUTER_INIT_SIZE(TME_BUS32_LOG2)] = {

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 8 bits
     initiator address offset: 24 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(0),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_UNDEF,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 16 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_UNDEF,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(1),

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 16 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 16 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_UNDEF,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 8 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_UNDEF,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(2),

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 24 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 24 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 24 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3) | TME_BUS_LANE_WARN,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0),
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1),
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2),
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 0 bits
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ROUTE(0) | TME_BUS_LANE_WARN,
  /* D15-D8 */	TME_BUS_LANE_ROUTE(1) | TME_BUS_LANE_WARN,
  /* D23-D16 */	TME_BUS_LANE_ROUTE(2) | TME_BUS_LANE_WARN,
  /* D31-D24 */	TME_BUS_LANE_ROUTE(3),

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 8 bits
     (a 32-bit initiator cannot request 32 bits at an 8-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 16 bits
     (a 32-bit initiator cannot request 32 bits at an 16-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 8 bits
     responder port least lane: D31-D24: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D15-D8: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D23-D16: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 16 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D7-D0: */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D15-D8
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D23-D16
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,

  /* initiator maximum cycle size: 32 bits
     initiator address offset: 24 bits
     (a 32-bit initiator cannot request 32 bits at an 24-bit offset - this is an array placeholder)
     responder bus port size: 32 bits
     responder port least lane: D31-D24
     (responder port not correctly positioned for this initiator): */
  /* D7-D0 */	TME_BUS_LANE_ABORT,
  /* D15-D8 */	TME_BUS_LANE_ABORT,
  /* D23-D16 */	TME_BUS_LANE_ABORT,
  /* D31-D24 */	TME_BUS_LANE_ABORT,
};

/* the 32-bit bus master DMA read function: */
int
tme_bus_device_dma_read_32(struct tme_bus_device *bus_device,
                           tme_bus_addr_t address_init,
                           tme_bus_addr_t size,
                           tme_uint8_t *buffer,
                           unsigned int locks)
{
  struct tme_bus_tlb *tlb, tlb_local;
  struct tme_bus_connection *conn_bus;
  tme_bus_addr_t count_minus_one, count;
  struct tme_bus_cycle cycle;
  tme_bus_addr_t address_resp;
  int shift;
  int err;

  /* assume no error: */
  err = TME_OK;

  /* loop while we have more bytes to read: */
  for (; err == TME_OK && size > 0; ) {

    /* hash this address into a TLB entry: */
    tlb = (*bus_device->tme_bus_device_tlb_hash)
            (bus_device,
             address_init,
             TME_BUS_CYCLE_READ);

    /* busy this TLB entry: */
    tme_bus_tlb_busy(tlb);

    /* if this TLB entry is invalid, doesn't cover this address, or if it doesn't
       allow reading, reload it: */
    if (tme_bus_tlb_is_invalid(tlb)
        || address_init < tlb->tme_bus_tlb_addr_first
        || address_init > tlb->tme_bus_tlb_addr_last
        || (tlb->tme_bus_tlb_emulator_off_read == TME_EMULATOR_OFF_UNDEF
            && !(tlb->tme_bus_tlb_cycles_ok & TME_BUS_CYCLE_READ))) {

      /* unbusy this TLB entry for filling: */
      tme_bus_tlb_unbusy_fill(tlb);

      /* pass this TLB's token: */
      tlb_local.tme_bus_tlb_token = tlb->tme_bus_tlb_token;

      /* get our bus connection: */
      conn_bus = tme_memory_atomic_pointer_read(struct tme_bus_connection *,
                                                bus_device->tme_bus_device_connection,
                                                &bus_device->tme_bus_device_connection_rwlock);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* reload the TLB entry: */
      err = (*conn_bus->tme_bus_tlb_fill)
              (conn_bus,
               &tlb_local,
               address_init,
               TME_BUS_CYCLE_READ);

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);

      /* return if we couldn't fill the TLB entry: */
      if (err != TME_OK) {
        return (err);
      }

      /* store the TLB entry: */
      *tlb = tlb_local;

      /* loop to check the newly filled TLB entry: */
      continue;
    }

    /* if this TLB entry allows fast reading: */
    if (tlb->tme_bus_tlb_emulator_off_read != TME_EMULATOR_OFF_UNDEF) {

      /* see how many bytes we can fast read from this TLB entry,
         starting at this address: */
      count_minus_one = (tlb->tme_bus_tlb_addr_last - address_init);

      /* read that many bytes or size bytes, whichever is smaller: */
      count_minus_one = TME_MIN(count_minus_one,
                                (size - 1));
      count = count_minus_one + 1;
      assert (count != 0);

      /* do the bus read: */
      tme_memory_bus_read_buffer((tlb->tme_bus_tlb_emulator_off_read + address_init), buffer, count, tlb->tme_bus_tlb_rwlock, sizeof(tme_uint8_t), sizeof(tme_uint32_t));

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);
    }

    /* otherwise, we have to do a slow read: */
    else {

      /* get the size of this bus cycle: */
      count = (1 << TME_BUS32_LOG2);
      count -= (address_init & (count - 1));
      count = TME_MIN(count, size);

      /* fill the cycle structure: */
      cycle.tme_bus_cycle_type = TME_BUS_CYCLE_READ;
      cycle.tme_bus_cycle_size = count;
      cycle.tme_bus_cycle_buffer = (tme_uint8_t *) buffer; /* XXX this breaks const */
      cycle.tme_bus_cycle_buffer_increment = 1;
      cycle.tme_bus_cycle_lane_routing
        = (bus_device->tme_bus_device_router
           + TME_BUS_ROUTER_INIT_INDEX(TME_BUS32_LOG2, count, address_init));

      /* XXX this should come from a socket configuration: */
      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS32_LOG2);

      /* form the physical address for the bus cycle handler: */
      address_resp = tlb->tme_bus_tlb_addr_offset + address_init;
      shift = tlb->tme_bus_tlb_addr_shift;
      if (shift < 0) {
        address_resp <<= (0 - shift);
      }
      else if (shift > 0) {
        address_resp >>= shift;
      }
      cycle.tme_bus_cycle_address = address_resp;

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* run the bus cycle: */
      err = (*tlb->tme_bus_tlb_cycle)
           (tlb->tme_bus_tlb_cycle_private, &cycle);

      /* if the TLB entry was invalidated before the read: */
      if (err == EBADF
          && tme_bus_tlb_is_invalid(tlb)) {
        count = 0;
      }

      /* otherwise, any other error might be a bus error: */
      else if (err != TME_OK) {
        err = tme_bus_tlb_fault(tlb, &cycle, err);
        assert (err != TME_OK);
      }

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);
    }

    /* update the address, buffer, and size and continue: */
    address_init += count;
    buffer += count;
    size -= count;
  }

  return (err);
}

/* the 32-bit bus master DMA write function: */
int
tme_bus_device_dma_write_32(struct tme_bus_device *bus_device,
                           tme_bus_addr_t address_init,
                           tme_bus_addr_t size,
                           const tme_uint8_t *buffer,
                           unsigned int locks)
{
  struct tme_bus_tlb *tlb, tlb_local;
  struct tme_bus_connection *conn_bus;
  tme_bus_addr_t count_minus_one, count;
  struct tme_bus_cycle cycle;
  tme_bus_addr_t address_resp;
  int shift;
  int err;

  /* assume no error: */
  err = TME_OK;

  /* loop while we have more bytes to write: */
  for (; err == TME_OK && size > 0; ) {

    /* hash this address into a TLB entry: */
    tlb = (*bus_device->tme_bus_device_tlb_hash)
            (bus_device,
             address_init,
             TME_BUS_CYCLE_WRITE);

    /* busy this TLB entry: */
    tme_bus_tlb_busy(tlb);

    /* if this TLB entry is invalid, doesn't cover this address, or if it doesn't
       allow writing, reload it: */
    if (tme_bus_tlb_is_invalid(tlb)
        || address_init < tlb->tme_bus_tlb_addr_first
        || address_init > tlb->tme_bus_tlb_addr_last
        || (tlb->tme_bus_tlb_emulator_off_write == TME_EMULATOR_OFF_UNDEF
            && !(tlb->tme_bus_tlb_cycles_ok & TME_BUS_CYCLE_WRITE))) {

      /* unbusy this TLB entry for filling: */
      tme_bus_tlb_unbusy_fill(tlb);

      /* pass this TLB's token: */
      tlb_local.tme_bus_tlb_token = tlb->tme_bus_tlb_token;

      /* get our bus connection: */
      conn_bus = tme_memory_atomic_pointer_read(struct tme_bus_connection *,
                                                bus_device->tme_bus_device_connection,
                                                &bus_device->tme_bus_device_connection_rwlock);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* reload the TLB entry: */
      err = (*conn_bus->tme_bus_tlb_fill)
              (conn_bus,
               &tlb_local,
               address_init,
               TME_BUS_CYCLE_WRITE);

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);

      /* return if we couldn't fill the TLB entry: */
      if (err != TME_OK) {
        return (err);
      }

      /* store the TLB entry: */
      *tlb = tlb_local;

      /* loop to check the newly filled TLB entry: */
      continue;
    }

    /* if this TLB entry allows fast writing: */
    if (tlb->tme_bus_tlb_emulator_off_write != TME_EMULATOR_OFF_UNDEF) {

      /* see how many bytes we can fast write to this TLB entry,
         starting at this address: */
      count_minus_one = (tlb->tme_bus_tlb_addr_last - address_init);

      /* write that many bytes or size bytes, whichever is smaller: */
      count_minus_one = TME_MIN(count_minus_one,
                                (size - 1));
      count = count_minus_one + 1;
      assert (count != 0);

      /* do the bus write: */
      tme_memory_bus_write_buffer((tlb->tme_bus_tlb_emulator_off_write + address_init), buffer, count, tlb->tme_bus_tlb_rwlock, sizeof(tme_uint8_t), sizeof(tme_uint32_t));

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);
    }

    /* otherwise, we have to do a slow write: */
    else {

      /* get the size of this bus cycle: */
      count = (1 << TME_BUS32_LOG2);
      count -= (address_init & (count - 1));
      count = TME_MIN(count, size);

      /* fill the cycle structure: */
      cycle.tme_bus_cycle_type = TME_BUS_CYCLE_WRITE;
      cycle.tme_bus_cycle_size = count;
      cycle.tme_bus_cycle_buffer = (tme_uint8_t *) buffer; /* XXX this breaks const */
      cycle.tme_bus_cycle_buffer_increment = 1;
      cycle.tme_bus_cycle_lane_routing
        = (bus_device->tme_bus_device_router
           + TME_BUS_ROUTER_INIT_INDEX(TME_BUS32_LOG2, count, address_init));

      /* XXX this should come from a socket configuration: */
      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS32_LOG2);

      /* form the physical address for the bus cycle handler: */
      address_resp = tlb->tme_bus_tlb_addr_offset + address_init;
      shift = tlb->tme_bus_tlb_addr_shift;
      if (shift < 0) {
        address_resp <<= (0 - shift);
      }
      else if (shift > 0) {
        address_resp >>= shift;
      }
      cycle.tme_bus_cycle_address = address_resp;

      /* unbusy this TLB entry: */
      tme_bus_tlb_unbusy(tlb);

      /* unlock the device: */
      (*bus_device->tme_bus_device_unlock)(bus_device, locks);

      /* run the bus cycle: */
      err = (*tlb->tme_bus_tlb_cycle)
           (tlb->tme_bus_tlb_cycle_private, &cycle);

      /* if the TLB entry was invalidated before the write: */
      if (err == EBADF
          && tme_bus_tlb_is_invalid(tlb)) {
        count = 0;
      }

      /* otherwise, any other error might be a bus error: */
      else if (err != TME_OK) {
        err = tme_bus_tlb_fault(tlb, &cycle, err);
        assert (err != TME_OK);
      }

      /* lock the device: */
      (*bus_device->tme_bus_device_lock)(bus_device, locks);
    }

    /* update the address, buffer, and size and continue: */
    address_init += count;
    buffer += count;
    size -= count;
  }

  return (err);
}
