/*static char sccsid[]="%Z% %M% %I% %E% %U%";*/
/************************************************************************/
/*																		*/
/*	akxmemtool.h														*/
/*																		*/
/*		Coded by Akito Kobayashi										*/
/*																		*/
/************************************************************************/
#ifndef _AKXMEMTOOL_H
#define _AKXMEMTOOL_H

#define  MEMTOOL

/**************************************************************************
 *                            MACRO                                       *
 **************************************************************************/
#undef Malloc
#undef Free  
#undef Realloc

#ifdef MEMTOOL
#define	Meminit(a)		akxm_mem_init(a)
#define	Malloc(a)		akxm_malloc(a,__FILE__,__LINE__)
#define	Realloc(a,b)	akxm_realloc(a,b,__FILE__,__LINE__)
#define	Free(a)			akxm_free(a,__FILE__,__LINE__)
#define	Nofree(a)		akxm_no_free(a)
#define	Strdup(a)		akxm_strdup(a,__FILE__,__LINE__)
#define	Strndup(a,b)	akxm_strndup(a,b,__FILE__,__LINE__)
#define	Memdup(a,b)		akxm_memdup(a,b,__FILE__,__LINE__)
#define	Memndup(a,b,c)	akxm_memndup(a,b,c,__FILE__,__LINE__)
#define	MRealloc(a,b)	akxm_mrealloc(a,b,__FILE__,__LINE__)
#else
#define	Meminit(a)
#define	Malloc(a)		malloc(a)
#define	Realloc(a,b)	realloc(a,b)
#define	Free(a)			free(a)
#define	Nofree(a)		(-1)
#define	Strdup(a)		strdup(a)
#define	Strndup(a,b)	(NULL)
#define	Memdup(a,b)		(NULL)
#define	Memndup(a,b,c)	(NULL)
#define	MRealloc(a,b)	(NULL)
#endif

#define	CCTMalloc(a,b)	akxm_cct_mem_alloc_m(a,b,__FILE__,__LINE__)

int akxm_addrchk(/*p*/);
extern	int 	akxm_mem_init();
extern	char	*akxm_malloc();
extern	char	*akxm_realloc();
extern	void	akxm_free();
extern	int 	akxm_no_free();
extern	char	*akxm_strdup();
extern	char	*akxm_strndup();
extern	char	*akxm_memdup();
extern	char	*akxm_memndup();
extern	char	*akxm_mrealloc();
int akxm_stat_memory(/*m,parm*/);
int akxm_mem_init_msg(/*msg,msglen*/);
int akxm_mem_cntl(/*m,parm*/);
int akxm_mem_init_opt(/*opt,proc,maxreg*/);
int akxm_mem_check(/*p,len,opt*/);

#define  AKX_CNBD_SIZE  8192		/* CnCB BD size */

#define D_CMB_SIZE		AKX_CNBD_SIZE
#define D_CCT_EXTENT	128

typedef struct _CMBCTL {
	struct _CMBCTL *cbc_next;
	char  *cbc_buf;
	size_t cbc_msize;
	size_t cbc_rem;
#if 1	/* 2022.6.20 */
	int cbc_mcount;
	int cbc_unused;
#endif
} tdtCMBCTL;

typedef struct {
	tdtCMBCTL *cct_top;
	tdtCMBCTL *cct_cur;
	size_t     cct_size;
	int        cct_ext;
#if 1	/* 2022.6.20 */
	int        cct_opt;
#endif
} tdtCONSTCT;

#if 1	/* 2022.6.21 */
typedef struct {
	short option;
	short offset;
	int  parlen;
	int  parlen2;
	char *par;
} tdtCCT_MEM;
#endif

#define D_CCT_MEM_USE_MIN_LEN	(sizeof(tdtCCT_MEM)*2)

void akxm_mem_sdump(/*pi,n,buf*/);
tdtCONSTCT *akxm_cct_new_opt(size_t size, int extent, int opt);
tdtCONSTCT *akxm_cct_new(size_t size, int extent);
int akxm_cct_mem_get(/*tdtCONSTCT *conct, size_t len, char **pmem*/);
int akxm_cct_mem_reget(tdtCONSTCT *conct, size_t len, char **pmem);
int akxm_cct_mem_put(tdtCONSTCT *conct, char *mem);
char *akxm_cct_mem_alloc(/*tdtCONSTCT *conct, size_t len*/);
char *akxm_cct_mem_alloc_m(/* pConstCt,len */);
tdtCONSTCT *akxm_cct_mem_new();
tdtCONSTCT *akxm_cct_mem_new_opt(/*size,opt*/);
void akxm_cct_mem_free(tdtCONSTCT *conct);
char *akxm_cct_malloc(/* ConstCt,Len */);
int akxm_cct_mem_used(tdtCONSTCT *conct);
int akxm_cct_reset(tdtCONSTCT *conct);
int akxm_alloc_ctl_is(/*pAC*/);
int akxm_alloc_ctl_pp(/*pAC,alen,pp*/);
int akxm_malloc_ctl_pp(/*pAC,alen,pp*/);
char *akxm_malloc_ctl(/*pAC,alen*/);
int akxm_malloc_constct_pp(/*m_alloc,pConstCt,alen,pp*/);
char *akxm_malloc_constct(/*m_alloc,pConstCt,alen*/);

#endif	/* _AKXMEMTOOL_H */
