/*static char sccsid[]="%Z% %M% %I% %E% %U%";*/
/*********************************************************/
/*                                                       */
/*     akaconst.h                                        */
/*                                                       */
/*              coded by A.Kobayashi 95.12.12            */
/*                                                       */
/*********************************************************/
#ifndef _AKACONST_H
#define _AKACONST_H

/*** aka_registerClass Option ***/
#define AKA_RCO_NOREPLY		0x01
#define AKA_RCO_NOWAITSHUT	0x02
#define AKA_RCO_RECVPROC	0x04
#define AKA_RCO_NODISPLAY	0x08
#define AKA_RCO_SYS_CLASS	0x10
#define AKA_RCO_NODROPCERR	0x20

/*** akbOption ***/
#define AKA_AKO_NOREPLY		AKB_AKO_NOREPLY			/* 0x01 */
#define AKA_AKO_VER_B		AKB_AKO_VER_B			/* 0x02 */
#define AKA_AKO_LEAVE		AKB_AKO_LEAVE			/* 0x04 */
#define AKA_AKO_CHANNEL		AKB_AKO_CHANNEL			/* 0x08 */
#define AKA_AKO_MULTI_REPLY	AKB_AKO_MULTI_REPLY		/* 0x10 */
#define AKA_AKO_CHANNEL_CMD	AKB_AKO_CHANNEL_CMD		/* 0x20 */
#define AKA_AKO_CH_WRTEND	AKB_AKO_CHANNEL_CMD		/* 0x20 */
#define AKA_AKO_COMOBJECT	0x40
#define AKA_AKO_EXTENSION	0x80

/*** Extension Option ***/
#define AKA_EXO_COMOBJECT	0x00000100
#define AKA_EXO_VER_A		0x00000200
#define AKA_EXO_SET_SEQ		0x00000400
#define AKA_EXO_COMMAND		0x00000800
#define AKA_EXO_REGIST		0x00001000

/*** Packet Form ***/
#define AKA_PFM_INDIRECT	AKB_PFM_INDIRECT
#define AKA_PFM_PRIORITY	AKB_PFM_PRIORITY
#define AKA_PFM_NEED_REPLY	AKB_PFM_NEED_REPLY

/*** Class Id ***/
#define AKA_CLASS_AKB			0
#define AKA_CLASS_BASE			65535
#define AKA_CLASS_REGIST		AKA_CLASS_BASE - AKB_CMD_REGIST
#define AKA_CLASS_DELETE		AKA_CLASS_BASE - AKB_CMD_DELETE
#define AKA_CLASS_QUERY			AKA_CLASS_BASE - AKB_CMD_QUERY
#define AKA_CLASS_WATCH			AKA_CLASS_BASE - AKB_CMD_WATCH
#define AKA_CLASS_NOTIFY		AKA_CLASS_BASE - AKB_CMD_NOTIFY
#define AKA_CLASS_TRACE			AKA_CLASS_BASE - AKB_CMD_TRACE
#define AKA_CLASS_LOG			AKA_CLASS_BASE - AKB_CMD_LOG
#define AKA_CLASS_WAKEUP		AKA_CLASS_BASE - AKB_CMD_WAKEUP
#define AKA_CLASS_REQUEST		AKA_CLASS_BASE - AKB_CMD_REQUEST
#define AKA_CLASS_STATISTICS	AKA_CLASS_BASE - AKB_CMD_STATISTICS
#define AKA_CLASS_VERSION		AKA_CLASS_BASE - AKB_CMD_VERSION
#define AKA_CLASS_PASSWORD		AKA_CLASS_BASE - AKB_CMD_PASSWORD
#define AKA_CLASS_MEMORY		AKA_CLASS_BASE - AKB_CMD_MEMORY
#define AKA_CLASS_HELP			AKA_CLASS_BASE - AKB_CMD_HELP
#define AKA_CLASS_HOSTCMD		AKA_CLASS_BASE - AKB_CMD_HOSTCMD
#define AKA_CLASS_PROPERTY		AKA_CLASS_BASE - AKB_CMD_PROPERTY
#define AKA_CLASS_BUNSAN		AKA_CLASS_BASE - AKB_CMD_BUNSAN
#define AKA_CLASS_ONDEMAND		AKA_CLASS_BASE - AKB_CMD_ONDEMAND
#define AKA_CLASS_SHUT			AKA_CLASS_BASE - AKB_CMD_SHUT
#define AKA_CLASS_FSHUT			AKA_CLASS_BASE - AKB_CMD_FSHUT
#define AKA_CLASS_ADDFUNC2		0x40000000

/*** Class Name ***/
#define AKA_CLASS_NAME_AKB			"AKA_AKB"
#define AKA_CLASS_NAME_REGIST		"AKA_REGIST"	
#define AKA_CLASS_NAME_DELETE		"AKA_DELETE"	
#define AKA_CLASS_NAME_QUERY		"AKA_QUERY"	
#define AKA_CLASS_NAME_WATCH		"AKA_WATCH"
#define AKA_CLASS_NAME_NOTIFY		"AKA_NOTIFY"
#define AKA_CLASS_NAME_TRACE		"AKA_TRACE"
#define AKA_CLASS_NAME_LOG			"AKA_LOG"
#define AKA_CLASS_NAME_WAKEUP		"AKA_WAKEUP"
#define AKA_CLASS_NAME_REQUEST		"AKA_REQUEST"
#define AKA_CLASS_NAME_STATISTICS	"AKA_STATISTICS"
#define AKA_CLASS_NAME_VERSION		"AKA_VERSION"
#define AKA_CLASS_NAME_PASSWORD		"AKA_PASSWORD"
#define AKA_CLASS_NAME_MEMORY		"AKA_MEMORY"
#define AKA_CLASS_NAME_HELP			"AKA_HELP"
#define AKA_CLASS_NAME_HOSTCMD		"AKA_HOSTCMD"
#define AKA_CLASS_NAME_PROPERTY		"AKA_PROPERTY"
#define AKA_CLASS_NAME_BUNSAN		"AKA_BUNSAN"
#define AKA_CLASS_NAME_SHUT			"AKA_SHUT"
#define AKA_CLASS_NAME_FSHUT		"AKA_FSHUT"

/*** Disposition ***/
#define AKA_REGIST_CLASS	256

/*** Shut Control **/
#define AKA_SHUT_GET        0
#define AKA_SHUT_MODE       1
#define AKA_SHUT_SUSPEND    2

#define AKA_SHUT_MODE_SHUT	0x01
#define AKA_SHUT_MODE_FSHUT	0x02

#define AKA_SHUT_SUSPEND_SET	0x01

/*** Wait Message ***/
#define AKA_WMSG_NULL_CLASS	0x01
#define AKA_WMSG_WAKEUP  	0x02
#define AKA_WMSG_TIMEOUT  	0x04
#define AKA_WMSG_FUNC2  	0x08
#define AKA_WMSG_METHOD  	0x10

/*** Channel ***/
#define AKA_CHANNEL_INIT	3
#define AKA_CHANNEL_MAX		255
#define AKA_CHANNEL_SEQMAX	32

#define AKA_CH_STATUS	0x0f
#define AKA_CH_ACCEPT	0x10
#define AKA_CH_WRTEND	0x20
#define AKA_CH_UDP_S	0x40	/* Server */
#define AKA_CH_UDP_C	0x80	/* Client */

#define AKAGETCHSTATUS(x)	(x & AKA_CH_STATUS)
#define AKAGETCHACCEPT(x)	(x & AKA_CH_ACCEPT)
#define AKAGETCHWRTEND(x)	(x & AKA_CH_WRTEND)
#define AKAGETCHUDPS(x)		(x & AKA_CH_UDP_S)
#define AKAGETCHUDPC(x)		(x & AKA_CH_UDP_C)
#define AKAGETCHUDP(x)		(x & (AKA_CH_UDP_S | AKA_CH_UDP_C))
#define AKASETCHSTATUS(a,x)	a = (a & ~AKA_CH_STATUS)|x

#define AKA_CHUO_DATA_AWAY		0x01	/*  */
#define AKA_CHSO_CLOSE_EXCEPT	0x01	/*  */
#define AKA_CHSO_USE_AKB_HEAD	0x02	/*  */
#define AKA_CHSO_NOT_RECOVERY	0x04	/*  */
#define AKA_CHSO_UIO_NOT_EXEC	0x08	/*  */
#define AKA_CHSO_UIO_CON_OPEN	0x10	/*  */
#define AKA_CHSO_UIO_JUST_INTRVL	0x20	/*  */
#define AKA_CHSO_AKB_USED		0x40	/*  */

#define AKA_UIO_LOCK_SELECT	0x04	/*  */
#define AKA_UIO_LOCK_READ	0x08	/*  */
#define AKA_UIO_LOCK_WRITE	0x10	/*  */

/*** Timer ***/
/* int_max = 2,147,483,648 */
/* over flow days = int_max /(3600*24*AKA_TIMER_CLOCK) */
/* 1/  10 : 2485.51 days */
/* 1/  20 : 1242.76 */
/* 1/  50 :  497.10 */
/* 1/ 100 :  248.55 */
/* 1/1000 :   24.86 */
#define AKA_TIMER_CLOCK		50	/* 1/50 sec */

/*** Log ***/
#define AKA_LOG_GROUP       0x10000000

/*** MsgOption ***/
#define AKA_MSO_INNER_REGIST	0x01
#define AKA_MSO_RWQ_TIMEOUT		0x02
#define AKA_MSO_SET_TIMEOUT		0x04
#define AKA_MSO_NOT_EXIT_USAGE	0x08
#define AKA_MSO_NEED_REPLY		0x10
#define AKA_MSO_REG_DO_CHA_RB	0x20
#define AKA_MSO_DO_CHA_RB		0x40
#define AKA_MSO_EXEC_NOFREE		0x80
#define AKA_MSO_USER_INIT_LAST	0x0100

/* InitAll iCmd(=-iSd) */
#define AKA_ISD_DETACH		0x02
#define AKA_ISD_LISTEN		0x04	/* Channel open for listen by argv[2] */
#define AKA_ISD_CH_OPEN		0x08	/* New channel open when connected */

/* Init Status */
#define AKA_IST_CONNECTED	0x01
#define AKA_IST_REGISTED	0x02
#define AKA_IST_INITIALIZED	0x04
#define AKA_IST_STANDALONE	0x80

/* Errors */
#define AKA_ERR_METHOD_NO_CMD	-18505699
#define AKA_ERR_METHOD_NOT_DEF	-18505608

#endif	/* _AKACONST_H */
