static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************
 *
 *	akxsCacheQue.c
 *
 *	    coded   by A.Kobayashi 96.5.24
 *	  updated   by A.Kobayashi 97.1.26
 *
 ************************************************/
/*
	cc -g -DLINUX -I../include -c akxsCacheQue.c
*/
#define CACHE_QUE
#include "akxcommon.h"

static struct {
	time_t    my_mtime;	/* t@C̍Ō̕ύX*/
	off_t     st_size;	/* t@C̍vTCY/(oCgP)*/
} tMod;

#define DEBUGP(x)

/*tdtCACHE_CTL_HEAD *akxs_cache_new(int iMax)*/
tdtCACHE_CTL_HEAD *akxs_cache_new_que(iMax)
int iMax;
{
	tdtCACHE_CTL_HEAD *pCH;
	tdtCACHE_CTL **ppCt;
	int i;

	if (iMax==0) return NULL;
	
	if (pCH = (tdtCACHE_CTL_HEAD *)Malloc(sizeof(tdtCACHE_CTL_HEAD))) {
		memset(pCH,0,sizeof(tdtCACHE_CTL_HEAD));	/* add 2000.12.13 Koba */
		if (iMax<0) {
			iMax = -iMax;
			pCH->ch_opt |= AKX_CACHE_NOAUTOEXT;
		}
		pCH->ch_imax = iMax;
		pCH->ch_kind = 1;
		pCH->ch_keylen = 0;
		pCH->ch_cmplen = sizeof(time_t)+sizeof(off_t);
		pCH->ch_cshlen = 0;
		if (!(pCH->ch_pque = akxs_que_new(0,iMax))) {
			Free(pCH);
			pCH = NULL;
		}
	}
	return pCH;
}

/* static void cache_free(unsigned char ucOpt,qCacheCtl *pCt)*/
static void cache_free(ucOpt, pCt)
unsigned char ucOpt;
tdtCACHE_CTL *pCt;
{
	if (pCt->ca_key ) Free(pCt->ca_key );
	if (pCt->ca_cmp1) Free(pCt->ca_cmp1);
	if (pCt->ca_cmp2) Free(pCt->ca_cmp2);
	if (ucOpt & AKX_CACHE_DATASAVE) {
		if (pCt->ca_data) Free(pCt->ca_data);
	}
	memset(pCt,0,sizeof(tdtCACHE_CTL));
}

/*int akxs_cache_free(tdtCACHE_CTL_HEAD *pCH)*/
int akxs_cache_free_que(pCH)
tdtCACHE_CTL_HEAD *pCH;
{
	tdtQUE_CTL *pCQ;
	tdtCACHE_CTL *pCt;

	if (!pCH) return -1;
	if (pCQ=pCH->ch_pque) {
		while (akxs_que_get(pCQ,QUE_DFLT,&pCt) > 0) {
			cache_free(pCH->ch_opt,pCt);
			Free(pCt);
		}
		akxs_que_all_free(pCH->ch_pque);
	}
	if (pCH->ch_prls) {
		cache_free(pCH->ch_opt,pCH->ch_prls);
		Free(pCH->ch_prls);
	}
	Free(pCH);
	
	return 0;
}

/*static int cache_srch(tdtCACHE_CTL_HEAD *pCH,char *cpKey)*/
static int cache_srch(pCH, cpKey)
tdtCACHE_CTL_HEAD *pCH;
char *cpKey;
{
	tdtQUE_CTL *pCQ;
	tdtCACHE_CTL *pCt, *pCtBef;
	int i,iKeyLen,found;
	unsigned char ucOpt;

	if (!pCH) return -1;
	if (!(pCQ=pCH->ch_pque)) return -1;
	pCH->ch_entry = 0;
	pCH->ch_pentry = NULL;
	if (!cpKey) return -3;	/* add 1998.8.13 Koba */
	ucOpt   = pCH->ch_opt;
	iKeyLen = pCH->ch_keylen;
	i = 0;
	akxs_que_move(pCQ,QUE_TOP);
	while (akxs_que_peek(pCQ,QUE_CUR,&pCt) > 0) {
		if (pCt->ca_key) {	/* add 1998.8.13 Koba */
			if (ucOpt&AKX_CACHE_FIXEDKEYL) {
				found = !memcmp(cpKey,pCt->ca_key,iKeyLen);
			}
			else {
/*
printf("cache_srch: cpKey=[%s] i=%d pCt=%08x cpCKey=%08x CKey=[%s]\n",
cpKey,i,pCt,pCt->ca_key,pCt->ca_key);
*/
				found = !strcmp(cpKey,pCt->ca_key);
			}
			if (found) {
				if (i > 0) {
					akxs_que_get(pCQ,QUE_CUR,NULL);
					akxs_que_put(pCQ,QUE_TOP,pCt);
				}
				pCH->ch_entry = 1;
				pCH->ch_pentry = pCt;
				return 1;
			}
		}
		akxs_que_move(pCQ,QUE_NEXT);
		i++;
	}
	return 0;
}

/*int akxs_cache_del(tdtCACHE_CTL_HEAD *pCH,char *cpKey)*/
int akxs_cache_del_que(pCH, cpKey)
tdtCACHE_CTL_HEAD *pCH;
char *cpKey;
{
	tdtCACHE_CTL *pCt;
	int iRc;

	if ((iRc=cache_srch(pCH,cpKey)) > 0) {
		akxs_que_get(pCH->ch_pque,QUE_TOP,&pCt);
		cache_free(pCH->ch_opt,pCH->ch_pentry);
		pCH->ch_smax--;
	}
	return iRc;
}

/***************************************************/
/*  ret < 0 : error                                */
/*      = 0 : o^Gg󂫂Ȃ                 */
/*      > 0 : o^Ggԍ                     */
/***************************************************/
/*int akxs_cache_set(tdtCACHE_CTL_HEAD *pCH,tdtCACHE_CTL *pCt0)*/
int akxs_cache_set_que(pCH, pCt0)
tdtCACHE_CTL_HEAD *pCH;
tdtCACHE_CTL *pCt0;
{
	tdtCACHE_CTL **ppCt, *pCt, *pOldCt;
	int iRc, i, iKeyLen, iCmpLen, iMax, iCshLen, iOldTime, iOldCt;
	unsigned char ucOpt;
	struct stat tStat;
	char *p;
	int t;

	if (!pCt0) return -25;	/* add 2001.1.26 Koba */
	if (iRc=cache_srch(pCH,pCt0->ca_key)) {
		if (iRc>0) {
			ucOpt   = pCH->ch_opt;
			iCshLen = pCH->ch_cshlen;
			pCt     = pCH->ch_pentry;
			if (ucOpt & AKX_CACHE_DATASAVE) {	/* malloc cache data area */
				if (!pCt0->ca_data) return -7;
				if (!pCt->ca_data) return -13;
				if (iCshLen <= 0) {
					if (iCshLen) {
						memcpy(&iCshLen,pCt0->ca_data,sizeof(INT4));
						iCshLen += sizeof(INT4);
					}
					else iCshLen = strlen(pCt0->ca_data) + 1;
					if (!(p=Realloc(pCt->ca_data,iCshLen))) {
						return -15;
					}
					pCt->ca_data = p;
				}
				memcpy(pCt->ca_data,pCt0->ca_data,iCshLen);
			}
			else pCt->ca_data = pCt0->ca_data;
			if (ucOpt & AKX_CACHE_NOAUTOEXT) {
				pCt->ca_chktime = akxe_get_msec(NULL,NULL);
/*
printf("akxs_cache_set:ChkTime=%d\n",pCt->ca_chktime);
*/
			}
		}
		return iRc;
	}
	else {
		if (!(pCt=(tdtCACHE_CTL *)Malloc(sizeof(tdtCACHE_CTL)))) return -3;
		memset(pCt,0,sizeof(tdtCACHE_CTL));
		if ((pCH->ch_smax>=pCH->ch_imax) &&
		    (pCH->ch_opt & AKX_CACHE_NOAUTOEXT)) {
			if (pCH->ch_prls) {
				cache_free(pCH->ch_opt,pCH->ch_prls);
				Free(pCH->ch_prls);
			}
			akxs_que_get(pCH->ch_pque,QUE_BOT,&(pCH->ch_prls));
		}
	}

	ucOpt   = pCH->ch_opt;
	iKeyLen = pCH->ch_keylen;
	iCmpLen = pCH->ch_cmplen;
	iCshLen = pCH->ch_cshlen;
	if (iCmpLen<=0) return -4;
	if (!pCt0->ca_key) return -5;
	if (!pCt0->ca_cmp1) return -6;
	if (ucOpt & AKX_CACHE_DATASAVE) {	/* malloc cache data area */
		if (!pCt0->ca_data) return -7;
	}

	if (ucOpt & AKX_CACHE_FIXEDKEYL) {	/* fixed len */
		if (iKeyLen<=0) return -8;
		if (!(pCt->ca_key=Malloc(iKeyLen))) return -9;
		memcpy(pCt->ca_key,pCt0->ca_key,iKeyLen);
	}
	else {	/* SZ */
		if (!(pCt->ca_key=Malloc(strlen(pCt0->ca_key)+1))) return -10;
		strcpy(pCt->ca_key,pCt0->ca_key);
	}

	if (!(pCt->ca_cmp2=Malloc(iCmpLen*2))) {
			cache_free(ucOpt,pCt);
			return -11;
	}
	if (ucOpt & AKX_CACHE_MEMCMP) {	/* memory */
		pCt->ca_cmp1 = pCt0->ca_cmp1;
		memcpy(pCt->ca_cmp2,pCt->ca_cmp1,iCmpLen);
	}
	else {	/* file */
		if (!(pCt->ca_cmp1=Malloc(strlen(pCt0->ca_cmp1)+1))) {
			cache_free(ucOpt,pCt);
			return -12;
		}
		strcpy(pCt->ca_cmp1,pCt0->ca_cmp1);	/* file name */
		if (stat(pCt->ca_cmp1,&tStat)) {
			if (ucOpt & AKX_CACHE_IGNCHKERR) {
				tStat.st_mtime = tStat.st_size = 0;
			}
			else {
				cache_free(ucOpt,pCt);
				return -21;
			}
		}
		tMod.my_mtime = tStat.st_mtime;
		tMod.st_size  = tStat.st_size;
		memcpy(pCt->ca_cmp2,(char *)&tMod,iCmpLen);
	}
	memset(pCt->ca_cmp2+iCmpLen,0,iCmpLen);
	if (ucOpt & AKX_CACHE_DATASAVE) {	/* malloc cache data area */
		if (iCshLen <= 0) {
			if (iCshLen) {
				memcpy(&iCshLen,pCt0->ca_data,sizeof(INT4));
				iCshLen += sizeof(INT4);
			}
			else iCshLen = strlen(pCt0->ca_data) + 1;
		}
		if (!(pCt->ca_data=Malloc(iCshLen))) {
			cache_free(ucOpt,pCt);
			return -15;
		}
		memcpy(pCt->ca_data,pCt0->ca_data,iCshLen);
	}
	else pCt->ca_data = pCt0->ca_data;
	if (pCH->ch_interval > 0) {
		pCt->ca_cmpnext = akxe_get_msec(NULL,NULL) + pCH->ch_interval;
/*
printf("akxs_cache_set:Key=[%s] CmpNext=%d\n",pCt->ca_key,pCt->ca_cmpnext);
*/
	}
	if (ucOpt & AKX_CACHE_NOAUTOEXT) {
		pCt->ca_chktime = akxe_get_msec(NULL,NULL);
/*
printf("akxs_cache_set:ChkTime=%d\n",pCt->ca_chktime);
*/
	}

	akxs_que_put(pCH->ch_pque,QUE_TOP,pCt);
	i = 1;
	pCH->ch_entry = i;
	pCH->ch_pentry = pCt;
	if ((pCH->ch_smax<pCH->ch_imax) ||
	    !(pCH->ch_opt & AKX_CACHE_NOAUTOEXT)) {
		if (++pCH->ch_smax > pCH->ch_imax) pCH->ch_imax++;
	}
	return i;
}

/***************************************************/
/*  ret < 0 : error                                */
/*      = 0 : LbV͗L                     */
/*      > 0 : LbV͖                     */
/***************************************************/
/*int akxs_cache_chk(tdtCACHE_CTL_HEAD *pCH,char *cpKey,tdtCACHE_CTL *pCt0)*/
int akxs_cache_chk_que(pCH, cpKey, pCt0)
tdtCACHE_CTL_HEAD *pCH;
char *cpKey;
tdtCACHE_CTL *pCt0;
{
	tdtCACHE_CTL **ppCt, *pCt;
	int iRc, iKeyLen, iCmpLen;
	unsigned char ucOpt;
	struct stat tStat;
	int t,ichk;

	if (!pCt0) return -25;	/* add 2001.1.26 Koba */
	if ((iRc=cache_srch(pCH,cpKey))>0) {
		ucOpt   = pCH->ch_opt;
		iCmpLen = pCH->ch_cmplen;
		pCt     = pCH->ch_pentry;
		if (pCH->ch_opt & AKX_CACHE_NOAUTOEXT) {
			pCt->ca_chktime = akxe_get_msec(NULL,NULL);
/*
printf("akxsCacheCheck:Key=[%s] ChkTime=%d\n",pCt->ca_key,pCt->ca_chktime);
*/
		}
		iRc = 0;
		if (ucOpt & AKX_CACHE_MEMCMP) {	/* memory */
			if (memcmp(pCt->ca_cmp2,pCt->ca_cmp1,iCmpLen)) {
				iRc = 1;
				memcpy(pCt->ca_cmp2+iCmpLen,pCt->ca_cmp2,iCmpLen);
				memcpy(pCt->ca_cmp2,pCt->ca_cmp1,iCmpLen);
			}
		}
		else {	/* file */
			ichk = 1;
			if (pCH->ch_interval > 0) {
				t = akxe_get_msec(NULL,NULL);
				if (t >= pCt->ca_cmpnext) {
/*
printf("akxsCacheCheck:Key=[%s] t=%d\n",pCt->ca_key,t);
*/
					pCt->ca_cmpnext = t + pCH->ch_interval;
				}
				else ichk = 0;
			}
			if (ichk) {
				if (stat(pCt->ca_cmp1,&tStat)) {
					if (ucOpt & AKX_CACHE_IGNCHKERR) {
						tStat.st_mtime = tStat.st_size = 0;
					}
					else return -21;
				}
				tMod.my_mtime = tStat.st_mtime;
				tMod.st_size  = tStat.st_size;
				if (memcmp(pCt->ca_cmp2,(char *)&tMod,iCmpLen)) {
					iRc = 1;
					memcpy(pCt->ca_cmp2+iCmpLen,pCt->ca_cmp2,iCmpLen);
					memcpy(pCt->ca_cmp2,(char *)&tMod,iCmpLen);
				}
			}
		}
		memcpy(pCt0,pCt,sizeof(tdtCACHE_CTL));
	}
	else if (!iRc) iRc = -22;
	return iRc;
}

/***************************************************/
/*  ret = 0 :                                  */
/*      < 0 : G[                               */
/***************************************************/
/*int akxs_cache_get(tdtCACHE_CTL_HEAD *pCH,int iEntry,tdtCACHE_CTL *pCt0)*/
int akxs_cache_get_que(pCH, iEntry, pCt0)
tdtCACHE_CTL_HEAD *pCH;
int iEntry;
tdtCACHE_CTL *pCt0;
{
	tdtQUE_CTL *pCQ;
	tdtCACHE_CTL **ppCt, *pCt;
	int i;

	if (!pCH) return -1;
	if (!pCt0) return -25;
	if (iEntry<0 || iEntry>pCH->ch_smax) return -26;
	if (!(pCQ=pCH->ch_pque)) return -1;
	if (iEntry) {
		i = 0;
		akxs_que_move(pCQ,QUE_TOP);
		while (akxs_que_peek(pCQ,QUE_CUR,&pCt) > 0) {
			i++;
			if (i == iEntry) break;
			akxs_que_move(pCQ,QUE_NEXT);
		}
	}
	else {
		akxs_que_get(pCQ,QUE_TOP,&pCt);
	}

	if (pCt) {
		memcpy(pCt0,pCt,sizeof(tdtCACHE_CTL));
		if (!iEntry) Free(pCt);
	}
	else {
		memset(pCt0,0,sizeof(tdtCACHE_CTL));
		return -22;
	}
	return 0;
}

int akxs_cache_ct_clear_que(ucOpt, pCt)
uchar ucOpt;
tdtCACHE_CTL *pCt;
{
	if (!pCt) return -1;
	cache_free(ucOpt, pCt);
	return 0;
}
