static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *	akxsbtree.c
 *
 *		  coded by A.Kobayashi 2003/11/28
 *
 *************************************************/
#include "akxcommon.h"
/*
#define BTREE_MAX_CELL	4
typedef struct tdtBTREE_CELL {
	struct tdtBTREE_NODE *next;
	int  key;
	char *keyp;
	char *datp;
} tdtBTREE_CELL;

typedef struct tdtBTREE_NODE {
	int max_cell;
	int used_cell;
	struct tdtBTREE_CELL node_cell[BTREE_MAX_CELL+1];
	struct tdtBTREE_NODE *next;
	struct tdtBTREE_NODE *prev;
} qBtreeNode;
*/

HASHB *akxsbtree_new(sKeyLen,sDatLen,iOpt)
short sKeyLen;
short sDatLen;
int   iOpt;
{
	HASHB *tph;

	if (!(tph=(HASHB *)Malloc(sizeof(HASHB)))) return NULL;
	memset(tph,0,sizeof(HASHB));
	tph->ha_id[0] = 'B';
	tph->ha_id[1] = 'T';
	tph->ha_keylen    = sKeyLen;
	tph->ha_maxreg = sDatLen;
	return tph;
}

static void _node_free(node)
tdtBTREE_NODE *node;
{
	int i;
	tdtBTREE_CELL *cell;

	if (node) {
		cell = &node->node_cell[0];
		for (i=0;i<node->used_cell;i++,cell++) {
			if (cell->keyp) Free(cell->keyp);
			if (cell->datp) Free(cell->datp);
			if (cell->next)  _node_free(cell->next);
		}
		if (node->next)  _node_free(node->next);
printf("_node_free: node=%08x\n",node);
		Free(node);
	}
}

int akxsbtree_free(tph)
HASHB *tph;
{
	if (tph) {
		if (tph->ha_reg) _node_free((tdtBTREE_NODE *)tph->ha_reg);
		Free(tph);
	}
	return 0;
}

static tdtBTREE_NODE *_btree_node_new(key,prev)
int key;
tdtBTREE_NODE *prev;
{
	tdtBTREE_NODE *node;

printf("_btree_node_new: key=%d prev=%08x\n",key,prev);
	if (node=(tdtBTREE_NODE *)Malloc(sizeof(tdtBTREE_NODE))) {
		memset(node,0,sizeof(tdtBTREE_NODE));
		node->max_cell = BTREE_MAX_CELL;
		node->node_cell[0].key = key;
		node->used_cell = 1;
		if (prev) prev->prev = node;
	}
	return node;
}

static int _btree_r(key,node)
int key;
tdtBTREE_NODE *node;
{
	int i,d;
	tdtBTREE_CELL *cell;

printf("_btree_r: key=%d node=%08x\n",key,node);
	if (node) {
		cell = &node->node_cell[0];
		for (i=0;i<node->used_cell;i++,cell++) {
			d = key - cell->key;
printf("_btree_r: cell->key=%d d=%d\n",cell->key,d);
			if (d < 0) return _btree_r(key,cell->next);
			else if (!d) return 1;
		}
		return _btree_r(key,node->next);
	}
	return 0;
}

int _btree_proc(func,tph)
char  func;
HASHB *tph;
{
	int keylen,klen,d,aklen,adlen,ret,key;
	char *p1,*p2;
	tdtBTREE_NODE *prev,*node,*next,*next_r,*next_l;

	if (!tph) return -1;
	if (!(p1=tph->ha_key)) return -2;
	keylen = tph->ha_keylen;
	next = (tdtBTREE_NODE *)tph->ha_reg;
	key = atoi(p1);
/**********
	if ((klen=akxt_get_gep_data(keylen,p1,&p1,&aklen))<0) return -3;
if (!keylen) printf("_bins_proc: func=%c key=[%s]\n",func,p1);
***/
	if (func=='S') {
		if (node=(tdtBTREE_NODE *)tph->ha_reg) {
			ret = _bins_s(key,node);
		}
		else {
			if (!(node=_btree_node_new(key,NULL))) return -12;
			tph->ha_reg = (char *)node;
printf("_btree: s: %c node=%08x\n",func,node);
			ret = 0;
		}
		return ret;
	}
	else if (func=='D') {
#if 0
		if (leaf && !d) {
			/* 폜ꂽleafNĂPOrightNB
			   rightNULL̂Ƃ́AleftNB*/
			next_r = leaf->right;
			next_l = leaf->left;
			if (next_r) next = next_r;
			else next = next_l;
printf("_binsrs: d: %c prev=%08x leaf=%08x L=%08x R=%08x next=%08x\n",
func,prev,leaf,next_l,next_r,next);
			if (prev) {
				/* POleafNĂnextN */
				if (prev->right == leaf)
					prev->right = next;
				else
					prev->left = next;
			}
			else {
				tph->ha_reg = (char *)next;
				prev = next;
			}
			/* rightNꂽ̂Aright͓o^B */
			if (next_r && next_l) {
				if (ret=_bins_s_leaf(keylen,next,next_l)) return ret;
			}
			_bins_count_leaf(prev);
			leaf->right = NULL;
			leaf->left  = NULL;
			_leaf_free(leaf);
			ret = 1;
		}
#endif
	}
	else {
		ret = _btree_r(key,next);
	/*
		if (leaf && !d) {
			tph->ha_nextp = (int *)leaf->datp;
			ret = 1;
		}
	*/
	}
	return ret;
}

int _bins_s(key,node)
int key;
tdtBTREE_NODE *node;
{
	int ret,d,i,j;
	tdtBTREE_NODE *next;
	tdtBTREE_CELL *cell;

printf("_btree_s: key=%d node=%08x\n",key,node);
	ret = 0;
	if (node) {
		cell = &node->node_cell[0];
		for (i=0;i<node->used_cell;i++,cell++) {
			d = key - cell->key;
printf("_btree_s: i=%d cell->key=%d d=%d\n",i,cell->key,d);
			if (d < 0) break;
			else if (!d) return 1;
		}
		if (d > 0) {
			if (node->used_cell < node->max_cell) {
				cell = &node->node_cell[node->used_cell++];
				cell->key = key;
printf("_btree_s: node->used_cell=%d\n",node->used_cell);
			}
			else {
				if (node->next) _bins_s(key,node->next);
				else {
					if (!(next=_btree_node_new(key,node))) return -12;
					node->next = next;
				}
			}
		}
		else {
			if (cell->next) _bins_s(key,cell->next);
			else {
				if (node->used_cell < node->max_cell) {
					for (j=node->used_cell;j>i;j--) {
						node->node_cell[j] = node->node_cell[j-1];
printf("_btree_s: j=%d cell->key=%d\n",j,node->node_cell[j].key);
					}
					cell->key = key;
					node->used_cell++;
printf("_btree_s: node->used_cell=%d\n",node->used_cell);
				}
				else {
					if (!(next=_btree_node_new(key,node))) return -12;
					cell->next = next;
				}
			}

		}
	}
	return ret;
}
