static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi(CSK) 2010.7.7	*/
/*											*/
/********************************************/
#include	"akxcommon.h"

static MPA _MMAX = {
	'M','P',
	 0, /* opt  */
	52,	/* alen */
	51,	/* len  */
MAXEXP,	/* exp  */
	 1,	/* sign */
	 0,	/* zero */
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 0};

static MPA _M0 = {
	'M','P',
	0,  /* opt  */
	52,	/* alen */
	0,	/* len  */
	0,	/* exp */
	1,	/* sign */
	1,	/* zero */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0};

static MPA _M1 = {
	'M','P',
	0,  /* opt  */
	52,	/* alen */
	1,	/* len  */
	0,	/* exp */
	1,	/* sign */
	0,	/* zero */
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0};

static char _MVMAX_num[52]={
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	 9, 0};
static MPAV _MVMAX = {
	'M','V',
	0,  /* opt  */
	52,	/* alen */
	51,	/* len  */
MAXEXP,	/* exp  */
	 1,	/* sign */
	 0,	/* zero */
	_MVMAX_num};

static char _MV0_num[52]={
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0};
static MPAV _MV0 = {
	'M','V',
	0,  /* opt  */
	52,	/* alen */
	0,	/* len  */
	0,	/* exp */
	1,	/* sign */
	1,	/* zero */
	_MV0_num};

static char _MV1_num[52]={
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0};
static MPAV _MV1 = {
	'M','V',
	0,  /* opt  */
	52,	/* alen */
	1,	/* len  */
	0,	/* exp */
	1,	/* sign */
	0,	/* zero */
	_MV1_num};

/********************************/
/*								*/
/********************************/
MPAV *mv_get_i(int i)
{
	if (i==1) return &_MV1;
	else return &_MV0;
}

/********************************/
/*								*/
/********************************/
MPAV *mv_get_MMAX()
{
	return &_MVMAX;
}

/********************************/
/*								*/
/********************************/
MPAV *mv_cpy(MPAV *d,MPAV *s,int iCPY)
{
	short opt;

	if (d != s) {
		if (iCPY == 1) {
			if ((d->alen && !d->num) || (s->alen && !s->num)) return NULL;
			if (s->len && (!d->num || d->alen<=s->len)) return NULL;
			d->id[0] = s->id[0];
			d->id[1] = s->id[1];
			d->len  = s->len;
			d->exp  = s->exp;
			d->sign = s->sign;
			d->zero = s->zero;
			d->opt = (s->opt & ~MPA_DATA_MALLOC) | (d->opt & MPA_DATA_MALLOC);
			if (s->len) memcpy(d->num,s->num,s->len);
			if (d->num) memset(d->num+d->len,0,d->alen-d->len);
		}
		else {
			memcpy(d,s,sizeof(MPAV));
			if (!iCPY) {
				if (s->alen && !s->num) return NULL;
				if (!s->len && !s->num) {
					if (d->num = Malloc(1)) {
						d->num[0] = 0;
						d->opt |= MPA_DATA_MALLOC;
						d->alen = 1;
					}
					else d = NULL;
				}
				else if (d->num = Memdup(s->num,s->len+1)) {
					d->opt |= MPA_DATA_MALLOC;
					d->alen = s->len + 1;
				}
				else d = NULL;
			}
		}
	}
	return d;
}

/********************************/
/*								*/
/********************************/
MPAV *mv_dup(MPAV *s)
{
	MPAV *d;

	if (d = (MPAV *)Malloc(sizeof(MPAV))) d = mv_cpy(d,s,0);
	return d;
}

/********************************/
/*								*/
/********************************/
MPAV *mv_set0(MPAV *a)
{
	a->opt = 0;
	a->len = 0;
	a->exp = 0;
	a->sign = 1;
	a->zero = 1;
	memset(a->num,0,a->alen+1);
	return a;
}

/********************************/
/*	mv_set_an	MPAV <-- "123"	*/
/********************************/
int mv_set_an(MPAV *a, char *s, int len_s)
{
	char *p,cc;
	int c, exp, i, pflag, sign, nzflag, pos, n, j, syo, lens, ret, at;
	char *q;
	int  alen;

	if (!a || !s) return -1;
	lens = len_s;
	p = s;
	sign = 1;
	while ((lens > 0) && (cc = *p)) {
		if(cc == '-') sign = 0;
		else if(cc!='+' && cc!=' ') break;
		p++;
		lens--;
	}
	memcpy(a->id,"MV",2);
	alen = lens + 1;
	if (!(a->num=Malloc(alen))) return -2;
	a->opt = MPA_DATA_MALLOC;
	a->alen = alen;
	a->num[0] = 0;
	a->zero = 0;
	at = ret = pos = exp = syo = 0;
	pflag = nzflag = 0;
	while ((lens-- > 0) && (cc = *p++)) {
		at++;
		if (cc == '.') {
			if (pflag) {
			/*	fprintf(stderr, "Error : Illegal point in mv_set_a()\n");	*/
			/*	*a = _MV0;
				return -2;	*/
				ret = at;
				break;
			}
			if (at==1) syo--;
			pflag = 1;
		}
		else if (cc=='E' || cc=='e') {
			exp += atoi(p);
			break;
		}
		else if(cc == '+' || cc == '-') {
			exp += atoi(p-1);
			break;
		}
		else {
			c = cc - '0';
			if (c<0 || c>9) {
			/*	fprintf(stderr, "Error : Illegal digit(%c)  in mv_set_a()\n",cc);	*/
			/*	*a = _MV0;
				return -3;	*/
				ret = at;
				break;
			}
			if (c) nzflag = 1;
			if (pos < alen) {
				if (nzflag) a->num[pos++] = c;
				else syo--;
				if (!pflag) exp++;
			}
		}
	}
/*
printf("mv_set_an: exp=%d\n",exp);
*/
	if (exp) exp--;
	if (syo) exp += syo;
	a->exp  = exp;
	a->sign = sign;
	a->len  = pos;
	if ((at=mv_normalize(a)) < 0) ret = at;
	return ret;
}

/********************************/
/*	mv_set_a	MPA <-- "123"	*/
/********************************/
int mv_set_a(MPAV *a, char *s)
{
	if (!s) return -1;
	return mv_set_an(a,s,strlen(s));
}

MPAV *mv_pset_an(MPAV *a, char *s, int len)
{
	int ret;
	ret = mv_set_an(a,s,len);
	if (ret) return &_MV0;
	return a;
}

MPAV *mv_pset_a(MPAV *a, char *s)
{
	if (!s) return &_MV0;
	return mv_pset_an(a,s,strlen(s));
}

/********************************/
/*								*/
/********************************/
int mv_normalize(MPAV *a)
{
	int pos,i,n,exp,sgn;
	char *q,*r;

	sgn = a->sign;
	exp = a->exp;
	pos = a->len;
	q = a->num + pos - 1;
	while (pos>0 && !*q--) pos--;
	if (pos) {
		i = 0;
		q = a->num;
		while (i<pos && !*q) {
			i++;
			q++;
		}
		if (i > 0) {
			n = i;
			r = a->num;
			for (;i<pos;i++) {
				*r++ = *q;
				*q++ = 0;
			}
			pos -= n;
			exp -= n;
		}
	}
	else {
		a->sign = 1;
		exp  = 0;
		a->zero = 1;
	}
	if (pos > a->alen-1) {
		pos = a->alen-1;
		a->num[pos] = 0;
	}
	a->len  = pos;

	if (exp > MAXEXP) {
	/*	fprintf(stderr, "Error : Overflow  in mv_mul()\n");	*/
		if (!mv_cpy(a,&_MVMAX,0)) return MPA_ERR_MALLOC;
		a->sign = sgn;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
	/*	fprintf(stderr, "Error : Underflow  in mv_mul()\n");	*/
		*a = _MV0;
		return MPA_ERR_UNDERFLOW;
	}
	a->exp = exp;
	return 0;
}

/********************************/
/*								*/
/********************************/
int mv_cmp(MPAV *a, MPAV *b)
{
	int mca;

	if (!a || !b) return -1;
	if (a->zero) {
		if (b->zero) return 0;
		return (b->sign == 1)? -1: 1;
	}
	if (b->zero) return (a->sign == 1)? 1: -1;
	if (a->sign == b->sign) {
		mca = mv_cmp_a(a, b);
		return (a->sign == 1)? mca: -mca;
	}
	return (a->sign == 1)? 1: -1;
}

/****************************************/
/*	mv_cmp_a	   compare |MPAV| vs |MPAV|	*/
/****************************************/
int mv_cmp_a(MPAV *aa, MPAV *bb)
{
/*	MPA a, b;	*/
	int i,a_exp,b_exp,len;
	char *p, *q;

	if (!aa || !bb) return -1;
	if (aa->zero) return (bb->zero)? 0: -1;
	if (bb->zero) return 1;
/*
	a = *aa;
	b = *bb;
	while (a.num[0] == 0 && a.exp != MINEXP) {
		for(i = 0, p = a.num, q = p + 1; i < NMPA; i++)	*p++ = *q++;
		*p = 0;
		a.exp--;
	}
	while (b.num[0] == 0 && b.exp != MINEXP) {
		for(i = 0, p = b.num, q = p + 1; i < NMPA; i++)	*p++ = *q++;
		*p = 0;
		b.exp--;
	}
*/
	if ((a_exp=aa->exp) > (b_exp=bb->exp)) return 1;
	else if (a_exp < b_exp) return -1;

	len = X_MIN(aa->len,bb->len) + 1;
	for(i = 0, p = aa->num, q = bb->num; i <= len; i++, p++, q++)
		if(*p != *q) return (*p > *q)? 1: -1;
	return 0;
}

/****************************************/
/*	mv_add	MPAV c <-- MPAV a + MPAV b	*/
/****************************************/
int mv_add(MPAV *c, MPAV *a, MPAV *b)
{
	int cmp,ret;

	if(a->zero)	{
		mv_cpy(c,b,0);
		return 0;
	}
	else if (b->zero) {
		mv_cpy(c,a,0);
		return 0;
	}
	ret = 0;
	if (a->sign == b->sign) {
		ret = mv_add_a(c, a, b);
		c->sign = a->sign;
	}
	else {
		cmp = mv_cmp_a(a, b);
		if(!cmp) {
			mv_cpy(c,&_MV0,0);
			return 0;
		}
		else if (cmp > 0) {
			ret = mv_sub_a(c, a, b);
			c->sign = a->sign;
		}
		else {
			ret = mv_sub_a(c, b, a);
			c->sign = b->sign;
		}
	}
/*
mv_print("mv_add:",c,1);
*/
	return ret;
}

/****************************************/
/*	mv_sub	MPAV c <-- MPAV a - MPAV b	*/
/****************************************/
int mv_sub(MPAV *c, MPAV *a, MPAV *b)
{
	int cmp,ret;

	if (a->zero) {
		if (b->zero) {
			mv_cpy(c,&_MV0,0);
			return 0;
		}
		b->sign = 1 - b->sign;
		mv_cpy(c,b,0);
		return 0;
	}
	if (b->zero) {
		mv_cpy(c,a,0);
		return 0;
	}
	else if (a->sign != b->sign) {
		ret = mv_add_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	cmp = mv_cmp_a(a, b);
	if (!cmp) {
		*c = _MV0;
		return 0;
	}
	else if (cmp > 0) {
		ret = mv_sub_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	ret = mv_sub_a(c, b, a);
	c->sign = 1 - b->sign;
	return ret;
}

/************************************************/
/*	mv_add_a	   MPAV ans <-- |MPAV a| + |MPAV b|	*/
/************************************************/
int mv_add_a(MPAV *ans, MPAV *a, MPAV *b)
{
	MPAV c,*pc,*pa,*pb;
	char *pan,*pbn,*p;
	int i, u, n, ia, ib, ia1, len1;

	if (!ans || !a || !b) return -1;
	if ((a->alen && !a->num) || (b->alen && !b->num)) return MPA_ERR_INVALID;
	if (a->zero) {
		mv_cpy(ans,b,0);
		return 0;
	}
	if (b->zero) {
		mv_cpy(ans,a,0);
		return 0;
	}
	if (a->exp >= b->exp) {
		mv_cpy(&c,a,0);
		pb = b;
	}
	else {
		mv_cpy(&c,b,0);
		pb = a;
	}
	pa = &c;
	c.zero = 0;
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib)+1 > (n=pa->alen-1)) {
		if (pa->opt & MPA_DATA_MALLOC) {
			if (!(p = Realloc(pa->num,ia+2))) return -2;
		}
		else {
			if (!(p = Malloc(ia+2))) return -2;
			pa->opt |= MPA_DATA_MALLOC;
		}
		pa->num = p;
		memset(p+n,0,ia+2-n);
		pa->alen = ia + 2;
	}
	len1 = pa->len - 1;
	ia1 = ia + 1;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	u = 0;
	while (ib-- >= 0) {
		u += *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) >= RADIX) {
			n = u - RADIX;
			u = 1;
		}
		else u = 0;
		*pan-- = n;
	}
/*
printf("mv_add_a: ia=%d u=%d *pan=%d\n",ia,u,*pan);
*/
	if (u) {
		while (ia-- >= 0) {
			u += *pan;
			if ((n=u) >= RADIX) {
				*pan-- = u - RADIX;
				u = 1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
			if (pa->len < pa->alen) pa->len++;
			i = pa->len;
			pan = pa->num + i;
			pbn = pan - 1;
			while (i-- > 0) *pan-- = *pbn--;
			pa->num[0] = u;
			pa->exp++;
		}
	}
	if (ia1 > pa->len) pa->len = ia1;
	*ans = c;
	return mv_normalize(ans);
}

/************************************************/
/*	mv_sub_a	MPAV ans <-- |MPAV a| - |MPAV b|	*/
/************************************************/
int mv_sub_a(MPAV *ans, MPAV *a, MPAV *b)
{
	MPAV c,*pc,*pa,*pb;
	char *pan,*pbn,*p;;
	int u, n, ia, ib, ia1, len1, len;

	if (!ans || !a || !b) return -1;
	if ((a->alen && !a->num) || (b->alen && !b->num)) return MPA_ERR_INVALID;
	c.sign = 1;
	pa = &c;
	pb = b;
	mv_cpy(&c,a,0);
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib)+1 > (n=pa->alen-1)) {
		if (pa->opt & MPA_DATA_MALLOC) {
			if (!(p = Realloc(pa->num,ia+2))) return -2;
		}
		else {
			if (!(p = Malloc(ia+2))) return -2;
			pa->opt |= MPA_DATA_MALLOC;
		}
		pa->num = p;
		memset(p+n,0,ia+2-n);
		pa->alen = ia + 2;
	}
	len = pa->len;
	len1 = len - 1;
	ia1 = ia + 1;
	u = 0;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	while (ib-- >= 0) {
		u -= *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) < 0) {
			n = u + RADIX;
			u = -1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >=0) {
			u = *pan + u;
			if ((n=u) < 0) {
				*pan-- = u + RADIX;
				u = -1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
		/*	fprintf(stderr, "Error : |a| < |b|\n");	*/
			Free(c.num);
			mv_cpy(ans,&_MV0,0);
			return MPA_ERR_A_LT_B;
		}
	}
	if (ia1 > len) pa->len = ia1;
	*ans = c;
	return mv_normalize(ans);
}

/********************************/
/*	mv_add1	  MPAV a += MPAV b	*/
/********************************/
int mv_add1(MPAV *a, MPAV *b)
{
	MPAV c;
	int rc;

	if (!(rc = mv_add(&c,a,b))) {
	/*	if (a->opt & MPA_DATA_MALLOC) Free(a->num);	*/
		*a = c;
	}
	return rc;
}

/********************************/
/*	mv_sub1	  MPAV a -= MPAV b	*/
/********************************/
int mv_sub1(MPAV *a, MPAV *b)
{
	MPAV c;
	int rc;

	if (!(rc = mv_sub(&c,a,b))) {
	/*	if (a->opt & MPA_DATA_MALLOC) Free(a->num);	*/
		*a = c;
	}
	return rc;
}

/************************************/
/*	mv_add1_a.c |MPAV a| += |MPAV b|*/
/************************************/
int mv_add1_a(MPAV *a, MPAV *b)
{
	MPAV c;
	int rc;

	if (!(rc = mv_add_a(&c,a,b))) {
	/*	if (a->opt & MPA_DATA_MALLOC) Free(a->num);	*/
		*a = c;
	}
	return rc;
}

/************************************/
/*	mv_sub1_a   |MPAV a| -= |MPAV b|	*/
/************************************/
int mv_sub1_a(MPAV *a, MPAV *b)
{
	MPAV c;
	int rc;

	if (!(rc = mv_sub_a(&c,a,b))) {
	/*	if (a->opt & MPA_DATA_MALLOC) Free(a->num);	*/
		*a = c;
	}
	return rc;
}

/********************************************/
/*	mv_mul	  MPAV ans <-- MPAV a * MPAV b	*/
/********************************************/
int mv_mul(MPAV *ans, MPAV *a, MPAV *b)
{
	MPAV c;
	int i, j, m, *r, *xp, u, v, exp, alen;
	static int *x=NULL;
	char *p, *q;

	if (!ans || !a || !b) return -1;
	if ((a->alen && !a->num) || (b->alen && !b->num)) return MPA_ERR_INVALID;
	if (a->zero || b->zero) {
		mv_cpy(ans,&_MV0,0);
		return 0;
	}
	alen = a->len + b->len;
	m = alen - 1;
/*
printf("mv_mul: a->len=%d b->len=%d m=%d\n",a->len,b->len,m);
*/
	j = sizeof(int)*(alen+1);
	if (x) x = (int *)Realloc(x,j);
	else x = (int *)Malloc(j);
	memset(x,0,j);
	for (i=b->len-1, xp=x+m, p=b->num+i; i>=0; i--, xp--, p--) {
		if ((v = *p)) {
			j = a->len - 1;
			q = a->num + j;
			r = xp;
			if (v == 1) {
				while (j-- >= 0) *r-- += *q--;
			}
			else if (v == 2) {
				while (j-- >= 0) {
					u = *q--;
					*r-- += u<<1;
				}
			}
			else {
				while (j-- >= 0) *r-- += *q-- * v;
			}
		}
/*
printf("mv_mul: i=%d\n",i);
*/
	}
	i = m;
	xp = x + i;
	if (!(c.num = Malloc(alen+1))) return -2;
	c.opt = MPA_DATA_MALLOC;
	c.alen = alen + 1;
	mv_set0(&c);
	p = c.num + i;
	u = 0;
	while (i >= 0) {
		*xp += u;
		if (*xp >= RADIX) {
			u = *xp/RADIX;
			*xp %= RADIX;
		}
		else u = 0;
		*p = *xp;
		p--;
		xp--;
		i--;
	}

	exp = (int)a->exp + (int)b->exp + 1;
	if (exp > MAXEXP) {
		mv_cpy(ans,&_MVMAX,0);
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		mv_cpy(ans,&_MV0,0);
		return MPA_ERR_UNDERFLOW;
	}
	a->exp = exp;
	c.zero = 0;
	c.sign = (a->sign == b->sign)? 1: 0;
	c.exp = exp;
	c.len = m + 1;
	*ans = c;
	mv_normalize(ans);
	return 0;
}

/********************************************/
/*	mv_div	  MPAV ans <-- MPAV a / MPAV b	*/
/********************************************/
int mv_div(MPAV *ans, MPAV *aa, MPAV *b)
{
	MPAV c, a, t;
	int d, i, exp, mlen, rc;
	short b_sign,b_exp;
	char *pcn;

	if (!ans || !aa || !b) return -1;
	if ((aa->alen && !aa->num) || (b->alen && !b->num)) return MPA_ERR_INVALID;
	if (aa->zero) {
		mv_cpy(ans,&_MV0,0);
		return 0;
	}
	if(b->zero) {
	/*	fprintf(stderr, "Error : Divide by 0  in mv_div()\n");	*/
		mv_cpy(ans,&_MVMAX,0);
		return MPA_ERR_ZERODIVIDE;
	}
	exp = (int)aa->exp - (int)b->exp;
	if (exp > MAXEXP) {
		mv_cpy(ans,&_MVMAX,0);
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		mv_cpy(ans,&_MV0,0);
		return MPA_ERR_UNDERFLOW;
	}
	if (aa->len<=NMPA && b->len<=NMPA) return mv_m_div(ans,aa,b);

	if (!mv_cpy(&a,aa,0)) return -2;
	b_sign = b->sign;
	b_exp  = b->exp;
	c = _MV0;
	mlen = X_MAX(aa->len,NMPA);
	if (!(c.num=Malloc(mlen+1))) return -3;
	c.alen = mlen + 1;
	c.opt = MPA_DATA_MALLOC;
	c.zero = 0;
	c.sign = (a.sign == b->sign)? 1: 0;
	a.sign = b->sign = 1;
	c.exp = exp;
	a.exp = b->exp = 0;
	for (i=0,pcn=c.num;i<=mlen;) {
		for (d=0;d<10;d++) {
			mv_cpy(&t,&a,0);
			if (rc=mv_sub1(&a,b)) return rc;
			if (!a.sign) {
				Free(a.num);
				a = t;
				a.exp++;
				break;
			}
			Free(t.num);
		}
		if (d >= 10) {
			Free(a.num);
			return -4;
		}
		*pcn++ = d;
		i++;
		if (a.zero) break;
	}
	Free(a.num);
	c.len = i;
	*ans = c;
	mv_normalize(ans);
	b->sign = b_sign;
	b->exp  = b_exp;

	return 0;
}

/********************************/
/*	mv_mul1	  MPAV a *= MPAV b	*/
/********************************/
int mv_mul1(MPAV *a, MPAV *b)
{
	MPAV c;
	int rc;

	if ((rc = mv_mul(&c,a,b)) >= 0) {
	/*	if (a->opt & MPA_DATA_MALLOC) Free(a->num);	*/
		*a = c;
	}
	return rc;
}

/********************************/
/*	mv_div1	  MPAV a /= MPAV b	*/
/********************************/
int mv_div1(MPAV *a, MPAV *b)
{
	MPAV c;
	int rc;

	if ((rc = mv_div(&c,a,b)) >= 0) {
	/*	if (a->opt & MPA_DATA_MALLOC) Free(a->num);	*/
		*a = c;
	}
	return rc;
}

/********************************************/
/*	mv_m_div	  MPAV ans <-- MPAV a / MPAV b	*/
/********************************************/
int mv_m_div(MPAV *ans, MPAV *aa, MPAV *bb)
{
	MPA c, a, b;
	int rc;

	memcpy(&a,aa,sizeof(MPAV));
	memcpy(a.num,aa->num,aa->len);
	memset(a.num+aa->len,0,NMPA-aa->len);
	a.id[1] = 'P';
	memcpy(&b,bb,sizeof(MPAV));
	memcpy(b.num,bb->num,bb->len);
	memset(b.num+bb->len,0,NMPA-bb->len);
	b.id[1] = 'P';
	rc = m_div(&c,&a,&b);
	if (rc >= 0) {
		memcpy(ans,&c,sizeof(MPAV));
		ans->num = Memdup(c.num,c.len+1);
		ans->alen = c.len+1;
		ans->opt = MPA_DATA_MALLOC;
		ans->id[1] = 'V';
	}
/*
printf("mv_m_div: rc=%d\n",rc);
*/
	return rc;
}

/************************************/
/*	mv_pack		DEC a <-- MPA b	*/
/************************************/
int mv_pack(char *a, int dec_size, MPAV *b)
{
	int i,len,size,ret,dsize;
	char *pam,*pbm,c1,c2;

	if (!a || !b) return -1;
	if (b->alen && !b->num) return MPA_ERR_INVALID;

	pam = a;
	pbm = b->num;
	size = b->len;
	len = size/2;
	ret = len + 1;
	if (dec_size > 0) {
		if (size > dec_size) return MPA_ERR_SIZE_OVER;
		dsize = dec_size/2 + 1;
		for (i=0;i<dsize-ret;i++) *pam++ = '\0';
	}
	else dsize = ret;
	if (!(size % 2)) {
		c1 = *pbm++;
		*pam++ = c1 & 0x0f;
		len--;
	}
	for (i=0;i<len;i++) {
		c1 = *pbm++;
		c2 = *pbm++;
		*pam++ = c1<<4 | (c2 & 0x0f);
	}
	c1 = *pbm;
	if (b->sign) c2 = 0x0c;
	else c2 = 0x0d;
	*pam = c1<<4 | (c2 & 0x0f);
	return dsize;
}

/************************************/
/*	mv_unpack  MPAV a <-- DEC b		*/
/************************************/
int mv_unpack(MPAV *a, char *b, int size, int scale)
{
	int i,len;
	char *pam,*pbm,c,d;

	if (!a || !b) return -1;
	if (a->alen && !a->num) return MPA_ERR_INVALID;
/*
printf("mv_unpack: size=%d scale=%d\n",size,scale);
*/
	mv_cpy(a,&_MV0,0);
	if (size > a->alen-1) return MPA_ERR_SIZE_OVER;
	pam = a->num;
	pbm = b;
	len = size/2;
	if (!(size % 2)) {
		c = *pbm++;
/*
printf("mv_unpack:1: c=%02x\n",c);
*/
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		len--;
	}
	for (i=0;i<len;i++) {
		c = *pbm++;
/*
printf("mv_unpack:2: c=%02x\n",c);
*/
		*pam++ = d = c>>4 & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
	}
	c = *pbm;
/*
printf("mv_unpack:3: c=%02x\n",c);
*/
	*pam = d = c>>4 & 0x0f;
	if (d > 9) return MPA_ERR_INVALID;
	c &= 0x0f;
	if (c == 0x0d) a->sign = 0;
	else if (c==0x0c || !c) a->sign = 1;
	else return -1;
	a->exp = size - scale - 1;
	a->len = size;
	a->zero = 0;
/*	return mv_normalize(a);	*/
	return 0;
}

/********************************/
/*	mv_mpa2d						*/
/********************************/
int mv_mpa2d(MPAV *a, double *dval)
{
	double d;
	int i,exp;
	char *p, *q;

	if (!a || !dval) return -1;
	if (a->alen && !a->num) return MPA_ERR_INVALID;

	if (a->zero) {
		*dval = 0.0;
		return 0;
	}
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = (double)*p++;
	while (i-- > 0) {
		d = d * (double)RADIX + (double)*p++;
		exp--;
	}
	while (exp > 0) {
		d *= (double)RADIX;
		exp--;
	}
	while (exp < 0) {
		d /= (double)RADIX;
		exp++;
	}
	if (!a->sign) d = -d;
	*dval = d;
	return 0;
}

int mv_dset(double *dval, MPAV *a)
{
	return mv_mpa2d(a, dval);
}

/********************************/
/*	mv_mpa2l						*/
/********************************/
int mv_mpa2l(MPAV *a, long *val)
{
	int ret, i, exp;
	long d;
	char *p,c;

	if (!a || !val) return -1;
	if (a->alen && !a->num) return MPA_ERR_INVALID;
	*val = 0;
	if (a->zero || a->exp < 0) return 0;
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = *p++;
	ret = 0;
	while (exp-- > 0) {
		d *= RADIX;
		if (i-- > 0) d += *p++;
		if (d < 0) {
			ret = MPA_ERR_OVERFLOW_I;
		/*	fprintf(stderr, "Error : Overflow  in mv_iset_s()\n");	*/
			break;
		}
	}
	if (ret) {
		if (a->sign) d = LONG_MAX;
		else d = LONG_MIN;
	}
	else if (!a->sign) d = -d;
	*val = d;
	return ret;
}

/********************************/
/*	mv_mpa2i						*/
/********************************/
int mv_mpa2i(MPAV *a, int *val)
{
	int ret;
	long l=0;

	ret = mv_mpa2l(a,&l);
	*val = l;
	return ret;
}

/********************************/
/*	mv_mpa2an					*/
/********************************/
int mv_mpa2an(MPAV *a, char *s, int len_s, int opt)
{
	char *p;
	int lens,exp,len;
	char *pan,c;

	p = s;
	if (!a || !p) return -1;
	if (a->alen && !a->num) return MPA_ERR_INVALID;
	if ((lens=len_s) <= 0) return -1;
	lens--;
	if (a->zero) {
		if (opt&0x01) {
			if (lens > 0) {
				if (lens == 1) *p++ = '0';
				else if (lens >= 2) {
					*p++ = '.';
					*p++ = '0';
				}
			}
		}
		else {
			if (lens-- > 0) *p++ = '0';
			if ((opt&(0x02|0x04)) && lens-- > 0) *p++ = '.';
			if ((opt&0x04) && lens-- > 0) *p++ = '0';
		}
	}
	else {
		if (!a->sign && lens-- > 0) *p++ = '-';
		len = a->len;
		pan = a->num;
		if ((exp=a->exp) < 0) {
			if (!(opt&0x01) && lens-- > 0) *p++ = '0';
			if (lens-- > 0) *p++ = '.';
			exp++;
			while (exp++ < 0 && lens-- > 0) *p++ = '0';
			while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
		}
		else {
			while (exp-- >= 0 && lens-- > 0) {
				if (len > 0) {
					c = *pan++ + '0';
					len--;
				}
				else c = '0';
				*p++ = c;
			}
 			if ((len>0||(opt&(0x02|0x04))) && lens-- > 0) *p++ = '.';
			if (len > 0) {
				while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
			}
			else if ((opt&0x04) && lens>0) *p++ = '0';
		}
	}
	*p = '\0';
	return strlen(s);
}

/********************************/
/*	mv_i2mpa						*/
/********************************/
int mv_i2mpa(int val, MPAV *a)
{
	int n, exp, len, w;
	char *p, *q;

	mv_cpy(a,&_MV0,0);
	if(!(n=val)) return 0;
	a->zero = 0;
	if (n < 0) {
		a->sign = 0;
		n = -n;
	}
	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX;
		n /= RADIX;
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	return 0;
}

/********************************/
/*	mv_d2mpa						*/
/********************************/
int mv_d2mpa(double d, MPAV *m)
{
	int i,exp,len;
	char *p;
	double a;

	a = d;
	mv_cpy(m,&_MV0,0);
	if (a == 0.) return 0;
	m->zero = 0;
	if (a < 0.) {
		m->sign = 0;
		a = - a;
	}
	exp = 0;
	while (a >= (double)RADIX) {
		exp++;
		a /= (double)RADIX;
	}
	while (a < 1.) {
		exp--;
		a *= (double)RADIX;
	}
	p = m->num;
	i = 0;
	len = m->alen - 1;
	do {
		*p = (int)a;
		a -= (double)*p++;
		a *= (double)RADIX;
	} while(a != 0. && ++i <= len);
	m->len = i;
	for (i++; i <= NMPA; i++) *p++ = 0;
	m->exp = exp;
	return 0;
}

/********************************/
/*	mv_scale						*/
/********************************/
int mv_scale(MPAV *mpa,int precision,int scale,int opt)
/* opt=0:ľܓ/1:؎̂/2:؏グ  */
{
	MPAV p5;
	int pre_exp,i,sign,len,exp;
	char *p;

	if (!mpa) return -1;
	if (mpa->alen && !mpa->num) return MPA_ERR_INVALID;
	if (precision<=0 || precision>mpa->alen-1) return -2;
	if (mpa->zero) return 0;

	if ((opt & 0x03) != 0x01) {
		mv_cpy(&p5,mv_get_i(1),0);
		p5.sign = mpa->sign;
		if (opt & 0x02) {
			i = mpa->exp + 1 + scale;
			p = mpa->num + i;
			i = mpa->len - i;
			while (i-- > 0) {
				if (*p++) {
					p5.exp = -scale;
					mv_add1(mpa,&p5);	/* ؏グ*/
					break;
				}
			}
		}
		else {
			p5.exp = -(scale+1);
			p5.num[0] = 5;
			mv_add1(mpa,&p5);	/* ľܓ*/
		}
		if (mpa->zero) return 0;
	}
	pre_exp = precision - scale - 1;
	exp = mpa->exp;
	if (exp > pre_exp) {
		sign = mpa->sign;
		mv_set0(mpa);
		mpa->exp = pre_exp;
		mpa->sign = sign;
		mpa->len = precision;
		p = mpa->num;
		i = precision;
		while (i--) *p++ = 9;
		return MPA_ERR_OVERFLOW;
	}
	else if ((len=scale+exp+1) <= 0) {
		mv_set0(mpa);
	/*	return 12;	*/
	}
	else if ((i=mpa->len-len) > 0) {
		mpa->len = len;
		p = mpa->num + len;
		while (i-- > 0) *p++ = 0;
	}
	return 0;
}

/********************************/
/*	mv_print					*/
/********************************/
void mv_print(char *s, MPAV *a, int _short)
{
	int i;
	char *p;

	printf("%s\n", s);
	printf("exp =%d zero=%d\n", a->exp, a->zero);
	printf("len =%d alen=%d\n", a->len, a->alen);
	if (a->sign==1)	putchar('+');
	else			putchar('-');
	if (a->num) {
		for (i = 0, p = a->num; i < a->alen; i++) {
			printf("%d ",*p++);
		}
	}
	putchar('\n');
	return;
}

/********************************/
/*	mv_ll2mpa					*/
/********************************/
int mv_ll2mpa(off_t val, MPAV *a)
{
	off_t n;
	int exp, len, w, v[2], v1, v2;
	char *p, *q;

	if (sizeof(off_t) == sizeof(int)) return mv_i2mpa(val,a);
	mv_cpy(a,&_MV0,0);
	if(!(n=val)) return 0;
	a->zero = 0;
	if (n < 0) {
		a->sign = 0;
		n = -n;
	}
	memcpy(v,&n,sizeof(off_t));
	if (1 == htonl(1)) {
		v1 = v[0];
		v2 = v[1];
	}
	else {
		v1 = v[1];
		v2 = v[0];
	}
	if (!v1) return mv_i2mpa(v2,a);
	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX;
		n /= RADIX;
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	return 0;
}

/********************************/
/*	mv_is_mpa0					*/
/********************************/
int mv_is_mpa0(MPAV *a)
{
	if (!a) return 0;
	return a->zero;
}
