static char sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akbsub.c
 *
 *        coded by A.Kobayashi 2000.10.10
 *
 *************************************************/
#include "akbcommon.h"

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_prom_name(iReSet)
int iReSet;
{
	static char *cpName=NULL;

	if (!cpName || iReSet) {
		akb_get_proc_name3(AKB_PRID_PROM,AKB_PRNAME_PROM,&cpName);
	}
	return cpName;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_connect_prom_host(iRetry,iSleep,cpHost)
int  iRetry,iSleep;
char *cpHost;
{
	int iRc,n;
	char *p,service[256],*argv[2];

	p = akb_prom_name(0);
	iRc = akbgetakbservname(p,service);
	if (iRc <= 0) {
		ERROROUT2("ret=%d Not defined port no for %s in SERVICE section of akb.ini",iRc,p);
		if (!iRc) iRc = -101;
	}
	else {
		if (cpHost && *cpHost=='?') {
			n = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,D_KEYNAME_PROM_HOST,argv,2);
			if (n >= 2) cpHost = argv[1];
			else cpHost = NULL;
		}
		iRc = akb_connect(cpHost,service,iRetry,iSleep);
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_connect_prom(iRetry,iSleep)
int  iRetry,iSleep;
{
	return akb_connect_prom_host(iRetry,iSleep,NULL);
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_code_trans(pInfoParm, pInfoParmd)
tdtINFO_PARM     *pInfoParm, *pInfoParmd;   /* p[^\ */
{
	tdtGENERAL_DATA tParm, tParmd;
	int rc;

	memcpy(&tParm.gd_code,&pInfoParm->pi_code,4);
	memcpy(&tParmd.gd_code,&pInfoParmd->pi_code,4);
	tParm.gd_dlen = pInfoParm->pi_dlen;
	tParm.gd_data  = pInfoParm->pi_data;
	tParmd.gd_data = NULL;
	rc = akxt_code_trans(&tParm, &tParmd);
	pInfoParmd->pi_scale = tParmd.gd_scale;
	pInfoParmd->pi_dlen   = tParmd.gd_dlen;
	pInfoParmd->pi_data     = tParmd.gd_data;

	return rc;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_netm_name(iReSet)
int iReSet;
{
	static char *cpName=NULL;

	if (!cpName || iReSet) {
		akb_get_proc_name3(AKB_PRID_NETM,AKB_PRNAME_NETM,&cpName);
	}
	return cpName;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_my_apsys_id()
{
	char *p,Service[D_RECORD_BUFSIZE];

	if (!(p = akb_netm_name(0))) return -1;
	if (akbgetakbservname(p,Service) <= 0) return 0;
	return akb_get_port_no(Service);
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_error_code(iError,ipErrInfo)
int iError,*ipErrInfo;
{
	int iEr,iErU;

	if ((iEr=iError) < 0) iEr = -iEr;

	iErU = iEr / 10000;
	if (ipErrInfo) *ipErrInfo = iErU;

	if (iErU>=1 && iErU<=3) {
		iEr %= 10000;
		if (iEr <= 999) {
			iEr += 9000;
			if (iError < 0) iEr = -iEr;
			return iEr;
		}
	}

	return iError;
}

/************************************************************/
/*  this code is copyed from apache                         */
/************************************************************/
int akb_detach(opt)
int opt;
{
	int pid,x;

/***
	chdir("/");
***/
	if ((pid = fork()) > 0)
		exit(0);
	else if (pid < 0) {
		perror("fork");
		ERROROUT("unable to fork new process");
		if (opt & 0x01) return pid;
		else exit(1);
	}
	PRINTOUT("Change daemon mode OK.");
	PRINTOUT("Replace stdin,stdout,stderr with /dev/null");

	/* close out the standard file descriptors */
	if (freopen("/dev/null", "r", stdin) == NULL) {
		ERROROUT1("unable to replace stdin with /dev/null:%s",strerror(errno));
	/* continue anyhow -- note we can't close out descriptor 0 because we
	* have nothing to replace it with, and if we didn't have a descriptor
	* 0 the next file would be created with that value ... leading to
	* havoc.
	*/
	}
	if (freopen("/dev/null", "w", stdout) == NULL) {
		ERROROUT1("unable to replace stdout with /dev/null:%s",strerror(errno));
	}
	/* stderr is a tricky one, we really want it to be the error_log,
	* but we haven't opened that yet.  So leave it alone for now and it'll
	* be reopened moments later.
	*/
	if (freopen("/dev/null", "w", stderr) == NULL) {
		ERROROUT1("unable to replace stderr with /dev/null:%s",strerror(errno));
	}
	x = LOGFLG(D_LOG_NO_ERROR,D_LOG_FLG_CHECK);
	LOGFLG(D_LOG_NO_ERROR,x & ~(D_LOG_FLG_STDOUT | D_LOG_FLG_STDERR));
	x = LOGFLG(D_LOG_NO_PRINT,D_LOG_FLG_CHECK);
	LOGFLG(D_LOG_NO_PRINT,x & ~(D_LOG_FLG_STDOUT | D_LOG_FLG_STDERR));
	x = LOGFLG(D_LOG_NO_DEBUG,D_LOG_FLG_CHECK);
	LOGFLG(D_LOG_NO_DEBUG,x & ~(D_LOG_FLG_STDOUT | D_LOG_FLG_STDERR));

	return pid;
}

/************************************************************/
/*                                                          */
/************************************************************/
typedef struct {
    int err_no;
    char *errmsg;
} tdtErrMsgTbl;

static tdtErrMsgTbl errmsgtbl[]=
	{0 ,"No error"
	,D_ERR_PACKET_ID		,ERRMSG_PACKET_ID
	,D_ERR_NO_PASSWORD		,ERRMSG_NO_PASSWORD
	,D_ERR_UNKNOWN_CMD		,ERRMSG_UNKNOWN_CMD
	,D_ERR_UNKNOWN_CLASS	,ERRMSG_UNKNOWN_CLASS
	,ERR_PR_PID_INVALID		,ERRMSG_PID_INVALID
	,ERR_PR_PID_REGISTED	,ERRMSG_PID_REGISTED
	,ERR_PR_ENTRY_USED		,ERRMSG_ENTRY_USED
	,ERR_PR_PID_EXECUTED	,ERRMSG_PID_EXECUTED
	,ERR_PR_PID_NOT_FOUND	,ERRMSG_PID_NOT_FOUND
	,ERR_TR_PID_INVALID		,ERRMSG_PID_INVALID
	,ERR_TR_PID_REGISTED	,ERRMSG_PID_REGISTED
	,ERR_TR_NO_ENTRY		,ERRMSG_NO_ENTRY
	,ERR_PR_NO_SYSTEM_PID	,ERRMSG_NO_SYSTEM_PID
	,D_ERR_NO_PROCESS		,ERRMSG_NO_PROCESS
	,D_ERR_RCO_RECVPROC		,ERRMSG_NOT_RECVPROC
	,D_ERR_MEM_ALLOC		,ERRMSG_MEM_ALLOC
	,D_ERR_FORM_CHANGE		,ERRMSG_FORM_CHANGE
	,D_ERR_SOCKET_CLOSED	,ERRMSG_SOCKET_CLOSED
	,D_ERR_SHUT_MODE		,ERRMSG_SHUT_MODE
	,D_ERR_SHUT_WAKEUP		,ERRMSG_SHUT_WAKEUP
	,D_ERR_MSG_TIMEOUT		,ERRMSG_MSG_TIMEOUT
	,D_ERR_NO_NETM			,ERRMSG_NO_NETM
	,0 ,NULL
	};

char *akb_str_error(err_no)
int err_no;
{
	int err;
	tdtErrMsgTbl *e;
	char *msg;

	err = akb_error_code(err_no,NULL);
	for (e=&errmsgtbl[0];msg=e->errmsg;e++) {
		if (err == e->err_no) {
			return msg;
		}
	}
	return "";
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_text_addr4(in, buf, len)
struct in_addr in;
char *buf;
int  len;
{
	char *p;

	if (!buf || len<=0) return -1;
#if 0
	if (!inet_ntop(AF_INET,&in,buf,len)) {
		*buf = '\0';
		return -2;
	}
#else
	if (p = inet_ntoa(in)) {
		strnzcpy(buf,p,len-1);
	}
	else {
		*buf = '\0';
		return -2;
	}
#endif
	return 0;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_get_str_addr4(in)
struct in_addr in;
{
	static char buf[16];

	akb_get_text_addr4(in, buf, sizeof(buf));
	return buf;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_akb_help_dir(iReSet)
int iReSet;
{
	static int iAkbHelp=1;
	static char *cpHelp=NULL;
	char *argv[2];
	int n;


	n = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,D_KEYNAME_HELP_DIR,argv,2);
	if (n < 2) {
		if (iAkbHelp || iReSet) {
			iAkbHelp = 0;
			cpHelp = getenv(AKB_HELP);
		}
		return cpHelp;
	}
	else {
/*
printf("akb_akb_help_dir: [%s] [%s]\n",argv[0],argv[1]);
*/
		return argv[1];
	}
}
