static  char    sccsid[]="%Z% %M% %I% %D% %T%";

#include	"akbcommon.h"

static char *gcpLogOutBuf=NULL;
static int giLogFlg[D_LOG_NO_MAX]=
	{D_LOG_FLG_STDOUT | D_LOG_FLG_FILE
	,D_LOG_FLG_STDOUT | D_LOG_FLG_FILE | D_LOG_FLG_NO_SRC
	,D_LOG_FLG_NONE
	,D_LOG_FLG_NONE};
static char *gcLogFile[D_LOG_NO_MAX]={NULL,NULL,NULL,NULL};
static uchar gucLogLevel[D_LOG_NO_MAX]={0,0,0,0};
static char *gcpLogDir=NULL;

#define TRACE_FILE	"trace.dump"
static char *gcpTraceFile=NULL;
static uchar gucTrace[256];

static char *gcpProcName=NULL;

/********************************************/
/*                                          */
/********************************************/
int akb_log_out_level_main(log_no,level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  log_no,level,line;
{
	FILE   *fp, *fo=NULL;
	char   *buf, *cpPath, *cpProc, *log_file, *p;
	int    iLogFlg,iLogLevel;
	static char *cpPath2=NULL,*cpPath3=NULL;

	if ((iLogLevel=akb_log_level(log_no,D_LOG_LEVEL_CHECK))<0) return iLogLevel;
	if (iLogLevel < level) return 0;

	if ((iLogFlg=akb_log_flg(log_no,D_LOG_FLG_CHECK))<0) return iLogFlg;

	if (!(cpProc=akb_log_get_proc_name())) cpProc = "";

	if (iLogFlg & D_LOG_FLG_STDOUT) fo = stdout;
	if (iLogFlg & D_LOG_FLG_STDERR) fo = stderr;

	if (iLogFlg & D_LOG_FLG_FILE) {
		if (log_file = akb_log_set_file_name(log_no, NULL)) {
#if 0	/* 2000.12.12 Koba */
			cpPath = akb_akb_home_add(akxt_add_dir(gcpLogDir,log_file));
#else
			p = akxt_add_dir2(gcpLogDir,log_file,&cpPath2);
			if (!p) p = log_file;
			cpPath = akxt_add_dir2(akb_akb_home(0),p,&cpPath3);
			if (!cpPath) cpPath = p;
#endif
			fp = fopen(cpPath, "a");
			if (fp) {
				if (!(iLogFlg & D_LOG_FLG_NO_TIME)) {
					buf = akb_log_time();
					if (*buf){
						fprintf(fp,"%s ",buf);
					}
				}
				if (!(iLogFlg & D_LOG_FLG_NO_SRC))
					fprintf(fp, "%s/%s(%d): ", cpProc, file, line);
				else if (!(iLogFlg & D_LOG_FLG_NO_PROC))
					fprintf(fp, "%s: ", cpProc);
				fprintf(fp, format, a1, a2, a3, a4, a5);
				fprintf(fp, "\n");
				fclose(fp);
			}
#ifdef NOTICE
			else {
				if (fo) fprintf(fo,"%s(%d): log file[%s] open error %d\n",
					            file,line,cpPath,errno);
			}
#endif
		}
	}
	if (fo) {
		if (*cpProc && !(iLogFlg & D_LOG_FLG_NO_PROC))
			fprintf(fo,"[%s] ", cpProc);
		else if (!(iLogFlg & D_LOG_FLG_NO_SRC))
			fprintf(fo,"%s(%d): ", file, line);
		fprintf(fo,format, a1, a2, a3, a4, a5);
		fprintf(fo,"\n");
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_out_main(log_no,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  log_no,line;
{
	return akb_log_out_level_main(log_no,0,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out_m(file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  line;
{
	if (!akb_log_set_file_name(D_LOG_NO_ERROR, NULL))
		akb_log_set_file_name(D_LOG_NO_ERROR, ERROR_LOG_FILE);
	return akb_log_out_main(D_LOG_NO_ERROR,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_out(file,line,msg)
char *file,*msg;
int  line;
{
	akb_error_out_m(file,line,"%s",msg,NULL,NULL,NULL,NULL);
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_outRc(file,line,msg,rc)
char *file,*msg;
int  line,rc;
{
	akb_error_out_m(file,line,"%s %d",msg,rc,NULL,NULL,NULL);
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_outS(file,line,format,msg)
char *file,*msg,*format;
int  line;
{
	akb_error_out_m(file,line,format,msg,NULL,NULL,NULL,NULL);
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_debug_out_level(level,file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  level,line;
{
	if (!akb_log_set_file_name(D_LOG_NO_DEBUG, NULL))
		akb_log_set_file_name(D_LOG_NO_DEBUG, DEBUG_LOG_FILE);
	return akb_log_out_level_main(D_LOG_NO_DEBUG,level,file,line,format,a1,a2,a3,a4,a5);
}
/********************************************/
/*                                          */
/********************************************/
int akb_debug_out_m(file,line,format,a1,a2,a3,a4,a5)
char *file,*format,*a1,*a2,*a3,*a4,*a5;
int  line;
{
	return akb_debug_out_level(0,file,line,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
int akb_debug_input(file,line,msg,x,pi)
char *file,*msg;
int  line, x, *pi;
{
	char buf[64];

    printf("%s(%d): %s %d ==> ", file, line, msg, x);
	gets(buf);
	if (pi && *buf) *pi = atoi(buf);
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_flg(i,f)
int i,f;
{
	if (i>=0 && i<D_LOG_NO_MAX) {
		if (f >= 0) giLogFlg[i] = f;
	}
	else {
		return -1;
	}

	return giLogFlg[i];
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_out(msg)
char *msg;
{
	char *p, c='\0';
	int len, ret;

	if (!msg) msg = akb_log_buf(0);
	if ((len = strlen(msg)) > 0) {
		p = msg + len - 1;
		if ((c=*p) == '\n') *p = '\0';
	}
	ret = akb_print_out("%s",msg,NULL,NULL,NULL,NULL);
	if (c == '\n') *p = c;
	return ret;
}

/********************************************/
/*                                          */
/********************************************/
int akb_print_out(format,a1,a2,a3,a4,a5)
char *format,*a1,*a2,*a3,*a4,*a5;
{
	akb_log_flg(D_LOG_NO_PRINT, D_LOG_FLG_NO_SRC |
		akb_log_flg(D_LOG_NO_PRINT,D_LOG_FLG_CHECK));

	if (!akb_log_set_file_name(D_LOG_NO_PRINT, NULL))
		akb_log_set_file_name(D_LOG_NO_PRINT, PRINT_LOG_FILE);

	return akb_log_out_main(D_LOG_NO_PRINT,NULL,0,format,a1,a2,a3,a4,a5);
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_buf(len)
int len;
{
	if (len > 0) {
		if (gcpLogOutBuf) {
			gcpLogOutBuf = Realloc(gcpLogOutBuf,len);
		}
		else {
			gcpLogOutBuf = Malloc(len);
		}
	}
	return gcpLogOutBuf;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_check(ucTrace,iRW,sCmd)
unsigned char *ucTrace;
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
short sCmd;
{
	pCOMM_PACK_HEAD pHead;
	int iTrace, iFlag;

	if (ucTrace) iTrace = ucTrace[sCmd];
	else {
		if (sCmd<0 || sCmd>255) return 0;
		else iTrace = gucTrace[sCmd];
	}
	if (sCmd == CM_CMD_SEND) sCmd = 0;
	iFlag = 0;
	if (!sCmd && ((iTrace & 0x03)==0x03)) {
		if ((!(iTrace & 0x04) && (iRW==0 || iRW==2)) ||
		    (iTrace & 0x04)) iFlag = 1;
	}
	else {
		if ((!iRW && (iTrace & 0x01)) ||
		    ( iRW && (iTrace & 0x02))) iFlag = 1;
	}
	if (iFlag && iTrace & 0x08) iFlag = 2;
	return iFlag;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace(ucTrace,fname,iRW,cpPacket)
unsigned char *ucTrace;
char *fname;
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
char *cpPacket;
{
	pCOMM_PACK_HEAD pHead;
	short sCmd;
	int iFlag;
	char *p;

	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd = ntohs(pHead->cph_prt.prt_cmnd) & 0x00ff;

	if (iFlag=akb_trace_check(ucTrace,iRW,sCmd)) {
		if (iFlag == 2) p = NULL;
		else p = (char *)(pHead + 1);
		akb_dump(fname,iRW,pHead,p);
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
void akb_log_set_proc_name(cpName)
char *cpName;
{
	int len;

	if (!cpName) {
		if (gcpProcName) {
			Free(gcpProcName);
			gcpProcName = NULL;
		}
		return;
	}
	len = strlen(cpName) + 1;
	if (gcpProcName) {
		gcpProcName=Realloc(gcpProcName,len);
	}
	else {
		gcpProcName=Malloc(len);
	}
	if (gcpProcName) strcpy(gcpProcName,cpName);
	return;
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_get_proc_name()
{
	return gcpProcName;
}

/********************************************/
/*                                          */
/********************************************/
int akb_error_akb_dump(iRW,pHead)
int  iRW;
pCOMM_PACK_HEAD pHead;
{
	char *p;

	p = akb_log_set_file_name(0, NULL);
	if (!p) p = akb_log_set_file_name(0, ERROR_LOG_FILE);
	return akb_dump(p,iRW,pHead,pHead+1);
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_set_file_name(i, cpFile)
int  i;
char *cpFile;
{
	int len;
	char *p=NULL;

	if (i>=0 && i<D_LOG_NO_MAX) {
		p = gcLogFile[i];
		if (cpFile) {
			len = strlen(cpFile) + 1;
			if (p) {
				p = Realloc(p,len);
			}
			else {
				p = Malloc(len);
			}
			if (p) {
				strcpy(p,cpFile);
				gcLogFile[i] = p;
			}
		}
	}

	return p;
}

/********************************************/
/*                                          */
/********************************************/
int akb_get_log_time(buf,len,format)
char *buf,*format;
int  len;
{
	time_t  tt;
	struct  tm *tm_str;

	if (!buf) return -1;
	if (len <= 0) return -2;
	tt=time(NULL);
	tm_str=localtime(&tt);
	if (!format) format = "%Y/%m/%d %T";
	return strftime(buf,len,format,tm_str);
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_time()
{
	static char buf[64];

	*buf = '\0';

	akb_get_log_time(buf,sizeof(buf),NULL);

	return buf;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_flg(i,f)
int i,f;
{
	if (i>0 && i<256) {
		if (f >= 0) gucTrace[i] = f;
	}
	else if (i == 0) {
		memset(gucTrace,f,sizeof(gucTrace));
	}
	else {
		return -1;
	}

	return gucTrace[i];
}

/********************************************/
/*                                          */
/********************************************/
char *akb_trace_set_file_name(cpFile)
char *cpFile;
{
	int len;
	char *p=NULL;

	p = gcpTraceFile;
	if (cpFile) {
		len = strlen(cpFile) + 1;
		if (p) {
			p = Realloc(p,len);
		}
		else {
			p = Malloc(len);
		}
		if (p) {
			strcpy(p,cpFile);
			gcpTraceFile = p;
		}
	}

	return p;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_out(iRW,cpPacket)
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
char *cpPacket;
{
	pCOMM_PACK_HEAD pHead;
	short sCmd;
	int iFlag;
	char *p;
	char *fname;

	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd = ntohs(pHead->cph_prt.prt_cmnd) & 0x00ff;
	fname = akb_trace_set_file_name(NULL);
	if (!fname) fname = akb_trace_set_file_name(TRACE_FILE);

	if (iFlag=akb_trace_check(NULL,iRW,sCmd)) {
		if (iFlag == 2) p = NULL;
		else p = (char *)(pHead + 1);
		akb_dump(fname,iRW,pHead,p);
	}
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_up()
{
	static char *name[]={"ERROR_LOG","PRINT_LOG","DEBUG_LOG","STATI_LOG"};
	char *argv[5];
	int i,n,w;

	for (i=0;i<D_LOG_NO_MAX;i++) {
		n = akb_gs_akbstpl(BLK_AKBSYSTEM,name[i],argv,4);
		if (n < 0) return n;
		else if (n >= 2) {
			if (!akxcgcvn(argv[1],strlen(argv[1]),&w)) LOGFLG(i,w);
			if (n >= 3) {
				if (!akxcgcvn(argv[2],strlen(argv[2]),&w)) LOGLEVEL(i,w);
			}
			if (n >= 4) {
				if (strlen(argv[3]) <= 0) return -1;
				if (!akb_log_set_file_name(i, argv[3])) return D_ERR_MEM_ALLOC;
			}
		}
	}
	n = akb_gs_akbstpl(BLK_AKBSYSTEM,"LOGDIR",argv,2);
	if (n < 0) return n;
	else if (n >= 2)
		if (!akb_log_set_dir(argv[1])) return D_ERR_MEM_ALLOC;
	return 0;
}

/********************************************/
/*                                          */
/********************************************/
char *akb_log_set_dir(cpDir)
char *cpDir;
{
	int len;
	char *p;

	p = gcpLogDir;
	if (cpDir) {
		len = strlen(cpDir) + 1;
		if (p) {
			p = Realloc(p,len);
		}
		else {
			p = Malloc(len);
		}
		if (p) {
			strcpy(p,cpDir);
			gcpLogDir = p;
		}
	}

	return p;
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_set_upName(cpProcName)
char *cpProcName;
{
	if (cpProcName && *cpProcName) akb_log_set_proc_name(cpProcName);
	return akb_log_set_up();
}

/********************************************/
/*                                          */
/********************************************/
int akb_log_level(i,level)
int i,level;
{
	if (i>=0 && i<D_LOG_NO_MAX) {
		if (level>=0 && level<=255) gucLogLevel[i] = level;
	}
	else {
		return -1;
	}

	return (int)gucLogLevel[i];
}

