static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akasys.c
 *
 *        coded by A.Kobayashi 2000.8.11
 *
 *************************************************/
#include "akacommon.h"

#define AKAS_REPLY_WAIT_TIMER_NAME		"?REPLY_WAIT:proc=%d,cmnd=%d"
#define AKAS_REPLY_WAIT_WAKEUP_EVENT	100

extern char version[];
extern char make_date[];
extern tdtCLASS_CTLHead tClassHead;

extern int akb_rwqttimer();

int giAKA_CHANNEL_MAX;
tdtMSG_CTL             tMsgCtl = {-1};
static tdtSTATISTICS  tStatistics,tStat2;
static tdtCLASS_CTL    tClass;
tdtINSTANCE    tInst;
static tdtMSG_COM      tRecvMsg;
static char          *cppFilev[256];
static char          *nullname=AKX_NULL_PRINT;

static int (**_pCommandClass)();
int (*_pHPToEntry)();
static int _command_class();
static int sys_watch_class();
static int sys_log_class();
static int sys_statistics_class();
extern int aka_sys_password_class();
static int _statistics();
static int _statistics_fileout();
static int _statistics_edit();
static int _statistics_Timer();
static int _statistics_que();
static int _statistics_time_out();
static int _statistics_rwbuf();
static int _statistics_cha_rb();
static int _statistics_memory();
static int _statistics_class();
static int _statistics_channel();
static int _delay_msg_timer();
static int _wait_msg_timer();
static int sys_memory_class();
static int sys_help_class();
static int sys_property_class();

/********************************************************/
/*                                                      */
/********************************************************/
int aka_initialize(iSd,iProcNumber,iMaxThreadTotal,
                  pRbRCtl,pRbWCtl,pRbWWCtl,RbWCtlPA,RbPriCtlPA,
                  ReadQuePA,WriteQuePA,iQueMax,pDataQueUsed,
                  pCommandClass,pHPToEntry,iQueAkbUsed)
int  iSd           ;    /* ڑ\Pbg̔ԍ */
int  iProcNumber   ;    /* vZXԍ */
int  iMaxThreadTotal;   /* NX̃bZ[W鑽dx̍vől
                           ÔƂ́ANX̐ݒɏ] */
tdtRB_CTL *pRbRCtl, *pRbWCtl, *pRbWWCtl;
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
tdtRW_QUE *ReadQuePA[], *WriteQuePA[];
int    iQueMax;
tdtGENERAL_DATA *pDataQueUsed;
int (*pCommandClass[])();
int (*pHPToEntry)();
int iQueAkbUsed;
{
	int iRc;
	tdtMSG_COM tRecvMsg;

	iRc = aka_get_regist_pid();
	if (iRc <= 0) aka_set_regist_pid(iProcNumber);
	else if (iRc != iProcNumber) return -1;

	/* bZ[W\ */
	memset(&tMsgCtl,0,sizeof(tdtMSG_CTL));
	tMsgCtl.my_host_id = aka_get_my_host_id();
	if (!(tMsgCtl.host_id = aka_get_pr_host_id()))
		tMsgCtl.host_id = tMsgCtl.my_host_id;
	if ((iRc = akb_get_my_apsys_id())<0) return -1;
	tMsgCtl.apsys_id = iRc;
	tMsgCtl.sd       = iSd;
	tMsgCtl.proc     = iProcNumber;
	tMsgCtl.us_proc    = iProcNumber;
	tMsgCtl.regist_dest_pid = aka_get_regist_dest_pid();

	aka_init_status(AKA_IST_INITIALIZED,1);

	tMsgCtl.timer_ctl = akxe_timer_new(); /* ^C}[\ */
	tMsgCtl.send_msg_time_out = 30000;    /* milli second */
	tMsgCtl.send_msg_min_wait = -1;   /* milli second */
	if (!(tMsgCtl.spool_dir = akb_akb_home(0))) tMsgCtl.spool_dir = "";

	tMsgCtl.rb_rctl  = pRbRCtl;
	tMsgCtl.rb_wctl  = pRbWCtl;
	tMsgCtl.rb_wwctl = pRbWWCtl;
	tMsgCtl.rb_wctl_pa   = RbWCtlPA;
	tMsgCtl.rb_pri_ctl_pa = RbPriCtlPA;
	tMsgCtl.read_que_pa  = ReadQuePA;
	tMsgCtl.write_que_pa = WriteQuePA;
/*
	tMsgCtl.iReadQueMax  = iQueMax;
	tMsgCtl.iWriteQueMax = iQueMax;
*/

	giAKA_CHANNEL_MAX = X_MIN(AKA_CHANNEL_MAX,iQueMax);
	tMsgCtl.channel_used = tMsgCtl.channel_max = tMsgCtl.channel_akb_used = iQueAkbUsed;
	if (iRc = aka_expand_tables(AKA_CHANNEL_INIT)) return iRc;
	aka_init_zero(0);

	tMsgCtl.que_used_data = pDataQueUsed;

	_pCommandClass = pCommandClass;
	_pHPToEntry    = pHPToEntry;

	/* NX̏ */
#if 1
	if (iRc = aka_registerClass2(_command_class,1,0,3,2,"Command")) return iRc;
	if (iRc = aka_registerClass2(_command_class,2,0,3,2,"Command")) return iRc;
	if (iRc = aka_registerClass2(sys_watch_class,AKA_CLASS_WATCH,0,1,2,
	                            AKA_CLASS_NAME_WATCH)) return iRc;
	if (iRc = aka_registerClass2(sys_log_class,AKA_CLASS_LOG,0,1,1,
	                            AKA_CLASS_NAME_LOG)) return iRc;
	if (iRc = aka_registerClass2(sys_statistics_class,AKA_CLASS_STATISTICS,0,2,2,
	                            AKA_CLASS_NAME_STATISTICS)) return iRc;
	if (iRc = aka_registerClass2(aka_sys_password_class,AKA_CLASS_PASSWORD,0,1,1,
	                            AKA_CLASS_NAME_PASSWORD)) return iRc;
/*
	if (iRc = aka_registerClass2(sys_version_class,AKA_CLASS_VERSION,0,1,0,
	                            AKA_CLASS_NAME_VERSION)) return iRc;
*/
	if (iRc = aka_registerClass2(sys_memory_class,AKA_CLASS_MEMORY,0,1,0,
	                            AKA_CLASS_NAME_MEMORY)) return iRc;
	if (iRc = aka_registerClass2(sys_help_class,AKA_CLASS_HELP,0,1,0,
	                            AKA_CLASS_NAME_HELP)) return iRc;
	if (iRc = aka_registerClass2(sys_property_class,AKA_CLASS_PROPERTY,0,1,0,
	                            AKA_CLASS_NAME_PROPERTY)) return iRc;
#else
	memset(&tRecvMsg,0,sizeof(tdtMSG_COM));
	tRecvMsg.msg_disp = AKA_REGIST_CLASS;
	sys_watch_class(AKA_CLASS_WATCH,NULL,&tRecvMsg);
	sys_log_class(AKA_CLASS_LOG,NULL,&tRecvMsg);
	sys_statistics_class(AKA_CLASS_STATISTICS,NULL,&tRecvMsg);
	aka_sys_password_class(AKA_CLASS_PASSWORD,NULL,&tRecvMsg);
	sys_memory_class(AKA_CLASS_MEMORY,NULL,&tRecvMsg);
	sys_property_class(AKA_CLASS_PROPERTY,NULL,&tRecvMsg);
/*
	sys_version_class(AKA_CLASS_VERSION,NULL,&tRecvMsg);
*/
#endif
	aka_set_ver_date(version,make_date);

	/* v񐧌\ */
	memset(&tStatistics,0,sizeof(tdtSTATISTICS));
	memset(&tStat2,0,sizeof(tdtSTATISTICS));
	memset(&tInst,0,sizeof(tdtINSTANCE));

	return 0;
}
#if 0
/********************************************************/
/*                                                      */
/********************************************************/
int aka_dispatch(pNew)
pRC_PACKET_TABLE  pNew;
{
	tdtCOMM_PACK_HEAD   *pHead,tHead;
	pCOMM_PACK_HEADB   pHeadB;
	int iCh, iThread, iRc=0, i;
	short sCmd;
	char *cpPacket, cver, *cpToFree, *cpInst;
	ushort usClassId;
	int (*pFuncName)();
	INT4 wrk[sizeof(tdtCOMM_PACK_HEAD)/4+4],len;

	cpPacket = pNew->sp_content;
	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd  = ntohs(pHead->cph_prt.prt_cmnd);
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_dispatch: cmnd=%d thread=%d classid=%d",sCmd,pHead->cph_sinf.ind_thrd,
ntohs(pHead->cph_dinf.ind_clid));
	if (sCmd != AKB_CMD_SEND) {
		memcpy(wrk,pHead,sizeof(tdtCOMM_PACK_HEAD));
		len = ntohl(pHead->cph_plen);
		i = sizeof(tdtCOMM_PACK_HEAD)/4;
		if (len > 0) {
			if (len > 8) len = 8;
			memcpy(&wrk[i+1],cpPacket+sizeof(tdtCOMM_PACK_HEAD),len);
		}
		wrk[i] = htons(sCmd)<<16;
		len += 4;
		cpPacket = (char *)wrk;
		pHead = (pCOMM_PACK_HEAD)cpPacket;
		pHead->cph_plen = htonl(len);
	}
	usClassId = ntohs(pHead->cph_dinf.ind_clid);
	pHeadB = (pCOMM_PACK_HEADB)pHead;
	cver = pHead->cph_prt.prt_ver;
	if ((cver=='C' && pHead->cph_dinf.ind_thrd == 0) ||
	    (cver=='B' && pHeadB->phb_dind.inb_pkid == 0)) {
		/* MpPbg */
		if (pHead->cph_dinf.ind_pano != 0) {
			if (iRc) {
				ERROROUT2("*** aka_dispatch:Dropped Error Packet ClassID=%d akberr=%d",
				          usClassId,ntohs(pHead->cph_dinf.ind_pano));
				if (pNew->sp_content) Free(pNew->sp_content);
				Free(pNew);
				return -1;
			}
		}
	}

	iRc = 0;
	pFuncName = NULL;
	switch (usClassId) {
		case 0:
		case 1:
		case 2:
			pFuncName = _command_class;
			break;

		case AKA_CLASS_WATCH:
			pFuncName = sys_watch_class;
			break;
		
		case AKA_CLASS_LOG:
			pFuncName = sys_log_class;
			break;

		case AKA_CLASS_STATISTICS:
			pFuncName = sys_statistics_class;
			break;

		case AKA_CLASS_PASSWORD:
			pFuncName = aka_sys_password_class;
			break;

		case AKA_CLASS_MEMORY:
			pFuncName = sys_memory_class;
			break;

		case AKA_CLASS_HELP:
			pFuncName = sys_help_class;
			break;

		case AKA_CLASS_PROPERTY:
			pFuncName = sys_property_class;
			break;
/*
		case AKA_CLASS_VERSION:
			pFuncName = sys_version_class;
			break;
*/
		default:
	/***
			if ((iCmd = AKA_CLASS_BASE - ucClassId) < 256) {
				if (!(pFuncName = ppClassFunc[iCmd])) iRc = -1;
			}
	***/
			iRc = D_ERR_UNKNOWN_CLASS;
			ERROROUT1("*** aka_dispatch:no class = %d",usClassId);
	}

	if (!pFuncName) {
		iRc = D_ERR_UNKNOWN_CLASS;
	}
	if (!iRc) {
		cpToFree = NULL;
		memset(&tRecvMsg,0,sizeof(tdtMSG_COM));
		if (pHead->cph_sinf.ind_thrd) {	/* command packet */
			tInst.pack_head = pHead;
		}
		else {
			len = ntohl(pHead->cph_plen);
if (DEBUGOUTCHECK(AKA_LOG_GROUP|252))
akxaxdump("Dispatch:cpPacket",cpPacket,sizeof(tdtCOMM_PACK_HEAD)+len);
			memcpy(&tHead,cpPacket+len,sizeof(tdtCOMM_PACK_HEAD));
			tInst.pack_head = &tHead;
			len -= sizeof(tdtCOMM_PACK_HEAD);
			pHead->cph_plen = htonl(len);
		}
		iRc = akb_set_recv_msg(cpPacket,&tRecvMsg,cppFilev,&cpToFree);
		if (iRc) {
			ERROROUT1("*** aka_dispatch:akb_set_recv_msg rc = %d",iRc);
		}
		else {
			aka_statistics_count(2,0);
			if (!tRecvMsg.msg_pmsg) tRecvMsg.msg_pmsg = "";
			if (tRecvMsg.msg_mlen > 0)
				*(tRecvMsg.msg_pmsg+tRecvMsg.msg_mlen) = '\0';
			iThread = 1;
			tRecvMsg.msg_seqn = cpPacket;
			pFuncName(iThread<<16|usClassId,NULL,&tRecvMsg);
		}
		if (cpToFree) Free(cpToFree);
	}
	if (iRc) {
		iCh = _pHPToEntry(ntohl(pHead->cph_sinf.ind_hoid),
		                  ntohs(pHead->cph_sinf.ind_prid));
		if (iCh >= 0) {
			if (akb_set_rb_pack_err_cd(iCh,pNew->sp_content,tMsgCtl.rb_wctl,iRc)) {
				ERROROUT("*** aka_dispatch:Dropped Packet -- repry error");
			}
			else {
				TRACEOUTCH(2,pNew->sp_content,iCh,"tMsgCtl.pRbWCtl");
				pNew->sp_content = NULL;
			}
		}
		else ERROROUT("*** aka_dispatch:Dropped Packet -- Src no entry");
	}

	if (pNew->sp_content) Free(pNew->sp_content);
	Free(pNew);
	return 0;
}
#endif
/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int n;
	char buf[128];
/*
printf("_statistics_timer:called\n");
*/
	_statistics_fileout(tptime->tv_sec,0,
            tMsgCtl.rb_rctl->rb_used,tMsgCtl.rb_wctl->rb_used,
            0);
	return 0;
}
#if 0
/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics(buf,iopt,mcat)
char *buf;
int  iopt[];
MCAT *mcat;
{
	static char *stat[]={"start","stop "};
	int len,ret=0,i,n;
	tdtTIMER_CTL *next;
	char *p;
	struct timeval tval;
	struct tm t;
	struct rusage rus;

	if (!(p=akb_log_get_proc_name())) p = nullname;
	aka_getm_sec(&tval);
	akxe_edit_elapse_time(tval.tv_sec,&t);
#if 0
#if 0
	getrusage(RUSAGE_SELF,&rus);
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\nMemory shm=%d data=%d stack=%d\n\nTimerId  WaitTime(msec)  Status  Name\n",p,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec,rus.ru_ixrss,rus.ru_idrss,rus.ru_isrss);
#else
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\n",
	        p,tMsgCtl.proc,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec);
#endif
#else
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\n\nMaxThreadTotal : %d   UsedThreadTotal : %d\n\nClassId    Option  DataSize  MaxThread  UsedCount  Name\n",
	        p,tMsgCtl.proc,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec,
	        tClassHead.max_thread_total,tClassHead.used_thread_total);
#endif
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	if ((ret = _statistics_class(buf,iopt,mcat)) < 0) return ret;

	if ((ret = _statistics_que(buf,mcat)) < 0) return ret;

	if ((ret = _statistics_edit(tval.tv_sec,buf,mcat)) < 0) return ret;

	if (iopt[1]) {
		if ((ret = _statistics_channel(buf,mcat)) < 0) return ret;

		if (iopt[1] & 0x02) {
			if ((ret = _statistics_rwbuf(buf,mcat)) < 0) return ret;
		}
		if (iopt[1] & 0x04) {
			if ((ret = _statistics_cha_rb(buf,mcat)) < 0) return ret;
		}
	}

	if (iopt[2]) {
		if ((ret = _statistics_timer(buf,mcat)) < 0) return ret;
	}

	if (iopt[3]) {
		if ((ret = _statistics_time_out(buf,mcat)) < 0) return ret;
	}

	if ((ret = _statistics_memory(buf,mcat)) < 0) return ret;

	return ret;
}
#endif
/********************************************************/
/*                                                      */
/********************************************************/
static int _delay_msg_timer(iTimerId, cpTimerName, cpParm, tptime, iEvent)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
int iEvent;
{
	tdtWAIT_PACKET *tpWait,*pRc;
	int pid,i;
	pSD_PACKET_TABLE pNew;

DEBUGOUTL4(AKA_LOG_GROUP|250,
"_delay_msg_timer:called TimerId=%d Name=[%s] Parm=%08x Event=%d",
iTimerId,cpTimerName, cpParm,iEvent);
	pNew = (pSD_PACKET_TABLE )cpParm;
	if (!akxs_rb_set_n(tMsgCtl.rb_wctl,pNew)) {
		ERROROUT1("_wait_msg_timer: name=[%s] resend error",cpTimerName);
		Free(pNew->sp_content);
		Free(pNew);
	}
	else TRACEOUTCH(2,pNew->sp_content,pNew->sp_ch,"tMsgCtl.pRbWCtl");
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_sys_reply_msg_delay(lInstanceHandle,tpReplyMsg,iWaitTime,cpWaitName)
long lInstanceHandle;   /* CX^Xʔԍ */
tdtMSG_COM *tpReplyMsg;
int  iWaitTime;    /* >=0 :bZ[W̃^CAEg(msec) */
char *cpWaitName;
{
	pCOMM_PACK_HEAD    pHead;
	int iCh, iThread, iRc=0, len;
	char *cpPacket,*cpW,procname[16],wrk[128],*p;
	ushort usClassId;
	pSD_PACKET_TABLE  pNew;

	if (iWaitTime <= 0) {
		return aka_reply_msg(lInstanceHandle,tpReplyMsg);
	}

	if (!tpReplyMsg) return -1;
	if (tpReplyMsg->msg_mlen < 0) return -1;

	pHead = tInst.pack_head;

	iCh = _pHPToEntry(ntohl(pHead->cph_sinf.ind_hoid),
	                  ntohs(pHead->cph_sinf.ind_prid));
	if (iCh < 0) {
		ERROROUT("*** aka_sys_reply_msg:Dropped Packet -- Src no entry");
		return iCh;
	}

	pHead->cph_dinf.ind_disp = 0;
#if 1
	pHead->cph_prt.prt_send = tpReplyMsg->msg_form & AKA_PFM_INDIRECT;
	len = akb_create_pk_data(NULL,pHead,tpReplyMsg,&cpPacket);
	if (len < 0) {
		ERROROUT1("aka_sys_reply_msg:Dropped Packet -- akb_create_pk_data error=%d",len);
		return len;
	}
#else
	if (!(cpPacket=Malloc(sizeof(tdtCOMM_PACK_HEAD)+tpReplyMsg->msg_mlen)))
			return -1;
	pHead->cph_plen = htonl(tpReplyMsg->msg_mlen);
	pHead->cph_prt.prt_send = 0x00;
	memcpy(cpPacket,pHead,sizeof(tdtCOMM_PACK_HEAD));
	if (tpReplyMsg->msg_mlen && tpReplyMsg->msg_pmsg)
		memcpy(cpPacket+sizeof(tdtCOMM_PACK_HEAD),tpReplyMsg->msg_pmsg,
		       tpReplyMsg->msg_mlen);
#endif

	if (tMsgCtl.us_proc == AKB_PRID_PROM || iCh == 0) {
		sprintf(procname,"P%d",tMsgCtl.us_proc);
		len=akb_mem_to_indir_f(procname,cpPacket,
		                   cpPacket+sizeof(tdtCOMM_PACK_HEAD),&cpW);
		if (len<0) {
			Free(cpPacket);
			ERROROUT1("aka_sys_reply_msg:Dropped Packet -- akb_mem_to_indir_f error=%d",
			          len);
			return len;
		}
		else if (len>0) {
			Free(cpPacket);
			cpPacket = cpW;
		}
	}
	if (iWaitTime <= 0) {
		iRc = akb_set_rb_pack_err_cd(iCh,cpPacket,tMsgCtl.rb_wctl,0);
		if (iRc) {
			ERROROUT1("aka_sys_reply_msg:Dropped Packet -- repry error=%d",iRc);
		}
		else TRACEOUTCH(2,cpPacket,iCh,"tMsgCtl.pRbWCtl");
	}
	else {
		 /* pPbg̍쐬 */
		akb_crt_err_packet(cpPacket,0);
		if (!(pNew = akb_packet_tbl_new(0))) {
			Free(cpPacket);
			return D_ERR_MEM_ALLOC;
		}
		pHead = (tdtCOMM_PACK_HEAD *)cpPacket;
		pNew->sp_content = cpPacket;
		pNew->sp_len     = sizeof(tdtCOMM_PACK_HEAD) + ntohl(pHead->cph_plen);
		pNew->sp_ch      = iCh ;

		if (!(p=cpWaitName)) {
			sprintf(wrk,"WAIT_MSG%x",pNew);
			p = wrk;
		}
		iRc = aka_register_timer(p,_delay_msg_timer,iWaitTime,pNew);
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_sys_reply_msg_delay: TimerId=%d name=[%s] time=%d",iRc,p,iWaitTime);
		if (iRc <= 0) {
			Free(pNew->sp_content);
			Free(pNew);
			if (!iRc) iRc = -1;
		}
		else iRc = 0;
	}

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_sys_reply_msg(lInstanceHandle,tpReplyMsg)
long lInstanceHandle;
tdtMSG_COM *tpReplyMsg;
{
#if 1
	return aka_reply_msg(lInstanceHandle,tpReplyMsg);
#else
	return aka_sys_reply_msg_delay(lInstanceHandle,tpReplyMsg,0,NULL);
#endif
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _cmd_conv(usClassId,cpMsg,pi_dlen,tpCmdCnv)
ushort usClassId;
char *cpMsg;
int  pi_dlen;
tdtCMD_CNV *tpCmdCnv;
{
	static struct {
		char *name;
		short cmd;
	} tCmd[]={
		"BUNSAN"		,AKB_CMD_BUNSAN,
		"START"			,AKB_CMD_START,
		"SHUT"			,AKB_CMD_SHUT,
		"FSHUT"			,AKB_CMD_FSHUT,
		"KILL"			,AKB_CMD_KILL,
		"TRACE"			,AKB_CMD_TRACE,
		"LOG"			,AKB_CMD_LOG,
		"QUERY"			,AKB_CMD_QUERY,
		"REQUEST"		,AKB_CMD_REQUEST,
	/*	"STATISTICS"	,AKB_CMD_STATISTICS,	*/
		"VER"			,AKB_CMD_VERSION,
		"VERSION"		,AKB_CMD_VERSION,
		"PASSWORD"		,AKB_CMD_PASSWORD,
		"HELP"			,AKB_CMD_HELP,
		"HOSTCMD"		,AKB_CMD_HOSTCMD,
		"PROPERTY"		,AKB_CMD_PROPERTY,
		NULL,0};
	static char parm[129];
	char *argv[12],buf[129],*cpRec,*p;
	int n,len,i,iRecLen,m;
	int w[4];
	short s=0,sW;
	unsigned short us=0, usW;
	unsigned char uc=0;
	SSP_S ssp;
/*
printf("_cmd_conv;usClassId=%d pi_dlen=%d\n",usClassId,pi_dlen);
*/
	memset(tpCmdCnv,0,sizeof(tdtCMD_CNV));
	if (usClassId < 2) {
		sW  = *(short *)cpMsg;
		s   = ntohs(sW);
		usW = *(unsigned short *)(cpMsg+2);
		us  = ntohs(usW);
		uc = us >> 8;
		tpCmdCnv->cmc_scmd = s;
		tpCmdCnv->cmc_prno = us;
		tpCmdCnv->cmc_ccmd    = uc;
		tpCmdCnv->cmc_mode   = us & 0x00ff;
	}
	else {
		memset(w,0,sizeof(w));
		tpCmdCnv->cmc_spec = 1;
		ssp.sp = 0;
		while ((iRecLen=akxtmgetline(cpMsg,pi_dlen,&ssp))>=0) {
			cpRec = ssp.wd;
			*(cpRec+iRecLen) = '\0';
			n = akxtgetargv2(cpRec,argv,12,parm,sizeof(parm),1);
			if (n > 0) {
				if ((m=n) > 4) m = 4;
				for (i=1;i<m;i++) {
				/*	if (akxcgcvn(argv[i],strlen(argv[i]),&w[i])) return -1;	*/
					akxcgcvn(argv[i],strlen(argv[i]),&w[i]);
				}
				if (!stricmp(argv[0],"C")) {
					if (n < 2) return -1;
					tpCmdCnv->cmc_scmd = w[1];
					tpCmdCnv->cmc_prno = w[2];
					tpCmdCnv->cmc_ccmd    = w[3];
					tpCmdCnv->cmc_mode   = w[2];
					tpCmdCnv->cmc_nprm = n - 1;
				/*
					memcpy(tpCmdCnv->cmc_parm,&argv[1],tpCmdCnv->cmc_nprm*sizeof(char *));
				*/
					memcpy(tpCmdCnv->cmc_parm,&argv[1],11*sizeof(char *));
					break;
				}
				else {
					tpCmdCnv->cmc_prno = w[1];
					tpCmdCnv->cmc_ccmd    = w[2];
					tpCmdCnv->cmc_mode   = w[1];
					tpCmdCnv->cmc_nprm = n;
				/*
					memcpy(tpCmdCnv->cmc_parm,argv,tpCmdCnv->cmc_nprm*sizeof(char *));
				*/
					memcpy(tpCmdCnv->cmc_parm,argv,11*sizeof(char *));
					for (i=0;p=tCmd[i].name;i++) {
/*
printf("_cmd_conv;i=%d name=[%s]\n",i,p);
*/
						if (*p == '/') p++;
						if (!stricmp(argv[0],p)) {
							tpCmdCnv->cmc_scmd = tCmd[i].cmd;
							return 0;
						}
					}
					return -1;
				}
			}
		}
	}
/*
printf("s = 0x%04x, us = 0x%04x, uc = 0x%02x\n",s,us,uc);
*/
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _verdate(tpRecvMsg,tpCmdCnv)
AKAMSGCOM *tpRecvMsg;
tdtCMD_CNV *tpCmdCnv;
{
	char *p,*pver,*pdate,*pVD[2];
	int  vrlen,dtlen,iVDL[2];

	aka_get_ver_date(pVD,iVDL);
	vrlen = iVDL[0];
	dtlen = iVDL[1];
	pver  = pVD[0];
	pdate = pVD[1];

	/* tCmdCnv.cpDataɃf[^Ƃ́ASoCgJ */
	p = Malloc(4+vrlen+dtlen+3);
	if (p) {
		tpCmdCnv->cmc_data = p;
	}
	else {
		ERROROUT("_verdate:Malloc Error");
		return D_ERR_MEM_ALLOC;
	}
	p += 4;
	memcpy(p,pver,vrlen);
	p += vrlen;
	*p++ = '\n';
	memcpy(p,pdate,dtlen);
	p += dtlen;
	*p++ = '\n';
	*p = '\0';
	tpCmdCnv->cmc_dlen = vrlen + dtlen + 7;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _command_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	int   iRc, iReply, l, iwRc;
	short sCommand;
	ushort usProcId,usClassId;
	char  *cpRecvMsg,*cpSendMsg;
	uchar ucCmd, ucFlg, ucReply;
	int   pi_dlen;
	INT4  lw;
	tdtCMD_CNV tCmdCnv;
	char *pAlloc,buf[32],msg[256],wait_name[64];
	AKAMSGCOM tReplyMsg;
	int (*pCommandFunc)();
	int iParm[10];

DEBUGOUTL2(AKA_LOG_GROUP|250,
"_command_class: Dispos=%d PackRet=%d",
tpRecvMsg->msg_disp,tpRecvMsg->msg_pret);
	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
    }
	iwRc = iRc = 0;
	pAlloc = NULL;
	memset(&tCmdCnv,0,sizeof(tdtCMD_CNV));
	pi_dlen  = tpRecvMsg->msg_mlen;
	cpRecvMsg = tpRecvMsg->msg_pmsg;
  switch (tpRecvMsg->msg_disp) {
  case 0:
	ucReply = tpRecvMsg->msg_resv;
	if (cpRecvMsg) {
		usClassId = lInstanceHandle & 0xffff;
		_cmd_conv(usClassId,cpRecvMsg,pi_dlen,&tCmdCnv);
		sCommand = tCmdCnv.cmc_scmd;
		usProcId = tCmdCnv.cmc_prno;
/*
printf("_command_class: sCommand=%d usProcId=%d\n",sCommand,usProcId);
*/
		if (sCommand >= 0 && sCommand <= 255)
			pCommandFunc = _pCommandClass[sCommand];
		else
			pCommandFunc = NULL;
		if (!(tpRecvMsg->msg_prid==D_PRID_PROM && !tpRecvMsg->msg_clid) &&
		    pCommandFunc &&
		    (sCommand==AKB_CMD_START || sCommand==AKB_CMD_SHUT ||
		     sCommand==AKB_CMD_FSHUT || sCommand==AKB_CMD_KILL ||
		     sCommand==AKB_CMD_TRACE || sCommand==AKB_CMD_PROPERTY ||
		     sCommand==AKB_CMD_LOG   || sCommand==AKB_CMD_REQUEST) &&
		    aka_sys_password_check(tpRecvMsg->msg_prid)) {
			iRc = D_ERR_NO_PASSWORD;
		}
		else {
			switch( sCommand ) {
				case AKB_CMD_BUNSAN:
				case AKB_CMD_START:
				case AKB_CMD_QUERY:
				case AKB_CMD_REQUEST:
				case AKB_CMD_SHUT:
				case AKB_CMD_FSHUT:
				case AKB_CMD_KILL:
				case AKB_CMD_NOTIFY:
			/*	case AKB_CMD_BROADCAST:	*/
					if (pCommandFunc) iRc = pCommandFunc(tpRecvMsg,&tCmdCnv);
					else iRc = D_ERR_UNDEF_CMDEXEC;
					break ;
				case AKB_CMD_HOSTCMD:
					if (pCommandFunc) {
						iRc = pCommandFunc(lInstanceHandle,cpInstanceData,
						                   tpRecvMsg,&tCmdCnv);
						ucReply = 0;
					}
					else iRc = D_ERR_UNDEF_CMDEXEC;
					break ;
				case AKB_CMD_TRACE:
				case AKB_CMD_LOG:
				  if (sCommand ==AKB_CMD_TRACE) {
					if (usClassId == 2) {
						sprintf(buf,"%d",D_LOG_NO_TRACE);
						tCmdCnv.cmc_parm[0] = buf;
						if (tCmdCnv.cmc_nprm <= 2) {
							tCmdCnv.cmc_nprm = 3;
							tCmdCnv.cmc_parm[2] = "0";
						}
						akb_log_set_parm2(tCmdCnv.cmc_nprm,tCmdCnv.cmc_parm,10,iParm);
						sprintf(msg+4,"CommandClass: Set trace usMode=0x%x ucCmd=%d sizemax=%d filemax=%d option=%d",iParm[1],iParm[2],iParm[3],iParm[4],iParm[5]);
					}
					else {
						ucCmd = tCmdCnv.cmc_ccmd;
						akb_trace_flg(ucCmd,tCmdCnv.cmc_mode);
						sprintf(msg+4,"CommandClass: Set trace usMode=0x%x, ucCmd=%d",tCmdCnv.cmc_mode,ucCmd);
					}
				  }
			/**********
					PRINTOUT(msg+4);
					tCmdCnv.cmc_spec |= 0x80;
					tCmdCnv.cmc_data = msg;
					tCmdCnv.cmc_dlen   = 5 + strlen(msg+4);
					break ;
				case AKB_CMD_LOG:
			*********/
				  else {
					if (usClassId == 2) {
						akb_log_set_parm2(tCmdCnv.cmc_nprm-1,&tCmdCnv.cmc_parm[1],10,iParm);
						sprintf(msg+4,"CommandClass: Set log logno=%d flg=%d level=%d sizemax=%d filemax=%d option=%d",iParm[0],iParm[1],iParm[2],iParm[3],iParm[4],iParm[5]);
					}
					else {
						ucFlg = tCmdCnv.cmc_ccmd;
						ucCmd = tCmdCnv.cmc_mode;
						if (ucCmd <= 3) akb_log_flg(ucCmd,ucFlg);
						sprintf(msg+4,"CommandClass: Set log logno = %d, flg = %d",ucCmd,ucFlg);
					}
				  }
					PRINTOUT(msg+4);
					tCmdCnv.cmc_spec |= 0x80;
					tCmdCnv.cmc_data = msg;
					tCmdCnv.cmc_dlen   = 5 + strlen(msg+4);
					break ;
				case AKB_CMD_VERSION:
					iRc = _verdate(tpRecvMsg,&tCmdCnv);
					break ;
				case AKB_CMD_PASSWORD:
					tpRecvMsg->msg_pmsg = tCmdCnv.cmc_parm[1];
					tpRecvMsg->msg_mlen = strlen(tpRecvMsg->msg_pmsg);
					aka_sys_password_class(lInstanceHandle,cpInstanceData,tpRecvMsg);
					ucReply = 0;/* aka_sys_password_class()̒replyĂ */
					break ;
				case AKB_CMD_PROPERTY:
					strcpy(tpRecvMsg->msg_pmsg,tpRecvMsg->msg_pmsg+9);
					tpRecvMsg->msg_mlen = strlen(tpRecvMsg->msg_pmsg);
					sys_property_class(lInstanceHandle,cpInstanceData,tpRecvMsg);
					ucReply = 0;/* aka_sys_password_class()̒replyĂ */
					break ;
				default:
					iRc = D_ERR_UNKNOWN_CMD;
			}
		}
	}
	else {
		iRc = D_ERR_LESS_DATA;
	}
	if (ucReply && tCmdCnv.cmc_dlen >= 0) {
		if ((iwRc = iRc) == D_ERR_REPLY_WAIT) iwRc = 0;
		if ((tCmdCnv.cmc_spec & 0x01)== 0) {
			lw = htonl(iwRc);
			/* tCmdCnv.cpDataɃf[^Ƃ́ASoCgJĂ */
			if (tCmdCnv.cmc_dlen > 4) {
				cpSendMsg = tCmdCnv.cmc_data;
				pi_dlen  = tCmdCnv.cmc_dlen;
			}
			else {
				cpSendMsg = buf;
				pi_dlen  = 4;
			}
			memcpy(cpSendMsg,&lw,4);
		}
		else {
			sprintf(buf,"R %d\n",iwRc);
			l = strlen(buf);
			if (tCmdCnv.cmc_dlen > 4) {
				tCmdCnv.cmc_dlen -= 4;
				pi_dlen = l + tCmdCnv.cmc_dlen + 1;
				if (pAlloc = Malloc(pi_dlen)) {
					cpSendMsg = pAlloc;
					memcpy(cpSendMsg,buf,l);
					memcpy(cpSendMsg+l,tCmdCnv.cmc_data+4,tCmdCnv.cmc_dlen);
					*(cpSendMsg+l+tCmdCnv.cmc_dlen) = '\0';
				}
				else {
					iRc = D_ERR_MEM_ALLOC;
					sprintf(buf,"R %d\n",iRc);
					cpSendMsg = buf;
					pi_dlen  = strlen(buf) + 1;
				}
			}
			else {
				cpSendMsg = buf;
				pi_dlen  = l + 1;
			}
		}
		memset(&tReplyMsg,0,sizeof(AKAMSGCOM));
		tReplyMsg.msg_pmsg   = cpSendMsg;
		tReplyMsg.msg_mlen = pi_dlen;
		if (iRc == D_ERR_REPLY_WAIT) {
			iwRc = tCmdCnv.cmc_wait;
			tReplyMsg.msg_disp = 1;
			if (sCommand == AKB_CMD_FSHUT) sCommand == AKB_CMD_SHUT;
			sprintf(wait_name,AKAS_REPLY_WAIT_TIMER_NAME,usProcId,sCommand);
/*
printf("_command_class: wait_name=[%s]\n",wait_name);
*/
#if 0
			iRc = aka_set_wait(lInstanceHandle,&tReplyMsg,iwRc,wait_name);
DEBUGOUTL1(AKA_LOG_GROUP|250,
"_command_class: aka_set_wait() ret=%d",iRc);
			if (iRc) iwRc = 0;
		}
		else iwRc = 0;
		if (iwRc == 0) aka_sys_reply_msg(lInstanceHandle,&tReplyMsg);
#else
		}
		else iwRc = 0;
		iRc = aka_sys_reply_msg_delay(lInstanceHandle,&tReplyMsg,iwRc,wait_name);
DEBUGOUTL1(AKA_LOG_GROUP|250,
"_command_class: aka_sys_reply_msg_delay() ret=%d",iRc);
		iwRc = 0;
#endif
	}
	if (pAlloc) Free(pAlloc);
	if (!(tCmdCnv.cmc_spec & 0x80) && tCmdCnv.cmc_data) Free(tCmdCnv.cmc_data);
	break;
  case 1:
		memset(&tReplyMsg,0,sizeof(AKAMSGCOM));
		tReplyMsg.msg_pmsg   = cpRecvMsg;
		tReplyMsg.msg_mlen = pi_dlen;
		aka_sys_reply_msg(lInstanceHandle,&tReplyMsg);
		iwRc = 0;
  }
	return iwRc;
}
#if 0
/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_inst_comment(lInstanceHandle, cpText)
long lInstanceHandle;
char *cpText;
{
	return 0;
}
#endif
/********************************************************/
/*                                                      */
/********************************************************/
int aka_del_reply_wait(usProcId,sCommand)
ushort usProcId;
short  sCommand;
{
	tdtWAIT_PACKET *tpWait;
	int procno,irc;
	char wrk[64];

	procno = usProcId;
	sprintf(wrk,AKAS_REPLY_WAIT_TIMER_NAME,procno,sCommand);
	irc = aka_wake_up_timer(2,wrk,AKAS_REPLY_WAIT_WAKEUP_EVENT);
/*
printf("aka_del_reply_wait: wait_name=[%s]\n",wrk);
*/
DEBUGOUTL3(AKA_LOG_GROUP|250,"aka_del_reply_wait: procno=%d command=%d irc=%d",
procno,sCommand,irc);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _wait_msg_timer(iTimerId, cpTimerName, cpParm, tptime, iEvent)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
int iEvent;
{
	tdtWAIT_PACKET *tpWait,*pRc;
	int pid,i;
	pSD_PACKET_TABLE pNew;

DEBUGOUTL4(AKA_LOG_GROUP|250,
"_wait_msg_timer:called TimerId=%d Name=[%s] Parm=%08x Event=%d",
iTimerId,cpTimerName, cpParm,iEvent);
	pNew = (pSD_PACKET_TABLE)cpParm;
	if (akb_set_rb_pack_err_cd(0,pNew,tMsgCtl.rb_rctl,iEvent)<0) {
		ERROROUT1("_wait_msg_timer: name=[%s] resend error",cpTimerName);
		Free(pNew->sp_content);
	}
DEBUGOUTL1(AKA_LOG_GROUP|250,"_wait_msg_timer:exit Name=[%s]",cpTimerName);
	Free(pNew);
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_wait(lInstanceHandle,tpWaitMsg,iWaitTime,cpWaitName)
long lInstanceHandle;   /* CX^Xʔԍ */
AKAMSGCOM *tpWaitMsg;
int  iWaitTime;    /* >=0 :bZ[W̃^CAEg(msec) */
char *cpWaitName;
{
	tdtCOMM_PACK_HEAD tHead;
	char *cpParm,*p,wrk[40];
	uchar  ucThread;
	int    iRc,len;
	ushort usClassId,usWrk;

	if (!tpWaitMsg || !cpWaitName) return -1;
	if (tMsgCtl.sd<0) return -1;

	usClassId = lInstanceHandle & 0x0000ffff;
	ucThread  = (lInstanceHandle>>16) & 0x000000ff;
	memset(&tHead,0,sizeof(tdtCOMM_PACK_HEAD));
	tHead.cph_prt.prt_ver        = 'C';
	tHead.cph_prt.prt_cmnd    = htons(AKB_CMD_SEND);
	tHead.cph_sinf.ind_hoid      = htonl(tMsgCtl.host_id);
	tHead.cph_sinf.ind_disp     = tpWaitMsg->msg_disp;
	tHead.cph_sinf.ind_thrd     = ucThread;
	tHead.cph_sinf.ind_prid  = htons(tMsgCtl.us_proc);
	tHead.cph_sinf.ind_clid    = htons(usClassId);
	len = sizeof(tdtCOMM_PACK_HEAD)+tpWaitMsg->msg_mlen;
	tHead.cph_plen            = htonl(len);

	if (!(cpParm=Malloc(sizeof(tdtCOMM_PACK_HEAD)+len))) {
		return -1;
	}
	memcpy(cpParm,&tHead,sizeof(tdtCOMM_PACK_HEAD));
	p = cpParm + sizeof(tdtCOMM_PACK_HEAD);
	memcpy(p,tpWaitMsg->msg_pmsg,tpWaitMsg->msg_mlen);
	p += tpWaitMsg->msg_mlen;
	memcpy(p,tInst.pack_head,sizeof(tdtCOMM_PACK_HEAD));
if (DEBUGOUTCHECK(AKA_LOG_GROUP|252))
akxaxdump("aka_set_wait:cpParm",cpParm,len+sizeof(tdtCOMM_PACK_HEAD));
	if (!(p=cpWaitName)) {
		sprintf(wrk,"WAIT_MSG%x",cpParm);
		p = wrk;
	}
	iRc = aka_register_timer(p,_wait_msg_timer,iWaitTime,cpParm);
	if (iRc <= 0) {
		if (cpParm) Free(cpParm);
		return -1;
	}
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_set_wait: TimerId=%d name=[%s] time=%d",iRc,p,iWaitTime);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int wait_msg_time_out()
{
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_sys_rwque_time_out_new(parm_dummy,_close_sd_func,pData)
int parm_dummy[];
int (*_close_sd_func)();
tdtGENERAL_DATA *pData;
{
	int n,parm[2],*pp;
	tdtRWQ_TIME_OUT *p;
	int i;

	n = aka_rwque_get_akb_time_out(parm);
	if (n <= 0) return n;
	else if (n == 1) pp = NULL;
	else pp = parm;

	p = aka_rwque_time_out_new(tMsgCtl.channel_max,pp /*,akb_rwqttimer */);
	if (tMsgCtl.rwqtime_out = p) {
		p->rwt_clsf = _close_sd_func;
		p->rwt_rqto.qto_qmax = tMsgCtl.channel_max;
		p->rwt_rqto.qto_ppqu   = tMsgCtl.read_que_pa;
		p->rwt_wqto.qto_qmax = tMsgCtl.channel_max;
		p->rwt_wqto.qto_ppqu   = tMsgCtl.write_que_pa;
		for (i=0;i<p->rwt_rqto.qto_qmax;i++)
			p->rwt_rqto.qto_ppqu[i]->rwq_wtime = p->rwt_rqto.qto_wait;
		for (i=0;i<p->rwt_wqto.qto_qmax;i++)
			p->rwt_wqto.qto_ppqu[i]->rwq_wtime = p->rwt_wqto.qto_wait;
		p->rwt_rqto.qto_used = pData;
		p->rwt_wqto.qto_used = pData;
	}
	return 0;
}

/*******************************************
 *	aka_get_msg(iWaitTime)
 *		ret  >0 ̂ƂApPbgB
 *		     =0 ̂ƂApPbgȂB
 *		     <0 ̂ƂAG[R[hB
 *******************************************/
int aka_get_msg(iWaitTime,akbPacketRead,akbPacketWrite)
int  iWaitTime  ;	/* select VXeR[ WaitTimei1/10bj */
int (*akbPacketRead)();
int (*akbPacketWrite)();
{
	int iRc = 0;
	int iRcW,iRcR,iShutMode;
	int lmtime;
	struct timeval tmtime;
	int iMinWaitTime,iTimerMinWait,iWait;

DEBUGOUTL1(AKA_LOG_GROUP|200,"aka_get_msg: Enter iWaitTime=%d",iWaitTime);

	if (tMsgCtl.sd<0) return -18505001;

	iShutMode = aka_shut_control(AKA_SHUT_GET,NULL);

DEBUGOUTL1(AKA_LOG_GROUP|200,"aka_get_msg: iShutMode=%d",iShutMode);

	if (iShutMode == 2) {	/* FSHUT mode */
		aka_put_msg(3,akbPacketWrite);
		return -AKB_CMD_FSHUT;
	}
	else if (iShutMode == 1 &&	/* SHUT mode */
	   !(akxs_rb_get(tMsgCtl.rb_rctl) || akxs_rb_get(tMsgCtl.rb_wctl) ||
	     tMsgCtl.wqsuspend ||
	     akb_qscheck_pa(tMsgCtl.channel_used,tMsgCtl.write_que_pa))) {
		return -AKB_CMD_SHUT;
	}
	/***********************************************
	 * {֐iWaitTimeɃ^[鎞̐ݒ *
	 ***********************************************/
	tMsgCtl.get_msg_wait_time = iWaitTime*100;
	if (tMsgCtl.get_msg_wait_time>=0) {
		if ((lmtime=aka_get_msec(&tmtime))<0) return -18505002;
		akxe_timer_add_msec(&tmtime,&tmtime,tMsgCtl.get_msg_wait_time);
		if (!timerisset(&tMsgCtl.get_msg_time_out) ||
		    timercmp(&tMsgCtl.get_msg_time_out,&tmtime,>)) {
			akxe_timer_add_msec(&tMsgCtl.get_msg_time_out,&tmtime,-5);
		}
	}

DEBUGOUTL5(AKA_LOG_GROUP|200,
"aka_get_msg: iWaitTime=%d tmtime=%d:%d tGetMsgTimeOut=%d:%d",
iWaitTime,tmtime.tv_sec,tmtime.tv_usec,tMsgCtl.get_msg_time_out.tv_sec,
tMsgCtl.get_msg_time_out.tv_usec);

	for (;;) {
		/**************************************************************
		 * PacketRead,PacketWriteȂƂP͎sĂ
		 * {֐烊^[鎞𔻒肵ĂǂAłȂ
		 * ȂŃ^[ꍇ
		 *************************************************************/
		if (iWaitTime>=0 && tMsgCtl.rsv1) {
			if ((lmtime=aka_get_msec(&tmtime))<0) return -18505002;

DEBUGOUTL4(AKA_LOG_GROUP|210,
"aka_get_msg: tmtime=%d:%d tGetMsgTimeOut=%d:%d",
tmtime.tv_sec,tmtime.tv_usec,tMsgCtl.get_msg_time_out.tv_sec,
tMsgCtl.get_msg_time_out.tv_usec);

		    if (!timercmp(&tMsgCtl.get_msg_time_out,&tmtime,>)) {
				timerclear(&tMsgCtl.get_msg_time_out);
				tMsgCtl.rsv1 = 0;
				break;
			}
			/* ҂ԍĐݒ */
			tMsgCtl.get_msg_wait_time = akxe_timer_sub(NULL,
				&tMsgCtl.get_msg_time_out,&tmtime);

DEBUGOUTL1(AKA_LOG_GROUP|210,
"aka_get_msg: iGetMsgWaitTime=%d",tMsgCtl.get_msg_wait_time);

		}
		/****************
		 * ^C}[ *
		 ****************/
		aka_timer_proc();
		/**********************
		 * pPbgv *
		 **********************/
		tMsgCtl.rsv1 = 1;
		if ((iRcW=aka_put_msg(0,akbPacketWrite))<0) {
			iRc = iRcW;
			break;
		}
		/*************************
		 * RWQueTimer̊Jn/~ *
		 *************************/
		aka_rwque_timer_ctl();
		/**************************************
		 * ԐM҂pPbg̃^CAEg *
		 **************************************/
		wait_msg_time_out();
		/****************
		 * ҂Ԑݒ *
		 ****************/
		iMinWaitTime = aka_get_min_wait_time(tMsgCtl.get_msg_wait_time);
		if (iShutMode && iMinWaitTime<0) iMinWaitTime = 0;
		/**********************
		 * pPbgq   *
		 **********************/
		tMsgCtl.rsv1 = 2;
		if (tMsgCtl.channel_akb_used && tMsgCtl.channel_used>tMsgCtl.channel_akb_used) {
			iWait = 0;
		}
		else iWait = iMinWaitTime;

DEBUGOUTL2(AKA_LOG_GROUP|210,
"aka_get_msg: iMinWaitTime=%d akbPacketRead(iWait=%d)",iMinWaitTime,iWait);

		if ((iRcR=akbPacketRead(iWait))<0) {

DEBUGOUTL1(AKA_LOG_GROUP|210,
"aka_get_msg: akbPacketRead() ret=%d",iRcR);

			iRc = iRcR;
			break;
		}
		else {
			if (tMsgCtl.channel_akb_used && tMsgCtl.channel_used>tMsgCtl.channel_akb_used) {
				if (iRcR) iMinWaitTime = 0;
				if ((iRcR=aka_packet_read(iMinWaitTime)) < 0) {

DEBUGOUTL1(AKA_LOG_GROUP|210,
"aka_get_msg: aka_packet_read() ret=%d",iRcR);

					iRc = iRcR;
					break;
				}
			}
			if (akxs_rb_get(tMsgCtl.rb_rctl)) iRcR = 1;
		}
		aka_rwque_remain(1);

		tMsgCtl.rsv1 = 3;
/* 2005.6.13 Koba
		if (iRcW == 0) {
*/
			if (iRcR) {
				iRc = iRcR;
				break;
			}
			else if (iShutMode == 2) {
				iRc = AKB_CMD_FSHUT;
				break;
			}
			else if (iShutMode == 1) {
				iRc = AKB_CMD_SHUT;
				break;
			}
/* 2005.6.13 Koba
		}
*/
	}
	if (iRc == D_ERR_READ_SOCKET ||
	    iRc == D_ERR_PROM_READ    ) aka_set_connect_sd(-1);

DEBUGOUTL1(AKA_LOG_GROUP|200,"aka_get_msg: Exit iRc=%d",iRc);

	return iRc;
}

/*******************************************
 *
 *******************************************/
int aka_put_msg(iRetry,akbPacketWrite)
int  iRetry;
int (*akbPacketWrite)();
{
	int i = iRetry,iRc = 0;

	for (;;) {
		if ((iRc=akbPacketWrite()) < 0) break;
		if (tMsgCtl.channel_akb_used && tMsgCtl.channel_akb_used<tMsgCtl.channel_max) {
			if ((iRc=aka_packet_write()) < 0) break;
		}
		aka_rwque_remain(2);
		if (akxs_rb_get(tMsgCtl.rb_wctl) || iRc) iRc = 1;
		else if (tMsgCtl.rwqtime_out) {
			if (tMsgCtl.rwqtime_out->rwt_wqto.qto_qrem) iRc = 1;
		}
		if (!iRc) break;
		else if (iRetry >= 0) {
			if (i-- <= 0) break;
		}
		aka_timer_proc();
		sleep(1);
	}
	return iRc;
}

#include "akaclass.c"
#define AKAS_INCLUDE
#include "akacomm.c"
