/*static    char    sccsid[]="%Z% %M% %I% %E% %U%";*/
/*************************************************
 *
 *  akacomm.c (include file)
 *
 *        coded by A.Kobayashi 2003.3.12
 *
 *************************************************/
#ifndef AKAS_INCLUDE
#include "akacommon.h"

extern tdtMSG_CTL tMsgCtl;
#endif
/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_msec(ptval)
struct timeval *ptval;
{
	return akxe_get_msec(tMsgCtl.timer_ctl,ptval);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_register_timer(cpTimerName,pFuncName,iWaitTime,cpParm)
char *cpTimerName ; /* ^C}[ */
int (*pFuncName)(); /* ^CAEgĂяo֐ւ̃|C^ */
int  iWaitTime    ; /* ^CAEg(msec) */
char *cpParm      ; /* ֐Ăяõp[^ */
{
	int id;

	if (tMsgCtl.sd<0) return -1;
	id = akxe_register_timer(tMsgCtl.timer_ctl,cpTimerName,pFuncName,
	                       iWaitTime,cpParm);

DEBUGOUT3("aka_register_timer: TimerName=[%s] WaitTime=%d TimerId=%d",
cpTimerName,iWaitTime,id);

	return id;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cancel_timer(iTimerId)
int  iTimerId     ; /* ^C}[ʔԍ */
{
	int ret;

	if (tMsgCtl.sd<0) return -1;
	ret = akxe_cancel_timer(tMsgCtl.timer_ctl,iTimerId);

DEBUGOUT2("aka_cancel_timer: TimerId=%d ret=%d",iTimerId,ret);

	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_timer_proc()
{
	if (tMsgCtl.sd<0) return -1;
	return akxe_proc_timer(tMsgCtl.timer_ctl);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_wake_up_timer(opt,obj,event)
int  opt;
char *obj;
int  event;
{
	if (tMsgCtl.sd<0) return -1;
	return akxe_wake_up_timer(tMsgCtl.timer_ctl,opt,obj,event);
}

/********************************************************/
/*                                                      */
/********************************************************/
static void _debug_out_timer_obj(func,opt,obj)
char *func;
int  opt;
char *obj;
{
#ifdef DEBUGOUT_ON
	if (DEBUGOUTCHECK(AKA_LOG_GROUP|250)) {
		if (!opt) DEBUGOUT1("%s: All",func);
		else if (opt==1) DEBUGOUT2("%s: TimerId=%d",func,*(int *)obj);
		else DEBUGOUT2("%s: TimerName=[%s]",func,obj);
	}
#endif
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_start_timer(opt,obj)
int  opt;
char *obj;
{
	if (tMsgCtl.sd<0) return -1;
#ifdef DEBUGOUT_ON
	_debug_out_timer_obj("aka_start_timer",opt,obj);
#endif
	return akxe_start_timer(tMsgCtl.timer_ctl,opt,obj);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_stop_timer(opt,obj)
int  opt;
char *obj;
{
	if (tMsgCtl.sd<0) return -1;
#ifdef DEBUGOUT_ON
	_debug_out_timer_obj("aka_stop_timer",opt,obj);
#endif
	return akxe_stop_timer(tMsgCtl.timer_ctl,opt,obj);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_timer_min_wait()
{
	if (tMsgCtl.sd<0) return -1;
/*
	if (tMsgCtl.timer_ctl->th_minwait > 0) akxe_min_wait_timer(tMsgCtl.timer_ctl);
*/
DEBUGOUTL1(AKA_LOG_GROUP|250,
"aka_timer_min_wait: iMinWait = %d",tMsgCtl.timer_ctl->th_minwait);
	return tMsgCtl.timer_ctl->th_minwait;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_my_apsys_id()
{
	if (tMsgCtl.sd < 0) return -1;
	return (int)tMsgCtl.apsys_id;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_min_wait_time(iWaitTime)
int iWaitTime;
{
	struct timeval tmtime, tmset;
	int iMinWaitTime,iTimerMinWait;
	int i,iTime[3];

	iTime[0] = iWaitTime;
	iTime[1] = tMsgCtl.send_msg_min_wait;
	iTime[2] = aka_timer_min_wait();
DEBUGOUTL3(AKA_LOG_GROUP|255,
"aka_get_min_wait_time:WaitTime=%d SendWait=%d TimerWait=%d",
iTime[0],iTime[1],iTime[2]);

	iMinWaitTime = -1;
	for (i=0;i<3;i++) {
		if ((iMinWaitTime < 0) ||
		    (iMinWaitTime >= 0 && iTime[i] >= 0 &&
		     iTime[i] < iMinWaitTime)) {
			if (!(iMinWaitTime = iTime[i])) break;
		}
	}

	return iMinWaitTime;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _rwque_time_out_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int iRc;

	if (!(iRc = akb_rwqttimer(iTimerId, cpTimerName, cpParm, tptime))) {
		aka_stop_timer(1,&iTimerId);
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtRWQ_TIME_OUT *aka_rwque_time_out_new(iQueMax,parm /* ,_rwque_time_out_timer */)
int iQueMax,parm[];
/* int (*_rwque_time_out_timer)(); */
{
    tdtRWQ_TIME_OUT *p;

/*	if (!_rwque_time_out_timer) return NULL;	*/
	if (p = akb_rwque_time_out_new(iQueMax,parm)) {
		if (p->rwt_qint > 0) {
			p->rwt_qtid =
				aka_register_timer("RWQueTimeOut",_rwque_time_out_timer,
				                 p->rwt_qint*1000,p);
			if (p->rwt_qtid > 0) {
				aka_stop_timer(1,&p->rwt_qtid);
			}
			else {
				akb_rwque_time_out_free(p);
				p = NULL;
			}
		}
	}
	return p;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_rwqtset_parm(parm)
int parm[];
{
	if (!tMsgCtl.rwqtime_out) return 0;
	return akb_rwqtset_parm(tMsgCtl.rwqtime_out,parm);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_update_qremain_flg()
{
	if (!tMsgCtl.rwqtime_out) return 0;
	return akb_rwqtupdate_qremain_flg(tMsgCtl.rwqtime_out);
}

/********************************************************/
/*		RWQueTimer̊Jn/~							*/
/********************************************************/
int aka_rwque_timer_ctl()
{
	int id;

	if (tMsgCtl.rwqtime_out) {
		if ((id=tMsgCtl.rwqtime_out->rwt_qtid)>0 &&
		     aka_update_qremain_flg()) {
			if (tMsgCtl.rwqtime_out->rwt_rflg[0])
				aka_start_timer(1,&id);
			else
				aka_stop_timer(1,&id);
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_rwque_remain(iRW)
int iRW;
{
	if (!tMsgCtl.rwqtime_out) return 0;
	return akb_rwqtremain(tMsgCtl.rwqtime_out,iRW);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_rwque_get_akb_time_out(parm)
int parm[];
{
	return akb_rwque_get_akb_time_out(akb_log_get_proc_name(),parm);
}

/********************************************************/
/*                                                      */
/********************************************************/
int  aka_shut_control(iAttribute,cpValue)
int iAttribute;
char *cpValue;
{
	char c;
	int ret = 0;

	if (tMsgCtl.sd<0) return -18502801;
	if (iAttribute != AKA_SHUT_GET) {
		if (!cpValue) return -18502804;
		c = *cpValue;
	}
	switch (iAttribute) {
	case AKA_SHUT_MODE:
			if (c == 0x00) tMsgCtl.shut_mode = 0;
			else if (c & AKA_SHUT_MODE_SHUT)
				tMsgCtl.shut_mode |= AKA_SHUT_MODE_SHUT;
			else if (c & AKA_SHUT_MODE_FSHUT)
				tMsgCtl.shut_mode |= AKA_SHUT_MODE_FSHUT;
			else ret = -18502803;
			break;
	case AKA_SHUT_SUSPEND:
			if (c == 0x00) tMsgCtl.shut_suspend = 0;
			else if (c == AKA_SHUT_SUSPEND_SET) tMsgCtl.shut_suspend = 1;
			else ret = -18502803;
			break;
	case AKA_SHUT_GET:
			if (cpValue) {
				*cpValue++ = tMsgCtl.shut_mode;
				*cpValue   = tMsgCtl.shut_suspend;
			}
			ret = tMsgCtl.shut_mode & AKA_SHUT_MODE_FSHUT;
			if (!ret && !tMsgCtl.shut_suspend &&
			    (tMsgCtl.shut_mode & AKA_SHUT_MODE_SHUT))
				ret = tMsgCtl.shut_mode & AKA_SHUT_MODE_SHUT;
			break;
	default:
			ret = -18502802;
	}
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
static char *gcpVerDate[2]={AKX_NULL_PRINT,AKX_NULL_PRINT};
static int   giVerDateLen[2]={0,0};

static int _getverdate(p,pd)
char *p,**pd;
{
	int i;

	*pd = p;
	i = strlen(p);
	while (*p && *p!='[') p++;
	if (*p) {
		*pd = ++p;
		i = 0;
		while (*p && *p!=']') {
			p++;
			i++;
		}
	}
	return i;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_ver_date(ver,date)
char *ver,*date;
{
	static char *cpVersion=NULL;
	static char *cpMakeDate=NULL;

	if (ver)  {
		if (!(cpVersion  = Strdup(ver))) return -1;
		giVerDateLen[0] = _getverdate(cpVersion,&gcpVerDate[0]);
		*(gcpVerDate[0]+giVerDateLen[0]) = '\0';
	}
	if (date) {
		if (!(cpMakeDate = Strdup(date))) return -2;
		giVerDateLen[1] = _getverdate(cpMakeDate,&gcpVerDate[1]);
		*(gcpVerDate[1]+giVerDateLen[1]) = '\0';
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_ver_date(cpVerDate,iVerDateLen)
char *cpVerDate[];
int   iVerDateLen[];
{
	if (cpVerDate) {
		cpVerDate[0] = gcpVerDate[0];
		cpVerDate[1] = gcpVerDate[1];
	}
	if (iVerDateLen) {
#if 0
		iVerDateLen[0] = giVerDateLen[0];
		iVerDateLen[1] = giVerDateLen[1];
#else
		iVerDateLen[0] = strlen(gcpVerDate[0]);
		iVerDateLen[1] = strlen(gcpVerDate[1]);
#endif
	}
	return 0;
}
/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_msg_time_out(iTimeOut)
int  iTimeOut     ;	/* ^CAEgԁi~bj */
{
	if (tMsgCtl.sd<0) return -18506601;
	if (iTimeOut>=0) {
		tMsgCtl.send_msg_time_out = iTimeOut;
	}
	return tMsgCtl.send_msg_time_out;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_up_msg_time_out(cpProcName)
char *cpProcName;
{
	char *argv[2],*namv[3];
	int n,w;

	if (tMsgCtl.sd<0) return -18506601;

	namv[0] = D_SECTION_AKB_SYSTEM;
	namv[1] = D_KEYNAME_MSG_TIMEOUT;
	namv[2] = cpProcName;
	n = akb_gs_akb_stpl_func(namv,'.',"4 2 3 1 ",argv,2,NULL,NULL);
	if (n >= 2) {
		w = atoi(argv[1]);
/*
printf("aka_set_up_msg_time_out: msg_timeout=%d\n",w);
*/
		aka_set_msg_time_out(w*1000);
	}
	return n;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_msec_l(ptval)
struct timeval *ptval;
{
	return akxe_get_msec_l(tMsgCtl.timer_ctl,ptval);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cha_rb_regist_timer(iTimerId)
int  iTimerId;
{
	return akb_cha_rb_regist_timer(tMsgCtl.timer_ctl,iTimerId);
}
