	#include <assert.h>
	#include "hfl.h"	//*SH_co*	*
	#include "hcut.h"
	#include "msgp.h"
	#include "laptime.h"
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__
HCUT_ADD(t_new) {
	laptime(0);
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	laptime();
	
	eq_i(obj->cnt, 0);
	eq_i(obj->mcnt, 31);
	eq(obj->lcnt!=0);
	eq(obj->arr!=NULL);
	eq(obj->enode, "init new test");	//enode はセンチネルとして追加、単独番兵
//add nodelist
	eq_p(obj->enode->next, obj->enode->pre);

//clean test
	hfl_free(obj);
	eq_i(obj->cnt, 0);
	eq_i(obj->mcnt, 0);
	eq_i(obj->lcnt, 0);
	eq_p(obj->arr, NULL);
	eq_p(obj->enode, NULL);
}
HCUT_ADD(t_set) {
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	
	hfl_nt* rp;
	rp =  hfl_set_i(obj, "unko", 10);
	eq_s(rp->key, "unko");
	eq_i(rp->i, 10);
	eq_i(obj->cnt, 1);
	
	rp =  hfl_set_i(obj, "1", 1);
	eq_s(rp->key, "1");
	eq_i(rp->i, 1);
	eq_i(obj->cnt, 2);

	hfl_set_i(obj, "ii", 10);
	hfl_set_d(obj, "dd", 1);
	hfl_set_s(obj, "ss", "hw");
	hfl_set_p(obj, "pp", "gw");
	eq_i(obj->cnt, 6);
	
	typedef struct my_tag{
		int a;
		int b;
	} my_t;
	
	my_t v = {10,20};
	rp = hfl_set_s(obj, "mem", &v, sizeof(v) );
	eq_i(rp->tp, 's');
	void* p = rp->s;
	int n = ((my_t*)p)->a;
	eq_i(n, 10);
	
	double d = 11.1;
	rp = hfl_set_s(obj, "k3", &d, sizeof(double) );
	d = *(double*)(rp->s);
	eq_d(d, 11.1);

	hfl_free(obj);
}
HCUT_ADD(t_unset) {
	hfl_t* obj = hfl_new();
	eq_i(obj->mcnt, 31);
	hfl_nt* p;
	p =  hfl_set_i(obj, "unko", 10);
	eq_s(p->key, "unko");
	eq_i(p->i, 10);
	eq_i(obj->cnt, 1);

	p =  hfl_set_i(obj, "1", 1);
	eq_s(p->key, "1");
	eq_i(p->i, 1);
	eq_i(obj->cnt, 2);

	p = hfl_unset(obj, "1");
	eq(p);
	eq_i(obj->cnt, 1);
	
	p = hfl_find(obj, "unko");
	eq_s(p->key, "unko");
	eq_i(p->i, 10);
	eq_i(obj->cnt, 1);
	
	p =  hfl_set_i(obj, "unko", 11);
	eq_s(p->key, "unko");
	eq_i(p->i, 11);
	eq_i(obj->cnt, 1);

	p = hfl_unset(obj, "unk");
	eq_p(p, NULL);
	eq_i(obj->cnt, 1);

	hfl_free(obj);
}
HCUT_ADD(t_find) {
	hfl_t* obj = hfl_new();
	hfl_nt* p;
	eq_i(obj->mcnt, 31);
	
	int rc=0;
	eq_i(rc, 0);
	hfl_set_i(obj, "ii", 10);
	p = hfl_set_d(obj, "dd", 1.0);
	
	eq_s(p->key, "dd");
	
	hfl_set_s(obj, "ss", "hw");
	hfl_set_p(obj, "pp", "gw");
	eq_i(obj->cnt, 4);
	
	hfl_nt* u = hfl_find(obj, "ii");
	eq_s(u->key, "ii");
	eq_i(u->i, 10);
	eq_d(u->d, 0);
	eq_p(u->s, NULL);

	u = hfl_find(obj, "dd");
	eq_s(u->key, "dd");
	eq_i(u->i, 0);
	eq_d(u->d, 1);
	eq_p(u->s, NULL);

	u = hfl_find(obj, "ss");
	eq_s(u->key, "ss");
	eq_i(u->i, 0);
	eq_d(u->d, 0);
	eq_s(u->s, "hw");

	u = hfl_find(obj, "pp");
	eq_s(u->key, "pp");
	eq_i(u->i, 0);
	eq_d(u->d, 0);
	eq_p(u->s, NULL);
	eq_s(u->p, "gw");
	
	hfl_free(obj);
}
HCUT_ADD(t_use) {
	hfl_t* obj = hfl_new();
	hfl_nt* rp = hfl_find(obj, "unko");
	eq_p(rp, NULL);
	
	rp = hfl_set_i(obj, "unko", 10);
	eq_i(rp->i, 10);
	eq_i(obj->cnt, 1);
	
	rp = hfl_unset(obj, "unko");
	eq(rp!=NULL);
	eq_i(obj->cnt, 0);
	
	rp = hfl_set_s(obj, "unko", "str");

	eq_i(rp->tp, 's');
	eq_s(rp->key, "unko");
	eq_s(rp->s, "str");
	eq_i(obj->cnt, 1);
	
	rp = hfl_set_i(obj, "unko", 22);
	eq_i(rp->tp, 'i');
	eq_s(rp->key, "unko");
	eq_i(rp->i, 22);
	eq_i(obj->cnt, 1);
	
	rp = hfl_set_i(obj, "unk", 12);
	eq_i(rp->tp, 'i');
	eq_s(rp->key, "unk");
	eq_i(rp->i, 12);
	eq_i(obj->cnt, 2);
	
	rp = hfl_unset(obj, "kk");
	eq(rp==NULL);
	eq_i(obj->cnt, 2);
	
	hfl_free(obj);
}
#ifndef TLV
# define TLV	1
#endif /**/
HCUT_RUN("stderr", TLV,
 t_new, t_set, t_unset, t_find, t_use, NULL)
